% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_afeye.R
\name{derive_var_afeye}
\alias{derive_var_afeye}
\title{Derive Affected Eye}
\usage{
derive_var_afeye(dataset_occ, loc_var, lat_var)
}
\arguments{
\item{dataset_occ}{Input Occurence dataset}

\item{loc_var}{Location variable}

\item{lat_var}{Laterality variable}
}
\value{
The input occurrence dataset with Affected Eye (AFEYE) added.
}
\description{
Derive Affected Eye (\code{AFEYE}) in occurrence datasets
}
\details{
Affected Eye is derived in the occurrence dataset using laterality and Study
Eye. This assumes Study Eye has already been added from ADSL.
}
\examples{
library(tibble)
library(admiral)

adae <- tribble(
  ~STUDYID, ~USUBJID, ~STUDYEYE, ~AELOC, ~AELAT,
  "XXX001", "P01", "RIGHT", "EYE", "RIGHT",
  "XXX001", "P01", "RIGHT", "EYE", "LEFT",
  "XXX001", "P02", "LEFT", "", "",
  "XXX001", "P02", "LEFT", "EYE", "LEFT",
  "XXX001", "P04", "BILATERAL", "EYE", "RIGHT",
  "XXX001", "P05", "RIGHT", "EYE", "RIGHT"
)

derive_var_afeye(adae, AELOC, AELAT)
}
\author{
Lucy Palmen
}
\keyword{der_occds}
