% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBM_theoretical_gap.R
\name{IBM_theoretical_gap}
\alias{IBM_theoretical_gap}
\title{Difference between unknown cumulative distribution functions of admixture models at some given point}
\usage{
IBM_theoretical_gap(z, par, known.p = c(0.5, 0.5), comp.dist, comp.param)
}
\arguments{
\item{z}{Point at which the difference between the unknown component distributions of the two considered admixture models is computed.}

\item{par}{Numeric vector with two elements, corresponding to the two parameter values at which to compute the gap. In practice
the component weights for the two admixture models.}

\item{known.p}{Numeric vector with two elements, the known (true) mixture weights.}

\item{comp.dist}{A list with four elements corresponding to the component distributions (specified with R native names for these distributions)
involved in the two admixture models. The two first elements refer to the unknown and known components of the 1st admixture model,
and the last two ones to those of the second admixture model. No unknown elements permitted.
For instance, 'comp.dist' could be specified as follows: list(f1='rnorm', g1='norm', f2='rnorm', g2='norm').}

\item{comp.param}{A list with four elements corresponding to the parameters of the component distributions, each element being a list
itself. The names used in this list must correspond to the native R argument names for these distributions.
The two first elements refer to the parameters of unknown and known components of the 1st admixture model, and the last
two ones to those of the second admixture model. No unknown elements permitted. For instance, 'comp.param' could be specified
as follows: : list(f1 = list(mean=2,sd=0.3), g1 = list(mean=0,sd=1), f2 = list(mean=2,sd=0.3), g2 = list(mean=3,sd=1.1)).}
}
\value{
The gap between F1 and F2 (unknown components of the two admixture models), evaluated at the specified point.
}
\description{
Compute the gap between the unknown cumulative distribution functions of the two considered admixture models at some given point,
where each admixture model has probability distribution function (pdf) given by l where l = p*f + (1-p)*g.
Uses the inversion method to do so, i.e. f = (1/p) (l - (1-p)g), where g represents the known component of the admixture
model and p is the proportion of the unknown component. This difference must be integrated over some domain to compute the
global discrepancy, as introduced in the paper presenting the IBM approach (see 'Details' below).
}
\details{
See the paper presenting the IBM approach at the following HAL weblink: https://hal.science/hal-03201760
}
\examples{
list.comp <- list(f1 = 'norm', g1 = 'norm',
                  f2 = 'norm', g2 = 'norm')
list.param <- list(f1 = list(mean = 3, sd = 0.5), g1 = list(mean = 0, sd = 1),
                   f2 = list(mean = 1, sd = 0.1), g2 = list(mean = 5, sd = 2))
IBM_theoretical_gap(z = 2.8, par = c(0.3,0.6), known.p = c(0.5,0.5),
                    comp.dist = list.comp, comp.param = list.param)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
