% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_cluster.R
\name{admix_cluster}
\alias{admix_cluster}
\title{Cluster K populations following admixture models}
\usage{
admix_cluster(
  samples,
  admixMod,
  conf_level = 0.95,
  tune_penalty = TRUE,
  tabul_dist = NULL,
  echo = TRUE,
  ...
)
}
\arguments{
\item{samples}{A list of the K (K>1) samples to be studied, all following admixture distributions.}

\item{admixMod}{A list of objects of class \link[admix]{admix_model}, containing useful information about distributions and parameters.}

\item{conf_level}{(default to 0.95) The confidence level of the k-sample tests used in the clustering procedure.}

\item{tune_penalty}{(default to TRUE) A boolean that allows to choose between a classical penalty term or an optimized penalty (embedding
some tuning parameters, automatically optimized). Optimized penalty is particularly useful for low/mid-sized samples,
or unbalanced sample sizes to detect alternatives to the null hypothesis (H0). It is recommended to use it.}

\item{tabul_dist}{(default to NULL) Only useful for comparisons of detected clusters at different confidence levels. A list of
the tabulated distributions of the stochastic integral used in the k-sample test, each element for each
cluster previously detected.}

\item{echo}{(default to TRUE) Display the remaining computation time.}

\item{...}{Optional arguments to \link[admix]{IBM_k_samples_test}; namely 'n_sim_tab', 'parallel' and 'n_cpu'. These are crucial
to speed-up the building of clusters.}
}
\value{
An object of class \link[admix]{admix_cluster}, containing 12 attributes: 1) the number of samples under study; 2) the sizes of samples;
3) the information about mixture components in each sample (distributions and parameters); 4) the number of detected clusters;
5) the list of p-values for each k-sample test at the origin of detected clusters; 6) the cluster affiliation for each sample;
7) the confidence level of statistical tests; 8) which samples in which cluster; 9) the size of clusters; 10) the estimated
weights of the unknown component distributions inside each cluster (remind that estimated weights are consistent only if
unknown components are tested to be identical, which is the case inside clusters); 11) the matrix of pairwise discrepancies
across all samples; 12) the list of tabulated distributions used for statistical tests involved in building the clusters.
}
\description{
Create clusters on the unknown components related to the K populations following admixture models. Based on the K-sample test
using Inversion - Best Matching (IBM) approach, see 'Details' below for further information.
}
\examples{
\donttest{
## Simulate mixture data:
mixt1 <- twoComp_mixt(n = 2600, weight = 0.8,
                      comp.dist = list("gamma", "exp"),
                      comp.param = list(list("shape" = 16, "scale" = 1/4),
                                        list("rate" = 1/3.5)))
mixt2 <- twoComp_mixt(n = 3000, weight = 0.7,
                      comp.dist = list("gamma", "exp"),
                      comp.param = list(list("shape" = 14, "scale" = 1/2),
                                        list("rate" = 1/5)))
mixt3 <- twoComp_mixt(n = 3500, weight = 0.6,
                      comp.dist = list("gamma", "gamma"),
                      comp.param = list(list("shape" = 16, "scale" = 1/4),
                                        list("shape" = 12, "scale" = 1/2)))
mixt4 <- twoComp_mixt(n = 4800, weight = 0.5,
                      comp.dist = list("gamma", "exp"),
                      comp.param = list(list("shape" = 14, "scale" = 1/2),
                                        list("rate" = 1/7)))
data1 <- getmixtData(mixt1)
data2 <- getmixtData(mixt2)
data3 <- getmixtData(mixt3)
data4 <- getmixtData(mixt4)
## Define the admixture models:
admixMod1 <- admix_model(knownComp_dist = mixt1$comp.dist[[2]],
                         knownComp_param = mixt1$comp.param[[2]])
admixMod2 <- admix_model(knownComp_dist = mixt2$comp.dist[[2]],
                         knownComp_param = mixt2$comp.param[[2]])
admixMod3 <- admix_model(knownComp_dist = mixt3$comp.dist[[2]],
                         knownComp_param = mixt3$comp.param[[2]])
admixMod4 <- admix_model(knownComp_dist = mixt4$comp.dist[[2]],
                         knownComp_param = mixt4$comp.param[[2]])
## Clustering procedure:
admix_cluster(samples = list(data1, data2, data3, data4),
              admixMod = list(admixMod1, admixMod2, admixMod3, admixMod4),
              conf_level = 0.95, tune_penalty = TRUE, n_sim_tab = 30)
}

}
\references{
\insertRef{MilhaudPommeretSalhiVandekerkhove2024b}{admix}
}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
