% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adw.R
\name{adw_vector}
\alias{adw_vector}
\title{Angular Distance Weighting Interpolation, adw_vector.}
\usage{
adw_vector(ds, extent, gridsize = 5, cdd = 1000, m = 4, nmin = 3, nmax = 10)
}
\arguments{
\item{ds}{a input dataframe which contains the column names of lon, lat, value.}

\item{extent}{a extent numeric vector of length 4 in the order c(xmin, xmax, ymin, ymax).}

\item{gridsize}{the grid size, i.e. the grid resolution. units: degree.}

\item{cdd}{correlation decay distance, i.e. the maximum search radius.
unit: kilometer. default value: 1000km.}

\item{m}{is used to adjust the weighting function further, higher values of m
increase the rate at which the weight decays with distance. default value 4.}

\item{nmin}{the minimum number of observation points required to interpolate
a grid within the search radius (i.e. cdd); if the number of stations within
the search ridius (cdd) is less than nmin, a missing value will be generated
to fill this grid. default value 3.}

\item{nmax}{The number of nearest points within the search radius to use for
interpolation. default value 10.}
}
\value{
a regular latitude-longitude dataframe grid (interpoled values).
}
\description{
The irregularly-spaced data are interpolated onto regular latitude-longitude
grids by weighting each station according to its distance and angle from the
center of a search radius.
}
\examples{
set.seed(2)
dd <- data.frame(lon = runif(100, min = 110, max = 117),
                 lat = runif(100, min = 31, max = 37),
                 value = runif(100, min = -10, max = 10))
head(dd)
# example
grd <- adw(dd, extent = c(110, 117, 31, 37), gridsize = 0.5, cdd = 500)
head(grd)
}
\references{
Caesar, J., L. Alexander, and R. Vose, 2006: Large-scale changes in observed daily maximum and minimum temperatures: Creation and analysis of a new gridded data set. Journal of Geophysical Research, 111, https://doi.org/10.1029/2005JD006280.
}
