% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{list_series}
\alias{list_series}
\title{List created series}
\usage{
list_series(theme_id = NULL, theme_title = NULL)
}
\arguments{
\item{theme_id, theme_title}{Optional parameters that can be used individually
or combined to filter the selected themes.}
}
\value{
A data.frame
}
\description{
List all series from the Atlas, regardless of whether they have data
available for download or not.
}
\examples{
\dontshow{if (aebdata:::test_connection_aeb("temas")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
series <- list_series(theme_id = c(42, 50))
series$series_title
\donttest{
# List all series and count the number of series available
all_series <- list_series()
length(unique(all_series$series_id))

# Count the number of series from Organizações do Estado theme
organizacoes <- list_series(theme_title = "Organizações do Estado")
nrow(organizacoes)
}
\dontshow{\}) # examplesIf}
}
