#' Parse checkmate assertions for testthat compatibility
#' @description
#'   The error messages generated by `checkmate` are formatted to look nicely in the console by the
#'   addition of `*` and `\n` characters.
#'
#'   This means that checking these errors with `testthat::expect_error()` will often fail or will be harder to read
#'   in the test since we need to manually insert `*` and `\n` to the comparison pattern to match the error message.
#'
#'   This helper function intercepts the `checkmate` error message and removes the `*` and `\n` characters to allow for
#'   human readable error checking.
#' @return
#'   The checkmate error without `*` and `\n` characters.
#' @noRd
checkmate_err_msg <- function(expr) {
  tryCatch(
    expr,
    error = \(e) {
      e$message |>
        stringr::str_remove_all(stringr::fixed("\n *")) |>
        stringr::str_remove_all(stringr::fixed("* ")) |>
        simpleError(message = _) |>
        stop()
    }
  )
}
