\name{afc.mc}
\alias{afc.mc}
\title{ 2AFC For Ordinal Polychotomous Observations And Continuous
  Forecasts }
\description{
 Routine to calculate the Generalized Discrimination Score (aka
 Two-Alternatives Forced Choice Score 2AFC) for the situation of
 polychotomous observations (ordinal) and continuous forecasts
}
\usage{
afc.mc(obsv, fcst, m = 3)
}
\arguments{
  \item{obsv}{  vector with polychotomous observations (values in
  \{1,..,m\}) }
  \item{fcst}{ vector of same length as \emph{obsv} with real-valued
  forecasts }
  \item{m}{ number of observation categories (default = 3) } 
}
\details{
  This routine applies Eq.18 of Mason and Weigel (2009) to calculate the 2AFC.
}
\value{
  \item{ p.afc }{ Value of Generalized Discrimination (2AFC) Score }
}
\references{ S.J. Mason and A.P. Weigel, 2009. A generic verification
  framework for administrative purposes. Mon. Wea. Rev., 137, 331-349 }
\author{ Andreas Weigel, Federal Office of Meteorology and Climatology,
  MeteoSwiss, Zurich, Switzerland }
\seealso{ \code{\link{afc}} }
\examples{
  #Forecasts and observations of Nino-3.4 index
  #Load set of polychotomous observations (4 categories) and continuous forecasts
  data(cnrm.nino34.mc)
  obsv = cnrm.nino34.mc$obsv
  fcst = cnrm.nino34.mc$fcst

  #Calculate skill score
  afc.mc(obsv,fcst,4)
}
\keyword{ file }% at least one, from doc/KEYWORDS
