% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.r
\name{normal3d}
\alias{normal3d}
\alias{normal3d.Coord3D}
\alias{normal3d.character}
\alias{normal3d.Plane3D}
\title{3D normal vectors}
\usage{
normal3d(x, ...)

\method{normal3d}{Coord3D}(x, cross, ..., normalize = TRUE)

\method{normal3d}{character}(x, ..., normalize = TRUE)

\method{normal3d}{Plane3D}(x, ..., normalize = TRUE)
}
\arguments{
\item{x}{Object to compute a 3D normal vector for
such as a \link{Plane3D} object}

\item{...}{Passed to other methods such as \code{\link[=as_coord3d]{as_coord3d()}}.}

\item{cross}{A \link{Coord3D} vector.
We'll compute the normal of \code{x} and \code{cross} by taking their cross product.}

\item{normalize}{If \code{TRUE} normalize to a unit vector}
}
\value{
A \link{Coord3D} (normal) vector
}
\description{
\code{normal3d()} is an S3 generic that computes a 3D normal vector.
}
\examples{
normal3d("xy-plane")
normal3d(as_coord3d(2, 0, 0), cross = as_coord3d(0, 2, 0))
}
