% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afttest.R
\name{afttest}
\alias{afttest}
\title{afttest}
\usage{
afttest(
  formula,
  data,
  path = 200,
  testType = "omni",
  eqType = "mns",
  optimType = "DFSANE",
  form = 1,
  pathsave = 50
)
}
\arguments{
\item{formula}{A formula expression, of the form \code{response ~ predictors}.
The \code{response} is a \code{Surv} object object with right censoring.
See the documentation of \code{lm}, \code{coxph} and \code{formula} for details.}

\item{data}{An optional data frame in which to interpret the variables occurring 
in the formula.}

\item{path}{An integer value specifies the number of approximated processes.
The default is given by 200.}

\item{testType}{A character string specifying the type of the test.
   The following are permitted:
   \describe{
     \item{\code{omni}}{an omnibus test}
     \item{\code{link}}{a link function test}
     \item{\code{form}}{a functional form}
}}

\item{eqType}{A character string specifying the type of the 
   estimating equation used to obtain the regression parameters.
   The readers are refered to the \pkg{aftgee} package for details.
   The following are permitted:
   \describe{
     \item{\code{mns}}{Regression parameters are estimated by iterating 
     the monotonic non-smoothed Gehan-based estimating equations.}
     \item{\code{mis}}{Regression parameters are estimated by iterating 
     the monotonic smoothed Gehan-based estimating equations.}
}}

\item{optimType}{A character string specifying the type of the optimization method.
   The following are permitted:
   \describe{
     \item{\code{DFSANE}}{See the documentation of \pkg{BB} packages for details.}
     \item{\code{Nelder-Mead}}{See the documentation of \code{optim} for details.}
     \item{\code{BFGS}}{See the documentation of \code{optim} for details.}
     \item{\code{CG}}{See the documentation of \code{optim} for details.}
     \item{\code{L-BFGS-B}}{See the documentation of \code{optim} for details.}
     \item{\code{SANN}}{See the documentation of \code{optim} for details.}
     \item{\code{Brent}}{See the documentation of \code{optim} for details.}
}}

\item{form}{A character string specifying the covariate which will be tested.
The argument form is necessary only if \code{testType} is \code{form}.
The default option for \code{form} is given by "1", which represents the 
first covariate in the formula argument.}

\item{pathsave}{An integer value specifies he number of paths saved among all the paths.
The default is given by 50. Note that it requires a lot of memory if save all
sampled paths (N by N matrix for each path andso path*N*N elements)}
}
\value{
\code{afttest} returns an object of class \code{afttest}.
   An object of class \code{afttest} is a list containing at least the following components:
\describe{
   \item{beta}{a vector of beta estimates based on \code{aftsrr}}
   \item{SE_process}{estimated standard error of the observed process}
   \item{obs_process}{observed process}
   \item{app_process}{approximated process}
   \item{obs_std_process}{standardized observed process}
   \item{app_std_process}{standardized approximated processes}
   \item{p_value}{obtained by the unstandardized test}
   \item{p_std_value}{obtained by the standardized test}
   \item{DF}{a data frame of observed failure time, right censoring indicator, covariates (scaled), 
   time-transformed residual based on beta estimates}
   \item{path}{the number of sample paths}
   \item{eqType}{eqType}
   \item{testType}{testType}
   \item{optimType}{optimType}
}
   For an omnibus test, the observed process and the realizations are composed of the 
   n by n matrix that rows represent the t and columns represent the x in the 
   time-transformed residual order.The observed process and the simulated processes
   for checking a functional form and a link function are given by the n by 1 vector
   which is a function of x in the time-transformed residual order.
}
\description{
afttest
}
\examples{
## Simulate data from an AFT model
library(afttest)
library(survival)
datgen <- function(n = 100) {
  z1 <- rbinom(n, 1, 0.5)
  z2 <- rnorm(n)
  e <- rnorm(n)
  tt <- exp(2 + z1 + z2 + e)
  cen <- runif(n, 0, 100)
  data.frame(Time = pmin(tt, cen), status = 1 * (tt < cen),
             z1 = z1, z2 = z2, id = 1:n)
}
set.seed(0)
simdata <- datgen(n = 20)
result <- afttest(Surv(Time, status) ~ z1 + z2, optimType = "DFSANE",
                  data = simdata, testType="link", eqType="mns")
summary(result)
# afttestplot(result)
}
