% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{split_interval_counts-deprecated}
\alias{split_interval_counts-deprecated}
\title{Split interval counts}
\usage{
split_interval_counts(
    lower_bounds,
    upper_bounds,
    counts,
    max_upper = 100L,
    weights = NULL
)
}
\arguments{
\item{lower_bounds, upper_bounds}{\verb{[integerish]}.

A pair of vectors representing the bounds of the intervals.

\code{lower_bounds} must be strictly less than \code{upper_bounds} and greater than or
equal to zero.

Missing (NA) bounds are not permitted.

Double vectors will be coerced to integer.}

\item{counts}{\verb{[numeric]}.

Vector of counts to be aggregated.}

\item{max_upper}{\verb{[integerish]}

Represents the maximum upper bounds permitted upon splitting the data.

Any upper bound greater than this will be replaced with this value prior to
splitting.

Double vectors will be coerced to integer.}

\item{weights}{\verb{[numeric]}

Population weightings to apply for individual years.

If \code{NULL} (default) counts will be split evenly based on interval size.

If specified, must be of length \code{max_upper} and represent weights in the
range 0:(max_upper - 1).}
}
\value{
A data frame with entries \code{age} (in years) and \code{count}.
}
\description{
DEPRECATED.

\code{split_interval_counts()} splits counts of a given age interval in to
counts for individual years based on a given weighting. Age intervals are
specified by their lower (closed) and upper (open) bounds, i.e. intervals
of the form [lower, upper).
}
\examples{

split_interval_counts(
    lower_bounds = c(0, 5, 10),
    upper_bounds = c(5, 10, 20),
    counts = c(5, 10, 30)
)

split_interval_counts(
    lower_bounds = c(0, 5, 10),
    upper_bounds = c(5, 10, Inf),
    counts = c(5, 10, 30),
    max_upper = 15
)

split_interval_counts(
    lower_bounds = c(0, 5),
    upper_bounds = c(5, 10),
    counts = c(5, 10),
    max_upper =10,
    weights = 1:10
)
}
\keyword{internal}
