\name{rothamsted.brussels}
\alias{rothamsted.brussels}
\docType{data}
\title{
  Yield of brussels sprouts, RCB with 9 fertilizer treatments
}
\description{
  Yield of brussels sprouts, RCB with 9 fertilizer treatments
}

\format{
  A data frame with 48 observations on the following 5 variables.
  \describe{
    \item{\code{row}}{Row}
    \item{\code{col}}{Column}
    \item{\code{yield}}{Yield of saleable sprouts, pounds}
    \item{\code{trt}}{Treatment factor, 9 levels}
    \item{\code{block}}{Block factor, 4 levels}
  }
}
\details{
  The block numbers are arbitrary, and may not match the orignal source.
}
\source{
  Rothamsted Experimental Station Report 1934-36.
  Brussels sprouts: effect of sulphate of ammonia, poultry manure, soot
  and rape dust, pp. 191-192. Harpenden: Lawes Agricultural Trust.
}
\references{
  McCullagh, P. and Clifford, D., (2006).
  Evidence for conformal invariance of crop yields,
  \emph{Proceedings of the Royal Society A: Mathematical, Physical and
  Engineering Science}, 462, 2119--2143.
}

\examples{

data(rothamsted.brussels)
dat <- rothamsted.brussels

require(lattice)
bwplot(yield~trt, dat, main="rothamsted.brussels")
desplot(yield~col*row, data=dat, num=trt, out1=block, cex=1,
        main="rothamsted.brussels")

}

