% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_S3_methods.R
\name{plot.checkAgri}
\alias{plot.checkAgri}
\title{Plot an object of class \code{checkAgri}}
\usage{
\method{plot}{checkAgri}(
  x,
  type = c("connectivity", "missing", "boxplot"),
  axis_size = 15,
  text_size = 5,
  ...
)
}
\arguments{
\item{x}{An object inheriting from class \code{checkAgri} resulting of
executing the function \code{check_design_met()}}

\item{type}{A character string specifiying the type of plot. "connectivity",
"missing" or "boxplot".}

\item{axis_size}{Numeric input to define the axis size.}

\item{text_size}{Numeric input to define the text size.}

\item{...}{Further graphical parameters. For future improvements.}
}
\value{
A ggplot object.
}
\description{
Create several plots for an object of class \code{checkAgri}
}
\examples{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
plot(results, type = "missing")
plot(results, type = "boxplot")

}
\author{
Johan Aparicio [aut]
}
