% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa.R
\name{fa_summary}
\alias{fa_summary}
\title{Factor Analytic Summary}
\usage{
fa_summary(
  model = NULL,
  trial = "trial",
  genotype = "genotype",
  BLUEs_trial = NULL,
  mult_fa1 = -1,
  mult_fa2 = 1,
  filter_score = 1.5,
  k_biplot = 1,
  size_label_var = 2,
  alpha_label_var = 0.2,
  size_label_ind = 2,
  alpha_label_ind = 0.8,
  size_arrow = 0.2,
  alpha_arrow = 0.2,
  base_size = 12
)
}
\arguments{
\item{model}{Factor Analytic Model (ASReml object)}

\item{trial}{A character string indicating the column in data that contains
trials.}

\item{genotype}{A character string indicating the column in data that
contains genotypes.}

\item{BLUEs_trial}{A data.frame containing BLUEs for each trial.}

\item{mult_fa1}{A constant to multiply the first loading. Must be 1 or -1.
(-1 by default)}

\item{mult_fa2}{A constant to multiply the second loading. Must be 1 or -1.
(1 by default)}

\item{filter_score}{A numeric value to filter genotypes by the distance from
the origin.}

\item{k_biplot}{A numeric value to multiply the scores in the biplot.}

\item{size_label_var}{A numeric value to define the label size for the
variables.}

\item{alpha_label_var}{A numeric value between (0,1) to define the label for
the variables.}

\item{size_label_ind}{A numeric value to define the label size for the
individuals.}

\item{alpha_label_ind}{A numeric value between (0,1) to define the label for
the individuals.}

\item{size_arrow}{A numeric value to define the arrow size.}

\item{alpha_arrow}{A numeric value between (0,1) to define the arrow.}

\item{base_size}{A numeric value to define the base size.}
}
\value{
An object with a list of:
\item{loadings}{A data.frame containing the first and second loading for each
 trial.}
\item{loading_star}{A data.frame containing the first and second loading
rotated for each trial.}
\item{Gvar}{A matrix of the estimated variance-covariance between trials.}
\item{Cmat}{A matrix of the correlation between trials.}
\item{summary_loading}{A data.frame containing a summary of the loadings.}
\item{paf_site}{A data.frame containing the percentage of variance explained
 for each component and for each trial.}
\item{var_tot}{A numeric value of the total variance.}
\item{scores}{A data.frame containing the scores for each genotype.}
\item{plots}{A list with different plots. Includes a plot for the loadings,
 biplot, biplot_scaled and loadings_c.}
}
\description{
Factor Analytic Summary
}
\examples{
\dontrun{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
met_results <- met_analysis(out, vcov = "fa2", progress = FALSE)

pp <- met_results$trial_effects
model <- met_results$met_models$yield
fa_summary(
  model = model,
  trial = "trial",
  genotype = "genotype",
  BLUEs_trial = pp,
  mult_fa1 = -1,
  mult_fa2 = -1,
  filter_score = 1,
  k_biplot = 10,
  size_label_var = 3,
  alpha_label_var = 0.5,
  size_label_ind = 3,
  alpha_label_ind = 0.8,
  size_arrow = 0.2,
  alpha_arrow = 0.1
)
}
}
