% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedd.R
\name{bedd}
\alias{bedd}
\title{Biologically effective degree-days (BEDD)}
\usage{
bedd(mx, mn, lati, dates)
}
\arguments{
\item{mx}{vector of daily maximum temperature series.}

\item{mn}{vector of daily minimum temperature series.}

\item{lati}{numeric value indicating the latitude of location.}

\item{dates}{vector of dates corresponding with daily temprature series}
}
\value{
The sum of degree-days (BEDD) is returned as a numeric value.
}
\description{
Biologically effective degree-days (BEDD). Gladstones, J. (1992).
}
\details{
Depending on the latitude, the function detects the hemisphere and considers growing season from 1st April to 31st October (northern hemisphere) or from 1st October to 30rd April (southern hemisphere).
}
\examples{

  bedd(mx = daily_tmax,
    mn = daily_tmin,
    dates = seq.Date(as.Date('1981-01-01'),
            as.Date('2010-12-31'), by ='day'),
            lati = 42)

}
\references{
Gladstones, J. (1992) Viticulture and environment (Winetitles: Adelaide).
}
