% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_gvgd.R
\name{agvgd}
\alias{agvgd}
\alias{align_gvgd}
\title{Align-GVGD (A-GVGD)}
\usage{
agvgd(alignment, poi, substitution, sort = FALSE)

align_gvgd(alignment, poi, substitution, sort = FALSE)
}
\arguments{
\item{alignment}{A character matrix or an alignment object obtained with
\code{\link[=read_alignment]{read_alignment()}}. Rows are expected to be sequences of single characters
(protein residues), and columns the alignment positions. The first row must
be the reference sequence, i.e. the sequence whose substitutions will be
evaluated against.}

\item{poi}{A whole number indicating the position of interest (POI).}

\item{substitution}{A character vector of protein residue substitutions to be
classified. The amino acids must be provided as one-letter symbols.}

\item{sort}{Whether to sort the output by \code{gd}, or not. Default is \code{FALSE}.}
}
\description{
This function implements the Align-GVGD (A-GVGD) method described in
Tavtigian \emph{et al.} (2006).

A-GVGD combines multiple sequence alignment of orthologous sequences with the
Grantham distance to classify missense variants, i.e. to distinguish human
disease susceptibility missense changes from changes of little clinical
significance.

\code{agvgd()} and \code{align_gvgd()} are synonyms.
}
\references{
\itemize{
\item Tavtigian, S.V., Deffenbaugh, A. M., Yin, L., Judkins, T., Scholl, T.,
Samollow, P.B., de Silva, D., Zharkikh, A., Thomas, A. \emph{Comprehensive
statistical study of 452 BRCA1 missense substitutions with classification of
eight recurrent substitutions as neutral}. Journal of Medical Genetics 43,
295--305 (2006). \doi{10.1136/jmg.2005.033878}.
\item Mathe, E., Olivier, M., Kato, S., Ishioka, C., Hainaut, P., Tavtigian, S.V.
\emph{Computational approaches for predicting the biological effect of p53
missense mutations: a comparison of three sequence analysis based methods}.
Nucleic Acids Research 34, 1317--1325 (2006). \doi{10.1093/nar/gkj518}.
}
}
