% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequentist_re.R
\name{BootstrapAPCEipwREparallel}
\alias{BootstrapAPCEipwREparallel}
\title{Bootstrap for estimating variance of APCE with random effects}
\usage{
BootstrapAPCEipwREparallel(data, rep = 1000, formula, nAGQ = 1, size = 5)
}
\arguments{
\item{data}{A \code{data.frame} or \code{matrix} of which columns consists of pre-treatment covariates, a binary treatment (Z), an ordinal decision (D), and an outcome variable (Y). The column names of the latter three should be specified as "Z", "D", and "Y" respectively.}

\item{rep}{Size of bootstrap}

\item{formula}{A formula of the model to fit.}

\item{nAGQ}{Integer scalar - the number of points per axis for evaluating the adaptive Gauss-Hermite approximation to the log-likelihood. Defaults to 1, corresponding to the Laplace approximation.}

\item{size}{The number of parallel computing. The default is \code{5}.}
}
\value{
An object of class \code{list} with the following elements:
\item{P.D1.boot}{An array with dimension rep by (k+1) by (k+2) for quantity P(D(1)=d| R=r), dimension 1 is rep (size of bootstrap), dimension 2 is (k+1) values of D from 0 to k, dimension 3 is (k+2) values of R from 0 to k+1.}
\item{P.D0.boot}{An array with dimension rep by (k+1) by (k+2) for quantity P(D(0)=d| R=r).}
\item{APCE.boot}{An array with dimension rep by (k+1) by (k+2) for quantity P(D(1)=d| R=r)-P(D(0)=d| R=r).}
\item{P.R.boot}{An array with dimension rep by (k+2) for quantity P(R=r) for r from 0 to (k+1).}
}
\description{
Estimate variance of APCE for frequentist analysis with random effects using bootstrap. See S7 for more details.
}
\examples{
\donttest{
data(synth)
data(hearingdate_synth)
synth$CourtEvent_HearingDate = hearingdate_synth
set.seed(123)
boot_apce_re = BootstrapAPCEipwREparallel(synth, rep = 10, 
                                          formula = "Y ~ Sex + White + Age + 
                                          CurrentViolentOffense + PendingChargeAtTimeOfOffense + 
                                          PriorMisdemeanorConviction + PriorFelonyConviction + 
                                          PriorViolentConviction + (1|CourtEvent_HearingDate) + 
                                          D", size = 1) # adjust the size
}

}
