% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fairness.R
\name{CalDelta}
\alias{CalDelta}
\title{Calculate the delta given the principal stratum}
\usage{
CalDelta(r, k, pd0, pd1, attr)
}
\arguments{
\item{r}{The given principal stratum.}

\item{k}{The maximum decision (e.g., largest bail amount).}

\item{pd0}{P.D0.mcmc array generated from \code{CalAPCE} or \code{CalAPCEparallel}.}

\item{pd1}{P.D1.mcmc array generated from \code{CalAPCE} or \code{CalAPCEparallel}.}

\item{attr}{The index of subgroups (within the output of CalAPCE/CalAPCEparallel) that corresponds to the protected attributes.}
}
\value{
A \code{data.frame} of the delta.
}
\description{
Calculate the maximal deviation of decisions probability among the distributions for different groups (delta) given the principal stratum (R).
}
\examples{
\donttest{
data(synth)
subgroup_synth <- list(
  1:nrow(synth), which(synth$Sex == 0), which(synth$Sex == 1),
  which(synth$Sex == 1 & synth$White == 0), which(synth$Sex == 1 & synth$White == 1)
)
sample_mcmc <- AiEvalmcmc(data = synth, n.mcmc = 10)
sample_apce <- CalAPCE(
  data = synth, mcmc.re = sample_mcmc, subgroup = subgroup_synth,
  burnin = 0
)
CalDelta(0, 3, sample_apce[["P.D0.mcmc"]], sample_apce[["P.D1.mcmc"]], c(2, 3))
}

}
