% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_index.R
\name{convert_to_index}
\alias{convert_to_index}
\title{Convert a pollutant concentration to its air quality category}
\usage{
convert_to_index(value, pollutant)
}
\arguments{
\item{value}{a numeric vector of values to convert to index}

\item{pollutant}{type of pollutant. A vector of one or more of the following
options: \itemize{ \item SO2 - Sulfur Dioxide - ppb (24 hour average)
\item CO - Carbon Monoxide - ppm (8 hour average) \item NO2 - Nitrogen
Dioxide - pbb (1 hour average) \item O3 - Ozone ppb (1 hour average)
\item PM10 - Particulate matter 10 micrometers or less (24 hour
average) \item PM25 - Particulate matter 2.5 micrometers or less (24
hour average) }}
}
\value{
the IMECA value of the concentration indexed into 5 categories
\itemize{
\item BUENA - Good: 0-50 minimal health risk
\item REGULAR - Regular: 51-100 moderate health effects
\item MALA - Bad: 101-150 sensitive groups may suffer adverse heatlh effects
\item MUY MALA - Very Bad: 151-200 everyone can experience negative health effects
\item EXTREMADAMENTE MALA - Extremely Bad: > 200 serious health issues
}
}
\description{
This functions converts a pollutant value in its original units into one of the 5
categories used by the Mexican government to communicate to the public how
polluted the air currently is and its health risks.
}
\examples{
convert_to_index(c(12.1, 215, 355), c("PM25", "PM10", "PM10"))
}
\seealso{
\href{http://www.aire.cdmx.gob.mx/aire/descargas/monitoreo/normatividad/NADF-009-AIRE-2006.pdf}{NADF-009-AIRE-2006}

Other convert functions: 
\code{\link{convert_to_imeca}()}
}
\concept{convert functions}
