% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{airports_near_airport}
\alias{airports_near_airport}
\title{Lookup airports nearby other airports}
\usage{
airports_near_airport(input, distance = 100)
}
\arguments{
\item{input}{An airport name, IATA code, or ICAO code. Input type will be guessed unless
explicitly defined}

\item{distance}{Distance boundary for nearest airport lookup in kilometres}
}
\value{
A tibble of airports that fall within the specified range of input airport
}
\description{
A function that returns details of airports within a user-specified distance of a given airport.
}
\examples{
airports_near_airport("YVR")

# Or with a user specified distance in kilometres
airports_near_airport("YVR", distance = 200)
}
