% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/alEfit.R
\name{alE}
\alias{alE}
\alias{alEfitdist}
\alias{alEfit}
\alias{alEfit.default}
\alias{print.alEfit}
\title{Arc length estimation.}
\usage{
alE(x, q1, q2, dc, type)

alEfitdist(x, q1, q2, dc, type, bootstraps)

alEfit(X, q1, q2, dc, type, bootstraps, ...)

\method{alEfit}{default}(X, q1, q2, dc, type, bootstraps, ...)

\method{print}{alEfit}(x, ...)
}
\arguments{
\item{x}{An alEfit object.}

\item{q1, q2}{Vectors specifying the quantiles over which arc length segments are to be computed.}

\item{dc}{TRUE/FALSE:  Should the discrete or continuous sample statistic be used.}

\item{type}{The type of bandwidth estimator for the underlying KDE; see \code{\link{bw}}.}

\item{bootstraps}{An integer specifying the size of the parametric bootstrap.}

\item{X}{A vector of sample values.}

\item{...}{Additional arguments passed to \code{alEfit} (not currently used).}
}
\value{
alE: A list with the following components (see \code{\link{optim}}):
\itemize{
\item par: The estimated parameters.
\item abstol: The absolute tolerance level (default 1e-15).
\item fail: An integer code indicating convergence.
\item fncount: Number of function evaluations.
}

alEfitdist: A matrix of parameter estimates resulting from the estimated arc lengths over the specified interval(s), i.e. the bootstrap distribution for the estimated parameters resulting from the chosen sample arc length statistic.

alEfit: A generic S3 object with class alEfit.

alEfit.default: A list with all components from \code{\link{alE}}, as well as :
\itemize{
\item dc: TRUE/FALSE Was the discrete or continuous sample arc length statistic used?
\item q1, q2: The segments over which the arc length(s) were calculated.
\item bw: The bandwidth for the kernel density estimator.
\item dist: A numeric matrix whose columns represent a bootstrap distribution for the corresponding parameter estimate.
\item se: A numeric vector with standard errors, obtained by a parametric bootstrap.
\item bootstraps: Number of bootstrap samples.
}
}
\description{
A framework for arc length estimation.
}
\details{
\itemize{
\item Estimate distributional parameters using the method of arc lengths.
\item Simulate bootstrap distributions for parameter estimates, resulting from sample arc length statistics.
}

This method is currently only implemented for the normal distribution.  The underlying C code for the Nelder-Mead method of the optim function is used for optimising the objective function.  The tolerance level is set at 1e-15, and a maximum number of 1000 iterations is allowed.  The maximum likelihood estimates are used as initial values for the Nelder-Mead algorithm.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for alEfit.

\item \code{alEfit}: print method for alEfit.
}}

\examples{
x <- rnorm(1000)
alE(x,0.025, 0.975, TRUE, -1)
alE(x,c(0.025, 0.5), c(0.5, 0.975), TRUE, -1)
alE(x,0.025, 0.975, FALSE, -1)
alE(x,c(0.025, 0.5), c(0.5, 0.975), FALSE, -1)

\dontrun{
alEfitdist(x, 0.025, 0.975, TRUE, -1, 100)
alEfitdist(x, 0.025, 0.975, FALSE, -1, 100)
}
alEfit(x, q1=0.025, q2=0.975, dc=TRUE, type=-1, bootstraps=50)
alEfit(x, q1=0.025, q2=0.975, dc=FALSE, type=-1, bootstraps=50)

}
