% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{maskSeqEnds}
\alias{maskSeqEnds}
\title{Masks ragged leading and trailing edges of aligned DNA sequences}
\usage{
maskSeqEnds(seq, max_mask = NULL, trim = FALSE)
}
\arguments{
\item{seq}{a character vector of DNA sequence strings.}

\item{max_mask}{the maximum number of characters to mask. If set to 0 then
no masking will be performed. If set to \code{NULL} then the upper 
masking bound will be automatically determined from the maximum 
number of observed leading or trailing \code{"N"} characters amongst 
all strings in \code{seq}.}

\item{trim}{if \code{TRUE} leading and trailing characters will be cut rather 
than masked with \code{"N"} characters.}
}
\value{
A modified \code{seq} vector with masked (or optionally trimmed) sequences.
}
\description{
\code{maskSeqEnds} takes a vector of DNA sequences, as character strings,
and replaces the leading and trailing characters with \code{"N"} characters to create 
a sequence vector with uniformly masked outer sequence segments.
}
\examples{
# Default behavior uniformly masks ragged ends
seq <- c("CCCCTGGG", "NAACTGGN", "NNNCTGNN")
maskSeqEnds(seq)

# Does nothing
maskSeqEnds(seq, max_mask=0)

# Cut ragged sequence ends
maskSeqEnds(seq, trim=TRUE)

# Set max_mask to limit extent of masking and trimming
maskSeqEnds(seq, max_mask=1)
maskSeqEnds(seq, max_mask=1, trim=TRUE)

}
\seealso{
Other sequence manipulation functions: \code{\link{collapseDuplicates}},
  \code{\link{maskSeqGaps}}
}

