% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{summarizeSubtrees}
\alias{summarizeSubtrees}
\title{Generate subtree summary statistics for a tree}
\usage{
summarizeSubtrees(graph, fields = NULL, root = "Germline")
}
\arguments{
\item{graph}{igraph object containing an annotated lineage tree.}

\item{fields}{annotation fields to add to the output.}

\item{root}{name of the root (germline) node.}
}
\value{
A data.frame with columns: 
          \itemize{
            \item  \code{NAME}:             node name.
            \item  \code{PARENT}:           name of the parent node.
            \item  \code{OUTDEGREE}:        number of edges leading from the node.
            \item  \code{SIZE}:             total number of nodes within the subtree rooted 
                                            at the node.
            \item  \code{DEPTH}:            the depth of the subtree that is rooted at 
                                            the node.
            \item  \code{PATHLENGTH}:       the maximum pathlength beneath the node.
            \item  \code{OUTDEGREE_NORM}:   \code{OUTDEGREE} normalized by the total 
                                            number of edges.
            \item  \code{SIZE_NORM}:        \code{SIZE} normalized by the largest
                                            subtree size (the germline).
            \item  \code{DEPTH_NORM}:       \code{DEPTH} normalized by the largest
                                            subtree depth (the germline).
            \item  \code{PATHLENGTH_NORM}:  \code{PATHLEGNTH} normalized by the largest
                                            subtree pathlength (the germline).
          }
          An additional column corresponding to the value of \code{field} is added when
          specified.
}
\description{
\code{summarizeSubtrees} calculates summary statistics for each node of a tree. Includes
both node properties and subtree properties.
}
\examples{
# Summarize a tree
graph <- ExampleTrees[[23]]
summarizeSubtrees(graph, fields="ISOTYPE", root="Germline")

}
\seealso{
See \link{buildPhylipLineage} for generating input trees. 
          See \link{getPathLengths} for calculating path length to nodes.
}

