% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AminoAcids.R
\name{bulk}
\alias{bulk}
\title{Calculates the average bulkiness of amino acid sequences}
\usage{
bulk(seq, bulkiness = NULL)
}
\arguments{
\item{seq}{vector of strings containing amino acid sequences.}

\item{bulkiness}{named numerical vector defining bulkiness scores for 
each amino acid, where names are single-letter amino acid 
character codes. If \code{NULL}, then the Zimmerman et al, 1968
scale is used.}
}
\value{
A vector of bulkiness scores for the sequence(s).
}
\description{
\code{bulk} calculates the average bulkiness score of amino acid sequences. 
Non-informative positions are excluded, where non-informative is defined as any 
character in \code{c("X", "-", ".", "*")}.
}
\examples{
# Default bulkiness scale
seq <- c("CARDRSTPWRRGIASTTVRTSW", "XXTQMYVRT")
bulk(seq)

# Use the Grantham, 1974 side chain volumn scores from the seqinr package
library(seqinr)
data(aaindex)
x <- aaindex[["GRAR740103"]]$I
# Rename the score vector to use single-letter codes
names(x) <- translateStrings(names(x), ABBREV_AA)
# Calculate average volume
bulk(seq, bulkiness=x)

}
\references{
\enumerate{
  \item  Zimmerman JM, Eliezer N, Simha R. The characterization of amino acid sequences 
           in proteins by statistical methods. J Theor Biol 21, 170-201 (1968).
}
}
\seealso{
For additional size related indices see \link[seqinr]{aaindex}.
}

