% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{AbundanceCurve-class}
\alias{AbundanceCurve-class}
\alias{AbundanceCurve}
\alias{print,AbundanceCurve-method}
\alias{AbundanceCurve-method}
\alias{plot,AbundanceCurve,missing-method}
\title{S4 class defining a clonal abundance curve}
\usage{
\S4method{print}{AbundanceCurve}(x)

\S4method{plot}{AbundanceCurve,missing}(x, y, ...)
}
\arguments{
\item{x}{AbundanceCurve object}

\item{y}{ignored.}

\item{...}{arguments to pass to \link{plotDiversityCurve}.}
}
\description{
\code{AbundanceCurve} defines clonal abundance values.
}
\section{Slots}{

\describe{
\item{\code{abundance}}{data.frame with relative clonal abundance data and confidence intervals,
containing the following columns:
\itemize{
  \item  \code{group}:  group identifier.
  \item  \code{clone_id} or \code{CLONE}:  clone identifier. 
  \item  \code{p}:      relative abundance of the clone.
  \item  \code{lower}:  lower confidence inverval bound.
  \item  \code{upper}:  upper confidence interval bound.
  \item  \code{rank}:   the rank of the clone abundance.
}}

\item{\code{bootstrap}}{data.frame of bootstrapped clonal distributions.}

\item{\code{clone_by}}{string specifying the name of the clone column.}

\item{\code{group_by}}{string specifying the name of the grouping column.}

\item{\code{groups}}{vector specifying the names of unique groups in group column.}

\item{\code{n}}{numeric vector indication the number of sequences sampled in each group.}

\item{\code{nboot}}{numeric specifying the number of bootstrap iterations to use.}

\item{\code{ci}}{confidence interval defining the upper and lower bounds 
(a value between 0 and 1).}
}}

