% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentAnalysis.R
\name{agentAnalysis}
\alias{agentAnalysis}
\title{Agent Analysis}
\usage{
agentAnalysis(
  pointMap,
  timesteps,
  releaseRate,
  agentLifeTimesteps,
  agentFov,
  agentStepsToDecision,
  agentLookMode,
  originX = NA,
  originY = NA,
  locationSeed = 0L,
  numberOfTrails = NA,
  getGateCounts = FALSE,
  copyMap = TRUE,
  verbose = FALSE,
  progress = FALSE
)
}
\arguments{
\item{pointMap}{A PointMap, used as an exosomatic visual map for agents to
take exploratory information}

\item{timesteps}{Number of total system timesteps.}

\item{releaseRate}{Agent release rate (likelihood of release per timestep).}

\item{agentLifeTimesteps}{Agent total lifetime (in timesteps)}

\item{agentFov}{Agent field-of-view (out of 32 bins = 360).}

\item{agentStepsToDecision}{Agent steps before turn decision.}

\item{agentLookMode}{The agent look mode. See \link{AgentLookMode}}

\item{originX}{Agent starting points (x coordinates).}

\item{originY}{Agent starting point (y coordinates).}

\item{locationSeed}{Agents to start at random locations with specific seed (0
to 10). Default is 0.}

\item{numberOfTrails}{Record trails for this amount of agents (set to 0 to
record all, with max possible currently = 50).}

\item{getGateCounts}{Get values at gates}

\item{copyMap}{Optional. Copy the internal sala map}

\item{verbose}{Optional. Show more information of the process.}

\item{progress}{Optional. Show process progress.}
}
\value{
Returns a list with:
\itemize{
  \item{newAttributes: The new attributes that were created during the
  process}
  \item{trailMap: A ShapeMap with trails if numberOfTrails was set over 0}
}
}
\description{
Runs Agent Analysis on the given PointMap
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.5,
    fillX = 3.0,
    fillY = 6.0,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
agentAnalysis(
  pointMap,
  timesteps = 3000L,
  releaseRate = 0.1,
  agentStepsToDecision = 3L,
  agentFov = 11L,
  agentLife = 1000L,
  agentLookMode = AgentLookMode$Standard,
  originX = NA,
  originY = NA,
  locationSeed = 1L,
  numberOfTrails = 50L,
  getGateCounts = FALSE,
  verbose = FALSE
)
}
