% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AxialShapeGraph.R
\docType{methods}
\name{linkCoords,AxialShapeGraph-method}
\alias{linkCoords,AxialShapeGraph-method}
\title{Link two Axial Lines (coordinates)}
\usage{
\S4method{linkCoords}{AxialShapeGraph}(map, fromX, fromY, toX, toY, copyMap = TRUE)
}
\arguments{
\item{map}{An Axial ShapeGraph}

\item{fromX}{X coordinate of the first link point}

\item{fromY}{Y coordinate of the first link point}

\item{toX}{X coordinate of the second link point}

\item{toY}{Y coordinate of the second link point}

\item{copyMap}{Optional. Copy the internal sala map}
}
\value{
A new Axial ShapeGraph with linked lines
}
\description{
Link two locations on an Axial ShapeGraph using the point coordinates
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
linkCoords(shapeGraph, 982.8, -1620.3, 1217.1, -1977.3)
}
