% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ale_core.R
\name{calc_ale}
\alias{calc_ale}
\title{Calculate ALE data}
\usage{
calc_ale(
  X,
  model,
  x_col,
  pred_fun,
  x_intervals,
  boot_it,
  seed,
  boot_alpha,
  boot_centre,
  ale_x = NULL,
  ale_n = NULL
)
}
\arguments{
\item{X}{dataframe. Data for which ALE is to be calculated. The y (outcome)
column is absent.}

\item{model}{See documentation for \code{ale}}

\item{x_col}{character length 1. Name of single column in X for which ALE data is to
be calculated.}

\item{pred_fun}{See documentation for \code{ale}}

\item{x_intervals}{See documentation for \code{ale}}

\item{boot_it}{See documentation for \code{ale}}

\item{seed}{See documentation for \code{ale}}

\item{boot_alpha}{See documentation for \code{ale}}

\item{boot_centre}{See documentation for \code{ale}}

\item{ale_x}{numeric or ordinal vector. Normally generated automatically (if
NULL), but if provided, the provided value will be used instead.}

\item{ale_n}{integer vector. See \code{ale_x}}
}
\description{
This function is not exported. It is uses tidyverse principles to rewrite
\code{ALEPlot::ALEPlot}.
This function is not usually called directly by the user. For details about
arguments not documented here, see \code{ale}.
}
\references{
Apley, Daniel W., and Jingyu Zhu.
"Visualizing the effects of predictor variables in black box supervised learning models."
Journal of the Royal Statistical Society Series B: Statistical Methodology
82.4 (2020): 1059-1086.
}
\author{
Dan Apley (source of original calculation of ALE in \code{ALEPlot::ALEPlot})

Chitu Okoli (rewrote the code while retaining ALE calculation)
}
