# bootstrapped binary outcome with full 1D and 2D ALE

    Code
      unclass(cat_cars_ale)
    Output
      <object>
      attr(,"S7_class")
      <ale::ALE> class
      @ parent     : <S7_object>
      @ constructor: function(model, x_cols, data, y_col, ..., exclude_cols, parallel, model_packages, output_stats, output_boot_data, pred_fun, pred_type, p_values, aler_alpha, max_num_bins, boot_it, boot_alpha, boot_centre, seed, y_type, sample_size, silent, .bins) {...}
      @ validator  : <NULL>
      @ properties :
       $ effect: <list>
       $ params: <list>
      attr(,"effect")
      attr(,"effect")$Asia
      attr(,"effect")$Asia$ale
      attr(,"effect")$Asia$ale$d1
      attr(,"effect")$Asia$ale$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4     1     0     0       0         0     0
       2     14.4     7     0     0       0         0     0
       3     15.2     7     0     0       0         0     0
       4     16.4     7     0     0       0         0     0
       5     18.7     7     0     0       0         0     0
       6     19.8     7     0     0       0         0     0
       7     21.4     7     0     0       0         0     0
       8     22.9     7     0     0       0         0     0
       9     30.1     7     0     0       0         0     0
      10     33.9     7     0     0       0         0     0
      
      attr(,"effect")$Asia$ale$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n    .y .y_lo .y_mean .y_median .y_hi
        <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE     36     0     0       0         0     0
      2 TRUE      28     0     0       0         0     0
      
      attr(,"effect")$Asia$ale$d1$am
      # A tibble: 2 x 7
        am.bin    .n      .y    .y_lo .y_mean .y_median  .y_hi
        <ord>  <int>   <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
      1 FALSE     38 0.00619 -0.0396  0.00619   0.0297  0.0320
      2 TRUE      26 0.0155  -0.00990 0.0155   -0.00670 0.0597
      
      attr(,"effect")$Asia$ale$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental     2 -0.0226 -0.288 -0.0226    0.0422 0.187
       2 Cadillac Fleetwood      2  0.0932 -0.280  0.0932    0.195  0.380
       3 Merc 450SL              2 -0.235  -0.766 -0.235    -0.305  0.355
       4 Merc 450SLC             2 -0.235  -0.766 -0.235    -0.305  0.355
       5 Camaro Z28              2  0.0975 -0.304  0.0975   -0.290  0.829
       6 Chrysler Imperial       2  0.264  -0.279  0.264     0.210  0.854
       7 Duster 360              2  0.264  -0.279  0.264     0.210  0.854
       8 Merc 450SE              2  0.266  -0.279  0.266     0.216  0.854
       9 Hornet Sportabout       2  0.433  -0.279  0.433     0.216  1.33 
      10 AMC Javelin             2  0.446  -0.302  0.446    -0.244  1.78 
      # i 22 more rows
      
      attr(,"effect")$Asia$ale$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n       .y   .y_lo  .y_mean .y_median   .y_hi
        <ord>    <int>    <dbl>   <dbl>    <dbl>     <dbl>   <dbl>
      1 three       30  0.118    0.0563  0.118      0.118   0.181 
      2 four        24  0.00198 -0.150   0.00198    0.0718  0.0948
      3 five        10 -0.330   -0.523  -0.330     -0.460  -0.0269
      
      attr(,"effect")$Asia$ale$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n       .y    .y_lo  .y_mean .y_median     .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>     <dbl>
      1         1    14  0.00549  0.00549  0.00549   0.00549  0.00549 
      2         2    19 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      3         3     9 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      4         4    16 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      5         8     6 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      
      attr(,"effect")$Asia$ale$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n          .y       .y_lo     .y_mean   .y_median       .y_hi
           <dbl> <int>       <dbl>       <dbl>       <dbl>       <dbl>       <dbl>
       1    1.50     1  0.0000319   0.0000319   0.0000319   0.0000319   0.0000319 
       2    1.94     7 -0.00000143 -0.00000836 -0.00000143 -0.00000427  0.00000790
       3    2.46     7 -0.00000906 -0.0000153  -0.00000906 -0.00000787 -0.00000385
       4    2.79     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       5    3.19     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       6    3.44     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       7    3.52     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       8    3.73     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       9    4.05     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
      10    5.45     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
      
      
      attr(,"effect")$Asia$ale$d2
      attr(,"effect")$Asia$ale$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 FALSE      1     0     0       0         0     0
       2     14.4 FALSE      7     0     0       0         0     0
       3     15.2 FALSE      7     0     0       0         0     0
       4     16.4 FALSE      7     0     0       0         0     0
       5     18.7 FALSE      3     0     0       0         0     0
       6     19.8 FALSE      5     0     0       0         0     0
       7     21.4 FALSE      4     0     0       0         0     0
       8     22.9 FALSE      0     0     0       0         0     0
       9     30.1 FALSE      2     0     0       0         0     0
      10     33.9 FALSE      0     0     0       0         0     0
      11     10.4 TRUE       0     0     0       0         0     0
      12     14.4 TRUE       0     0     0       0         0     0
      13     15.2 TRUE       0     0     0       0         0     0
      14     16.4 TRUE       0     0     0       0         0     0
      15     18.7 TRUE       4     0     0       0         0     0
      16     19.8 TRUE       2     0     0       0         0     0
      17     21.4 TRUE       3     0     0       0         0     0
      18     22.9 TRUE       7     0     0       0         0     0
      19     30.1 TRUE       5     0     0       0         0     0
      20     33.9 TRUE       7     0     0       0         0     0
      
      attr(,"effect")$Asia$ale$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 FALSE      1     0     0       0         0     0
       2     14.4 FALSE      7     0     0       0         0     0
       3     15.2 FALSE      5     0     0       0         0     0
       4     16.4 FALSE      5     0     0       0         0     0
       5     18.7 FALSE      7     0     0       0         0     0
       6     19.8 FALSE      5     0     0       0         0     0
       7     21.4 FALSE      1     0     0       0         0     0
       8     22.9 FALSE      5     0     0       0         0     0
       9     30.1 FALSE      2     0     0       0         0     0
      10     33.9 FALSE      0     0     0       0         0     0
      11     10.4 TRUE       0     0     0       0         0     0
      12     14.4 TRUE       0     0     0       0         0     0
      13     15.2 TRUE       2     0     0       0         0     0
      14     16.4 TRUE       2     0     0       0         0     0
      15     18.7 TRUE       0     0     0       0         0     0
      16     19.8 TRUE       2     0     0       0         0     0
      17     21.4 TRUE       6     0     0       0         0     0
      18     22.9 TRUE       2     0     0       0         0     0
      19     30.1 TRUE       5     0     0       0         0     0
      20     33.9 TRUE       7     0     0       0         0     0
      
      attr(,"effect")$Asia$ale$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin              .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>               <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 Lincoln Continental     0     0     0       0         0     0
       2     14.4 Lincoln Continental     2     0     0       0         0     0
       3     15.2 Lincoln Continental     0     0     0       0         0     0
       4     16.4 Lincoln Continental     0     0     0       0         0     0
       5     18.7 Lincoln Continental     0     0     0       0         0     0
       6     19.8 Lincoln Continental     0     0     0       0         0     0
       7     21.4 Lincoln Continental     0     0     0       0         0     0
       8     22.9 Lincoln Continental     0     0     0       0         0     0
       9     30.1 Lincoln Continental     0     0     0       0         0     0
      10     33.9 Lincoln Continental     0     0     0       0         0     0
      # i 310 more rows
      
      attr(,"effect")$Asia$ale$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>    <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 three        1     0     0       0         0     0
       2     14.4 three        7     0     0       0         0     0
       3     15.2 three        5     0     0       0         0     0
       4     16.4 three        5     0     0       0         0     0
       5     18.7 three        5     0     0       0         0     0
       6     19.8 three        3     0     0       0         0     0
       7     21.4 three        1     0     0       0         0     0
       8     22.9 three        3     0     0       0         0     0
       9     30.1 three        0     0     0       0         0     0
      10     33.9 three        0     0     0       0         0     0
      # i 20 more rows
      
      attr(,"effect")$Asia$ale$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl>     <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4         1     0     0     0       0         0     0
       2     14.4         1     0     0     0       0         0     0
       3     15.2         1     0     0     0       0         0     0
       4     16.4         1     0     0     0       0         0     0
       5     18.7         1     2     0     0       0         0     0
       6     19.8         1     0     0     0       0         0     0
       7     21.4         1     1     0     0       0         0     0
       8     22.9         1     5     0     0       0         0     0
       9     30.1         1     2     0     0       0         0     0
      10     33.9         1     4     0     0       0         0     0
      # i 40 more rows
      
      attr(,"effect")$Asia$ale$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl>   <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4    1.50     0     0     0       0         0     0
       2     14.4    1.50     0     0     0       0         0     0
       3     15.2    1.50     0     0     0       0         0     0
       4     16.4    1.50     0     0     0       0         0     0
       5     18.7    1.50     0     0     0       0         0     0
       6     19.8    1.50     0     0     0       0         0     0
       7     21.4    1.50     0     0     0       0         0     0
       8     22.9    1.50     0     0     0       0         0     0
       9     30.1    1.50     1     0     0       0         0     0
      10     33.9    1.50     0     0     0       0         0     0
      # i 90 more rows
      
      attr(,"effect")$Asia$ale$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n    .y .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  FALSE     24     0     0       0         0     0
      2 TRUE   FALSE     14     0     0       0         0     0
      3 FALSE  TRUE      12     0     0       0         0     0
      4 TRUE   TRUE      14     0     0       0         0     0
      
      attr(,"effect")$Asia$ale$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin              .n    .y .y_lo .y_mean .y_median .y_hi
         <ord>  <ord>               <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE  Lincoln Continental     2     0     0       0         0     0
       2 TRUE   Lincoln Continental     0     0     0       0         0     0
       3 FALSE  Cadillac Fleetwood      2     0     0       0         0     0
       4 TRUE   Cadillac Fleetwood      0     0     0       0         0     0
       5 FALSE  Merc 450SL              2     0     0       0         0     0
       6 TRUE   Merc 450SL              0     0     0       0         0     0
       7 FALSE  Merc 450SLC             2     0     0       0         0     0
       8 TRUE   Merc 450SLC             0     0     0       0         0     0
       9 FALSE  Camaro Z28              2     0     0       0         0     0
      10 TRUE   Camaro Z28              0     0     0       0         0     0
      # i 54 more rows
      
      attr(,"effect")$Asia$ale$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n    .y .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>    <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  three       24     0     0       0         0     0
      2 TRUE   three        6     0     0       0         0     0
      3 FALSE  four         4     0     0       0         0     0
      4 TRUE   four        20     0     0       0         0     0
      5 FALSE  five         8     0     0       0         0     0
      6 TRUE   five         2     0     0       0         0     0
      
      attr(,"effect")$Asia$ale$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
         <ord>      <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE          1     0     0     0       0         0     0
       2 TRUE           1    14     0     0       0         0     0
       3 FALSE          2    10     0     0       0         0     0
       4 TRUE           2     9     0     0       0         0     0
       5 FALSE          3     8     0     0       0         0     0
       6 TRUE           3     1     0     0       0         0     0
       7 FALSE          4    13     0     0       0         0     0
       8 TRUE           4     3     0     0       0         0     0
       9 FALSE          8     5     0     0       0         0     0
      10 TRUE           8     1     0     0       0         0     0
      
      attr(,"effect")$Asia$ale$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
         <ord>    <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE     1.50     0     0     0       0         0     0
       2 TRUE      1.50     1     0     0       0         0     0
       3 FALSE     1.94     0     0     0       0         0     0
       4 TRUE      1.94     7     0     0       0         0     0
       5 FALSE     2.46     2     0     0       0         0     0
       6 TRUE      2.46     5     0     0       0         0     0
       7 FALSE     2.79     4     0     0       0         0     0
       8 TRUE      2.79     3     0     0       0         0     0
       9 FALSE     3.19     4     0     0       0         0     0
      10 TRUE      3.19     3     0     0       0         0     0
      11 FALSE     3.44     2     0     0       0         0     0
      12 TRUE      3.44     5     0     0       0         0     0
      13 FALSE     3.52     3     0     0       0         0     0
      14 TRUE      3.52     4     0     0       0         0     0
      15 FALSE     3.73     7     0     0       0         0     0
      16 TRUE      3.73     0     0     0       0         0     0
      17 FALSE     4.05     7     0     0       0         0     0
      18 TRUE      4.05     0     0     0       0         0     0
      19 FALSE     5.45     7     0     0       0         0     0
      20 TRUE      5.45     0     0     0       0         0     0
      
      attr(,"effect")$Asia$ale$d2$`am:model`
      # A tibble: 64 x 8
         am.bin model.bin              .n     .y  .y_lo .y_mean .y_median .y_hi
         <ord>  <ord>               <int>  <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE  Lincoln Continental     2 0.214   0.106  0.214      0.106 0.415
       2 TRUE   Lincoln Continental     0 0.214  -1.28   0.214      0.512 1.46 
       3 FALSE  Cadillac Fleetwood      2 0.323   0.106  0.323      0.106 0.723
       4 TRUE   Cadillac Fleetwood      0 0.323  -1.27   0.323      0.837 1.48 
       5 FALSE  Merc 450SL              2 0.0915 -0.552  0.0915     0.106 0.723
       6 TRUE   Merc 450SL              0 0.0915 -1.27   0.0915     0.817 0.836
       7 FALSE  Merc 450SLC             2 0.0915 -0.552  0.0915     0.106 0.723
       8 TRUE   Merc 450SLC             0 0.0915 -1.27   0.0915     0.817 0.836
       9 FALSE  Camaro Z28              2 0.0910 -0.552  0.0910     0.106 0.721
      10 TRUE   Camaro Z28              0 0.0910 -1.27   0.0910     0.817 0.834
      # i 54 more rows
      
      attr(,"effect")$Asia$ale$d2$`am:gear`
      # A tibble: 6 x 8
        am.bin gear.bin    .n      .y  .y_lo .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
      1 FALSE  three       30 -0.0927 -0.197 -0.0927   -0.0688 -0.00870
      2 TRUE   three        0 -0.0927 -0.601 -0.0927   -0.104   0.425  
      3 FALSE  four         8 -0.191  -0.332 -0.191    -0.165  -0.0736 
      4 TRUE   four        16 -0.433  -0.832 -0.433    -0.507   0.0281 
      5 FALSE  five         0 -0.191  -0.332 -0.191    -0.165  -0.0736 
      6 TRUE   five        10 -0.766  -0.942 -0.766    -0.806  -0.555  
      
      attr(,"effect")$Asia$ale$d2$`am:carb`
      # A tibble: 10 x 8
         am.bin carb.ceil    .n        .y    .y_lo   .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>     <dbl>    <dbl>     <dbl>     <dbl>  <dbl>
       1 FALSE          1     6  0.0166    0.0166   0.0166     0.0166  0.0166
       2 TRUE           1     8  0.0166   -0.101    0.0166     0.0166  0.134 
       3 FALSE          2    12  0.0134   -0.0621   0.0134     0.0163  0.0863
       4 TRUE           2     7 -0.000253 -0.203   -0.000253   0.00468 0.198 
       5 FALSE          3     7  0.0134    0.00415  0.0134     0.0163  0.0201
       6 TRUE           3     2 -0.000226 -0.120   -0.000226   0.00468 0.116 
       7 FALSE          4    11  0.190    -0.0514   0.190      0.229   0.399 
       8 TRUE           4     5  0.454     0.357    0.454      0.423   0.579 
       9 FALSE          8     2  0.190     0.0307   0.190      0.229   0.317 
      10 TRUE           8     4  0.454     0.341    0.454      0.353   0.654 
      
      attr(,"effect")$Asia$ale$d2$`am:wt`
      # A tibble: 20 x 8
         am.bin wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>    <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 FALSE     1.50     0 0.0139  0.0139   0.0139    0.0139 0.0139
       2 TRUE      1.50     1 0.0139 -0.00237  0.0139    0.0139 0.0301
       3 FALSE     1.94     0 0.0139  0.00413  0.0139    0.0139 0.0236
       4 TRUE      1.94     7 0.0138 -0.0225   0.0138    0.0138 0.0502
       5 FALSE     2.46     1 0.0138 -0.00627  0.0138    0.0139 0.0339
       6 TRUE      2.46     6 0.0138 -0.0225   0.0138    0.0138 0.0502
       7 FALSE     2.79     1 0.0314 -0.00483  0.0314    0.0426 0.0582
       8 TRUE      2.79     6 0.0538  0.0227   0.0538    0.0605 0.0793
       9 FALSE     3.19     3 0.0481  0.0157   0.0481    0.0497 0.0792
      10 TRUE      3.19     4 0.100   0.0512   0.100     0.0987 0.151 
      11 FALSE     3.44     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      12 TRUE      3.44     0 0.109   0.0651   0.109     0.0987 0.161 
      13 FALSE     3.52     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      14 TRUE      3.52     0 0.113   0.0772   0.113     0.0987 0.161 
      15 FALSE     3.73     5 0.0481  0.0157   0.0481    0.0497 0.0792
      16 TRUE      3.73     2 0.113   0.0973   0.113     0.0987 0.141 
      17 FALSE     4.05     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      18 TRUE      4.05     0 0.113   0.0772   0.113     0.0987 0.161 
      19 FALSE     5.45     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      20 TRUE      5.45     0 0.113   0.0772   0.113     0.0987 0.161 
      
      attr(,"effect")$Asia$ale$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental three        2 -0.0681 -0.184 -0.0681   -0.184  0.146
       2 Cadillac Fleetwood  three        2  0.0476 -0.184  0.0476   -0.184  0.476
       3 Merc 450SL          three        2 -0.280  -1.12  -0.280    -0.184  0.476
       4 Merc 450SLC         three        2 -0.114  -0.643 -0.114    -0.184  0.476
       5 Camaro Z28          three        2  0.389  -0.158  0.389     0.342  0.975
       6 Chrysler Imperial   three        2  0.223  -0.556  0.223     0.274  0.957
       7 Duster 360          three        2  0.223  -0.970  0.223     0.272  1.37 
       8 Merc 450SE          three        2  0.224  -0.687  0.224     0.250  1.11 
       9 Hornet Sportabout   three        2  0.225  -0.686  0.225     0.250  1.11 
      10 AMC Javelin         three        2 -0.0923 -1.59  -0.0923   -0.0198 1.34 
      # i 86 more rows
      
      attr(,"effect")$Asia$ale$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0  3.42  3.42     3.42      3.42  3.42
       2 Cadillac Fleetwood          1     0  3.42  3.42     3.42      3.42  3.42
       3 Merc 450SL                  1     0  3.42  3.42     3.42      3.42  3.42
       4 Merc 450SLC                 1     0  3.42  3.42     3.42      3.42  3.42
       5 Camaro Z28                  1     0  3.42  3.42     3.42      3.42  3.42
       6 Chrysler Imperial           1     0  3.42  3.00     3.42      3.01  4.19
       7 Duster 360                  1     0  3.42 -0.295    3.42      2.05  8.30
       8 Merc 450SE                  1     0  3.42 -3.05     3.42      2.05 11.1 
       9 Hornet Sportabout           1     0  3.42 -3.45     3.42      2.05 11.5 
      10 AMC Javelin                 1     0  3.42 -3.81     3.42      2.05 11.8 
      # i 150 more rows
      
      attr(,"effect")$Asia$ale$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n    .y   .y_lo .y_mean .y_median .y_hi
         <ord>                 <dbl> <int> <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental    1.50     0 0.342  0.342    0.342     0.342 0.342
       2 Cadillac Fleetwood     1.50     0 0.342  0.342    0.342     0.342 0.342
       3 Merc 450SL             1.50     0 0.342  0.342    0.342     0.342 0.342
       4 Merc 450SLC            1.50     0 0.342  0.342    0.342     0.342 0.342
       5 Camaro Z28             1.50     0 0.342  0.342    0.342     0.342 0.342
       6 Chrysler Imperial      1.50     0 0.342  0.319    0.342     0.342 0.366
       7 Duster 360             1.50     0 0.342  0.284    0.342     0.286 0.448
       8 Merc 450SE             1.50     0 0.342 -0.0164   0.342     0.286 0.749
       9 Hornet Sportabout      1.50     0 0.342 -0.0274   0.342     0.286 0.760
      10 AMC Javelin            1.50     0 0.342 -0.0351   0.342     0.286 0.768
      # i 310 more rows
      
      attr(,"effect")$Asia$ale$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>        <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 three            1     6 0.0284  0.0284   0.0284    0.0284 0.0284
       2 four             1     8 0.0284 -0.0188   0.0284    0.0249 0.0785
       3 five             1     0 0.0284 -0.0220   0.0284    0.0249 0.0817
       4 three            2     8 0.0270 -0.0718   0.0270    0.0206 0.131 
       5 four             2     7 0.118   0.0612   0.118     0.135  0.161 
       6 five             2     4 0.0970  0.00282  0.0970    0.130  0.163 
       7 three            3     7 0.0341 -0.0182   0.0341    0.0372 0.0838
       8 four             3     2 0.149   0.120    0.149     0.140  0.185 
       9 five             3     0 0.123   0.0471   0.123     0.139  0.187 
      10 three            4     8 0.0456 -0.0699   0.0456    0.0598 0.149 
      11 four             4     6 0.307   0.206    0.307     0.358  0.364 
      12 five             4     2 0.285   0.221    0.285     0.270  0.361 
      13 three            8     1 0.0456 -0.0204   0.0456    0.0574 0.102 
      14 four             8     1 0.308   0.256    0.308     0.307  0.359 
      15 five             8     4 0.285   0.217    0.285     0.273  0.364 
      
      attr(,"effect")$Asia$ale$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 three       1.50     0 0.0363  0.0363   0.0363    0.0363 0.0363
       2 four        1.50     0 0.0363  0.0274   0.0363    0.0364 0.0453
       3 five        1.50     1 0.0363  0.0212   0.0363    0.0389 0.0493
       4 three       1.94     0 0.0470  0.0108   0.0470    0.0619 0.0704
       5 four        1.94     6 0.0550  0.00593  0.0550    0.0757 0.0864
       6 five        1.94     1 0.0552  0.00661  0.0552    0.0757 0.0864
       7 three       2.46     1 0.0487 -0.00963  0.0487    0.0762 0.0838
       8 four        2.46     4 0.0623  0.0132   0.0623    0.0852 0.0919
       9 five        2.46     2 0.0725  0.0313   0.0725    0.0923 0.0970
      10 three       2.79     1 0.0489 -0.00962  0.0489    0.0764 0.0840
      # i 20 more rows
      
      attr(,"effect")$Asia$ale$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n      .y    .y_lo .y_mean .y_median   .y_hi
             <dbl>   <dbl> <int>   <dbl>    <dbl>   <dbl>     <dbl>   <dbl>
       1         1    1.50     0 0.00454  0.00454 0.00454   0.00454 0.00454
       2         2    1.50     1 0.00454 -0.0270  0.00454   0.00454 0.0361 
       3         3    1.50     0 0.00454 -0.0216  0.00454   0.00454 0.0307 
       4         4    1.50     0 0.00454 -0.0310  0.00454   0.00454 0.0401 
       5         8    1.50     0 0.00454 -0.0316  0.00454   0.00454 0.0407 
       6         1    1.94     4 0.00454 -0.00336 0.00454   0.00454 0.0124 
       7         2    1.94     3 0.0185  -0.0159  0.0185    0.00668 0.0629 
       8         3    1.94     0 0.0185  -0.00651 0.0185    0.00668 0.0535 
       9         4    1.94     0 0.0185  -0.0159  0.0185    0.00668 0.0629 
      10         8    1.94     0 0.0185  -0.0159  0.0185    0.00668 0.0629 
      # i 40 more rows
      
      
      
      attr(,"effect")$Asia$stats
      attr(,"effect")$Asia$stats$d1
      # A tibble: 42 x 8
         statistic estimate p.value term  conf.low  mean median conf.high
         <chr>        <dbl>   <dbl> <chr>    <dbl> <dbl>  <dbl>     <dbl>
       1 aled             0       1 mpg          0     0      0         0
       2 aler_min         0       1 mpg          0     0      0         0
       3 aler_max         0       1 mpg          0     0      0         0
       4 naled            0       0 mpg          0     0      0         0
       5 naler_min        0       1 mpg          0     0      0         0
       6 naler_max        0       0 mpg          0     0      0         0
       7 aled             0       1 vs           0     0      0         0
       8 aler_min         0       1 vs           0     0      0         0
       9 aler_max         0       1 vs           0     0      0         0
      10 naled            0       0 vs           0     0      0         0
      # i 32 more rows
      
      attr(,"effect")$Asia$stats$d2
      # A tibble: 126 x 8
         statistic estimate p.value term   conf.low  mean median conf.high
         <chr>        <dbl>   <dbl> <chr>     <dbl> <dbl>  <dbl>     <dbl>
       1 aled             0       1 mpg:vs        0     0      0         0
       2 aler_min         0       1 mpg:vs        0     0      0         0
       3 aler_max         0       1 mpg:vs        0     0      0         0
       4 naled            0       0 mpg:vs        0     0      0         0
       5 naler_min        0       1 mpg:vs        0     0      0         0
       6 naler_max        0       0 mpg:vs        0     0      0         0
       7 aled             0       1 mpg:am        0     0      0         0
       8 aler_min         0       1 mpg:am        0     0      0         0
       9 aler_max         0       1 mpg:am        0     0      0         0
      10 naled            0       0 mpg:am        0     0      0         0
      # i 116 more rows
      
      
      attr(,"effect")$Asia$boot_data
      attr(,"effect")$Asia$boot_data$d1
      attr(,"effect")$Asia$boot_data$d1$mpg
      # A tibble: 30 x 6
           .it   mpg .y_composite    .n .y_distinct    .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4            0     1           0     0
       2     0  14.4            0     7           0     0
       3     0  15.2            0     7           0     0
       4     0  16.4            0     7           0     0
       5     0  18.7            0     7           0     0
       6     0  19.8            0     7           0     0
       7     0  21.4            0     7           0     0
       8     0  22.9            0     7           0     0
       9     0  30.1            0     7           0     0
      10     0  33.9            0     7           0     0
      # i 20 more rows
      
      attr(,"effect")$Asia$boot_data$d1$vs
      # A tibble: 6 x 6
          .it vs    .y_composite    .n .y_distinct    .y
        <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
      1     0 FALSE            0    36           0     0
      2     0 TRUE             0    28           0     0
      3     1 FALSE            0    36           0     0
      4     1 TRUE             0    28           0     0
      5     2 FALSE            0    36           0     0
      6     2 TRUE             0    28           0     0
      
      attr(,"effect")$Asia$boot_data$d1$am
      # A tibble: 6 x 6
          .it am    .y_composite    .n .y_distinct       .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
      1     0 FALSE     -0.0432     38    -0.0432  -0.0432 
      2     0 TRUE       0.0632     26     0.0632   0.0632 
      3     1 FALSE      0.0321     38     0.0321   0.0321 
      4     1 TRUE      -0.0101     26    -0.0101  -0.0101 
      5     2 FALSE      0.0297     38     0.0297   0.0297 
      6     2 TRUE      -0.00670    26    -0.00670 -0.00670
      
      attr(,"effect")$Asia$boot_data$d1$model
      # A tibble: 96 x 6
           .it model               .y_composite    .n .y_distinct     .y
         <dbl> <fct>                      <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental       -0.305     2      -0.305 -0.305
       2     0 Cadillac Fleetwood        -0.305     2      -0.305 -0.305
       3     0 Merc 450SL                -0.305     2      -0.305 -0.305
       4     0 Merc 450SLC               -0.305     2      -0.305 -0.305
       5     0 Camaro Z28                -0.305     2      -0.305 -0.305
       6     0 Chrysler Imperial         -0.305     2      -0.305 -0.305
       7     0 Duster 360                -0.305     2      -0.305 -0.305
       8     0 Merc 450SE                -0.305     2      -0.305 -0.305
       9     0 Hornet Sportabout         -0.305     2      -0.305 -0.305
      10     0 AMC Javelin               -0.305     2      -0.305 -0.305
      # i 86 more rows
      
      attr(,"effect")$Asia$boot_data$d1$gear
      # A tibble: 9 x 6
          .it gear  .y_composite    .n .y_distinct       .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
      1     0 three      0.118      30     0.118    0.118  
      2     0 four       0.0718     24     0.0718   0.0718 
      3     0 five      -0.526      10    -0.526   -0.526  
      4     1 three      0.0530     30     0.0530   0.0530 
      5     1 four      -0.162      24    -0.162   -0.162  
      6     1 five      -0.460      10    -0.460   -0.460  
      7     2 three      0.184      30     0.184    0.184  
      8     2 four       0.0960     24     0.0960   0.0960 
      9     2 five      -0.00410    10    -0.00410 -0.00410
      
      attr(,"effect")$Asia$boot_data$d1$carb
      # A tibble: 15 x 6
           .it  carb .y_composite    .n .y_distinct         .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>      <dbl>
       1     0     1    0.00549      14   0.00549    0.00549  
       2     0     2   -0.00191      19  -0.00191   -0.00191  
       3     0     3   -0.00191       9  -0.00191   -0.00191  
       4     0     4   -0.00191      16  -0.00191   -0.00191  
       5     0     8   -0.00191       6  -0.00191   -0.00191  
       6     1     1    0.00549      18   0.00549    0.00549  
       7     1     2   -0.00377      16  -0.00377   -0.00377  
       8     1     3   -0.00377      13  -0.00377   -0.00377  
       9     1     4   -0.00377      15  -0.00377   -0.00377  
      10     1     8   -0.00377       2  -0.00377   -0.00377  
      11     2     1    0.00549      15   0.00549    0.00549  
      12     2     2   -0.0000232    13  -0.0000232 -0.0000232
      13     2     3   -0.0000232    13  -0.0000232 -0.0000232
      14     2     4   -0.0000232    20  -0.0000232 -0.0000232
      15     2     8   -0.0000232     3  -0.0000232 -0.0000232
      
      attr(,"effect")$Asia$boot_data$d1$wt
      # A tibble: 30 x 6
           .it    wt .y_composite    .n .y_distinct          .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>       <dbl>
       1     0  1.50   0.0000319      1  0.0000319   0.0000319 
       2     0  1.94   0.00000854     7  0.00000854  0.00000854
       3     0  2.46  -0.00000364     7 -0.00000364 -0.00000364
       4     0  2.79  -0.00000366     7 -0.00000366 -0.00000366
       5     0  3.19  -0.00000366     7 -0.00000366 -0.00000366
       6     0  3.44  -0.00000366     7 -0.00000366 -0.00000366
       7     0  3.52  -0.00000366     7 -0.00000366 -0.00000366
       8     0  3.73  -0.00000366     7 -0.00000366 -0.00000366
       9     0  4.05  -0.00000366     7 -0.00000366 -0.00000366
      10     0  5.45  -0.00000366     7 -0.00000366 -0.00000366
      # i 20 more rows
      
      
      attr(,"effect")$Asia$boot_data$d2
      attr(,"effect")$Asia$boot_data$d2$`mpg:vs`
      # A tibble: 60 x 7
           .it   mpg vs    .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 FALSE            0     1           0     0
       2     0  14.4 FALSE            0     7           0     0
       3     0  15.2 FALSE            0     7           0     0
       4     0  16.4 FALSE            0     7           0     0
       5     0  18.7 FALSE            0     3           0     0
       6     0  19.8 FALSE            0     5           0     0
       7     0  21.4 FALSE            0     4           0     0
       8     0  22.9 FALSE            0     0           0     0
       9     0  30.1 FALSE            0     2           0     0
      10     0  33.9 FALSE            0     0           0     0
      # i 50 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`mpg:am`
      # A tibble: 60 x 7
           .it   mpg am    .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 FALSE            0     1           0     0
       2     0  14.4 FALSE            0     7           0     0
       3     0  15.2 FALSE            0     5           0     0
       4     0  16.4 FALSE            0     5           0     0
       5     0  18.7 FALSE            0     7           0     0
       6     0  19.8 FALSE            0     5           0     0
       7     0  21.4 FALSE            0     1           0     0
       8     0  22.9 FALSE            0     5           0     0
       9     0  30.1 FALSE            0     2           0     0
      10     0  33.9 FALSE            0     0           0     0
      # i 50 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`mpg:model`
      # A tibble: 960 x 7
           .it   mpg model               .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>                      <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 Lincoln Continental            0     0           0     0
       2     0  14.4 Lincoln Continental            0     2           0     0
       3     0  15.2 Lincoln Continental            0     0           0     0
       4     0  16.4 Lincoln Continental            0     0           0     0
       5     0  18.7 Lincoln Continental            0     0           0     0
       6     0  19.8 Lincoln Continental            0     0           0     0
       7     0  21.4 Lincoln Continental            0     0           0     0
       8     0  22.9 Lincoln Continental            0     0           0     0
       9     0  30.1 Lincoln Continental            0     0           0     0
      10     0  33.9 Lincoln Continental            0     0           0     0
      # i 950 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`mpg:gear`
      # A tibble: 90 x 7
           .it   mpg gear  .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 three            0     1           0     0
       2     0  14.4 three            0     7           0     0
       3     0  15.2 three            0     5           0     0
       4     0  16.4 three            0     5           0     0
       5     0  18.7 three            0     5           0     0
       6     0  19.8 three            0     3           0     0
       7     0  21.4 three            0     1           0     0
       8     0  22.9 three            0     3           0     0
       9     0  30.1 three            0     0           0     0
      10     0  33.9 three            0     0           0     0
      # i 80 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`mpg:carb`
      # A tibble: 150 x 7
           .it   mpg  carb .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4     1            0     0           0     0
       2     0  14.4     1            0     0           0     0
       3     0  15.2     1            0     0           0     0
       4     0  16.4     1            0     0           0     0
       5     0  18.7     1            0     2           0     0
       6     0  19.8     1            0     0           0     0
       7     0  21.4     1            0     1           0     0
       8     0  22.9     1            0     5           0     0
       9     0  30.1     1            0     2           0     0
      10     0  33.9     1            0     4           0     0
      # i 140 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`mpg:wt`
      # A tibble: 300 x 7
           .it   mpg    wt .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4  1.50            0     0           0     0
       2     0  14.4  1.50            0     0           0     0
       3     0  15.2  1.50            0     0           0     0
       4     0  16.4  1.50            0     0           0     0
       5     0  18.7  1.50            0     0           0     0
       6     0  19.8  1.50            0     0           0     0
       7     0  21.4  1.50            0     0           0     0
       8     0  22.9  1.50            0     0           0     0
       9     0  30.1  1.50            0     1           0     0
      10     0  33.9  1.50            0     0           0     0
      # i 290 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`vs:am`
      # A tibble: 12 x 7
           .it vs    am    .y_composite    .n .y_distinct    .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE FALSE            0    24           0     0
       2     0 TRUE  FALSE            0    14           0     0
       3     0 FALSE TRUE             0    12           0     0
       4     0 TRUE  TRUE             0    14           0     0
       5     1 FALSE FALSE            0    24           0     0
       6     1 TRUE  FALSE            0    14           0     0
       7     1 FALSE TRUE             0    12           0     0
       8     1 TRUE  TRUE             0    14           0     0
       9     2 FALSE FALSE            0    24           0     0
      10     2 TRUE  FALSE            0    14           0     0
      11     2 FALSE TRUE             0    12           0     0
      12     2 TRUE  TRUE             0    14           0     0
      
      attr(,"effect")$Asia$boot_data$d2$`vs:model`
      # A tibble: 192 x 7
           .it vs    model               .y_composite    .n .y_distinct    .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE Lincoln Continental            0     2           0     0
       2     0 TRUE  Lincoln Continental            0     0           0     0
       3     0 FALSE Cadillac Fleetwood             0     2           0     0
       4     0 TRUE  Cadillac Fleetwood             0     0           0     0
       5     0 FALSE Merc 450SL                     0     2           0     0
       6     0 TRUE  Merc 450SL                     0     0           0     0
       7     0 FALSE Merc 450SLC                    0     2           0     0
       8     0 TRUE  Merc 450SLC                    0     0           0     0
       9     0 FALSE Camaro Z28                     0     2           0     0
      10     0 TRUE  Camaro Z28                     0     0           0     0
      # i 182 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`vs:gear`
      # A tibble: 18 x 7
           .it vs    gear  .y_composite    .n .y_distinct    .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE three            0    24           0     0
       2     0 TRUE  three            0     6           0     0
       3     0 FALSE four             0     4           0     0
       4     0 TRUE  four             0    20           0     0
       5     0 FALSE five             0     8           0     0
       6     0 TRUE  five             0     2           0     0
       7     1 FALSE three            0    24           0     0
       8     1 TRUE  three            0     6           0     0
       9     1 FALSE four             0     4           0     0
      10     1 TRUE  four             0    20           0     0
      11     1 FALSE five             0     8           0     0
      12     1 TRUE  five             0     2           0     0
      13     2 FALSE three            0    24           0     0
      14     2 TRUE  three            0     6           0     0
      15     2 FALSE four             0     4           0     0
      16     2 TRUE  four             0    20           0     0
      17     2 FALSE five             0     8           0     0
      18     2 TRUE  five             0     2           0     0
      
      attr(,"effect")$Asia$boot_data$d2$`vs:carb`
      # A tibble: 30 x 7
           .it vs     carb .y_composite    .n .y_distinct    .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE     1            0     0           0     0
       2     0 TRUE      1            0    14           0     0
       3     0 FALSE     2            0    10           0     0
       4     0 TRUE      2            0     9           0     0
       5     0 FALSE     3            0     8           0     0
       6     0 TRUE      3            0     1           0     0
       7     0 FALSE     4            0    13           0     0
       8     0 TRUE      4            0     3           0     0
       9     0 FALSE     8            0     5           0     0
      10     0 TRUE      8            0     1           0     0
      # i 20 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`vs:wt`
      # A tibble: 60 x 7
           .it vs       wt .y_composite    .n .y_distinct    .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE  1.50            0     0           0     0
       2     0 TRUE   1.50            0     1           0     0
       3     0 FALSE  1.94            0     0           0     0
       4     0 TRUE   1.94            0     7           0     0
       5     0 FALSE  2.46            0     2           0     0
       6     0 TRUE   2.46            0     5           0     0
       7     0 FALSE  2.79            0     4           0     0
       8     0 TRUE   2.79            0     3           0     0
       9     0 FALSE  3.19            0     4           0     0
      10     0 TRUE   3.19            0     3           0     0
      # i 50 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`am:model`
      # A tibble: 192 x 7
           .it am    model               .y_composite    .n .y_distinct     .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl>  <dbl>
       1     0 FALSE Lincoln Continental        0.106     2       0.106  0.106
       2     0 TRUE  Lincoln Continental        0.106     0      -1.38  -1.38 
       3     0 FALSE Cadillac Fleetwood         0.106     2       0.106  0.106
       4     0 TRUE  Cadillac Fleetwood         0.106     0      -1.38  -1.38 
       5     0 FALSE Merc 450SL                 0.106     2       0.106  0.106
       6     0 TRUE  Merc 450SL                 0.106     0      -1.38  -1.38 
       7     0 FALSE Merc 450SLC                0.106     2       0.106  0.106
       8     0 TRUE  Merc 450SLC                0.106     0      -1.38  -1.38 
       9     0 FALSE Camaro Z28                 0.106     2       0.106  0.106
      10     0 TRUE  Camaro Z28                 0.106     0      -1.38  -1.38 
      # i 182 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`am:gear`
      # A tibble: 18 x 7
           .it am    gear  .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE three     -0.0688     30    -0.0688  -0.0688 
       2     0 TRUE  three     -0.0688      0     0.453    0.453  
       3     0 FALSE four      -0.0688      8    -0.0688  -0.0688 
       4     0 TRUE  four      -0.466      16     0.0563   0.0563 
       5     0 FALSE five      -0.0688      0    -0.0688  -0.0688 
       6     0 TRUE  five      -1.06       10    -0.541   -0.541  
       7     1 FALSE three     -0.204      30    -0.204   -0.204  
       8     1 TRUE  three     -0.204       0    -0.104   -0.104  
       9     1 FALSE four      -0.340       8    -0.340   -0.340  
      10     1 TRUE  four      -0.607      16    -0.507   -0.507  
      11     1 FALSE five      -0.340       0    -0.340   -0.340  
      12     1 TRUE  five      -0.905      10    -0.806   -0.806  
      13     2 FALSE three     -0.00554    30    -0.00554 -0.00554
      14     2 TRUE  three     -0.00554     0    -0.628   -0.628  
      15     2 FALSE four      -0.165       8    -0.165   -0.165  
      16     2 TRUE  four      -0.228      16    -0.850   -0.850  
      17     2 FALSE five      -0.165       0    -0.165   -0.165  
      18     2 TRUE  five      -0.328      10    -0.950   -0.950  
      
      attr(,"effect")$Asia$boot_data$d2$`am:carb`
      # A tibble: 30 x 7
           .it am     carb .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE     1      0.0166      6      0.0166  0.0166
       2     0 TRUE      1      0.0166      8     -0.107  -0.107 
       3     0 FALSE     2      0.0166     12     -0.0662 -0.0662
       4     0 TRUE      2     -0.00350     7     -0.213  -0.213 
       5     0 FALSE     3      0.0166      7      0.0203  0.0203
       6     0 TRUE      3     -0.00342     2     -0.127  -0.127 
       7     0 FALSE     4      0.0166     11     -0.0662 -0.0662
       8     0 TRUE      4      0.550       5      0.423   0.423 
       9     0 FALSE     8      0.0166      2      0.0203  0.0203
      10     0 TRUE      8      0.550       4      0.340   0.340 
      # i 20 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`am:wt`
      # A tibble: 60 x 7
           .it am       wt .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE  1.50       0.0139     0     0.0139   0.0139 
       2     0 TRUE   1.50       0.0139     1    -0.00322 -0.00322
       3     0 FALSE  1.94       0.0139     0     0.00361  0.00361
       4     0 TRUE   1.94       0.0138     7    -0.0244  -0.0244 
       5     0 FALSE  2.46       0.0139     1    -0.00732 -0.00732
       6     0 TRUE   2.46       0.0138     6    -0.0245  -0.0245 
       7     0 FALSE  2.79       0.0139     1    -0.00732 -0.00732
       8     0 TRUE   2.79       0.0378     6     0.0207   0.0207 
       9     0 FALSE  3.19       0.0139     3     0.0139   0.0139 
      10     0 TRUE   3.19       0.0761     4     0.0487   0.0487 
      # i 50 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`model:gear`
      # A tibble: 288 x 7
           .it model               gear  .y_composite    .n .y_distinct      .y
         <dbl> <fct>               <fct>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 Lincoln Continental three       -0.184     2     -0.184  -0.184 
       2     0 Cadillac Fleetwood  three       -0.184     2     -0.184  -0.184 
       3     0 Merc 450SL          three       -0.184     2     -0.184  -0.184 
       4     0 Merc 450SLC         three       -0.184     2     -0.184  -0.184 
       5     0 Camaro Z28          three       -0.184     2     -0.184  -0.184 
       6     0 Chrysler Imperial   three       -0.184     2      0.274   0.274 
       7     0 Duster 360          three       -0.184     2      0.272   0.272 
       8     0 Merc 450SE          three       -0.184     2      0.250   0.250 
       9     0 Hornet Sportabout   three       -0.184     2      0.250   0.250 
      10     0 AMC Javelin         three       -0.184     2     -0.0198 -0.0198
      # i 278 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`model:carb`
      # A tibble: 480 x 7
           .it model                carb .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental     1         3.42     0       3.42   3.42 
       2     0 Cadillac Fleetwood      1         3.42     0       3.42   3.42 
       3     0 Merc 450SL              1         3.42     0       3.42   3.42 
       4     0 Merc 450SLC             1         3.42     0       3.42   3.42 
       5     0 Camaro Z28              1         3.42     0       3.42   3.42 
       6     0 Chrysler Imperial       1         3.42     0       3.00   3.00 
       7     0 Duster 360              1         3.42     0      -0.418 -0.418
       8     0 Merc 450SE              1         3.42     0      -3.32  -3.32 
       9     0 Hornet Sportabout       1         3.42     0      -3.74  -3.74 
      10     0 AMC Javelin             1         3.42     0      -4.12  -4.12 
      # i 470 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`model:wt`
      # A tibble: 960 x 7
           .it model                  wt .y_composite    .n .y_distinct      .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 Lincoln Continental  1.50        0.342     0      0.342   0.342 
       2     0 Cadillac Fleetwood   1.50        0.342     0      0.342   0.342 
       3     0 Merc 450SL           1.50        0.342     0      0.342   0.342 
       4     0 Merc 450SLC          1.50        0.342     0      0.342   0.342 
       5     0 Camaro Z28           1.50        0.342     0      0.342   0.342 
       6     0 Chrysler Imperial    1.50        0.342     0      0.342   0.342 
       7     0 Duster 360           1.50        0.342     0      0.284   0.284 
       8     0 Merc 450SE           1.50        0.342     0     -0.0324 -0.0324
       9     0 Hornet Sportabout    1.50        0.342     0     -0.0439 -0.0439
      10     0 AMC Javelin          1.50        0.342     0     -0.0520 -0.0520
      # i 950 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`gear:carb`
      # A tibble: 45 x 7
           .it gear   carb .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 three     1       0.0284     6      0.0284  0.0284
       2     0 four      1       0.0284     8     -0.0211 -0.0211
       3     0 five      1       0.0284     0     -0.0245 -0.0245
       4     0 three     2       0.0284     8     -0.0766 -0.0766
       5     0 four      2       0.162      7      0.0573  0.0573
       6     0 five      2       0.130      4      0.130   0.130 
       7     0 three     3       0.0284     7     -0.0211 -0.0211
       8     0 four      3       0.193      2      0.140   0.140 
       9     0 five      3       0.147      0      0.0422  0.0422
      10     0 three     4       0.0284     8     -0.0767 -0.0767
      # i 35 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`gear:wt`
      # A tibble: 90 x 7
           .it gear     wt .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 three  1.50       0.0363     0     0.0363   0.0363 
       2     0 four   1.50       0.0363     0     0.0269   0.0269 
       3     0 five   1.50       0.0363     1     0.0202   0.0202 
       4     0 three  1.94       0.0363     0     0.00815  0.00815
       5     0 four   1.94       0.0527     6     0.00226  0.00226
       6     0 five   1.94       0.0535     1     0.00298  0.00298
       7     0 three  2.46       0.0363     1    -0.0141  -0.0141 
       8     0 four   2.46       0.0599     4     0.00943  0.00943
       9     0 five   2.46       0.0786     2     0.0281   0.0281 
      10     0 three  2.79       0.0363     1    -0.0141  -0.0141 
      # i 80 more rows
      
      attr(,"effect")$Asia$boot_data$d2$`carb:wt`
      # A tibble: 150 x 7
           .it  carb    wt .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0     1  1.50      0.00454     0     0.00454  0.00454
       2     0     2  1.50      0.00454     1    -0.0287  -0.0287 
       3     0     3  1.50      0.00454     0    -0.0230  -0.0230 
       4     0     4  1.50      0.00454     0    -0.0329  -0.0329 
       5     0     8  1.50      0.00454     0    -0.0335  -0.0335 
       6     0     1  1.94      0.00454     4    -0.00377 -0.00377
       7     0     2  1.94      0.0244      3    -0.0171  -0.0171 
       8     0     3  1.94      0.0244      0    -0.00721 -0.00721
       9     0     4  1.94      0.0244      0    -0.0171  -0.0171 
      10     0     8  1.94      0.0244      0    -0.0171  -0.0171 
      # i 140 more rows
      
      
      
      
      attr(,"effect")$Europe
      attr(,"effect")$Europe$ale
      attr(,"effect")$Europe$ale$d1
      attr(,"effect")$Europe$ale$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4     1     0     0       0         0     0
       2     14.4     7     0     0       0         0     0
       3     15.2     7     0     0       0         0     0
       4     16.4     7     0     0       0         0     0
       5     18.7     7     0     0       0         0     0
       6     19.8     7     0     0       0         0     0
       7     21.4     7     0     0       0         0     0
       8     22.9     7     0     0       0         0     0
       9     30.1     7     0     0       0         0     0
      10     33.9     7     0     0       0         0     0
      
      attr(,"effect")$Europe$ale$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n    .y .y_lo .y_mean .y_median .y_hi
        <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE     36     0     0       0         0     0
      2 TRUE      28     0     0       0         0     0
      
      attr(,"effect")$Europe$ale$d1$am
      # A tibble: 2 x 7
        am.bin    .n       .y   .y_lo  .y_mean .y_median   .y_hi
        <ord>  <int>    <dbl>   <dbl>    <dbl>     <dbl>   <dbl>
      1 FALSE     38 -0.00619 -0.0320 -0.00619  -0.0297  0.0396 
      2 TRUE      26 -0.0155  -0.0597 -0.0155    0.00670 0.00990
      
      attr(,"effect")$Europe$ale$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental     2  0.217  -0.164  0.217      0.166 0.641
       2 Cadillac Fleetwood      2  0.268  -0.494  0.268      0.166 1.12 
       3 Merc 450SL              2  0.931  -0.444  0.931      1.17  2.10 
       4 Merc 450SLC             2  0.764  -0.444  0.764      1.17  1.63 
       5 Camaro Z28              2 -0.0688 -1.44  -0.0688     0.166 1.10 
       6 Chrysler Imperial       2  0.0978 -0.967  0.0978     0.166 1.10 
       7 Duster 360              2  0.0978 -0.967  0.0978     0.166 1.10 
       8 Merc 450SE              2  0.596  -0.917  0.596      1.17  1.62 
       9 Hornet Sportabout       2 -0.237  -1.92  -0.237      0.166 1.10 
      10 AMC Javelin             2 -0.0841 -1.92  -0.0841     0.166 1.54 
      # i 22 more rows
      
      attr(,"effect")$Europe$ale$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n     .y   .y_lo .y_mean .y_median  .y_hi
        <ord>    <int>  <dbl>   <dbl>   <dbl>     <dbl>  <dbl>
      1 three       30 -0.239 -0.366   -0.239    -0.239 -0.112
      2 four        24  0.247  0.140    0.247     0.211  0.385
      3 five        10  0.380 -0.0309   0.380     0.594  0.609
      
      attr(,"effect")$Europe$ale$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n       .y     .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>     <dbl>    <dbl>     <dbl>    <dbl>
      1         1    14 -0.00549 -0.00549  -0.00549  -0.00549 -0.00549
      2         2    19  0.00190  0.000117  0.00190   0.00191  0.00367
      3         3     9  0.00190  0.000117  0.00190   0.00191  0.00367
      4         4    16  0.00190  0.000117  0.00190   0.00191  0.00367
      5         8     6  0.00190  0.000117  0.00190   0.00191  0.00367
      
      attr(,"effect")$Europe$ale$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n          .y       .y_lo     .y_mean   .y_median       .y_hi
           <dbl> <int>       <dbl>       <dbl>       <dbl>       <dbl>       <dbl>
       1    1.50     1 -0.0000319  -0.0000319  -0.0000319  -0.0000319  -0.0000319 
       2    1.94     7  0.00000143 -0.00000790  0.00000143  0.00000427  0.00000836
       3    2.46     7  0.00000906  0.00000385  0.00000906  0.00000787  0.0000153 
       4    2.79     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       5    3.19     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       6    3.44     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       7    3.52     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       8    3.73     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       9    4.05     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
      10    5.45     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
      
      
      attr(,"effect")$Europe$ale$d2
      attr(,"effect")$Europe$ale$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 FALSE      1     0     0       0         0     0
       2     14.4 FALSE      7     0     0       0         0     0
       3     15.2 FALSE      7     0     0       0         0     0
       4     16.4 FALSE      7     0     0       0         0     0
       5     18.7 FALSE      3     0     0       0         0     0
       6     19.8 FALSE      5     0     0       0         0     0
       7     21.4 FALSE      4     0     0       0         0     0
       8     22.9 FALSE      0     0     0       0         0     0
       9     30.1 FALSE      2     0     0       0         0     0
      10     33.9 FALSE      0     0     0       0         0     0
      11     10.4 TRUE       0     0     0       0         0     0
      12     14.4 TRUE       0     0     0       0         0     0
      13     15.2 TRUE       0     0     0       0         0     0
      14     16.4 TRUE       0     0     0       0         0     0
      15     18.7 TRUE       4     0     0       0         0     0
      16     19.8 TRUE       2     0     0       0         0     0
      17     21.4 TRUE       3     0     0       0         0     0
      18     22.9 TRUE       7     0     0       0         0     0
      19     30.1 TRUE       5     0     0       0         0     0
      20     33.9 TRUE       7     0     0       0         0     0
      
      attr(,"effect")$Europe$ale$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 FALSE      1     0     0       0         0     0
       2     14.4 FALSE      7     0     0       0         0     0
       3     15.2 FALSE      5     0     0       0         0     0
       4     16.4 FALSE      5     0     0       0         0     0
       5     18.7 FALSE      7     0     0       0         0     0
       6     19.8 FALSE      5     0     0       0         0     0
       7     21.4 FALSE      1     0     0       0         0     0
       8     22.9 FALSE      5     0     0       0         0     0
       9     30.1 FALSE      2     0     0       0         0     0
      10     33.9 FALSE      0     0     0       0         0     0
      11     10.4 TRUE       0     0     0       0         0     0
      12     14.4 TRUE       0     0     0       0         0     0
      13     15.2 TRUE       2     0     0       0         0     0
      14     16.4 TRUE       2     0     0       0         0     0
      15     18.7 TRUE       0     0     0       0         0     0
      16     19.8 TRUE       2     0     0       0         0     0
      17     21.4 TRUE       6     0     0       0         0     0
      18     22.9 TRUE       2     0     0       0         0     0
      19     30.1 TRUE       5     0     0       0         0     0
      20     33.9 TRUE       7     0     0       0         0     0
      
      attr(,"effect")$Europe$ale$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin              .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>               <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 Lincoln Continental     0     0     0       0         0     0
       2     14.4 Lincoln Continental     2     0     0       0         0     0
       3     15.2 Lincoln Continental     0     0     0       0         0     0
       4     16.4 Lincoln Continental     0     0     0       0         0     0
       5     18.7 Lincoln Continental     0     0     0       0         0     0
       6     19.8 Lincoln Continental     0     0     0       0         0     0
       7     21.4 Lincoln Continental     0     0     0       0         0     0
       8     22.9 Lincoln Continental     0     0     0       0         0     0
       9     30.1 Lincoln Continental     0     0     0       0         0     0
      10     33.9 Lincoln Continental     0     0     0       0         0     0
      # i 310 more rows
      
      attr(,"effect")$Europe$ale$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>    <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 three        1     0     0       0         0     0
       2     14.4 three        7     0     0       0         0     0
       3     15.2 three        5     0     0       0         0     0
       4     16.4 three        5     0     0       0         0     0
       5     18.7 three        5     0     0       0         0     0
       6     19.8 three        3     0     0       0         0     0
       7     21.4 three        1     0     0       0         0     0
       8     22.9 three        3     0     0       0         0     0
       9     30.1 three        0     0     0       0         0     0
      10     33.9 three        0     0     0       0         0     0
      # i 20 more rows
      
      attr(,"effect")$Europe$ale$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl>     <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4         1     0     0     0       0         0     0
       2     14.4         1     0     0     0       0         0     0
       3     15.2         1     0     0     0       0         0     0
       4     16.4         1     0     0     0       0         0     0
       5     18.7         1     2     0     0       0         0     0
       6     19.8         1     0     0     0       0         0     0
       7     21.4         1     1     0     0       0         0     0
       8     22.9         1     5     0     0       0         0     0
       9     30.1         1     2     0     0       0         0     0
      10     33.9         1     4     0     0       0         0     0
      # i 40 more rows
      
      attr(,"effect")$Europe$ale$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl>   <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4    1.50     0     0     0       0         0     0
       2     14.4    1.50     0     0     0       0         0     0
       3     15.2    1.50     0     0     0       0         0     0
       4     16.4    1.50     0     0     0       0         0     0
       5     18.7    1.50     0     0     0       0         0     0
       6     19.8    1.50     0     0     0       0         0     0
       7     21.4    1.50     0     0     0       0         0     0
       8     22.9    1.50     0     0     0       0         0     0
       9     30.1    1.50     1     0     0       0         0     0
      10     33.9    1.50     0     0     0       0         0     0
      # i 90 more rows
      
      attr(,"effect")$Europe$ale$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n    .y .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  FALSE     24     0     0       0         0     0
      2 TRUE   FALSE     14     0     0       0         0     0
      3 FALSE  TRUE      12     0     0       0         0     0
      4 TRUE   TRUE      14     0     0       0         0     0
      
      attr(,"effect")$Europe$ale$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin              .n    .y .y_lo .y_mean .y_median .y_hi
         <ord>  <ord>               <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE  Lincoln Continental     2     0     0       0         0     0
       2 TRUE   Lincoln Continental     0     0     0       0         0     0
       3 FALSE  Cadillac Fleetwood      2     0     0       0         0     0
       4 TRUE   Cadillac Fleetwood      0     0     0       0         0     0
       5 FALSE  Merc 450SL              2     0     0       0         0     0
       6 TRUE   Merc 450SL              0     0     0       0         0     0
       7 FALSE  Merc 450SLC             2     0     0       0         0     0
       8 TRUE   Merc 450SLC             0     0     0       0         0     0
       9 FALSE  Camaro Z28              2     0     0       0         0     0
      10 TRUE   Camaro Z28              0     0     0       0         0     0
      # i 54 more rows
      
      attr(,"effect")$Europe$ale$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n    .y .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>    <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  three       24     0     0       0         0     0
      2 TRUE   three        6     0     0       0         0     0
      3 FALSE  four         4     0     0       0         0     0
      4 TRUE   four        20     0     0       0         0     0
      5 FALSE  five         8     0     0       0         0     0
      6 TRUE   five         2     0     0       0         0     0
      
      attr(,"effect")$Europe$ale$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
         <ord>      <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE          1     0     0     0       0         0     0
       2 TRUE           1    14     0     0       0         0     0
       3 FALSE          2    10     0     0       0         0     0
       4 TRUE           2     9     0     0       0         0     0
       5 FALSE          3     8     0     0       0         0     0
       6 TRUE           3     1     0     0       0         0     0
       7 FALSE          4    13     0     0       0         0     0
       8 TRUE           4     3     0     0       0         0     0
       9 FALSE          8     5     0     0       0         0     0
      10 TRUE           8     1     0     0       0         0     0
      
      attr(,"effect")$Europe$ale$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
         <ord>    <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE     1.50     0     0     0       0         0     0
       2 TRUE      1.50     1     0     0       0         0     0
       3 FALSE     1.94     0     0     0       0         0     0
       4 TRUE      1.94     7     0     0       0         0     0
       5 FALSE     2.46     2     0     0       0         0     0
       6 TRUE      2.46     5     0     0       0         0     0
       7 FALSE     2.79     4     0     0       0         0     0
       8 TRUE      2.79     3     0     0       0         0     0
       9 FALSE     3.19     4     0     0       0         0     0
      10 TRUE      3.19     3     0     0       0         0     0
      11 FALSE     3.44     2     0     0       0         0     0
      12 TRUE      3.44     5     0     0       0         0     0
      13 FALSE     3.52     3     0     0       0         0     0
      14 TRUE      3.52     4     0     0       0         0     0
      15 FALSE     3.73     7     0     0       0         0     0
      16 TRUE      3.73     0     0     0       0         0     0
      17 FALSE     4.05     7     0     0       0         0     0
      18 TRUE      4.05     0     0     0       0         0     0
      19 FALSE     5.45     7     0     0       0         0     0
      20 TRUE      5.45     0     0     0       0         0     0
      
      attr(,"effect")$Europe$ale$d2$`am:model`
      # A tibble: 64 x 8
         am.bin model.bin              .n      .y  .y_lo .y_mean .y_median   .y_hi
         <ord>  <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl>   <dbl>
       1 FALSE  Lincoln Continental     2 -0.193  -1.51  -0.193    -0.327   1.24  
       2 TRUE   Lincoln Continental     0 -0.193  -0.393 -0.193    -0.0844 -0.0844
       3 FALSE  Cadillac Fleetwood      2 -0.301  -1.52  -0.301    -0.652   1.22  
       4 TRUE   Cadillac Fleetwood      0 -0.301  -0.701 -0.301    -0.0844 -0.0844
       5 FALSE  Merc 450SL              2 -0.0689 -1.52  -0.0689   -0.652   1.88  
       6 TRUE   Merc 450SL              0 -0.0689 -0.701 -0.0689   -0.0844  0.576 
       7 FALSE  Merc 450SLC             2 -0.0689 -1.52  -0.0689   -0.652   1.88  
       8 TRUE   Merc 450SLC             0 -0.0689 -0.701 -0.0689   -0.0844  0.576 
       9 FALSE  Camaro Z28              2 -0.0683 -1.52  -0.0683   -0.650   1.88  
      10 TRUE   Camaro Z28              0 -0.0683 -0.699 -0.0683   -0.0844  0.576 
      # i 54 more rows
      
      attr(,"effect")$Europe$ale$d2$`am:gear`
      # A tibble: 6 x 8
        am.bin gear.bin    .n      .y  .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  three       30 -0.0465 -0.476 -0.0465   -0.0254 0.365
      2 TRUE   three        0 -0.0465 -0.348 -0.0465   -0.212  0.395
      3 FALSE  four         8 -0.122  -0.584 -0.122    -0.145  0.359
      4 TRUE   four        16 -0.198  -0.459 -0.198    -0.385  0.222
      5 FALSE  five         0 -0.122  -0.584 -0.122    -0.145  0.359
      6 TRUE   five        10  0.0371 -0.354  0.0371   -0.183  0.615
      
      attr(,"effect")$Europe$ale$d2$`am:carb`
      # A tibble: 10 x 8
         am.bin carb.ceil    .n        .y    .y_lo   .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>     <dbl>    <dbl>     <dbl>     <dbl>    <dbl>
       1 FALSE          1     6 -0.0166   -0.137   -0.0166    -0.0166   0.104  
       2 TRUE           1     8 -0.0166   -0.0201  -0.0166    -0.0166  -0.0131 
       3 FALSE          2    12 -0.0134   -0.216   -0.0134    -0.0163   0.192  
       4 TRUE           2     7  0.000253 -0.00434  0.000253   0.00193  0.00342
       5 FALSE          3     7 -0.0134   -0.134   -0.0134    -0.0163   0.110  
       6 TRUE           3     2  0.000227 -0.0756   0.000227  -0.00468  0.0802 
       7 FALSE          4    11 -0.190    -0.229   -0.190     -0.226   -0.121  
       8 TRUE           4     5 -0.454    -0.542   -0.454     -0.464   -0.359  
       9 FALSE          8     2 -0.190    -0.228   -0.190     -0.202   -0.143  
      10 TRUE           8     4 -0.454    -0.620   -0.454     -0.377   -0.355  
      
      attr(,"effect")$Europe$ale$d2$`am:wt`
      # A tibble: 20 x 8
         am.bin wt.ceil    .n      .y   .y_lo .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 -0.0139 -0.0301 -0.0139   -0.0139  0.00238
       2 TRUE      1.50     1 -0.0139 -0.0139 -0.0139   -0.0139 -0.0138 
       3 FALSE     1.94     0 -0.0139 -0.0398 -0.0139   -0.0139  0.0122 
       4 TRUE      1.94     7 -0.0138 -0.0340 -0.0138   -0.0138  0.00634
       5 FALSE     2.46     1 -0.0138 -0.0502 -0.0138   -0.0139  0.0226 
       6 TRUE      2.46     6 -0.0138 -0.0340 -0.0138   -0.0138  0.00634
       7 FALSE     2.79     1 -0.0314 -0.0517 -0.0314   -0.0426 -0.00165
       8 TRUE      2.79     6 -0.0538 -0.0630 -0.0538   -0.0605 -0.0389 
       9 FALSE     3.19     3 -0.0481 -0.0783 -0.0481   -0.0327 -0.0310 
      10 TRUE      3.19     4 -0.100  -0.104  -0.100    -0.0987 -0.0973 
      11 FALSE     3.44     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      12 TRUE      3.44     0 -0.109  -0.122  -0.109    -0.105  -0.0990 
      13 FALSE     3.52     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      14 TRUE      3.52     0 -0.113  -0.125  -0.113    -0.114  -0.0995 
      15 FALSE     3.73     5 -0.0481 -0.0783 -0.0481   -0.0327 -0.0310 
      16 TRUE      3.73     2 -0.113  -0.124  -0.113    -0.116  -0.0995 
      17 FALSE     4.05     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      18 TRUE      4.05     0 -0.113  -0.134  -0.113    -0.105  -0.0990 
      19 FALSE     5.45     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      20 TRUE      5.45     0 -0.113  -0.134  -0.113    -0.105  -0.0990 
      
      attr(,"effect")$Europe$ale$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n     .y   .y_lo .y_mean .y_median .y_hi
         <ord>               <ord>    <int>  <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental three        2 0.185  -0.0288  0.185     0.301  0.301
       2 Cadillac Fleetwood  three        2 0.0696 -0.359   0.0696    0.301  0.301
       3 Merc 450SL          three        2 0.399  -0.359   0.399     0.301  1.24 
       4 Merc 450SLC         three        2 0.399  -0.359   0.399     0.301  1.24 
       5 Camaro Z28          three        2 0.0663 -0.832   0.0663    0.301  0.765
       6 Chrysler Imperial   three        2 0.0663 -0.450   0.0663   -0.0912 0.717
       7 Duster 360          three        2 0.0663 -0.693   0.0663    0.211  0.703
       8 Merc 450SE          three        2 0.0643 -0.692   0.0643    0.235  0.676
       9 Hornet Sportabout   three        2 0.0643 -0.533   0.0643   -0.0418 0.752
      10 AMC Javelin         three        2 0.218  -0.455   0.218     0.177  0.924
      # i 86 more rows
      
      attr(,"effect")$Europe$ale$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       2 Cadillac Fleetwood          1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       3 Merc 450SL                  1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       4 Merc 450SLC                 1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       5 Camaro Z28                  1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       6 Chrysler Imperial           1     0 -3.89  -5.43   -3.89     -5.05 -1.37
       7 Duster 360                  1     0 -3.89  -8.50   -3.89     -5.26  1.88
       8 Merc 450SE                  1     0 -3.89 -10.8    -3.89     -5.26  4.14
       9 Hornet Sportabout           1     0 -3.89 -10.8    -3.89     -5.26  4.15
      10 AMC Javelin                 1     0 -3.89 -11.1    -3.89     -5.26  4.50
      # i 150 more rows
      
      attr(,"effect")$Europe$ale$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n     .y  .y_lo .y_mean .y_median    .y_hi
         <ord>                 <dbl> <int>  <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
       1 Lincoln Continental    1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       2 Cadillac Fleetwood     1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       3 Merc 450SL             1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       4 Merc 450SLC            1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       5 Camaro Z28             1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       6 Chrysler Imperial      1.50     0 -0.403 -0.460  -0.403    -0.459 -0.297  
       7 Duster 360             1.50     0 -0.403 -0.550  -0.403    -0.459 -0.208  
       8 Merc 450SE             1.50     0 -0.403 -0.762  -0.403    -0.459  0.00423
       9 Hornet Sportabout      1.50     0 -0.403 -0.773  -0.403    -0.459  0.0150 
      10 AMC Javelin            1.50     0 -0.403 -0.780  -0.403    -0.459  0.0226 
      # i 310 more rows
      
      attr(,"effect")$Europe$ale$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n      .y   .y_lo .y_mean .y_median .y_hi
         <ord>        <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 three            1     6 0.00218 -0.0999 0.00218   0.00214 0.104
       2 four             1     8 0.00218 -0.147  0.00218  -0.00135 0.154
       3 five             1     0 0.00218 -0.150  0.00218  -0.00135 0.158
       4 three            2     8 0.00616 -0.199  0.00616   0.0106  0.208
       5 four             2     7 0.0104  -0.198  0.0104    0.0250  0.207
       6 five             2     4 0.0315  -0.0678 0.0315    0.0249  0.137
       7 three            3     7 0.00616 -0.147  0.00616   0.0106  0.155
       8 four             3     2 0.0104  -0.149  0.0104    0.0227  0.159
       9 five             3     0 0.0369  -0.152  0.0369    0.0214  0.239
      10 three            4     8 0.00616 -0.199  0.00616   0.0129  0.206
      11 four             4     6 0.0104  -0.0985 0.0104    0.0262  0.106
      12 five             4     2 0.0369  -0.0995 0.0369    0.0214  0.187
      13 three            8     1 0.00616 -0.150  0.00616   0.0106  0.158
      14 four             8     1 0.00933 -0.201  0.00933   0.0227  0.209
      15 five             8     4 0.0359  -0.155  0.0359    0.0236  0.237
      
      attr(,"effect")$Europe$ale$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n       .y   .y_lo  .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>    <dbl>   <dbl>    <dbl>     <dbl>  <dbl>
       1 three       1.50     0 -0.00213 -0.0403 -0.00213 -0.00217  0.0361
       2 four        1.50     0 -0.00213 -0.0492 -0.00213 -0.00213  0.0450
       3 five        1.50     1 -0.00213 -0.0555 -0.00213  0.000424 0.0490
       4 three       1.94     0 -0.00212 -0.0669 -0.00212  0.000451 0.0605
       5 four        1.94     6 -0.00207 -0.0881 -0.00207  0.000513 0.0818
       6 five        1.94     1 -0.00231 -0.0888 -0.00231  0.000513 0.0818
       7 three       2.46     1 -0.00212 -0.0881 -0.00212  0.000462 0.0817
       8 four        2.46     4 -0.00205 -0.0881 -0.00205  0.000523 0.0818
       9 five        2.46     2 -0.0123  -0.106  -0.0123  -0.0115   0.0812
      10 three       2.79     1 -0.00212 -0.0881 -0.00212  0.000462 0.0817
      # i 20 more rows
      
      attr(,"effect")$Europe$ale$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median      .y_hi
             <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>      <dbl>
       1         1    1.50     0 -0.00454 -0.0267  -0.00454  -0.00454  0.0176   
       2         2    1.50     1 -0.00454 -0.0361  -0.00454  -0.00454  0.0270   
       3         3    1.50     0 -0.00454 -0.0401  -0.00454  -0.00454  0.0310   
       4         4    1.50     0 -0.00454 -0.00916 -0.00454  -0.00454  0.0000810
       5         8    1.50     0 -0.00454 -0.0407  -0.00454  -0.00454  0.0316   
       6         1    1.94     4 -0.00454 -0.0346  -0.00454  -0.00454  0.0255   
       7         2    1.94     3 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
       8         3    1.94     0 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
       9         4    1.94     0 -0.0185  -0.0319  -0.0185   -0.0161  -0.00715  
      10         8    1.94     0 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
      # i 40 more rows
      
      
      
      attr(,"effect")$Europe$stats
      attr(,"effect")$Europe$stats$d1
      # A tibble: 42 x 8
         statistic estimate p.value term  conf.low  mean median conf.high
         <chr>        <dbl>   <dbl> <chr>    <dbl> <dbl>  <dbl>     <dbl>
       1 aled             0       1 mpg          0     0      0         0
       2 aler_min         0       1 mpg          0     0      0         0
       3 aler_max         0       1 mpg          0     0      0         0
       4 naled            0       0 mpg          0     0      0         0
       5 naler_min        0       1 mpg          0     0      0         0
       6 naler_max        0       0 mpg          0     0      0         0
       7 aled             0       1 vs           0     0      0         0
       8 aler_min         0       1 vs           0     0      0         0
       9 aler_max         0       1 vs           0     0      0         0
      10 naled            0       0 vs           0     0      0         0
      # i 32 more rows
      
      attr(,"effect")$Europe$stats$d2
      # A tibble: 126 x 8
         statistic estimate p.value term   conf.low  mean median conf.high
         <chr>        <dbl>   <dbl> <chr>     <dbl> <dbl>  <dbl>     <dbl>
       1 aled             0       1 mpg:vs        0     0      0         0
       2 aler_min         0       1 mpg:vs        0     0      0         0
       3 aler_max         0       1 mpg:vs        0     0      0         0
       4 naled            0       0 mpg:vs        0     0      0         0
       5 naler_min        0       1 mpg:vs        0     0      0         0
       6 naler_max        0       0 mpg:vs        0     0      0         0
       7 aled             0       1 mpg:am        0     0      0         0
       8 aler_min         0       1 mpg:am        0     0      0         0
       9 aler_max         0       1 mpg:am        0     0      0         0
      10 naled            0       0 mpg:am        0     0      0         0
      # i 116 more rows
      
      
      attr(,"effect")$Europe$boot_data
      attr(,"effect")$Europe$boot_data$d1
      attr(,"effect")$Europe$boot_data$d1$mpg
      # A tibble: 30 x 6
           .it   mpg .y_composite    .n .y_distinct    .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4            0     1           0     0
       2     0  14.4            0     7           0     0
       3     0  15.2            0     7           0     0
       4     0  16.4            0     7           0     0
       5     0  18.7            0     7           0     0
       6     0  19.8            0     7           0     0
       7     0  21.4            0     7           0     0
       8     0  22.9            0     7           0     0
       9     0  30.1            0     7           0     0
      10     0  33.9            0     7           0     0
      # i 20 more rows
      
      attr(,"effect")$Europe$boot_data$d1$vs
      # A tibble: 6 x 6
          .it vs    .y_composite    .n .y_distinct    .y
        <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
      1     0 FALSE            0    36           0     0
      2     0 TRUE             0    28           0     0
      3     1 FALSE            0    36           0     0
      4     1 TRUE             0    28           0     0
      5     2 FALSE            0    36           0     0
      6     2 TRUE             0    28           0     0
      
      attr(,"effect")$Europe$boot_data$d1$am
      # A tibble: 6 x 6
          .it am    .y_composite    .n .y_distinct       .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
      1     0 FALSE      0.0432     38     0.0432   0.0432 
      2     0 TRUE      -0.0632     26    -0.0632  -0.0632 
      3     1 FALSE     -0.0321     38    -0.0321  -0.0321 
      4     1 TRUE       0.0101     26     0.0101   0.0101 
      5     2 FALSE     -0.0297     38    -0.0297  -0.0297 
      6     2 TRUE       0.00670    26     0.00670  0.00670
      
      attr(,"effect")$Europe$boot_data$d1$model
      # A tibble: 96 x 6
           .it model               .y_composite    .n .y_distinct    .y
         <dbl> <fct>                      <dbl> <dbl>       <dbl> <dbl>
       1     0 Lincoln Continental        0.166     2       0.166 0.166
       2     0 Cadillac Fleetwood         0.166     2       0.166 0.166
       3     0 Merc 450SL                 1.17      2       1.17  1.17 
       4     0 Merc 450SLC                1.17      2       1.17  1.17 
       5     0 Camaro Z28                 0.166     2       0.166 0.166
       6     0 Chrysler Imperial          0.166     2       0.166 0.166
       7     0 Duster 360                 0.166     2       0.166 0.166
       8     0 Merc 450SE                 1.17      2       1.17  1.17 
       9     0 Hornet Sportabout          0.166     2       0.166 0.166
      10     0 AMC Javelin                0.166     2       0.166 0.166
      # i 86 more rows
      
      attr(,"effect")$Europe$boot_data$d1$gear
      # A tibble: 9 x 6
          .it gear  .y_composite    .n .y_distinct      .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>   <dbl>
      1     0 three      -0.372     30     -0.372  -0.372 
      2     0 four        0.211     24      0.211   0.211 
      3     0 five        0.610     10      0.610   0.610 
      4     1 three      -0.106     30     -0.106  -0.106 
      5     1 four        0.394     24      0.394   0.394 
      6     1 five        0.594     10      0.594   0.594 
      7     2 three      -0.239     30     -0.239  -0.239 
      8     2 four        0.136     24      0.136   0.136 
      9     2 five       -0.0638    10     -0.0638 -0.0638
      
      attr(,"effect")$Europe$boot_data$d1$carb
      # A tibble: 15 x 6
           .it  carb .y_composite    .n .y_distinct         .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>      <dbl>
       1     0     1   -0.00549      14  -0.00549   -0.00549  
       2     0     2    0.00191      19   0.00191    0.00191  
       3     0     3    0.00191       9   0.00191    0.00191  
       4     0     4    0.00191      16   0.00191    0.00191  
       5     0     8    0.00191       6   0.00191    0.00191  
       6     1     1   -0.00549      18  -0.00549   -0.00549  
       7     1     2    0.00377      16   0.00377    0.00377  
       8     1     3    0.00377      13   0.00377    0.00377  
       9     1     4    0.00377      15   0.00377    0.00377  
      10     1     8    0.00377       2   0.00377    0.00377  
      11     2     1   -0.00549      15  -0.00549   -0.00549  
      12     2     2    0.0000232    13   0.0000232  0.0000232
      13     2     3    0.0000232    13   0.0000232  0.0000232
      14     2     4    0.0000232    20   0.0000232  0.0000232
      15     2     8    0.0000232     3   0.0000232  0.0000232
      
      attr(,"effect")$Europe$boot_data$d1$wt
      # A tibble: 30 x 6
           .it    wt .y_composite    .n .y_distinct          .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>       <dbl>
       1     0  1.50  -0.0000319      1 -0.0000319  -0.0000319 
       2     0  1.94  -0.00000854     7 -0.00000854 -0.00000854
       3     0  2.46   0.00000364     7  0.00000364  0.00000364
       4     0  2.79   0.00000366     7  0.00000366  0.00000366
       5     0  3.19   0.00000366     7  0.00000366  0.00000366
       6     0  3.44   0.00000366     7  0.00000366  0.00000366
       7     0  3.52   0.00000366     7  0.00000366  0.00000366
       8     0  3.73   0.00000366     7  0.00000366  0.00000366
       9     0  4.05   0.00000366     7  0.00000366  0.00000366
      10     0  5.45   0.00000366     7  0.00000366  0.00000366
      # i 20 more rows
      
      
      attr(,"effect")$Europe$boot_data$d2
      attr(,"effect")$Europe$boot_data$d2$`mpg:vs`
      # A tibble: 60 x 7
           .it   mpg vs    .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 FALSE            0     1           0     0
       2     0  14.4 FALSE            0     7           0     0
       3     0  15.2 FALSE            0     7           0     0
       4     0  16.4 FALSE            0     7           0     0
       5     0  18.7 FALSE            0     3           0     0
       6     0  19.8 FALSE            0     5           0     0
       7     0  21.4 FALSE            0     4           0     0
       8     0  22.9 FALSE            0     0           0     0
       9     0  30.1 FALSE            0     2           0     0
      10     0  33.9 FALSE            0     0           0     0
      # i 50 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`mpg:am`
      # A tibble: 60 x 7
           .it   mpg am    .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 FALSE            0     1           0     0
       2     0  14.4 FALSE            0     7           0     0
       3     0  15.2 FALSE            0     5           0     0
       4     0  16.4 FALSE            0     5           0     0
       5     0  18.7 FALSE            0     7           0     0
       6     0  19.8 FALSE            0     5           0     0
       7     0  21.4 FALSE            0     1           0     0
       8     0  22.9 FALSE            0     5           0     0
       9     0  30.1 FALSE            0     2           0     0
      10     0  33.9 FALSE            0     0           0     0
      # i 50 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`mpg:model`
      # A tibble: 960 x 7
           .it   mpg model               .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>                      <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 Lincoln Continental            0     0           0     0
       2     0  14.4 Lincoln Continental            0     2           0     0
       3     0  15.2 Lincoln Continental            0     0           0     0
       4     0  16.4 Lincoln Continental            0     0           0     0
       5     0  18.7 Lincoln Continental            0     0           0     0
       6     0  19.8 Lincoln Continental            0     0           0     0
       7     0  21.4 Lincoln Continental            0     0           0     0
       8     0  22.9 Lincoln Continental            0     0           0     0
       9     0  30.1 Lincoln Continental            0     0           0     0
      10     0  33.9 Lincoln Continental            0     0           0     0
      # i 950 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`mpg:gear`
      # A tibble: 90 x 7
           .it   mpg gear  .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 three            0     1           0     0
       2     0  14.4 three            0     7           0     0
       3     0  15.2 three            0     5           0     0
       4     0  16.4 three            0     5           0     0
       5     0  18.7 three            0     5           0     0
       6     0  19.8 three            0     3           0     0
       7     0  21.4 three            0     1           0     0
       8     0  22.9 three            0     3           0     0
       9     0  30.1 three            0     0           0     0
      10     0  33.9 three            0     0           0     0
      # i 80 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`mpg:carb`
      # A tibble: 150 x 7
           .it   mpg  carb .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4     1            0     0           0     0
       2     0  14.4     1            0     0           0     0
       3     0  15.2     1            0     0           0     0
       4     0  16.4     1            0     0           0     0
       5     0  18.7     1            0     2           0     0
       6     0  19.8     1            0     0           0     0
       7     0  21.4     1            0     1           0     0
       8     0  22.9     1            0     5           0     0
       9     0  30.1     1            0     2           0     0
      10     0  33.9     1            0     4           0     0
      # i 140 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`mpg:wt`
      # A tibble: 300 x 7
           .it   mpg    wt .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4  1.50            0     0           0     0
       2     0  14.4  1.50            0     0           0     0
       3     0  15.2  1.50            0     0           0     0
       4     0  16.4  1.50            0     0           0     0
       5     0  18.7  1.50            0     0           0     0
       6     0  19.8  1.50            0     0           0     0
       7     0  21.4  1.50            0     0           0     0
       8     0  22.9  1.50            0     0           0     0
       9     0  30.1  1.50            0     1           0     0
      10     0  33.9  1.50            0     0           0     0
      # i 290 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`vs:am`
      # A tibble: 12 x 7
           .it vs    am    .y_composite    .n .y_distinct    .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE FALSE            0    24           0     0
       2     0 TRUE  FALSE            0    14           0     0
       3     0 FALSE TRUE             0    12           0     0
       4     0 TRUE  TRUE             0    14           0     0
       5     1 FALSE FALSE            0    24           0     0
       6     1 TRUE  FALSE            0    14           0     0
       7     1 FALSE TRUE             0    12           0     0
       8     1 TRUE  TRUE             0    14           0     0
       9     2 FALSE FALSE            0    24           0     0
      10     2 TRUE  FALSE            0    14           0     0
      11     2 FALSE TRUE             0    12           0     0
      12     2 TRUE  TRUE             0    14           0     0
      
      attr(,"effect")$Europe$boot_data$d2$`vs:model`
      # A tibble: 192 x 7
           .it vs    model               .y_composite    .n .y_distinct    .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE Lincoln Continental            0     2           0     0
       2     0 TRUE  Lincoln Continental            0     0           0     0
       3     0 FALSE Cadillac Fleetwood             0     2           0     0
       4     0 TRUE  Cadillac Fleetwood             0     0           0     0
       5     0 FALSE Merc 450SL                     0     2           0     0
       6     0 TRUE  Merc 450SL                     0     0           0     0
       7     0 FALSE Merc 450SLC                    0     2           0     0
       8     0 TRUE  Merc 450SLC                    0     0           0     0
       9     0 FALSE Camaro Z28                     0     2           0     0
      10     0 TRUE  Camaro Z28                     0     0           0     0
      # i 182 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`vs:gear`
      # A tibble: 18 x 7
           .it vs    gear  .y_composite    .n .y_distinct    .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE three            0    24           0     0
       2     0 TRUE  three            0     6           0     0
       3     0 FALSE four             0     4           0     0
       4     0 TRUE  four             0    20           0     0
       5     0 FALSE five             0     8           0     0
       6     0 TRUE  five             0     2           0     0
       7     1 FALSE three            0    24           0     0
       8     1 TRUE  three            0     6           0     0
       9     1 FALSE four             0     4           0     0
      10     1 TRUE  four             0    20           0     0
      11     1 FALSE five             0     8           0     0
      12     1 TRUE  five             0     2           0     0
      13     2 FALSE three            0    24           0     0
      14     2 TRUE  three            0     6           0     0
      15     2 FALSE four             0     4           0     0
      16     2 TRUE  four             0    20           0     0
      17     2 FALSE five             0     8           0     0
      18     2 TRUE  five             0     2           0     0
      
      attr(,"effect")$Europe$boot_data$d2$`vs:carb`
      # A tibble: 30 x 7
           .it vs     carb .y_composite    .n .y_distinct    .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE     1            0     0           0     0
       2     0 TRUE      1            0    14           0     0
       3     0 FALSE     2            0    10           0     0
       4     0 TRUE      2            0     9           0     0
       5     0 FALSE     3            0     8           0     0
       6     0 TRUE      3            0     1           0     0
       7     0 FALSE     4            0    13           0     0
       8     0 TRUE      4            0     3           0     0
       9     0 FALSE     8            0     5           0     0
      10     0 TRUE      8            0     1           0     0
      # i 20 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`vs:wt`
      # A tibble: 60 x 7
           .it vs       wt .y_composite    .n .y_distinct    .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE  1.50            0     0           0     0
       2     0 TRUE   1.50            0     1           0     0
       3     0 FALSE  1.94            0     0           0     0
       4     0 TRUE   1.94            0     7           0     0
       5     0 FALSE  2.46            0     2           0     0
       6     0 TRUE   2.46            0     5           0     0
       7     0 FALSE  2.79            0     4           0     0
       8     0 TRUE   2.79            0     3           0     0
       9     0 FALSE  3.19            0     4           0     0
      10     0 TRUE   3.19            0     3           0     0
      # i 50 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`am:model`
      # A tibble: 192 x 7
           .it am    model               .y_composite    .n .y_distinct      .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE Lincoln Continental      -0.0844     2     -1.57   -1.57  
       2     0 TRUE  Lincoln Continental      -0.0844     0     -0.0844 -0.0844
       3     0 FALSE Cadillac Fleetwood       -0.0844     2     -1.57   -1.57  
       4     0 TRUE  Cadillac Fleetwood       -0.0844     0     -0.0844 -0.0844
       5     0 FALSE Merc 450SL               -0.0844     2     -1.57   -1.57  
       6     0 TRUE  Merc 450SL               -0.0844     0     -0.0844 -0.0844
       7     0 FALSE Merc 450SLC              -0.0844     2     -1.57   -1.57  
       8     0 TRUE  Merc 450SLC              -0.0844     0     -0.0844 -0.0844
       9     0 FALSE Camaro Z28               -0.0844     2     -1.57   -1.57  
      10     0 TRUE  Camaro Z28               -0.0844     0     -0.0844 -0.0844
      # i 182 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`am:gear`
      # A tibble: 18 x 7
           .it am    gear  .y_composite    .n .y_distinct      .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE three     -0.00407    30      0.386   0.386 
       2     0 TRUE  three     -0.00407     0      0.427   0.427 
       3     0 FALSE four      -0.00407     8      0.386   0.386 
       4     0 TRUE  four      -0.177      16      0.254   0.254 
       5     0 FALSE five      -0.00407     0      0.386   0.386 
       6     0 TRUE  five       0.226      10      0.657   0.657 
       7     1 FALSE three     -0.0677     30     -0.0254 -0.0254
       8     1 TRUE  three     -0.0677      0     -0.212  -0.212 
       9     1 FALSE four      -0.187       8     -0.145  -0.145 
      10     1 TRUE  four      -0.241      16     -0.385  -0.385 
      11     1 FALSE five      -0.187       0     -0.145  -0.145 
      12     1 TRUE  five      -0.0395     10     -0.183  -0.183 
      13     2 FALSE three     -0.0677     30     -0.500  -0.500 
      14     2 TRUE  three     -0.0677      0     -0.355  -0.355 
      15     2 FALSE four      -0.176       8     -0.608  -0.608 
      16     2 TRUE  four      -0.175      16     -0.463  -0.463 
      17     2 FALSE five      -0.176       0     -0.608  -0.608 
      18     2 TRUE  five      -0.0753     10     -0.363  -0.363 
      
      attr(,"effect")$Europe$boot_data$d2$`am:carb`
      # A tibble: 30 x 7
           .it am     carb .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE     1     -0.0166      6    -0.144   -0.144  
       2     0 TRUE      1     -0.0166      8    -0.0129  -0.0129 
       3     0 FALSE     2     -0.0166     12    -0.226   -0.226  
       4     0 TRUE      2      0.00350     7     0.00350  0.00350
       5     0 FALSE     3     -0.0166      7    -0.140   -0.140  
       6     0 TRUE      3      0.00342     2    -0.0793  -0.0793 
       7     0 FALSE     4     -0.0166     11    -0.226   -0.226  
       8     0 TRUE      4     -0.550       5    -0.546   -0.546  
       9     0 FALSE     8     -0.0166      2    -0.140   -0.140  
      10     0 TRUE      8     -0.550       4    -0.633   -0.633  
      # i 20 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`am:wt`
      # A tibble: 60 x 7
           .it am       wt .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE  1.50      -0.0139     0     -0.0310 -0.0310
       2     0 TRUE   1.50      -0.0139     1     -0.0138 -0.0138
       3     0 FALSE  1.94      -0.0139     0     -0.0412 -0.0412
       4     0 TRUE   1.94      -0.0138     7     -0.0350 -0.0350
       5     0 FALSE  2.46      -0.0139     1     -0.0522 -0.0522
       6     0 TRUE   2.46      -0.0138     6     -0.0350 -0.0350
       7     0 FALSE  2.79      -0.0139     1     -0.0522 -0.0522
       8     0 TRUE   2.79      -0.0378     6     -0.0378 -0.0378
       9     0 FALSE  3.19      -0.0139     3     -0.0309 -0.0309
      10     0 TRUE   3.19      -0.0761     4     -0.0973 -0.0973
      # i 50 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`model:gear`
      # A tibble: 288 x 7
           .it model               gear  .y_composite    .n .y_distinct    .y
         <dbl> <fct>               <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0 Lincoln Continental three        0.301     2       0.301 0.301
       2     0 Cadillac Fleetwood  three        0.301     2       0.301 0.301
       3     0 Merc 450SL          three        0.301     2       0.301 0.301
       4     0 Merc 450SLC         three        0.301     2       0.301 0.301
       5     0 Camaro Z28          three        0.301     2       0.301 0.301
       6     0 Chrysler Imperial   three        0.301     2       0.759 0.759
       7     0 Duster 360          three        0.301     2       0.729 0.729
       8     0 Merc 450SE          three        0.301     2       0.235 0.235
       9     0 Hornet Sportabout   three        0.301     2       0.794 0.794
      10     0 AMC Javelin         three        0.301     2       0.964 0.964
      # i 278 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`model:carb`
      # A tibble: 480 x 7
           .it model                carb .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental     1        -3.89     0       -3.89  -3.89
       2     0 Cadillac Fleetwood      1        -3.89     0       -3.89  -3.89
       3     0 Merc 450SL              1        -3.89     0       -3.89  -3.89
       4     0 Merc 450SLC             1        -3.89     0       -3.89  -3.89
       5     0 Camaro Z28              1        -3.89     0       -3.89  -3.89
       6     0 Chrysler Imperial       1        -3.89     0       -5.45  -5.45
       7     0 Duster 360              1        -3.89     0       -8.67  -8.67
       8     0 Merc 450SE              1        -3.89     0      -11.1  -11.1 
       9     0 Hornet Sportabout       1        -3.89     0      -11.1  -11.1 
      10     0 AMC Javelin             1        -3.89     0      -11.4  -11.4 
      # i 470 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`model:wt`
      # A tibble: 960 x 7
           .it model                  wt .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental  1.50       -0.403     0      -0.403 -0.403
       2     0 Cadillac Fleetwood   1.50       -0.403     0      -0.403 -0.403
       3     0 Merc 450SL           1.50       -0.403     0      -0.403 -0.403
       4     0 Merc 450SLC          1.50       -0.403     0      -0.403 -0.403
       5     0 Camaro Z28           1.50       -0.403     0      -0.403 -0.403
       6     0 Chrysler Imperial    1.50       -0.403     0      -0.460 -0.460
       7     0 Duster 360           1.50       -0.403     0      -0.555 -0.555
       8     0 Merc 450SE           1.50       -0.403     0      -0.778 -0.778
       9     0 Hornet Sportabout    1.50       -0.403     0      -0.789 -0.789
      10     0 AMC Javelin          1.50       -0.403     0      -0.797 -0.797
      # i 950 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`gear:carb`
      # A tibble: 45 x 7
           .it gear   carb .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 three     1      0.00218     6     -0.105  -0.105 
       2     0 four      1      0.00218     8     -0.155  -0.155 
       3     0 five      1      0.00218     0     -0.158  -0.158 
       4     0 three     2      0.00218     8     -0.210  -0.210 
       5     0 four      2      0.00237     7     -0.210  -0.210 
       6     0 five      2      0.0348      4     -0.0727 -0.0727
       7     0 three     3      0.00218     7     -0.155  -0.155 
       8     0 four      3      0.00237     2     -0.158  -0.158 
       9     0 five      3      0.0510      0     -0.161  -0.161 
      10     0 three     4      0.00218     8     -0.210  -0.210 
      # i 35 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`gear:wt`
      # A tibble: 90 x 7
           .it gear     wt .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 three  1.50     -0.00213     0     -0.0423 -0.0423
       2     0 four   1.50     -0.00213     0     -0.0517 -0.0517
       3     0 five   1.50     -0.00213     1     -0.0584 -0.0584
       4     0 three  1.94     -0.00213     0     -0.0705 -0.0705
       5     0 four   1.94     -0.00210     6     -0.0927 -0.0927
       6     0 five   1.94     -0.00282     1     -0.0935 -0.0935
       7     0 three  2.46     -0.00213     1     -0.0928 -0.0928
       8     0 four   2.46     -0.00208     4     -0.0927 -0.0927
       9     0 five   2.46     -0.0208      2     -0.111  -0.111 
      10     0 three  2.79     -0.00213     1     -0.0928 -0.0928
      # i 80 more rows
      
      attr(,"effect")$Europe$boot_data$d2$`carb:wt`
      # A tibble: 150 x 7
           .it  carb    wt .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0     1  1.50     -0.00454     0    -0.0278  -0.0278 
       2     0     2  1.50     -0.00454     1    -0.0377  -0.0377 
       3     0     3  1.50     -0.00454     0    -0.0420  -0.0420 
       4     0     4  1.50     -0.00454     0    -0.00941 -0.00941
       5     0     8  1.50     -0.00454     0    -0.0426  -0.0426 
       6     0     1  1.94     -0.00454     4    -0.0361  -0.0361 
       7     0     2  1.94     -0.0244      3    -0.0659  -0.0659 
       8     0     3  1.94     -0.0244      0    -0.0659  -0.0659 
       9     0     4  1.94     -0.0244      0    -0.0327  -0.0327 
      10     0     8  1.94     -0.0244      0    -0.0659  -0.0659 
      # i 140 more rows
      
      
      
      
      attr(,"effect")$`North America`
      attr(,"effect")$`North America`$ale
      attr(,"effect")$`North America`$ale$d1
      attr(,"effect")$`North America`$ale$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4     1     0     0       0         0     0
       2     14.4     7     0     0       0         0     0
       3     15.2     7     0     0       0         0     0
       4     16.4     7     0     0       0         0     0
       5     18.7     7     0     0       0         0     0
       6     19.8     7     0     0       0         0     0
       7     21.4     7     0     0       0         0     0
       8     22.9     7     0     0       0         0     0
       9     30.1     7     0     0       0         0     0
      10     33.9     7     0     0       0         0     0
      
      attr(,"effect")$`North America`$ale$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n    .y .y_lo .y_mean .y_median .y_hi
        <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE     36     0     0       0         0     0
      2 TRUE      28     0     0       0         0     0
      
      attr(,"effect")$`North America`$ale$d1$am
      # A tibble: 2 x 7
        am.bin    .n        .y     .y_lo   .y_mean .y_median    .y_hi
        <ord>  <int>     <dbl>     <dbl>     <dbl>     <dbl>    <dbl>
      1 FALSE     38 -5.57e-10 -9.65e-10 -5.57e-10 -8.52e-10 1.02e-10
      2 TRUE      26  1.57e-10 -2.14e-10  1.57e-10 -4.72e-11 7.00e-10
      
      attr(,"effect")$`North America`$ale$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median  .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl>  <dbl>
       1 Lincoln Continental     2 -0.195  -0.811 -0.195      0.139 0.139 
       2 Cadillac Fleetwood      2 -0.361  -1.29  -0.361      0.139 0.139 
       3 Merc 450SL              2 -0.695  -1.34  -0.695     -0.861 0.0888
       4 Merc 450SLC             2 -0.529  -0.863 -0.529     -0.861 0.0888
       5 Camaro Z28              2 -0.0287 -0.813 -0.0287     0.139 0.614 
       6 Chrysler Imperial       2 -0.362  -1.29  -0.362      0.139 0.139 
       7 Duster 360              2 -0.362  -1.29  -0.362      0.139 0.139 
       8 Merc 450SE              2 -0.862  -1.81  -0.862     -0.861 0.0888
       9 Hornet Sportabout       2 -0.195  -1.29  -0.195      0.139 0.614 
      10 AMC Javelin             2 -0.362  -1.29  -0.362      0.139 0.139 
      # i 22 more rows
      
      attr(,"effect")$`North America`$ale$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n      .y   .y_lo .y_mean .y_median   .y_hi
        <ord>    <int>   <dbl>   <dbl>   <dbl>     <dbl>   <dbl>
      1 three       30  0.120   0.0527  0.120     0.0544  0.244 
      2 four        24 -0.249  -0.280  -0.249    -0.232  -0.232 
      3 five        10 -0.0498 -0.131  -0.0498   -0.0843  0.0603
      
      attr(,"effect")$`North America`$ale$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n            .y         .y_lo       .y_mean  .y_median     .y_hi
            <dbl> <int>         <dbl>         <dbl>         <dbl>      <dbl>     <dbl>
      1         1    14  0.000000108   0.000000108   0.000000108     1.08e-7  1.08e- 7
      2         2    19 -0.0000000359 -0.0000000704 -0.0000000359   -3.71e-8 -5.22e-10
      3         3     9 -0.0000000359 -0.0000000704 -0.0000000359   -3.71e-8 -5.24e-10
      4         4    16 -0.0000000359 -0.0000000704 -0.0000000359   -3.71e-8 -5.24e-10
      5         8     6 -0.0000000413 -0.0000000817 -0.0000000413   -4.13e-8 -9.49e-10
      
      attr(,"effect")$`North America`$ale$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n       .y     .y_lo  .y_mean .y_median    .y_hi
           <dbl> <int>    <dbl>     <dbl>    <dbl>     <dbl>    <dbl>
       1    1.50     1 6.60e-10  6.60e-10 6.60e-10  6.60e-10 6.60e-10
       2    1.94     7 2.64e-10 -1.50e-12 2.64e-10  1.40e-10 6.34e-10
       3    2.46     7 2.19e-10 -4.36e-11 2.19e-10  6.88e-11 6.08e-10
       4    2.79     7 2.19e-10 -4.36e-11 2.19e-10  6.88e-11 6.08e-10
       5    3.19     7 2.19e-10 -4.36e-11 2.19e-10  6.88e-11 6.08e-10
       6    3.44     7 2.19e-10 -4.29e-11 2.19e-10  6.88e-11 6.09e-10
       7    3.52     7 2.19e-10 -4.28e-11 2.19e-10  6.90e-11 6.09e-10
       8    3.73     7 2.19e-10 -4.28e-11 2.19e-10  6.89e-11 6.09e-10
       9    4.05     7 2.19e-10 -4.28e-11 2.19e-10  6.89e-11 6.09e-10
      10    5.45     7 2.19e-10 -4.28e-11 2.19e-10  6.89e-11 6.09e-10
      
      
      attr(,"effect")$`North America`$ale$d2
      attr(,"effect")$`North America`$ale$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 FALSE      1     0     0       0         0     0
       2     14.4 FALSE      7     0     0       0         0     0
       3     15.2 FALSE      7     0     0       0         0     0
       4     16.4 FALSE      7     0     0       0         0     0
       5     18.7 FALSE      3     0     0       0         0     0
       6     19.8 FALSE      5     0     0       0         0     0
       7     21.4 FALSE      4     0     0       0         0     0
       8     22.9 FALSE      0     0     0       0         0     0
       9     30.1 FALSE      2     0     0       0         0     0
      10     33.9 FALSE      0     0     0       0         0     0
      11     10.4 TRUE       0     0     0       0         0     0
      12     14.4 TRUE       0     0     0       0         0     0
      13     15.2 TRUE       0     0     0       0         0     0
      14     16.4 TRUE       0     0     0       0         0     0
      15     18.7 TRUE       4     0     0       0         0     0
      16     19.8 TRUE       2     0     0       0         0     0
      17     21.4 TRUE       3     0     0       0         0     0
      18     22.9 TRUE       7     0     0       0         0     0
      19     30.1 TRUE       5     0     0       0         0     0
      20     33.9 TRUE       7     0     0       0         0     0
      
      attr(,"effect")$`North America`$ale$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 FALSE      1     0     0       0         0     0
       2     14.4 FALSE      7     0     0       0         0     0
       3     15.2 FALSE      5     0     0       0         0     0
       4     16.4 FALSE      5     0     0       0         0     0
       5     18.7 FALSE      7     0     0       0         0     0
       6     19.8 FALSE      5     0     0       0         0     0
       7     21.4 FALSE      1     0     0       0         0     0
       8     22.9 FALSE      5     0     0       0         0     0
       9     30.1 FALSE      2     0     0       0         0     0
      10     33.9 FALSE      0     0     0       0         0     0
      11     10.4 TRUE       0     0     0       0         0     0
      12     14.4 TRUE       0     0     0       0         0     0
      13     15.2 TRUE       2     0     0       0         0     0
      14     16.4 TRUE       2     0     0       0         0     0
      15     18.7 TRUE       0     0     0       0         0     0
      16     19.8 TRUE       2     0     0       0         0     0
      17     21.4 TRUE       6     0     0       0         0     0
      18     22.9 TRUE       2     0     0       0         0     0
      19     30.1 TRUE       5     0     0       0         0     0
      20     33.9 TRUE       7     0     0       0         0     0
      
      attr(,"effect")$`North America`$ale$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin              .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>               <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 Lincoln Continental     0     0     0       0         0     0
       2     14.4 Lincoln Continental     2     0     0       0         0     0
       3     15.2 Lincoln Continental     0     0     0       0         0     0
       4     16.4 Lincoln Continental     0     0     0       0         0     0
       5     18.7 Lincoln Continental     0     0     0       0         0     0
       6     19.8 Lincoln Continental     0     0     0       0         0     0
       7     21.4 Lincoln Continental     0     0     0       0         0     0
       8     22.9 Lincoln Continental     0     0     0       0         0     0
       9     30.1 Lincoln Continental     0     0     0       0         0     0
      10     33.9 Lincoln Continental     0     0     0       0         0     0
      # i 310 more rows
      
      attr(,"effect")$`North America`$ale$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl> <ord>    <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4 three        1     0     0       0         0     0
       2     14.4 three        7     0     0       0         0     0
       3     15.2 three        5     0     0       0         0     0
       4     16.4 three        5     0     0       0         0     0
       5     18.7 three        5     0     0       0         0     0
       6     19.8 three        3     0     0       0         0     0
       7     21.4 three        1     0     0       0         0     0
       8     22.9 three        3     0     0       0         0     0
       9     30.1 three        0     0     0       0         0     0
      10     33.9 three        0     0     0       0         0     0
      # i 20 more rows
      
      attr(,"effect")$`North America`$ale$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl>     <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4         1     0     0     0       0         0     0
       2     14.4         1     0     0     0       0         0     0
       3     15.2         1     0     0     0       0         0     0
       4     16.4         1     0     0     0       0         0     0
       5     18.7         1     2     0     0       0         0     0
       6     19.8         1     0     0     0       0         0     0
       7     21.4         1     1     0     0       0         0     0
       8     22.9         1     5     0     0       0         0     0
       9     30.1         1     2     0     0       0         0     0
      10     33.9         1     4     0     0       0         0     0
      # i 40 more rows
      
      attr(,"effect")$`North America`$ale$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
            <dbl>   <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1     10.4    1.50     0     0     0       0         0     0
       2     14.4    1.50     0     0     0       0         0     0
       3     15.2    1.50     0     0     0       0         0     0
       4     16.4    1.50     0     0     0       0         0     0
       5     18.7    1.50     0     0     0       0         0     0
       6     19.8    1.50     0     0     0       0         0     0
       7     21.4    1.50     0     0     0       0         0     0
       8     22.9    1.50     0     0     0       0         0     0
       9     30.1    1.50     1     0     0       0         0     0
      10     33.9    1.50     0     0     0       0         0     0
      # i 90 more rows
      
      attr(,"effect")$`North America`$ale$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n    .y .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>  <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  FALSE     24     0     0       0         0     0
      2 TRUE   FALSE     14     0     0       0         0     0
      3 FALSE  TRUE      12     0     0       0         0     0
      4 TRUE   TRUE      14     0     0       0         0     0
      
      attr(,"effect")$`North America`$ale$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin              .n    .y .y_lo .y_mean .y_median .y_hi
         <ord>  <ord>               <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE  Lincoln Continental     2     0     0       0         0     0
       2 TRUE   Lincoln Continental     0     0     0       0         0     0
       3 FALSE  Cadillac Fleetwood      2     0     0       0         0     0
       4 TRUE   Cadillac Fleetwood      0     0     0       0         0     0
       5 FALSE  Merc 450SL              2     0     0       0         0     0
       6 TRUE   Merc 450SL              0     0     0       0         0     0
       7 FALSE  Merc 450SLC             2     0     0       0         0     0
       8 TRUE   Merc 450SLC             0     0     0       0         0     0
       9 FALSE  Camaro Z28              2     0     0       0         0     0
      10 TRUE   Camaro Z28              0     0     0       0         0     0
      # i 54 more rows
      
      attr(,"effect")$`North America`$ale$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n    .y .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>    <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  three       24     0     0       0         0     0
      2 TRUE   three        6     0     0       0         0     0
      3 FALSE  four         4     0     0       0         0     0
      4 TRUE   four        20     0     0       0         0     0
      5 FALSE  five         8     0     0       0         0     0
      6 TRUE   five         2     0     0       0         0     0
      
      attr(,"effect")$`North America`$ale$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
         <ord>      <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE          1     0     0     0       0         0     0
       2 TRUE           1    14     0     0       0         0     0
       3 FALSE          2    10     0     0       0         0     0
       4 TRUE           2     9     0     0       0         0     0
       5 FALSE          3     8     0     0       0         0     0
       6 TRUE           3     1     0     0       0         0     0
       7 FALSE          4    13     0     0       0         0     0
       8 TRUE           4     3     0     0       0         0     0
       9 FALSE          8     5     0     0       0         0     0
      10 TRUE           8     1     0     0       0         0     0
      
      attr(,"effect")$`North America`$ale$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n    .y .y_lo .y_mean .y_median .y_hi
         <ord>    <dbl> <int> <dbl> <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE     1.50     0     0     0       0         0     0
       2 TRUE      1.50     1     0     0       0         0     0
       3 FALSE     1.94     0     0     0       0         0     0
       4 TRUE      1.94     7     0     0       0         0     0
       5 FALSE     2.46     2     0     0       0         0     0
       6 TRUE      2.46     5     0     0       0         0     0
       7 FALSE     2.79     4     0     0       0         0     0
       8 TRUE      2.79     3     0     0       0         0     0
       9 FALSE     3.19     4     0     0       0         0     0
      10 TRUE      3.19     3     0     0       0         0     0
      11 FALSE     3.44     2     0     0       0         0     0
      12 TRUE      3.44     5     0     0       0         0     0
      13 FALSE     3.52     3     0     0       0         0     0
      14 TRUE      3.52     4     0     0       0         0     0
      15 FALSE     3.73     7     0     0       0         0     0
      16 TRUE      3.73     0     0     0       0         0     0
      17 FALSE     4.05     7     0     0       0         0     0
      18 TRUE      4.05     0     0     0       0         0     0
      19 FALSE     5.45     7     0     0       0         0     0
      20 TRUE      5.45     0     0     0       0         0     0
      
      attr(,"effect")$`North America`$ale$d2$`am:model`
      # A tibble: 64 x 8
         am.bin model.bin              .n      .y   .y_lo .y_mean .y_median   .y_hi
         <ord>  <ord>               <int>   <dbl>   <dbl>   <dbl>     <dbl>   <dbl>
       1 FALSE  Lincoln Continental     2 -0.0218 -0.0218 -0.0218   -0.0218 -0.0218
       2 TRUE   Lincoln Continental     0 -0.0218 -1.43   -0.0218    0.0596  1.32  
       3 FALSE  Cadillac Fleetwood      2 -0.0218 -0.0218 -0.0218   -0.0218 -0.0218
       4 TRUE   Cadillac Fleetwood      0 -0.0218 -1.43   -0.0218    0.0596  1.32  
       5 FALSE  Merc 450SL              2 -0.0226 -0.0241 -0.0226   -0.0218 -0.0218
       6 TRUE   Merc 450SL              0 -0.0226 -1.43   -0.0226    0.0596  1.31  
       7 FALSE  Merc 450SLC             2 -0.0226 -0.0241 -0.0226   -0.0218 -0.0218
       8 TRUE   Merc 450SLC             0 -0.0226 -1.43   -0.0226    0.0596  1.31  
       9 FALSE  Camaro Z28              2 -0.0226 -0.0241 -0.0226   -0.0218 -0.0218
      10 TRUE   Camaro Z28              0 -0.0226 -1.43   -0.0226    0.0596  1.31  
      # i 54 more rows
      
      attr(,"effect")$`North America`$ale$d2$`am:gear`
      # A tibble: 6 x 8
        am.bin gear.bin    .n    .y  .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>    <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  three       30 0.139 -0.101   0.139     0.205 0.323
      2 TRUE   three        0 0.139 -0.605   0.139     0.170 0.858
      3 FALSE  four         8 0.313  0.153   0.313     0.205 0.566
      4 TRUE   four        16 0.631 -0.263   0.631     0.746 1.43 
      5 FALSE  five         0 0.313  0.153   0.313     0.205 0.566
      6 TRUE   five        10 0.728 -0.259   0.728     0.843 1.62 
      
      attr(,"effect")$`North America`$ale$d2$`am:carb`
      # A tibble: 10 x 8
         am.bin carb.ceil    .n            .y        .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>         <dbl>        <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     6 -0.0000000460 -0.00351     -4.60e-8   2.63e-8  3.51e-3
       2 TRUE           1     8 -0.0000000460 -0.117       -4.60e-8   2.47e-7  1.17e-1
       3 FALSE          2    12 -0.000000106  -0.0786      -1.06e-7   2.31e-8  7.86e-2
       4 TRUE           2     7 -0.000000373  -0.121       -3.73e-7  -5.45e-8  1.21e-1
       5 FALSE          3     7 -0.000000106  -0.00351     -1.06e-7   2.19e-8  3.50e-3
       6 TRUE           3     2 -0.000000373  -0.199       -3.73e-7   1.90e-8  1.99e-1
       7 FALSE          4    11 -0.000000109  -0.000000220 -1.09e-7  -5.33e-8 -4.64e-8
       8 TRUE           4     5 -0.000000380  -0.117       -3.80e-7   1.25e-8  1.17e-1
       9 FALSE          8     2 -0.000000110  -0.0786      -1.10e-7   1.95e-8  7.86e-2
      10 TRUE           8     4 -0.000000380  -0.199       -3.80e-7   1.30e-8  1.99e-1
      
      attr(,"effect")$`North America`$ale$d2$`am:wt`
      # A tibble: 20 x 8
         am.bin wt.ceil    .n        .y     .y_lo   .y_mean .y_median         .y_hi
         <ord>    <dbl> <int>     <dbl>     <dbl>     <dbl>     <dbl>         <dbl>
       1 FALSE     1.50     0  9.93e-11 -1.11e- 5  9.93e-11  4.34e-10 0.0000111    
       2 TRUE      1.50     1  9.93e-11 -1.62e- 2  9.93e-11  5.51e-10 0.0162       
       3 FALSE     1.94     0  9.85e-11 -2.01e- 2  9.85e-11 -1.47e-10 0.0201       
       4 TRUE      1.94     7 -4.37e-10 -3.64e- 2 -4.37e-10 -5.09e-11 0.0364       
       5 FALSE     2.46     1  7.33e-11 -2.01e- 2  7.33e-11 -1.75e-10 0.0201       
       6 TRUE      2.46     6 -5.10e-10 -3.64e- 2 -5.10e-10 -7.93e-11 0.0364       
       7 FALSE     2.79     1  1.10e- 9  1.67e-10  1.10e- 9  1.45e- 9 0.00000000174
       8 TRUE      2.79     6  1.32e- 9 -1.62e- 2  1.32e- 9  3.23e- 9 0.0162       
       9 FALSE     3.19     3  1.34e- 9 -9.74e- 3  1.34e- 9  1.51e- 9 0.00974      
      10 TRUE      3.19     4  1.56e- 9 -3.64e- 2  1.56e- 9  2.66e- 9 0.0364       
      11 FALSE     3.44     7  1.34e- 9 -2.01e- 2  1.34e- 9  1.51e- 9 0.0201       
      12 TRUE      3.44     0  1.56e- 9 -3.64e- 2  1.56e- 9  2.66e- 9 0.0364       
      13 FALSE     3.52     7  1.34e- 9 -2.01e- 2  1.34e- 9  1.51e- 9 0.0201       
      14 TRUE      3.52     0  1.56e- 9 -1.62e- 2  1.56e- 9  2.90e- 9 0.0162       
      15 FALSE     3.73     5  1.34e- 9 -1.69e- 5  1.34e- 9  2.11e- 9 0.0000169    
      16 TRUE      3.73     2  1.56e- 9 -2.60e- 2  1.56e- 9  2.66e- 9 0.0260       
      17 FALSE     4.05     7  1.34e- 9 -2.01e- 2  1.34e- 9  1.51e- 9 0.0201       
      18 TRUE      4.05     0  1.56e- 9 -3.64e- 2  1.56e- 9  2.66e- 9 0.0364       
      19 FALSE     5.45     7  1.34e- 9 -2.01e- 2  1.34e- 9  1.51e- 9 0.0201       
      20 TRUE      5.45     0  1.56e- 9 -3.64e- 2  1.56e- 9  2.66e- 9 0.0364       
      
      attr(,"effect")$`North America`$ale$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n     .y  .y_lo .y_mean .y_median  .y_hi
         <ord>               <ord>    <int>  <dbl>  <dbl>   <dbl>     <dbl>  <dbl>
       1 Lincoln Continental three        2 -0.117 -0.117  -0.117   -0.117  -0.117
       2 Cadillac Fleetwood  three        2 -0.117 -0.117  -0.117   -0.117  -0.117
       3 Merc 450SL          three        2 -0.119 -0.122  -0.119   -0.117  -0.117
       4 Merc 450SLC         three        2 -0.285 -0.596  -0.285   -0.117  -0.117
       5 Camaro Z28          three        2 -0.455 -1.08   -0.455   -0.117  -0.117
       6 Chrysler Imperial   three        2 -0.289 -1.42   -0.289    0.305   0.337
       7 Duster 360          three        2 -0.289 -1.15   -0.289    0.0335  0.303
       8 Merc 450SE          three        2 -0.289 -1.15   -0.289    0.0334  0.303
       9 Hornet Sportabout   three        2 -0.289 -1.59   -0.289    0.398   0.432
      10 AMC Javelin         three        2 -0.125 -1.13   -0.125    0.285   0.534
      # i 86 more rows
      
      attr(,"effect")$`North America`$ale$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0 0.471  0.471   0.471     0.471 0.471
       2 Cadillac Fleetwood          1     0 0.471  0.471   0.471     0.471 0.471
       3 Merc 450SL                  1     0 0.471  0.471   0.471     0.471 0.471
       4 Merc 450SLC                 1     0 0.471  0.471   0.471     0.471 0.471
       5 Camaro Z28                  1     0 0.471  0.471   0.471     0.471 0.471
       6 Chrysler Imperial           1     0 0.471 -1.49    0.471    -0.690 3.42 
       7 Duster 360                  1     0 0.471 -5.32    0.471    -0.895 7.42 
       8 Merc 450SE                  1     0 0.471 -6.40    0.471    -0.895 8.51 
       9 Hornet Sportabout           1     0 0.471 -6.67    0.471    -0.895 8.77 
      10 AMC Javelin                 1     0 0.471 -6.76    0.471    -0.895 8.87 
      # i 150 more rows
      
      attr(,"effect")$`North America`$ale$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>                 <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 Lincoln Continental    1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       2 Cadillac Fleetwood     1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       3 Merc 450SL             1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       4 Merc 450SLC            1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       5 Camaro Z28             1.50     0 0.0603  0.0527   0.0603   0.0602  0.0681
       6 Chrysler Imperial      1.50     0 0.0603  0.00257  0.0603   0.00402 0.166 
       7 Duster 360             1.50     0 0.0603 -0.239    0.0603   0.00402 0.407 
       8 Merc 450SE             1.50     0 0.0603 -0.301    0.0603   0.00402 0.470 
       9 Hornet Sportabout      1.50     0 0.0603 -0.317    0.0603   0.00402 0.486 
      10 AMC Javelin            1.50     0 0.0603 -0.317    0.0603   0.00402 0.486 
      # i 310 more rows
      
      attr(,"effect")$`North America`$ale$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n      .y  .y_lo .y_mean .y_median    .y_hi
         <ord>        <dbl> <int>   <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
       1 three            1     6 -0.0306 -0.106 -0.0306   -0.0663  0.0748 
       2 four             1     8 -0.0306 -0.153 -0.0306   -0.0698  0.125  
       3 five             1     0 -0.0306 -0.156 -0.0306   -0.0698  0.128  
       4 three            2     8 -0.0331 -0.206 -0.0331   -0.0775  0.177  
       5 four             2     7 -0.129  -0.341 -0.129    -0.227   0.167  
       6 five             2     4 -0.129  -0.241 -0.129    -0.226   0.0664 
       7 three            3     7 -0.0403 -0.154 -0.0403   -0.0940  0.119  
       8 four             3     2 -0.159  -0.322 -0.159    -0.257   0.0858 
       9 five             3     0 -0.160  -0.374 -0.160    -0.257   0.135  
      10 three            4     8 -0.0518 -0.208 -0.0518   -0.112   0.155  
      11 four             4     6 -0.317  -0.437 -0.317    -0.427  -0.105  
      12 five             4     2 -0.322  -0.494 -0.322    -0.433  -0.0547 
      13 three            8     1 -0.0518 -0.158 -0.0518   -0.114   0.108  
      14 four             8     1 -0.317  -0.534 -0.317    -0.431  -0.00255
      15 five             8     4 -0.321  -0.544 -0.321    -0.432  -0.00476
      
      attr(,"effect")$`North America`$ale$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n      .y   .y_lo .y_mean .y_median   .y_hi
         <ord>      <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl>   <dbl>
       1 three       1.50     0 -0.0342 -0.0869 -0.0342   -0.0210 0.00727
       2 four        1.50     0 -0.0342 -0.0958 -0.0342   -0.0210 0.0162 
       3 five        1.50     1 -0.0342 -0.102  -0.0342   -0.0184 0.0202 
       4 three       1.94     0 -0.0448 -0.115  -0.0448   -0.0504 0.0301 
       5 four        1.94     6 -0.0529 -0.152  -0.0529   -0.0553 0.0484 
       6 five        1.94     1 -0.0529 -0.152  -0.0529   -0.0553 0.0484 
       7 three       2.46     1 -0.0466 -0.137  -0.0466   -0.0557 0.0510 
       8 four        2.46     4 -0.0603 -0.159  -0.0603   -0.0648 0.0428 
       9 five        2.46     2 -0.0603 -0.159  -0.0603   -0.0648 0.0428 
      10 three       2.79     1 -0.0468 -0.137  -0.0468   -0.0559 0.0509 
      # i 20 more rows
      
      attr(,"effect")$`North America`$ale$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n           .y    .y_lo      .y_mean .y_median   .y_hi
             <dbl>   <dbl> <int>        <dbl>    <dbl>        <dbl>     <dbl>   <dbl>
       1         1    1.50     0 0.0000000171 -0.0315  0.0000000171  -1.68e-7 0.0315 
       2         2    1.50     1 0.0000000171 -0.00404 0.0000000171  -1.03e-8 0.00404
       3         3    1.50     0 0.0000000171 -0.0356  0.0000000171  -1.96e-7 0.0356 
       4         4    1.50     0 0.0000000171 -0.0267  0.0000000171  -1.34e-7 0.0267 
       5         8    1.50     0 0.0000000171 -0.0362  0.0000000171  -1.95e-7 0.0362 
       6         1    1.94     4 0.0000000171 -0.0394  0.0000000171  -1.98e-7 0.0394 
       7         2    1.94     3 0.000000105  -0.00790 0.000000105   -5.22e-9 0.00790
       8         3    1.94     0 0.000000105  -0.0394  0.000000105   -1.91e-7 0.0394 
       9         4    1.94     0 0.000000105  -0.0300  0.000000105   -1.26e-7 0.0300 
      10         8    1.94     0 0.000000105  -0.0394  0.000000105   -1.88e-7 0.0394 
      # i 40 more rows
      
      
      
      attr(,"effect")$`North America`$stats
      attr(,"effect")$`North America`$stats$d1
      # A tibble: 42 x 8
         statistic estimate p.value term  conf.low  mean median conf.high
         <chr>        <dbl>   <dbl> <chr>    <dbl> <dbl>  <dbl>     <dbl>
       1 aled             0       1 mpg          0     0      0         0
       2 aler_min         0       1 mpg          0     0      0         0
       3 aler_max         0       1 mpg          0     0      0         0
       4 naled            0       0 mpg          0     0      0         0
       5 naler_min        0       1 mpg          0     0      0         0
       6 naler_max        0       0 mpg          0     0      0         0
       7 aled             0       1 vs           0     0      0         0
       8 aler_min         0       1 vs           0     0      0         0
       9 aler_max         0       1 vs           0     0      0         0
      10 naled            0       0 vs           0     0      0         0
      # i 32 more rows
      
      attr(,"effect")$`North America`$stats$d2
      # A tibble: 126 x 8
         statistic estimate p.value term   conf.low  mean median conf.high
         <chr>        <dbl>   <dbl> <chr>     <dbl> <dbl>  <dbl>     <dbl>
       1 aled             0       1 mpg:vs        0     0      0         0
       2 aler_min         0       1 mpg:vs        0     0      0         0
       3 aler_max         0       1 mpg:vs        0     0      0         0
       4 naled            0       0 mpg:vs        0     0      0         0
       5 naler_min        0       1 mpg:vs        0     0      0         0
       6 naler_max        0       0 mpg:vs        0     0      0         0
       7 aled             0       1 mpg:am        0     0      0         0
       8 aler_min         0       1 mpg:am        0     0      0         0
       9 aler_max         0       1 mpg:am        0     0      0         0
      10 naled            0       0 mpg:am        0     0      0         0
      # i 116 more rows
      
      
      attr(,"effect")$`North America`$boot_data
      attr(,"effect")$`North America`$boot_data$d1
      attr(,"effect")$`North America`$boot_data$d1$mpg
      # A tibble: 30 x 6
           .it   mpg .y_composite    .n .y_distinct    .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4            0     1           0     0
       2     0  14.4            0     7           0     0
       3     0  15.2            0     7           0     0
       4     0  16.4            0     7           0     0
       5     0  18.7            0     7           0     0
       6     0  19.8            0     7           0     0
       7     0  21.4            0     7           0     0
       8     0  22.9            0     7           0     0
       9     0  30.1            0     7           0     0
      10     0  33.9            0     7           0     0
      # i 20 more rows
      
      attr(,"effect")$`North America`$boot_data$d1$vs
      # A tibble: 6 x 6
          .it vs    .y_composite    .n .y_distinct    .y
        <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
      1     0 FALSE            0    36           0     0
      2     0 TRUE             0    28           0     0
      3     1 FALSE            0    36           0     0
      4     1 TRUE             0    28           0     0
      5     2 FALSE            0    36           0     0
      6     2 TRUE             0    28           0     0
      
      attr(,"effect")$`North America`$boot_data$d1$am
      # A tibble: 6 x 6
          .it am    .y_composite    .n .y_distinct        .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>     <dbl>
      1     0 FALSE     1.52e-10    38    1.52e-10  1.52e-10
      2     0 TRUE     -2.23e-10    26   -2.23e-10 -2.23e-10
      3     1 FALSE    -9.71e-10    38   -9.71e-10 -9.71e-10
      4     1 TRUE      7.39e-10    26    7.39e-10  7.39e-10
      5     2 FALSE    -8.52e-10    38   -8.52e-10 -8.52e-10
      6     2 TRUE     -4.72e-11    26   -4.72e-11 -4.72e-11
      
      attr(,"effect")$`North America`$boot_data$d1$model
      # A tibble: 96 x 6
           .it model               .y_composite    .n .y_distinct     .y
         <dbl> <fct>                      <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental        0.139     2       0.139  0.139
       2     0 Cadillac Fleetwood         0.139     2       0.139  0.139
       3     0 Merc 450SL                -0.861     2      -0.861 -0.861
       4     0 Merc 450SLC               -0.861     2      -0.861 -0.861
       5     0 Camaro Z28                 0.139     2       0.139  0.139
       6     0 Chrysler Imperial          0.139     2       0.139  0.139
       7     0 Duster 360                 0.139     2       0.139  0.139
       8     0 Merc 450SE                -0.861     2      -0.861 -0.861
       9     0 Hornet Sportabout          0.139     2       0.139  0.139
      10     0 AMC Javelin                0.139     2       0.139  0.139
      # i 86 more rows
      
      attr(,"effect")$`North America`$boot_data$d1$gear
      # A tibble: 9 x 6
          .it gear  .y_composite    .n .y_distinct      .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>   <dbl>
      1     0 three       0.254     30      0.254   0.254 
      2     0 four       -0.283     24     -0.283  -0.283 
      3     0 five       -0.0843    10     -0.0843 -0.0843
      4     1 three       0.0526    30      0.0526  0.0526
      5     1 four       -0.232     24     -0.232  -0.232 
      6     1 five       -0.133     10     -0.133  -0.133 
      7     2 three       0.0544    30      0.0544  0.0544
      8     2 four       -0.232     24     -0.232  -0.232 
      9     2 five        0.0679    10      0.0679  0.0679
      
      attr(,"effect")$`North America`$boot_data$d1$carb
      # A tibble: 15 x 6
           .it  carb .y_composite    .n .y_distinct       .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0     1      1.08e-7    14     1.08e-7  1.08e-7
       2     0     2     -3.71e-8    19    -3.71e-8 -3.71e-8
       3     0     3     -3.71e-8     9    -3.71e-8 -3.71e-8
       4     0     4     -3.71e-8    16    -3.71e-8 -3.71e-8
       5     0     8     -4.13e-8     6    -4.13e-8 -4.13e-8
       6     1     1      1.08e-7    18     1.08e-7  1.08e-7
       7     1     2     -7.21e-8    16    -7.21e-8 -7.21e-8
       8     1     3     -7.21e-8    13    -7.21e-8 -7.21e-8
       9     1     4     -7.21e-8    15    -7.21e-8 -7.21e-8
      10     1     8     -8.38e-8     2    -8.38e-8 -8.38e-8
      11     2     1      1.08e-7    15     1.08e-7  1.08e-7
      12     2     2      1.40e-9    13     1.40e-9  1.40e-9
      13     2     3      1.40e-9    13     1.40e-9  1.40e-9
      14     2     4      1.40e-9    20     1.40e-9  1.40e-9
      15     2     8      1.17e-9     3     1.17e-9  1.17e-9
      
      attr(,"effect")$`North America`$boot_data$d1$wt
      # A tibble: 30 x 6
           .it    wt .y_composite    .n .y_distinct        .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>     <dbl>
       1     0  1.50     6.60e-10     1    6.60e-10  6.60e-10
       2     0  1.94    -8.93e-12     7   -8.93e-12 -8.93e-12
       3     0  2.46    -4.95e-11     7   -4.95e-11 -4.95e-11
       4     0  2.79    -4.95e-11     7   -4.95e-11 -4.95e-11
       5     0  3.19    -4.95e-11     7   -4.95e-11 -4.95e-11
       6     0  3.44    -4.87e-11     7   -4.87e-11 -4.87e-11
       7     0  3.52    -4.87e-11     7   -4.87e-11 -4.87e-11
       8     0  3.73    -4.87e-11     7   -4.87e-11 -4.87e-11
       9     0  4.05    -4.87e-11     7   -4.87e-11 -4.87e-11
      10     0  5.45    -4.87e-11     7   -4.87e-11 -4.87e-11
      # i 20 more rows
      
      
      attr(,"effect")$`North America`$boot_data$d2
      attr(,"effect")$`North America`$boot_data$d2$`mpg:vs`
      # A tibble: 60 x 7
           .it   mpg vs    .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 FALSE            0     1           0     0
       2     0  14.4 FALSE            0     7           0     0
       3     0  15.2 FALSE            0     7           0     0
       4     0  16.4 FALSE            0     7           0     0
       5     0  18.7 FALSE            0     3           0     0
       6     0  19.8 FALSE            0     5           0     0
       7     0  21.4 FALSE            0     4           0     0
       8     0  22.9 FALSE            0     0           0     0
       9     0  30.1 FALSE            0     2           0     0
      10     0  33.9 FALSE            0     0           0     0
      # i 50 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`mpg:am`
      # A tibble: 60 x 7
           .it   mpg am    .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 FALSE            0     1           0     0
       2     0  14.4 FALSE            0     7           0     0
       3     0  15.2 FALSE            0     5           0     0
       4     0  16.4 FALSE            0     5           0     0
       5     0  18.7 FALSE            0     7           0     0
       6     0  19.8 FALSE            0     5           0     0
       7     0  21.4 FALSE            0     1           0     0
       8     0  22.9 FALSE            0     5           0     0
       9     0  30.1 FALSE            0     2           0     0
      10     0  33.9 FALSE            0     0           0     0
      # i 50 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`mpg:model`
      # A tibble: 960 x 7
           .it   mpg model               .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>                      <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 Lincoln Continental            0     0           0     0
       2     0  14.4 Lincoln Continental            0     2           0     0
       3     0  15.2 Lincoln Continental            0     0           0     0
       4     0  16.4 Lincoln Continental            0     0           0     0
       5     0  18.7 Lincoln Continental            0     0           0     0
       6     0  19.8 Lincoln Continental            0     0           0     0
       7     0  21.4 Lincoln Continental            0     0           0     0
       8     0  22.9 Lincoln Continental            0     0           0     0
       9     0  30.1 Lincoln Continental            0     0           0     0
      10     0  33.9 Lincoln Continental            0     0           0     0
      # i 950 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`mpg:gear`
      # A tibble: 90 x 7
           .it   mpg gear  .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4 three            0     1           0     0
       2     0  14.4 three            0     7           0     0
       3     0  15.2 three            0     5           0     0
       4     0  16.4 three            0     5           0     0
       5     0  18.7 three            0     5           0     0
       6     0  19.8 three            0     3           0     0
       7     0  21.4 three            0     1           0     0
       8     0  22.9 three            0     3           0     0
       9     0  30.1 three            0     0           0     0
      10     0  33.9 three            0     0           0     0
      # i 80 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`mpg:carb`
      # A tibble: 150 x 7
           .it   mpg  carb .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4     1            0     0           0     0
       2     0  14.4     1            0     0           0     0
       3     0  15.2     1            0     0           0     0
       4     0  16.4     1            0     0           0     0
       5     0  18.7     1            0     2           0     0
       6     0  19.8     1            0     0           0     0
       7     0  21.4     1            0     1           0     0
       8     0  22.9     1            0     5           0     0
       9     0  30.1     1            0     2           0     0
      10     0  33.9     1            0     4           0     0
      # i 140 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`mpg:wt`
      # A tibble: 300 x 7
           .it   mpg    wt .y_composite    .n .y_distinct    .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0  10.4  1.50            0     0           0     0
       2     0  14.4  1.50            0     0           0     0
       3     0  15.2  1.50            0     0           0     0
       4     0  16.4  1.50            0     0           0     0
       5     0  18.7  1.50            0     0           0     0
       6     0  19.8  1.50            0     0           0     0
       7     0  21.4  1.50            0     0           0     0
       8     0  22.9  1.50            0     0           0     0
       9     0  30.1  1.50            0     1           0     0
      10     0  33.9  1.50            0     0           0     0
      # i 290 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`vs:am`
      # A tibble: 12 x 7
           .it vs    am    .y_composite    .n .y_distinct    .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE FALSE            0    24           0     0
       2     0 TRUE  FALSE            0    14           0     0
       3     0 FALSE TRUE             0    12           0     0
       4     0 TRUE  TRUE             0    14           0     0
       5     1 FALSE FALSE            0    24           0     0
       6     1 TRUE  FALSE            0    14           0     0
       7     1 FALSE TRUE             0    12           0     0
       8     1 TRUE  TRUE             0    14           0     0
       9     2 FALSE FALSE            0    24           0     0
      10     2 TRUE  FALSE            0    14           0     0
      11     2 FALSE TRUE             0    12           0     0
      12     2 TRUE  TRUE             0    14           0     0
      
      attr(,"effect")$`North America`$boot_data$d2$`vs:model`
      # A tibble: 192 x 7
           .it vs    model               .y_composite    .n .y_distinct    .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE Lincoln Continental            0     2           0     0
       2     0 TRUE  Lincoln Continental            0     0           0     0
       3     0 FALSE Cadillac Fleetwood             0     2           0     0
       4     0 TRUE  Cadillac Fleetwood             0     0           0     0
       5     0 FALSE Merc 450SL                     0     2           0     0
       6     0 TRUE  Merc 450SL                     0     0           0     0
       7     0 FALSE Merc 450SLC                    0     2           0     0
       8     0 TRUE  Merc 450SLC                    0     0           0     0
       9     0 FALSE Camaro Z28                     0     2           0     0
      10     0 TRUE  Camaro Z28                     0     0           0     0
      # i 182 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`vs:gear`
      # A tibble: 18 x 7
           .it vs    gear  .y_composite    .n .y_distinct    .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE three            0    24           0     0
       2     0 TRUE  three            0     6           0     0
       3     0 FALSE four             0     4           0     0
       4     0 TRUE  four             0    20           0     0
       5     0 FALSE five             0     8           0     0
       6     0 TRUE  five             0     2           0     0
       7     1 FALSE three            0    24           0     0
       8     1 TRUE  three            0     6           0     0
       9     1 FALSE four             0     4           0     0
      10     1 TRUE  four             0    20           0     0
      11     1 FALSE five             0     8           0     0
      12     1 TRUE  five             0     2           0     0
      13     2 FALSE three            0    24           0     0
      14     2 TRUE  three            0     6           0     0
      15     2 FALSE four             0     4           0     0
      16     2 TRUE  four             0    20           0     0
      17     2 FALSE five             0     8           0     0
      18     2 TRUE  five             0     2           0     0
      
      attr(,"effect")$`North America`$boot_data$d2$`vs:carb`
      # A tibble: 30 x 7
           .it vs     carb .y_composite    .n .y_distinct    .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE     1            0     0           0     0
       2     0 TRUE      1            0    14           0     0
       3     0 FALSE     2            0    10           0     0
       4     0 TRUE      2            0     9           0     0
       5     0 FALSE     3            0     8           0     0
       6     0 TRUE      3            0     1           0     0
       7     0 FALSE     4            0    13           0     0
       8     0 TRUE      4            0     3           0     0
       9     0 FALSE     8            0     5           0     0
      10     0 TRUE      8            0     1           0     0
      # i 20 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`vs:wt`
      # A tibble: 60 x 7
           .it vs       wt .y_composite    .n .y_distinct    .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl> <dbl>
       1     0 FALSE  1.50            0     0           0     0
       2     0 TRUE   1.50            0     1           0     0
       3     0 FALSE  1.94            0     0           0     0
       4     0 TRUE   1.94            0     7           0     0
       5     0 FALSE  2.46            0     2           0     0
       6     0 TRUE   2.46            0     5           0     0
       7     0 FALSE  2.79            0     4           0     0
       8     0 TRUE   2.79            0     3           0     0
       9     0 FALSE  3.19            0     4           0     0
      10     0 TRUE   3.19            0     3           0     0
      # i 50 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`am:model`
      # A tibble: 192 x 7
           .it am    model               .y_composite    .n .y_distinct      .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE Lincoln Continental      -0.0218     2     -0.0218 -0.0218
       2     0 TRUE  Lincoln Continental      -0.0218     0     -1.51   -1.51  
       3     0 FALSE Cadillac Fleetwood       -0.0218     2     -0.0218 -0.0218
       4     0 TRUE  Cadillac Fleetwood       -0.0218     0     -1.51   -1.51  
       5     0 FALSE Merc 450SL               -0.0218     2     -0.0218 -0.0218
       6     0 TRUE  Merc 450SL               -0.0218     0     -1.51   -1.51  
       7     0 FALSE Merc 450SLC              -0.0218     2     -0.0218 -0.0218
       8     0 TRUE  Merc 450SLC              -0.0218     0     -1.51   -1.51  
       9     0 FALSE Camaro Z28               -0.0218     2     -0.0218 -0.0218
      10     0 TRUE  Camaro Z28               -0.0218     0     -1.51   -1.51  
      # i 182 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`am:gear`
      # A tibble: 18 x 7
           .it am    gear  .y_composite    .n .y_distinct     .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 FALSE three       0.0729    30       0.205  0.205
       2     0 TRUE  three       0.0729     0       0.894  0.894
       3     0 FALSE four        0.0729     8       0.205  0.205
       4     0 TRUE  four        0.643     16       1.46   1.46 
       5     0 FALSE five        0.0729     0       0.205  0.205
       6     0 TRUE  five        0.838     10       1.66   1.66 
       7     1 FALSE three       0.271     30       0.329  0.329
       8     1 TRUE  three       0.271      0       0.170  0.170
       9     1 FALSE four        0.527      8       0.585  0.585
      10     1 TRUE  four        0.848     16       0.746  0.746
      11     1 FALSE five        0.527      0       0.585  0.585
      12     1 TRUE  five        0.945     10       0.843  0.843
      13     2 FALSE three       0.0732    30      -0.117 -0.117
      14     2 TRUE  three       0.0732     0      -0.646 -0.646
      15     2 FALSE four        0.340      8       0.150  0.150
      16     2 TRUE  four        0.403     16      -0.317 -0.317
      17     2 FALSE five        0.340      0       0.150  0.150
      18     2 TRUE  five        0.403     10      -0.317 -0.317
      
      attr(,"effect")$`North America`$boot_data$d2$`am:carb`
      # A tibble: 30 x 7
           .it am     carb  .y_composite    .n   .y_distinct            .y
         <dbl> <fct> <dbl>         <dbl> <dbl>         <dbl>         <dbl>
       1     0 FALSE     1 -0.0000000460     6  0.00370       0.00370     
       2     0 TRUE      1 -0.0000000460     8 -0.123        -0.123       
       3     0 FALSE     2 -0.0000000460    12 -0.0828       -0.0828      
       4     0 TRUE      2 -0.000000439      7 -0.127        -0.127       
       5     0 FALSE     3 -0.0000000460     7  0.00369       0.00369     
       6     0 TRUE      3 -0.000000439      2 -0.210        -0.210       
       7     0 FALSE     4 -0.0000000460    11 -0.0000000460 -0.0000000460
       8     0 TRUE      4 -0.000000446      5 -0.123        -0.123       
       9     0 FALSE     8 -0.0000000460     2 -0.0828       -0.0828      
      10     0 TRUE      8 -0.000000447      4 -0.210        -0.210       
      # i 20 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`am:wt`
      # A tibble: 60 x 7
           .it am       wt .y_composite    .n .y_distinct        .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>     <dbl>
       1     0 FALSE  1.50     9.93e-11     0    1.17e- 5  1.17e- 5
       2     0 TRUE   1.50     9.93e-11     1   -1.71e- 2 -1.71e- 2
       3     0 FALSE  1.94     9.93e-11     0   -2.12e- 2 -2.12e- 2
       4     0 TRUE   1.94    -5.71e-10     7   -3.83e- 2 -3.83e- 2
       5     0 FALSE  2.46     9.93e-11     1   -2.12e- 2 -2.12e- 2
       6     0 TRUE   2.46    -6.18e-10     6   -3.83e- 2 -3.83e- 2
       7     0 FALSE  2.79     9.93e-11     1    9.93e-11  9.93e-11
       8     0 TRUE   2.79     7.83e-10     6   -1.71e- 2 -1.71e- 2
       9     0 FALSE  3.19     9.93e-11     3   -1.03e- 2 -1.03e- 2
      10     0 TRUE   3.19     7.86e-10     4   -3.83e- 2 -3.83e- 2
      # i 50 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`model:gear`
      # A tibble: 288 x 7
           .it model               gear  .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <fct>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental three       -0.117     2      -0.117 -0.117
       2     0 Cadillac Fleetwood  three       -0.117     2      -0.117 -0.117
       3     0 Merc 450SL          three       -0.117     2      -0.117 -0.117
       4     0 Merc 450SLC         three       -0.117     2      -0.117 -0.117
       5     0 Camaro Z28          three       -0.117     2      -0.117 -0.117
       6     0 Chrysler Imperial   three       -0.117     2       0.339  0.339
       7     0 Duster 360          three       -0.117     2       0.317  0.317
       8     0 Merc 450SE          three       -0.117     2       0.317  0.317
       9     0 Hornet Sportabout   three       -0.117     2       0.434  0.434
      10     0 AMC Javelin         three       -0.117     2       0.547  0.547
      # i 278 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`model:carb`
      # A tibble: 480 x 7
           .it model                carb .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental     1        0.471     0       0.471  0.471
       2     0 Cadillac Fleetwood      1        0.471     0       0.471  0.471
       3     0 Merc 450SL              1        0.471     0       0.471  0.471
       4     0 Merc 450SLC             1        0.471     0       0.471  0.471
       5     0 Camaro Z28              1        0.471     0       0.471  0.471
       6     0 Chrysler Imperial       1        0.471     0      -1.53  -1.53 
       7     0 Duster 360              1        0.471     0      -5.55  -5.55 
       8     0 Merc 450SE              1        0.471     0      -6.69  -6.69 
       9     0 Hornet Sportabout       1        0.471     0      -6.97  -6.97 
      10     0 AMC Javelin             1        0.471     0      -7.07  -7.07 
      # i 470 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`model:wt`
      # A tibble: 960 x 7
           .it model                  wt .y_composite    .n .y_distinct       .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 Lincoln Continental  1.50       0.0603     0     0.0603   0.0603 
       2     0 Cadillac Fleetwood   1.50       0.0603     0     0.0603   0.0603 
       3     0 Merc 450SL           1.50       0.0603     0     0.0603   0.0603 
       4     0 Merc 450SLC          1.50       0.0603     0     0.0603   0.0603 
       5     0 Camaro Z28           1.50       0.0603     0     0.0602   0.0602 
       6     0 Chrysler Imperial    1.50       0.0603     0     0.00250  0.00250
       7     0 Duster 360           1.50       0.0603     0    -0.252   -0.252  
       8     0 Merc 450SE           1.50       0.0603     0    -0.318   -0.318  
       9     0 Hornet Sportabout    1.50       0.0603     0    -0.334   -0.334  
      10     0 AMC Javelin          1.50       0.0603     0    -0.334   -0.334  
      # i 950 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`gear:carb`
      # A tibble: 45 x 7
           .it gear   carb .y_composite    .n .y_distinct     .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 three     1      -0.0306     6      -0.108 -0.108
       2     0 four      1      -0.0306     8      -0.157 -0.157
       3     0 five      1      -0.0306     0      -0.160 -0.160
       4     0 three     2      -0.0306     8      -0.213 -0.213
       5     0 four      2      -0.165      7      -0.347 -0.347
       6     0 five      2      -0.165      4      -0.242 -0.242
       7     0 three     3      -0.0306     7      -0.157 -0.157
       8     0 four      3      -0.195      2      -0.325 -0.325
       9     0 five      3      -0.198      0      -0.380 -0.380
      10     0 three     4      -0.0306     8      -0.213 -0.213
      # i 35 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`gear:wt`
      # A tibble: 90 x 7
           .it gear     wt .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 three  1.50      -0.0342     0     -0.0903 -0.0903
       2     0 four   1.50      -0.0342     0     -0.0997 -0.0997
       3     0 five   1.50      -0.0342     1     -0.106  -0.106 
       4     0 three  1.94      -0.0342     0     -0.119  -0.119 
       5     0 four   1.94      -0.0506     6     -0.157  -0.157 
       6     0 five   1.94      -0.0506     1     -0.157  -0.157 
       7     0 three  2.46      -0.0342     1     -0.141  -0.141 
       8     0 four   2.46      -0.0578     4     -0.164  -0.164 
       9     0 five   2.46      -0.0578     2     -0.164  -0.164 
      10     0 three  2.79      -0.0342     1     -0.141  -0.141 
      # i 80 more rows
      
      attr(,"effect")$`North America`$boot_data$d2$`carb:wt`
      # A tibble: 150 x 7
           .it  carb    wt .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0     1  1.50 0.0000000171     0    -0.0332  -0.0332 
       2     0     2  1.50 0.0000000171     1    -0.00425 -0.00425
       3     0     3  1.50 0.0000000171     0    -0.0375  -0.0375 
       4     0     4  1.50 0.0000000171     0    -0.0281  -0.0281 
       5     0     8  1.50 0.0000000171     0    -0.0381  -0.0381 
       6     0     1  1.94 0.0000000171     4    -0.0415  -0.0415 
       7     0     2  1.94 0.000000145      3    -0.00831 -0.00831
       8     0     3  1.94 0.000000145      0    -0.0415  -0.0415 
       9     0     4  1.94 0.000000145      0    -0.0316  -0.0316 
      10     0     8  1.94 0.000000145      0    -0.0415  -0.0415 
      # i 140 more rows
      
      
      
      
      attr(,"params")
      attr(,"params")$max_d
      [1] 2
      
      attr(,"params")$ordered_x_cols
      attr(,"params")$ordered_x_cols$d1
      [1] "mpg"   "vs"    "am"    "model" "gear"  "carb"  "wt"   
      
      attr(,"params")$ordered_x_cols$d2
       [1] "mpg:vs"     "mpg:am"     "mpg:model"  "mpg:gear"   "mpg:carb"  
       [6] "mpg:wt"     "vs:am"      "vs:model"   "vs:gear"    "vs:carb"   
      [11] "vs:wt"      "am:model"   "am:gear"    "am:carb"    "am:wt"     
      [16] "model:gear" "model:carb" "model:wt"   "gear:carb"  "gear:wt"   
      [21] "carb:wt"   
      
      
      attr(,"params")$requested_x_cols
      attr(,"params")$requested_x_cols$d1
      [1] "mpg"   "vs"    "am"    "model" "gear"  "carb"  "wt"   
      
      attr(,"params")$requested_x_cols$d2
       [1] "mpg:vs"     "mpg:am"     "mpg:model"  "mpg:gear"   "mpg:carb"  
       [6] "mpg:wt"     "vs:am"      "vs:model"   "vs:gear"    "vs:carb"   
      [11] "vs:wt"      "am:model"   "am:gear"    "am:carb"    "am:wt"     
      [16] "model:gear" "model:carb" "model:wt"   "gear:carb"  "gear:wt"   
      [21] "carb:wt"   
      
      
      attr(,"params")$y_cats
      [1] "Asia"          "Europe"        "North America"
      
      attr(,"params")$y_summary
                    continent         Asia       Europe North America
      min        0.000000e+00 0.000000e+00 0.000000e+00  0.000000e+00
      1%         1.069668e-33 2.992722e-30 1.069668e-33  2.347822e-34
      2.5%       6.673430e-30 4.423735e-28 1.517465e-32  6.673430e-30
      5%         3.090197e-29 3.706601e-27 1.024412e-30  3.090197e-29
      10%        7.497546e-28 7.833412e-24 7.497546e-28  8.934872e-29
      20%        4.002630e-25 6.716097e-21 4.002630e-25  4.655065e-26
      25%        3.199266e-24 8.785222e-20 8.693125e-25  3.199266e-24
      30%        6.827727e-23 2.256763e-18 6.827727e-23  2.889855e-23
      40%        7.271081e-18 8.144755e-16 5.332080e-18  7.271081e-18
      aler_lo_lo 1.197313e-14 1.197313e-14 1.305088e-14  2.637676e-14
      aler_lo    1.197341e-14 1.197341e-14 1.305116e-14  2.637704e-14
      50%        1.305186e-14 1.197411e-14 1.305186e-14  2.637774e-14
      mean       3.333333e-01 3.333333e-01 3.333333e-01  3.333333e-01
      aler_hi    2.637802e-14 1.197440e-14 1.305215e-14  2.637802e-14
      aler_hi_hi 2.637866e-14 1.197504e-14 1.305278e-14  2.637866e-14
      60%        1.134760e-08 9.938550e-13 9.999865e-01  1.134760e-08
      70%        1.000000e+00 5.030736e-08 1.000000e+00  1.000000e+00
      75%        1.000000e+00 4.755457e-06 1.000000e+00  1.000000e+00
      80%        1.000000e+00 1.373114e-05 1.000000e+00  1.000000e+00
      90%        1.000000e+00 1.000000e+00 1.000000e+00  1.000000e+00
      95%        1.000000e+00 1.000000e+00 1.000000e+00  1.000000e+00
      97.5%      1.000000e+00 1.000000e+00 1.000000e+00  1.000000e+00
      99%        1.000000e+00 1.000000e+00 1.000000e+00  1.000000e+00
      max        1.000000e+00 1.000000e+00 1.000000e+00  1.000000e+00
      
      attr(,"params")$model
      attr(,"params")$model$class
      [1] "multinom" "nnet"    
      
      attr(,"params")$model$call
      [1] "nnet::multinom(formula = continent ~ model + wt + am + gear + \n    carb, data = test_cars, trace = FALSE)"
      
      attr(,"params")$model$print
      [1] "Call:\nnnet::multinom(formula = continent ~ model + wt + am + gear + \n    carb, data = test_cars, trace = FALSE)\n\nCoefficients:\n              (Intercept) modelCadillac Fleetwood modelCamaro Z28\nEurope          -21.86205               -2.222771       -6.526356\nNorth America   -12.29302               -2.006450       14.817906\n              modelChrysler Imperial modelDatsun 710 modelDodge Challenger\nEurope                    -3.5495185       -42.28844             -3.766810\nNorth America             -0.4119232       -22.35666              7.689393\n              modelDuster 360 modelFerrari Dino modelFiat 128 modelFiat X1-9\nEurope              -7.046867          5.545836     42.144872      43.426334\nNorth America       20.851301         -3.241914      2.522922       2.870462\n              modelFord Pantera L modelHonda Civic modelHornet 4 Drive\nEurope                  -23.11127      -27.5878163           -2.495884\nNorth America            29.30682       -0.1513286            7.771946\n              modelHornet Sportabout modelLincoln Continental modelLotus Europa\nEurope                     -5.036042                -1.780289         14.561696\nNorth America              12.103127                -2.891703         -1.631007\n              modelMaserati Bora modelMazda RX4 modelMazda RX4 Wag\nEurope                  6.999218      -33.61112          -35.88135\nNorth America          -7.857123       -3.27005          -10.72975\n              modelMerc 230 modelMerc 240D modelMerc 280 modelMerc 280C\nEurope           14.2684900     14.2452958     11.590028     10.4496565\nNorth America    -0.5204999     -0.6708756      1.228568      0.8928993\n              modelMerc 450SE modelMerc 450SL modelMerc 450SLC\nEurope               39.49499         34.5616         36.09627\nNorth America       -38.59611        -31.8537        -34.17067\n              modelPontiac Firebird modelPorsche 914-2 modelToyota Corolla\nEurope                    -3.057543          15.344405          -34.531039\nNorth America              4.399831          -4.102117           -8.804816\n              modelToyota Corona modelValiant modelVolvo 142E       wt\nEurope                 -44.72605    -2.073514       34.932615 4.534617\nNorth America          -52.77315     5.537827        2.626442 3.625818\n                 amTRUE     gear.L    gear.Q      carb\nEurope        -34.05607 40.7995829 -5.443825 10.524876\nNorth America -24.81811  0.6220113 39.516400  5.894396\n\nResidual Deviance: 0.0001161393 \nAIC: 136.0001 "
      
      attr(,"params")$model$summary
      [1] "Call:\nnnet::multinom(formula = continent ~ model + wt + am + gear + \n    carb, data = test_cars, trace = FALSE)\n\nCoefficients:\n              (Intercept) modelCadillac Fleetwood modelCamaro Z28\nEurope          -21.86205               -2.222771       -6.526356\nNorth America   -12.29302               -2.006450       14.817906\n              modelChrysler Imperial modelDatsun 710 modelDodge Challenger\nEurope                    -3.5495185       -42.28844             -3.766810\nNorth America             -0.4119232       -22.35666              7.689393\n              modelDuster 360 modelFerrari Dino modelFiat 128 modelFiat X1-9\nEurope              -7.046867          5.545836     42.144872      43.426334\nNorth America       20.851301         -3.241914      2.522922       2.870462\n              modelFord Pantera L modelHonda Civic modelHornet 4 Drive\nEurope                  -23.11127      -27.5878163           -2.495884\nNorth America            29.30682       -0.1513286            7.771946\n              modelHornet Sportabout modelLincoln Continental modelLotus Europa\nEurope                     -5.036042                -1.780289         14.561696\nNorth America              12.103127                -2.891703         -1.631007\n              modelMaserati Bora modelMazda RX4 modelMazda RX4 Wag\nEurope                  6.999218      -33.61112          -35.88135\nNorth America          -7.857123       -3.27005          -10.72975\n              modelMerc 230 modelMerc 240D modelMerc 280 modelMerc 280C\nEurope           14.2684900     14.2452958     11.590028     10.4496565\nNorth America    -0.5204999     -0.6708756      1.228568      0.8928993\n              modelMerc 450SE modelMerc 450SL modelMerc 450SLC\nEurope               39.49499         34.5616         36.09627\nNorth America       -38.59611        -31.8537        -34.17067\n              modelPontiac Firebird modelPorsche 914-2 modelToyota Corolla\nEurope                    -3.057543          15.344405          -34.531039\nNorth America              4.399831          -4.102117           -8.804816\n              modelToyota Corona modelValiant modelVolvo 142E       wt\nEurope                 -44.72605    -2.073514       34.932615 4.534617\nNorth America          -52.77315     5.537827        2.626442 3.625818\n                 amTRUE     gear.L    gear.Q      carb\nEurope        -34.05607 40.7995829 -5.443825 10.524876\nNorth America -24.81811  0.6220113 39.516400  5.894396\n\nStd. Errors:\n              (Intercept) modelCadillac Fleetwood modelCamaro Z28\nEurope           35852.83                64.65729             NaN\nNorth America    12968.78                64.70730    2.870067e-08\n              modelChrysler Imperial modelDatsun 710 modelDodge Challenger\nEurope                      477.3874    1.590757e-08          2.858243e-08\nNorth America               477.3874    2.200012e-18          6.428719e+00\n              modelDuster 360 modelFerrari Dino modelFiat 128 modelFiat X1-9\nEurope           5.486580e-10          2660.898  1.805399e+04   1.525317e+04\nNorth America    7.249665e-11          2660.898  1.192455e-12   4.867466e-13\n              modelFord Pantera L modelHonda Civic modelHornet 4 Drive\nEurope                 0.09603878     5.871595e-07        3.863891e-10\nNorth America          0.09624948     9.331882e-08        7.163294e+03\n              modelHornet Sportabout modelLincoln Continental modelLotus Europa\nEurope                  4.655689e-09                 285.0759          32194.07\nNorth America           5.351209e-02                 285.1436          20099.45\n              modelMaserati Bora modelMazda RX4 modelMazda RX4 Wag\nEurope                0.01739745   644.72277405       1.000913e+02\nNorth America         0.01739745     0.04282998       3.394594e-05\n              modelMerc 230 modelMerc 240D modelMerc 280 modelMerc 280C\nEurope         1.329222e+02   1.088958e+02  4.023889e-07   2.701645e-06\nNorth America  4.475756e-08   3.800080e-08  2.855911e-10   1.280090e-09\n              modelMerc 450SE modelMerc 450SL modelMerc 450SLC\nEurope            92448.24826        22918.50        1179.3388\nNorth America        12.05893        21677.09         776.0876\n              modelPontiac Firebird modelPorsche 914-2 modelToyota Corolla\nEurope                 1.504060e-06           29024.38        9.393802e-15\nNorth America          6.422677e+01           62881.87        2.008891e-13\n              modelToyota Corona modelValiant modelVolvo 142E       wt   amTRUE\nEurope              2.042457e-17 7.332842e-09    5.751337e+04 26852.73 81773.79\nNorth America       1.689525e+01 3.329289e+04    5.749185e-12 97682.05 57698.40\n                 gear.L    gear.Q     carb\nEurope        120502.95 45794.583 77388.60\nNorth America  84695.32  5294.488 34719.66\n\nResidual Deviance: 0.0001161393 \nAIC: 136.0001 "
      
      
      attr(,"params")$data
      attr(,"params")$data$data_sample
      # A tibble: 64 x 8
           mpg vs    continent     am    model             gear   carb    wt
         <dbl> <lgl> <fct>         <lgl> <chr>             <ord> <int> <dbl>
       1  21   FALSE Asia          TRUE  Mazda RX4         four      4  2.62
       2  21   FALSE Asia          TRUE  Mazda RX4 Wag     four      4  2.88
       3  22.8 TRUE  Asia          TRUE  Datsun 710        four      1  2.32
       4  21.4 TRUE  North America FALSE Hornet 4 Drive    three     1  3.22
       5  18.7 FALSE North America FALSE Hornet Sportabout three     2  3.44
       6  18.1 TRUE  North America FALSE Valiant           three     1  3.46
       7  14.3 FALSE North America FALSE Duster 360        three     4  3.57
       8  24.4 TRUE  Europe        FALSE Merc 240D         four      2  3.19
       9  22.8 TRUE  Europe        FALSE Merc 230          four      2  3.15
      10  19.2 TRUE  Europe        FALSE Merc 280          four      4  3.44
      # i 54 more rows
      
      attr(,"params")$data$y_vals_sample
                 Asia       Europe North America
      1  1.000000e+00 3.101887e-14  6.537610e-18
      2  1.000000e+00 1.018274e-14  9.489785e-21
      3  1.000000e+00 2.627972e-32  2.366458e-34
      4  3.355506e-13 2.265633e-26  1.000000e+00
      5  5.377066e-18 2.956660e-27  1.000000e+00
      6  1.288929e-12 4.032610e-25  1.000000e+00
      7  4.043404e-27 7.439102e-28  1.000000e+00
      8  8.984341e-15 1.000000e+00  2.843402e-24
      9  1.052416e-14 1.000000e+00  3.348575e-24
      10 2.968411e-23 1.000000e+00  2.047714e-26
      11 9.284979e-23 1.000000e+00  4.578751e-26
      12 1.284023e-16 1.000000e+00  8.157836e-18
      13 8.331004e-14 1.000000e+00  1.307688e-12
      14 1.431293e-14 1.000000e+00  2.654720e-14
      15 7.731999e-20 3.603019e-15  1.000000e+00
      16 9.971464e-20 1.592098e-14  1.000000e+00
      17 1.112253e-20 2.115769e-16  1.000000e+00
      18 1.405315e-05 9.999859e-01  1.373965e-28
      19 1.000000e+00 9.694352e-23  2.934333e-23
      20 1.000000e+00 6.815207e-30  3.132362e-29
      21 1.000000e+00 1.028218e-33  9.973236e-16
      22 3.322245e-16 9.342366e-25  1.000000e+00
      23 9.879611e-13 8.170982e-20  1.000000e+00
      24 6.336585e-25 6.674374e-25  1.000000e+00
      25 2.743479e-15 6.845408e-23  1.000000e+00
      26 1.297545e-05 9.999870e-01  6.870224e-29
      27 5.019518e-08 9.999999e-01  3.082157e-10
      28 1.885279e-06 9.999981e-01  1.410710e-08
      29 9.136296e-20 5.361045e-18  1.000000e+00
      30 2.703016e-23 1.000000e+00  6.687763e-14
      31 1.211644e-34 1.000000e+00  7.112017e-21
      32 3.688923e-08 1.000000e+00  1.189251e-27
      33 1.000000e+00 3.408497e-14  7.049392e-18
      34 1.000000e+00 2.572858e-19  2.489552e-23
      35 1.000000e+00 2.558207e-32  2.316091e-34
      36 3.298994e-13 2.275299e-26  1.000000e+00
      37 1.337882e-20 3.110842e-25  1.000000e+00
      38 1.389107e-12 3.957660e-25  1.000000e+00
      39 3.647166e-27 7.633916e-28  1.000000e+00
      40 7.899779e-15 1.000000e+00  2.771028e-24
      41 1.005165e-14 1.000000e+00  3.317888e-24
      42 7.658342e-28 1.000000e+00  1.980485e-28
      43 1.064524e-22 1.000000e+00  4.705941e-26
      44 5.328465e-12 1.000000e+00  8.550926e-16
      45 2.496435e-18 1.000000e+00  1.303274e-14
      46 1.342406e-14 1.000000e+00  2.620827e-14
      47 2.933308e-17 3.474335e-17  1.000000e+00
      48 3.255127e-17 1.594157e-16  1.000000e+00
      49 3.066813e-23 2.169517e-14  1.000000e+00
      50 1.345603e-05 9.999865e-01  1.362061e-28
      51 1.000000e+00 1.041859e-22  3.108341e-23
      52 1.000000e+00 6.680493e-30  3.082756e-29
      53 1.000000e+00 1.094012e-33  1.048032e-15
      54 2.973320e-16 9.605844e-25  1.000000e+00
      55 1.061403e-12 8.025443e-20  1.000000e+00
      56 6.074529e-25 6.745405e-25  1.000000e+00
      57 3.045398e-15 6.668596e-23  1.000000e+00
      58 1.351647e-05 9.999865e-01  6.926697e-29
      59 5.131701e-08 9.999999e-01  3.095840e-10
      60 2.015459e-06 9.999980e-01  1.429715e-08
      61 9.386677e-20 5.324839e-18  1.000000e+00
      62 2.463284e-23 1.000000e+00  6.564435e-14
      63 4.750282e-30 1.000000e+00  7.370275e-19
      64 9.953285e-13 1.000000e+00  1.160579e-29
      
      attr(,"params")$data$nrow
      [1] 64
      
      
      attr(,"params")$y_col
      [1] "continent"
      
      attr(,"params")$parallel
      [1] 0
      
      attr(,"params")$model_packages
      NULL
      
      attr(,"params")$output_stats
      [1] TRUE
      
      attr(,"params")$output_boot_data
      [1] TRUE
      
      attr(,"params")$pred_fun
      [1] "function(object, newdata, type = pred_type) {\n      stats::predict(object = object, newdata = newdata, type = type)\n    }"
      
      attr(,"params")$pred_type
      [1] "probs"
      
      attr(,"params")$p_values
      <ale::ALEpDist>
       @ rand_stats           :List of 3
       .. $ Asia         : tibble [100 x 6] (S3: tbl_df/tbl/data.frame)
       ..  ..$ aled     : num [1:100] 4.92e-20 2.07e-22 1.29e-21 7.03e-23 4.80e-22 ...
       ..  ..$ aler_min : num [1:100] -2.26e-19 -6.32e-22 -4.70e-21 -3.06e-22 -1.53e-21 ...
       ..  ..$ aler_max : num [1:100] 2.66e-19 1.04e-21 4.96e-21 4.08e-22 2.85e-21 ...
       ..  ..$ naled    : num [1:100] 0 0 0 0 0 0 0 0 0 0 ...
       ..  ..$ naler_min: num [1:100] 0 0 0 0 0 0 0 0 0 0 ...
       ..  ..$ naler_max: num [1:100] 0 0 0 0 0 0 0 0 0 0 ...
       .. $ Europe       : tibble [100 x 6] (S3: tbl_df/tbl/data.frame)
       ..  ..$ aled     : num [1:100] 4.92e-20 2.07e-22 1.29e-21 7.03e-23 4.80e-22 ...
       ..  ..$ aler_min : num [1:100] -2.26e-19 -6.32e-22 -4.70e-21 -3.06e-22 -1.53e-21 ...
       ..  ..$ aler_max : num [1:100] 2.66e-19 1.04e-21 4.96e-21 4.08e-22 2.85e-21 ...
       ..  ..$ naled    : num [1:100] 0 0 0 0 0 0 0 0 0 0 ...
       ..  ..$ naler_min: num [1:100] 0 0 0 0 0 0 0 0 0 0 ...
       ..  ..$ naler_max: num [1:100] 0 0 0 0 0 0 0 0 0 0 ...
       .. $ North America: tibble [100 x 6] (S3: tbl_df/tbl/data.frame)
       ..  ..$ aled     : num [1:100] 4.92e-20 2.07e-22 1.29e-21 7.03e-23 4.80e-22 ...
       ..  ..$ aler_min : num [1:100] -2.26e-19 -6.32e-22 -4.70e-21 -3.06e-22 -1.53e-21 ...
       ..  ..$ aler_max : num [1:100] 2.66e-19 1.04e-21 4.96e-21 4.08e-22 2.85e-21 ...
       ..  ..$ naled    : num [1:100] 0 0 0 0 0 0 0 0 0 0 ...
       ..  ..$ naler_min: num [1:100] 0 0 0 0 0 0 0 0 0 0 ...
       ..  ..$ naler_max: num [1:100] 0 0 0 0 0 0 0 0 0 0 ...
       @ residual_distribution: 'univariateML' Named num [1:2] -2.04e-23 1.50e-17
       .. - attr(*, "logLik")= num 2371
       .. - attr(*, "call")= language f(x = x, na.rm = na.rm)
       .. - attr(*, "n")= int 64
       .. - attr(*, "model")= chr "Laplace"
       .. - attr(*, "density")= chr "extraDistr::dlaplace"
       .. - attr(*, "support")= num [1:2] -Inf Inf
       .. - attr(*, "names")= chr [1:2] "mu" "sigma"
       .. - attr(*, "default")= num [1:2] 0 1
       .. - attr(*, "continuous")= logi TRUE
       @ residuals            : NULL
       @ params               :List of 11
       .. $ model                        :List of 4
       ..  ..$ class  : chr [1:2] "multinom" "nnet"
       ..  ..$ call   : chr "nnet::multinom(formula = continent ~ model + wt + am + gear + \n    carb, data = test_cars, trace = FALSE)"
       ..  ..$ print  : chr "Call:\nnnet::multinom(formula = continent ~ model + wt + am + gear + \n    carb, data = test_cars, trace = FALS"| __truncated__
       ..  ..$ summary: chr "Call:\nnnet::multinom(formula = continent ~ model + wt + am + gear + \n    carb, data = test_cars, trace = FALS"| __truncated__
       .. $ y_col                        : chr "continent"
       .. $ rand_it                      : NULL
       .. $ parallel                     : num 0
       .. $ model_packages               : NULL
       .. $ random_model_call_string     : NULL
       .. $ random_model_call_string_vars: chr(0) 
       .. $ positive                     : logi TRUE
       .. $ seed                         : num 0
       .. $ rand_it_ok                   : int 100
       .. $ exactness                    : chr "surrogate"
      
      attr(,"params")$aler_alpha
      [1] 0.01 0.05
      
      attr(,"params")$max_num_bins
      [1] 10
      
      attr(,"params")$boot_it
      [1] 2
      
      attr(,"params")$boot_alpha
      [1] 0.05
      
      attr(,"params")$boot_centre
      [1] "mean"
      
      attr(,"params")$seed
      [1] 0
      
      attr(,"params")$y_type
      [1] "categorical"
      
      attr(,"params")$sample_size
      [1] 500
      

---

    Code
      get(cat_cars_ale)
    Output
      $Asia
      $Asia$d1
      $Asia$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE     36 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      2 TRUE      28 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d1$am
      # A tibble: 2 x 7
        am.bin    .n      .y    .y_lo .y_mean .y_median  .y_hi
        <ord>  <int>   <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
      1 FALSE     38 0.00619 -0.0396  0.00619   0.0297  0.0320
      2 TRUE      26 0.0155  -0.00990 0.0155   -0.00670 0.0597
      
      $Asia$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental     2 -0.0226 -0.288 -0.0226    0.0422 0.187
       2 Cadillac Fleetwood      2  0.0932 -0.280  0.0932    0.195  0.380
       3 Merc 450SL              2 -0.235  -0.766 -0.235    -0.305  0.355
       4 Merc 450SLC             2 -0.235  -0.766 -0.235    -0.305  0.355
       5 Camaro Z28              2  0.0975 -0.304  0.0975   -0.290  0.829
       6 Chrysler Imperial       2  0.264  -0.279  0.264     0.210  0.854
       7 Duster 360              2  0.264  -0.279  0.264     0.210  0.854
       8 Merc 450SE              2  0.266  -0.279  0.266     0.216  0.854
       9 Hornet Sportabout       2  0.433  -0.279  0.433     0.216  1.33 
      10 AMC Javelin             2  0.446  -0.302  0.446    -0.244  1.78 
      # i 22 more rows
      
      $Asia$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n       .y   .y_lo  .y_mean .y_median   .y_hi
        <ord>    <int>    <dbl>   <dbl>    <dbl>     <dbl>   <dbl>
      1 three       30  0.118    0.0563  0.118      0.118   0.181 
      2 four        24  0.00198 -0.150   0.00198    0.0718  0.0948
      3 five        10 -0.330   -0.523  -0.330     -0.460  -0.0269
      
      $Asia$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n       .y    .y_lo  .y_mean .y_median     .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>     <dbl>
      1         1    14  0.00549  0.00549  0.00549   0.00549  0.00549 
      2         2    19 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      3         3     9 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      4         4    16 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      5         8     6 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      
      $Asia$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n          .y       .y_lo     .y_mean   .y_median       .y_hi
           <dbl> <int>       <dbl>       <dbl>       <dbl>       <dbl>       <dbl>
       1    1.50     1  0.0000319   0.0000319   0.0000319   0.0000319   0.0000319 
       2    1.94     7 -0.00000143 -0.00000836 -0.00000143 -0.00000427  0.00000790
       3    2.46     7 -0.00000906 -0.0000153  -0.00000906 -0.00000787 -0.00000385
       4    2.79     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       5    3.19     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       6    3.44     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       7    3.52     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       8    3.73     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       9    4.05     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
      10    5.45     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
      
      
      $Asia$d2
      $Asia$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 FALSE      3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 FALSE      4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 FALSE      0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 FALSE      2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 FALSE      0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      11     10.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      12     14.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      13     15.2 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      14     16.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      15     18.7 TRUE       4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      16     19.8 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      17     21.4 TRUE       3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      18     22.9 TRUE       7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      19     30.1 TRUE       5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      20     33.9 TRUE       7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 FALSE      1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 FALSE      2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 FALSE      0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      11     10.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      12     14.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      13     15.2 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      14     16.4 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      15     18.7 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      16     19.8 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      17     21.4 TRUE       6 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      18     22.9 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      19     30.1 TRUE       5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      20     33.9 TRUE       7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin           .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>            <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 Lincoln Contine~     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 310 more rows
      
      $Asia$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 three        1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 three        7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 three        5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 three        5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 three        5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 three        3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 three        1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 three        3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 three        0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 three        0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 20 more rows
      
      $Asia$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>     <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7         1     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4         1     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9         1     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1         1     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9         1     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 40 more rows
      
      $Asia$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1    1.50     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 90 more rows
      
      $Asia$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  FALSE     24 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      2 TRUE   FALSE     14 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      3 FALSE  TRUE      12 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      4 TRUE   TRUE      14 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin             .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>  <ord>              <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE  Lincoln Continent~     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2 TRUE   Lincoln Continent~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3 FALSE  Cadillac Fleetwood     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4 TRUE   Cadillac Fleetwood     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5 FALSE  Merc 450SL             2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6 TRUE   Merc 450SL             0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7 FALSE  Merc 450SLC            2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8 TRUE   Merc 450SLC            0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9 FALSE  Camaro Z28             2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10 TRUE   Camaro Z28             0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 54 more rows
      
      $Asia$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  three       24 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      2 TRUE   three        6 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      3 FALSE  four         4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      4 TRUE   four        20 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      5 FALSE  five         8 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      6 TRUE   five         2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2 TRUE           1    14 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3 FALSE          2    10 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4 TRUE           2     9 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5 FALSE          3     8 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6 TRUE           3     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7 FALSE          4    13 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8 TRUE           4     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9 FALSE          8     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10 TRUE           8     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2 TRUE      1.50     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3 FALSE     1.94     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4 TRUE      1.94     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5 FALSE     2.46     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6 TRUE      2.46     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7 FALSE     2.79     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8 TRUE      2.79     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9 FALSE     3.19     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10 TRUE      3.19     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      11 FALSE     3.44     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      12 TRUE      3.44     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      13 FALSE     3.52     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      14 TRUE      3.52     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      15 FALSE     3.73     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      16 TRUE      3.73     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      17 FALSE     4.05     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      18 TRUE      4.05     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      19 FALSE     5.45     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      20 TRUE      5.45     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`am:model`
      # A tibble: 64 x 8
         am.bin model.bin              .n     .y  .y_lo .y_mean .y_median .y_hi
         <ord>  <ord>               <int>  <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE  Lincoln Continental     2 0.214   0.106  0.214      0.106 0.415
       2 TRUE   Lincoln Continental     0 0.214  -1.28   0.214      0.512 1.46 
       3 FALSE  Cadillac Fleetwood      2 0.323   0.106  0.323      0.106 0.723
       4 TRUE   Cadillac Fleetwood      0 0.323  -1.27   0.323      0.837 1.48 
       5 FALSE  Merc 450SL              2 0.0915 -0.552  0.0915     0.106 0.723
       6 TRUE   Merc 450SL              0 0.0915 -1.27   0.0915     0.817 0.836
       7 FALSE  Merc 450SLC             2 0.0915 -0.552  0.0915     0.106 0.723
       8 TRUE   Merc 450SLC             0 0.0915 -1.27   0.0915     0.817 0.836
       9 FALSE  Camaro Z28              2 0.0910 -0.552  0.0910     0.106 0.721
      10 TRUE   Camaro Z28              0 0.0910 -1.27   0.0910     0.817 0.834
      # i 54 more rows
      
      $Asia$d2$`am:gear`
      # A tibble: 6 x 8
        am.bin gear.bin    .n      .y  .y_lo .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
      1 FALSE  three       30 -0.0927 -0.197 -0.0927   -0.0688 -0.00870
      2 TRUE   three        0 -0.0927 -0.601 -0.0927   -0.104   0.425  
      3 FALSE  four         8 -0.191  -0.332 -0.191    -0.165  -0.0736 
      4 TRUE   four        16 -0.433  -0.832 -0.433    -0.507   0.0281 
      5 FALSE  five         0 -0.191  -0.332 -0.191    -0.165  -0.0736 
      6 TRUE   five        10 -0.766  -0.942 -0.766    -0.806  -0.555  
      
      $Asia$d2$`am:carb`
      # A tibble: 10 x 8
         am.bin carb.ceil    .n        .y    .y_lo   .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>     <dbl>    <dbl>     <dbl>     <dbl>  <dbl>
       1 FALSE          1     6  0.0166    0.0166   0.0166     0.0166  0.0166
       2 TRUE           1     8  0.0166   -0.101    0.0166     0.0166  0.134 
       3 FALSE          2    12  0.0134   -0.0621   0.0134     0.0163  0.0863
       4 TRUE           2     7 -0.000253 -0.203   -0.000253   0.00468 0.198 
       5 FALSE          3     7  0.0134    0.00415  0.0134     0.0163  0.0201
       6 TRUE           3     2 -0.000226 -0.120   -0.000226   0.00468 0.116 
       7 FALSE          4    11  0.190    -0.0514   0.190      0.229   0.399 
       8 TRUE           4     5  0.454     0.357    0.454      0.423   0.579 
       9 FALSE          8     2  0.190     0.0307   0.190      0.229   0.317 
      10 TRUE           8     4  0.454     0.341    0.454      0.353   0.654 
      
      $Asia$d2$`am:wt`
      # A tibble: 20 x 8
         am.bin wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>    <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 FALSE     1.50     0 0.0139  0.0139   0.0139    0.0139 0.0139
       2 TRUE      1.50     1 0.0139 -0.00237  0.0139    0.0139 0.0301
       3 FALSE     1.94     0 0.0139  0.00413  0.0139    0.0139 0.0236
       4 TRUE      1.94     7 0.0138 -0.0225   0.0138    0.0138 0.0502
       5 FALSE     2.46     1 0.0138 -0.00627  0.0138    0.0139 0.0339
       6 TRUE      2.46     6 0.0138 -0.0225   0.0138    0.0138 0.0502
       7 FALSE     2.79     1 0.0314 -0.00483  0.0314    0.0426 0.0582
       8 TRUE      2.79     6 0.0538  0.0227   0.0538    0.0605 0.0793
       9 FALSE     3.19     3 0.0481  0.0157   0.0481    0.0497 0.0792
      10 TRUE      3.19     4 0.100   0.0512   0.100     0.0987 0.151 
      11 FALSE     3.44     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      12 TRUE      3.44     0 0.109   0.0651   0.109     0.0987 0.161 
      13 FALSE     3.52     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      14 TRUE      3.52     0 0.113   0.0772   0.113     0.0987 0.161 
      15 FALSE     3.73     5 0.0481  0.0157   0.0481    0.0497 0.0792
      16 TRUE      3.73     2 0.113   0.0973   0.113     0.0987 0.141 
      17 FALSE     4.05     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      18 TRUE      4.05     0 0.113   0.0772   0.113     0.0987 0.161 
      19 FALSE     5.45     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      20 TRUE      5.45     0 0.113   0.0772   0.113     0.0987 0.161 
      
      $Asia$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental three        2 -0.0681 -0.184 -0.0681   -0.184  0.146
       2 Cadillac Fleetwood  three        2  0.0476 -0.184  0.0476   -0.184  0.476
       3 Merc 450SL          three        2 -0.280  -1.12  -0.280    -0.184  0.476
       4 Merc 450SLC         three        2 -0.114  -0.643 -0.114    -0.184  0.476
       5 Camaro Z28          three        2  0.389  -0.158  0.389     0.342  0.975
       6 Chrysler Imperial   three        2  0.223  -0.556  0.223     0.274  0.957
       7 Duster 360          three        2  0.223  -0.970  0.223     0.272  1.37 
       8 Merc 450SE          three        2  0.224  -0.687  0.224     0.250  1.11 
       9 Hornet Sportabout   three        2  0.225  -0.686  0.225     0.250  1.11 
      10 AMC Javelin         three        2 -0.0923 -1.59  -0.0923   -0.0198 1.34 
      # i 86 more rows
      
      $Asia$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0  3.42  3.42     3.42      3.42  3.42
       2 Cadillac Fleetwood          1     0  3.42  3.42     3.42      3.42  3.42
       3 Merc 450SL                  1     0  3.42  3.42     3.42      3.42  3.42
       4 Merc 450SLC                 1     0  3.42  3.42     3.42      3.42  3.42
       5 Camaro Z28                  1     0  3.42  3.42     3.42      3.42  3.42
       6 Chrysler Imperial           1     0  3.42  3.00     3.42      3.01  4.19
       7 Duster 360                  1     0  3.42 -0.295    3.42      2.05  8.30
       8 Merc 450SE                  1     0  3.42 -3.05     3.42      2.05 11.1 
       9 Hornet Sportabout           1     0  3.42 -3.45     3.42      2.05 11.5 
      10 AMC Javelin                 1     0  3.42 -3.81     3.42      2.05 11.8 
      # i 150 more rows
      
      $Asia$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n    .y   .y_lo .y_mean .y_median .y_hi
         <ord>                 <dbl> <int> <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental    1.50     0 0.342  0.342    0.342     0.342 0.342
       2 Cadillac Fleetwood     1.50     0 0.342  0.342    0.342     0.342 0.342
       3 Merc 450SL             1.50     0 0.342  0.342    0.342     0.342 0.342
       4 Merc 450SLC            1.50     0 0.342  0.342    0.342     0.342 0.342
       5 Camaro Z28             1.50     0 0.342  0.342    0.342     0.342 0.342
       6 Chrysler Imperial      1.50     0 0.342  0.319    0.342     0.342 0.366
       7 Duster 360             1.50     0 0.342  0.284    0.342     0.286 0.448
       8 Merc 450SE             1.50     0 0.342 -0.0164   0.342     0.286 0.749
       9 Hornet Sportabout      1.50     0 0.342 -0.0274   0.342     0.286 0.760
      10 AMC Javelin            1.50     0 0.342 -0.0351   0.342     0.286 0.768
      # i 310 more rows
      
      $Asia$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>        <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 three            1     6 0.0284  0.0284   0.0284    0.0284 0.0284
       2 four             1     8 0.0284 -0.0188   0.0284    0.0249 0.0785
       3 five             1     0 0.0284 -0.0220   0.0284    0.0249 0.0817
       4 three            2     8 0.0270 -0.0718   0.0270    0.0206 0.131 
       5 four             2     7 0.118   0.0612   0.118     0.135  0.161 
       6 five             2     4 0.0970  0.00282  0.0970    0.130  0.163 
       7 three            3     7 0.0341 -0.0182   0.0341    0.0372 0.0838
       8 four             3     2 0.149   0.120    0.149     0.140  0.185 
       9 five             3     0 0.123   0.0471   0.123     0.139  0.187 
      10 three            4     8 0.0456 -0.0699   0.0456    0.0598 0.149 
      11 four             4     6 0.307   0.206    0.307     0.358  0.364 
      12 five             4     2 0.285   0.221    0.285     0.270  0.361 
      13 three            8     1 0.0456 -0.0204   0.0456    0.0574 0.102 
      14 four             8     1 0.308   0.256    0.308     0.307  0.359 
      15 five             8     4 0.285   0.217    0.285     0.273  0.364 
      
      $Asia$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 three       1.50     0 0.0363  0.0363   0.0363    0.0363 0.0363
       2 four        1.50     0 0.0363  0.0274   0.0363    0.0364 0.0453
       3 five        1.50     1 0.0363  0.0212   0.0363    0.0389 0.0493
       4 three       1.94     0 0.0470  0.0108   0.0470    0.0619 0.0704
       5 four        1.94     6 0.0550  0.00593  0.0550    0.0757 0.0864
       6 five        1.94     1 0.0552  0.00661  0.0552    0.0757 0.0864
       7 three       2.46     1 0.0487 -0.00963  0.0487    0.0762 0.0838
       8 four        2.46     4 0.0623  0.0132   0.0623    0.0852 0.0919
       9 five        2.46     2 0.0725  0.0313   0.0725    0.0923 0.0970
      10 three       2.79     1 0.0489 -0.00962  0.0489    0.0764 0.0840
      # i 20 more rows
      
      $Asia$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n      .y    .y_lo .y_mean .y_median   .y_hi
             <dbl>   <dbl> <int>   <dbl>    <dbl>   <dbl>     <dbl>   <dbl>
       1         1    1.50     0 0.00454  0.00454 0.00454   0.00454 0.00454
       2         2    1.50     1 0.00454 -0.0270  0.00454   0.00454 0.0361 
       3         3    1.50     0 0.00454 -0.0216  0.00454   0.00454 0.0307 
       4         4    1.50     0 0.00454 -0.0310  0.00454   0.00454 0.0401 
       5         8    1.50     0 0.00454 -0.0316  0.00454   0.00454 0.0407 
       6         1    1.94     4 0.00454 -0.00336 0.00454   0.00454 0.0124 
       7         2    1.94     3 0.0185  -0.0159  0.0185    0.00668 0.0629 
       8         3    1.94     0 0.0185  -0.00651 0.0185    0.00668 0.0535 
       9         4    1.94     0 0.0185  -0.0159  0.0185    0.00668 0.0629 
      10         8    1.94     0 0.0185  -0.0159  0.0185    0.00668 0.0629 
      # i 40 more rows
      
      
      
      $Europe
      $Europe$d1
      $Europe$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE     36 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      2 TRUE      28 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d1$am
      # A tibble: 2 x 7
        am.bin    .n       .y   .y_lo  .y_mean .y_median   .y_hi
        <ord>  <int>    <dbl>   <dbl>    <dbl>     <dbl>   <dbl>
      1 FALSE     38 -0.00619 -0.0320 -0.00619  -0.0297  0.0396 
      2 TRUE      26 -0.0155  -0.0597 -0.0155    0.00670 0.00990
      
      $Europe$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental     2  0.217  -0.164  0.217      0.166 0.641
       2 Cadillac Fleetwood      2  0.268  -0.494  0.268      0.166 1.12 
       3 Merc 450SL              2  0.931  -0.444  0.931      1.17  2.10 
       4 Merc 450SLC             2  0.764  -0.444  0.764      1.17  1.63 
       5 Camaro Z28              2 -0.0688 -1.44  -0.0688     0.166 1.10 
       6 Chrysler Imperial       2  0.0978 -0.967  0.0978     0.166 1.10 
       7 Duster 360              2  0.0978 -0.967  0.0978     0.166 1.10 
       8 Merc 450SE              2  0.596  -0.917  0.596      1.17  1.62 
       9 Hornet Sportabout       2 -0.237  -1.92  -0.237      0.166 1.10 
      10 AMC Javelin             2 -0.0841 -1.92  -0.0841     0.166 1.54 
      # i 22 more rows
      
      $Europe$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n     .y   .y_lo .y_mean .y_median  .y_hi
        <ord>    <int>  <dbl>   <dbl>   <dbl>     <dbl>  <dbl>
      1 three       30 -0.239 -0.366   -0.239    -0.239 -0.112
      2 four        24  0.247  0.140    0.247     0.211  0.385
      3 five        10  0.380 -0.0309   0.380     0.594  0.609
      
      $Europe$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n       .y     .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>     <dbl>    <dbl>     <dbl>    <dbl>
      1         1    14 -0.00549 -0.00549  -0.00549  -0.00549 -0.00549
      2         2    19  0.00190  0.000117  0.00190   0.00191  0.00367
      3         3     9  0.00190  0.000117  0.00190   0.00191  0.00367
      4         4    16  0.00190  0.000117  0.00190   0.00191  0.00367
      5         8     6  0.00190  0.000117  0.00190   0.00191  0.00367
      
      $Europe$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n          .y       .y_lo     .y_mean   .y_median       .y_hi
           <dbl> <int>       <dbl>       <dbl>       <dbl>       <dbl>       <dbl>
       1    1.50     1 -0.0000319  -0.0000319  -0.0000319  -0.0000319  -0.0000319 
       2    1.94     7  0.00000143 -0.00000790  0.00000143  0.00000427  0.00000836
       3    2.46     7  0.00000906  0.00000385  0.00000906  0.00000787  0.0000153 
       4    2.79     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       5    3.19     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       6    3.44     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       7    3.52     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       8    3.73     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       9    4.05     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
      10    5.45     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
      
      
      $Europe$d2
      $Europe$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 FALSE      3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 FALSE      4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 FALSE      0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 FALSE      2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 FALSE      0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      11     10.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      12     14.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      13     15.2 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      14     16.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      15     18.7 TRUE       4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      16     19.8 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      17     21.4 TRUE       3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      18     22.9 TRUE       7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      19     30.1 TRUE       5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      20     33.9 TRUE       7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 FALSE      1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 FALSE      2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 FALSE      0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      11     10.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      12     14.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      13     15.2 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      14     16.4 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      15     18.7 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      16     19.8 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      17     21.4 TRUE       6 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      18     22.9 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      19     30.1 TRUE       5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      20     33.9 TRUE       7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin           .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>            <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 Lincoln Contine~     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 310 more rows
      
      $Europe$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 three        1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 three        7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 three        5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 three        5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 three        5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 three        3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 three        1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 three        3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 three        0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 three        0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 20 more rows
      
      $Europe$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>     <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7         1     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4         1     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9         1     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1         1     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9         1     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 40 more rows
      
      $Europe$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1    1.50     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 90 more rows
      
      $Europe$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  FALSE     24 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      2 TRUE   FALSE     14 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      3 FALSE  TRUE      12 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      4 TRUE   TRUE      14 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin             .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>  <ord>              <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE  Lincoln Continent~     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2 TRUE   Lincoln Continent~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3 FALSE  Cadillac Fleetwood     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4 TRUE   Cadillac Fleetwood     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5 FALSE  Merc 450SL             2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6 TRUE   Merc 450SL             0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7 FALSE  Merc 450SLC            2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8 TRUE   Merc 450SLC            0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9 FALSE  Camaro Z28             2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10 TRUE   Camaro Z28             0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 54 more rows
      
      $Europe$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  three       24 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      2 TRUE   three        6 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      3 FALSE  four         4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      4 TRUE   four        20 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      5 FALSE  five         8 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      6 TRUE   five         2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2 TRUE           1    14 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3 FALSE          2    10 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4 TRUE           2     9 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5 FALSE          3     8 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6 TRUE           3     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7 FALSE          4    13 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8 TRUE           4     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9 FALSE          8     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10 TRUE           8     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2 TRUE      1.50     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3 FALSE     1.94     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4 TRUE      1.94     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5 FALSE     2.46     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6 TRUE      2.46     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7 FALSE     2.79     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8 TRUE      2.79     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9 FALSE     3.19     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10 TRUE      3.19     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      11 FALSE     3.44     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      12 TRUE      3.44     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      13 FALSE     3.52     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      14 TRUE      3.52     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      15 FALSE     3.73     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      16 TRUE      3.73     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      17 FALSE     4.05     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      18 TRUE      4.05     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      19 FALSE     5.45     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      20 TRUE      5.45     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`am:model`
      # A tibble: 64 x 8
         am.bin model.bin              .n      .y  .y_lo .y_mean .y_median   .y_hi
         <ord>  <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl>   <dbl>
       1 FALSE  Lincoln Continental     2 -0.193  -1.51  -0.193    -0.327   1.24  
       2 TRUE   Lincoln Continental     0 -0.193  -0.393 -0.193    -0.0844 -0.0844
       3 FALSE  Cadillac Fleetwood      2 -0.301  -1.52  -0.301    -0.652   1.22  
       4 TRUE   Cadillac Fleetwood      0 -0.301  -0.701 -0.301    -0.0844 -0.0844
       5 FALSE  Merc 450SL              2 -0.0689 -1.52  -0.0689   -0.652   1.88  
       6 TRUE   Merc 450SL              0 -0.0689 -0.701 -0.0689   -0.0844  0.576 
       7 FALSE  Merc 450SLC             2 -0.0689 -1.52  -0.0689   -0.652   1.88  
       8 TRUE   Merc 450SLC             0 -0.0689 -0.701 -0.0689   -0.0844  0.576 
       9 FALSE  Camaro Z28              2 -0.0683 -1.52  -0.0683   -0.650   1.88  
      10 TRUE   Camaro Z28              0 -0.0683 -0.699 -0.0683   -0.0844  0.576 
      # i 54 more rows
      
      $Europe$d2$`am:gear`
      # A tibble: 6 x 8
        am.bin gear.bin    .n      .y  .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  three       30 -0.0465 -0.476 -0.0465   -0.0254 0.365
      2 TRUE   three        0 -0.0465 -0.348 -0.0465   -0.212  0.395
      3 FALSE  four         8 -0.122  -0.584 -0.122    -0.145  0.359
      4 TRUE   four        16 -0.198  -0.459 -0.198    -0.385  0.222
      5 FALSE  five         0 -0.122  -0.584 -0.122    -0.145  0.359
      6 TRUE   five        10  0.0371 -0.354  0.0371   -0.183  0.615
      
      $Europe$d2$`am:carb`
      # A tibble: 10 x 8
         am.bin carb.ceil    .n        .y    .y_lo   .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>     <dbl>    <dbl>     <dbl>     <dbl>    <dbl>
       1 FALSE          1     6 -0.0166   -0.137   -0.0166    -0.0166   0.104  
       2 TRUE           1     8 -0.0166   -0.0201  -0.0166    -0.0166  -0.0131 
       3 FALSE          2    12 -0.0134   -0.216   -0.0134    -0.0163   0.192  
       4 TRUE           2     7  0.000253 -0.00434  0.000253   0.00193  0.00342
       5 FALSE          3     7 -0.0134   -0.134   -0.0134    -0.0163   0.110  
       6 TRUE           3     2  0.000227 -0.0756   0.000227  -0.00468  0.0802 
       7 FALSE          4    11 -0.190    -0.229   -0.190     -0.226   -0.121  
       8 TRUE           4     5 -0.454    -0.542   -0.454     -0.464   -0.359  
       9 FALSE          8     2 -0.190    -0.228   -0.190     -0.202   -0.143  
      10 TRUE           8     4 -0.454    -0.620   -0.454     -0.377   -0.355  
      
      $Europe$d2$`am:wt`
      # A tibble: 20 x 8
         am.bin wt.ceil    .n      .y   .y_lo .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 -0.0139 -0.0301 -0.0139   -0.0139  0.00238
       2 TRUE      1.50     1 -0.0139 -0.0139 -0.0139   -0.0139 -0.0138 
       3 FALSE     1.94     0 -0.0139 -0.0398 -0.0139   -0.0139  0.0122 
       4 TRUE      1.94     7 -0.0138 -0.0340 -0.0138   -0.0138  0.00634
       5 FALSE     2.46     1 -0.0138 -0.0502 -0.0138   -0.0139  0.0226 
       6 TRUE      2.46     6 -0.0138 -0.0340 -0.0138   -0.0138  0.00634
       7 FALSE     2.79     1 -0.0314 -0.0517 -0.0314   -0.0426 -0.00165
       8 TRUE      2.79     6 -0.0538 -0.0630 -0.0538   -0.0605 -0.0389 
       9 FALSE     3.19     3 -0.0481 -0.0783 -0.0481   -0.0327 -0.0310 
      10 TRUE      3.19     4 -0.100  -0.104  -0.100    -0.0987 -0.0973 
      11 FALSE     3.44     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      12 TRUE      3.44     0 -0.109  -0.122  -0.109    -0.105  -0.0990 
      13 FALSE     3.52     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      14 TRUE      3.52     0 -0.113  -0.125  -0.113    -0.114  -0.0995 
      15 FALSE     3.73     5 -0.0481 -0.0783 -0.0481   -0.0327 -0.0310 
      16 TRUE      3.73     2 -0.113  -0.124  -0.113    -0.116  -0.0995 
      17 FALSE     4.05     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      18 TRUE      4.05     0 -0.113  -0.134  -0.113    -0.105  -0.0990 
      19 FALSE     5.45     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      20 TRUE      5.45     0 -0.113  -0.134  -0.113    -0.105  -0.0990 
      
      $Europe$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n     .y   .y_lo .y_mean .y_median .y_hi
         <ord>               <ord>    <int>  <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental three        2 0.185  -0.0288  0.185     0.301  0.301
       2 Cadillac Fleetwood  three        2 0.0696 -0.359   0.0696    0.301  0.301
       3 Merc 450SL          three        2 0.399  -0.359   0.399     0.301  1.24 
       4 Merc 450SLC         three        2 0.399  -0.359   0.399     0.301  1.24 
       5 Camaro Z28          three        2 0.0663 -0.832   0.0663    0.301  0.765
       6 Chrysler Imperial   three        2 0.0663 -0.450   0.0663   -0.0912 0.717
       7 Duster 360          three        2 0.0663 -0.693   0.0663    0.211  0.703
       8 Merc 450SE          three        2 0.0643 -0.692   0.0643    0.235  0.676
       9 Hornet Sportabout   three        2 0.0643 -0.533   0.0643   -0.0418 0.752
      10 AMC Javelin         three        2 0.218  -0.455   0.218     0.177  0.924
      # i 86 more rows
      
      $Europe$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       2 Cadillac Fleetwood          1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       3 Merc 450SL                  1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       4 Merc 450SLC                 1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       5 Camaro Z28                  1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       6 Chrysler Imperial           1     0 -3.89  -5.43   -3.89     -5.05 -1.37
       7 Duster 360                  1     0 -3.89  -8.50   -3.89     -5.26  1.88
       8 Merc 450SE                  1     0 -3.89 -10.8    -3.89     -5.26  4.14
       9 Hornet Sportabout           1     0 -3.89 -10.8    -3.89     -5.26  4.15
      10 AMC Javelin                 1     0 -3.89 -11.1    -3.89     -5.26  4.50
      # i 150 more rows
      
      $Europe$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n     .y  .y_lo .y_mean .y_median    .y_hi
         <ord>                 <dbl> <int>  <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
       1 Lincoln Continental    1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       2 Cadillac Fleetwood     1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       3 Merc 450SL             1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       4 Merc 450SLC            1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       5 Camaro Z28             1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       6 Chrysler Imperial      1.50     0 -0.403 -0.460  -0.403    -0.459 -0.297  
       7 Duster 360             1.50     0 -0.403 -0.550  -0.403    -0.459 -0.208  
       8 Merc 450SE             1.50     0 -0.403 -0.762  -0.403    -0.459  0.00423
       9 Hornet Sportabout      1.50     0 -0.403 -0.773  -0.403    -0.459  0.0150 
      10 AMC Javelin            1.50     0 -0.403 -0.780  -0.403    -0.459  0.0226 
      # i 310 more rows
      
      $Europe$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n      .y   .y_lo .y_mean .y_median .y_hi
         <ord>        <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 three            1     6 0.00218 -0.0999 0.00218   0.00214 0.104
       2 four             1     8 0.00218 -0.147  0.00218  -0.00135 0.154
       3 five             1     0 0.00218 -0.150  0.00218  -0.00135 0.158
       4 three            2     8 0.00616 -0.199  0.00616   0.0106  0.208
       5 four             2     7 0.0104  -0.198  0.0104    0.0250  0.207
       6 five             2     4 0.0315  -0.0678 0.0315    0.0249  0.137
       7 three            3     7 0.00616 -0.147  0.00616   0.0106  0.155
       8 four             3     2 0.0104  -0.149  0.0104    0.0227  0.159
       9 five             3     0 0.0369  -0.152  0.0369    0.0214  0.239
      10 three            4     8 0.00616 -0.199  0.00616   0.0129  0.206
      11 four             4     6 0.0104  -0.0985 0.0104    0.0262  0.106
      12 five             4     2 0.0369  -0.0995 0.0369    0.0214  0.187
      13 three            8     1 0.00616 -0.150  0.00616   0.0106  0.158
      14 four             8     1 0.00933 -0.201  0.00933   0.0227  0.209
      15 five             8     4 0.0359  -0.155  0.0359    0.0236  0.237
      
      $Europe$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n       .y   .y_lo  .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>    <dbl>   <dbl>    <dbl>     <dbl>  <dbl>
       1 three       1.50     0 -0.00213 -0.0403 -0.00213 -0.00217  0.0361
       2 four        1.50     0 -0.00213 -0.0492 -0.00213 -0.00213  0.0450
       3 five        1.50     1 -0.00213 -0.0555 -0.00213  0.000424 0.0490
       4 three       1.94     0 -0.00212 -0.0669 -0.00212  0.000451 0.0605
       5 four        1.94     6 -0.00207 -0.0881 -0.00207  0.000513 0.0818
       6 five        1.94     1 -0.00231 -0.0888 -0.00231  0.000513 0.0818
       7 three       2.46     1 -0.00212 -0.0881 -0.00212  0.000462 0.0817
       8 four        2.46     4 -0.00205 -0.0881 -0.00205  0.000523 0.0818
       9 five        2.46     2 -0.0123  -0.106  -0.0123  -0.0115   0.0812
      10 three       2.79     1 -0.00212 -0.0881 -0.00212  0.000462 0.0817
      # i 20 more rows
      
      $Europe$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median      .y_hi
             <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>      <dbl>
       1         1    1.50     0 -0.00454 -0.0267  -0.00454  -0.00454  0.0176   
       2         2    1.50     1 -0.00454 -0.0361  -0.00454  -0.00454  0.0270   
       3         3    1.50     0 -0.00454 -0.0401  -0.00454  -0.00454  0.0310   
       4         4    1.50     0 -0.00454 -0.00916 -0.00454  -0.00454  0.0000810
       5         8    1.50     0 -0.00454 -0.0407  -0.00454  -0.00454  0.0316   
       6         1    1.94     4 -0.00454 -0.0346  -0.00454  -0.00454  0.0255   
       7         2    1.94     3 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
       8         3    1.94     0 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
       9         4    1.94     0 -0.0185  -0.0319  -0.0185   -0.0161  -0.00715  
      10         8    1.94     0 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
      # i 40 more rows
      
      
      
      $`North America`
      $`North America`$d1
      $`North America`$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE     36 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      2 TRUE      28 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d1$am
      # A tibble: 2 x 7
        am.bin    .n        .y     .y_lo   .y_mean .y_median    .y_hi
        <ord>  <int>     <dbl>     <dbl>     <dbl>     <dbl>    <dbl>
      1 FALSE     38 -5.57e-10 -9.65e-10 -5.57e-10 -8.52e-10 1.02e-10
      2 TRUE      26  1.57e-10 -2.14e-10  1.57e-10 -4.71e-11 7.00e-10
      
      $`North America`$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median  .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl>  <dbl>
       1 Lincoln Continental     2 -0.195  -0.811 -0.195      0.139 0.139 
       2 Cadillac Fleetwood      2 -0.361  -1.29  -0.361      0.139 0.139 
       3 Merc 450SL              2 -0.695  -1.34  -0.695     -0.861 0.0888
       4 Merc 450SLC             2 -0.529  -0.863 -0.529     -0.861 0.0888
       5 Camaro Z28              2 -0.0287 -0.813 -0.0287     0.139 0.614 
       6 Chrysler Imperial       2 -0.362  -1.29  -0.362      0.139 0.139 
       7 Duster 360              2 -0.362  -1.29  -0.362      0.139 0.139 
       8 Merc 450SE              2 -0.862  -1.81  -0.862     -0.861 0.0888
       9 Hornet Sportabout       2 -0.195  -1.29  -0.195      0.139 0.614 
      10 AMC Javelin             2 -0.362  -1.29  -0.362      0.139 0.139 
      # i 22 more rows
      
      $`North America`$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n      .y   .y_lo .y_mean .y_median   .y_hi
        <ord>    <int>   <dbl>   <dbl>   <dbl>     <dbl>   <dbl>
      1 three       30  0.120   0.0527  0.120     0.0544  0.244 
      2 four        24 -0.249  -0.280  -0.249    -0.232  -0.232 
      3 five        10 -0.0498 -0.131  -0.0498   -0.0843  0.0603
      
      $`North America`$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n            .y         .y_lo       .y_mean  .y_median     .y_hi
            <dbl> <int>         <dbl>         <dbl>         <dbl>      <dbl>     <dbl>
      1         1    14  0.000000108   0.000000108   0.000000108     1.08e-7  1.08e- 7
      2         2    19 -0.0000000359 -0.0000000704 -0.0000000359   -3.71e-8 -5.22e-10
      3         3     9 -0.0000000359 -0.0000000704 -0.0000000359   -3.71e-8 -5.24e-10
      4         4    16 -0.0000000359 -0.0000000704 -0.0000000359   -3.71e-8 -5.24e-10
      5         8     6 -0.0000000413 -0.0000000817 -0.0000000413   -4.13e-8 -9.49e-10
      
      $`North America`$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n       .y     .y_lo  .y_mean .y_median    .y_hi
           <dbl> <int>    <dbl>     <dbl>    <dbl>     <dbl>    <dbl>
       1    1.50     1 6.60e-10  6.60e-10 6.60e-10  6.60e-10 6.60e-10
       2    1.94     7 2.64e-10 -1.47e-12 2.64e-10  1.40e-10 6.34e-10
       3    2.46     7 2.19e-10 -4.35e-11 2.19e-10  6.88e-11 6.08e-10
       4    2.79     7 2.19e-10 -4.36e-11 2.19e-10  6.88e-11 6.08e-10
       5    3.19     7 2.19e-10 -4.36e-11 2.19e-10  6.88e-11 6.08e-10
       6    3.44     7 2.19e-10 -4.28e-11 2.19e-10  6.88e-11 6.09e-10
       7    3.52     7 2.19e-10 -4.28e-11 2.19e-10  6.90e-11 6.10e-10
       8    3.73     7 2.19e-10 -4.28e-11 2.19e-10  6.90e-11 6.10e-10
       9    4.05     7 2.19e-10 -4.28e-11 2.19e-10  6.90e-11 6.10e-10
      10    5.45     7 2.19e-10 -4.28e-11 2.19e-10  6.90e-11 6.10e-10
      
      
      $`North America`$d2
      $`North America`$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7 FALSE      3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4 FALSE      4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9 FALSE      0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1 FALSE      2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9 FALSE      0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      11     10.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      12     14.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      13     15.2 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      14     16.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      15     18.7 TRUE       4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      16     19.8 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      17     21.4 TRUE       3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      18     22.9 TRUE       7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      19     30.1 TRUE       5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      20     33.9 TRUE       7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4 FALSE      1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1 FALSE      2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9 FALSE      0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      11     10.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      12     14.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      13     15.2 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      14     16.4 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      15     18.7 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      16     19.8 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      17     21.4 TRUE       6 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      18     22.9 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      19     30.1 TRUE       5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      20     33.9 TRUE       7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin           .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>            <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4 Lincoln Contine~     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 310 more rows
      
      $`North America`$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 three        1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4 three        7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2 three        5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4 three        5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7 three        5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8 three        3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4 three        1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9 three        3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1 three        0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9 three        0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 20 more rows
      
      $`North America`$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>     <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7         1     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4         1     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9         1     5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1         1     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9         1     4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 40 more rows
      
      $`North America`$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1    1.50     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 90 more rows
      
      $`North America`$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  FALSE     24 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      2 TRUE   FALSE     14 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      3 FALSE  TRUE      12 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      4 TRUE   TRUE      14 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin             .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>  <ord>              <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE  Lincoln Continent~     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2 TRUE   Lincoln Continent~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3 FALSE  Cadillac Fleetwood     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4 TRUE   Cadillac Fleetwood     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5 FALSE  Merc 450SL             2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6 TRUE   Merc 450SL             0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7 FALSE  Merc 450SLC            2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8 TRUE   Merc 450SLC            0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9 FALSE  Camaro Z28             2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10 TRUE   Camaro Z28             0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 54 more rows
      
      $`North America`$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  three       24 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      2 TRUE   three        6 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      3 FALSE  four         4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      4 TRUE   four        20 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      5 FALSE  five         8 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      6 TRUE   five         2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2 TRUE           1    14 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3 FALSE          2    10 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4 TRUE           2     9 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5 FALSE          3     8 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6 TRUE           3     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7 FALSE          4    13 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8 TRUE           4     3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9 FALSE          8     5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10 TRUE           8     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2 TRUE      1.50     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3 FALSE     1.94     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4 TRUE      1.94     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5 FALSE     2.46     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6 TRUE      2.46     5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7 FALSE     2.79     4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8 TRUE      2.79     3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9 FALSE     3.19     4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10 TRUE      3.19     3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      11 FALSE     3.44     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      12 TRUE      3.44     5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      13 FALSE     3.52     3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      14 TRUE      3.52     4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      15 FALSE     3.73     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      16 TRUE      3.73     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      17 FALSE     4.05     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      18 TRUE      4.05     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      19 FALSE     5.45     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      20 TRUE      5.45     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`am:model`
      # A tibble: 64 x 8
         am.bin model.bin              .n      .y   .y_lo .y_mean .y_median   .y_hi
         <ord>  <ord>               <int>   <dbl>   <dbl>   <dbl>     <dbl>   <dbl>
       1 FALSE  Lincoln Continental     2 -0.0218 -0.0218 -0.0218   -0.0218 -0.0218
       2 TRUE   Lincoln Continental     0 -0.0218 -1.43   -0.0218    0.0596  1.32  
       3 FALSE  Cadillac Fleetwood      2 -0.0218 -0.0218 -0.0218   -0.0218 -0.0218
       4 TRUE   Cadillac Fleetwood      0 -0.0218 -1.43   -0.0218    0.0596  1.32  
       5 FALSE  Merc 450SL              2 -0.0226 -0.0241 -0.0226   -0.0218 -0.0218
       6 TRUE   Merc 450SL              0 -0.0226 -1.43   -0.0226    0.0596  1.31  
       7 FALSE  Merc 450SLC             2 -0.0226 -0.0241 -0.0226   -0.0218 -0.0218
       8 TRUE   Merc 450SLC             0 -0.0226 -1.43   -0.0226    0.0596  1.31  
       9 FALSE  Camaro Z28              2 -0.0226 -0.0241 -0.0226   -0.0218 -0.0218
      10 TRUE   Camaro Z28              0 -0.0226 -1.43   -0.0226    0.0596  1.31  
      # i 54 more rows
      
      $`North America`$d2$`am:gear`
      # A tibble: 6 x 8
        am.bin gear.bin    .n    .y  .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>    <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  three       30 0.139 -0.101   0.139     0.205 0.323
      2 TRUE   three        0 0.139 -0.605   0.139     0.170 0.858
      3 FALSE  four         8 0.313  0.153   0.313     0.205 0.566
      4 TRUE   four        16 0.631 -0.263   0.631     0.746 1.43 
      5 FALSE  five         0 0.313  0.153   0.313     0.205 0.566
      6 TRUE   five        10 0.728 -0.259   0.728     0.843 1.62 
      
      $`North America`$d2$`am:carb`
      # A tibble: 10 x 8
         am.bin carb.ceil    .n            .y        .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>         <dbl>        <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     6 -0.0000000460 -0.00351     -4.60e-8   2.63e-8  3.51e-3
       2 TRUE           1     8 -0.0000000460 -0.117       -4.60e-8   2.47e-7  1.17e-1
       3 FALSE          2    12 -0.000000106  -0.0786      -1.06e-7   2.31e-8  7.86e-2
       4 TRUE           2     7 -0.000000373  -0.121       -3.73e-7  -5.45e-8  1.21e-1
       5 FALSE          3     7 -0.000000106  -0.00351     -1.06e-7   2.19e-8  3.50e-3
       6 TRUE           3     2 -0.000000373  -0.199       -3.73e-7   1.90e-8  1.99e-1
       7 FALSE          4    11 -0.000000109  -0.000000220 -1.09e-7  -5.33e-8 -4.64e-8
       8 TRUE           4     5 -0.000000380  -0.117       -3.80e-7   1.25e-8  1.17e-1
       9 FALSE          8     2 -0.000000110  -0.0786      -1.10e-7   1.95e-8  7.86e-2
      10 TRUE           8     4 -0.000000380  -0.199       -3.80e-7   1.30e-8  1.99e-1
      
      $`North America`$d2$`am:wt`
      # A tibble: 20 x 8
         am.bin wt.ceil    .n        .y     .y_lo   .y_mean .y_median         .y_hi
         <ord>    <dbl> <int>     <dbl>     <dbl>     <dbl>     <dbl>         <dbl>
       1 FALSE     1.50     0  9.93e-11 -1.11e- 5  9.93e-11  4.34e-10 0.0000111    
       2 TRUE      1.50     1  9.93e-11 -1.62e- 2  9.93e-11  5.51e-10 0.0162       
       3 FALSE     1.94     0  9.85e-11 -2.01e- 2  9.85e-11 -1.47e-10 0.0201       
       4 TRUE      1.94     7 -4.37e-10 -3.64e- 2 -4.37e-10 -5.09e-11 0.0364       
       5 FALSE     2.46     1  7.33e-11 -2.01e- 2  7.33e-11 -1.75e-10 0.0201       
       6 TRUE      2.46     6 -5.10e-10 -3.64e- 2 -5.10e-10 -7.92e-11 0.0364       
       7 FALSE     2.79     1  1.10e- 9  1.67e-10  1.10e- 9  1.45e- 9 0.00000000174
       8 TRUE      2.79     6  1.32e- 9 -1.62e- 2  1.32e- 9  3.24e- 9 0.0162       
       9 FALSE     3.19     3  1.34e- 9 -9.74e- 3  1.34e- 9  1.51e- 9 0.00974      
      10 TRUE      3.19     4  1.56e- 9 -3.64e- 2  1.56e- 9  2.66e- 9 0.0364       
      11 FALSE     3.44     7  1.34e- 9 -2.01e- 2  1.34e- 9  1.51e- 9 0.0201       
      12 TRUE      3.44     0  1.56e- 9 -3.64e- 2  1.56e- 9  2.66e- 9 0.0364       
      13 FALSE     3.52     7  1.34e- 9 -2.01e- 2  1.34e- 9  1.51e- 9 0.0201       
      14 TRUE      3.52     0  1.56e- 9 -1.62e- 2  1.56e- 9  2.90e- 9 0.0162       
      15 FALSE     3.73     5  1.34e- 9 -1.69e- 5  1.34e- 9  2.11e- 9 0.0000169    
      16 TRUE      3.73     2  1.56e- 9 -2.60e- 2  1.56e- 9  2.66e- 9 0.0260       
      17 FALSE     4.05     7  1.34e- 9 -2.01e- 2  1.34e- 9  1.51e- 9 0.0201       
      18 TRUE      4.05     0  1.56e- 9 -3.64e- 2  1.56e- 9  2.66e- 9 0.0364       
      19 FALSE     5.45     7  1.34e- 9 -2.01e- 2  1.34e- 9  1.51e- 9 0.0201       
      20 TRUE      5.45     0  1.56e- 9 -3.64e- 2  1.56e- 9  2.66e- 9 0.0364       
      
      $`North America`$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n     .y  .y_lo .y_mean .y_median  .y_hi
         <ord>               <ord>    <int>  <dbl>  <dbl>   <dbl>     <dbl>  <dbl>
       1 Lincoln Continental three        2 -0.117 -0.117  -0.117   -0.117  -0.117
       2 Cadillac Fleetwood  three        2 -0.117 -0.117  -0.117   -0.117  -0.117
       3 Merc 450SL          three        2 -0.119 -0.122  -0.119   -0.117  -0.117
       4 Merc 450SLC         three        2 -0.285 -0.596  -0.285   -0.117  -0.117
       5 Camaro Z28          three        2 -0.455 -1.08   -0.455   -0.117  -0.117
       6 Chrysler Imperial   three        2 -0.289 -1.42   -0.289    0.305   0.337
       7 Duster 360          three        2 -0.289 -1.15   -0.289    0.0335  0.303
       8 Merc 450SE          three        2 -0.289 -1.15   -0.289    0.0334  0.303
       9 Hornet Sportabout   three        2 -0.289 -1.59   -0.289    0.398   0.432
      10 AMC Javelin         three        2 -0.125 -1.13   -0.125    0.285   0.534
      # i 86 more rows
      
      $`North America`$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0 0.471  0.471   0.471     0.471 0.471
       2 Cadillac Fleetwood          1     0 0.471  0.471   0.471     0.471 0.471
       3 Merc 450SL                  1     0 0.471  0.471   0.471     0.471 0.471
       4 Merc 450SLC                 1     0 0.471  0.471   0.471     0.471 0.471
       5 Camaro Z28                  1     0 0.471  0.471   0.471     0.471 0.471
       6 Chrysler Imperial           1     0 0.471 -1.49    0.471    -0.690 3.42 
       7 Duster 360                  1     0 0.471 -5.32    0.471    -0.895 7.42 
       8 Merc 450SE                  1     0 0.471 -6.40    0.471    -0.895 8.51 
       9 Hornet Sportabout           1     0 0.471 -6.67    0.471    -0.895 8.77 
      10 AMC Javelin                 1     0 0.471 -6.76    0.471    -0.895 8.87 
      # i 150 more rows
      
      $`North America`$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>                 <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 Lincoln Continental    1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       2 Cadillac Fleetwood     1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       3 Merc 450SL             1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       4 Merc 450SLC            1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       5 Camaro Z28             1.50     0 0.0603  0.0527   0.0603   0.0602  0.0681
       6 Chrysler Imperial      1.50     0 0.0603  0.00257  0.0603   0.00402 0.166 
       7 Duster 360             1.50     0 0.0603 -0.239    0.0603   0.00402 0.407 
       8 Merc 450SE             1.50     0 0.0603 -0.301    0.0603   0.00402 0.470 
       9 Hornet Sportabout      1.50     0 0.0603 -0.317    0.0603   0.00402 0.486 
      10 AMC Javelin            1.50     0 0.0603 -0.317    0.0603   0.00402 0.486 
      # i 310 more rows
      
      $`North America`$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n      .y  .y_lo .y_mean .y_median    .y_hi
         <ord>        <dbl> <int>   <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
       1 three            1     6 -0.0306 -0.106 -0.0306   -0.0663  0.0748 
       2 four             1     8 -0.0306 -0.153 -0.0306   -0.0698  0.125  
       3 five             1     0 -0.0306 -0.156 -0.0306   -0.0698  0.128  
       4 three            2     8 -0.0331 -0.206 -0.0331   -0.0775  0.177  
       5 four             2     7 -0.129  -0.341 -0.129    -0.227   0.167  
       6 five             2     4 -0.129  -0.241 -0.129    -0.226   0.0664 
       7 three            3     7 -0.0403 -0.154 -0.0403   -0.0940  0.119  
       8 four             3     2 -0.159  -0.322 -0.159    -0.257   0.0858 
       9 five             3     0 -0.160  -0.374 -0.160    -0.257   0.135  
      10 three            4     8 -0.0518 -0.208 -0.0518   -0.112   0.155  
      11 four             4     6 -0.317  -0.437 -0.317    -0.427  -0.105  
      12 five             4     2 -0.322  -0.494 -0.322    -0.433  -0.0547 
      13 three            8     1 -0.0518 -0.158 -0.0518   -0.114   0.108  
      14 four             8     1 -0.317  -0.534 -0.317    -0.431  -0.00255
      15 five             8     4 -0.321  -0.544 -0.321    -0.432  -0.00476
      
      $`North America`$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n      .y   .y_lo .y_mean .y_median   .y_hi
         <ord>      <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl>   <dbl>
       1 three       1.50     0 -0.0342 -0.0869 -0.0342   -0.0210 0.00727
       2 four        1.50     0 -0.0342 -0.0958 -0.0342   -0.0210 0.0162 
       3 five        1.50     1 -0.0342 -0.102  -0.0342   -0.0184 0.0202 
       4 three       1.94     0 -0.0448 -0.115  -0.0448   -0.0504 0.0301 
       5 four        1.94     6 -0.0529 -0.152  -0.0529   -0.0553 0.0484 
       6 five        1.94     1 -0.0529 -0.152  -0.0529   -0.0553 0.0484 
       7 three       2.46     1 -0.0466 -0.137  -0.0466   -0.0557 0.0510 
       8 four        2.46     4 -0.0603 -0.159  -0.0603   -0.0648 0.0428 
       9 five        2.46     2 -0.0603 -0.159  -0.0603   -0.0648 0.0428 
      10 three       2.79     1 -0.0468 -0.137  -0.0468   -0.0559 0.0509 
      # i 20 more rows
      
      $`North America`$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n           .y    .y_lo      .y_mean .y_median   .y_hi
             <dbl>   <dbl> <int>        <dbl>    <dbl>        <dbl>     <dbl>   <dbl>
       1         1    1.50     0 0.0000000171 -0.0315  0.0000000171  -1.68e-7 0.0315 
       2         2    1.50     1 0.0000000171 -0.00404 0.0000000171  -1.03e-8 0.00404
       3         3    1.50     0 0.0000000171 -0.0356  0.0000000171  -1.96e-7 0.0356 
       4         4    1.50     0 0.0000000171 -0.0267  0.0000000171  -1.34e-7 0.0267 
       5         8    1.50     0 0.0000000171 -0.0362  0.0000000171  -1.95e-7 0.0362 
       6         1    1.94     4 0.0000000171 -0.0394  0.0000000171  -1.98e-7 0.0394 
       7         2    1.94     3 0.000000105  -0.00790 0.000000105   -5.22e-9 0.00790
       8         3    1.94     0 0.000000105  -0.0394  0.000000105   -1.91e-7 0.0394 
       9         4    1.94     0 0.000000105  -0.0300  0.000000105   -1.26e-7 0.0300 
      10         8    1.94     0 0.000000105  -0.0394  0.000000105   -1.88e-7 0.0394 
      # i 40 more rows
      
      
      

---

    Code
      get(cat_cars_ale, what = "boot_data")
    Output
      $Asia
      $Asia$d1
      $Asia$d1$mpg
      # A tibble: 30 x 6
           .it   mpg .y_composite    .n .y_distinct       .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4     1.20e-14     1    1.20e-14 1.20e-14
       2     0  14.4     1.20e-14     7    1.20e-14 1.20e-14
       3     0  15.2     1.20e-14     7    1.20e-14 1.20e-14
       4     0  16.4     1.20e-14     7    1.20e-14 1.20e-14
       5     0  18.7     1.20e-14     7    1.20e-14 1.20e-14
       6     0  19.8     1.20e-14     7    1.20e-14 1.20e-14
       7     0  21.4     1.20e-14     7    1.20e-14 1.20e-14
       8     0  22.9     1.20e-14     7    1.20e-14 1.20e-14
       9     0  30.1     1.20e-14     7    1.20e-14 1.20e-14
      10     0  33.9     1.20e-14     7    1.20e-14 1.20e-14
      # i 20 more rows
      
      $Asia$d1$vs
      # A tibble: 6 x 6
          .it vs    .y_composite    .n .y_distinct       .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
      1     0 FALSE     1.20e-14    36    1.20e-14 1.20e-14
      2     0 TRUE      1.20e-14    28    1.20e-14 1.20e-14
      3     1 FALSE     1.20e-14    36    1.20e-14 1.20e-14
      4     1 TRUE      1.20e-14    28    1.20e-14 1.20e-14
      5     2 FALSE     1.20e-14    36    1.20e-14 1.20e-14
      6     2 TRUE      1.20e-14    28    1.20e-14 1.20e-14
      
      $Asia$d1$am
      # A tibble: 6 x 6
          .it am    .y_composite    .n .y_distinct       .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
      1     0 FALSE     -0.0432     38    -0.0432  -0.0432 
      2     0 TRUE       0.0632     26     0.0632   0.0632 
      3     1 FALSE      0.0321     38     0.0321   0.0321 
      4     1 TRUE      -0.0101     26    -0.0101  -0.0101 
      5     2 FALSE      0.0297     38     0.0297   0.0297 
      6     2 TRUE      -0.00670    26    -0.00670 -0.00670
      
      $Asia$d1$model
      # A tibble: 96 x 6
           .it model               .y_composite    .n .y_distinct     .y
         <dbl> <fct>                      <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental       -0.305     2      -0.305 -0.305
       2     0 Cadillac Fleetwood        -0.305     2      -0.305 -0.305
       3     0 Merc 450SL                -0.305     2      -0.305 -0.305
       4     0 Merc 450SLC               -0.305     2      -0.305 -0.305
       5     0 Camaro Z28                -0.305     2      -0.305 -0.305
       6     0 Chrysler Imperial         -0.305     2      -0.305 -0.305
       7     0 Duster 360                -0.305     2      -0.305 -0.305
       8     0 Merc 450SE                -0.305     2      -0.305 -0.305
       9     0 Hornet Sportabout         -0.305     2      -0.305 -0.305
      10     0 AMC Javelin               -0.305     2      -0.305 -0.305
      # i 86 more rows
      
      $Asia$d1$gear
      # A tibble: 9 x 6
          .it gear  .y_composite    .n .y_distinct       .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
      1     0 three      0.118      30     0.118    0.118  
      2     0 four       0.0718     24     0.0718   0.0718 
      3     0 five      -0.526      10    -0.526   -0.526  
      4     1 three      0.0530     30     0.0530   0.0530 
      5     1 four      -0.162      24    -0.162   -0.162  
      6     1 five      -0.460      10    -0.460   -0.460  
      7     2 three      0.184      30     0.184    0.184  
      8     2 four       0.0960     24     0.0960   0.0960 
      9     2 five      -0.00410    10    -0.00410 -0.00410
      
      $Asia$d1$carb
      # A tibble: 15 x 6
           .it  carb .y_composite    .n .y_distinct         .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>      <dbl>
       1     0     1    0.00549      14   0.00549    0.00549  
       2     0     2   -0.00191      19  -0.00191   -0.00191  
       3     0     3   -0.00191       9  -0.00191   -0.00191  
       4     0     4   -0.00191      16  -0.00191   -0.00191  
       5     0     8   -0.00191       6  -0.00191   -0.00191  
       6     1     1    0.00549      18   0.00549    0.00549  
       7     1     2   -0.00377      16  -0.00377   -0.00377  
       8     1     3   -0.00377      13  -0.00377   -0.00377  
       9     1     4   -0.00377      15  -0.00377   -0.00377  
      10     1     8   -0.00377       2  -0.00377   -0.00377  
      11     2     1    0.00549      15   0.00549    0.00549  
      12     2     2   -0.0000232    13  -0.0000232 -0.0000232
      13     2     3   -0.0000232    13  -0.0000232 -0.0000232
      14     2     4   -0.0000232    20  -0.0000232 -0.0000232
      15     2     8   -0.0000232     3  -0.0000232 -0.0000232
      
      $Asia$d1$wt
      # A tibble: 30 x 6
           .it    wt .y_composite    .n .y_distinct          .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>       <dbl>
       1     0  1.50   0.0000319      1  0.0000319   0.0000319 
       2     0  1.94   0.00000854     7  0.00000854  0.00000854
       3     0  2.46  -0.00000364     7 -0.00000364 -0.00000364
       4     0  2.79  -0.00000366     7 -0.00000366 -0.00000366
       5     0  3.19  -0.00000366     7 -0.00000366 -0.00000366
       6     0  3.44  -0.00000366     7 -0.00000366 -0.00000366
       7     0  3.52  -0.00000366     7 -0.00000366 -0.00000366
       8     0  3.73  -0.00000366     7 -0.00000366 -0.00000366
       9     0  4.05  -0.00000366     7 -0.00000366 -0.00000366
      10     0  5.45  -0.00000366     7 -0.00000366 -0.00000366
      # i 20 more rows
      
      
      $Asia$d2
      $Asia$d2$`mpg:vs`
      # A tibble: 60 x 7
           .it   mpg vs    .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 FALSE     1.20e-14     1    1.20e-14 1.20e-14
       2     0  14.4 FALSE     1.20e-14     7    1.20e-14 1.20e-14
       3     0  15.2 FALSE     1.20e-14     7    1.20e-14 1.20e-14
       4     0  16.4 FALSE     1.20e-14     7    1.20e-14 1.20e-14
       5     0  18.7 FALSE     1.20e-14     3    1.20e-14 1.20e-14
       6     0  19.8 FALSE     1.20e-14     5    1.20e-14 1.20e-14
       7     0  21.4 FALSE     1.20e-14     4    1.20e-14 1.20e-14
       8     0  22.9 FALSE     1.20e-14     0    1.20e-14 1.20e-14
       9     0  30.1 FALSE     1.20e-14     2    1.20e-14 1.20e-14
      10     0  33.9 FALSE     1.20e-14     0    1.20e-14 1.20e-14
      # i 50 more rows
      
      $Asia$d2$`mpg:am`
      # A tibble: 60 x 7
           .it   mpg am    .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 FALSE     1.20e-14     1    1.20e-14 1.20e-14
       2     0  14.4 FALSE     1.20e-14     7    1.20e-14 1.20e-14
       3     0  15.2 FALSE     1.20e-14     5    1.20e-14 1.20e-14
       4     0  16.4 FALSE     1.20e-14     5    1.20e-14 1.20e-14
       5     0  18.7 FALSE     1.20e-14     7    1.20e-14 1.20e-14
       6     0  19.8 FALSE     1.20e-14     5    1.20e-14 1.20e-14
       7     0  21.4 FALSE     1.20e-14     1    1.20e-14 1.20e-14
       8     0  22.9 FALSE     1.20e-14     5    1.20e-14 1.20e-14
       9     0  30.1 FALSE     1.20e-14     2    1.20e-14 1.20e-14
      10     0  33.9 FALSE     1.20e-14     0    1.20e-14 1.20e-14
      # i 50 more rows
      
      $Asia$d2$`mpg:model`
      # A tibble: 960 x 7
           .it   mpg model               .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>                      <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
       2     0  14.4 Lincoln Continental     1.20e-14     2    1.20e-14 1.20e-14
       3     0  15.2 Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
       4     0  16.4 Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
       5     0  18.7 Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
       6     0  19.8 Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
       7     0  21.4 Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
       8     0  22.9 Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
       9     0  30.1 Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
      10     0  33.9 Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
      # i 950 more rows
      
      $Asia$d2$`mpg:gear`
      # A tibble: 90 x 7
           .it   mpg gear  .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 three     1.20e-14     1    1.20e-14 1.20e-14
       2     0  14.4 three     1.20e-14     7    1.20e-14 1.20e-14
       3     0  15.2 three     1.20e-14     5    1.20e-14 1.20e-14
       4     0  16.4 three     1.20e-14     5    1.20e-14 1.20e-14
       5     0  18.7 three     1.20e-14     5    1.20e-14 1.20e-14
       6     0  19.8 three     1.20e-14     3    1.20e-14 1.20e-14
       7     0  21.4 three     1.20e-14     1    1.20e-14 1.20e-14
       8     0  22.9 three     1.20e-14     3    1.20e-14 1.20e-14
       9     0  30.1 three     1.20e-14     0    1.20e-14 1.20e-14
      10     0  33.9 three     1.20e-14     0    1.20e-14 1.20e-14
      # i 80 more rows
      
      $Asia$d2$`mpg:carb`
      # A tibble: 150 x 7
           .it   mpg  carb .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4     1     1.20e-14     0    1.20e-14 1.20e-14
       2     0  14.4     1     1.20e-14     0    1.20e-14 1.20e-14
       3     0  15.2     1     1.20e-14     0    1.20e-14 1.20e-14
       4     0  16.4     1     1.20e-14     0    1.20e-14 1.20e-14
       5     0  18.7     1     1.20e-14     2    1.20e-14 1.20e-14
       6     0  19.8     1     1.20e-14     0    1.20e-14 1.20e-14
       7     0  21.4     1     1.20e-14     1    1.20e-14 1.20e-14
       8     0  22.9     1     1.20e-14     5    1.20e-14 1.20e-14
       9     0  30.1     1     1.20e-14     2    1.20e-14 1.20e-14
      10     0  33.9     1     1.20e-14     4    1.20e-14 1.20e-14
      # i 140 more rows
      
      $Asia$d2$`mpg:wt`
      # A tibble: 300 x 7
           .it   mpg    wt .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4  1.50     1.20e-14     0    1.20e-14 1.20e-14
       2     0  14.4  1.50     1.20e-14     0    1.20e-14 1.20e-14
       3     0  15.2  1.50     1.20e-14     0    1.20e-14 1.20e-14
       4     0  16.4  1.50     1.20e-14     0    1.20e-14 1.20e-14
       5     0  18.7  1.50     1.20e-14     0    1.20e-14 1.20e-14
       6     0  19.8  1.50     1.20e-14     0    1.20e-14 1.20e-14
       7     0  21.4  1.50     1.20e-14     0    1.20e-14 1.20e-14
       8     0  22.9  1.50     1.20e-14     0    1.20e-14 1.20e-14
       9     0  30.1  1.50     1.20e-14     1    1.20e-14 1.20e-14
      10     0  33.9  1.50     1.20e-14     0    1.20e-14 1.20e-14
      # i 290 more rows
      
      $Asia$d2$`vs:am`
      # A tibble: 12 x 7
           .it vs    am    .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE FALSE     1.20e-14    24    1.20e-14 1.20e-14
       2     0 TRUE  FALSE     1.20e-14    14    1.20e-14 1.20e-14
       3     0 FALSE TRUE      1.20e-14    12    1.20e-14 1.20e-14
       4     0 TRUE  TRUE      1.20e-14    14    1.20e-14 1.20e-14
       5     1 FALSE FALSE     1.20e-14    24    1.20e-14 1.20e-14
       6     1 TRUE  FALSE     1.20e-14    14    1.20e-14 1.20e-14
       7     1 FALSE TRUE      1.20e-14    12    1.20e-14 1.20e-14
       8     1 TRUE  TRUE      1.20e-14    14    1.20e-14 1.20e-14
       9     2 FALSE FALSE     1.20e-14    24    1.20e-14 1.20e-14
      10     2 TRUE  FALSE     1.20e-14    14    1.20e-14 1.20e-14
      11     2 FALSE TRUE      1.20e-14    12    1.20e-14 1.20e-14
      12     2 TRUE  TRUE      1.20e-14    14    1.20e-14 1.20e-14
      
      $Asia$d2$`vs:model`
      # A tibble: 192 x 7
           .it vs    model               .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE Lincoln Continental     1.20e-14     2    1.20e-14 1.20e-14
       2     0 TRUE  Lincoln Continental     1.20e-14     0    1.20e-14 1.20e-14
       3     0 FALSE Cadillac Fleetwood      1.20e-14     2    1.20e-14 1.20e-14
       4     0 TRUE  Cadillac Fleetwood      1.20e-14     0    1.20e-14 1.20e-14
       5     0 FALSE Merc 450SL              1.20e-14     2    1.20e-14 1.20e-14
       6     0 TRUE  Merc 450SL              1.20e-14     0    1.20e-14 1.20e-14
       7     0 FALSE Merc 450SLC             1.20e-14     2    1.20e-14 1.20e-14
       8     0 TRUE  Merc 450SLC             1.20e-14     0    1.20e-14 1.20e-14
       9     0 FALSE Camaro Z28              1.20e-14     2    1.20e-14 1.20e-14
      10     0 TRUE  Camaro Z28              1.20e-14     0    1.20e-14 1.20e-14
      # i 182 more rows
      
      $Asia$d2$`vs:gear`
      # A tibble: 18 x 7
           .it vs    gear  .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE three     1.20e-14    24    1.20e-14 1.20e-14
       2     0 TRUE  three     1.20e-14     6    1.20e-14 1.20e-14
       3     0 FALSE four      1.20e-14     4    1.20e-14 1.20e-14
       4     0 TRUE  four      1.20e-14    20    1.20e-14 1.20e-14
       5     0 FALSE five      1.20e-14     8    1.20e-14 1.20e-14
       6     0 TRUE  five      1.20e-14     2    1.20e-14 1.20e-14
       7     1 FALSE three     1.20e-14    24    1.20e-14 1.20e-14
       8     1 TRUE  three     1.20e-14     6    1.20e-14 1.20e-14
       9     1 FALSE four      1.20e-14     4    1.20e-14 1.20e-14
      10     1 TRUE  four      1.20e-14    20    1.20e-14 1.20e-14
      11     1 FALSE five      1.20e-14     8    1.20e-14 1.20e-14
      12     1 TRUE  five      1.20e-14     2    1.20e-14 1.20e-14
      13     2 FALSE three     1.20e-14    24    1.20e-14 1.20e-14
      14     2 TRUE  three     1.20e-14     6    1.20e-14 1.20e-14
      15     2 FALSE four      1.20e-14     4    1.20e-14 1.20e-14
      16     2 TRUE  four      1.20e-14    20    1.20e-14 1.20e-14
      17     2 FALSE five      1.20e-14     8    1.20e-14 1.20e-14
      18     2 TRUE  five      1.20e-14     2    1.20e-14 1.20e-14
      
      $Asia$d2$`vs:carb`
      # A tibble: 30 x 7
           .it vs     carb .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE     1     1.20e-14     0    1.20e-14 1.20e-14
       2     0 TRUE      1     1.20e-14    14    1.20e-14 1.20e-14
       3     0 FALSE     2     1.20e-14    10    1.20e-14 1.20e-14
       4     0 TRUE      2     1.20e-14     9    1.20e-14 1.20e-14
       5     0 FALSE     3     1.20e-14     8    1.20e-14 1.20e-14
       6     0 TRUE      3     1.20e-14     1    1.20e-14 1.20e-14
       7     0 FALSE     4     1.20e-14    13    1.20e-14 1.20e-14
       8     0 TRUE      4     1.20e-14     3    1.20e-14 1.20e-14
       9     0 FALSE     8     1.20e-14     5    1.20e-14 1.20e-14
      10     0 TRUE      8     1.20e-14     1    1.20e-14 1.20e-14
      # i 20 more rows
      
      $Asia$d2$`vs:wt`
      # A tibble: 60 x 7
           .it vs       wt .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE  1.50     1.20e-14     0    1.20e-14 1.20e-14
       2     0 TRUE   1.50     1.20e-14     1    1.20e-14 1.20e-14
       3     0 FALSE  1.94     1.20e-14     0    1.20e-14 1.20e-14
       4     0 TRUE   1.94     1.20e-14     7    1.20e-14 1.20e-14
       5     0 FALSE  2.46     1.20e-14     2    1.20e-14 1.20e-14
       6     0 TRUE   2.46     1.20e-14     5    1.20e-14 1.20e-14
       7     0 FALSE  2.79     1.20e-14     4    1.20e-14 1.20e-14
       8     0 TRUE   2.79     1.20e-14     3    1.20e-14 1.20e-14
       9     0 FALSE  3.19     1.20e-14     4    1.20e-14 1.20e-14
      10     0 TRUE   3.19     1.20e-14     3    1.20e-14 1.20e-14
      # i 50 more rows
      
      $Asia$d2$`am:model`
      # A tibble: 192 x 7
           .it am    model               .y_composite    .n .y_distinct     .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl>  <dbl>
       1     0 FALSE Lincoln Continental        0.106     2       0.106  0.106
       2     0 TRUE  Lincoln Continental        0.106     0      -1.38  -1.38 
       3     0 FALSE Cadillac Fleetwood         0.106     2       0.106  0.106
       4     0 TRUE  Cadillac Fleetwood         0.106     0      -1.38  -1.38 
       5     0 FALSE Merc 450SL                 0.106     2       0.106  0.106
       6     0 TRUE  Merc 450SL                 0.106     0      -1.38  -1.38 
       7     0 FALSE Merc 450SLC                0.106     2       0.106  0.106
       8     0 TRUE  Merc 450SLC                0.106     0      -1.38  -1.38 
       9     0 FALSE Camaro Z28                 0.106     2       0.106  0.106
      10     0 TRUE  Camaro Z28                 0.106     0      -1.38  -1.38 
      # i 182 more rows
      
      $Asia$d2$`am:gear`
      # A tibble: 18 x 7
           .it am    gear  .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE three     -0.0688     30    -0.0688  -0.0688 
       2     0 TRUE  three     -0.0688      0     0.453    0.453  
       3     0 FALSE four      -0.0688      8    -0.0688  -0.0688 
       4     0 TRUE  four      -0.466      16     0.0563   0.0563 
       5     0 FALSE five      -0.0688      0    -0.0688  -0.0688 
       6     0 TRUE  five      -1.06       10    -0.541   -0.541  
       7     1 FALSE three     -0.204      30    -0.204   -0.204  
       8     1 TRUE  three     -0.204       0    -0.104   -0.104  
       9     1 FALSE four      -0.340       8    -0.340   -0.340  
      10     1 TRUE  four      -0.607      16    -0.507   -0.507  
      11     1 FALSE five      -0.340       0    -0.340   -0.340  
      12     1 TRUE  five      -0.905      10    -0.806   -0.806  
      13     2 FALSE three     -0.00554    30    -0.00554 -0.00554
      14     2 TRUE  three     -0.00554     0    -0.628   -0.628  
      15     2 FALSE four      -0.165       8    -0.165   -0.165  
      16     2 TRUE  four      -0.228      16    -0.850   -0.850  
      17     2 FALSE five      -0.165       0    -0.165   -0.165  
      18     2 TRUE  five      -0.328      10    -0.950   -0.950  
      
      $Asia$d2$`am:carb`
      # A tibble: 30 x 7
           .it am     carb .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE     1      0.0166      6      0.0166  0.0166
       2     0 TRUE      1      0.0166      8     -0.107  -0.107 
       3     0 FALSE     2      0.0166     12     -0.0662 -0.0662
       4     0 TRUE      2     -0.00350     7     -0.213  -0.213 
       5     0 FALSE     3      0.0166      7      0.0203  0.0203
       6     0 TRUE      3     -0.00342     2     -0.127  -0.127 
       7     0 FALSE     4      0.0166     11     -0.0662 -0.0662
       8     0 TRUE      4      0.550       5      0.423   0.423 
       9     0 FALSE     8      0.0166      2      0.0203  0.0203
      10     0 TRUE      8      0.550       4      0.340   0.340 
      # i 20 more rows
      
      $Asia$d2$`am:wt`
      # A tibble: 60 x 7
           .it am       wt .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE  1.50       0.0139     0     0.0139   0.0139 
       2     0 TRUE   1.50       0.0139     1    -0.00322 -0.00322
       3     0 FALSE  1.94       0.0139     0     0.00361  0.00361
       4     0 TRUE   1.94       0.0138     7    -0.0244  -0.0244 
       5     0 FALSE  2.46       0.0139     1    -0.00732 -0.00732
       6     0 TRUE   2.46       0.0138     6    -0.0245  -0.0245 
       7     0 FALSE  2.79       0.0139     1    -0.00732 -0.00732
       8     0 TRUE   2.79       0.0378     6     0.0207   0.0207 
       9     0 FALSE  3.19       0.0139     3     0.0139   0.0139 
      10     0 TRUE   3.19       0.0761     4     0.0487   0.0487 
      # i 50 more rows
      
      $Asia$d2$`model:gear`
      # A tibble: 288 x 7
           .it model               gear  .y_composite    .n .y_distinct      .y
         <dbl> <fct>               <fct>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 Lincoln Continental three       -0.184     2     -0.184  -0.184 
       2     0 Cadillac Fleetwood  three       -0.184     2     -0.184  -0.184 
       3     0 Merc 450SL          three       -0.184     2     -0.184  -0.184 
       4     0 Merc 450SLC         three       -0.184     2     -0.184  -0.184 
       5     0 Camaro Z28          three       -0.184     2     -0.184  -0.184 
       6     0 Chrysler Imperial   three       -0.184     2      0.274   0.274 
       7     0 Duster 360          three       -0.184     2      0.272   0.272 
       8     0 Merc 450SE          three       -0.184     2      0.250   0.250 
       9     0 Hornet Sportabout   three       -0.184     2      0.250   0.250 
      10     0 AMC Javelin         three       -0.184     2     -0.0198 -0.0198
      # i 278 more rows
      
      $Asia$d2$`model:carb`
      # A tibble: 480 x 7
           .it model                carb .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental     1         3.42     0       3.42   3.42 
       2     0 Cadillac Fleetwood      1         3.42     0       3.42   3.42 
       3     0 Merc 450SL              1         3.42     0       3.42   3.42 
       4     0 Merc 450SLC             1         3.42     0       3.42   3.42 
       5     0 Camaro Z28              1         3.42     0       3.42   3.42 
       6     0 Chrysler Imperial       1         3.42     0       3.00   3.00 
       7     0 Duster 360              1         3.42     0      -0.418 -0.418
       8     0 Merc 450SE              1         3.42     0      -3.32  -3.32 
       9     0 Hornet Sportabout       1         3.42     0      -3.74  -3.74 
      10     0 AMC Javelin             1         3.42     0      -4.12  -4.12 
      # i 470 more rows
      
      $Asia$d2$`model:wt`
      # A tibble: 960 x 7
           .it model                  wt .y_composite    .n .y_distinct      .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 Lincoln Continental  1.50        0.342     0      0.342   0.342 
       2     0 Cadillac Fleetwood   1.50        0.342     0      0.342   0.342 
       3     0 Merc 450SL           1.50        0.342     0      0.342   0.342 
       4     0 Merc 450SLC          1.50        0.342     0      0.342   0.342 
       5     0 Camaro Z28           1.50        0.342     0      0.342   0.342 
       6     0 Chrysler Imperial    1.50        0.342     0      0.342   0.342 
       7     0 Duster 360           1.50        0.342     0      0.284   0.284 
       8     0 Merc 450SE           1.50        0.342     0     -0.0324 -0.0324
       9     0 Hornet Sportabout    1.50        0.342     0     -0.0439 -0.0439
      10     0 AMC Javelin          1.50        0.342     0     -0.0520 -0.0520
      # i 950 more rows
      
      $Asia$d2$`gear:carb`
      # A tibble: 45 x 7
           .it gear   carb .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 three     1       0.0284     6      0.0284  0.0284
       2     0 four      1       0.0284     8     -0.0211 -0.0211
       3     0 five      1       0.0284     0     -0.0245 -0.0245
       4     0 three     2       0.0284     8     -0.0766 -0.0766
       5     0 four      2       0.162      7      0.0573  0.0573
       6     0 five      2       0.130      4      0.130   0.130 
       7     0 three     3       0.0284     7     -0.0211 -0.0211
       8     0 four      3       0.193      2      0.140   0.140 
       9     0 five      3       0.147      0      0.0422  0.0422
      10     0 three     4       0.0284     8     -0.0767 -0.0767
      # i 35 more rows
      
      $Asia$d2$`gear:wt`
      # A tibble: 90 x 7
           .it gear     wt .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 three  1.50       0.0363     0     0.0363   0.0363 
       2     0 four   1.50       0.0363     0     0.0269   0.0269 
       3     0 five   1.50       0.0363     1     0.0202   0.0202 
       4     0 three  1.94       0.0363     0     0.00815  0.00815
       5     0 four   1.94       0.0527     6     0.00226  0.00226
       6     0 five   1.94       0.0535     1     0.00298  0.00298
       7     0 three  2.46       0.0363     1    -0.0141  -0.0141 
       8     0 four   2.46       0.0599     4     0.00943  0.00943
       9     0 five   2.46       0.0786     2     0.0281   0.0281 
      10     0 three  2.79       0.0363     1    -0.0141  -0.0141 
      # i 80 more rows
      
      $Asia$d2$`carb:wt`
      # A tibble: 150 x 7
           .it  carb    wt .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0     1  1.50      0.00454     0     0.00454  0.00454
       2     0     2  1.50      0.00454     1    -0.0287  -0.0287 
       3     0     3  1.50      0.00454     0    -0.0230  -0.0230 
       4     0     4  1.50      0.00454     0    -0.0329  -0.0329 
       5     0     8  1.50      0.00454     0    -0.0335  -0.0335 
       6     0     1  1.94      0.00454     4    -0.00377 -0.00377
       7     0     2  1.94      0.0244      3    -0.0171  -0.0171 
       8     0     3  1.94      0.0244      0    -0.00721 -0.00721
       9     0     4  1.94      0.0244      0    -0.0171  -0.0171 
      10     0     8  1.94      0.0244      0    -0.0171  -0.0171 
      # i 140 more rows
      
      
      
      $Europe
      $Europe$d1
      $Europe$d1$mpg
      # A tibble: 30 x 6
           .it   mpg .y_composite    .n .y_distinct       .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4     1.31e-14     1    1.31e-14 1.31e-14
       2     0  14.4     1.31e-14     7    1.31e-14 1.31e-14
       3     0  15.2     1.31e-14     7    1.31e-14 1.31e-14
       4     0  16.4     1.31e-14     7    1.31e-14 1.31e-14
       5     0  18.7     1.31e-14     7    1.31e-14 1.31e-14
       6     0  19.8     1.31e-14     7    1.31e-14 1.31e-14
       7     0  21.4     1.31e-14     7    1.31e-14 1.31e-14
       8     0  22.9     1.31e-14     7    1.31e-14 1.31e-14
       9     0  30.1     1.31e-14     7    1.31e-14 1.31e-14
      10     0  33.9     1.31e-14     7    1.31e-14 1.31e-14
      # i 20 more rows
      
      $Europe$d1$vs
      # A tibble: 6 x 6
          .it vs    .y_composite    .n .y_distinct       .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
      1     0 FALSE     1.31e-14    36    1.31e-14 1.31e-14
      2     0 TRUE      1.31e-14    28    1.31e-14 1.31e-14
      3     1 FALSE     1.31e-14    36    1.31e-14 1.31e-14
      4     1 TRUE      1.31e-14    28    1.31e-14 1.31e-14
      5     2 FALSE     1.31e-14    36    1.31e-14 1.31e-14
      6     2 TRUE      1.31e-14    28    1.31e-14 1.31e-14
      
      $Europe$d1$am
      # A tibble: 6 x 6
          .it am    .y_composite    .n .y_distinct       .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
      1     0 FALSE      0.0432     38     0.0432   0.0432 
      2     0 TRUE      -0.0632     26    -0.0632  -0.0632 
      3     1 FALSE     -0.0321     38    -0.0321  -0.0321 
      4     1 TRUE       0.0101     26     0.0101   0.0101 
      5     2 FALSE     -0.0297     38    -0.0297  -0.0297 
      6     2 TRUE       0.00670    26     0.00670  0.00670
      
      $Europe$d1$model
      # A tibble: 96 x 6
           .it model               .y_composite    .n .y_distinct    .y
         <dbl> <fct>                      <dbl> <dbl>       <dbl> <dbl>
       1     0 Lincoln Continental        0.166     2       0.166 0.166
       2     0 Cadillac Fleetwood         0.166     2       0.166 0.166
       3     0 Merc 450SL                 1.17      2       1.17  1.17 
       4     0 Merc 450SLC                1.17      2       1.17  1.17 
       5     0 Camaro Z28                 0.166     2       0.166 0.166
       6     0 Chrysler Imperial          0.166     2       0.166 0.166
       7     0 Duster 360                 0.166     2       0.166 0.166
       8     0 Merc 450SE                 1.17      2       1.17  1.17 
       9     0 Hornet Sportabout          0.166     2       0.166 0.166
      10     0 AMC Javelin                0.166     2       0.166 0.166
      # i 86 more rows
      
      $Europe$d1$gear
      # A tibble: 9 x 6
          .it gear  .y_composite    .n .y_distinct      .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>   <dbl>
      1     0 three      -0.372     30     -0.372  -0.372 
      2     0 four        0.211     24      0.211   0.211 
      3     0 five        0.610     10      0.610   0.610 
      4     1 three      -0.106     30     -0.106  -0.106 
      5     1 four        0.394     24      0.394   0.394 
      6     1 five        0.594     10      0.594   0.594 
      7     2 three      -0.239     30     -0.239  -0.239 
      8     2 four        0.136     24      0.136   0.136 
      9     2 five       -0.0638    10     -0.0638 -0.0638
      
      $Europe$d1$carb
      # A tibble: 15 x 6
           .it  carb .y_composite    .n .y_distinct         .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>      <dbl>
       1     0     1   -0.00549      14  -0.00549   -0.00549  
       2     0     2    0.00191      19   0.00191    0.00191  
       3     0     3    0.00191       9   0.00191    0.00191  
       4     0     4    0.00191      16   0.00191    0.00191  
       5     0     8    0.00191       6   0.00191    0.00191  
       6     1     1   -0.00549      18  -0.00549   -0.00549  
       7     1     2    0.00377      16   0.00377    0.00377  
       8     1     3    0.00377      13   0.00377    0.00377  
       9     1     4    0.00377      15   0.00377    0.00377  
      10     1     8    0.00377       2   0.00377    0.00377  
      11     2     1   -0.00549      15  -0.00549   -0.00549  
      12     2     2    0.0000232    13   0.0000232  0.0000232
      13     2     3    0.0000232    13   0.0000232  0.0000232
      14     2     4    0.0000232    20   0.0000232  0.0000232
      15     2     8    0.0000232     3   0.0000232  0.0000232
      
      $Europe$d1$wt
      # A tibble: 30 x 6
           .it    wt .y_composite    .n .y_distinct          .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>       <dbl>
       1     0  1.50  -0.0000319      1 -0.0000319  -0.0000319 
       2     0  1.94  -0.00000854     7 -0.00000854 -0.00000854
       3     0  2.46   0.00000364     7  0.00000364  0.00000364
       4     0  2.79   0.00000366     7  0.00000366  0.00000366
       5     0  3.19   0.00000366     7  0.00000366  0.00000366
       6     0  3.44   0.00000366     7  0.00000366  0.00000366
       7     0  3.52   0.00000366     7  0.00000366  0.00000366
       8     0  3.73   0.00000366     7  0.00000366  0.00000366
       9     0  4.05   0.00000366     7  0.00000366  0.00000366
      10     0  5.45   0.00000366     7  0.00000366  0.00000366
      # i 20 more rows
      
      
      $Europe$d2
      $Europe$d2$`mpg:vs`
      # A tibble: 60 x 7
           .it   mpg vs    .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 FALSE     1.31e-14     1    1.31e-14 1.31e-14
       2     0  14.4 FALSE     1.31e-14     7    1.31e-14 1.31e-14
       3     0  15.2 FALSE     1.31e-14     7    1.31e-14 1.31e-14
       4     0  16.4 FALSE     1.31e-14     7    1.31e-14 1.31e-14
       5     0  18.7 FALSE     1.31e-14     3    1.31e-14 1.31e-14
       6     0  19.8 FALSE     1.31e-14     5    1.31e-14 1.31e-14
       7     0  21.4 FALSE     1.31e-14     4    1.31e-14 1.31e-14
       8     0  22.9 FALSE     1.31e-14     0    1.31e-14 1.31e-14
       9     0  30.1 FALSE     1.31e-14     2    1.31e-14 1.31e-14
      10     0  33.9 FALSE     1.31e-14     0    1.31e-14 1.31e-14
      # i 50 more rows
      
      $Europe$d2$`mpg:am`
      # A tibble: 60 x 7
           .it   mpg am    .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 FALSE     1.31e-14     1    1.31e-14 1.31e-14
       2     0  14.4 FALSE     1.31e-14     7    1.31e-14 1.31e-14
       3     0  15.2 FALSE     1.31e-14     5    1.31e-14 1.31e-14
       4     0  16.4 FALSE     1.31e-14     5    1.31e-14 1.31e-14
       5     0  18.7 FALSE     1.31e-14     7    1.31e-14 1.31e-14
       6     0  19.8 FALSE     1.31e-14     5    1.31e-14 1.31e-14
       7     0  21.4 FALSE     1.31e-14     1    1.31e-14 1.31e-14
       8     0  22.9 FALSE     1.31e-14     5    1.31e-14 1.31e-14
       9     0  30.1 FALSE     1.31e-14     2    1.31e-14 1.31e-14
      10     0  33.9 FALSE     1.31e-14     0    1.31e-14 1.31e-14
      # i 50 more rows
      
      $Europe$d2$`mpg:model`
      # A tibble: 960 x 7
           .it   mpg model               .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>                      <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
       2     0  14.4 Lincoln Continental     1.31e-14     2    1.31e-14 1.31e-14
       3     0  15.2 Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
       4     0  16.4 Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
       5     0  18.7 Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
       6     0  19.8 Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
       7     0  21.4 Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
       8     0  22.9 Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
       9     0  30.1 Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
      10     0  33.9 Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
      # i 950 more rows
      
      $Europe$d2$`mpg:gear`
      # A tibble: 90 x 7
           .it   mpg gear  .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 three     1.31e-14     1    1.31e-14 1.31e-14
       2     0  14.4 three     1.31e-14     7    1.31e-14 1.31e-14
       3     0  15.2 three     1.31e-14     5    1.31e-14 1.31e-14
       4     0  16.4 three     1.31e-14     5    1.31e-14 1.31e-14
       5     0  18.7 three     1.31e-14     5    1.31e-14 1.31e-14
       6     0  19.8 three     1.31e-14     3    1.31e-14 1.31e-14
       7     0  21.4 three     1.31e-14     1    1.31e-14 1.31e-14
       8     0  22.9 three     1.31e-14     3    1.31e-14 1.31e-14
       9     0  30.1 three     1.31e-14     0    1.31e-14 1.31e-14
      10     0  33.9 three     1.31e-14     0    1.31e-14 1.31e-14
      # i 80 more rows
      
      $Europe$d2$`mpg:carb`
      # A tibble: 150 x 7
           .it   mpg  carb .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4     1     1.31e-14     0    1.31e-14 1.31e-14
       2     0  14.4     1     1.31e-14     0    1.31e-14 1.31e-14
       3     0  15.2     1     1.31e-14     0    1.31e-14 1.31e-14
       4     0  16.4     1     1.31e-14     0    1.31e-14 1.31e-14
       5     0  18.7     1     1.31e-14     2    1.31e-14 1.31e-14
       6     0  19.8     1     1.31e-14     0    1.31e-14 1.31e-14
       7     0  21.4     1     1.31e-14     1    1.31e-14 1.31e-14
       8     0  22.9     1     1.31e-14     5    1.31e-14 1.31e-14
       9     0  30.1     1     1.31e-14     2    1.31e-14 1.31e-14
      10     0  33.9     1     1.31e-14     4    1.31e-14 1.31e-14
      # i 140 more rows
      
      $Europe$d2$`mpg:wt`
      # A tibble: 300 x 7
           .it   mpg    wt .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4  1.50     1.31e-14     0    1.31e-14 1.31e-14
       2     0  14.4  1.50     1.31e-14     0    1.31e-14 1.31e-14
       3     0  15.2  1.50     1.31e-14     0    1.31e-14 1.31e-14
       4     0  16.4  1.50     1.31e-14     0    1.31e-14 1.31e-14
       5     0  18.7  1.50     1.31e-14     0    1.31e-14 1.31e-14
       6     0  19.8  1.50     1.31e-14     0    1.31e-14 1.31e-14
       7     0  21.4  1.50     1.31e-14     0    1.31e-14 1.31e-14
       8     0  22.9  1.50     1.31e-14     0    1.31e-14 1.31e-14
       9     0  30.1  1.50     1.31e-14     1    1.31e-14 1.31e-14
      10     0  33.9  1.50     1.31e-14     0    1.31e-14 1.31e-14
      # i 290 more rows
      
      $Europe$d2$`vs:am`
      # A tibble: 12 x 7
           .it vs    am    .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE FALSE     1.31e-14    24    1.31e-14 1.31e-14
       2     0 TRUE  FALSE     1.31e-14    14    1.31e-14 1.31e-14
       3     0 FALSE TRUE      1.31e-14    12    1.31e-14 1.31e-14
       4     0 TRUE  TRUE      1.31e-14    14    1.31e-14 1.31e-14
       5     1 FALSE FALSE     1.31e-14    24    1.31e-14 1.31e-14
       6     1 TRUE  FALSE     1.31e-14    14    1.31e-14 1.31e-14
       7     1 FALSE TRUE      1.31e-14    12    1.31e-14 1.31e-14
       8     1 TRUE  TRUE      1.31e-14    14    1.31e-14 1.31e-14
       9     2 FALSE FALSE     1.31e-14    24    1.31e-14 1.31e-14
      10     2 TRUE  FALSE     1.31e-14    14    1.31e-14 1.31e-14
      11     2 FALSE TRUE      1.31e-14    12    1.31e-14 1.31e-14
      12     2 TRUE  TRUE      1.31e-14    14    1.31e-14 1.31e-14
      
      $Europe$d2$`vs:model`
      # A tibble: 192 x 7
           .it vs    model               .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE Lincoln Continental     1.31e-14     2    1.31e-14 1.31e-14
       2     0 TRUE  Lincoln Continental     1.31e-14     0    1.31e-14 1.31e-14
       3     0 FALSE Cadillac Fleetwood      1.31e-14     2    1.31e-14 1.31e-14
       4     0 TRUE  Cadillac Fleetwood      1.31e-14     0    1.31e-14 1.31e-14
       5     0 FALSE Merc 450SL              1.31e-14     2    1.31e-14 1.31e-14
       6     0 TRUE  Merc 450SL              1.31e-14     0    1.31e-14 1.31e-14
       7     0 FALSE Merc 450SLC             1.31e-14     2    1.31e-14 1.31e-14
       8     0 TRUE  Merc 450SLC             1.31e-14     0    1.31e-14 1.31e-14
       9     0 FALSE Camaro Z28              1.31e-14     2    1.31e-14 1.31e-14
      10     0 TRUE  Camaro Z28              1.31e-14     0    1.31e-14 1.31e-14
      # i 182 more rows
      
      $Europe$d2$`vs:gear`
      # A tibble: 18 x 7
           .it vs    gear  .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE three     1.31e-14    24    1.31e-14 1.31e-14
       2     0 TRUE  three     1.31e-14     6    1.31e-14 1.31e-14
       3     0 FALSE four      1.31e-14     4    1.31e-14 1.31e-14
       4     0 TRUE  four      1.31e-14    20    1.31e-14 1.31e-14
       5     0 FALSE five      1.31e-14     8    1.31e-14 1.31e-14
       6     0 TRUE  five      1.31e-14     2    1.31e-14 1.31e-14
       7     1 FALSE three     1.31e-14    24    1.31e-14 1.31e-14
       8     1 TRUE  three     1.31e-14     6    1.31e-14 1.31e-14
       9     1 FALSE four      1.31e-14     4    1.31e-14 1.31e-14
      10     1 TRUE  four      1.31e-14    20    1.31e-14 1.31e-14
      11     1 FALSE five      1.31e-14     8    1.31e-14 1.31e-14
      12     1 TRUE  five      1.31e-14     2    1.31e-14 1.31e-14
      13     2 FALSE three     1.31e-14    24    1.31e-14 1.31e-14
      14     2 TRUE  three     1.31e-14     6    1.31e-14 1.31e-14
      15     2 FALSE four      1.31e-14     4    1.31e-14 1.31e-14
      16     2 TRUE  four      1.31e-14    20    1.31e-14 1.31e-14
      17     2 FALSE five      1.31e-14     8    1.31e-14 1.31e-14
      18     2 TRUE  five      1.31e-14     2    1.31e-14 1.31e-14
      
      $Europe$d2$`vs:carb`
      # A tibble: 30 x 7
           .it vs     carb .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE     1     1.31e-14     0    1.31e-14 1.31e-14
       2     0 TRUE      1     1.31e-14    14    1.31e-14 1.31e-14
       3     0 FALSE     2     1.31e-14    10    1.31e-14 1.31e-14
       4     0 TRUE      2     1.31e-14     9    1.31e-14 1.31e-14
       5     0 FALSE     3     1.31e-14     8    1.31e-14 1.31e-14
       6     0 TRUE      3     1.31e-14     1    1.31e-14 1.31e-14
       7     0 FALSE     4     1.31e-14    13    1.31e-14 1.31e-14
       8     0 TRUE      4     1.31e-14     3    1.31e-14 1.31e-14
       9     0 FALSE     8     1.31e-14     5    1.31e-14 1.31e-14
      10     0 TRUE      8     1.31e-14     1    1.31e-14 1.31e-14
      # i 20 more rows
      
      $Europe$d2$`vs:wt`
      # A tibble: 60 x 7
           .it vs       wt .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE  1.50     1.31e-14     0    1.31e-14 1.31e-14
       2     0 TRUE   1.50     1.31e-14     1    1.31e-14 1.31e-14
       3     0 FALSE  1.94     1.31e-14     0    1.31e-14 1.31e-14
       4     0 TRUE   1.94     1.31e-14     7    1.31e-14 1.31e-14
       5     0 FALSE  2.46     1.31e-14     2    1.31e-14 1.31e-14
       6     0 TRUE   2.46     1.31e-14     5    1.31e-14 1.31e-14
       7     0 FALSE  2.79     1.31e-14     4    1.31e-14 1.31e-14
       8     0 TRUE   2.79     1.31e-14     3    1.31e-14 1.31e-14
       9     0 FALSE  3.19     1.31e-14     4    1.31e-14 1.31e-14
      10     0 TRUE   3.19     1.31e-14     3    1.31e-14 1.31e-14
      # i 50 more rows
      
      $Europe$d2$`am:model`
      # A tibble: 192 x 7
           .it am    model               .y_composite    .n .y_distinct      .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE Lincoln Continental      -0.0844     2     -1.57   -1.57  
       2     0 TRUE  Lincoln Continental      -0.0844     0     -0.0844 -0.0844
       3     0 FALSE Cadillac Fleetwood       -0.0844     2     -1.57   -1.57  
       4     0 TRUE  Cadillac Fleetwood       -0.0844     0     -0.0844 -0.0844
       5     0 FALSE Merc 450SL               -0.0844     2     -1.57   -1.57  
       6     0 TRUE  Merc 450SL               -0.0844     0     -0.0844 -0.0844
       7     0 FALSE Merc 450SLC              -0.0844     2     -1.57   -1.57  
       8     0 TRUE  Merc 450SLC              -0.0844     0     -0.0844 -0.0844
       9     0 FALSE Camaro Z28               -0.0844     2     -1.57   -1.57  
      10     0 TRUE  Camaro Z28               -0.0844     0     -0.0844 -0.0844
      # i 182 more rows
      
      $Europe$d2$`am:gear`
      # A tibble: 18 x 7
           .it am    gear  .y_composite    .n .y_distinct      .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE three     -0.00407    30      0.386   0.386 
       2     0 TRUE  three     -0.00407     0      0.427   0.427 
       3     0 FALSE four      -0.00407     8      0.386   0.386 
       4     0 TRUE  four      -0.177      16      0.254   0.254 
       5     0 FALSE five      -0.00407     0      0.386   0.386 
       6     0 TRUE  five       0.226      10      0.657   0.657 
       7     1 FALSE three     -0.0677     30     -0.0254 -0.0254
       8     1 TRUE  three     -0.0677      0     -0.212  -0.212 
       9     1 FALSE four      -0.187       8     -0.145  -0.145 
      10     1 TRUE  four      -0.241      16     -0.385  -0.385 
      11     1 FALSE five      -0.187       0     -0.145  -0.145 
      12     1 TRUE  five      -0.0395     10     -0.183  -0.183 
      13     2 FALSE three     -0.0677     30     -0.500  -0.500 
      14     2 TRUE  three     -0.0677      0     -0.355  -0.355 
      15     2 FALSE four      -0.176       8     -0.608  -0.608 
      16     2 TRUE  four      -0.175      16     -0.463  -0.463 
      17     2 FALSE five      -0.176       0     -0.608  -0.608 
      18     2 TRUE  five      -0.0753     10     -0.363  -0.363 
      
      $Europe$d2$`am:carb`
      # A tibble: 30 x 7
           .it am     carb .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE     1     -0.0166      6    -0.144   -0.144  
       2     0 TRUE      1     -0.0166      8    -0.0129  -0.0129 
       3     0 FALSE     2     -0.0166     12    -0.226   -0.226  
       4     0 TRUE      2      0.00350     7     0.00350  0.00350
       5     0 FALSE     3     -0.0166      7    -0.140   -0.140  
       6     0 TRUE      3      0.00342     2    -0.0793  -0.0793 
       7     0 FALSE     4     -0.0166     11    -0.226   -0.226  
       8     0 TRUE      4     -0.550       5    -0.546   -0.546  
       9     0 FALSE     8     -0.0166      2    -0.140   -0.140  
      10     0 TRUE      8     -0.550       4    -0.633   -0.633  
      # i 20 more rows
      
      $Europe$d2$`am:wt`
      # A tibble: 60 x 7
           .it am       wt .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE  1.50      -0.0139     0     -0.0310 -0.0310
       2     0 TRUE   1.50      -0.0139     1     -0.0138 -0.0138
       3     0 FALSE  1.94      -0.0139     0     -0.0412 -0.0412
       4     0 TRUE   1.94      -0.0138     7     -0.0350 -0.0350
       5     0 FALSE  2.46      -0.0139     1     -0.0522 -0.0522
       6     0 TRUE   2.46      -0.0138     6     -0.0350 -0.0350
       7     0 FALSE  2.79      -0.0139     1     -0.0522 -0.0522
       8     0 TRUE   2.79      -0.0378     6     -0.0378 -0.0378
       9     0 FALSE  3.19      -0.0139     3     -0.0309 -0.0309
      10     0 TRUE   3.19      -0.0761     4     -0.0973 -0.0973
      # i 50 more rows
      
      $Europe$d2$`model:gear`
      # A tibble: 288 x 7
           .it model               gear  .y_composite    .n .y_distinct    .y
         <dbl> <fct>               <fct>        <dbl> <dbl>       <dbl> <dbl>
       1     0 Lincoln Continental three        0.301     2       0.301 0.301
       2     0 Cadillac Fleetwood  three        0.301     2       0.301 0.301
       3     0 Merc 450SL          three        0.301     2       0.301 0.301
       4     0 Merc 450SLC         three        0.301     2       0.301 0.301
       5     0 Camaro Z28          three        0.301     2       0.301 0.301
       6     0 Chrysler Imperial   three        0.301     2       0.759 0.759
       7     0 Duster 360          three        0.301     2       0.729 0.729
       8     0 Merc 450SE          three        0.301     2       0.235 0.235
       9     0 Hornet Sportabout   three        0.301     2       0.794 0.794
      10     0 AMC Javelin         three        0.301     2       0.964 0.964
      # i 278 more rows
      
      $Europe$d2$`model:carb`
      # A tibble: 480 x 7
           .it model                carb .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental     1        -3.89     0       -3.89  -3.89
       2     0 Cadillac Fleetwood      1        -3.89     0       -3.89  -3.89
       3     0 Merc 450SL              1        -3.89     0       -3.89  -3.89
       4     0 Merc 450SLC             1        -3.89     0       -3.89  -3.89
       5     0 Camaro Z28              1        -3.89     0       -3.89  -3.89
       6     0 Chrysler Imperial       1        -3.89     0       -5.45  -5.45
       7     0 Duster 360              1        -3.89     0       -8.67  -8.67
       8     0 Merc 450SE              1        -3.89     0      -11.1  -11.1 
       9     0 Hornet Sportabout       1        -3.89     0      -11.1  -11.1 
      10     0 AMC Javelin             1        -3.89     0      -11.4  -11.4 
      # i 470 more rows
      
      $Europe$d2$`model:wt`
      # A tibble: 960 x 7
           .it model                  wt .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental  1.50       -0.403     0      -0.403 -0.403
       2     0 Cadillac Fleetwood   1.50       -0.403     0      -0.403 -0.403
       3     0 Merc 450SL           1.50       -0.403     0      -0.403 -0.403
       4     0 Merc 450SLC          1.50       -0.403     0      -0.403 -0.403
       5     0 Camaro Z28           1.50       -0.403     0      -0.403 -0.403
       6     0 Chrysler Imperial    1.50       -0.403     0      -0.460 -0.460
       7     0 Duster 360           1.50       -0.403     0      -0.555 -0.555
       8     0 Merc 450SE           1.50       -0.403     0      -0.778 -0.778
       9     0 Hornet Sportabout    1.50       -0.403     0      -0.789 -0.789
      10     0 AMC Javelin          1.50       -0.403     0      -0.797 -0.797
      # i 950 more rows
      
      $Europe$d2$`gear:carb`
      # A tibble: 45 x 7
           .it gear   carb .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 three     1      0.00218     6     -0.105  -0.105 
       2     0 four      1      0.00218     8     -0.155  -0.155 
       3     0 five      1      0.00218     0     -0.158  -0.158 
       4     0 three     2      0.00218     8     -0.210  -0.210 
       5     0 four      2      0.00237     7     -0.210  -0.210 
       6     0 five      2      0.0348      4     -0.0727 -0.0727
       7     0 three     3      0.00218     7     -0.155  -0.155 
       8     0 four      3      0.00237     2     -0.158  -0.158 
       9     0 five      3      0.0510      0     -0.161  -0.161 
      10     0 three     4      0.00218     8     -0.210  -0.210 
      # i 35 more rows
      
      $Europe$d2$`gear:wt`
      # A tibble: 90 x 7
           .it gear     wt .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 three  1.50     -0.00213     0     -0.0423 -0.0423
       2     0 four   1.50     -0.00213     0     -0.0517 -0.0517
       3     0 five   1.50     -0.00213     1     -0.0584 -0.0584
       4     0 three  1.94     -0.00213     0     -0.0705 -0.0705
       5     0 four   1.94     -0.00210     6     -0.0927 -0.0927
       6     0 five   1.94     -0.00282     1     -0.0935 -0.0935
       7     0 three  2.46     -0.00213     1     -0.0928 -0.0928
       8     0 four   2.46     -0.00208     4     -0.0927 -0.0927
       9     0 five   2.46     -0.0208      2     -0.111  -0.111 
      10     0 three  2.79     -0.00213     1     -0.0928 -0.0928
      # i 80 more rows
      
      $Europe$d2$`carb:wt`
      # A tibble: 150 x 7
           .it  carb    wt .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0     1  1.50     -0.00454     0    -0.0278  -0.0278 
       2     0     2  1.50     -0.00454     1    -0.0377  -0.0377 
       3     0     3  1.50     -0.00454     0    -0.0420  -0.0420 
       4     0     4  1.50     -0.00454     0    -0.00941 -0.00941
       5     0     8  1.50     -0.00454     0    -0.0426  -0.0426 
       6     0     1  1.94     -0.00454     4    -0.0361  -0.0361 
       7     0     2  1.94     -0.0244      3    -0.0659  -0.0659 
       8     0     3  1.94     -0.0244      0    -0.0659  -0.0659 
       9     0     4  1.94     -0.0244      0    -0.0327  -0.0327 
      10     0     8  1.94     -0.0244      0    -0.0659  -0.0659 
      # i 140 more rows
      
      
      
      $`North America`
      $`North America`$d1
      $`North America`$d1$mpg
      # A tibble: 30 x 6
           .it   mpg .y_composite    .n .y_distinct       .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4     2.64e-14     1    2.64e-14 2.64e-14
       2     0  14.4     2.64e-14     7    2.64e-14 2.64e-14
       3     0  15.2     2.64e-14     7    2.64e-14 2.64e-14
       4     0  16.4     2.64e-14     7    2.64e-14 2.64e-14
       5     0  18.7     2.64e-14     7    2.64e-14 2.64e-14
       6     0  19.8     2.64e-14     7    2.64e-14 2.64e-14
       7     0  21.4     2.64e-14     7    2.64e-14 2.64e-14
       8     0  22.9     2.64e-14     7    2.64e-14 2.64e-14
       9     0  30.1     2.64e-14     7    2.64e-14 2.64e-14
      10     0  33.9     2.64e-14     7    2.64e-14 2.64e-14
      # i 20 more rows
      
      $`North America`$d1$vs
      # A tibble: 6 x 6
          .it vs    .y_composite    .n .y_distinct       .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
      1     0 FALSE     2.64e-14    36    2.64e-14 2.64e-14
      2     0 TRUE      2.64e-14    28    2.64e-14 2.64e-14
      3     1 FALSE     2.64e-14    36    2.64e-14 2.64e-14
      4     1 TRUE      2.64e-14    28    2.64e-14 2.64e-14
      5     2 FALSE     2.64e-14    36    2.64e-14 2.64e-14
      6     2 TRUE      2.64e-14    28    2.64e-14 2.64e-14
      
      $`North America`$d1$am
      # A tibble: 6 x 6
          .it am    .y_composite    .n .y_distinct        .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>     <dbl>
      1     0 FALSE     1.52e-10    38    1.52e-10  1.52e-10
      2     0 TRUE     -2.23e-10    26   -2.23e-10 -2.23e-10
      3     1 FALSE    -9.71e-10    38   -9.71e-10 -9.71e-10
      4     1 TRUE      7.39e-10    26    7.39e-10  7.39e-10
      5     2 FALSE    -8.52e-10    38   -8.52e-10 -8.52e-10
      6     2 TRUE     -4.71e-11    26   -4.71e-11 -4.71e-11
      
      $`North America`$d1$model
      # A tibble: 96 x 6
           .it model               .y_composite    .n .y_distinct     .y
         <dbl> <fct>                      <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental        0.139     2       0.139  0.139
       2     0 Cadillac Fleetwood         0.139     2       0.139  0.139
       3     0 Merc 450SL                -0.861     2      -0.861 -0.861
       4     0 Merc 450SLC               -0.861     2      -0.861 -0.861
       5     0 Camaro Z28                 0.139     2       0.139  0.139
       6     0 Chrysler Imperial          0.139     2       0.139  0.139
       7     0 Duster 360                 0.139     2       0.139  0.139
       8     0 Merc 450SE                -0.861     2      -0.861 -0.861
       9     0 Hornet Sportabout          0.139     2       0.139  0.139
      10     0 AMC Javelin                0.139     2       0.139  0.139
      # i 86 more rows
      
      $`North America`$d1$gear
      # A tibble: 9 x 6
          .it gear  .y_composite    .n .y_distinct      .y
        <dbl> <fct>        <dbl> <dbl>       <dbl>   <dbl>
      1     0 three       0.254     30      0.254   0.254 
      2     0 four       -0.283     24     -0.283  -0.283 
      3     0 five       -0.0843    10     -0.0843 -0.0843
      4     1 three       0.0526    30      0.0526  0.0526
      5     1 four       -0.232     24     -0.232  -0.232 
      6     1 five       -0.133     10     -0.133  -0.133 
      7     2 three       0.0544    30      0.0544  0.0544
      8     2 four       -0.232     24     -0.232  -0.232 
      9     2 five        0.0679    10      0.0679  0.0679
      
      $`North America`$d1$carb
      # A tibble: 15 x 6
           .it  carb .y_composite    .n .y_distinct       .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0     1      1.08e-7    14     1.08e-7  1.08e-7
       2     0     2     -3.71e-8    19    -3.71e-8 -3.71e-8
       3     0     3     -3.71e-8     9    -3.71e-8 -3.71e-8
       4     0     4     -3.71e-8    16    -3.71e-8 -3.71e-8
       5     0     8     -4.13e-8     6    -4.13e-8 -4.13e-8
       6     1     1      1.08e-7    18     1.08e-7  1.08e-7
       7     1     2     -7.21e-8    16    -7.21e-8 -7.21e-8
       8     1     3     -7.21e-8    13    -7.21e-8 -7.21e-8
       9     1     4     -7.21e-8    15    -7.21e-8 -7.21e-8
      10     1     8     -8.38e-8     2    -8.38e-8 -8.38e-8
      11     2     1      1.08e-7    15     1.08e-7  1.08e-7
      12     2     2      1.40e-9    13     1.40e-9  1.40e-9
      13     2     3      1.40e-9    13     1.40e-9  1.40e-9
      14     2     4      1.40e-9    20     1.40e-9  1.40e-9
      15     2     8      1.17e-9     3     1.17e-9  1.17e-9
      
      $`North America`$d1$wt
      # A tibble: 30 x 6
           .it    wt .y_composite    .n .y_distinct        .y
         <dbl> <dbl>        <dbl> <dbl>       <dbl>     <dbl>
       1     0  1.50     6.60e-10     1    6.60e-10  6.60e-10
       2     0  1.94    -8.90e-12     7   -8.90e-12 -8.90e-12
       3     0  2.46    -4.95e-11     7   -4.95e-11 -4.95e-11
       4     0  2.79    -4.95e-11     7   -4.95e-11 -4.95e-11
       5     0  3.19    -4.95e-11     7   -4.95e-11 -4.95e-11
       6     0  3.44    -4.87e-11     7   -4.87e-11 -4.87e-11
       7     0  3.52    -4.87e-11     7   -4.87e-11 -4.87e-11
       8     0  3.73    -4.87e-11     7   -4.87e-11 -4.87e-11
       9     0  4.05    -4.87e-11     7   -4.87e-11 -4.87e-11
      10     0  5.45    -4.87e-11     7   -4.87e-11 -4.87e-11
      # i 20 more rows
      
      
      $`North America`$d2
      $`North America`$d2$`mpg:vs`
      # A tibble: 60 x 7
           .it   mpg vs    .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 FALSE     2.64e-14     1    2.64e-14 2.64e-14
       2     0  14.4 FALSE     2.64e-14     7    2.64e-14 2.64e-14
       3     0  15.2 FALSE     2.64e-14     7    2.64e-14 2.64e-14
       4     0  16.4 FALSE     2.64e-14     7    2.64e-14 2.64e-14
       5     0  18.7 FALSE     2.64e-14     3    2.64e-14 2.64e-14
       6     0  19.8 FALSE     2.64e-14     5    2.64e-14 2.64e-14
       7     0  21.4 FALSE     2.64e-14     4    2.64e-14 2.64e-14
       8     0  22.9 FALSE     2.64e-14     0    2.64e-14 2.64e-14
       9     0  30.1 FALSE     2.64e-14     2    2.64e-14 2.64e-14
      10     0  33.9 FALSE     2.64e-14     0    2.64e-14 2.64e-14
      # i 50 more rows
      
      $`North America`$d2$`mpg:am`
      # A tibble: 60 x 7
           .it   mpg am    .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 FALSE     2.64e-14     1    2.64e-14 2.64e-14
       2     0  14.4 FALSE     2.64e-14     7    2.64e-14 2.64e-14
       3     0  15.2 FALSE     2.64e-14     5    2.64e-14 2.64e-14
       4     0  16.4 FALSE     2.64e-14     5    2.64e-14 2.64e-14
       5     0  18.7 FALSE     2.64e-14     7    2.64e-14 2.64e-14
       6     0  19.8 FALSE     2.64e-14     5    2.64e-14 2.64e-14
       7     0  21.4 FALSE     2.64e-14     1    2.64e-14 2.64e-14
       8     0  22.9 FALSE     2.64e-14     5    2.64e-14 2.64e-14
       9     0  30.1 FALSE     2.64e-14     2    2.64e-14 2.64e-14
      10     0  33.9 FALSE     2.64e-14     0    2.64e-14 2.64e-14
      # i 50 more rows
      
      $`North America`$d2$`mpg:model`
      # A tibble: 960 x 7
           .it   mpg model               .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>                      <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
       2     0  14.4 Lincoln Continental     2.64e-14     2    2.64e-14 2.64e-14
       3     0  15.2 Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
       4     0  16.4 Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
       5     0  18.7 Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
       6     0  19.8 Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
       7     0  21.4 Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
       8     0  22.9 Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
       9     0  30.1 Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
      10     0  33.9 Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
      # i 950 more rows
      
      $`North America`$d2$`mpg:gear`
      # A tibble: 90 x 7
           .it   mpg gear  .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4 three     2.64e-14     1    2.64e-14 2.64e-14
       2     0  14.4 three     2.64e-14     7    2.64e-14 2.64e-14
       3     0  15.2 three     2.64e-14     5    2.64e-14 2.64e-14
       4     0  16.4 three     2.64e-14     5    2.64e-14 2.64e-14
       5     0  18.7 three     2.64e-14     5    2.64e-14 2.64e-14
       6     0  19.8 three     2.64e-14     3    2.64e-14 2.64e-14
       7     0  21.4 three     2.64e-14     1    2.64e-14 2.64e-14
       8     0  22.9 three     2.64e-14     3    2.64e-14 2.64e-14
       9     0  30.1 three     2.64e-14     0    2.64e-14 2.64e-14
      10     0  33.9 three     2.64e-14     0    2.64e-14 2.64e-14
      # i 80 more rows
      
      $`North America`$d2$`mpg:carb`
      # A tibble: 150 x 7
           .it   mpg  carb .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4     1     2.64e-14     0    2.64e-14 2.64e-14
       2     0  14.4     1     2.64e-14     0    2.64e-14 2.64e-14
       3     0  15.2     1     2.64e-14     0    2.64e-14 2.64e-14
       4     0  16.4     1     2.64e-14     0    2.64e-14 2.64e-14
       5     0  18.7     1     2.64e-14     2    2.64e-14 2.64e-14
       6     0  19.8     1     2.64e-14     0    2.64e-14 2.64e-14
       7     0  21.4     1     2.64e-14     1    2.64e-14 2.64e-14
       8     0  22.9     1     2.64e-14     5    2.64e-14 2.64e-14
       9     0  30.1     1     2.64e-14     2    2.64e-14 2.64e-14
      10     0  33.9     1     2.64e-14     4    2.64e-14 2.64e-14
      # i 140 more rows
      
      $`North America`$d2$`mpg:wt`
      # A tibble: 300 x 7
           .it   mpg    wt .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0  10.4  1.50     2.64e-14     0    2.64e-14 2.64e-14
       2     0  14.4  1.50     2.64e-14     0    2.64e-14 2.64e-14
       3     0  15.2  1.50     2.64e-14     0    2.64e-14 2.64e-14
       4     0  16.4  1.50     2.64e-14     0    2.64e-14 2.64e-14
       5     0  18.7  1.50     2.64e-14     0    2.64e-14 2.64e-14
       6     0  19.8  1.50     2.64e-14     0    2.64e-14 2.64e-14
       7     0  21.4  1.50     2.64e-14     0    2.64e-14 2.64e-14
       8     0  22.9  1.50     2.64e-14     0    2.64e-14 2.64e-14
       9     0  30.1  1.50     2.64e-14     1    2.64e-14 2.64e-14
      10     0  33.9  1.50     2.64e-14     0    2.64e-14 2.64e-14
      # i 290 more rows
      
      $`North America`$d2$`vs:am`
      # A tibble: 12 x 7
           .it vs    am    .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE FALSE     2.64e-14    24    2.64e-14 2.64e-14
       2     0 TRUE  FALSE     2.64e-14    14    2.64e-14 2.64e-14
       3     0 FALSE TRUE      2.64e-14    12    2.64e-14 2.64e-14
       4     0 TRUE  TRUE      2.64e-14    14    2.64e-14 2.64e-14
       5     1 FALSE FALSE     2.64e-14    24    2.64e-14 2.64e-14
       6     1 TRUE  FALSE     2.64e-14    14    2.64e-14 2.64e-14
       7     1 FALSE TRUE      2.64e-14    12    2.64e-14 2.64e-14
       8     1 TRUE  TRUE      2.64e-14    14    2.64e-14 2.64e-14
       9     2 FALSE FALSE     2.64e-14    24    2.64e-14 2.64e-14
      10     2 TRUE  FALSE     2.64e-14    14    2.64e-14 2.64e-14
      11     2 FALSE TRUE      2.64e-14    12    2.64e-14 2.64e-14
      12     2 TRUE  TRUE      2.64e-14    14    2.64e-14 2.64e-14
      
      $`North America`$d2$`vs:model`
      # A tibble: 192 x 7
           .it vs    model               .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE Lincoln Continental     2.64e-14     2    2.64e-14 2.64e-14
       2     0 TRUE  Lincoln Continental     2.64e-14     0    2.64e-14 2.64e-14
       3     0 FALSE Cadillac Fleetwood      2.64e-14     2    2.64e-14 2.64e-14
       4     0 TRUE  Cadillac Fleetwood      2.64e-14     0    2.64e-14 2.64e-14
       5     0 FALSE Merc 450SL              2.64e-14     2    2.64e-14 2.64e-14
       6     0 TRUE  Merc 450SL              2.64e-14     0    2.64e-14 2.64e-14
       7     0 FALSE Merc 450SLC             2.64e-14     2    2.64e-14 2.64e-14
       8     0 TRUE  Merc 450SLC             2.64e-14     0    2.64e-14 2.64e-14
       9     0 FALSE Camaro Z28              2.64e-14     2    2.64e-14 2.64e-14
      10     0 TRUE  Camaro Z28              2.64e-14     0    2.64e-14 2.64e-14
      # i 182 more rows
      
      $`North America`$d2$`vs:gear`
      # A tibble: 18 x 7
           .it vs    gear  .y_composite    .n .y_distinct       .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE three     2.64e-14    24    2.64e-14 2.64e-14
       2     0 TRUE  three     2.64e-14     6    2.64e-14 2.64e-14
       3     0 FALSE four      2.64e-14     4    2.64e-14 2.64e-14
       4     0 TRUE  four      2.64e-14    20    2.64e-14 2.64e-14
       5     0 FALSE five      2.64e-14     8    2.64e-14 2.64e-14
       6     0 TRUE  five      2.64e-14     2    2.64e-14 2.64e-14
       7     1 FALSE three     2.64e-14    24    2.64e-14 2.64e-14
       8     1 TRUE  three     2.64e-14     6    2.64e-14 2.64e-14
       9     1 FALSE four      2.64e-14     4    2.64e-14 2.64e-14
      10     1 TRUE  four      2.64e-14    20    2.64e-14 2.64e-14
      11     1 FALSE five      2.64e-14     8    2.64e-14 2.64e-14
      12     1 TRUE  five      2.64e-14     2    2.64e-14 2.64e-14
      13     2 FALSE three     2.64e-14    24    2.64e-14 2.64e-14
      14     2 TRUE  three     2.64e-14     6    2.64e-14 2.64e-14
      15     2 FALSE four      2.64e-14     4    2.64e-14 2.64e-14
      16     2 TRUE  four      2.64e-14    20    2.64e-14 2.64e-14
      17     2 FALSE five      2.64e-14     8    2.64e-14 2.64e-14
      18     2 TRUE  five      2.64e-14     2    2.64e-14 2.64e-14
      
      $`North America`$d2$`vs:carb`
      # A tibble: 30 x 7
           .it vs     carb .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE     1     2.64e-14     0    2.64e-14 2.64e-14
       2     0 TRUE      1     2.64e-14    14    2.64e-14 2.64e-14
       3     0 FALSE     2     2.64e-14    10    2.64e-14 2.64e-14
       4     0 TRUE      2     2.64e-14     9    2.64e-14 2.64e-14
       5     0 FALSE     3     2.64e-14     8    2.64e-14 2.64e-14
       6     0 TRUE      3     2.64e-14     1    2.64e-14 2.64e-14
       7     0 FALSE     4     2.64e-14    13    2.64e-14 2.64e-14
       8     0 TRUE      4     2.64e-14     3    2.64e-14 2.64e-14
       9     0 FALSE     8     2.64e-14     5    2.64e-14 2.64e-14
      10     0 TRUE      8     2.64e-14     1    2.64e-14 2.64e-14
      # i 20 more rows
      
      $`North America`$d2$`vs:wt`
      # A tibble: 60 x 7
           .it vs       wt .y_composite    .n .y_distinct       .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 FALSE  1.50     2.64e-14     0    2.64e-14 2.64e-14
       2     0 TRUE   1.50     2.64e-14     1    2.64e-14 2.64e-14
       3     0 FALSE  1.94     2.64e-14     0    2.64e-14 2.64e-14
       4     0 TRUE   1.94     2.64e-14     7    2.64e-14 2.64e-14
       5     0 FALSE  2.46     2.64e-14     2    2.64e-14 2.64e-14
       6     0 TRUE   2.46     2.64e-14     5    2.64e-14 2.64e-14
       7     0 FALSE  2.79     2.64e-14     4    2.64e-14 2.64e-14
       8     0 TRUE   2.79     2.64e-14     3    2.64e-14 2.64e-14
       9     0 FALSE  3.19     2.64e-14     4    2.64e-14 2.64e-14
      10     0 TRUE   3.19     2.64e-14     3    2.64e-14 2.64e-14
      # i 50 more rows
      
      $`North America`$d2$`am:model`
      # A tibble: 192 x 7
           .it am    model               .y_composite    .n .y_distinct      .y
         <dbl> <fct> <fct>                      <dbl> <dbl>       <dbl>   <dbl>
       1     0 FALSE Lincoln Continental      -0.0218     2     -0.0218 -0.0218
       2     0 TRUE  Lincoln Continental      -0.0218     0     -1.51   -1.51  
       3     0 FALSE Cadillac Fleetwood       -0.0218     2     -0.0218 -0.0218
       4     0 TRUE  Cadillac Fleetwood       -0.0218     0     -1.51   -1.51  
       5     0 FALSE Merc 450SL               -0.0218     2     -0.0218 -0.0218
       6     0 TRUE  Merc 450SL               -0.0218     0     -1.51   -1.51  
       7     0 FALSE Merc 450SLC              -0.0218     2     -0.0218 -0.0218
       8     0 TRUE  Merc 450SLC              -0.0218     0     -1.51   -1.51  
       9     0 FALSE Camaro Z28               -0.0218     2     -0.0218 -0.0218
      10     0 TRUE  Camaro Z28               -0.0218     0     -1.51   -1.51  
      # i 182 more rows
      
      $`North America`$d2$`am:gear`
      # A tibble: 18 x 7
           .it am    gear  .y_composite    .n .y_distinct     .y
         <dbl> <fct> <fct>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 FALSE three       0.0729    30       0.205  0.205
       2     0 TRUE  three       0.0729     0       0.894  0.894
       3     0 FALSE four        0.0729     8       0.205  0.205
       4     0 TRUE  four        0.643     16       1.46   1.46 
       5     0 FALSE five        0.0729     0       0.205  0.205
       6     0 TRUE  five        0.838     10       1.66   1.66 
       7     1 FALSE three       0.271     30       0.329  0.329
       8     1 TRUE  three       0.271      0       0.170  0.170
       9     1 FALSE four        0.527      8       0.585  0.585
      10     1 TRUE  four        0.848     16       0.746  0.746
      11     1 FALSE five        0.527      0       0.585  0.585
      12     1 TRUE  five        0.945     10       0.843  0.843
      13     2 FALSE three       0.0732    30      -0.117 -0.117
      14     2 TRUE  three       0.0732     0      -0.646 -0.646
      15     2 FALSE four        0.340      8       0.150  0.150
      16     2 TRUE  four        0.403     16      -0.317 -0.317
      17     2 FALSE five        0.340      0       0.150  0.150
      18     2 TRUE  five        0.403     10      -0.317 -0.317
      
      $`North America`$d2$`am:carb`
      # A tibble: 30 x 7
           .it am     carb  .y_composite    .n   .y_distinct            .y
         <dbl> <fct> <dbl>         <dbl> <dbl>         <dbl>         <dbl>
       1     0 FALSE     1 -0.0000000460     6  0.00370       0.00370     
       2     0 TRUE      1 -0.0000000460     8 -0.123        -0.123       
       3     0 FALSE     2 -0.0000000460    12 -0.0828       -0.0828      
       4     0 TRUE      2 -0.000000439      7 -0.127        -0.127       
       5     0 FALSE     3 -0.0000000460     7  0.00369       0.00369     
       6     0 TRUE      3 -0.000000439      2 -0.210        -0.210       
       7     0 FALSE     4 -0.0000000460    11 -0.0000000460 -0.0000000460
       8     0 TRUE      4 -0.000000446      5 -0.123        -0.123       
       9     0 FALSE     8 -0.0000000460     2 -0.0828       -0.0828      
      10     0 TRUE      8 -0.000000447      4 -0.210        -0.210       
      # i 20 more rows
      
      $`North America`$d2$`am:wt`
      # A tibble: 60 x 7
           .it am       wt .y_composite    .n .y_distinct        .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>     <dbl>
       1     0 FALSE  1.50     9.93e-11     0    1.17e- 5  1.17e- 5
       2     0 TRUE   1.50     9.93e-11     1   -1.71e- 2 -1.71e- 2
       3     0 FALSE  1.94     9.93e-11     0   -2.12e- 2 -2.12e- 2
       4     0 TRUE   1.94    -5.71e-10     7   -3.83e- 2 -3.83e- 2
       5     0 FALSE  2.46     9.93e-11     1   -2.12e- 2 -2.12e- 2
       6     0 TRUE   2.46    -6.18e-10     6   -3.83e- 2 -3.83e- 2
       7     0 FALSE  2.79     9.93e-11     1    9.93e-11  9.93e-11
       8     0 TRUE   2.79     7.83e-10     6   -1.71e- 2 -1.71e- 2
       9     0 FALSE  3.19     9.93e-11     3   -1.03e- 2 -1.03e- 2
      10     0 TRUE   3.19     7.86e-10     4   -3.83e- 2 -3.83e- 2
      # i 50 more rows
      
      $`North America`$d2$`model:gear`
      # A tibble: 288 x 7
           .it model               gear  .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <fct>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental three       -0.117     2      -0.117 -0.117
       2     0 Cadillac Fleetwood  three       -0.117     2      -0.117 -0.117
       3     0 Merc 450SL          three       -0.117     2      -0.117 -0.117
       4     0 Merc 450SLC         three       -0.117     2      -0.117 -0.117
       5     0 Camaro Z28          three       -0.117     2      -0.117 -0.117
       6     0 Chrysler Imperial   three       -0.117     2       0.339  0.339
       7     0 Duster 360          three       -0.117     2       0.317  0.317
       8     0 Merc 450SE          three       -0.117     2       0.317  0.317
       9     0 Hornet Sportabout   three       -0.117     2       0.434  0.434
      10     0 AMC Javelin         three       -0.117     2       0.547  0.547
      # i 278 more rows
      
      $`North America`$d2$`model:carb`
      # A tibble: 480 x 7
           .it model                carb .y_composite    .n .y_distinct     .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 Lincoln Continental     1        0.471     0       0.471  0.471
       2     0 Cadillac Fleetwood      1        0.471     0       0.471  0.471
       3     0 Merc 450SL              1        0.471     0       0.471  0.471
       4     0 Merc 450SLC             1        0.471     0       0.471  0.471
       5     0 Camaro Z28              1        0.471     0       0.471  0.471
       6     0 Chrysler Imperial       1        0.471     0      -1.53  -1.53 
       7     0 Duster 360              1        0.471     0      -5.55  -5.55 
       8     0 Merc 450SE              1        0.471     0      -6.69  -6.69 
       9     0 Hornet Sportabout       1        0.471     0      -6.97  -6.97 
      10     0 AMC Javelin             1        0.471     0      -7.07  -7.07 
      # i 470 more rows
      
      $`North America`$d2$`model:wt`
      # A tibble: 960 x 7
           .it model                  wt .y_composite    .n .y_distinct       .y
         <dbl> <fct>               <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0 Lincoln Continental  1.50       0.0603     0     0.0603   0.0603 
       2     0 Cadillac Fleetwood   1.50       0.0603     0     0.0603   0.0603 
       3     0 Merc 450SL           1.50       0.0603     0     0.0603   0.0603 
       4     0 Merc 450SLC          1.50       0.0603     0     0.0603   0.0603 
       5     0 Camaro Z28           1.50       0.0603     0     0.0602   0.0602 
       6     0 Chrysler Imperial    1.50       0.0603     0     0.00250  0.00250
       7     0 Duster 360           1.50       0.0603     0    -0.252   -0.252  
       8     0 Merc 450SE           1.50       0.0603     0    -0.318   -0.318  
       9     0 Hornet Sportabout    1.50       0.0603     0    -0.334   -0.334  
      10     0 AMC Javelin          1.50       0.0603     0    -0.334   -0.334  
      # i 950 more rows
      
      $`North America`$d2$`gear:carb`
      # A tibble: 45 x 7
           .it gear   carb .y_composite    .n .y_distinct     .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>  <dbl>
       1     0 three     1      -0.0306     6      -0.108 -0.108
       2     0 four      1      -0.0306     8      -0.157 -0.157
       3     0 five      1      -0.0306     0      -0.160 -0.160
       4     0 three     2      -0.0306     8      -0.213 -0.213
       5     0 four      2      -0.165      7      -0.347 -0.347
       6     0 five      2      -0.165      4      -0.242 -0.242
       7     0 three     3      -0.0306     7      -0.157 -0.157
       8     0 four      3      -0.195      2      -0.325 -0.325
       9     0 five      3      -0.198      0      -0.380 -0.380
      10     0 three     4      -0.0306     8      -0.213 -0.213
      # i 35 more rows
      
      $`North America`$d2$`gear:wt`
      # A tibble: 90 x 7
           .it gear     wt .y_composite    .n .y_distinct      .y
         <dbl> <fct> <dbl>        <dbl> <dbl>       <dbl>   <dbl>
       1     0 three  1.50      -0.0342     0     -0.0903 -0.0903
       2     0 four   1.50      -0.0342     0     -0.0997 -0.0997
       3     0 five   1.50      -0.0342     1     -0.106  -0.106 
       4     0 three  1.94      -0.0342     0     -0.119  -0.119 
       5     0 four   1.94      -0.0506     6     -0.157  -0.157 
       6     0 five   1.94      -0.0506     1     -0.157  -0.157 
       7     0 three  2.46      -0.0342     1     -0.141  -0.141 
       8     0 four   2.46      -0.0578     4     -0.164  -0.164 
       9     0 five   2.46      -0.0578     2     -0.164  -0.164 
      10     0 three  2.79      -0.0342     1     -0.141  -0.141 
      # i 80 more rows
      
      $`North America`$d2$`carb:wt`
      # A tibble: 150 x 7
           .it  carb    wt .y_composite    .n .y_distinct       .y
         <dbl> <dbl> <dbl>        <dbl> <dbl>       <dbl>    <dbl>
       1     0     1  1.50 0.0000000171     0    -0.0332  -0.0332 
       2     0     2  1.50 0.0000000171     1    -0.00425 -0.00425
       3     0     3  1.50 0.0000000171     0    -0.0375  -0.0375 
       4     0     4  1.50 0.0000000171     0    -0.0281  -0.0281 
       5     0     8  1.50 0.0000000171     0    -0.0381  -0.0381 
       6     0     1  1.94 0.0000000171     4    -0.0415  -0.0415 
       7     0     2  1.94 0.000000145      3    -0.00831 -0.00831
       8     0     3  1.94 0.000000145      0    -0.0415  -0.0415 
       9     0     4  1.94 0.000000145      0    -0.0316  -0.0316 
      10     0     8  1.94 0.000000145      0    -0.0415  -0.0415 
      # i 140 more rows
      
      
      

---

    Code
      get(cat_cars_ale, stats = "estimate")
    Output
      $Asia
      $Asia$d1
      # A tibble: 7 x 7
        term       aled   aler_min  aler_max naled naler_min naler_max
        <chr>     <dbl>      <dbl>     <dbl> <dbl>     <dbl>     <dbl>
      1 mpg   0          0         0           0           0       0  
      2 vs    0          0         0           0           0       0  
      3 am    0.0218    -0.00838   0.0309     38.9       -50      31.2
      4 model 1.17      -1.94      1.05       43.0       -50      40.6
      5 gear  0.140     -0.232     0.119      37.7       -50      31.2
      6 carb  0.00172   -0.00189   0.00549    40.9       -50      31.2
      7 wt    0.0000118 -0.0000118 0.0000319  47.8       -50      31.2
      
      $Asia$d2
      # A tibble: 21 x 7
         term       aled aler_min aler_max naled naler_min naler_max
         <chr>     <dbl>    <dbl>    <dbl> <dbl>     <dbl>     <dbl>
       1 mpg:vs        0        0        0     0         0         0
       2 mpg:am        0        0        0     0         0         0
       3 mpg:model     0        0        0     0         0         0
       4 mpg:gear      0        0        0     0         0         0
       5 mpg:carb      0        0        0     0         0         0
       6 mpg:wt        0        0        0     0         0         0
       7 vs:am         0        0        0     0         0         0
       8 vs:model      0        0        0     0         0         0
       9 vs:gear       0        0        0     0         0         0
      10 vs:carb       0        0        0     0         0         0
      # i 11 more rows
      
      
      $Europe
      $Europe$d1
      # A tibble: 7 x 7
        term       aled   aler_min  aler_max naled naler_min naler_max
        <chr>     <dbl>      <dbl>     <dbl> <dbl>     <dbl>     <dbl>
      1 mpg   0          0         0           0         0        0   
      2 vs    0          0         0           0         0        0   
      3 am    0.0218    -0.0309    0.00838    32.2     -50        6.25
      4 model 2.27      -0.680     4.28       45.9     -21.9     50   
      5 gear  0.232     -0.172     0.365      30.2     -50        6.25
      6 carb  0.00172   -0.00549   0.00189    27.4     -50        6.25
      7 wt    0.0000118 -0.0000319 0.0000118  10.7     -50        6.25
      
      $Europe$d2
      # A tibble: 21 x 7
         term       aled aler_min aler_max naled naler_min naler_max
         <chr>     <dbl>    <dbl>    <dbl> <dbl>     <dbl>     <dbl>
       1 mpg:vs        0        0        0     0         0         0
       2 mpg:am        0        0        0     0         0         0
       3 mpg:model     0        0        0     0         0         0
       4 mpg:gear      0        0        0     0         0         0
       5 mpg:carb      0        0        0     0         0         0
       6 mpg:wt        0        0        0     0         0         0
       7 vs:am         0        0        0     0         0         0
       8 vs:model      0        0        0     0         0         0
       9 vs:gear       0        0        0     0         0         0
      10 vs:carb       0        0        0     0         0         0
      # i 11 more rows
      
      
      $`North America`
      $`North America`$d1
      # A tibble: 7 x 7
        term      aled  aler_min  aler_max naled naler_min naler_max
        <chr>    <dbl>     <dbl>     <dbl> <dbl>     <dbl>     <dbl>
      1 mpg   0         0         0         0         0         0   
      2 vs    0         0         0         0         0         0   
      3 am    7.01e-10 -9.12e-10  3.46e-10 41.7     -50       -20.3 
      4 model 1.48e+ 0 -2.59e+ 0 -1.11e- 1 43.0     -50       -18.8 
      5 gear  1.28e- 1 -2.32e- 1  6.02e- 2 29.5     -50        12.5 
      6 carb  3.40e- 8 -4.13e- 8  1.08e- 7 20.4     -20.3      12.5 
      7 wt    3.83e-10  3.53e-10  6.60e-10  8.06      7.81      9.38
      
      $`North America`$d2
      # A tibble: 21 x 7
         term       aled aler_min aler_max naled naler_min naler_max
         <chr>     <dbl>    <dbl>    <dbl> <dbl>     <dbl>     <dbl>
       1 mpg:vs        0        0        0     0         0         0
       2 mpg:am        0        0        0     0         0         0
       3 mpg:model     0        0        0     0         0         0
       4 mpg:gear      0        0        0     0         0         0
       5 mpg:carb      0        0        0     0         0         0
       6 mpg:wt        0        0        0     0         0         0
       7 vs:am         0        0        0     0         0         0
       8 vs:model      0        0        0     0         0         0
       9 vs:gear       0        0        0     0         0         0
      10 vs:carb       0        0        0     0         0         0
      # i 11 more rows
      
      

---

    Code
      get(cat_cars_ale, cats = c("Asia", "Europe"))
    Output
      $Asia
      $Asia$d1
      $Asia$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE     36 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      2 TRUE      28 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d1$am
      # A tibble: 2 x 7
        am.bin    .n      .y    .y_lo .y_mean .y_median  .y_hi
        <ord>  <int>   <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
      1 FALSE     38 0.00619 -0.0396  0.00619   0.0297  0.0320
      2 TRUE      26 0.0155  -0.00990 0.0155   -0.00670 0.0597
      
      $Asia$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental     2 -0.0226 -0.288 -0.0226    0.0422 0.187
       2 Cadillac Fleetwood      2  0.0932 -0.280  0.0932    0.195  0.380
       3 Merc 450SL              2 -0.235  -0.766 -0.235    -0.305  0.355
       4 Merc 450SLC             2 -0.235  -0.766 -0.235    -0.305  0.355
       5 Camaro Z28              2  0.0975 -0.304  0.0975   -0.290  0.829
       6 Chrysler Imperial       2  0.264  -0.279  0.264     0.210  0.854
       7 Duster 360              2  0.264  -0.279  0.264     0.210  0.854
       8 Merc 450SE              2  0.266  -0.279  0.266     0.216  0.854
       9 Hornet Sportabout       2  0.433  -0.279  0.433     0.216  1.33 
      10 AMC Javelin             2  0.446  -0.302  0.446    -0.244  1.78 
      # i 22 more rows
      
      $Asia$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n       .y   .y_lo  .y_mean .y_median   .y_hi
        <ord>    <int>    <dbl>   <dbl>    <dbl>     <dbl>   <dbl>
      1 three       30  0.118    0.0563  0.118      0.118   0.181 
      2 four        24  0.00198 -0.150   0.00198    0.0718  0.0948
      3 five        10 -0.330   -0.523  -0.330     -0.460  -0.0269
      
      $Asia$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n       .y    .y_lo  .y_mean .y_median     .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>     <dbl>
      1         1    14  0.00549  0.00549  0.00549   0.00549  0.00549 
      2         2    19 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      3         3     9 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      4         4    16 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      5         8     6 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      
      $Asia$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n          .y       .y_lo     .y_mean   .y_median       .y_hi
           <dbl> <int>       <dbl>       <dbl>       <dbl>       <dbl>       <dbl>
       1    1.50     1  0.0000319   0.0000319   0.0000319   0.0000319   0.0000319 
       2    1.94     7 -0.00000143 -0.00000836 -0.00000143 -0.00000427  0.00000790
       3    2.46     7 -0.00000906 -0.0000153  -0.00000906 -0.00000787 -0.00000385
       4    2.79     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       5    3.19     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       6    3.44     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       7    3.52     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       8    3.73     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       9    4.05     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
      10    5.45     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
      
      
      $Asia$d2
      $Asia$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 FALSE      3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 FALSE      4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 FALSE      0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 FALSE      2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 FALSE      0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      11     10.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      12     14.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      13     15.2 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      14     16.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      15     18.7 TRUE       4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      16     19.8 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      17     21.4 TRUE       3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      18     22.9 TRUE       7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      19     30.1 TRUE       5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      20     33.9 TRUE       7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 FALSE      1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 FALSE      2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 FALSE      0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      11     10.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      12     14.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      13     15.2 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      14     16.4 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      15     18.7 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      16     19.8 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      17     21.4 TRUE       6 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      18     22.9 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      19     30.1 TRUE       5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      20     33.9 TRUE       7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin           .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>            <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 Lincoln Contine~     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 310 more rows
      
      $Asia$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 three        1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 three        7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 three        5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 three        5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 three        5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 three        3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 three        1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 three        3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 three        0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 three        0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 20 more rows
      
      $Asia$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>     <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7         1     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4         1     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9         1     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1         1     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9         1     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 40 more rows
      
      $Asia$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1    1.50     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 90 more rows
      
      $Asia$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  FALSE     24 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      2 TRUE   FALSE     14 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      3 FALSE  TRUE      12 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      4 TRUE   TRUE      14 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin             .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>  <ord>              <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE  Lincoln Continent~     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2 TRUE   Lincoln Continent~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3 FALSE  Cadillac Fleetwood     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4 TRUE   Cadillac Fleetwood     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5 FALSE  Merc 450SL             2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6 TRUE   Merc 450SL             0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7 FALSE  Merc 450SLC            2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8 TRUE   Merc 450SLC            0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9 FALSE  Camaro Z28             2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10 TRUE   Camaro Z28             0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 54 more rows
      
      $Asia$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  three       24 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      2 TRUE   three        6 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      3 FALSE  four         4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      4 TRUE   four        20 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      5 FALSE  five         8 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      6 TRUE   five         2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2 TRUE           1    14 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3 FALSE          2    10 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4 TRUE           2     9 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5 FALSE          3     8 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6 TRUE           3     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7 FALSE          4    13 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8 TRUE           4     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9 FALSE          8     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10 TRUE           8     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2 TRUE      1.50     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3 FALSE     1.94     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4 TRUE      1.94     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5 FALSE     2.46     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6 TRUE      2.46     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7 FALSE     2.79     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8 TRUE      2.79     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9 FALSE     3.19     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10 TRUE      3.19     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      11 FALSE     3.44     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      12 TRUE      3.44     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      13 FALSE     3.52     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      14 TRUE      3.52     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      15 FALSE     3.73     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      16 TRUE      3.73     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      17 FALSE     4.05     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      18 TRUE      4.05     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      19 FALSE     5.45     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      20 TRUE      5.45     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`am:model`
      # A tibble: 64 x 8
         am.bin model.bin              .n     .y  .y_lo .y_mean .y_median .y_hi
         <ord>  <ord>               <int>  <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 FALSE  Lincoln Continental     2 0.214   0.106  0.214      0.106 0.415
       2 TRUE   Lincoln Continental     0 0.214  -1.28   0.214      0.512 1.46 
       3 FALSE  Cadillac Fleetwood      2 0.323   0.106  0.323      0.106 0.723
       4 TRUE   Cadillac Fleetwood      0 0.323  -1.27   0.323      0.837 1.48 
       5 FALSE  Merc 450SL              2 0.0915 -0.552  0.0915     0.106 0.723
       6 TRUE   Merc 450SL              0 0.0915 -1.27   0.0915     0.817 0.836
       7 FALSE  Merc 450SLC             2 0.0915 -0.552  0.0915     0.106 0.723
       8 TRUE   Merc 450SLC             0 0.0915 -1.27   0.0915     0.817 0.836
       9 FALSE  Camaro Z28              2 0.0910 -0.552  0.0910     0.106 0.721
      10 TRUE   Camaro Z28              0 0.0910 -1.27   0.0910     0.817 0.834
      # i 54 more rows
      
      $Asia$d2$`am:gear`
      # A tibble: 6 x 8
        am.bin gear.bin    .n      .y  .y_lo .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
      1 FALSE  three       30 -0.0927 -0.197 -0.0927   -0.0688 -0.00870
      2 TRUE   three        0 -0.0927 -0.601 -0.0927   -0.104   0.425  
      3 FALSE  four         8 -0.191  -0.332 -0.191    -0.165  -0.0736 
      4 TRUE   four        16 -0.433  -0.832 -0.433    -0.507   0.0281 
      5 FALSE  five         0 -0.191  -0.332 -0.191    -0.165  -0.0736 
      6 TRUE   five        10 -0.766  -0.942 -0.766    -0.806  -0.555  
      
      $Asia$d2$`am:carb`
      # A tibble: 10 x 8
         am.bin carb.ceil    .n        .y    .y_lo   .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>     <dbl>    <dbl>     <dbl>     <dbl>  <dbl>
       1 FALSE          1     6  0.0166    0.0166   0.0166     0.0166  0.0166
       2 TRUE           1     8  0.0166   -0.101    0.0166     0.0166  0.134 
       3 FALSE          2    12  0.0134   -0.0621   0.0134     0.0163  0.0863
       4 TRUE           2     7 -0.000253 -0.203   -0.000253   0.00468 0.198 
       5 FALSE          3     7  0.0134    0.00415  0.0134     0.0163  0.0201
       6 TRUE           3     2 -0.000226 -0.120   -0.000226   0.00468 0.116 
       7 FALSE          4    11  0.190    -0.0514   0.190      0.229   0.399 
       8 TRUE           4     5  0.454     0.357    0.454      0.423   0.579 
       9 FALSE          8     2  0.190     0.0307   0.190      0.229   0.317 
      10 TRUE           8     4  0.454     0.341    0.454      0.353   0.654 
      
      $Asia$d2$`am:wt`
      # A tibble: 20 x 8
         am.bin wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>    <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 FALSE     1.50     0 0.0139  0.0139   0.0139    0.0139 0.0139
       2 TRUE      1.50     1 0.0139 -0.00237  0.0139    0.0139 0.0301
       3 FALSE     1.94     0 0.0139  0.00413  0.0139    0.0139 0.0236
       4 TRUE      1.94     7 0.0138 -0.0225   0.0138    0.0138 0.0502
       5 FALSE     2.46     1 0.0138 -0.00627  0.0138    0.0139 0.0339
       6 TRUE      2.46     6 0.0138 -0.0225   0.0138    0.0138 0.0502
       7 FALSE     2.79     1 0.0314 -0.00483  0.0314    0.0426 0.0582
       8 TRUE      2.79     6 0.0538  0.0227   0.0538    0.0605 0.0793
       9 FALSE     3.19     3 0.0481  0.0157   0.0481    0.0497 0.0792
      10 TRUE      3.19     4 0.100   0.0512   0.100     0.0987 0.151 
      11 FALSE     3.44     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      12 TRUE      3.44     0 0.109   0.0651   0.109     0.0987 0.161 
      13 FALSE     3.52     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      14 TRUE      3.52     0 0.113   0.0772   0.113     0.0987 0.161 
      15 FALSE     3.73     5 0.0481  0.0157   0.0481    0.0497 0.0792
      16 TRUE      3.73     2 0.113   0.0973   0.113     0.0987 0.141 
      17 FALSE     4.05     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      18 TRUE      4.05     0 0.113   0.0772   0.113     0.0987 0.161 
      19 FALSE     5.45     7 0.0481 -0.00341  0.0481    0.0709 0.0803
      20 TRUE      5.45     0 0.113   0.0772   0.113     0.0987 0.161 
      
      $Asia$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental three        2 -0.0681 -0.184 -0.0681   -0.184  0.146
       2 Cadillac Fleetwood  three        2  0.0476 -0.184  0.0476   -0.184  0.476
       3 Merc 450SL          three        2 -0.280  -1.12  -0.280    -0.184  0.476
       4 Merc 450SLC         three        2 -0.114  -0.643 -0.114    -0.184  0.476
       5 Camaro Z28          three        2  0.389  -0.158  0.389     0.342  0.975
       6 Chrysler Imperial   three        2  0.223  -0.556  0.223     0.274  0.957
       7 Duster 360          three        2  0.223  -0.970  0.223     0.272  1.37 
       8 Merc 450SE          three        2  0.224  -0.687  0.224     0.250  1.11 
       9 Hornet Sportabout   three        2  0.225  -0.686  0.225     0.250  1.11 
      10 AMC Javelin         three        2 -0.0923 -1.59  -0.0923   -0.0198 1.34 
      # i 86 more rows
      
      $Asia$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0  3.42  3.42     3.42      3.42  3.42
       2 Cadillac Fleetwood          1     0  3.42  3.42     3.42      3.42  3.42
       3 Merc 450SL                  1     0  3.42  3.42     3.42      3.42  3.42
       4 Merc 450SLC                 1     0  3.42  3.42     3.42      3.42  3.42
       5 Camaro Z28                  1     0  3.42  3.42     3.42      3.42  3.42
       6 Chrysler Imperial           1     0  3.42  3.00     3.42      3.01  4.19
       7 Duster 360                  1     0  3.42 -0.295    3.42      2.05  8.30
       8 Merc 450SE                  1     0  3.42 -3.05     3.42      2.05 11.1 
       9 Hornet Sportabout           1     0  3.42 -3.45     3.42      2.05 11.5 
      10 AMC Javelin                 1     0  3.42 -3.81     3.42      2.05 11.8 
      # i 150 more rows
      
      $Asia$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n    .y   .y_lo .y_mean .y_median .y_hi
         <ord>                 <dbl> <int> <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental    1.50     0 0.342  0.342    0.342     0.342 0.342
       2 Cadillac Fleetwood     1.50     0 0.342  0.342    0.342     0.342 0.342
       3 Merc 450SL             1.50     0 0.342  0.342    0.342     0.342 0.342
       4 Merc 450SLC            1.50     0 0.342  0.342    0.342     0.342 0.342
       5 Camaro Z28             1.50     0 0.342  0.342    0.342     0.342 0.342
       6 Chrysler Imperial      1.50     0 0.342  0.319    0.342     0.342 0.366
       7 Duster 360             1.50     0 0.342  0.284    0.342     0.286 0.448
       8 Merc 450SE             1.50     0 0.342 -0.0164   0.342     0.286 0.749
       9 Hornet Sportabout      1.50     0 0.342 -0.0274   0.342     0.286 0.760
      10 AMC Javelin            1.50     0 0.342 -0.0351   0.342     0.286 0.768
      # i 310 more rows
      
      $Asia$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>        <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 three            1     6 0.0284  0.0284   0.0284    0.0284 0.0284
       2 four             1     8 0.0284 -0.0188   0.0284    0.0249 0.0785
       3 five             1     0 0.0284 -0.0220   0.0284    0.0249 0.0817
       4 three            2     8 0.0270 -0.0718   0.0270    0.0206 0.131 
       5 four             2     7 0.118   0.0612   0.118     0.135  0.161 
       6 five             2     4 0.0970  0.00282  0.0970    0.130  0.163 
       7 three            3     7 0.0341 -0.0182   0.0341    0.0372 0.0838
       8 four             3     2 0.149   0.120    0.149     0.140  0.185 
       9 five             3     0 0.123   0.0471   0.123     0.139  0.187 
      10 three            4     8 0.0456 -0.0699   0.0456    0.0598 0.149 
      11 four             4     6 0.307   0.206    0.307     0.358  0.364 
      12 five             4     2 0.285   0.221    0.285     0.270  0.361 
      13 three            8     1 0.0456 -0.0204   0.0456    0.0574 0.102 
      14 four             8     1 0.308   0.256    0.308     0.307  0.359 
      15 five             8     4 0.285   0.217    0.285     0.273  0.364 
      
      $Asia$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 three       1.50     0 0.0363  0.0363   0.0363    0.0363 0.0363
       2 four        1.50     0 0.0363  0.0274   0.0363    0.0364 0.0453
       3 five        1.50     1 0.0363  0.0212   0.0363    0.0389 0.0493
       4 three       1.94     0 0.0470  0.0108   0.0470    0.0619 0.0704
       5 four        1.94     6 0.0550  0.00593  0.0550    0.0757 0.0864
       6 five        1.94     1 0.0552  0.00661  0.0552    0.0757 0.0864
       7 three       2.46     1 0.0487 -0.00963  0.0487    0.0762 0.0838
       8 four        2.46     4 0.0623  0.0132   0.0623    0.0852 0.0919
       9 five        2.46     2 0.0725  0.0313   0.0725    0.0923 0.0970
      10 three       2.79     1 0.0489 -0.00962  0.0489    0.0764 0.0840
      # i 20 more rows
      
      $Asia$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n      .y    .y_lo .y_mean .y_median   .y_hi
             <dbl>   <dbl> <int>   <dbl>    <dbl>   <dbl>     <dbl>   <dbl>
       1         1    1.50     0 0.00454  0.00454 0.00454   0.00454 0.00454
       2         2    1.50     1 0.00454 -0.0270  0.00454   0.00454 0.0361 
       3         3    1.50     0 0.00454 -0.0216  0.00454   0.00454 0.0307 
       4         4    1.50     0 0.00454 -0.0310  0.00454   0.00454 0.0401 
       5         8    1.50     0 0.00454 -0.0316  0.00454   0.00454 0.0407 
       6         1    1.94     4 0.00454 -0.00336 0.00454   0.00454 0.0124 
       7         2    1.94     3 0.0185  -0.0159  0.0185    0.00668 0.0629 
       8         3    1.94     0 0.0185  -0.00651 0.0185    0.00668 0.0535 
       9         4    1.94     0 0.0185  -0.0159  0.0185    0.00668 0.0629 
      10         8    1.94     0 0.0185  -0.0159  0.0185    0.00668 0.0629 
      # i 40 more rows
      
      
      
      $Europe
      $Europe$d1
      $Europe$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE     36 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      2 TRUE      28 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d1$am
      # A tibble: 2 x 7
        am.bin    .n       .y   .y_lo  .y_mean .y_median   .y_hi
        <ord>  <int>    <dbl>   <dbl>    <dbl>     <dbl>   <dbl>
      1 FALSE     38 -0.00619 -0.0320 -0.00619  -0.0297  0.0396 
      2 TRUE      26 -0.0155  -0.0597 -0.0155    0.00670 0.00990
      
      $Europe$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental     2  0.217  -0.164  0.217      0.166 0.641
       2 Cadillac Fleetwood      2  0.268  -0.494  0.268      0.166 1.12 
       3 Merc 450SL              2  0.931  -0.444  0.931      1.17  2.10 
       4 Merc 450SLC             2  0.764  -0.444  0.764      1.17  1.63 
       5 Camaro Z28              2 -0.0688 -1.44  -0.0688     0.166 1.10 
       6 Chrysler Imperial       2  0.0978 -0.967  0.0978     0.166 1.10 
       7 Duster 360              2  0.0978 -0.967  0.0978     0.166 1.10 
       8 Merc 450SE              2  0.596  -0.917  0.596      1.17  1.62 
       9 Hornet Sportabout       2 -0.237  -1.92  -0.237      0.166 1.10 
      10 AMC Javelin             2 -0.0841 -1.92  -0.0841     0.166 1.54 
      # i 22 more rows
      
      $Europe$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n     .y   .y_lo .y_mean .y_median  .y_hi
        <ord>    <int>  <dbl>   <dbl>   <dbl>     <dbl>  <dbl>
      1 three       30 -0.239 -0.366   -0.239    -0.239 -0.112
      2 four        24  0.247  0.140    0.247     0.211  0.385
      3 five        10  0.380 -0.0309   0.380     0.594  0.609
      
      $Europe$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n       .y     .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>     <dbl>    <dbl>     <dbl>    <dbl>
      1         1    14 -0.00549 -0.00549  -0.00549  -0.00549 -0.00549
      2         2    19  0.00190  0.000117  0.00190   0.00191  0.00367
      3         3     9  0.00190  0.000117  0.00190   0.00191  0.00367
      4         4    16  0.00190  0.000117  0.00190   0.00191  0.00367
      5         8     6  0.00190  0.000117  0.00190   0.00191  0.00367
      
      $Europe$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n          .y       .y_lo     .y_mean   .y_median       .y_hi
           <dbl> <int>       <dbl>       <dbl>       <dbl>       <dbl>       <dbl>
       1    1.50     1 -0.0000319  -0.0000319  -0.0000319  -0.0000319  -0.0000319 
       2    1.94     7  0.00000143 -0.00000790  0.00000143  0.00000427  0.00000836
       3    2.46     7  0.00000906  0.00000385  0.00000906  0.00000787  0.0000153 
       4    2.79     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       5    3.19     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       6    3.44     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       7    3.52     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       8    3.73     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       9    4.05     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
      10    5.45     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
      
      
      $Europe$d2
      $Europe$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 FALSE      3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 FALSE      4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 FALSE      0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 FALSE      2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 FALSE      0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      11     10.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      12     14.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      13     15.2 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      14     16.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      15     18.7 TRUE       4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      16     19.8 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      17     21.4 TRUE       3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      18     22.9 TRUE       7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      19     30.1 TRUE       5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      20     33.9 TRUE       7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 FALSE      1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 FALSE      2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 FALSE      0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      11     10.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      12     14.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      13     15.2 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      14     16.4 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      15     18.7 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      16     19.8 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      17     21.4 TRUE       6 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      18     22.9 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      19     30.1 TRUE       5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      20     33.9 TRUE       7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin           .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>            <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 Lincoln Contine~     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 310 more rows
      
      $Europe$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 three        1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 three        7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 three        5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 three        5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 three        5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 three        3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 three        1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 three        3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 three        0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 three        0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 20 more rows
      
      $Europe$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>     <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7         1     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4         1     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9         1     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1         1     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9         1     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 40 more rows
      
      $Europe$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1    1.50     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 90 more rows
      
      $Europe$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  FALSE     24 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      2 TRUE   FALSE     14 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      3 FALSE  TRUE      12 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      4 TRUE   TRUE      14 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin             .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>  <ord>              <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE  Lincoln Continent~     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2 TRUE   Lincoln Continent~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3 FALSE  Cadillac Fleetwood     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4 TRUE   Cadillac Fleetwood     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5 FALSE  Merc 450SL             2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6 TRUE   Merc 450SL             0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7 FALSE  Merc 450SLC            2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8 TRUE   Merc 450SLC            0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9 FALSE  Camaro Z28             2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10 TRUE   Camaro Z28             0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 54 more rows
      
      $Europe$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  three       24 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      2 TRUE   three        6 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      3 FALSE  four         4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      4 TRUE   four        20 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      5 FALSE  five         8 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      6 TRUE   five         2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2 TRUE           1    14 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3 FALSE          2    10 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4 TRUE           2     9 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5 FALSE          3     8 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6 TRUE           3     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7 FALSE          4    13 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8 TRUE           4     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9 FALSE          8     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10 TRUE           8     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2 TRUE      1.50     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3 FALSE     1.94     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4 TRUE      1.94     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5 FALSE     2.46     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6 TRUE      2.46     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7 FALSE     2.79     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8 TRUE      2.79     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9 FALSE     3.19     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10 TRUE      3.19     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      11 FALSE     3.44     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      12 TRUE      3.44     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      13 FALSE     3.52     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      14 TRUE      3.52     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      15 FALSE     3.73     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      16 TRUE      3.73     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      17 FALSE     4.05     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      18 TRUE      4.05     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      19 FALSE     5.45     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      20 TRUE      5.45     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`am:model`
      # A tibble: 64 x 8
         am.bin model.bin              .n      .y  .y_lo .y_mean .y_median   .y_hi
         <ord>  <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl>   <dbl>
       1 FALSE  Lincoln Continental     2 -0.193  -1.51  -0.193    -0.327   1.24  
       2 TRUE   Lincoln Continental     0 -0.193  -0.393 -0.193    -0.0844 -0.0844
       3 FALSE  Cadillac Fleetwood      2 -0.301  -1.52  -0.301    -0.652   1.22  
       4 TRUE   Cadillac Fleetwood      0 -0.301  -0.701 -0.301    -0.0844 -0.0844
       5 FALSE  Merc 450SL              2 -0.0689 -1.52  -0.0689   -0.652   1.88  
       6 TRUE   Merc 450SL              0 -0.0689 -0.701 -0.0689   -0.0844  0.576 
       7 FALSE  Merc 450SLC             2 -0.0689 -1.52  -0.0689   -0.652   1.88  
       8 TRUE   Merc 450SLC             0 -0.0689 -0.701 -0.0689   -0.0844  0.576 
       9 FALSE  Camaro Z28              2 -0.0683 -1.52  -0.0683   -0.650   1.88  
      10 TRUE   Camaro Z28              0 -0.0683 -0.699 -0.0683   -0.0844  0.576 
      # i 54 more rows
      
      $Europe$d2$`am:gear`
      # A tibble: 6 x 8
        am.bin gear.bin    .n      .y  .y_lo .y_mean .y_median .y_hi
        <ord>  <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
      1 FALSE  three       30 -0.0465 -0.476 -0.0465   -0.0254 0.365
      2 TRUE   three        0 -0.0465 -0.348 -0.0465   -0.212  0.395
      3 FALSE  four         8 -0.122  -0.584 -0.122    -0.145  0.359
      4 TRUE   four        16 -0.198  -0.459 -0.198    -0.385  0.222
      5 FALSE  five         0 -0.122  -0.584 -0.122    -0.145  0.359
      6 TRUE   five        10  0.0371 -0.354  0.0371   -0.183  0.615
      
      $Europe$d2$`am:carb`
      # A tibble: 10 x 8
         am.bin carb.ceil    .n        .y    .y_lo   .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>     <dbl>    <dbl>     <dbl>     <dbl>    <dbl>
       1 FALSE          1     6 -0.0166   -0.137   -0.0166    -0.0166   0.104  
       2 TRUE           1     8 -0.0166   -0.0201  -0.0166    -0.0166  -0.0131 
       3 FALSE          2    12 -0.0134   -0.216   -0.0134    -0.0163   0.192  
       4 TRUE           2     7  0.000253 -0.00434  0.000253   0.00193  0.00342
       5 FALSE          3     7 -0.0134   -0.134   -0.0134    -0.0163   0.110  
       6 TRUE           3     2  0.000227 -0.0756   0.000227  -0.00468  0.0802 
       7 FALSE          4    11 -0.190    -0.229   -0.190     -0.226   -0.121  
       8 TRUE           4     5 -0.454    -0.542   -0.454     -0.464   -0.359  
       9 FALSE          8     2 -0.190    -0.228   -0.190     -0.202   -0.143  
      10 TRUE           8     4 -0.454    -0.620   -0.454     -0.377   -0.355  
      
      $Europe$d2$`am:wt`
      # A tibble: 20 x 8
         am.bin wt.ceil    .n      .y   .y_lo .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 -0.0139 -0.0301 -0.0139   -0.0139  0.00238
       2 TRUE      1.50     1 -0.0139 -0.0139 -0.0139   -0.0139 -0.0138 
       3 FALSE     1.94     0 -0.0139 -0.0398 -0.0139   -0.0139  0.0122 
       4 TRUE      1.94     7 -0.0138 -0.0340 -0.0138   -0.0138  0.00634
       5 FALSE     2.46     1 -0.0138 -0.0502 -0.0138   -0.0139  0.0226 
       6 TRUE      2.46     6 -0.0138 -0.0340 -0.0138   -0.0138  0.00634
       7 FALSE     2.79     1 -0.0314 -0.0517 -0.0314   -0.0426 -0.00165
       8 TRUE      2.79     6 -0.0538 -0.0630 -0.0538   -0.0605 -0.0389 
       9 FALSE     3.19     3 -0.0481 -0.0783 -0.0481   -0.0327 -0.0310 
      10 TRUE      3.19     4 -0.100  -0.104  -0.100    -0.0987 -0.0973 
      11 FALSE     3.44     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      12 TRUE      3.44     0 -0.109  -0.122  -0.109    -0.105  -0.0990 
      13 FALSE     3.52     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      14 TRUE      3.52     0 -0.113  -0.125  -0.113    -0.114  -0.0995 
      15 FALSE     3.73     5 -0.0481 -0.0783 -0.0481   -0.0327 -0.0310 
      16 TRUE      3.73     2 -0.113  -0.124  -0.113    -0.116  -0.0995 
      17 FALSE     4.05     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      18 TRUE      4.05     0 -0.113  -0.134  -0.113    -0.105  -0.0990 
      19 FALSE     5.45     7 -0.0481 -0.0793 -0.0481   -0.0522 -0.0135 
      20 TRUE      5.45     0 -0.113  -0.134  -0.113    -0.105  -0.0990 
      
      $Europe$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n     .y   .y_lo .y_mean .y_median .y_hi
         <ord>               <ord>    <int>  <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental three        2 0.185  -0.0288  0.185     0.301  0.301
       2 Cadillac Fleetwood  three        2 0.0696 -0.359   0.0696    0.301  0.301
       3 Merc 450SL          three        2 0.399  -0.359   0.399     0.301  1.24 
       4 Merc 450SLC         three        2 0.399  -0.359   0.399     0.301  1.24 
       5 Camaro Z28          three        2 0.0663 -0.832   0.0663    0.301  0.765
       6 Chrysler Imperial   three        2 0.0663 -0.450   0.0663   -0.0912 0.717
       7 Duster 360          three        2 0.0663 -0.693   0.0663    0.211  0.703
       8 Merc 450SE          three        2 0.0643 -0.692   0.0643    0.235  0.676
       9 Hornet Sportabout   three        2 0.0643 -0.533   0.0643   -0.0418 0.752
      10 AMC Javelin         three        2 0.218  -0.455   0.218     0.177  0.924
      # i 86 more rows
      
      $Europe$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       2 Cadillac Fleetwood          1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       3 Merc 450SL                  1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       4 Merc 450SLC                 1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       5 Camaro Z28                  1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       6 Chrysler Imperial           1     0 -3.89  -5.43   -3.89     -5.05 -1.37
       7 Duster 360                  1     0 -3.89  -8.50   -3.89     -5.26  1.88
       8 Merc 450SE                  1     0 -3.89 -10.8    -3.89     -5.26  4.14
       9 Hornet Sportabout           1     0 -3.89 -10.8    -3.89     -5.26  4.15
      10 AMC Javelin                 1     0 -3.89 -11.1    -3.89     -5.26  4.50
      # i 150 more rows
      
      $Europe$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n     .y  .y_lo .y_mean .y_median    .y_hi
         <ord>                 <dbl> <int>  <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
       1 Lincoln Continental    1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       2 Cadillac Fleetwood     1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       3 Merc 450SL             1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       4 Merc 450SLC            1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       5 Camaro Z28             1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       6 Chrysler Imperial      1.50     0 -0.403 -0.460  -0.403    -0.459 -0.297  
       7 Duster 360             1.50     0 -0.403 -0.550  -0.403    -0.459 -0.208  
       8 Merc 450SE             1.50     0 -0.403 -0.762  -0.403    -0.459  0.00423
       9 Hornet Sportabout      1.50     0 -0.403 -0.773  -0.403    -0.459  0.0150 
      10 AMC Javelin            1.50     0 -0.403 -0.780  -0.403    -0.459  0.0226 
      # i 310 more rows
      
      $Europe$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n      .y   .y_lo .y_mean .y_median .y_hi
         <ord>        <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 three            1     6 0.00218 -0.0999 0.00218   0.00214 0.104
       2 four             1     8 0.00218 -0.147  0.00218  -0.00135 0.154
       3 five             1     0 0.00218 -0.150  0.00218  -0.00135 0.158
       4 three            2     8 0.00616 -0.199  0.00616   0.0106  0.208
       5 four             2     7 0.0104  -0.198  0.0104    0.0250  0.207
       6 five             2     4 0.0315  -0.0678 0.0315    0.0249  0.137
       7 three            3     7 0.00616 -0.147  0.00616   0.0106  0.155
       8 four             3     2 0.0104  -0.149  0.0104    0.0227  0.159
       9 five             3     0 0.0369  -0.152  0.0369    0.0214  0.239
      10 three            4     8 0.00616 -0.199  0.00616   0.0129  0.206
      11 four             4     6 0.0104  -0.0985 0.0104    0.0262  0.106
      12 five             4     2 0.0369  -0.0995 0.0369    0.0214  0.187
      13 three            8     1 0.00616 -0.150  0.00616   0.0106  0.158
      14 four             8     1 0.00933 -0.201  0.00933   0.0227  0.209
      15 five             8     4 0.0359  -0.155  0.0359    0.0236  0.237
      
      $Europe$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n       .y   .y_lo  .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>    <dbl>   <dbl>    <dbl>     <dbl>  <dbl>
       1 three       1.50     0 -0.00213 -0.0403 -0.00213 -0.00217  0.0361
       2 four        1.50     0 -0.00213 -0.0492 -0.00213 -0.00213  0.0450
       3 five        1.50     1 -0.00213 -0.0555 -0.00213  0.000424 0.0490
       4 three       1.94     0 -0.00212 -0.0669 -0.00212  0.000451 0.0605
       5 four        1.94     6 -0.00207 -0.0881 -0.00207  0.000513 0.0818
       6 five        1.94     1 -0.00231 -0.0888 -0.00231  0.000513 0.0818
       7 three       2.46     1 -0.00212 -0.0881 -0.00212  0.000462 0.0817
       8 four        2.46     4 -0.00205 -0.0881 -0.00205  0.000523 0.0818
       9 five        2.46     2 -0.0123  -0.106  -0.0123  -0.0115   0.0812
      10 three       2.79     1 -0.00212 -0.0881 -0.00212  0.000462 0.0817
      # i 20 more rows
      
      $Europe$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median      .y_hi
             <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>      <dbl>
       1         1    1.50     0 -0.00454 -0.0267  -0.00454  -0.00454  0.0176   
       2         2    1.50     1 -0.00454 -0.0361  -0.00454  -0.00454  0.0270   
       3         3    1.50     0 -0.00454 -0.0401  -0.00454  -0.00454  0.0310   
       4         4    1.50     0 -0.00454 -0.00916 -0.00454  -0.00454  0.0000810
       5         8    1.50     0 -0.00454 -0.0407  -0.00454  -0.00454  0.0316   
       6         1    1.94     4 -0.00454 -0.0346  -0.00454  -0.00454  0.0255   
       7         2    1.94     3 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
       8         3    1.94     0 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
       9         4    1.94     0 -0.0185  -0.0319  -0.0185   -0.0161  -0.00715  
      10         8    1.94     0 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
      # i 40 more rows
      
      
      

---

    Code
      get(cat_cars_ale, exclude_cols = list(d2_all = "am"))
    Output
      $Asia
      $Asia$d1
      $Asia$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE     36 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      2 TRUE      28 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d1$am
      # A tibble: 2 x 7
        am.bin    .n      .y    .y_lo .y_mean .y_median  .y_hi
        <ord>  <int>   <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
      1 FALSE     38 0.00619 -0.0396  0.00619   0.0297  0.0320
      2 TRUE      26 0.0155  -0.00990 0.0155   -0.00670 0.0597
      
      $Asia$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental     2 -0.0226 -0.288 -0.0226    0.0422 0.187
       2 Cadillac Fleetwood      2  0.0932 -0.280  0.0932    0.195  0.380
       3 Merc 450SL              2 -0.235  -0.766 -0.235    -0.305  0.355
       4 Merc 450SLC             2 -0.235  -0.766 -0.235    -0.305  0.355
       5 Camaro Z28              2  0.0975 -0.304  0.0975   -0.290  0.829
       6 Chrysler Imperial       2  0.264  -0.279  0.264     0.210  0.854
       7 Duster 360              2  0.264  -0.279  0.264     0.210  0.854
       8 Merc 450SE              2  0.266  -0.279  0.266     0.216  0.854
       9 Hornet Sportabout       2  0.433  -0.279  0.433     0.216  1.33 
      10 AMC Javelin             2  0.446  -0.302  0.446    -0.244  1.78 
      # i 22 more rows
      
      $Asia$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n       .y   .y_lo  .y_mean .y_median   .y_hi
        <ord>    <int>    <dbl>   <dbl>    <dbl>     <dbl>   <dbl>
      1 three       30  0.118    0.0563  0.118      0.118   0.181 
      2 four        24  0.00198 -0.150   0.00198    0.0718  0.0948
      3 five        10 -0.330   -0.523  -0.330     -0.460  -0.0269
      
      $Asia$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n       .y    .y_lo  .y_mean .y_median     .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>     <dbl>
      1         1    14  0.00549  0.00549  0.00549   0.00549  0.00549 
      2         2    19 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      3         3     9 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      4         4    16 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      5         8     6 -0.00190 -0.00367 -0.00190  -0.00191 -0.000117
      
      $Asia$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n          .y       .y_lo     .y_mean   .y_median       .y_hi
           <dbl> <int>       <dbl>       <dbl>       <dbl>       <dbl>       <dbl>
       1    1.50     1  0.0000319   0.0000319   0.0000319   0.0000319   0.0000319 
       2    1.94     7 -0.00000143 -0.00000836 -0.00000143 -0.00000427  0.00000790
       3    2.46     7 -0.00000906 -0.0000153  -0.00000906 -0.00000787 -0.00000385
       4    2.79     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       5    3.19     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       6    3.44     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       7    3.52     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       8    3.73     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
       9    4.05     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
      10    5.45     7 -0.00000907 -0.0000153  -0.00000907 -0.00000788 -0.00000387
      
      
      $Asia$d2
      $Asia$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 FALSE      3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 FALSE      4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 FALSE      0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 FALSE      2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 FALSE      0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      11     10.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      12     14.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      13     15.2 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      14     16.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      15     18.7 TRUE       4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      16     19.8 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      17     21.4 TRUE       3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      18     22.9 TRUE       7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      19     30.1 TRUE       5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      20     33.9 TRUE       7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 FALSE      7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 FALSE      1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 FALSE      5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 FALSE      2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 FALSE      0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      11     10.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      12     14.4 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      13     15.2 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      14     16.4 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      15     18.7 TRUE       0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      16     19.8 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      17     21.4 TRUE       6 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      18     22.9 TRUE       2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      19     30.1 TRUE       5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      20     33.9 TRUE       7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin           .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>            <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 Lincoln Contine~     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 Lincoln Contine~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 310 more rows
      
      $Asia$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 three        1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4 three        7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2 three        5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4 three        5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7 three        5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8 three        3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4 three        1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9 three        3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1 three        0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9 three        0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 20 more rows
      
      $Asia$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>     <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7         1     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8         1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4         1     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9         1     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1         1     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9         1     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 40 more rows
      
      $Asia$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2     14.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3     15.2    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4     16.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5     18.7    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6     19.8    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7     21.4    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8     22.9    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9     30.1    1.50     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10     33.9    1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 90 more rows
      
      $Asia$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  FALSE     24 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      2 TRUE   FALSE     14 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      3 FALSE  TRUE      12 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      4 TRUE   TRUE      14 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin             .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>  <ord>              <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE  Lincoln Continent~     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2 TRUE   Lincoln Continent~     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3 FALSE  Cadillac Fleetwood     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4 TRUE   Cadillac Fleetwood     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5 FALSE  Merc 450SL             2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6 TRUE   Merc 450SL             0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7 FALSE  Merc 450SLC            2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8 TRUE   Merc 450SLC            0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9 FALSE  Camaro Z28             2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10 TRUE   Camaro Z28             0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      # i 54 more rows
      
      $Asia$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  three       24 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      2 TRUE   three        6 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      3 FALSE  four         4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      4 TRUE   four        20 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      5 FALSE  five         8 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      6 TRUE   five         2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2 TRUE           1    14 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3 FALSE          2    10 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4 TRUE           2     9 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5 FALSE          3     8 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6 TRUE           3     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7 FALSE          4    13 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8 TRUE           4     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9 FALSE          8     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10 TRUE           8     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       2 TRUE      1.50     1 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       3 FALSE     1.94     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       4 TRUE      1.94     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       5 FALSE     2.46     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       6 TRUE      2.46     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       7 FALSE     2.79     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       8 TRUE      2.79     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
       9 FALSE     3.19     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      10 TRUE      3.19     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      11 FALSE     3.44     2 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      12 TRUE      3.44     5 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      13 FALSE     3.52     3 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      14 TRUE      3.52     4 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      15 FALSE     3.73     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      16 TRUE      3.73     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      17 FALSE     4.05     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      18 TRUE      4.05     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      19 FALSE     5.45     7 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      20 TRUE      5.45     0 1.20e-14 1.20e-14 1.20e-14  1.20e-14 1.20e-14
      
      $Asia$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <ord>    <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental three        2 -0.0681 -0.184 -0.0681   -0.184  0.146
       2 Cadillac Fleetwood  three        2  0.0476 -0.184  0.0476   -0.184  0.476
       3 Merc 450SL          three        2 -0.280  -1.12  -0.280    -0.184  0.476
       4 Merc 450SLC         three        2 -0.114  -0.643 -0.114    -0.184  0.476
       5 Camaro Z28          three        2  0.389  -0.158  0.389     0.342  0.975
       6 Chrysler Imperial   three        2  0.223  -0.556  0.223     0.274  0.957
       7 Duster 360          three        2  0.223  -0.970  0.223     0.272  1.37 
       8 Merc 450SE          three        2  0.224  -0.687  0.224     0.250  1.11 
       9 Hornet Sportabout   three        2  0.225  -0.686  0.225     0.250  1.11 
      10 AMC Javelin         three        2 -0.0923 -1.59  -0.0923   -0.0198 1.34 
      # i 86 more rows
      
      $Asia$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0  3.42  3.42     3.42      3.42  3.42
       2 Cadillac Fleetwood          1     0  3.42  3.42     3.42      3.42  3.42
       3 Merc 450SL                  1     0  3.42  3.42     3.42      3.42  3.42
       4 Merc 450SLC                 1     0  3.42  3.42     3.42      3.42  3.42
       5 Camaro Z28                  1     0  3.42  3.42     3.42      3.42  3.42
       6 Chrysler Imperial           1     0  3.42  3.00     3.42      3.01  4.19
       7 Duster 360                  1     0  3.42 -0.295    3.42      2.05  8.30
       8 Merc 450SE                  1     0  3.42 -3.05     3.42      2.05 11.1 
       9 Hornet Sportabout           1     0  3.42 -3.45     3.42      2.05 11.5 
      10 AMC Javelin                 1     0  3.42 -3.81     3.42      2.05 11.8 
      # i 150 more rows
      
      $Asia$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n    .y   .y_lo .y_mean .y_median .y_hi
         <ord>                 <dbl> <int> <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental    1.50     0 0.342  0.342    0.342     0.342 0.342
       2 Cadillac Fleetwood     1.50     0 0.342  0.342    0.342     0.342 0.342
       3 Merc 450SL             1.50     0 0.342  0.342    0.342     0.342 0.342
       4 Merc 450SLC            1.50     0 0.342  0.342    0.342     0.342 0.342
       5 Camaro Z28             1.50     0 0.342  0.342    0.342     0.342 0.342
       6 Chrysler Imperial      1.50     0 0.342  0.319    0.342     0.342 0.366
       7 Duster 360             1.50     0 0.342  0.284    0.342     0.286 0.448
       8 Merc 450SE             1.50     0 0.342 -0.0164   0.342     0.286 0.749
       9 Hornet Sportabout      1.50     0 0.342 -0.0274   0.342     0.286 0.760
      10 AMC Javelin            1.50     0 0.342 -0.0351   0.342     0.286 0.768
      # i 310 more rows
      
      $Asia$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>        <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 three            1     6 0.0284  0.0284   0.0284    0.0284 0.0284
       2 four             1     8 0.0284 -0.0188   0.0284    0.0249 0.0785
       3 five             1     0 0.0284 -0.0220   0.0284    0.0249 0.0817
       4 three            2     8 0.0270 -0.0718   0.0270    0.0206 0.131 
       5 four             2     7 0.118   0.0612   0.118     0.135  0.161 
       6 five             2     4 0.0970  0.00282  0.0970    0.130  0.163 
       7 three            3     7 0.0341 -0.0182   0.0341    0.0372 0.0838
       8 four             3     2 0.149   0.120    0.149     0.140  0.185 
       9 five             3     0 0.123   0.0471   0.123     0.139  0.187 
      10 three            4     8 0.0456 -0.0699   0.0456    0.0598 0.149 
      11 four             4     6 0.307   0.206    0.307     0.358  0.364 
      12 five             4     2 0.285   0.221    0.285     0.270  0.361 
      13 three            8     1 0.0456 -0.0204   0.0456    0.0574 0.102 
      14 four             8     1 0.308   0.256    0.308     0.307  0.359 
      15 five             8     4 0.285   0.217    0.285     0.273  0.364 
      
      $Asia$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 three       1.50     0 0.0363  0.0363   0.0363    0.0363 0.0363
       2 four        1.50     0 0.0363  0.0274   0.0363    0.0364 0.0453
       3 five        1.50     1 0.0363  0.0212   0.0363    0.0389 0.0493
       4 three       1.94     0 0.0470  0.0108   0.0470    0.0619 0.0704
       5 four        1.94     6 0.0550  0.00593  0.0550    0.0757 0.0864
       6 five        1.94     1 0.0552  0.00661  0.0552    0.0757 0.0864
       7 three       2.46     1 0.0487 -0.00963  0.0487    0.0762 0.0838
       8 four        2.46     4 0.0623  0.0132   0.0623    0.0852 0.0919
       9 five        2.46     2 0.0725  0.0313   0.0725    0.0923 0.0970
      10 three       2.79     1 0.0489 -0.00962  0.0489    0.0764 0.0840
      # i 20 more rows
      
      $Asia$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n      .y    .y_lo .y_mean .y_median   .y_hi
             <dbl>   <dbl> <int>   <dbl>    <dbl>   <dbl>     <dbl>   <dbl>
       1         1    1.50     0 0.00454  0.00454 0.00454   0.00454 0.00454
       2         2    1.50     1 0.00454 -0.0270  0.00454   0.00454 0.0361 
       3         3    1.50     0 0.00454 -0.0216  0.00454   0.00454 0.0307 
       4         4    1.50     0 0.00454 -0.0310  0.00454   0.00454 0.0401 
       5         8    1.50     0 0.00454 -0.0316  0.00454   0.00454 0.0407 
       6         1    1.94     4 0.00454 -0.00336 0.00454   0.00454 0.0124 
       7         2    1.94     3 0.0185  -0.0159  0.0185    0.00668 0.0629 
       8         3    1.94     0 0.0185  -0.00651 0.0185    0.00668 0.0535 
       9         4    1.94     0 0.0185  -0.0159  0.0185    0.00668 0.0629 
      10         8    1.94     0 0.0185  -0.0159  0.0185    0.00668 0.0629 
      # i 40 more rows
      
      
      
      $Europe
      $Europe$d1
      $Europe$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE     36 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      2 TRUE      28 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d1$am
      # A tibble: 2 x 7
        am.bin    .n       .y   .y_lo  .y_mean .y_median   .y_hi
        <ord>  <int>    <dbl>   <dbl>    <dbl>     <dbl>   <dbl>
      1 FALSE     38 -0.00619 -0.0320 -0.00619  -0.0297  0.0396 
      2 TRUE      26 -0.0155  -0.0597 -0.0155    0.00670 0.00990
      
      $Europe$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental     2  0.217  -0.164  0.217      0.166 0.641
       2 Cadillac Fleetwood      2  0.268  -0.494  0.268      0.166 1.12 
       3 Merc 450SL              2  0.931  -0.444  0.931      1.17  2.10 
       4 Merc 450SLC             2  0.764  -0.444  0.764      1.17  1.63 
       5 Camaro Z28              2 -0.0688 -1.44  -0.0688     0.166 1.10 
       6 Chrysler Imperial       2  0.0978 -0.967  0.0978     0.166 1.10 
       7 Duster 360              2  0.0978 -0.967  0.0978     0.166 1.10 
       8 Merc 450SE              2  0.596  -0.917  0.596      1.17  1.62 
       9 Hornet Sportabout       2 -0.237  -1.92  -0.237      0.166 1.10 
      10 AMC Javelin             2 -0.0841 -1.92  -0.0841     0.166 1.54 
      # i 22 more rows
      
      $Europe$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n     .y   .y_lo .y_mean .y_median  .y_hi
        <ord>    <int>  <dbl>   <dbl>   <dbl>     <dbl>  <dbl>
      1 three       30 -0.239 -0.366   -0.239    -0.239 -0.112
      2 four        24  0.247  0.140    0.247     0.211  0.385
      3 five        10  0.380 -0.0309   0.380     0.594  0.609
      
      $Europe$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n       .y     .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>     <dbl>    <dbl>     <dbl>    <dbl>
      1         1    14 -0.00549 -0.00549  -0.00549  -0.00549 -0.00549
      2         2    19  0.00190  0.000117  0.00190   0.00191  0.00367
      3         3     9  0.00190  0.000117  0.00190   0.00191  0.00367
      4         4    16  0.00190  0.000117  0.00190   0.00191  0.00367
      5         8     6  0.00190  0.000117  0.00190   0.00191  0.00367
      
      $Europe$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n          .y       .y_lo     .y_mean   .y_median       .y_hi
           <dbl> <int>       <dbl>       <dbl>       <dbl>       <dbl>       <dbl>
       1    1.50     1 -0.0000319  -0.0000319  -0.0000319  -0.0000319  -0.0000319 
       2    1.94     7  0.00000143 -0.00000790  0.00000143  0.00000427  0.00000836
       3    2.46     7  0.00000906  0.00000385  0.00000906  0.00000787  0.0000153 
       4    2.79     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       5    3.19     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       6    3.44     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       7    3.52     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       8    3.73     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
       9    4.05     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
      10    5.45     7  0.00000907  0.00000387  0.00000907  0.00000788  0.0000153 
      
      
      $Europe$d2
      $Europe$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 FALSE      3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 FALSE      4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 FALSE      0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 FALSE      2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 FALSE      0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      11     10.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      12     14.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      13     15.2 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      14     16.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      15     18.7 TRUE       4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      16     19.8 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      17     21.4 TRUE       3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      18     22.9 TRUE       7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      19     30.1 TRUE       5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      20     33.9 TRUE       7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 FALSE      7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 FALSE      1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 FALSE      5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 FALSE      2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 FALSE      0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      11     10.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      12     14.4 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      13     15.2 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      14     16.4 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      15     18.7 TRUE       0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      16     19.8 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      17     21.4 TRUE       6 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      18     22.9 TRUE       2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      19     30.1 TRUE       5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      20     33.9 TRUE       7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin           .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>            <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 Lincoln Contine~     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 Lincoln Contine~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 310 more rows
      
      $Europe$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 three        1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4 three        7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2 three        5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4 three        5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7 three        5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8 three        3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4 three        1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9 three        3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1 three        0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9 three        0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 20 more rows
      
      $Europe$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>     <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7         1     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8         1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4         1     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9         1     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1         1     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9         1     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 40 more rows
      
      $Europe$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2     14.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3     15.2    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4     16.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5     18.7    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6     19.8    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7     21.4    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8     22.9    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9     30.1    1.50     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10     33.9    1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 90 more rows
      
      $Europe$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  FALSE     24 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      2 TRUE   FALSE     14 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      3 FALSE  TRUE      12 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      4 TRUE   TRUE      14 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin             .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>  <ord>              <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE  Lincoln Continent~     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2 TRUE   Lincoln Continent~     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3 FALSE  Cadillac Fleetwood     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4 TRUE   Cadillac Fleetwood     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5 FALSE  Merc 450SL             2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6 TRUE   Merc 450SL             0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7 FALSE  Merc 450SLC            2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8 TRUE   Merc 450SLC            0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9 FALSE  Camaro Z28             2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10 TRUE   Camaro Z28             0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      # i 54 more rows
      
      $Europe$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  three       24 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      2 TRUE   three        6 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      3 FALSE  four         4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      4 TRUE   four        20 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      5 FALSE  five         8 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      6 TRUE   five         2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2 TRUE           1    14 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3 FALSE          2    10 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4 TRUE           2     9 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5 FALSE          3     8 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6 TRUE           3     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7 FALSE          4    13 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8 TRUE           4     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9 FALSE          8     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10 TRUE           8     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       2 TRUE      1.50     1 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       3 FALSE     1.94     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       4 TRUE      1.94     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       5 FALSE     2.46     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       6 TRUE      2.46     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       7 FALSE     2.79     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       8 TRUE      2.79     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
       9 FALSE     3.19     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      10 TRUE      3.19     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      11 FALSE     3.44     2 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      12 TRUE      3.44     5 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      13 FALSE     3.52     3 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      14 TRUE      3.52     4 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      15 FALSE     3.73     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      16 TRUE      3.73     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      17 FALSE     4.05     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      18 TRUE      4.05     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      19 FALSE     5.45     7 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      20 TRUE      5.45     0 1.31e-14 1.31e-14 1.31e-14  1.31e-14 1.31e-14
      
      $Europe$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n     .y   .y_lo .y_mean .y_median .y_hi
         <ord>               <ord>    <int>  <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental three        2 0.185  -0.0288  0.185     0.301  0.301
       2 Cadillac Fleetwood  three        2 0.0696 -0.359   0.0696    0.301  0.301
       3 Merc 450SL          three        2 0.399  -0.359   0.399     0.301  1.24 
       4 Merc 450SLC         three        2 0.399  -0.359   0.399     0.301  1.24 
       5 Camaro Z28          three        2 0.0663 -0.832   0.0663    0.301  0.765
       6 Chrysler Imperial   three        2 0.0663 -0.450   0.0663   -0.0912 0.717
       7 Duster 360          three        2 0.0663 -0.693   0.0663    0.211  0.703
       8 Merc 450SE          three        2 0.0643 -0.692   0.0643    0.235  0.676
       9 Hornet Sportabout   three        2 0.0643 -0.533   0.0643   -0.0418 0.752
      10 AMC Javelin         three        2 0.218  -0.455   0.218     0.177  0.924
      # i 86 more rows
      
      $Europe$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       2 Cadillac Fleetwood          1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       3 Merc 450SL                  1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       4 Merc 450SLC                 1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       5 Camaro Z28                  1     0 -3.89  -3.89   -3.89     -3.89 -3.89
       6 Chrysler Imperial           1     0 -3.89  -5.43   -3.89     -5.05 -1.37
       7 Duster 360                  1     0 -3.89  -8.50   -3.89     -5.26  1.88
       8 Merc 450SE                  1     0 -3.89 -10.8    -3.89     -5.26  4.14
       9 Hornet Sportabout           1     0 -3.89 -10.8    -3.89     -5.26  4.15
      10 AMC Javelin                 1     0 -3.89 -11.1    -3.89     -5.26  4.50
      # i 150 more rows
      
      $Europe$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n     .y  .y_lo .y_mean .y_median    .y_hi
         <ord>                 <dbl> <int>  <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
       1 Lincoln Continental    1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       2 Cadillac Fleetwood     1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       3 Merc 450SL             1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       4 Merc 450SLC            1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       5 Camaro Z28             1.50     0 -0.403 -0.403  -0.403    -0.403 -0.403  
       6 Chrysler Imperial      1.50     0 -0.403 -0.460  -0.403    -0.459 -0.297  
       7 Duster 360             1.50     0 -0.403 -0.550  -0.403    -0.459 -0.208  
       8 Merc 450SE             1.50     0 -0.403 -0.762  -0.403    -0.459  0.00423
       9 Hornet Sportabout      1.50     0 -0.403 -0.773  -0.403    -0.459  0.0150 
      10 AMC Javelin            1.50     0 -0.403 -0.780  -0.403    -0.459  0.0226 
      # i 310 more rows
      
      $Europe$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n      .y   .y_lo .y_mean .y_median .y_hi
         <ord>        <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl> <dbl>
       1 three            1     6 0.00218 -0.0999 0.00218   0.00214 0.104
       2 four             1     8 0.00218 -0.147  0.00218  -0.00135 0.154
       3 five             1     0 0.00218 -0.150  0.00218  -0.00135 0.158
       4 three            2     8 0.00616 -0.199  0.00616   0.0106  0.208
       5 four             2     7 0.0104  -0.198  0.0104    0.0250  0.207
       6 five             2     4 0.0315  -0.0678 0.0315    0.0249  0.137
       7 three            3     7 0.00616 -0.147  0.00616   0.0106  0.155
       8 four             3     2 0.0104  -0.149  0.0104    0.0227  0.159
       9 five             3     0 0.0369  -0.152  0.0369    0.0214  0.239
      10 three            4     8 0.00616 -0.199  0.00616   0.0129  0.206
      11 four             4     6 0.0104  -0.0985 0.0104    0.0262  0.106
      12 five             4     2 0.0369  -0.0995 0.0369    0.0214  0.187
      13 three            8     1 0.00616 -0.150  0.00616   0.0106  0.158
      14 four             8     1 0.00933 -0.201  0.00933   0.0227  0.209
      15 five             8     4 0.0359  -0.155  0.0359    0.0236  0.237
      
      $Europe$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n       .y   .y_lo  .y_mean .y_median  .y_hi
         <ord>      <dbl> <int>    <dbl>   <dbl>    <dbl>     <dbl>  <dbl>
       1 three       1.50     0 -0.00213 -0.0403 -0.00213 -0.00217  0.0361
       2 four        1.50     0 -0.00213 -0.0492 -0.00213 -0.00213  0.0450
       3 five        1.50     1 -0.00213 -0.0555 -0.00213  0.000424 0.0490
       4 three       1.94     0 -0.00212 -0.0669 -0.00212  0.000451 0.0605
       5 four        1.94     6 -0.00207 -0.0881 -0.00207  0.000513 0.0818
       6 five        1.94     1 -0.00231 -0.0888 -0.00231  0.000513 0.0818
       7 three       2.46     1 -0.00212 -0.0881 -0.00212  0.000462 0.0817
       8 four        2.46     4 -0.00205 -0.0881 -0.00205  0.000523 0.0818
       9 five        2.46     2 -0.0123  -0.106  -0.0123  -0.0115   0.0812
      10 three       2.79     1 -0.00212 -0.0881 -0.00212  0.000462 0.0817
      # i 20 more rows
      
      $Europe$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median      .y_hi
             <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>      <dbl>
       1         1    1.50     0 -0.00454 -0.0267  -0.00454  -0.00454  0.0176   
       2         2    1.50     1 -0.00454 -0.0361  -0.00454  -0.00454  0.0270   
       3         3    1.50     0 -0.00454 -0.0401  -0.00454  -0.00454  0.0310   
       4         4    1.50     0 -0.00454 -0.00916 -0.00454  -0.00454  0.0000810
       5         8    1.50     0 -0.00454 -0.0407  -0.00454  -0.00454  0.0316   
       6         1    1.94     4 -0.00454 -0.0346  -0.00454  -0.00454  0.0255   
       7         2    1.94     3 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
       8         3    1.94     0 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
       9         4    1.94     0 -0.0185  -0.0319  -0.0185   -0.0161  -0.00715  
      10         8    1.94     0 -0.0185  -0.0629  -0.0185   -0.00668  0.0159   
      # i 40 more rows
      
      
      
      $`North America`
      $`North America`$d1
      $`North America`$d1$mpg
      # A tibble: 10 x 7
         mpg.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d1$vs
      # A tibble: 2 x 7
        vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE     36 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      2 TRUE      28 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d1$am
      # A tibble: 2 x 7
        am.bin    .n        .y     .y_lo   .y_mean .y_median    .y_hi
        <ord>  <int>     <dbl>     <dbl>     <dbl>     <dbl>    <dbl>
      1 FALSE     38 -5.57e-10 -9.65e-10 -5.57e-10 -8.52e-10 1.02e-10
      2 TRUE      26  1.57e-10 -2.14e-10  1.57e-10 -4.71e-11 7.00e-10
      
      $`North America`$d1$model
      # A tibble: 32 x 7
         model.bin              .n      .y  .y_lo .y_mean .y_median  .y_hi
         <ord>               <int>   <dbl>  <dbl>   <dbl>     <dbl>  <dbl>
       1 Lincoln Continental     2 -0.195  -0.811 -0.195      0.139 0.139 
       2 Cadillac Fleetwood      2 -0.361  -1.29  -0.361      0.139 0.139 
       3 Merc 450SL              2 -0.695  -1.34  -0.695     -0.861 0.0888
       4 Merc 450SLC             2 -0.529  -0.863 -0.529     -0.861 0.0888
       5 Camaro Z28              2 -0.0287 -0.813 -0.0287     0.139 0.614 
       6 Chrysler Imperial       2 -0.362  -1.29  -0.362      0.139 0.139 
       7 Duster 360              2 -0.362  -1.29  -0.362      0.139 0.139 
       8 Merc 450SE              2 -0.862  -1.81  -0.862     -0.861 0.0888
       9 Hornet Sportabout       2 -0.195  -1.29  -0.195      0.139 0.614 
      10 AMC Javelin             2 -0.362  -1.29  -0.362      0.139 0.139 
      # i 22 more rows
      
      $`North America`$d1$gear
      # A tibble: 3 x 7
        gear.bin    .n      .y   .y_lo .y_mean .y_median   .y_hi
        <ord>    <int>   <dbl>   <dbl>   <dbl>     <dbl>   <dbl>
      1 three       30  0.120   0.0527  0.120     0.0544  0.244 
      2 four        24 -0.249  -0.280  -0.249    -0.232  -0.232 
      3 five        10 -0.0498 -0.131  -0.0498   -0.0843  0.0603
      
      $`North America`$d1$carb
      # A tibble: 5 x 7
        carb.ceil    .n            .y         .y_lo       .y_mean  .y_median     .y_hi
            <dbl> <int>         <dbl>         <dbl>         <dbl>      <dbl>     <dbl>
      1         1    14  0.000000108   0.000000108   0.000000108     1.08e-7  1.08e- 7
      2         2    19 -0.0000000359 -0.0000000704 -0.0000000359   -3.71e-8 -5.22e-10
      3         3     9 -0.0000000359 -0.0000000704 -0.0000000359   -3.71e-8 -5.24e-10
      4         4    16 -0.0000000359 -0.0000000704 -0.0000000359   -3.71e-8 -5.24e-10
      5         8     6 -0.0000000413 -0.0000000817 -0.0000000413   -4.13e-8 -9.49e-10
      
      $`North America`$d1$wt
      # A tibble: 10 x 7
         wt.ceil    .n       .y     .y_lo  .y_mean .y_median    .y_hi
           <dbl> <int>    <dbl>     <dbl>    <dbl>     <dbl>    <dbl>
       1    1.50     1 6.60e-10  6.60e-10 6.60e-10  6.60e-10 6.60e-10
       2    1.94     7 2.64e-10 -1.47e-12 2.64e-10  1.40e-10 6.34e-10
       3    2.46     7 2.19e-10 -4.35e-11 2.19e-10  6.88e-11 6.08e-10
       4    2.79     7 2.19e-10 -4.36e-11 2.19e-10  6.88e-11 6.08e-10
       5    3.19     7 2.19e-10 -4.36e-11 2.19e-10  6.88e-11 6.08e-10
       6    3.44     7 2.19e-10 -4.28e-11 2.19e-10  6.88e-11 6.09e-10
       7    3.52     7 2.19e-10 -4.28e-11 2.19e-10  6.90e-11 6.10e-10
       8    3.73     7 2.19e-10 -4.28e-11 2.19e-10  6.90e-11 6.10e-10
       9    4.05     7 2.19e-10 -4.28e-11 2.19e-10  6.90e-11 6.10e-10
      10    5.45     7 2.19e-10 -4.28e-11 2.19e-10  6.90e-11 6.10e-10
      
      
      $`North America`$d2
      $`North America`$d2$`mpg:vs`
      # A tibble: 20 x 8
         mpg.ceil vs.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7 FALSE      3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4 FALSE      4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9 FALSE      0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1 FALSE      2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9 FALSE      0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      11     10.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      12     14.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      13     15.2 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      14     16.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      15     18.7 TRUE       4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      16     19.8 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      17     21.4 TRUE       3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      18     22.9 TRUE       7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      19     30.1 TRUE       5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      20     33.9 TRUE       7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`mpg:am`
      # A tibble: 20 x 8
         mpg.ceil am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 FALSE      1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7 FALSE      7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4 FALSE      1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9 FALSE      5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1 FALSE      2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9 FALSE      0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      11     10.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      12     14.4 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      13     15.2 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      14     16.4 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      15     18.7 TRUE       0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      16     19.8 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      17     21.4 TRUE       6 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      18     22.9 TRUE       2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      19     30.1 TRUE       5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      20     33.9 TRUE       7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`mpg:model`
      # A tibble: 320 x 8
         mpg.ceil model.bin           .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>            <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4 Lincoln Contine~     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9 Lincoln Contine~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 310 more rows
      
      $`North America`$d2$`mpg:gear`
      # A tibble: 30 x 8
         mpg.ceil gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl> <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4 three        1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4 three        7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2 three        5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4 three        5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7 three        5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8 three        3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4 three        1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9 three        3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1 three        0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9 three        0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 20 more rows
      
      $`North America`$d2$`mpg:carb`
      # A tibble: 50 x 8
         mpg.ceil carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>     <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7         1     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8         1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4         1     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9         1     5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1         1     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9         1     4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 40 more rows
      
      $`North America`$d2$`mpg:wt`
      # A tibble: 100 x 8
         mpg.ceil wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
            <dbl>   <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1     10.4    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2     14.4    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3     15.2    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4     16.4    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5     18.7    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6     19.8    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7     21.4    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8     22.9    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9     30.1    1.50     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10     33.9    1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 90 more rows
      
      $`North America`$d2$`vs:am`
      # A tibble: 4 x 8
        vs.bin am.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>  <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  FALSE     24 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      2 TRUE   FALSE     14 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      3 FALSE  TRUE      12 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      4 TRUE   TRUE      14 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`vs:model`
      # A tibble: 64 x 8
         vs.bin model.bin             .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>  <ord>              <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE  Lincoln Continent~     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2 TRUE   Lincoln Continent~     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3 FALSE  Cadillac Fleetwood     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4 TRUE   Cadillac Fleetwood     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5 FALSE  Merc 450SL             2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6 TRUE   Merc 450SL             0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7 FALSE  Merc 450SLC            2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8 TRUE   Merc 450SLC            0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9 FALSE  Camaro Z28             2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10 TRUE   Camaro Z28             0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      # i 54 more rows
      
      $`North America`$d2$`vs:gear`
      # A tibble: 6 x 8
        vs.bin gear.bin    .n       .y    .y_lo  .y_mean .y_median    .y_hi
        <ord>  <ord>    <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
      1 FALSE  three       24 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      2 TRUE   three        6 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      3 FALSE  four         4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      4 TRUE   four        20 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      5 FALSE  five         8 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      6 TRUE   five         2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`vs:carb`
      # A tibble: 10 x 8
         vs.bin carb.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>      <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE          1     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2 TRUE           1    14 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3 FALSE          2    10 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4 TRUE           2     9 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5 FALSE          3     8 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6 TRUE           3     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7 FALSE          4    13 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8 TRUE           4     3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9 FALSE          8     5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10 TRUE           8     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`vs:wt`
      # A tibble: 20 x 8
         vs.bin wt.ceil    .n       .y    .y_lo  .y_mean .y_median    .y_hi
         <ord>    <dbl> <int>    <dbl>    <dbl>    <dbl>     <dbl>    <dbl>
       1 FALSE     1.50     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       2 TRUE      1.50     1 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       3 FALSE     1.94     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       4 TRUE      1.94     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       5 FALSE     2.46     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       6 TRUE      2.46     5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       7 FALSE     2.79     4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       8 TRUE      2.79     3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
       9 FALSE     3.19     4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      10 TRUE      3.19     3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      11 FALSE     3.44     2 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      12 TRUE      3.44     5 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      13 FALSE     3.52     3 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      14 TRUE      3.52     4 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      15 FALSE     3.73     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      16 TRUE      3.73     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      17 FALSE     4.05     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      18 TRUE      4.05     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      19 FALSE     5.45     7 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      20 TRUE      5.45     0 2.64e-14 2.64e-14 2.64e-14  2.64e-14 2.64e-14
      
      $`North America`$d2$`model:gear`
      # A tibble: 96 x 8
         model.bin           gear.bin    .n     .y  .y_lo .y_mean .y_median  .y_hi
         <ord>               <ord>    <int>  <dbl>  <dbl>   <dbl>     <dbl>  <dbl>
       1 Lincoln Continental three        2 -0.117 -0.117  -0.117   -0.117  -0.117
       2 Cadillac Fleetwood  three        2 -0.117 -0.117  -0.117   -0.117  -0.117
       3 Merc 450SL          three        2 -0.119 -0.122  -0.119   -0.117  -0.117
       4 Merc 450SLC         three        2 -0.285 -0.596  -0.285   -0.117  -0.117
       5 Camaro Z28          three        2 -0.455 -1.08   -0.455   -0.117  -0.117
       6 Chrysler Imperial   three        2 -0.289 -1.42   -0.289    0.305   0.337
       7 Duster 360          three        2 -0.289 -1.15   -0.289    0.0335  0.303
       8 Merc 450SE          three        2 -0.289 -1.15   -0.289    0.0334  0.303
       9 Hornet Sportabout   three        2 -0.289 -1.59   -0.289    0.398   0.432
      10 AMC Javelin         three        2 -0.125 -1.13   -0.125    0.285   0.534
      # i 86 more rows
      
      $`North America`$d2$`model:carb`
      # A tibble: 160 x 8
         model.bin           carb.ceil    .n    .y  .y_lo .y_mean .y_median .y_hi
         <ord>                   <dbl> <int> <dbl>  <dbl>   <dbl>     <dbl> <dbl>
       1 Lincoln Continental         1     0 0.471  0.471   0.471     0.471 0.471
       2 Cadillac Fleetwood          1     0 0.471  0.471   0.471     0.471 0.471
       3 Merc 450SL                  1     0 0.471  0.471   0.471     0.471 0.471
       4 Merc 450SLC                 1     0 0.471  0.471   0.471     0.471 0.471
       5 Camaro Z28                  1     0 0.471  0.471   0.471     0.471 0.471
       6 Chrysler Imperial           1     0 0.471 -1.49    0.471    -0.690 3.42 
       7 Duster 360                  1     0 0.471 -5.32    0.471    -0.895 7.42 
       8 Merc 450SE                  1     0 0.471 -6.40    0.471    -0.895 8.51 
       9 Hornet Sportabout           1     0 0.471 -6.67    0.471    -0.895 8.77 
      10 AMC Javelin                 1     0 0.471 -6.76    0.471    -0.895 8.87 
      # i 150 more rows
      
      $`North America`$d2$`model:wt`
      # A tibble: 320 x 8
         model.bin           wt.ceil    .n     .y    .y_lo .y_mean .y_median  .y_hi
         <ord>                 <dbl> <int>  <dbl>    <dbl>   <dbl>     <dbl>  <dbl>
       1 Lincoln Continental    1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       2 Cadillac Fleetwood     1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       3 Merc 450SL             1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       4 Merc 450SLC            1.50     0 0.0603  0.0603   0.0603   0.0603  0.0603
       5 Camaro Z28             1.50     0 0.0603  0.0527   0.0603   0.0602  0.0681
       6 Chrysler Imperial      1.50     0 0.0603  0.00257  0.0603   0.00402 0.166 
       7 Duster 360             1.50     0 0.0603 -0.239    0.0603   0.00402 0.407 
       8 Merc 450SE             1.50     0 0.0603 -0.301    0.0603   0.00402 0.470 
       9 Hornet Sportabout      1.50     0 0.0603 -0.317    0.0603   0.00402 0.486 
      10 AMC Javelin            1.50     0 0.0603 -0.317    0.0603   0.00402 0.486 
      # i 310 more rows
      
      $`North America`$d2$`gear:carb`
      # A tibble: 15 x 8
         gear.bin carb.ceil    .n      .y  .y_lo .y_mean .y_median    .y_hi
         <ord>        <dbl> <int>   <dbl>  <dbl>   <dbl>     <dbl>    <dbl>
       1 three            1     6 -0.0306 -0.106 -0.0306   -0.0663  0.0748 
       2 four             1     8 -0.0306 -0.153 -0.0306   -0.0698  0.125  
       3 five             1     0 -0.0306 -0.156 -0.0306   -0.0698  0.128  
       4 three            2     8 -0.0331 -0.206 -0.0331   -0.0775  0.177  
       5 four             2     7 -0.129  -0.341 -0.129    -0.227   0.167  
       6 five             2     4 -0.129  -0.241 -0.129    -0.226   0.0664 
       7 three            3     7 -0.0403 -0.154 -0.0403   -0.0940  0.119  
       8 four             3     2 -0.159  -0.322 -0.159    -0.257   0.0858 
       9 five             3     0 -0.160  -0.374 -0.160    -0.257   0.135  
      10 three            4     8 -0.0518 -0.208 -0.0518   -0.112   0.155  
      11 four             4     6 -0.317  -0.437 -0.317    -0.427  -0.105  
      12 five             4     2 -0.322  -0.494 -0.322    -0.433  -0.0547 
      13 three            8     1 -0.0518 -0.158 -0.0518   -0.114   0.108  
      14 four             8     1 -0.317  -0.534 -0.317    -0.431  -0.00255
      15 five             8     4 -0.321  -0.544 -0.321    -0.432  -0.00476
      
      $`North America`$d2$`gear:wt`
      # A tibble: 30 x 8
         gear.bin wt.ceil    .n      .y   .y_lo .y_mean .y_median   .y_hi
         <ord>      <dbl> <int>   <dbl>   <dbl>   <dbl>     <dbl>   <dbl>
       1 three       1.50     0 -0.0342 -0.0869 -0.0342   -0.0210 0.00727
       2 four        1.50     0 -0.0342 -0.0958 -0.0342   -0.0210 0.0162 
       3 five        1.50     1 -0.0342 -0.102  -0.0342   -0.0184 0.0202 
       4 three       1.94     0 -0.0448 -0.115  -0.0448   -0.0504 0.0301 
       5 four        1.94     6 -0.0529 -0.152  -0.0529   -0.0553 0.0484 
       6 five        1.94     1 -0.0529 -0.152  -0.0529   -0.0553 0.0484 
       7 three       2.46     1 -0.0466 -0.137  -0.0466   -0.0557 0.0510 
       8 four        2.46     4 -0.0603 -0.159  -0.0603   -0.0648 0.0428 
       9 five        2.46     2 -0.0603 -0.159  -0.0603   -0.0648 0.0428 
      10 three       2.79     1 -0.0468 -0.137  -0.0468   -0.0559 0.0509 
      # i 20 more rows
      
      $`North America`$d2$`carb:wt`
      # A tibble: 50 x 8
         carb.ceil wt.ceil    .n           .y    .y_lo      .y_mean .y_median   .y_hi
             <dbl>   <dbl> <int>        <dbl>    <dbl>        <dbl>     <dbl>   <dbl>
       1         1    1.50     0 0.0000000171 -0.0315  0.0000000171  -1.68e-7 0.0315 
       2         2    1.50     1 0.0000000171 -0.00404 0.0000000171  -1.03e-8 0.00404
       3         3    1.50     0 0.0000000171 -0.0356  0.0000000171  -1.96e-7 0.0356 
       4         4    1.50     0 0.0000000171 -0.0267  0.0000000171  -1.34e-7 0.0267 
       5         8    1.50     0 0.0000000171 -0.0362  0.0000000171  -1.95e-7 0.0362 
       6         1    1.94     4 0.0000000171 -0.0394  0.0000000171  -1.98e-7 0.0394 
       7         2    1.94     3 0.000000105  -0.00790 0.000000105   -5.22e-9 0.00790
       8         3    1.94     0 0.000000105  -0.0394  0.000000105   -1.91e-7 0.0394 
       9         4    1.94     0 0.000000105  -0.0300  0.000000105   -1.26e-7 0.0300 
      10         8    1.94     0 0.000000105  -0.0394  0.000000105   -1.88e-7 0.0394 
      # i 40 more rows
      
      
      

---

    Code
      get(cat_cars_ale, stats = "conf_regions")
    Message
      ! Note that confidence regions are not reliable with fewer than 100 bootstrap iterations or p-values based on fewer than 100 random iterations.
      i There are 2 bootstrap iterations.
      i p-values are based on 100 iterations.
    Output
      $Asia
      $Asia$d1
      # A tibble: 45 x 12
         term  x             start_x end_x x_span_pct     n    pct         y   start_y
         <chr> <chr>           <dbl> <dbl>      <dbl> <int>  <dbl>     <dbl>     <dbl>
       1 mpg   <NA>             10.4  33.9        100    64 100    NA         1.20e-14
       2 vs    FALSE            NA    NA           NA    36  56.2   1.20e-14 NA       
       3 vs    TRUE             NA    NA           NA    28  43.8   1.20e-14 NA       
       4 am    FALSE            NA    NA           NA    38  59.4   6.19e- 3 NA       
       5 am    TRUE             NA    NA           NA    26  40.6   1.55e- 2 NA       
       6 model Lincoln Cont~    NA    NA           NA     2   3.12 -2.26e- 2 NA       
       7 model Cadillac Fle~    NA    NA           NA     2   3.12  9.32e- 2 NA       
       8 model Merc 450SL       NA    NA           NA     2   3.12 -2.35e- 1 NA       
       9 model Merc 450SLC      NA    NA           NA     2   3.12 -2.35e- 1 NA       
      10 model Camaro Z28       NA    NA           NA     2   3.12  9.75e- 2 NA       
      # i 35 more rows
      # i 3 more variables: end_y <dbl>, trend <dbl>, aler_band <ord>
      
      $Asia$d2
      # A tibble: 315 x 8
         term1 x1          term2 x2    aler_band     n   pct        y
         <chr> <chr>       <chr> <chr> <ord>     <int> <dbl>    <dbl>
       1 mpg   [10.4,18.7] vs    FALSE overlap      25 39.1  1.20e-14
       2 mpg   (18.7,21.4] vs    FALSE overlap       9 14.1  1.20e-14
       3 mpg   (21.4,33.9] vs    FALSE overlap       2  3.12 1.20e-14
       4 mpg   [10.4,18.7] vs    TRUE  overlap       4  6.25 1.20e-14
       5 mpg   (18.7,21.4] vs    TRUE  overlap       5  7.81 1.20e-14
       6 mpg   (21.4,33.9] vs    TRUE  overlap      19 29.7  1.20e-14
       7 mpg   [10.4,16.4] am    FALSE overlap      18 28.1  1.20e-14
       8 mpg   (16.4,21.4] am    FALSE overlap      13 20.3  1.20e-14
       9 mpg   (21.4,33.9] am    FALSE overlap       7 10.9  1.20e-14
      10 mpg   [10.4,16.4] am    TRUE  overlap       4  6.25 1.20e-14
      # i 305 more rows
      
      
      $Europe
      $Europe$d1
      # A tibble: 45 x 12
         term  x             start_x end_x x_span_pct     n    pct         y   start_y
         <chr> <chr>           <dbl> <dbl>      <dbl> <int>  <dbl>     <dbl>     <dbl>
       1 mpg   <NA>             10.4  33.9        100    64 100    NA         1.31e-14
       2 vs    FALSE            NA    NA           NA    36  56.2   1.31e-14 NA       
       3 vs    TRUE             NA    NA           NA    28  43.8   1.31e-14 NA       
       4 am    FALSE            NA    NA           NA    38  59.4  -6.19e- 3 NA       
       5 am    TRUE             NA    NA           NA    26  40.6  -1.55e- 2 NA       
       6 model Lincoln Cont~    NA    NA           NA     2   3.12  2.17e- 1 NA       
       7 model Cadillac Fle~    NA    NA           NA     2   3.12  2.68e- 1 NA       
       8 model Merc 450SL       NA    NA           NA     2   3.12  9.31e- 1 NA       
       9 model Merc 450SLC      NA    NA           NA     2   3.12  7.64e- 1 NA       
      10 model Camaro Z28       NA    NA           NA     2   3.12 -6.88e- 2 NA       
      # i 35 more rows
      # i 3 more variables: end_y <dbl>, trend <dbl>, aler_band <ord>
      
      $Europe$d2
      # A tibble: 310 x 8
         term1 x1          term2 x2    aler_band     n   pct        y
         <chr> <chr>       <chr> <chr> <ord>     <int> <dbl>    <dbl>
       1 mpg   [10.4,18.7] vs    FALSE overlap      25 39.1  1.31e-14
       2 mpg   (18.7,21.4] vs    FALSE overlap       9 14.1  1.31e-14
       3 mpg   (21.4,33.9] vs    FALSE overlap       2  3.12 1.31e-14
       4 mpg   [10.4,18.7] vs    TRUE  overlap       4  6.25 1.31e-14
       5 mpg   (18.7,21.4] vs    TRUE  overlap       5  7.81 1.31e-14
       6 mpg   (21.4,33.9] vs    TRUE  overlap      19 29.7  1.31e-14
       7 mpg   [10.4,16.4] am    FALSE overlap      18 28.1  1.31e-14
       8 mpg   (16.4,21.4] am    FALSE overlap      13 20.3  1.31e-14
       9 mpg   (21.4,33.9] am    FALSE overlap       7 10.9  1.31e-14
      10 mpg   [10.4,16.4] am    TRUE  overlap       4  6.25 1.31e-14
      # i 300 more rows
      
      
      $`North America`
      $`North America`$d1
      # A tibble: 44 x 12
         term  x             start_x end_x x_span_pct     n    pct         y   start_y
         <chr> <chr>           <dbl> <dbl>      <dbl> <int>  <dbl>     <dbl>     <dbl>
       1 mpg   <NA>             10.4  33.9        100    64 100    NA         2.64e-14
       2 vs    FALSE            NA    NA           NA    36  56.2   2.64e-14 NA       
       3 vs    TRUE             NA    NA           NA    28  43.8   2.64e-14 NA       
       4 am    FALSE            NA    NA           NA    38  59.4  -5.57e-10 NA       
       5 am    TRUE             NA    NA           NA    26  40.6   1.57e-10 NA       
       6 model Lincoln Cont~    NA    NA           NA     2   3.12 -1.95e- 1 NA       
       7 model Cadillac Fle~    NA    NA           NA     2   3.12 -3.61e- 1 NA       
       8 model Merc 450SL       NA    NA           NA     2   3.12 -6.95e- 1 NA       
       9 model Merc 450SLC      NA    NA           NA     2   3.12 -5.29e- 1 NA       
      10 model Camaro Z28       NA    NA           NA     2   3.12 -2.87e- 2 NA       
      # i 34 more rows
      # i 3 more variables: end_y <dbl>, trend <dbl>, aler_band <ord>
      
      $`North America`$d2
      # A tibble: 307 x 8
         term1 x1          term2 x2    aler_band     n   pct        y
         <chr> <chr>       <chr> <chr> <ord>     <int> <dbl>    <dbl>
       1 mpg   [10.4,18.7] vs    FALSE overlap      25 39.1  2.64e-14
       2 mpg   (18.7,21.4] vs    FALSE overlap       9 14.1  2.64e-14
       3 mpg   (21.4,33.9] vs    FALSE overlap       2  3.12 2.64e-14
       4 mpg   [10.4,18.7] vs    TRUE  overlap       4  6.25 2.64e-14
       5 mpg   (18.7,21.4] vs    TRUE  overlap       5  7.81 2.64e-14
       6 mpg   (21.4,33.9] vs    TRUE  overlap      19 29.7  2.64e-14
       7 mpg   [10.4,16.4] am    FALSE overlap      18 28.1  2.64e-14
       8 mpg   (16.4,21.4] am    FALSE overlap      13 20.3  2.64e-14
       9 mpg   (21.4,33.9] am    FALSE overlap       7 10.9  2.64e-14
      10 mpg   [10.4,16.4] am    TRUE  overlap       4  6.25 2.64e-14
      # i 297 more rows
      
      

---

    Code
      get(cat_cars_ale, stats = "conf_sig")
    Message
      ! Note that confidence regions are not reliable with fewer than 100 bootstrap iterations or p-values based on fewer than 100 random iterations.
      i There are 2 bootstrap iterations.
      i p-values are based on 100 iterations.
    Output
      $Asia
      $Asia$d1
      # A tibble: 8 x 12
        term  x     start_x end_x x_span_pct     n   pct        y     start_y    end_y
        <chr> <chr>   <dbl> <dbl>      <dbl> <int> <dbl>    <dbl>       <dbl>    <dbl>
      1 gear  three   NA    NA          NA      30 46.9   0.118   NA          NA      
      2 gear  four    NA    NA          NA      24 37.5   0.00198 NA          NA      
      3 gear  five    NA    NA          NA      10 15.6  -0.330   NA          NA      
      4 carb  <NA>     1     1           0      14 21.9  NA        0.00549     5.49e-3
      5 carb  <NA>     2     8          85.7    50 78.1  NA       -0.00190    -1.90e-3
      6 wt    <NA>     1.50  1.50        0       1  1.56 NA        0.0000319   3.19e-5
      7 wt    <NA>     1.94  1.94        0       7 10.9  NA       -0.00000143 -1.43e-6
      8 wt    <NA>     2.46  5.45       75.6    56 87.5  NA       -0.00000906 -9.07e-6
      # i 2 more variables: trend <dbl>, aler_band <ord>
      
      $Asia$d2
      # A tibble: 128 x 8
         term1 x1    term2 x2    aler_band     n   pct         y
         <chr> <chr> <chr> <chr> <ord>     <int> <dbl>     <dbl>
       1 am    FALSE gear  three below        30 46.9  -0.0927  
       2 am    FALSE gear  four  below         8 12.5  -0.191   
       3 am    TRUE  gear  four  overlap      16 25    -0.433   
       4 am    TRUE  gear  five  below        10 15.6  -0.766   
       5 am    FALSE carb  [1,2] above         6  9.38  0.0166  
       6 am    TRUE  carb  [1,2] overlap      15 23.4   0.00816 
       7 am    FALSE carb  [1,2] overlap      12 18.8   0.0134  
       8 am    FALSE carb  (2,4] above         7 10.9   0.0134  
       9 am    TRUE  carb  (2,4] overlap       2  3.12 -0.000226
      10 am    FALSE carb  (2,4] overlap      11 17.2   0.190   
      # i 118 more rows
      
      
      $Europe
      $Europe$d1
      # A tibble: 40 x 12
         term  x      start_x end_x x_span_pct     n   pct       y start_y end_y trend
         <chr> <chr>    <dbl> <dbl>      <dbl> <int> <dbl>   <dbl>   <dbl> <dbl> <dbl>
       1 model Linco~      NA    NA         NA     2  3.12  0.217       NA    NA    NA
       2 model Cadil~      NA    NA         NA     2  3.12  0.268       NA    NA    NA
       3 model Merc ~      NA    NA         NA     2  3.12  0.931       NA    NA    NA
       4 model Merc ~      NA    NA         NA     2  3.12  0.764       NA    NA    NA
       5 model Camar~      NA    NA         NA     2  3.12 -0.0688      NA    NA    NA
       6 model Chrys~      NA    NA         NA     2  3.12  0.0978      NA    NA    NA
       7 model Duste~      NA    NA         NA     2  3.12  0.0978      NA    NA    NA
       8 model Merc ~      NA    NA         NA     2  3.12  0.596       NA    NA    NA
       9 model Horne~      NA    NA         NA     2  3.12 -0.237       NA    NA    NA
      10 model AMC J~      NA    NA         NA     2  3.12 -0.0841      NA    NA    NA
      # i 30 more rows
      # i 1 more variable: aler_band <ord>
      
      $Europe$d2
      # A tibble: 133 x 8
         term1 x1    term2 x2         aler_band     n   pct         y
         <chr> <chr> <chr> <chr>      <ord>     <int> <dbl>     <dbl>
       1 am    FALSE carb  [1,2]      overlap      18 28.1  -0.0150  
       2 am    TRUE  carb  [1,2]      below         8 12.5  -0.0166  
       3 am    TRUE  carb  [1,2]      overlap       7 10.9   0.000253
       4 am    FALSE carb  (2,4]      overlap       7 10.9  -0.0134  
       5 am    TRUE  carb  (2,4]      overlap       2  3.12  0.000227
       6 am    FALSE carb  (2,4]      below        11 17.2  -0.190   
       7 am    TRUE  carb  (2,4]      below         5  7.81 -0.454   
       8 am    FALSE carb  (4,8]      below         2  3.12 -0.190   
       9 am    TRUE  carb  (4,8]      below         4  6.25 -0.454   
      10 am    TRUE  wt    [1.5,2.79] below         7 10.9  -0.0338  
      # i 123 more rows
      
      
      $`North America`
      $`North America`$d1
      # A tibble: 37 x 12
         term  x      start_x end_x x_span_pct     n   pct       y start_y end_y trend
         <chr> <chr>    <dbl> <dbl>      <dbl> <int> <dbl>   <dbl>   <dbl> <dbl> <dbl>
       1 model Linco~      NA    NA         NA     2  3.12 -0.195       NA    NA    NA
       2 model Cadil~      NA    NA         NA     2  3.12 -0.361       NA    NA    NA
       3 model Merc ~      NA    NA         NA     2  3.12 -0.695       NA    NA    NA
       4 model Merc ~      NA    NA         NA     2  3.12 -0.529       NA    NA    NA
       5 model Camar~      NA    NA         NA     2  3.12 -0.0287      NA    NA    NA
       6 model Chrys~      NA    NA         NA     2  3.12 -0.362       NA    NA    NA
       7 model Duste~      NA    NA         NA     2  3.12 -0.362       NA    NA    NA
       8 model Merc ~      NA    NA         NA     2  3.12 -0.862       NA    NA    NA
       9 model Horne~      NA    NA         NA     2  3.12 -0.195       NA    NA    NA
      10 model AMC J~      NA    NA         NA     2  3.12 -0.362       NA    NA    NA
      # i 27 more rows
      # i 1 more variable: aler_band <ord>
      
      $`North America`$d2
      # A tibble: 167 x 8
         term1 x1    term2 x2                  aler_band     n   pct       y
         <chr> <chr> <chr> <chr>               <ord>     <int> <dbl>   <dbl>
       1 am    FALSE model Lincoln Continental below         2  3.12 -0.0218
       2 am    FALSE model Cadillac Fleetwood  below         2  3.12 -0.0218
       3 am    FALSE model Merc 450SL          below         2  3.12 -0.0226
       4 am    FALSE model Merc 450SLC         below         2  3.12 -0.0226
       5 am    FALSE model Camaro Z28          below         2  3.12 -0.0226
       6 am    FALSE model Chrysler Imperial   overlap       2  3.12 -0.0226
       7 am    FALSE model Duster 360          overlap       2  3.12 -0.0226
       8 am    FALSE model Merc 450SE          overlap       2  3.12 -0.0230
       9 am    FALSE model Hornet Sportabout   overlap       2  3.12 -0.0230
      10 am    FALSE model AMC Javelin         overlap       2  3.12 -0.0230
      # i 157 more rows
      
      

---

    Code
      ale_plots_to_data(cat_cars_ale_plots)
    Condition
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning:
      Position guide is perpendicular to the intended axis.
      i Did you mean to specify a different guide `position`?
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
      Warning in `regularize.values()`:
      collapsing to unique 'x' values
    Output
      $Asia
      $Asia$d1
      $Asia$d1$mpg
                x            y PANEL group colour      fill linewidth linetype alpha
      1  10.37589 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
      2  14.41394 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
      3  15.20000 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
      4  16.40000 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
      5  18.70000 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
      6  19.84566 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
      7  21.40000 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
      8  22.87332 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
      9  30.10414 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
      10 33.90000 1.197411e-14     1    -1     NA lightgray       0.5        1    NA
         xmin xmax         ymin        ymax
      1  -Inf  Inf 1.197341e-14 1.19744e-14
      2  -Inf  Inf 1.197341e-14 1.19744e-14
      3  -Inf  Inf 1.197341e-14 1.19744e-14
      4  -Inf  Inf 1.197341e-14 1.19744e-14
      5  -Inf  Inf 1.197341e-14 1.19744e-14
      6  -Inf  Inf 1.197341e-14 1.19744e-14
      7  -Inf  Inf 1.197341e-14 1.19744e-14
      8  -Inf  Inf 1.197341e-14 1.19744e-14
      9  -Inf  Inf 1.197341e-14 1.19744e-14
      10 -Inf  Inf 1.197341e-14 1.19744e-14
      
      $Asia$d1$vs
        x            y PANEL group colour      fill linewidth linetype alpha xmin
      1 1 1.197411e-14     1     1     NA lightgray       0.5        1    NA -Inf
      2 2 1.197411e-14     1     2     NA lightgray       0.5        1    NA -Inf
        xmax         ymin        ymax
      1  Inf 1.197341e-14 1.19744e-14
      2  Inf 1.197341e-14 1.19744e-14
      
      $Asia$d1$am
        x           y PANEL group colour      fill linewidth linetype alpha xmin xmax
      1 1 0.006188871     1     1     NA lightgray       0.5        1    NA -Inf  Inf
      2 2 0.015482442     1     2     NA lightgray       0.5        1    NA -Inf  Inf
                ymin        ymax
      1 1.197341e-14 1.19744e-14
      2 1.197341e-14 1.19744e-14
      
      $Asia$d1$model
          x           y PANEL group colour      fill linewidth linetype alpha xmin
      1   1 -0.02256553     1     1     NA lightgray       0.5        1    NA -Inf
      2   2  0.09317291     1     2     NA lightgray       0.5        1    NA -Inf
      3   3 -0.23524785     1     3     NA lightgray       0.5        1    NA -Inf
      4   4 -0.23524785     1     4     NA lightgray       0.5        1    NA -Inf
      5   5  0.09751143     1     5     NA lightgray       0.5        1    NA -Inf
      6   6  0.26417810     1     6     NA lightgray       0.5        1    NA -Inf
      7   7  0.26417810     1     7     NA lightgray       0.5        1    NA -Inf
      8   8  0.26611036     1     8     NA lightgray       0.5        1    NA -Inf
      9   9  0.43273667     1     9     NA lightgray       0.5        1    NA -Inf
      10 10  0.44616466     1    10     NA lightgray       0.5        1    NA -Inf
      11 11  0.44616466     1    11     NA lightgray       0.5        1    NA -Inf
      12 12  0.44616466     1    12     NA lightgray       0.5        1    NA -Inf
      13 13  0.44616466     1    13     NA lightgray       0.5        1    NA -Inf
      14 14  0.77949799     1    14     NA lightgray       0.5        1    NA -Inf
      15 15 -0.22030910     1    15     NA lightgray       0.5        1    NA -Inf
      16 16 -0.05364243     1    16     NA lightgray       0.5        1    NA -Inf
      17 17 -0.05370066     1    17     NA lightgray       0.5        1    NA -Inf
      18 18  0.11220276     1    18     NA lightgray       0.5        1    NA -Inf
      19 19  0.11220281     1    19     NA lightgray       0.5        1    NA -Inf
      20 20  0.14577267     1    20     NA lightgray       0.5        1    NA -Inf
      21 21 -0.02754194     1    21     NA lightgray       0.5        1    NA -Inf
      22 22 -0.36770131     1    22     NA lightgray       0.5        1    NA -Inf
      23 23 -0.03661493     1    23     NA lightgray       0.5        1    NA -Inf
      24 24 -0.69864333     1    24     NA lightgray       0.5        1    NA -Inf
      25 25 -0.69864332     1    25     NA lightgray       0.5        1    NA -Inf
      26 26 -0.69864353     1    26     NA lightgray       0.5        1    NA -Inf
      27 27 -1.02590338     1    27     NA lightgray       0.5        1    NA -Inf
      28 28 -0.52590572     1    28     NA lightgray       0.5        1    NA -Inf
      29 29 -1.02589030     1    29     NA lightgray       0.5        1    NA -Inf
      30 30 -0.85922071     1    30     NA lightgray       0.5        1    NA -Inf
      31 31 -0.52591213     1    31     NA lightgray       0.5        1    NA -Inf
      32 32 -1.02590860     1    32     NA lightgray       0.5        1    NA -Inf
         xmax         ymin        ymax
      1   Inf 1.197341e-14 1.19744e-14
      2   Inf 1.197341e-14 1.19744e-14
      3   Inf 1.197341e-14 1.19744e-14
      4   Inf 1.197341e-14 1.19744e-14
      5   Inf 1.197341e-14 1.19744e-14
      6   Inf 1.197341e-14 1.19744e-14
      7   Inf 1.197341e-14 1.19744e-14
      8   Inf 1.197341e-14 1.19744e-14
      9   Inf 1.197341e-14 1.19744e-14
      10  Inf 1.197341e-14 1.19744e-14
      11  Inf 1.197341e-14 1.19744e-14
      12  Inf 1.197341e-14 1.19744e-14
      13  Inf 1.197341e-14 1.19744e-14
      14  Inf 1.197341e-14 1.19744e-14
      15  Inf 1.197341e-14 1.19744e-14
      16  Inf 1.197341e-14 1.19744e-14
      17  Inf 1.197341e-14 1.19744e-14
      18  Inf 1.197341e-14 1.19744e-14
      19  Inf 1.197341e-14 1.19744e-14
      20  Inf 1.197341e-14 1.19744e-14
      21  Inf 1.197341e-14 1.19744e-14
      22  Inf 1.197341e-14 1.19744e-14
      23  Inf 1.197341e-14 1.19744e-14
      24  Inf 1.197341e-14 1.19744e-14
      25  Inf 1.197341e-14 1.19744e-14
      26  Inf 1.197341e-14 1.19744e-14
      27  Inf 1.197341e-14 1.19744e-14
      28  Inf 1.197341e-14 1.19744e-14
      29  Inf 1.197341e-14 1.19744e-14
      30  Inf 1.197341e-14 1.19744e-14
      31  Inf 1.197341e-14 1.19744e-14
      32  Inf 1.197341e-14 1.19744e-14
      
      $Asia$d1$gear
        x            y PANEL group colour      fill linewidth linetype alpha xmin
      1 1  0.118437865     1     1     NA lightgray       0.5        1    NA -Inf
      2 2  0.001975945     1     2     NA lightgray       0.5        1    NA -Inf
      3 3 -0.330118650     1     3     NA lightgray       0.5        1    NA -Inf
        xmax         ymin        ymax
      1  Inf 1.197341e-14 1.19744e-14
      2  Inf 1.197341e-14 1.19744e-14
      3  Inf 1.197341e-14 1.19744e-14
      
      $Asia$d1$carb
        x            y PANEL group colour      fill linewidth linetype alpha xmin
      1 1  0.005489234     1    -1     NA lightgray       0.5        1    NA -Inf
      2 2 -0.001898356     1    -1     NA lightgray       0.5        1    NA -Inf
      3 3 -0.001898365     1    -1     NA lightgray       0.5        1    NA -Inf
      4 4 -0.001898365     1    -1     NA lightgray       0.5        1    NA -Inf
      5 8 -0.001898365     1    -1     NA lightgray       0.5        1    NA -Inf
        xmax         ymin        ymax
      1  Inf 1.197341e-14 1.19744e-14
      2  Inf 1.197341e-14 1.19744e-14
      3  Inf 1.197341e-14 1.19744e-14
      4  Inf 1.197341e-14 1.19744e-14
      5  Inf 1.197341e-14 1.19744e-14
      
      $Asia$d1$wt
                x             y PANEL group colour      fill linewidth linetype alpha
      1  1.498275  3.193949e-05     1    -1     NA lightgray       0.5        1    NA
      2  1.935000 -1.434368e-06     1    -1     NA lightgray       0.5        1    NA
      3  2.465000 -9.061987e-06     1    -1     NA lightgray       0.5        1    NA
      4  2.790481 -9.072039e-06     1    -1     NA lightgray       0.5        1    NA
      5  3.190000 -9.072039e-06     1    -1     NA lightgray       0.5        1    NA
      6  3.439356 -9.072040e-06     1    -1     NA lightgray       0.5        1    NA
      7  3.520000 -9.072040e-06     1    -1     NA lightgray       0.5        1    NA
      8  3.730000 -9.072040e-06     1    -1     NA lightgray       0.5        1    NA
      9  4.046066 -9.072044e-06     1    -1     NA lightgray       0.5        1    NA
      10 5.453272 -9.072044e-06     1    -1     NA lightgray       0.5        1    NA
         xmin xmax         ymin        ymax
      1  -Inf  Inf 1.197341e-14 1.19744e-14
      2  -Inf  Inf 1.197341e-14 1.19744e-14
      3  -Inf  Inf 1.197341e-14 1.19744e-14
      4  -Inf  Inf 1.197341e-14 1.19744e-14
      5  -Inf  Inf 1.197341e-14 1.19744e-14
      6  -Inf  Inf 1.197341e-14 1.19744e-14
      7  -Inf  Inf 1.197341e-14 1.19744e-14
      8  -Inf  Inf 1.197341e-14 1.19744e-14
      9  -Inf  Inf 1.197341e-14 1.19744e-14
      10 -Inf  Inf 1.197341e-14 1.19744e-14
      
      
      $Asia$d2
      $Asia$d2$`mpg:vs`
            fill  x y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FFBBBB  2 1     1     3  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #FFBBBB  2 1     1     3  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #FFBBBB  2 1     1     3  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFBBBB  3 1     1     5  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      8  #FFBBBB  3 1     1     5  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      9  #FFBBBB  3 1     1     5  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      10 #FFBBBB  4 1     1     7  3.5  4.5  0.5  1.5     NA       0.1        1    NA
      11 #FFBBBB  4 1     1     7  3.5  4.5  0.5  1.5     NA       0.1        1    NA
      12 #FFBBBB  4 1     1     7  3.5  4.5  0.5  1.5     NA       0.1        1    NA
      13 #FFBBBB  5 1     1     9  4.5  5.5  0.5  1.5     NA       0.1        1    NA
      14 #FFBBBB  5 1     1     9  4.5  5.5  0.5  1.5     NA       0.1        1    NA
      15 #FFBBBB  5 1     1     9  4.5  5.5  0.5  1.5     NA       0.1        1    NA
      16 #FFBBBB  6 1     1    11  5.5  6.5  0.5  1.5     NA       0.1        1    NA
      17 #FFBBBB  6 1     1    11  5.5  6.5  0.5  1.5     NA       0.1        1    NA
      18 #FFBBBB  6 1     1    11  5.5  6.5  0.5  1.5     NA       0.1        1    NA
      19 #FFBBBB  7 1     1    13  6.5  7.5  0.5  1.5     NA       0.1        1    NA
      20 #FFBBBB  7 1     1    13  6.5  7.5  0.5  1.5     NA       0.1        1    NA
      21 #FFBBBB  7 1     1    13  6.5  7.5  0.5  1.5     NA       0.1        1    NA
      22 #FFBBBB  8 1     1    15  7.5  8.5  0.5  1.5     NA       0.1        1    NA
      23 #FFBBBB  8 1     1    15  7.5  8.5  0.5  1.5     NA       0.1        1    NA
      24 #FFBBBB  8 1     1    15  7.5  8.5  0.5  1.5     NA       0.1        1    NA
      25 #FFBBBB  9 1     1    17  8.5  9.5  0.5  1.5     NA       0.1        1    NA
      26 #FFBBBB  9 1     1    17  8.5  9.5  0.5  1.5     NA       0.1        1    NA
      27 #FFBBBB  9 1     1    17  8.5  9.5  0.5  1.5     NA       0.1        1    NA
      28 #FFBBBB 10 1     1    19  9.5 10.5  0.5  1.5     NA       0.1        1    NA
      29 #FFBBBB 10 1     1    19  9.5 10.5  0.5  1.5     NA       0.1        1    NA
      30 #FFBBBB 10 1     1    19  9.5 10.5  0.5  1.5     NA       0.1        1    NA
      31 #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      32 #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      33 #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      34 #FFBBBB  2 2     1     4  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      35 #FFBBBB  2 2     1     4  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      36 #FFBBBB  2 2     1     4  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      37 #FFBBBB  3 2     1     6  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      38 #FFBBBB  3 2     1     6  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      39 #FFBBBB  3 2     1     6  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      40 #FFBBBB  4 2     1     8  3.5  4.5  1.5  2.5     NA       0.1        1    NA
      41 #FFBBBB  4 2     1     8  3.5  4.5  1.5  2.5     NA       0.1        1    NA
      42 #FFBBBB  4 2     1     8  3.5  4.5  1.5  2.5     NA       0.1        1    NA
      43 #FFBBBB  5 2     1    10  4.5  5.5  1.5  2.5     NA       0.1        1    NA
      44 #FFBBBB  5 2     1    10  4.5  5.5  1.5  2.5     NA       0.1        1    NA
      45 #FFBBBB  5 2     1    10  4.5  5.5  1.5  2.5     NA       0.1        1    NA
      46 #FFBBBB  6 2     1    12  5.5  6.5  1.5  2.5     NA       0.1        1    NA
      47 #FFBBBB  6 2     1    12  5.5  6.5  1.5  2.5     NA       0.1        1    NA
      48 #FFBBBB  6 2     1    12  5.5  6.5  1.5  2.5     NA       0.1        1    NA
      49 #FFBBBB  7 2     1    14  6.5  7.5  1.5  2.5     NA       0.1        1    NA
      50 #FFBBBB  7 2     1    14  6.5  7.5  1.5  2.5     NA       0.1        1    NA
      51 #FFBBBB  7 2     1    14  6.5  7.5  1.5  2.5     NA       0.1        1    NA
      52 #FFBBBB  8 2     1    16  7.5  8.5  1.5  2.5     NA       0.1        1    NA
      53 #FFBBBB  8 2     1    16  7.5  8.5  1.5  2.5     NA       0.1        1    NA
      54 #FFBBBB  8 2     1    16  7.5  8.5  1.5  2.5     NA       0.1        1    NA
      55 #FFBBBB  9 2     1    18  8.5  9.5  1.5  2.5     NA       0.1        1    NA
      56 #FFBBBB  9 2     1    18  8.5  9.5  1.5  2.5     NA       0.1        1    NA
      57 #FFBBBB  9 2     1    18  8.5  9.5  1.5  2.5     NA       0.1        1    NA
      58 #FFBBBB 10 2     1    20  9.5 10.5  1.5  2.5     NA       0.1        1    NA
      59 #FFBBBB 10 2     1    20  9.5 10.5  1.5  2.5     NA       0.1        1    NA
      60 #FFBBBB 10 2     1    20  9.5 10.5  1.5  2.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      19    NA     NA
      20    NA     NA
      21    NA     NA
      22    NA     NA
      23    NA     NA
      24    NA     NA
      25    NA     NA
      26    NA     NA
      27    NA     NA
      28    NA     NA
      29    NA     NA
      30    NA     NA
      31    NA     NA
      32    NA     NA
      33    NA     NA
      34    NA     NA
      35    NA     NA
      36    NA     NA
      37    NA     NA
      38    NA     NA
      39    NA     NA
      40    NA     NA
      41    NA     NA
      42    NA     NA
      43    NA     NA
      44    NA     NA
      45    NA     NA
      46    NA     NA
      47    NA     NA
      48    NA     NA
      49    NA     NA
      50    NA     NA
      51    NA     NA
      52    NA     NA
      53    NA     NA
      54    NA     NA
      55    NA     NA
      56    NA     NA
      57    NA     NA
      58    NA     NA
      59    NA     NA
      60    NA     NA
      
      $Asia$d2$`mpg:am`
            fill  x y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FFBBBB  2 1     1     3  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #FFBBBB  2 1     1     3  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #FFBBBB  2 1     1     3  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFBBBB  3 1     1     5  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      8  #FFBBBB  3 1     1     5  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      9  #FFBBBB  3 1     1     5  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      10 #FFBBBB  4 1     1     7  3.5  4.5  0.5  1.5     NA       0.1        1    NA
      11 #FFBBBB  4 1     1     7  3.5  4.5  0.5  1.5     NA       0.1        1    NA
      12 #FFBBBB  4 1     1     7  3.5  4.5  0.5  1.5     NA       0.1        1    NA
      13 #FFBBBB  5 1     1     9  4.5  5.5  0.5  1.5     NA       0.1        1    NA
      14 #FFBBBB  5 1     1     9  4.5  5.5  0.5  1.5     NA       0.1        1    NA
      15 #FFBBBB  5 1     1     9  4.5  5.5  0.5  1.5     NA       0.1        1    NA
      16 #FFBBBB  6 1     1    11  5.5  6.5  0.5  1.5     NA       0.1        1    NA
      17 #FFBBBB  6 1     1    11  5.5  6.5  0.5  1.5     NA       0.1        1    NA
      18 #FFBBBB  6 1     1    11  5.5  6.5  0.5  1.5     NA       0.1        1    NA
      19 #FFBBBB  7 1     1    13  6.5  7.5  0.5  1.5     NA       0.1        1    NA
      20 #FFBBBB  7 1     1    13  6.5  7.5  0.5  1.5     NA       0.1        1    NA
      21 #FFBBBB  7 1     1    13  6.5  7.5  0.5  1.5     NA       0.1        1    NA
      22 #FFBBBB  8 1     1    15  7.5  8.5  0.5  1.5     NA       0.1        1    NA
      23 #FFBBBB  8 1     1    15  7.5  8.5  0.5  1.5     NA       0.1        1    NA
      24 #FFBBBB  8 1     1    15  7.5  8.5  0.5  1.5     NA       0.1        1    NA
      25 #FFBBBB  9 1     1    17  8.5  9.5  0.5  1.5     NA       0.1        1    NA
      26 #FFBBBB  9 1     1    17  8.5  9.5  0.5  1.5     NA       0.1        1    NA
      27 #FFBBBB  9 1     1    17  8.5  9.5  0.5  1.5     NA       0.1        1    NA
      28 #FFBBBB 10 1     1    19  9.5 10.5  0.5  1.5     NA       0.1        1    NA
      29 #FFBBBB 10 1     1    19  9.5 10.5  0.5  1.5     NA       0.1        1    NA
      30 #FFBBBB 10 1     1    19  9.5 10.5  0.5  1.5     NA       0.1        1    NA
      31 #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      32 #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      33 #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      34 #FFBBBB  2 2     1     4  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      35 #FFBBBB  2 2     1     4  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      36 #FFBBBB  2 2     1     4  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      37 #FFBBBB  3 2     1     6  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      38 #FFBBBB  3 2     1     6  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      39 #FFBBBB  3 2     1     6  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      40 #FFBBBB  4 2     1     8  3.5  4.5  1.5  2.5     NA       0.1        1    NA
      41 #FFBBBB  4 2     1     8  3.5  4.5  1.5  2.5     NA       0.1        1    NA
      42 #FFBBBB  4 2     1     8  3.5  4.5  1.5  2.5     NA       0.1        1    NA
      43 #FFBBBB  5 2     1    10  4.5  5.5  1.5  2.5     NA       0.1        1    NA
      44 #FFBBBB  5 2     1    10  4.5  5.5  1.5  2.5     NA       0.1        1    NA
      45 #FFBBBB  5 2     1    10  4.5  5.5  1.5  2.5     NA       0.1        1    NA
      46 #FFBBBB  6 2     1    12  5.5  6.5  1.5  2.5     NA       0.1        1    NA
      47 #FFBBBB  6 2     1    12  5.5  6.5  1.5  2.5     NA       0.1        1    NA
      48 #FFBBBB  6 2     1    12  5.5  6.5  1.5  2.5     NA       0.1        1    NA
      49 #FFBBBB  7 2     1    14  6.5  7.5  1.5  2.5     NA       0.1        1    NA
      50 #FFBBBB  7 2     1    14  6.5  7.5  1.5  2.5     NA       0.1        1    NA
      51 #FFBBBB  7 2     1    14  6.5  7.5  1.5  2.5     NA       0.1        1    NA
      52 #FFBBBB  8 2     1    16  7.5  8.5  1.5  2.5     NA       0.1        1    NA
      53 #FFBBBB  8 2     1    16  7.5  8.5  1.5  2.5     NA       0.1        1    NA
      54 #FFBBBB  8 2     1    16  7.5  8.5  1.5  2.5     NA       0.1        1    NA
      55 #FFBBBB  9 2     1    18  8.5  9.5  1.5  2.5     NA       0.1        1    NA
      56 #FFBBBB  9 2     1    18  8.5  9.5  1.5  2.5     NA       0.1        1    NA
      57 #FFBBBB  9 2     1    18  8.5  9.5  1.5  2.5     NA       0.1        1    NA
      58 #FFBBBB 10 2     1    20  9.5 10.5  1.5  2.5     NA       0.1        1    NA
      59 #FFBBBB 10 2     1    20  9.5 10.5  1.5  2.5     NA       0.1        1    NA
      60 #FFBBBB 10 2     1    20  9.5 10.5  1.5  2.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      19    NA     NA
      20    NA     NA
      21    NA     NA
      22    NA     NA
      23    NA     NA
      24    NA     NA
      25    NA     NA
      26    NA     NA
      27    NA     NA
      28    NA     NA
      29    NA     NA
      30    NA     NA
      31    NA     NA
      32    NA     NA
      33    NA     NA
      34    NA     NA
      35    NA     NA
      36    NA     NA
      37    NA     NA
      38    NA     NA
      39    NA     NA
      40    NA     NA
      41    NA     NA
      42    NA     NA
      43    NA     NA
      44    NA     NA
      45    NA     NA
      46    NA     NA
      47    NA     NA
      48    NA     NA
      49    NA     NA
      50    NA     NA
      51    NA     NA
      52    NA     NA
      53    NA     NA
      54    NA     NA
      55    NA     NA
      56    NA     NA
      57    NA     NA
      58    NA     NA
      59    NA     NA
      60    NA     NA
      
      $Asia$d2$`mpg:model`
             fill  x  y PANEL group xmin xmax ymin ymax colour linewidth linetype
      1   #FFBBBB  1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      2   #FFBBBB  1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      3   #FFBBBB  1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      4   #FFBBBB  2  1     1    33  1.5  2.5  0.5  1.5     NA       0.1        1
      5   #FFBBBB  2  1     1    33  1.5  2.5  0.5  1.5     NA       0.1        1
      6   #FFBBBB  2  1     1    33  1.5  2.5  0.5  1.5     NA       0.1        1
      7   #FFBBBB  3  1     1    65  2.5  3.5  0.5  1.5     NA       0.1        1
      8   #FFBBBB  3  1     1    65  2.5  3.5  0.5  1.5     NA       0.1        1
      9   #FFBBBB  3  1     1    65  2.5  3.5  0.5  1.5     NA       0.1        1
      10  #FFBBBB  4  1     1    97  3.5  4.5  0.5  1.5     NA       0.1        1
      11  #FFBBBB  4  1     1    97  3.5  4.5  0.5  1.5     NA       0.1        1
      12  #FFBBBB  4  1     1    97  3.5  4.5  0.5  1.5     NA       0.1        1
      13  #FFBBBB  5  1     1   129  4.5  5.5  0.5  1.5     NA       0.1        1
      14  #FFBBBB  5  1     1   129  4.5  5.5  0.5  1.5     NA       0.1        1
      15  #FFBBBB  5  1     1   129  4.5  5.5  0.5  1.5     NA       0.1        1
      16  #FFBBBB  6  1     1   161  5.5  6.5  0.5  1.5     NA       0.1        1
      17  #FFBBBB  6  1     1   161  5.5  6.5  0.5  1.5     NA       0.1        1
      18  #FFBBBB  6  1     1   161  5.5  6.5  0.5  1.5     NA       0.1        1
      19  #FFBBBB  7  1     1   193  6.5  7.5  0.5  1.5     NA       0.1        1
      20  #FFBBBB  7  1     1   193  6.5  7.5  0.5  1.5     NA       0.1        1
      21  #FFBBBB  7  1     1   193  6.5  7.5  0.5  1.5     NA       0.1        1
      22  #FFBBBB  8  1     1   225  7.5  8.5  0.5  1.5     NA       0.1        1
      23  #FFBBBB  8  1     1   225  7.5  8.5  0.5  1.5     NA       0.1        1
      24  #FFBBBB  8  1     1   225  7.5  8.5  0.5  1.5     NA       0.1        1
      25  #FFBBBB  9  1     1   257  8.5  9.5  0.5  1.5     NA       0.1        1
      26  #FFBBBB  9  1     1   257  8.5  9.5  0.5  1.5     NA       0.1        1
      27  #FFBBBB  9  1     1   257  8.5  9.5  0.5  1.5     NA       0.1        1
      28  #FFBBBB 10  1     1   289  9.5 10.5  0.5  1.5     NA       0.1        1
      29  #FFBBBB 10  1     1   289  9.5 10.5  0.5  1.5     NA       0.1        1
      30  #FFBBBB 10  1     1   289  9.5 10.5  0.5  1.5     NA       0.1        1
      31  #FFBBBB  1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      32  #FFBBBB  1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      33  #FFBBBB  1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      34  #FFBBBB  2  2     1    34  1.5  2.5  1.5  2.5     NA       0.1        1
      35  #FFBBBB  2  2     1    34  1.5  2.5  1.5  2.5     NA       0.1        1
      36  #FFBBBB  2  2     1    34  1.5  2.5  1.5  2.5     NA       0.1        1
      37  #FFBBBB  3  2     1    66  2.5  3.5  1.5  2.5     NA       0.1        1
      38  #FFBBBB  3  2     1    66  2.5  3.5  1.5  2.5     NA       0.1        1
      39  #FFBBBB  3  2     1    66  2.5  3.5  1.5  2.5     NA       0.1        1
      40  #FFBBBB  4  2     1    98  3.5  4.5  1.5  2.5     NA       0.1        1
      41  #FFBBBB  4  2     1    98  3.5  4.5  1.5  2.5     NA       0.1        1
      42  #FFBBBB  4  2     1    98  3.5  4.5  1.5  2.5     NA       0.1        1
      43  #FFBBBB  5  2     1   130  4.5  5.5  1.5  2.5     NA       0.1        1
      44  #FFBBBB  5  2     1   130  4.5  5.5  1.5  2.5     NA       0.1        1
      45  #FFBBBB  5  2     1   130  4.5  5.5  1.5  2.5     NA       0.1        1
      46  #FFBBBB  6  2     1   162  5.5  6.5  1.5  2.5     NA       0.1        1
      47  #FFBBBB  6  2     1   162  5.5  6.5  1.5  2.5     NA       0.1        1
      48  #FFBBBB  6  2     1   162  5.5  6.5  1.5  2.5     NA       0.1        1
      49  #FFBBBB  7  2     1   194  6.5  7.5  1.5  2.5     NA       0.1        1
      50  #FFBBBB  7  2     1   194  6.5  7.5  1.5  2.5     NA       0.1        1
      51  #FFBBBB  7  2     1   194  6.5  7.5  1.5  2.5     NA       0.1        1
      52  #FFBBBB  8  2     1   226  7.5  8.5  1.5  2.5     NA       0.1        1
      53  #FFBBBB  8  2     1   226  7.5  8.5  1.5  2.5     NA       0.1        1
      54  #FFBBBB  8  2     1   226  7.5  8.5  1.5  2.5     NA       0.1        1
      55  #FFBBBB  9  2     1   258  8.5  9.5  1.5  2.5     NA       0.1        1
      56  #FFBBBB  9  2     1   258  8.5  9.5  1.5  2.5     NA       0.1        1
      57  #FFBBBB  9  2     1   258  8.5  9.5  1.5  2.5     NA       0.1        1
      58  #FFBBBB 10  2     1   290  9.5 10.5  1.5  2.5     NA       0.1        1
      59  #FFBBBB 10  2     1   290  9.5 10.5  1.5  2.5     NA       0.1        1
      60  #FFBBBB 10  2     1   290  9.5 10.5  1.5  2.5     NA       0.1        1
      61  #FFBBBB  1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      62  #FFBBBB  1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      63  #FFBBBB  1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      64  #FFBBBB  2  3     1    35  1.5  2.5  2.5  3.5     NA       0.1        1
      65  #FFBBBB  2  3     1    35  1.5  2.5  2.5  3.5     NA       0.1        1
      66  #FFBBBB  2  3     1    35  1.5  2.5  2.5  3.5     NA       0.1        1
      67  #FFBBBB  3  3     1    67  2.5  3.5  2.5  3.5     NA       0.1        1
      68  #FFBBBB  3  3     1    67  2.5  3.5  2.5  3.5     NA       0.1        1
      69  #FFBBBB  3  3     1    67  2.5  3.5  2.5  3.5     NA       0.1        1
      70  #FFBBBB  4  3     1    99  3.5  4.5  2.5  3.5     NA       0.1        1
      71  #FFBBBB  4  3     1    99  3.5  4.5  2.5  3.5     NA       0.1        1
      72  #FFBBBB  4  3     1    99  3.5  4.5  2.5  3.5     NA       0.1        1
      73  #FFBBBB  5  3     1   131  4.5  5.5  2.5  3.5     NA       0.1        1
      74  #FFBBBB  5  3     1   131  4.5  5.5  2.5  3.5     NA       0.1        1
      75  #FFBBBB  5  3     1   131  4.5  5.5  2.5  3.5     NA       0.1        1
      76  #FFBBBB  6  3     1   163  5.5  6.5  2.5  3.5     NA       0.1        1
      77  #FFBBBB  6  3     1   163  5.5  6.5  2.5  3.5     NA       0.1        1
      78  #FFBBBB  6  3     1   163  5.5  6.5  2.5  3.5     NA       0.1        1
      79  #FFBBBB  7  3     1   195  6.5  7.5  2.5  3.5     NA       0.1        1
      80  #FFBBBB  7  3     1   195  6.5  7.5  2.5  3.5     NA       0.1        1
      81  #FFBBBB  7  3     1   195  6.5  7.5  2.5  3.5     NA       0.1        1
      82  #FFBBBB  8  3     1   227  7.5  8.5  2.5  3.5     NA       0.1        1
      83  #FFBBBB  8  3     1   227  7.5  8.5  2.5  3.5     NA       0.1        1
      84  #FFBBBB  8  3     1   227  7.5  8.5  2.5  3.5     NA       0.1        1
      85  #FFBBBB  9  3     1   259  8.5  9.5  2.5  3.5     NA       0.1        1
      86  #FFBBBB  9  3     1   259  8.5  9.5  2.5  3.5     NA       0.1        1
      87  #FFBBBB  9  3     1   259  8.5  9.5  2.5  3.5     NA       0.1        1
      88  #FFBBBB 10  3     1   291  9.5 10.5  2.5  3.5     NA       0.1        1
      89  #FFBBBB 10  3     1   291  9.5 10.5  2.5  3.5     NA       0.1        1
      90  #FFBBBB 10  3     1   291  9.5 10.5  2.5  3.5     NA       0.1        1
      91  #FFBBBB  1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      92  #FFBBBB  1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      93  #FFBBBB  1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      94  #FFBBBB  2  4     1    36  1.5  2.5  3.5  4.5     NA       0.1        1
      95  #FFBBBB  2  4     1    36  1.5  2.5  3.5  4.5     NA       0.1        1
      96  #FFBBBB  2  4     1    36  1.5  2.5  3.5  4.5     NA       0.1        1
      97  #FFBBBB  3  4     1    68  2.5  3.5  3.5  4.5     NA       0.1        1
      98  #FFBBBB  3  4     1    68  2.5  3.5  3.5  4.5     NA       0.1        1
      99  #FFBBBB  3  4     1    68  2.5  3.5  3.5  4.5     NA       0.1        1
      100 #FFBBBB  4  4     1   100  3.5  4.5  3.5  4.5     NA       0.1        1
      101 #FFBBBB  4  4     1   100  3.5  4.5  3.5  4.5     NA       0.1        1
      102 #FFBBBB  4  4     1   100  3.5  4.5  3.5  4.5     NA       0.1        1
      103 #FFBBBB  5  4     1   132  4.5  5.5  3.5  4.5     NA       0.1        1
      104 #FFBBBB  5  4     1   132  4.5  5.5  3.5  4.5     NA       0.1        1
      105 #FFBBBB  5  4     1   132  4.5  5.5  3.5  4.5     NA       0.1        1
      106 #FFBBBB  6  4     1   164  5.5  6.5  3.5  4.5     NA       0.1        1
      107 #FFBBBB  6  4     1   164  5.5  6.5  3.5  4.5     NA       0.1        1
      108 #FFBBBB  6  4     1   164  5.5  6.5  3.5  4.5     NA       0.1        1
      109 #FFBBBB  7  4     1   196  6.5  7.5  3.5  4.5     NA       0.1        1
      110 #FFBBBB  7  4     1   196  6.5  7.5  3.5  4.5     NA       0.1        1
      111 #FFBBBB  7  4     1   196  6.5  7.5  3.5  4.5     NA       0.1        1
      112 #FFBBBB  8  4     1   228  7.5  8.5  3.5  4.5     NA       0.1        1
      113 #FFBBBB  8  4     1   228  7.5  8.5  3.5  4.5     NA       0.1        1
      114 #FFBBBB  8  4     1   228  7.5  8.5  3.5  4.5     NA       0.1        1
      115 #FFBBBB  9  4     1   260  8.5  9.5  3.5  4.5     NA       0.1        1
      116 #FFBBBB  9  4     1   260  8.5  9.5  3.5  4.5     NA       0.1        1
      117 #FFBBBB  9  4     1   260  8.5  9.5  3.5  4.5     NA       0.1        1
      118 #FFBBBB 10  4     1   292  9.5 10.5  3.5  4.5     NA       0.1        1
      119 #FFBBBB 10  4     1   292  9.5 10.5  3.5  4.5     NA       0.1        1
      120 #FFBBBB 10  4     1   292  9.5 10.5  3.5  4.5     NA       0.1        1
      121 #FFBBBB  1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      122 #FFBBBB  1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      123 #FFBBBB  1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      124 #FFBBBB  2  5     1    37  1.5  2.5  4.5  5.5     NA       0.1        1
      125 #FFBBBB  2  5     1    37  1.5  2.5  4.5  5.5     NA       0.1        1
      126 #FFBBBB  2  5     1    37  1.5  2.5  4.5  5.5     NA       0.1        1
      127 #FFBBBB  3  5     1    69  2.5  3.5  4.5  5.5     NA       0.1        1
      128 #FFBBBB  3  5     1    69  2.5  3.5  4.5  5.5     NA       0.1        1
      129 #FFBBBB  3  5     1    69  2.5  3.5  4.5  5.5     NA       0.1        1
      130 #FFBBBB  4  5     1   101  3.5  4.5  4.5  5.5     NA       0.1        1
      131 #FFBBBB  4  5     1   101  3.5  4.5  4.5  5.5     NA       0.1        1
      132 #FFBBBB  4  5     1   101  3.5  4.5  4.5  5.5     NA       0.1        1
      133 #FFBBBB  5  5     1   133  4.5  5.5  4.5  5.5     NA       0.1        1
      134 #FFBBBB  5  5     1   133  4.5  5.5  4.5  5.5     NA       0.1        1
      135 #FFBBBB  5  5     1   133  4.5  5.5  4.5  5.5     NA       0.1        1
      136 #FFBBBB  6  5     1   165  5.5  6.5  4.5  5.5     NA       0.1        1
      137 #FFBBBB  6  5     1   165  5.5  6.5  4.5  5.5     NA       0.1        1
      138 #FFBBBB  6  5     1   165  5.5  6.5  4.5  5.5     NA       0.1        1
      139 #FFBBBB  7  5     1   197  6.5  7.5  4.5  5.5     NA       0.1        1
      140 #FFBBBB  7  5     1   197  6.5  7.5  4.5  5.5     NA       0.1        1
      141 #FFBBBB  7  5     1   197  6.5  7.5  4.5  5.5     NA       0.1        1
      142 #FFBBBB  8  5     1   229  7.5  8.5  4.5  5.5     NA       0.1        1
      143 #FFBBBB  8  5     1   229  7.5  8.5  4.5  5.5     NA       0.1        1
      144 #FFBBBB  8  5     1   229  7.5  8.5  4.5  5.5     NA       0.1        1
      145 #FFBBBB  9  5     1   261  8.5  9.5  4.5  5.5     NA       0.1        1
      146 #FFBBBB  9  5     1   261  8.5  9.5  4.5  5.5     NA       0.1        1
      147 #FFBBBB  9  5     1   261  8.5  9.5  4.5  5.5     NA       0.1        1
      148 #FFBBBB 10  5     1   293  9.5 10.5  4.5  5.5     NA       0.1        1
      149 #FFBBBB 10  5     1   293  9.5 10.5  4.5  5.5     NA       0.1        1
      150 #FFBBBB 10  5     1   293  9.5 10.5  4.5  5.5     NA       0.1        1
      151 #FFBBBB  1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      152 #FFBBBB  1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      153 #FFBBBB  1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      154 #FFBBBB  2  6     1    38  1.5  2.5  5.5  6.5     NA       0.1        1
      155 #FFBBBB  2  6     1    38  1.5  2.5  5.5  6.5     NA       0.1        1
      156 #FFBBBB  2  6     1    38  1.5  2.5  5.5  6.5     NA       0.1        1
      157 #FFBBBB  3  6     1    70  2.5  3.5  5.5  6.5     NA       0.1        1
      158 #FFBBBB  3  6     1    70  2.5  3.5  5.5  6.5     NA       0.1        1
      159 #FFBBBB  3  6     1    70  2.5  3.5  5.5  6.5     NA       0.1        1
      160 #FFBBBB  4  6     1   102  3.5  4.5  5.5  6.5     NA       0.1        1
      161 #FFBBBB  4  6     1   102  3.5  4.5  5.5  6.5     NA       0.1        1
      162 #FFBBBB  4  6     1   102  3.5  4.5  5.5  6.5     NA       0.1        1
      163 #FFBBBB  5  6     1   134  4.5  5.5  5.5  6.5     NA       0.1        1
      164 #FFBBBB  5  6     1   134  4.5  5.5  5.5  6.5     NA       0.1        1
      165 #FFBBBB  5  6     1   134  4.5  5.5  5.5  6.5     NA       0.1        1
      166 #FFBBBB  6  6     1   166  5.5  6.5  5.5  6.5     NA       0.1        1
      167 #FFBBBB  6  6     1   166  5.5  6.5  5.5  6.5     NA       0.1        1
      168 #FFBBBB  6  6     1   166  5.5  6.5  5.5  6.5     NA       0.1        1
      169 #FFBBBB  7  6     1   198  6.5  7.5  5.5  6.5     NA       0.1        1
      170 #FFBBBB  7  6     1   198  6.5  7.5  5.5  6.5     NA       0.1        1
      171 #FFBBBB  7  6     1   198  6.5  7.5  5.5  6.5     NA       0.1        1
      172 #FFBBBB  8  6     1   230  7.5  8.5  5.5  6.5     NA       0.1        1
      173 #FFBBBB  8  6     1   230  7.5  8.5  5.5  6.5     NA       0.1        1
      174 #FFBBBB  8  6     1   230  7.5  8.5  5.5  6.5     NA       0.1        1
      175 #FFBBBB  9  6     1   262  8.5  9.5  5.5  6.5     NA       0.1        1
      176 #FFBBBB  9  6     1   262  8.5  9.5  5.5  6.5     NA       0.1        1
      177 #FFBBBB  9  6     1   262  8.5  9.5  5.5  6.5     NA       0.1        1
      178 #FFBBBB 10  6     1   294  9.5 10.5  5.5  6.5     NA       0.1        1
      179 #FFBBBB 10  6     1   294  9.5 10.5  5.5  6.5     NA       0.1        1
      180 #FFBBBB 10  6     1   294  9.5 10.5  5.5  6.5     NA       0.1        1
      181 #FFBBBB  1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      182 #FFBBBB  1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      183 #FFBBBB  1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      184 #FFBBBB  2  7     1    39  1.5  2.5  6.5  7.5     NA       0.1        1
      185 #FFBBBB  2  7     1    39  1.5  2.5  6.5  7.5     NA       0.1        1
      186 #FFBBBB  2  7     1    39  1.5  2.5  6.5  7.5     NA       0.1        1
      187 #FFBBBB  3  7     1    71  2.5  3.5  6.5  7.5     NA       0.1        1
      188 #FFBBBB  3  7     1    71  2.5  3.5  6.5  7.5     NA       0.1        1
      189 #FFBBBB  3  7     1    71  2.5  3.5  6.5  7.5     NA       0.1        1
      190 #FFBBBB  4  7     1   103  3.5  4.5  6.5  7.5     NA       0.1        1
      191 #FFBBBB  4  7     1   103  3.5  4.5  6.5  7.5     NA       0.1        1
      192 #FFBBBB  4  7     1   103  3.5  4.5  6.5  7.5     NA       0.1        1
      193 #FFBBBB  5  7     1   135  4.5  5.5  6.5  7.5     NA       0.1        1
      194 #FFBBBB  5  7     1   135  4.5  5.5  6.5  7.5     NA       0.1        1
      195 #FFBBBB  5  7     1   135  4.5  5.5  6.5  7.5     NA       0.1        1
      196 #FFBBBB  6  7     1   167  5.5  6.5  6.5  7.5     NA       0.1        1
      197 #FFBBBB  6  7     1   167  5.5  6.5  6.5  7.5     NA       0.1        1
      198 #FFBBBB  6  7     1   167  5.5  6.5  6.5  7.5     NA       0.1        1
      199 #FFBBBB  7  7     1   199  6.5  7.5  6.5  7.5     NA       0.1        1
      200 #FFBBBB  7  7     1   199  6.5  7.5  6.5  7.5     NA       0.1        1
      201 #FFBBBB  7  7     1   199  6.5  7.5  6.5  7.5     NA       0.1        1
      202 #FFBBBB  8  7     1   231  7.5  8.5  6.5  7.5     NA       0.1        1
      203 #FFBBBB  8  7     1   231  7.5  8.5  6.5  7.5     NA       0.1        1
      204 #FFBBBB  8  7     1   231  7.5  8.5  6.5  7.5     NA       0.1        1
      205 #FFBBBB  9  7     1   263  8.5  9.5  6.5  7.5     NA       0.1        1
      206 #FFBBBB  9  7     1   263  8.5  9.5  6.5  7.5     NA       0.1        1
      207 #FFBBBB  9  7     1   263  8.5  9.5  6.5  7.5     NA       0.1        1
      208 #FFBBBB 10  7     1   295  9.5 10.5  6.5  7.5     NA       0.1        1
      209 #FFBBBB 10  7     1   295  9.5 10.5  6.5  7.5     NA       0.1        1
      210 #FFBBBB 10  7     1   295  9.5 10.5  6.5  7.5     NA       0.1        1
      211 #FFBBBB  1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      212 #FFBBBB  1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      213 #FFBBBB  1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      214 #FFBBBB  2  8     1    40  1.5  2.5  7.5  8.5     NA       0.1        1
      215 #FFBBBB  2  8     1    40  1.5  2.5  7.5  8.5     NA       0.1        1
      216 #FFBBBB  2  8     1    40  1.5  2.5  7.5  8.5     NA       0.1        1
      217 #FFBBBB  3  8     1    72  2.5  3.5  7.5  8.5     NA       0.1        1
      218 #FFBBBB  3  8     1    72  2.5  3.5  7.5  8.5     NA       0.1        1
      219 #FFBBBB  3  8     1    72  2.5  3.5  7.5  8.5     NA       0.1        1
      220 #FFBBBB  4  8     1   104  3.5  4.5  7.5  8.5     NA       0.1        1
      221 #FFBBBB  4  8     1   104  3.5  4.5  7.5  8.5     NA       0.1        1
      222 #FFBBBB  4  8     1   104  3.5  4.5  7.5  8.5     NA       0.1        1
      223 #FFBBBB  5  8     1   136  4.5  5.5  7.5  8.5     NA       0.1        1
      224 #FFBBBB  5  8     1   136  4.5  5.5  7.5  8.5     NA       0.1        1
      225 #FFBBBB  5  8     1   136  4.5  5.5  7.5  8.5     NA       0.1        1
      226 #FFBBBB  6  8     1   168  5.5  6.5  7.5  8.5     NA       0.1        1
      227 #FFBBBB  6  8     1   168  5.5  6.5  7.5  8.5     NA       0.1        1
      228 #FFBBBB  6  8     1   168  5.5  6.5  7.5  8.5     NA       0.1        1
      229 #FFBBBB  7  8     1   200  6.5  7.5  7.5  8.5     NA       0.1        1
      230 #FFBBBB  7  8     1   200  6.5  7.5  7.5  8.5     NA       0.1        1
      231 #FFBBBB  7  8     1   200  6.5  7.5  7.5  8.5     NA       0.1        1
      232 #FFBBBB  8  8     1   232  7.5  8.5  7.5  8.5     NA       0.1        1
      233 #FFBBBB  8  8     1   232  7.5  8.5  7.5  8.5     NA       0.1        1
      234 #FFBBBB  8  8     1   232  7.5  8.5  7.5  8.5     NA       0.1        1
      235 #FFBBBB  9  8     1   264  8.5  9.5  7.5  8.5     NA       0.1        1
      236 #FFBBBB  9  8     1   264  8.5  9.5  7.5  8.5     NA       0.1        1
      237 #FFBBBB  9  8     1   264  8.5  9.5  7.5  8.5     NA       0.1        1
      238 #FFBBBB 10  8     1   296  9.5 10.5  7.5  8.5     NA       0.1        1
      239 #FFBBBB 10  8     1   296  9.5 10.5  7.5  8.5     NA       0.1        1
      240 #FFBBBB 10  8     1   296  9.5 10.5  7.5  8.5     NA       0.1        1
      241 #FFBBBB  1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      242 #FFBBBB  1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      243 #FFBBBB  1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      244 #FFBBBB  2  9     1    41  1.5  2.5  8.5  9.5     NA       0.1        1
      245 #FFBBBB  2  9     1    41  1.5  2.5  8.5  9.5     NA       0.1        1
      246 #FFBBBB  2  9     1    41  1.5  2.5  8.5  9.5     NA       0.1        1
      247 #FFBBBB  3  9     1    73  2.5  3.5  8.5  9.5     NA       0.1        1
      248 #FFBBBB  3  9     1    73  2.5  3.5  8.5  9.5     NA       0.1        1
      249 #FFBBBB  3  9     1    73  2.5  3.5  8.5  9.5     NA       0.1        1
      250 #FFBBBB  4  9     1   105  3.5  4.5  8.5  9.5     NA       0.1        1
      251 #FFBBBB  4  9     1   105  3.5  4.5  8.5  9.5     NA       0.1        1
      252 #FFBBBB  4  9     1   105  3.5  4.5  8.5  9.5     NA       0.1        1
      253 #FFBBBB  5  9     1   137  4.5  5.5  8.5  9.5     NA       0.1        1
      254 #FFBBBB  5  9     1   137  4.5  5.5  8.5  9.5     NA       0.1        1
      255 #FFBBBB  5  9     1   137  4.5  5.5  8.5  9.5     NA       0.1        1
      256 #FFBBBB  6  9     1   169  5.5  6.5  8.5  9.5     NA       0.1        1
      257 #FFBBBB  6  9     1   169  5.5  6.5  8.5  9.5     NA       0.1        1
      258 #FFBBBB  6  9     1   169  5.5  6.5  8.5  9.5     NA       0.1        1
      259 #FFBBBB  7  9     1   201  6.5  7.5  8.5  9.5     NA       0.1        1
      260 #FFBBBB  7  9     1   201  6.5  7.5  8.5  9.5     NA       0.1        1
      261 #FFBBBB  7  9     1   201  6.5  7.5  8.5  9.5     NA       0.1        1
      262 #FFBBBB  8  9     1   233  7.5  8.5  8.5  9.5     NA       0.1        1
      263 #FFBBBB  8  9     1   233  7.5  8.5  8.5  9.5     NA       0.1        1
      264 #FFBBBB  8  9     1   233  7.5  8.5  8.5  9.5     NA       0.1        1
      265 #FFBBBB  9  9     1   265  8.5  9.5  8.5  9.5     NA       0.1        1
      266 #FFBBBB  9  9     1   265  8.5  9.5  8.5  9.5     NA       0.1        1
      267 #FFBBBB  9  9     1   265  8.5  9.5  8.5  9.5     NA       0.1        1
      268 #FFBBBB 10  9     1   297  9.5 10.5  8.5  9.5     NA       0.1        1
      269 #FFBBBB 10  9     1   297  9.5 10.5  8.5  9.5     NA       0.1        1
      270 #FFBBBB 10  9     1   297  9.5 10.5  8.5  9.5     NA       0.1        1
      271 #FFBBBB  1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      272 #FFBBBB  1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      273 #FFBBBB  1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      274 #FFBBBB  2 10     1    42  1.5  2.5  9.5 10.5     NA       0.1        1
      275 #FFBBBB  2 10     1    42  1.5  2.5  9.5 10.5     NA       0.1        1
      276 #FFBBBB  2 10     1    42  1.5  2.5  9.5 10.5     NA       0.1        1
      277 #FFBBBB  3 10     1    74  2.5  3.5  9.5 10.5     NA       0.1        1
      278 #FFBBBB  3 10     1    74  2.5  3.5  9.5 10.5     NA       0.1        1
      279 #FFBBBB  3 10     1    74  2.5  3.5  9.5 10.5     NA       0.1        1
      280 #FFBBBB  4 10     1   106  3.5  4.5  9.5 10.5     NA       0.1        1
      281 #FFBBBB  4 10     1   106  3.5  4.5  9.5 10.5     NA       0.1        1
      282 #FFBBBB  4 10     1   106  3.5  4.5  9.5 10.5     NA       0.1        1
      283 #FFBBBB  5 10     1   138  4.5  5.5  9.5 10.5     NA       0.1        1
      284 #FFBBBB  5 10     1   138  4.5  5.5  9.5 10.5     NA       0.1        1
      285 #FFBBBB  5 10     1   138  4.5  5.5  9.5 10.5     NA       0.1        1
      286 #FFBBBB  6 10     1   170  5.5  6.5  9.5 10.5     NA       0.1        1
      287 #FFBBBB  6 10     1   170  5.5  6.5  9.5 10.5     NA       0.1        1
      288 #FFBBBB  6 10     1   170  5.5  6.5  9.5 10.5     NA       0.1        1
      289 #FFBBBB  7 10     1   202  6.5  7.5  9.5 10.5     NA       0.1        1
      290 #FFBBBB  7 10     1   202  6.5  7.5  9.5 10.5     NA       0.1        1
      291 #FFBBBB  7 10     1   202  6.5  7.5  9.5 10.5     NA       0.1        1
      292 #FFBBBB  8 10     1   234  7.5  8.5  9.5 10.5     NA       0.1        1
      293 #FFBBBB  8 10     1   234  7.5  8.5  9.5 10.5     NA       0.1        1
      294 #FFBBBB  8 10     1   234  7.5  8.5  9.5 10.5     NA       0.1        1
      295 #FFBBBB  9 10     1   266  8.5  9.5  9.5 10.5     NA       0.1        1
      296 #FFBBBB  9 10     1   266  8.5  9.5  9.5 10.5     NA       0.1        1
      297 #FFBBBB  9 10     1   266  8.5  9.5  9.5 10.5     NA       0.1        1
      298 #FFBBBB 10 10     1   298  9.5 10.5  9.5 10.5     NA       0.1        1
      299 #FFBBBB 10 10     1   298  9.5 10.5  9.5 10.5     NA       0.1        1
      300 #FFBBBB 10 10     1   298  9.5 10.5  9.5 10.5     NA       0.1        1
      301 #FFBBBB  1 11     1    11  0.5  1.5 10.5 11.5     NA       0.1        1
      302 #FFBBBB  1 11     1    11  0.5  1.5 10.5 11.5     NA       0.1        1
      303 #FFBBBB  1 11     1    11  0.5  1.5 10.5 11.5     NA       0.1        1
      304 #FFBBBB  2 11     1    43  1.5  2.5 10.5 11.5     NA       0.1        1
      305 #FFBBBB  2 11     1    43  1.5  2.5 10.5 11.5     NA       0.1        1
      306 #FFBBBB  2 11     1    43  1.5  2.5 10.5 11.5     NA       0.1        1
      307 #FFBBBB  3 11     1    75  2.5  3.5 10.5 11.5     NA       0.1        1
      308 #FFBBBB  3 11     1    75  2.5  3.5 10.5 11.5     NA       0.1        1
      309 #FFBBBB  3 11     1    75  2.5  3.5 10.5 11.5     NA       0.1        1
      310 #FFBBBB  4 11     1   107  3.5  4.5 10.5 11.5     NA       0.1        1
      311 #FFBBBB  4 11     1   107  3.5  4.5 10.5 11.5     NA       0.1        1
      312 #FFBBBB  4 11     1   107  3.5  4.5 10.5 11.5     NA       0.1        1
      313 #FFBBBB  5 11     1   139  4.5  5.5 10.5 11.5     NA       0.1        1
      314 #FFBBBB  5 11     1   139  4.5  5.5 10.5 11.5     NA       0.1        1
      315 #FFBBBB  5 11     1   139  4.5  5.5 10.5 11.5     NA       0.1        1
      316 #FFBBBB  6 11     1   171  5.5  6.5 10.5 11.5     NA       0.1        1
      317 #FFBBBB  6 11     1   171  5.5  6.5 10.5 11.5     NA       0.1        1
      318 #FFBBBB  6 11     1   171  5.5  6.5 10.5 11.5     NA       0.1        1
      319 #FFBBBB  7 11     1   203  6.5  7.5 10.5 11.5     NA       0.1        1
      320 #FFBBBB  7 11     1   203  6.5  7.5 10.5 11.5     NA       0.1        1
      321 #FFBBBB  7 11     1   203  6.5  7.5 10.5 11.5     NA       0.1        1
      322 #FFBBBB  8 11     1   235  7.5  8.5 10.5 11.5     NA       0.1        1
      323 #FFBBBB  8 11     1   235  7.5  8.5 10.5 11.5     NA       0.1        1
      324 #FFBBBB  8 11     1   235  7.5  8.5 10.5 11.5     NA       0.1        1
      325 #FFBBBB  9 11     1   267  8.5  9.5 10.5 11.5     NA       0.1        1
      326 #FFBBBB  9 11     1   267  8.5  9.5 10.5 11.5     NA       0.1        1
      327 #FFBBBB  9 11     1   267  8.5  9.5 10.5 11.5     NA       0.1        1
      328 #FFBBBB 10 11     1   299  9.5 10.5 10.5 11.5     NA       0.1        1
      329 #FFBBBB 10 11     1   299  9.5 10.5 10.5 11.5     NA       0.1        1
      330 #FFBBBB 10 11     1   299  9.5 10.5 10.5 11.5     NA       0.1        1
      331 #FFBBBB  1 12     1    12  0.5  1.5 11.5 12.5     NA       0.1        1
      332 #FFBBBB  1 12     1    12  0.5  1.5 11.5 12.5     NA       0.1        1
      333 #FFBBBB  1 12     1    12  0.5  1.5 11.5 12.5     NA       0.1        1
      334 #FFBBBB  2 12     1    44  1.5  2.5 11.5 12.5     NA       0.1        1
      335 #FFBBBB  2 12     1    44  1.5  2.5 11.5 12.5     NA       0.1        1
      336 #FFBBBB  2 12     1    44  1.5  2.5 11.5 12.5     NA       0.1        1
      337 #FFBBBB  3 12     1    76  2.5  3.5 11.5 12.5     NA       0.1        1
      338 #FFBBBB  3 12     1    76  2.5  3.5 11.5 12.5     NA       0.1        1
      339 #FFBBBB  3 12     1    76  2.5  3.5 11.5 12.5     NA       0.1        1
      340 #FFBBBB  4 12     1   108  3.5  4.5 11.5 12.5     NA       0.1        1
      341 #FFBBBB  4 12     1   108  3.5  4.5 11.5 12.5     NA       0.1        1
      342 #FFBBBB  4 12     1   108  3.5  4.5 11.5 12.5     NA       0.1        1
      343 #FFBBBB  5 12     1   140  4.5  5.5 11.5 12.5     NA       0.1        1
      344 #FFBBBB  5 12     1   140  4.5  5.5 11.5 12.5     NA       0.1        1
      345 #FFBBBB  5 12     1   140  4.5  5.5 11.5 12.5     NA       0.1        1
      346 #FFBBBB  6 12     1   172  5.5  6.5 11.5 12.5     NA       0.1        1
      347 #FFBBBB  6 12     1   172  5.5  6.5 11.5 12.5     NA       0.1        1
      348 #FFBBBB  6 12     1   172  5.5  6.5 11.5 12.5     NA       0.1        1
      349 #FFBBBB  7 12     1   204  6.5  7.5 11.5 12.5     NA       0.1        1
      350 #FFBBBB  7 12     1   204  6.5  7.5 11.5 12.5     NA       0.1        1
      351 #FFBBBB  7 12     1   204  6.5  7.5 11.5 12.5     NA       0.1        1
      352 #FFBBBB  8 12     1   236  7.5  8.5 11.5 12.5     NA       0.1        1
      353 #FFBBBB  8 12     1   236  7.5  8.5 11.5 12.5     NA       0.1        1
      354 #FFBBBB  8 12     1   236  7.5  8.5 11.5 12.5     NA       0.1        1
      355 #FFBBBB  9 12     1   268  8.5  9.5 11.5 12.5     NA       0.1        1
      356 #FFBBBB  9 12     1   268  8.5  9.5 11.5 12.5     NA       0.1        1
      357 #FFBBBB  9 12     1   268  8.5  9.5 11.5 12.5     NA       0.1        1
      358 #FFBBBB 10 12     1   300  9.5 10.5 11.5 12.5     NA       0.1        1
      359 #FFBBBB 10 12     1   300  9.5 10.5 11.5 12.5     NA       0.1        1
      360 #FFBBBB 10 12     1   300  9.5 10.5 11.5 12.5     NA       0.1        1
      361 #FFBBBB  1 13     1    13  0.5  1.5 12.5 13.5     NA       0.1        1
      362 #FFBBBB  1 13     1    13  0.5  1.5 12.5 13.5     NA       0.1        1
      363 #FFBBBB  1 13     1    13  0.5  1.5 12.5 13.5     NA       0.1        1
      364 #FFBBBB  2 13     1    45  1.5  2.5 12.5 13.5     NA       0.1        1
      365 #FFBBBB  2 13     1    45  1.5  2.5 12.5 13.5     NA       0.1        1
      366 #FFBBBB  2 13     1    45  1.5  2.5 12.5 13.5     NA       0.1        1
      367 #FFBBBB  3 13     1    77  2.5  3.5 12.5 13.5     NA       0.1        1
      368 #FFBBBB  3 13     1    77  2.5  3.5 12.5 13.5     NA       0.1        1
      369 #FFBBBB  3 13     1    77  2.5  3.5 12.5 13.5     NA       0.1        1
      370 #FFBBBB  4 13     1   109  3.5  4.5 12.5 13.5     NA       0.1        1
      371 #FFBBBB  4 13     1   109  3.5  4.5 12.5 13.5     NA       0.1        1
      372 #FFBBBB  4 13     1   109  3.5  4.5 12.5 13.5     NA       0.1        1
      373 #FFBBBB  5 13     1   141  4.5  5.5 12.5 13.5     NA       0.1        1
      374 #FFBBBB  5 13     1   141  4.5  5.5 12.5 13.5     NA       0.1        1
      375 #FFBBBB  5 13     1   141  4.5  5.5 12.5 13.5     NA       0.1        1
      376 #FFBBBB  6 13     1   173  5.5  6.5 12.5 13.5     NA       0.1        1
      377 #FFBBBB  6 13     1   173  5.5  6.5 12.5 13.5     NA       0.1        1
      378 #FFBBBB  6 13     1   173  5.5  6.5 12.5 13.5     NA       0.1        1
      379 #FFBBBB  7 13     1   205  6.5  7.5 12.5 13.5     NA       0.1        1
      380 #FFBBBB  7 13     1   205  6.5  7.5 12.5 13.5     NA       0.1        1
      381 #FFBBBB  7 13     1   205  6.5  7.5 12.5 13.5     NA       0.1        1
      382 #FFBBBB  8 13     1   237  7.5  8.5 12.5 13.5     NA       0.1        1
      383 #FFBBBB  8 13     1   237  7.5  8.5 12.5 13.5     NA       0.1        1
      384 #FFBBBB  8 13     1   237  7.5  8.5 12.5 13.5     NA       0.1        1
      385 #FFBBBB  9 13     1   269  8.5  9.5 12.5 13.5     NA       0.1        1
      386 #FFBBBB  9 13     1   269  8.5  9.5 12.5 13.5     NA       0.1        1
      387 #FFBBBB  9 13     1   269  8.5  9.5 12.5 13.5     NA       0.1        1
      388 #FFBBBB 10 13     1   301  9.5 10.5 12.5 13.5     NA       0.1        1
      389 #FFBBBB 10 13     1   301  9.5 10.5 12.5 13.5     NA       0.1        1
      390 #FFBBBB 10 13     1   301  9.5 10.5 12.5 13.5     NA       0.1        1
      391 #FFBBBB  1 14     1    14  0.5  1.5 13.5 14.5     NA       0.1        1
      392 #FFBBBB  1 14     1    14  0.5  1.5 13.5 14.5     NA       0.1        1
      393 #FFBBBB  1 14     1    14  0.5  1.5 13.5 14.5     NA       0.1        1
      394 #FFBBBB  2 14     1    46  1.5  2.5 13.5 14.5     NA       0.1        1
      395 #FFBBBB  2 14     1    46  1.5  2.5 13.5 14.5     NA       0.1        1
      396 #FFBBBB  2 14     1    46  1.5  2.5 13.5 14.5     NA       0.1        1
      397 #FFBBBB  3 14     1    78  2.5  3.5 13.5 14.5     NA       0.1        1
      398 #FFBBBB  3 14     1    78  2.5  3.5 13.5 14.5     NA       0.1        1
      399 #FFBBBB  3 14     1    78  2.5  3.5 13.5 14.5     NA       0.1        1
      400 #FFBBBB  4 14     1   110  3.5  4.5 13.5 14.5     NA       0.1        1
      401 #FFBBBB  4 14     1   110  3.5  4.5 13.5 14.5     NA       0.1        1
      402 #FFBBBB  4 14     1   110  3.5  4.5 13.5 14.5     NA       0.1        1
      403 #FFBBBB  5 14     1   142  4.5  5.5 13.5 14.5     NA       0.1        1
      404 #FFBBBB  5 14     1   142  4.5  5.5 13.5 14.5     NA       0.1        1
      405 #FFBBBB  5 14     1   142  4.5  5.5 13.5 14.5     NA       0.1        1
      406 #FFBBBB  6 14     1   174  5.5  6.5 13.5 14.5     NA       0.1        1
      407 #FFBBBB  6 14     1   174  5.5  6.5 13.5 14.5     NA       0.1        1
      408 #FFBBBB  6 14     1   174  5.5  6.5 13.5 14.5     NA       0.1        1
      409 #FFBBBB  7 14     1   206  6.5  7.5 13.5 14.5     NA       0.1        1
      410 #FFBBBB  7 14     1   206  6.5  7.5 13.5 14.5     NA       0.1        1
      411 #FFBBBB  7 14     1   206  6.5  7.5 13.5 14.5     NA       0.1        1
      412 #FFBBBB  8 14     1   238  7.5  8.5 13.5 14.5     NA       0.1        1
      413 #FFBBBB  8 14     1   238  7.5  8.5 13.5 14.5     NA       0.1        1
      414 #FFBBBB  8 14     1   238  7.5  8.5 13.5 14.5     NA       0.1        1
      415 #FFBBBB  9 14     1   270  8.5  9.5 13.5 14.5     NA       0.1        1
      416 #FFBBBB  9 14     1   270  8.5  9.5 13.5 14.5     NA       0.1        1
      417 #FFBBBB  9 14     1   270  8.5  9.5 13.5 14.5     NA       0.1        1
      418 #FFBBBB 10 14     1   302  9.5 10.5 13.5 14.5     NA       0.1        1
      419 #FFBBBB 10 14     1   302  9.5 10.5 13.5 14.5     NA       0.1        1
      420 #FFBBBB 10 14     1   302  9.5 10.5 13.5 14.5     NA       0.1        1
      421 #FFBBBB  1 15     1    15  0.5  1.5 14.5 15.5     NA       0.1        1
      422 #FFBBBB  1 15     1    15  0.5  1.5 14.5 15.5     NA       0.1        1
      423 #FFBBBB  1 15     1    15  0.5  1.5 14.5 15.5     NA       0.1        1
      424 #FFBBBB  2 15     1    47  1.5  2.5 14.5 15.5     NA       0.1        1
      425 #FFBBBB  2 15     1    47  1.5  2.5 14.5 15.5     NA       0.1        1
      426 #FFBBBB  2 15     1    47  1.5  2.5 14.5 15.5     NA       0.1        1
      427 #FFBBBB  3 15     1    79  2.5  3.5 14.5 15.5     NA       0.1        1
      428 #FFBBBB  3 15     1    79  2.5  3.5 14.5 15.5     NA       0.1        1
      429 #FFBBBB  3 15     1    79  2.5  3.5 14.5 15.5     NA       0.1        1
      430 #FFBBBB  4 15     1   111  3.5  4.5 14.5 15.5     NA       0.1        1
      431 #FFBBBB  4 15     1   111  3.5  4.5 14.5 15.5     NA       0.1        1
      432 #FFBBBB  4 15     1   111  3.5  4.5 14.5 15.5     NA       0.1        1
      433 #FFBBBB  5 15     1   143  4.5  5.5 14.5 15.5     NA       0.1        1
      434 #FFBBBB  5 15     1   143  4.5  5.5 14.5 15.5     NA       0.1        1
      435 #FFBBBB  5 15     1   143  4.5  5.5 14.5 15.5     NA       0.1        1
      436 #FFBBBB  6 15     1   175  5.5  6.5 14.5 15.5     NA       0.1        1
      437 #FFBBBB  6 15     1   175  5.5  6.5 14.5 15.5     NA       0.1        1
      438 #FFBBBB  6 15     1   175  5.5  6.5 14.5 15.5     NA       0.1        1
      439 #FFBBBB  7 15     1   207  6.5  7.5 14.5 15.5     NA       0.1        1
      440 #FFBBBB  7 15     1   207  6.5  7.5 14.5 15.5     NA       0.1        1
      441 #FFBBBB  7 15     1   207  6.5  7.5 14.5 15.5     NA       0.1        1
      442 #FFBBBB  8 15     1   239  7.5  8.5 14.5 15.5     NA       0.1        1
      443 #FFBBBB  8 15     1   239  7.5  8.5 14.5 15.5     NA       0.1        1
      444 #FFBBBB  8 15     1   239  7.5  8.5 14.5 15.5     NA       0.1        1
      445 #FFBBBB  9 15     1   271  8.5  9.5 14.5 15.5     NA       0.1        1
      446 #FFBBBB  9 15     1   271  8.5  9.5 14.5 15.5     NA       0.1        1
      447 #FFBBBB  9 15     1   271  8.5  9.5 14.5 15.5     NA       0.1        1
      448 #FFBBBB 10 15     1   303  9.5 10.5 14.5 15.5     NA       0.1        1
      449 #FFBBBB 10 15     1   303  9.5 10.5 14.5 15.5     NA       0.1        1
      450 #FFBBBB 10 15     1   303  9.5 10.5 14.5 15.5     NA       0.1        1
      451 #FFBBBB  1 16     1    16  0.5  1.5 15.5 16.5     NA       0.1        1
      452 #FFBBBB  1 16     1    16  0.5  1.5 15.5 16.5     NA       0.1        1
      453 #FFBBBB  1 16     1    16  0.5  1.5 15.5 16.5     NA       0.1        1
      454 #FFBBBB  2 16     1    48  1.5  2.5 15.5 16.5     NA       0.1        1
      455 #FFBBBB  2 16     1    48  1.5  2.5 15.5 16.5     NA       0.1        1
      456 #FFBBBB  2 16     1    48  1.5  2.5 15.5 16.5     NA       0.1        1
      457 #FFBBBB  3 16     1    80  2.5  3.5 15.5 16.5     NA       0.1        1
      458 #FFBBBB  3 16     1    80  2.5  3.5 15.5 16.5     NA       0.1        1
      459 #FFBBBB  3 16     1    80  2.5  3.5 15.5 16.5     NA       0.1        1
      460 #FFBBBB  4 16     1   112  3.5  4.5 15.5 16.5     NA       0.1        1
      461 #FFBBBB  4 16     1   112  3.5  4.5 15.5 16.5     NA       0.1        1
      462 #FFBBBB  4 16     1   112  3.5  4.5 15.5 16.5     NA       0.1        1
      463 #FFBBBB  5 16     1   144  4.5  5.5 15.5 16.5     NA       0.1        1
      464 #FFBBBB  5 16     1   144  4.5  5.5 15.5 16.5     NA       0.1        1
      465 #FFBBBB  5 16     1   144  4.5  5.5 15.5 16.5     NA       0.1        1
      466 #FFBBBB  6 16     1   176  5.5  6.5 15.5 16.5     NA       0.1        1
      467 #FFBBBB  6 16     1   176  5.5  6.5 15.5 16.5     NA       0.1        1
      468 #FFBBBB  6 16     1   176  5.5  6.5 15.5 16.5     NA       0.1        1
      469 #FFBBBB  7 16     1   208  6.5  7.5 15.5 16.5     NA       0.1        1
      470 #FFBBBB  7 16     1   208  6.5  7.5 15.5 16.5     NA       0.1        1
      471 #FFBBBB  7 16     1   208  6.5  7.5 15.5 16.5     NA       0.1        1
      472 #FFBBBB  8 16     1   240  7.5  8.5 15.5 16.5     NA       0.1        1
      473 #FFBBBB  8 16     1   240  7.5  8.5 15.5 16.5     NA       0.1        1
      474 #FFBBBB  8 16     1   240  7.5  8.5 15.5 16.5     NA       0.1        1
      475 #FFBBBB  9 16     1   272  8.5  9.5 15.5 16.5     NA       0.1        1
      476 #FFBBBB  9 16     1   272  8.5  9.5 15.5 16.5     NA       0.1        1
      477 #FFBBBB  9 16     1   272  8.5  9.5 15.5 16.5     NA       0.1        1
      478 #FFBBBB 10 16     1   304  9.5 10.5 15.5 16.5     NA       0.1        1
      479 #FFBBBB 10 16     1   304  9.5 10.5 15.5 16.5     NA       0.1        1
      480 #FFBBBB 10 16     1   304  9.5 10.5 15.5 16.5     NA       0.1        1
      481 #FFBBBB  1 17     1    17  0.5  1.5 16.5 17.5     NA       0.1        1
      482 #FFBBBB  1 17     1    17  0.5  1.5 16.5 17.5     NA       0.1        1
      483 #FFBBBB  1 17     1    17  0.5  1.5 16.5 17.5     NA       0.1        1
      484 #FFBBBB  2 17     1    49  1.5  2.5 16.5 17.5     NA       0.1        1
      485 #FFBBBB  2 17     1    49  1.5  2.5 16.5 17.5     NA       0.1        1
      486 #FFBBBB  2 17     1    49  1.5  2.5 16.5 17.5     NA       0.1        1
      487 #FFBBBB  3 17     1    81  2.5  3.5 16.5 17.5     NA       0.1        1
      488 #FFBBBB  3 17     1    81  2.5  3.5 16.5 17.5     NA       0.1        1
      489 #FFBBBB  3 17     1    81  2.5  3.5 16.5 17.5     NA       0.1        1
      490 #FFBBBB  4 17     1   113  3.5  4.5 16.5 17.5     NA       0.1        1
      491 #FFBBBB  4 17     1   113  3.5  4.5 16.5 17.5     NA       0.1        1
      492 #FFBBBB  4 17     1   113  3.5  4.5 16.5 17.5     NA       0.1        1
      493 #FFBBBB  5 17     1   145  4.5  5.5 16.5 17.5     NA       0.1        1
      494 #FFBBBB  5 17     1   145  4.5  5.5 16.5 17.5     NA       0.1        1
      495 #FFBBBB  5 17     1   145  4.5  5.5 16.5 17.5     NA       0.1        1
      496 #FFBBBB  6 17     1   177  5.5  6.5 16.5 17.5     NA       0.1        1
      497 #FFBBBB  6 17     1   177  5.5  6.5 16.5 17.5     NA       0.1        1
      498 #FFBBBB  6 17     1   177  5.5  6.5 16.5 17.5     NA       0.1        1
      499 #FFBBBB  7 17     1   209  6.5  7.5 16.5 17.5     NA       0.1        1
      500 #FFBBBB  7 17     1   209  6.5  7.5 16.5 17.5     NA       0.1        1
      501 #FFBBBB  7 17     1   209  6.5  7.5 16.5 17.5     NA       0.1        1
      502 #FFBBBB  8 17     1   241  7.5  8.5 16.5 17.5     NA       0.1        1
      503 #FFBBBB  8 17     1   241  7.5  8.5 16.5 17.5     NA       0.1        1
      504 #FFBBBB  8 17     1   241  7.5  8.5 16.5 17.5     NA       0.1        1
      505 #FFBBBB  9 17     1   273  8.5  9.5 16.5 17.5     NA       0.1        1
      506 #FFBBBB  9 17     1   273  8.5  9.5 16.5 17.5     NA       0.1        1
      507 #FFBBBB  9 17     1   273  8.5  9.5 16.5 17.5     NA       0.1        1
      508 #FFBBBB 10 17     1   305  9.5 10.5 16.5 17.5     NA       0.1        1
      509 #FFBBBB 10 17     1   305  9.5 10.5 16.5 17.5     NA       0.1        1
      510 #FFBBBB 10 17     1   305  9.5 10.5 16.5 17.5     NA       0.1        1
      511 #FFBBBB  1 18     1    18  0.5  1.5 17.5 18.5     NA       0.1        1
      512 #FFBBBB  1 18     1    18  0.5  1.5 17.5 18.5     NA       0.1        1
      513 #FFBBBB  1 18     1    18  0.5  1.5 17.5 18.5     NA       0.1        1
      514 #FFBBBB  2 18     1    50  1.5  2.5 17.5 18.5     NA       0.1        1
      515 #FFBBBB  2 18     1    50  1.5  2.5 17.5 18.5     NA       0.1        1
      516 #FFBBBB  2 18     1    50  1.5  2.5 17.5 18.5     NA       0.1        1
      517 #FFBBBB  3 18     1    82  2.5  3.5 17.5 18.5     NA       0.1        1
      518 #FFBBBB  3 18     1    82  2.5  3.5 17.5 18.5     NA       0.1        1
      519 #FFBBBB  3 18     1    82  2.5  3.5 17.5 18.5     NA       0.1        1
      520 #FFBBBB  4 18     1   114  3.5  4.5 17.5 18.5     NA       0.1        1
      521 #FFBBBB  4 18     1   114  3.5  4.5 17.5 18.5     NA       0.1        1
      522 #FFBBBB  4 18     1   114  3.5  4.5 17.5 18.5     NA       0.1        1
      523 #FFBBBB  5 18     1   146  4.5  5.5 17.5 18.5     NA       0.1        1
      524 #FFBBBB  5 18     1   146  4.5  5.5 17.5 18.5     NA       0.1        1
      525 #FFBBBB  5 18     1   146  4.5  5.5 17.5 18.5     NA       0.1        1
      526 #FFBBBB  6 18     1   178  5.5  6.5 17.5 18.5     NA       0.1        1
      527 #FFBBBB  6 18     1   178  5.5  6.5 17.5 18.5     NA       0.1        1
      528 #FFBBBB  6 18     1   178  5.5  6.5 17.5 18.5     NA       0.1        1
      529 #FFBBBB  7 18     1   210  6.5  7.5 17.5 18.5     NA       0.1        1
      530 #FFBBBB  7 18     1   210  6.5  7.5 17.5 18.5     NA       0.1        1
      531 #FFBBBB  7 18     1   210  6.5  7.5 17.5 18.5     NA       0.1        1
      532 #FFBBBB  8 18     1   242  7.5  8.5 17.5 18.5     NA       0.1        1
      533 #FFBBBB  8 18     1   242  7.5  8.5 17.5 18.5     NA       0.1        1
      534 #FFBBBB  8 18     1   242  7.5  8.5 17.5 18.5     NA       0.1        1
      535 #FFBBBB  9 18     1   274  8.5  9.5 17.5 18.5     NA       0.1        1
      536 #FFBBBB  9 18     1   274  8.5  9.5 17.5 18.5     NA       0.1        1
      537 #FFBBBB  9 18     1   274  8.5  9.5 17.5 18.5     NA       0.1        1
      538 #FFBBBB 10 18     1   306  9.5 10.5 17.5 18.5     NA       0.1        1
      539 #FFBBBB 10 18     1   306  9.5 10.5 17.5 18.5     NA       0.1        1
      540 #FFBBBB 10 18     1   306  9.5 10.5 17.5 18.5     NA       0.1        1
      541 #FFBBBB  1 19     1    19  0.5  1.5 18.5 19.5     NA       0.1        1
      542 #FFBBBB  1 19     1    19  0.5  1.5 18.5 19.5     NA       0.1        1
      543 #FFBBBB  1 19     1    19  0.5  1.5 18.5 19.5     NA       0.1        1
      544 #FFBBBB  2 19     1    51  1.5  2.5 18.5 19.5     NA       0.1        1
      545 #FFBBBB  2 19     1    51  1.5  2.5 18.5 19.5     NA       0.1        1
      546 #FFBBBB  2 19     1    51  1.5  2.5 18.5 19.5     NA       0.1        1
      547 #FFBBBB  3 19     1    83  2.5  3.5 18.5 19.5     NA       0.1        1
      548 #FFBBBB  3 19     1    83  2.5  3.5 18.5 19.5     NA       0.1        1
      549 #FFBBBB  3 19     1    83  2.5  3.5 18.5 19.5     NA       0.1        1
      550 #FFBBBB  4 19     1   115  3.5  4.5 18.5 19.5     NA       0.1        1
      551 #FFBBBB  4 19     1   115  3.5  4.5 18.5 19.5     NA       0.1        1
      552 #FFBBBB  4 19     1   115  3.5  4.5 18.5 19.5     NA       0.1        1
      553 #FFBBBB  5 19     1   147  4.5  5.5 18.5 19.5     NA       0.1        1
      554 #FFBBBB  5 19     1   147  4.5  5.5 18.5 19.5     NA       0.1        1
      555 #FFBBBB  5 19     1   147  4.5  5.5 18.5 19.5     NA       0.1        1
      556 #FFBBBB  6 19     1   179  5.5  6.5 18.5 19.5     NA       0.1        1
      557 #FFBBBB  6 19     1   179  5.5  6.5 18.5 19.5     NA       0.1        1
      558 #FFBBBB  6 19     1   179  5.5  6.5 18.5 19.5     NA       0.1        1
      559 #FFBBBB  7 19     1   211  6.5  7.5 18.5 19.5     NA       0.1        1
      560 #FFBBBB  7 19     1   211  6.5  7.5 18.5 19.5     NA       0.1        1
      561 #FFBBBB  7 19     1   211  6.5  7.5 18.5 19.5     NA       0.1        1
      562 #FFBBBB  8 19     1   243  7.5  8.5 18.5 19.5     NA       0.1        1
      563 #FFBBBB  8 19     1   243  7.5  8.5 18.5 19.5     NA       0.1        1
      564 #FFBBBB  8 19     1   243  7.5  8.5 18.5 19.5     NA       0.1        1
      565 #FFBBBB  9 19     1   275  8.5  9.5 18.5 19.5     NA       0.1        1
      566 #FFBBBB  9 19     1   275  8.5  9.5 18.5 19.5     NA       0.1        1
      567 #FFBBBB  9 19     1   275  8.5  9.5 18.5 19.5     NA       0.1        1
      568 #FFBBBB 10 19     1   307  9.5 10.5 18.5 19.5     NA       0.1        1
      569 #FFBBBB 10 19     1   307  9.5 10.5 18.5 19.5     NA       0.1        1
      570 #FFBBBB 10 19     1   307  9.5 10.5 18.5 19.5     NA       0.1        1
      571 #FFBBBB  1 20     1    20  0.5  1.5 19.5 20.5     NA       0.1        1
      572 #FFBBBB  1 20     1    20  0.5  1.5 19.5 20.5     NA       0.1        1
      573 #FFBBBB  1 20     1    20  0.5  1.5 19.5 20.5     NA       0.1        1
      574 #FFBBBB  2 20     1    52  1.5  2.5 19.5 20.5     NA       0.1        1
      575 #FFBBBB  2 20     1    52  1.5  2.5 19.5 20.5     NA       0.1        1
      576 #FFBBBB  2 20     1    52  1.5  2.5 19.5 20.5     NA       0.1        1
      577 #FFBBBB  3 20     1    84  2.5  3.5 19.5 20.5     NA       0.1        1
      578 #FFBBBB  3 20     1    84  2.5  3.5 19.5 20.5     NA       0.1        1
      579 #FFBBBB  3 20     1    84  2.5  3.5 19.5 20.5     NA       0.1        1
      580 #FFBBBB  4 20     1   116  3.5  4.5 19.5 20.5     NA       0.1        1
      581 #FFBBBB  4 20     1   116  3.5  4.5 19.5 20.5     NA       0.1        1
      582 #FFBBBB  4 20     1   116  3.5  4.5 19.5 20.5     NA       0.1        1
      583 #FFBBBB  5 20     1   148  4.5  5.5 19.5 20.5     NA       0.1        1
      584 #FFBBBB  5 20     1   148  4.5  5.5 19.5 20.5     NA       0.1        1
      585 #FFBBBB  5 20     1   148  4.5  5.5 19.5 20.5     NA       0.1        1
      586 #FFBBBB  6 20     1   180  5.5  6.5 19.5 20.5     NA       0.1        1
      587 #FFBBBB  6 20     1   180  5.5  6.5 19.5 20.5     NA       0.1        1
      588 #FFBBBB  6 20     1   180  5.5  6.5 19.5 20.5     NA       0.1        1
      589 #FFBBBB  7 20     1   212  6.5  7.5 19.5 20.5     NA       0.1        1
      590 #FFBBBB  7 20     1   212  6.5  7.5 19.5 20.5     NA       0.1        1
      591 #FFBBBB  7 20     1   212  6.5  7.5 19.5 20.5     NA       0.1        1
      592 #FFBBBB  8 20     1   244  7.5  8.5 19.5 20.5     NA       0.1        1
      593 #FFBBBB  8 20     1   244  7.5  8.5 19.5 20.5     NA       0.1        1
      594 #FFBBBB  8 20     1   244  7.5  8.5 19.5 20.5     NA       0.1        1
      595 #FFBBBB  9 20     1   276  8.5  9.5 19.5 20.5     NA       0.1        1
      596 #FFBBBB  9 20     1   276  8.5  9.5 19.5 20.5     NA       0.1        1
      597 #FFBBBB  9 20     1   276  8.5  9.5 19.5 20.5     NA       0.1        1
      598 #FFBBBB 10 20     1   308  9.5 10.5 19.5 20.5     NA       0.1        1
      599 #FFBBBB 10 20     1   308  9.5 10.5 19.5 20.5     NA       0.1        1
      600 #FFBBBB 10 20     1   308  9.5 10.5 19.5 20.5     NA       0.1        1
      601 #FFBBBB  1 21     1    21  0.5  1.5 20.5 21.5     NA       0.1        1
      602 #FFBBBB  1 21     1    21  0.5  1.5 20.5 21.5     NA       0.1        1
      603 #FFBBBB  1 21     1    21  0.5  1.5 20.5 21.5     NA       0.1        1
      604 #FFBBBB  2 21     1    53  1.5  2.5 20.5 21.5     NA       0.1        1
      605 #FFBBBB  2 21     1    53  1.5  2.5 20.5 21.5     NA       0.1        1
      606 #FFBBBB  2 21     1    53  1.5  2.5 20.5 21.5     NA       0.1        1
      607 #FFBBBB  3 21     1    85  2.5  3.5 20.5 21.5     NA       0.1        1
      608 #FFBBBB  3 21     1    85  2.5  3.5 20.5 21.5     NA       0.1        1
      609 #FFBBBB  3 21     1    85  2.5  3.5 20.5 21.5     NA       0.1        1
      610 #FFBBBB  4 21     1   117  3.5  4.5 20.5 21.5     NA       0.1        1
      611 #FFBBBB  4 21     1   117  3.5  4.5 20.5 21.5     NA       0.1        1
      612 #FFBBBB  4 21     1   117  3.5  4.5 20.5 21.5     NA       0.1        1
      613 #FFBBBB  5 21     1   149  4.5  5.5 20.5 21.5     NA       0.1        1
      614 #FFBBBB  5 21     1   149  4.5  5.5 20.5 21.5     NA       0.1        1
      615 #FFBBBB  5 21     1   149  4.5  5.5 20.5 21.5     NA       0.1        1
      616 #FFBBBB  6 21     1   181  5.5  6.5 20.5 21.5     NA       0.1        1
      617 #FFBBBB  6 21     1   181  5.5  6.5 20.5 21.5     NA       0.1        1
      618 #FFBBBB  6 21     1   181  5.5  6.5 20.5 21.5     NA       0.1        1
      619 #FFBBBB  7 21     1   213  6.5  7.5 20.5 21.5     NA       0.1        1
      620 #FFBBBB  7 21     1   213  6.5  7.5 20.5 21.5     NA       0.1        1
      621 #FFBBBB  7 21     1   213  6.5  7.5 20.5 21.5     NA       0.1        1
      622 #FFBBBB  8 21     1   245  7.5  8.5 20.5 21.5     NA       0.1        1
      623 #FFBBBB  8 21     1   245  7.5  8.5 20.5 21.5     NA       0.1        1
      624 #FFBBBB  8 21     1   245  7.5  8.5 20.5 21.5     NA       0.1        1
      625 #FFBBBB  9 21     1   277  8.5  9.5 20.5 21.5     NA       0.1        1
      626 #FFBBBB  9 21     1   277  8.5  9.5 20.5 21.5     NA       0.1        1
      627 #FFBBBB  9 21     1   277  8.5  9.5 20.5 21.5     NA       0.1        1
      628 #FFBBBB 10 21     1   309  9.5 10.5 20.5 21.5     NA       0.1        1
      629 #FFBBBB 10 21     1   309  9.5 10.5 20.5 21.5     NA       0.1        1
      630 #FFBBBB 10 21     1   309  9.5 10.5 20.5 21.5     NA       0.1        1
      631 #FFBBBB  1 22     1    22  0.5  1.5 21.5 22.5     NA       0.1        1
      632 #FFBBBB  1 22     1    22  0.5  1.5 21.5 22.5     NA       0.1        1
      633 #FFBBBB  1 22     1    22  0.5  1.5 21.5 22.5     NA       0.1        1
      634 #FFBBBB  2 22     1    54  1.5  2.5 21.5 22.5     NA       0.1        1
      635 #FFBBBB  2 22     1    54  1.5  2.5 21.5 22.5     NA       0.1        1
      636 #FFBBBB  2 22     1    54  1.5  2.5 21.5 22.5     NA       0.1        1
      637 #FFBBBB  3 22     1    86  2.5  3.5 21.5 22.5     NA       0.1        1
      638 #FFBBBB  3 22     1    86  2.5  3.5 21.5 22.5     NA       0.1        1
      639 #FFBBBB  3 22     1    86  2.5  3.5 21.5 22.5     NA       0.1        1
      640 #FFBBBB  4 22     1   118  3.5  4.5 21.5 22.5     NA       0.1        1
      641 #FFBBBB  4 22     1   118  3.5  4.5 21.5 22.5     NA       0.1        1
      642 #FFBBBB  4 22     1   118  3.5  4.5 21.5 22.5     NA       0.1        1
      643 #FFBBBB  5 22     1   150  4.5  5.5 21.5 22.5     NA       0.1        1
      644 #FFBBBB  5 22     1   150  4.5  5.5 21.5 22.5     NA       0.1        1
      645 #FFBBBB  5 22     1   150  4.5  5.5 21.5 22.5     NA       0.1        1
      646 #FFBBBB  6 22     1   182  5.5  6.5 21.5 22.5     NA       0.1        1
      647 #FFBBBB  6 22     1   182  5.5  6.5 21.5 22.5     NA       0.1        1
      648 #FFBBBB  6 22     1   182  5.5  6.5 21.5 22.5     NA       0.1        1
      649 #FFBBBB  7 22     1   214  6.5  7.5 21.5 22.5     NA       0.1        1
      650 #FFBBBB  7 22     1   214  6.5  7.5 21.5 22.5     NA       0.1        1
      651 #FFBBBB  7 22     1   214  6.5  7.5 21.5 22.5     NA       0.1        1
      652 #FFBBBB  8 22     1   246  7.5  8.5 21.5 22.5     NA       0.1        1
      653 #FFBBBB  8 22     1   246  7.5  8.5 21.5 22.5     NA       0.1        1
      654 #FFBBBB  8 22     1   246  7.5  8.5 21.5 22.5     NA       0.1        1
      655 #FFBBBB  9 22     1   278  8.5  9.5 21.5 22.5     NA       0.1        1
      656 #FFBBBB  9 22     1   278  8.5  9.5 21.5 22.5     NA       0.1        1
      657 #FFBBBB  9 22     1   278  8.5  9.5 21.5 22.5     NA       0.1        1
      658 #FFBBBB 10 22     1   310  9.5 10.5 21.5 22.5     NA       0.1        1
      659 #FFBBBB 10 22     1   310  9.5 10.5 21.5 22.5     NA       0.1        1
      660 #FFBBBB 10 22     1   310  9.5 10.5 21.5 22.5     NA       0.1        1
      661 #FFBBBB  1 23     1    23  0.5  1.5 22.5 23.5     NA       0.1        1
      662 #FFBBBB  1 23     1    23  0.5  1.5 22.5 23.5     NA       0.1        1
      663 #FFBBBB  1 23     1    23  0.5  1.5 22.5 23.5     NA       0.1        1
      664 #FFBBBB  2 23     1    55  1.5  2.5 22.5 23.5     NA       0.1        1
      665 #FFBBBB  2 23     1    55  1.5  2.5 22.5 23.5     NA       0.1        1
      666 #FFBBBB  2 23     1    55  1.5  2.5 22.5 23.5     NA       0.1        1
      667 #FFBBBB  3 23     1    87  2.5  3.5 22.5 23.5     NA       0.1        1
      668 #FFBBBB  3 23     1    87  2.5  3.5 22.5 23.5     NA       0.1        1
      669 #FFBBBB  3 23     1    87  2.5  3.5 22.5 23.5     NA       0.1        1
      670 #FFBBBB  4 23     1   119  3.5  4.5 22.5 23.5     NA       0.1        1
      671 #FFBBBB  4 23     1   119  3.5  4.5 22.5 23.5     NA       0.1        1
      672 #FFBBBB  4 23     1   119  3.5  4.5 22.5 23.5     NA       0.1        1
      673 #FFBBBB  5 23     1   151  4.5  5.5 22.5 23.5     NA       0.1        1
      674 #FFBBBB  5 23     1   151  4.5  5.5 22.5 23.5     NA       0.1        1
      675 #FFBBBB  5 23     1   151  4.5  5.5 22.5 23.5     NA       0.1        1
      676 #FFBBBB  6 23     1   183  5.5  6.5 22.5 23.5     NA       0.1        1
      677 #FFBBBB  6 23     1   183  5.5  6.5 22.5 23.5     NA       0.1        1
      678 #FFBBBB  6 23     1   183  5.5  6.5 22.5 23.5     NA       0.1        1
      679 #FFBBBB  7 23     1   215  6.5  7.5 22.5 23.5     NA       0.1        1
      680 #FFBBBB  7 23     1   215  6.5  7.5 22.5 23.5     NA       0.1        1
      681 #FFBBBB  7 23     1   215  6.5  7.5 22.5 23.5     NA       0.1        1
      682 #FFBBBB  8 23     1   247  7.5  8.5 22.5 23.5     NA       0.1        1
      683 #FFBBBB  8 23     1   247  7.5  8.5 22.5 23.5     NA       0.1        1
      684 #FFBBBB  8 23     1   247  7.5  8.5 22.5 23.5     NA       0.1        1
      685 #FFBBBB  9 23     1   279  8.5  9.5 22.5 23.5     NA       0.1        1
      686 #FFBBBB  9 23     1   279  8.5  9.5 22.5 23.5     NA       0.1        1
      687 #FFBBBB  9 23     1   279  8.5  9.5 22.5 23.5     NA       0.1        1
      688 #FFBBBB 10 23     1   311  9.5 10.5 22.5 23.5     NA       0.1        1
      689 #FFBBBB 10 23     1   311  9.5 10.5 22.5 23.5     NA       0.1        1
      690 #FFBBBB 10 23     1   311  9.5 10.5 22.5 23.5     NA       0.1        1
      691 #FFBBBB  1 24     1    24  0.5  1.5 23.5 24.5     NA       0.1        1
      692 #FFBBBB  1 24     1    24  0.5  1.5 23.5 24.5     NA       0.1        1
      693 #FFBBBB  1 24     1    24  0.5  1.5 23.5 24.5     NA       0.1        1
      694 #FFBBBB  2 24     1    56  1.5  2.5 23.5 24.5     NA       0.1        1
      695 #FFBBBB  2 24     1    56  1.5  2.5 23.5 24.5     NA       0.1        1
      696 #FFBBBB  2 24     1    56  1.5  2.5 23.5 24.5     NA       0.1        1
      697 #FFBBBB  3 24     1    88  2.5  3.5 23.5 24.5     NA       0.1        1
      698 #FFBBBB  3 24     1    88  2.5  3.5 23.5 24.5     NA       0.1        1
      699 #FFBBBB  3 24     1    88  2.5  3.5 23.5 24.5     NA       0.1        1
      700 #FFBBBB  4 24     1   120  3.5  4.5 23.5 24.5     NA       0.1        1
      701 #FFBBBB  4 24     1   120  3.5  4.5 23.5 24.5     NA       0.1        1
      702 #FFBBBB  4 24     1   120  3.5  4.5 23.5 24.5     NA       0.1        1
      703 #FFBBBB  5 24     1   152  4.5  5.5 23.5 24.5     NA       0.1        1
      704 #FFBBBB  5 24     1   152  4.5  5.5 23.5 24.5     NA       0.1        1
      705 #FFBBBB  5 24     1   152  4.5  5.5 23.5 24.5     NA       0.1        1
      706 #FFBBBB  6 24     1   184  5.5  6.5 23.5 24.5     NA       0.1        1
      707 #FFBBBB  6 24     1   184  5.5  6.5 23.5 24.5     NA       0.1        1
      708 #FFBBBB  6 24     1   184  5.5  6.5 23.5 24.5     NA       0.1        1
      709 #FFBBBB  7 24     1   216  6.5  7.5 23.5 24.5     NA       0.1        1
      710 #FFBBBB  7 24     1   216  6.5  7.5 23.5 24.5     NA       0.1        1
      711 #FFBBBB  7 24     1   216  6.5  7.5 23.5 24.5     NA       0.1        1
      712 #FFBBBB  8 24     1   248  7.5  8.5 23.5 24.5     NA       0.1        1
      713 #FFBBBB  8 24     1   248  7.5  8.5 23.5 24.5     NA       0.1        1
      714 #FFBBBB  8 24     1   248  7.5  8.5 23.5 24.5     NA       0.1        1
      715 #FFBBBB  9 24     1   280  8.5  9.5 23.5 24.5     NA       0.1        1
      716 #FFBBBB  9 24     1   280  8.5  9.5 23.5 24.5     NA       0.1        1
      717 #FFBBBB  9 24     1   280  8.5  9.5 23.5 24.5     NA       0.1        1
      718 #FFBBBB 10 24     1   312  9.5 10.5 23.5 24.5     NA       0.1        1
      719 #FFBBBB 10 24     1   312  9.5 10.5 23.5 24.5     NA       0.1        1
      720 #FFBBBB 10 24     1   312  9.5 10.5 23.5 24.5     NA       0.1        1
      721 #FFBBBB  1 25     1    25  0.5  1.5 24.5 25.5     NA       0.1        1
      722 #FFBBBB  1 25     1    25  0.5  1.5 24.5 25.5     NA       0.1        1
      723 #FFBBBB  1 25     1    25  0.5  1.5 24.5 25.5     NA       0.1        1
      724 #FFBBBB  2 25     1    57  1.5  2.5 24.5 25.5     NA       0.1        1
      725 #FFBBBB  2 25     1    57  1.5  2.5 24.5 25.5     NA       0.1        1
      726 #FFBBBB  2 25     1    57  1.5  2.5 24.5 25.5     NA       0.1        1
      727 #FFBBBB  3 25     1    89  2.5  3.5 24.5 25.5     NA       0.1        1
      728 #FFBBBB  3 25     1    89  2.5  3.5 24.5 25.5     NA       0.1        1
      729 #FFBBBB  3 25     1    89  2.5  3.5 24.5 25.5     NA       0.1        1
      730 #FFBBBB  4 25     1   121  3.5  4.5 24.5 25.5     NA       0.1        1
      731 #FFBBBB  4 25     1   121  3.5  4.5 24.5 25.5     NA       0.1        1
      732 #FFBBBB  4 25     1   121  3.5  4.5 24.5 25.5     NA       0.1        1
      733 #FFBBBB  5 25     1   153  4.5  5.5 24.5 25.5     NA       0.1        1
      734 #FFBBBB  5 25     1   153  4.5  5.5 24.5 25.5     NA       0.1        1
      735 #FFBBBB  5 25     1   153  4.5  5.5 24.5 25.5     NA       0.1        1
      736 #FFBBBB  6 25     1   185  5.5  6.5 24.5 25.5     NA       0.1        1
      737 #FFBBBB  6 25     1   185  5.5  6.5 24.5 25.5     NA       0.1        1
      738 #FFBBBB  6 25     1   185  5.5  6.5 24.5 25.5     NA       0.1        1
      739 #FFBBBB  7 25     1   217  6.5  7.5 24.5 25.5     NA       0.1        1
      740 #FFBBBB  7 25     1   217  6.5  7.5 24.5 25.5     NA       0.1        1
      741 #FFBBBB  7 25     1   217  6.5  7.5 24.5 25.5     NA       0.1        1
      742 #FFBBBB  8 25     1   249  7.5  8.5 24.5 25.5     NA       0.1        1
      743 #FFBBBB  8 25     1   249  7.5  8.5 24.5 25.5     NA       0.1        1
      744 #FFBBBB  8 25     1   249  7.5  8.5 24.5 25.5     NA       0.1        1
      745 #FFBBBB  9 25     1   281  8.5  9.5 24.5 25.5     NA       0.1        1
      746 #FFBBBB  9 25     1   281  8.5  9.5 24.5 25.5     NA       0.1        1
      747 #FFBBBB  9 25     1   281  8.5  9.5 24.5 25.5     NA       0.1        1
      748 #FFBBBB 10 25     1   313  9.5 10.5 24.5 25.5     NA       0.1        1
      749 #FFBBBB 10 25     1   313  9.5 10.5 24.5 25.5     NA       0.1        1
      750 #FFBBBB 10 25     1   313  9.5 10.5 24.5 25.5     NA       0.1        1
      751 #FFBBBB  1 26     1    26  0.5  1.5 25.5 26.5     NA       0.1        1
      752 #FFBBBB  1 26     1    26  0.5  1.5 25.5 26.5     NA       0.1        1
      753 #FFBBBB  1 26     1    26  0.5  1.5 25.5 26.5     NA       0.1        1
      754 #FFBBBB  2 26     1    58  1.5  2.5 25.5 26.5     NA       0.1        1
      755 #FFBBBB  2 26     1    58  1.5  2.5 25.5 26.5     NA       0.1        1
      756 #FFBBBB  2 26     1    58  1.5  2.5 25.5 26.5     NA       0.1        1
      757 #FFBBBB  3 26     1    90  2.5  3.5 25.5 26.5     NA       0.1        1
      758 #FFBBBB  3 26     1    90  2.5  3.5 25.5 26.5     NA       0.1        1
      759 #FFBBBB  3 26     1    90  2.5  3.5 25.5 26.5     NA       0.1        1
      760 #FFBBBB  4 26     1   122  3.5  4.5 25.5 26.5     NA       0.1        1
      761 #FFBBBB  4 26     1   122  3.5  4.5 25.5 26.5     NA       0.1        1
      762 #FFBBBB  4 26     1   122  3.5  4.5 25.5 26.5     NA       0.1        1
      763 #FFBBBB  5 26     1   154  4.5  5.5 25.5 26.5     NA       0.1        1
      764 #FFBBBB  5 26     1   154  4.5  5.5 25.5 26.5     NA       0.1        1
      765 #FFBBBB  5 26     1   154  4.5  5.5 25.5 26.5     NA       0.1        1
      766 #FFBBBB  6 26     1   186  5.5  6.5 25.5 26.5     NA       0.1        1
      767 #FFBBBB  6 26     1   186  5.5  6.5 25.5 26.5     NA       0.1        1
      768 #FFBBBB  6 26     1   186  5.5  6.5 25.5 26.5     NA       0.1        1
      769 #FFBBBB  7 26     1   218  6.5  7.5 25.5 26.5     NA       0.1        1
      770 #FFBBBB  7 26     1   218  6.5  7.5 25.5 26.5     NA       0.1        1
      771 #FFBBBB  7 26     1   218  6.5  7.5 25.5 26.5     NA       0.1        1
      772 #FFBBBB  8 26     1   250  7.5  8.5 25.5 26.5     NA       0.1        1
      773 #FFBBBB  8 26     1   250  7.5  8.5 25.5 26.5     NA       0.1        1
      774 #FFBBBB  8 26     1   250  7.5  8.5 25.5 26.5     NA       0.1        1
      775 #FFBBBB  9 26     1   282  8.5  9.5 25.5 26.5     NA       0.1        1
      776 #FFBBBB  9 26     1   282  8.5  9.5 25.5 26.5     NA       0.1        1
      777 #FFBBBB  9 26     1   282  8.5  9.5 25.5 26.5     NA       0.1        1
      778 #FFBBBB 10 26     1   314  9.5 10.5 25.5 26.5     NA       0.1        1
      779 #FFBBBB 10 26     1   314  9.5 10.5 25.5 26.5     NA       0.1        1
      780 #FFBBBB 10 26     1   314  9.5 10.5 25.5 26.5     NA       0.1        1
      781 #FFBBBB  1 27     1    27  0.5  1.5 26.5 27.5     NA       0.1        1
      782 #FFBBBB  1 27     1    27  0.5  1.5 26.5 27.5     NA       0.1        1
      783 #FFBBBB  1 27     1    27  0.5  1.5 26.5 27.5     NA       0.1        1
      784 #FFBBBB  2 27     1    59  1.5  2.5 26.5 27.5     NA       0.1        1
      785 #FFBBBB  2 27     1    59  1.5  2.5 26.5 27.5     NA       0.1        1
      786 #FFBBBB  2 27     1    59  1.5  2.5 26.5 27.5     NA       0.1        1
      787 #FFBBBB  3 27     1    91  2.5  3.5 26.5 27.5     NA       0.1        1
      788 #FFBBBB  3 27     1    91  2.5  3.5 26.5 27.5     NA       0.1        1
      789 #FFBBBB  3 27     1    91  2.5  3.5 26.5 27.5     NA       0.1        1
      790 #FFBBBB  4 27     1   123  3.5  4.5 26.5 27.5     NA       0.1        1
      791 #FFBBBB  4 27     1   123  3.5  4.5 26.5 27.5     NA       0.1        1
      792 #FFBBBB  4 27     1   123  3.5  4.5 26.5 27.5     NA       0.1        1
      793 #FFBBBB  5 27     1   155  4.5  5.5 26.5 27.5     NA       0.1        1
      794 #FFBBBB  5 27     1   155  4.5  5.5 26.5 27.5     NA       0.1        1
      795 #FFBBBB  5 27     1   155  4.5  5.5 26.5 27.5     NA       0.1        1
      796 #FFBBBB  6 27     1   187  5.5  6.5 26.5 27.5     NA       0.1        1
      797 #FFBBBB  6 27     1   187  5.5  6.5 26.5 27.5     NA       0.1        1
      798 #FFBBBB  6 27     1   187  5.5  6.5 26.5 27.5     NA       0.1        1
      799 #FFBBBB  7 27     1   219  6.5  7.5 26.5 27.5     NA       0.1        1
      800 #FFBBBB  7 27     1   219  6.5  7.5 26.5 27.5     NA       0.1        1
      801 #FFBBBB  7 27     1   219  6.5  7.5 26.5 27.5     NA       0.1        1
      802 #FFBBBB  8 27     1   251  7.5  8.5 26.5 27.5     NA       0.1        1
      803 #FFBBBB  8 27     1   251  7.5  8.5 26.5 27.5     NA       0.1        1
      804 #FFBBBB  8 27     1   251  7.5  8.5 26.5 27.5     NA       0.1        1
      805 #FFBBBB  9 27     1   283  8.5  9.5 26.5 27.5     NA       0.1        1
      806 #FFBBBB  9 27     1   283  8.5  9.5 26.5 27.5     NA       0.1        1
      807 #FFBBBB  9 27     1   283  8.5  9.5 26.5 27.5     NA       0.1        1
      808 #FFBBBB 10 27     1   315  9.5 10.5 26.5 27.5     NA       0.1        1
      809 #FFBBBB 10 27     1   315  9.5 10.5 26.5 27.5     NA       0.1        1
      810 #FFBBBB 10 27     1   315  9.5 10.5 26.5 27.5     NA       0.1        1
      811 #FFBBBB  1 28     1    28  0.5  1.5 27.5 28.5     NA       0.1        1
      812 #FFBBBB  1 28     1    28  0.5  1.5 27.5 28.5     NA       0.1        1
      813 #FFBBBB  1 28     1    28  0.5  1.5 27.5 28.5     NA       0.1        1
      814 #FFBBBB  2 28     1    60  1.5  2.5 27.5 28.5     NA       0.1        1
      815 #FFBBBB  2 28     1    60  1.5  2.5 27.5 28.5     NA       0.1        1
      816 #FFBBBB  2 28     1    60  1.5  2.5 27.5 28.5     NA       0.1        1
      817 #FFBBBB  3 28     1    92  2.5  3.5 27.5 28.5     NA       0.1        1
      818 #FFBBBB  3 28     1    92  2.5  3.5 27.5 28.5     NA       0.1        1
      819 #FFBBBB  3 28     1    92  2.5  3.5 27.5 28.5     NA       0.1        1
      820 #FFBBBB  4 28     1   124  3.5  4.5 27.5 28.5     NA       0.1        1
      821 #FFBBBB  4 28     1   124  3.5  4.5 27.5 28.5     NA       0.1        1
      822 #FFBBBB  4 28     1   124  3.5  4.5 27.5 28.5     NA       0.1        1
      823 #FFBBBB  5 28     1   156  4.5  5.5 27.5 28.5     NA       0.1        1
      824 #FFBBBB  5 28     1   156  4.5  5.5 27.5 28.5     NA       0.1        1
      825 #FFBBBB  5 28     1   156  4.5  5.5 27.5 28.5     NA       0.1        1
      826 #FFBBBB  6 28     1   188  5.5  6.5 27.5 28.5     NA       0.1        1
      827 #FFBBBB  6 28     1   188  5.5  6.5 27.5 28.5     NA       0.1        1
      828 #FFBBBB  6 28     1   188  5.5  6.5 27.5 28.5     NA       0.1        1
      829 #FFBBBB  7 28     1   220  6.5  7.5 27.5 28.5     NA       0.1        1
      830 #FFBBBB  7 28     1   220  6.5  7.5 27.5 28.5     NA       0.1        1
      831 #FFBBBB  7 28     1   220  6.5  7.5 27.5 28.5     NA       0.1        1
      832 #FFBBBB  8 28     1   252  7.5  8.5 27.5 28.5     NA       0.1        1
      833 #FFBBBB  8 28     1   252  7.5  8.5 27.5 28.5     NA       0.1        1
      834 #FFBBBB  8 28     1   252  7.5  8.5 27.5 28.5     NA       0.1        1
      835 #FFBBBB  9 28     1   284  8.5  9.5 27.5 28.5     NA       0.1        1
      836 #FFBBBB  9 28     1   284  8.5  9.5 27.5 28.5     NA       0.1        1
      837 #FFBBBB  9 28     1   284  8.5  9.5 27.5 28.5     NA       0.1        1
      838 #FFBBBB 10 28     1   316  9.5 10.5 27.5 28.5     NA       0.1        1
      839 #FFBBBB 10 28     1   316  9.5 10.5 27.5 28.5     NA       0.1        1
      840 #FFBBBB 10 28     1   316  9.5 10.5 27.5 28.5     NA       0.1        1
      841 #FFBBBB  1 29     1    29  0.5  1.5 28.5 29.5     NA       0.1        1
      842 #FFBBBB  1 29     1    29  0.5  1.5 28.5 29.5     NA       0.1        1
      843 #FFBBBB  1 29     1    29  0.5  1.5 28.5 29.5     NA       0.1        1
      844 #FFBBBB  2 29     1    61  1.5  2.5 28.5 29.5     NA       0.1        1
      845 #FFBBBB  2 29     1    61  1.5  2.5 28.5 29.5     NA       0.1        1
      846 #FFBBBB  2 29     1    61  1.5  2.5 28.5 29.5     NA       0.1        1
      847 #FFBBBB  3 29     1    93  2.5  3.5 28.5 29.5     NA       0.1        1
      848 #FFBBBB  3 29     1    93  2.5  3.5 28.5 29.5     NA       0.1        1
      849 #FFBBBB  3 29     1    93  2.5  3.5 28.5 29.5     NA       0.1        1
      850 #FFBBBB  4 29     1   125  3.5  4.5 28.5 29.5     NA       0.1        1
      851 #FFBBBB  4 29     1   125  3.5  4.5 28.5 29.5     NA       0.1        1
      852 #FFBBBB  4 29     1   125  3.5  4.5 28.5 29.5     NA       0.1        1
      853 #FFBBBB  5 29     1   157  4.5  5.5 28.5 29.5     NA       0.1        1
      854 #FFBBBB  5 29     1   157  4.5  5.5 28.5 29.5     NA       0.1        1
      855 #FFBBBB  5 29     1   157  4.5  5.5 28.5 29.5     NA       0.1        1
      856 #FFBBBB  6 29     1   189  5.5  6.5 28.5 29.5     NA       0.1        1
      857 #FFBBBB  6 29     1   189  5.5  6.5 28.5 29.5     NA       0.1        1
      858 #FFBBBB  6 29     1   189  5.5  6.5 28.5 29.5     NA       0.1        1
      859 #FFBBBB  7 29     1   221  6.5  7.5 28.5 29.5     NA       0.1        1
      860 #FFBBBB  7 29     1   221  6.5  7.5 28.5 29.5     NA       0.1        1
      861 #FFBBBB  7 29     1   221  6.5  7.5 28.5 29.5     NA       0.1        1
      862 #FFBBBB  8 29     1   253  7.5  8.5 28.5 29.5     NA       0.1        1
      863 #FFBBBB  8 29     1   253  7.5  8.5 28.5 29.5     NA       0.1        1
      864 #FFBBBB  8 29     1   253  7.5  8.5 28.5 29.5     NA       0.1        1
      865 #FFBBBB  9 29     1   285  8.5  9.5 28.5 29.5     NA       0.1        1
      866 #FFBBBB  9 29     1   285  8.5  9.5 28.5 29.5     NA       0.1        1
      867 #FFBBBB  9 29     1   285  8.5  9.5 28.5 29.5     NA       0.1        1
      868 #FFBBBB 10 29     1   317  9.5 10.5 28.5 29.5     NA       0.1        1
      869 #FFBBBB 10 29     1   317  9.5 10.5 28.5 29.5     NA       0.1        1
      870 #FFBBBB 10 29     1   317  9.5 10.5 28.5 29.5     NA       0.1        1
      871 #FFBBBB  1 30     1    30  0.5  1.5 29.5 30.5     NA       0.1        1
      872 #FFBBBB  1 30     1    30  0.5  1.5 29.5 30.5     NA       0.1        1
      873 #FFBBBB  1 30     1    30  0.5  1.5 29.5 30.5     NA       0.1        1
      874 #FFBBBB  2 30     1    62  1.5  2.5 29.5 30.5     NA       0.1        1
      875 #FFBBBB  2 30     1    62  1.5  2.5 29.5 30.5     NA       0.1        1
      876 #FFBBBB  2 30     1    62  1.5  2.5 29.5 30.5     NA       0.1        1
      877 #FFBBBB  3 30     1    94  2.5  3.5 29.5 30.5     NA       0.1        1
      878 #FFBBBB  3 30     1    94  2.5  3.5 29.5 30.5     NA       0.1        1
      879 #FFBBBB  3 30     1    94  2.5  3.5 29.5 30.5     NA       0.1        1
      880 #FFBBBB  4 30     1   126  3.5  4.5 29.5 30.5     NA       0.1        1
      881 #FFBBBB  4 30     1   126  3.5  4.5 29.5 30.5     NA       0.1        1
      882 #FFBBBB  4 30     1   126  3.5  4.5 29.5 30.5     NA       0.1        1
      883 #FFBBBB  5 30     1   158  4.5  5.5 29.5 30.5     NA       0.1        1
      884 #FFBBBB  5 30     1   158  4.5  5.5 29.5 30.5     NA       0.1        1
      885 #FFBBBB  5 30     1   158  4.5  5.5 29.5 30.5     NA       0.1        1
      886 #FFBBBB  6 30     1   190  5.5  6.5 29.5 30.5     NA       0.1        1
      887 #FFBBBB  6 30     1   190  5.5  6.5 29.5 30.5     NA       0.1        1
      888 #FFBBBB  6 30     1   190  5.5  6.5 29.5 30.5     NA       0.1        1
      889 #FFBBBB  7 30     1   222  6.5  7.5 29.5 30.5     NA       0.1        1
      890 #FFBBBB  7 30     1   222  6.5  7.5 29.5 30.5     NA       0.1        1
      891 #FFBBBB  7 30     1   222  6.5  7.5 29.5 30.5     NA       0.1        1
      892 #FFBBBB  8 30     1   254  7.5  8.5 29.5 30.5     NA       0.1        1
      893 #FFBBBB  8 30     1   254  7.5  8.5 29.5 30.5     NA       0.1        1
      894 #FFBBBB  8 30     1   254  7.5  8.5 29.5 30.5     NA       0.1        1
      895 #FFBBBB  9 30     1   286  8.5  9.5 29.5 30.5     NA       0.1        1
      896 #FFBBBB  9 30     1   286  8.5  9.5 29.5 30.5     NA       0.1        1
      897 #FFBBBB  9 30     1   286  8.5  9.5 29.5 30.5     NA       0.1        1
      898 #FFBBBB 10 30     1   318  9.5 10.5 29.5 30.5     NA       0.1        1
      899 #FFBBBB 10 30     1   318  9.5 10.5 29.5 30.5     NA       0.1        1
      900 #FFBBBB 10 30     1   318  9.5 10.5 29.5 30.5     NA       0.1        1
      901 #FFBBBB  1 31     1    31  0.5  1.5 30.5 31.5     NA       0.1        1
      902 #FFBBBB  1 31     1    31  0.5  1.5 30.5 31.5     NA       0.1        1
      903 #FFBBBB  1 31     1    31  0.5  1.5 30.5 31.5     NA       0.1        1
      904 #FFBBBB  2 31     1    63  1.5  2.5 30.5 31.5     NA       0.1        1
      905 #FFBBBB  2 31     1    63  1.5  2.5 30.5 31.5     NA       0.1        1
      906 #FFBBBB  2 31     1    63  1.5  2.5 30.5 31.5     NA       0.1        1
      907 #FFBBBB  3 31     1    95  2.5  3.5 30.5 31.5     NA       0.1        1
      908 #FFBBBB  3 31     1    95  2.5  3.5 30.5 31.5     NA       0.1        1
      909 #FFBBBB  3 31     1    95  2.5  3.5 30.5 31.5     NA       0.1        1
      910 #FFBBBB  4 31     1   127  3.5  4.5 30.5 31.5     NA       0.1        1
      911 #FFBBBB  4 31     1   127  3.5  4.5 30.5 31.5     NA       0.1        1
      912 #FFBBBB  4 31     1   127  3.5  4.5 30.5 31.5     NA       0.1        1
      913 #FFBBBB  5 31     1   159  4.5  5.5 30.5 31.5     NA       0.1        1
      914 #FFBBBB  5 31     1   159  4.5  5.5 30.5 31.5     NA       0.1        1
      915 #FFBBBB  5 31     1   159  4.5  5.5 30.5 31.5     NA       0.1        1
      916 #FFBBBB  6 31     1   191  5.5  6.5 30.5 31.5     NA       0.1        1
      917 #FFBBBB  6 31     1   191  5.5  6.5 30.5 31.5     NA       0.1        1
      918 #FFBBBB  6 31     1   191  5.5  6.5 30.5 31.5     NA       0.1        1
      919 #FFBBBB  7 31     1   223  6.5  7.5 30.5 31.5     NA       0.1        1
      920 #FFBBBB  7 31     1   223  6.5  7.5 30.5 31.5     NA       0.1        1
      921 #FFBBBB  7 31     1   223  6.5  7.5 30.5 31.5     NA       0.1        1
      922 #FFBBBB  8 31     1   255  7.5  8.5 30.5 31.5     NA       0.1        1
      923 #FFBBBB  8 31     1   255  7.5  8.5 30.5 31.5     NA       0.1        1
      924 #FFBBBB  8 31     1   255  7.5  8.5 30.5 31.5     NA       0.1        1
      925 #FFBBBB  9 31     1   287  8.5  9.5 30.5 31.5     NA       0.1        1
      926 #FFBBBB  9 31     1   287  8.5  9.5 30.5 31.5     NA       0.1        1
      927 #FFBBBB  9 31     1   287  8.5  9.5 30.5 31.5     NA       0.1        1
      928 #FFBBBB 10 31     1   319  9.5 10.5 30.5 31.5     NA       0.1        1
      929 #FFBBBB 10 31     1   319  9.5 10.5 30.5 31.5     NA       0.1        1
      930 #FFBBBB 10 31     1   319  9.5 10.5 30.5 31.5     NA       0.1        1
      931 #FFBBBB  1 32     1    32  0.5  1.5 31.5 32.5     NA       0.1        1
      932 #FFBBBB  1 32     1    32  0.5  1.5 31.5 32.5     NA       0.1        1
      933 #FFBBBB  1 32     1    32  0.5  1.5 31.5 32.5     NA       0.1        1
      934 #FFBBBB  2 32     1    64  1.5  2.5 31.5 32.5     NA       0.1        1
      935 #FFBBBB  2 32     1    64  1.5  2.5 31.5 32.5     NA       0.1        1
      936 #FFBBBB  2 32     1    64  1.5  2.5 31.5 32.5     NA       0.1        1
      937 #FFBBBB  3 32     1    96  2.5  3.5 31.5 32.5     NA       0.1        1
      938 #FFBBBB  3 32     1    96  2.5  3.5 31.5 32.5     NA       0.1        1
      939 #FFBBBB  3 32     1    96  2.5  3.5 31.5 32.5     NA       0.1        1
      940 #FFBBBB  4 32     1   128  3.5  4.5 31.5 32.5     NA       0.1        1
      941 #FFBBBB  4 32     1   128  3.5  4.5 31.5 32.5     NA       0.1        1
      942 #FFBBBB  4 32     1   128  3.5  4.5 31.5 32.5     NA       0.1        1
      943 #FFBBBB  5 32     1   160  4.5  5.5 31.5 32.5     NA       0.1        1
      944 #FFBBBB  5 32     1   160  4.5  5.5 31.5 32.5     NA       0.1        1
      945 #FFBBBB  5 32     1   160  4.5  5.5 31.5 32.5     NA       0.1        1
      946 #FFBBBB  6 32     1   192  5.5  6.5 31.5 32.5     NA       0.1        1
      947 #FFBBBB  6 32     1   192  5.5  6.5 31.5 32.5     NA       0.1        1
      948 #FFBBBB  6 32     1   192  5.5  6.5 31.5 32.5     NA       0.1        1
      949 #FFBBBB  7 32     1   224  6.5  7.5 31.5 32.5     NA       0.1        1
      950 #FFBBBB  7 32     1   224  6.5  7.5 31.5 32.5     NA       0.1        1
      951 #FFBBBB  7 32     1   224  6.5  7.5 31.5 32.5     NA       0.1        1
      952 #FFBBBB  8 32     1   256  7.5  8.5 31.5 32.5     NA       0.1        1
      953 #FFBBBB  8 32     1   256  7.5  8.5 31.5 32.5     NA       0.1        1
      954 #FFBBBB  8 32     1   256  7.5  8.5 31.5 32.5     NA       0.1        1
      955 #FFBBBB  9 32     1   288  8.5  9.5 31.5 32.5     NA       0.1        1
      956 #FFBBBB  9 32     1   288  8.5  9.5 31.5 32.5     NA       0.1        1
      957 #FFBBBB  9 32     1   288  8.5  9.5 31.5 32.5     NA       0.1        1
      958 #FFBBBB 10 32     1   320  9.5 10.5 31.5 32.5     NA       0.1        1
      959 #FFBBBB 10 32     1   320  9.5 10.5 31.5 32.5     NA       0.1        1
      960 #FFBBBB 10 32     1   320  9.5 10.5 31.5 32.5     NA       0.1        1
          alpha width height
      1      NA    NA     NA
      2      NA    NA     NA
      3      NA    NA     NA
      4      NA    NA     NA
      5      NA    NA     NA
      6      NA    NA     NA
      7      NA    NA     NA
      8      NA    NA     NA
      9      NA    NA     NA
      10     NA    NA     NA
      11     NA    NA     NA
      12     NA    NA     NA
      13     NA    NA     NA
      14     NA    NA     NA
      15     NA    NA     NA
      16     NA    NA     NA
      17     NA    NA     NA
      18     NA    NA     NA
      19     NA    NA     NA
      20     NA    NA     NA
      21     NA    NA     NA
      22     NA    NA     NA
      23     NA    NA     NA
      24     NA    NA     NA
      25     NA    NA     NA
      26     NA    NA     NA
      27     NA    NA     NA
      28     NA    NA     NA
      29     NA    NA     NA
      30     NA    NA     NA
      31     NA    NA     NA
      32     NA    NA     NA
      33     NA    NA     NA
      34     NA    NA     NA
      35     NA    NA     NA
      36     NA    NA     NA
      37     NA    NA     NA
      38     NA    NA     NA
      39     NA    NA     NA
      40     NA    NA     NA
      41     NA    NA     NA
      42     NA    NA     NA
      43     NA    NA     NA
      44     NA    NA     NA
      45     NA    NA     NA
      46     NA    NA     NA
      47     NA    NA     NA
      48     NA    NA     NA
      49     NA    NA     NA
      50     NA    NA     NA
      51     NA    NA     NA
      52     NA    NA     NA
      53     NA    NA     NA
      54     NA    NA     NA
      55     NA    NA     NA
      56     NA    NA     NA
      57     NA    NA     NA
      58     NA    NA     NA
      59     NA    NA     NA
      60     NA    NA     NA
      61     NA    NA     NA
      62     NA    NA     NA
      63     NA    NA     NA
      64     NA    NA     NA
      65     NA    NA     NA
      66     NA    NA     NA
      67     NA    NA     NA
      68     NA    NA     NA
      69     NA    NA     NA
      70     NA    NA     NA
      71     NA    NA     NA
      72     NA    NA     NA
      73     NA    NA     NA
      74     NA    NA     NA
      75     NA    NA     NA
      76     NA    NA     NA
      77     NA    NA     NA
      78     NA    NA     NA
      79     NA    NA     NA
      80     NA    NA     NA
      81     NA    NA     NA
      82     NA    NA     NA
      83     NA    NA     NA
      84     NA    NA     NA
      85     NA    NA     NA
      86     NA    NA     NA
      87     NA    NA     NA
      88     NA    NA     NA
      89     NA    NA     NA
      90     NA    NA     NA
      91     NA    NA     NA
      92     NA    NA     NA
      93     NA    NA     NA
      94     NA    NA     NA
      95     NA    NA     NA
      96     NA    NA     NA
      97     NA    NA     NA
      98     NA    NA     NA
      99     NA    NA     NA
      100    NA    NA     NA
      101    NA    NA     NA
      102    NA    NA     NA
      103    NA    NA     NA
      104    NA    NA     NA
      105    NA    NA     NA
      106    NA    NA     NA
      107    NA    NA     NA
      108    NA    NA     NA
      109    NA    NA     NA
      110    NA    NA     NA
      111    NA    NA     NA
      112    NA    NA     NA
      113    NA    NA     NA
      114    NA    NA     NA
      115    NA    NA     NA
      116    NA    NA     NA
      117    NA    NA     NA
      118    NA    NA     NA
      119    NA    NA     NA
      120    NA    NA     NA
      121    NA    NA     NA
      122    NA    NA     NA
      123    NA    NA     NA
      124    NA    NA     NA
      125    NA    NA     NA
      126    NA    NA     NA
      127    NA    NA     NA
      128    NA    NA     NA
      129    NA    NA     NA
      130    NA    NA     NA
      131    NA    NA     NA
      132    NA    NA     NA
      133    NA    NA     NA
      134    NA    NA     NA
      135    NA    NA     NA
      136    NA    NA     NA
      137    NA    NA     NA
      138    NA    NA     NA
      139    NA    NA     NA
      140    NA    NA     NA
      141    NA    NA     NA
      142    NA    NA     NA
      143    NA    NA     NA
      144    NA    NA     NA
      145    NA    NA     NA
      146    NA    NA     NA
      147    NA    NA     NA
      148    NA    NA     NA
      149    NA    NA     NA
      150    NA    NA     NA
      151    NA    NA     NA
      152    NA    NA     NA
      153    NA    NA     NA
      154    NA    NA     NA
      155    NA    NA     NA
      156    NA    NA     NA
      157    NA    NA     NA
      158    NA    NA     NA
      159    NA    NA     NA
      160    NA    NA     NA
      161    NA    NA     NA
      162    NA    NA     NA
      163    NA    NA     NA
      164    NA    NA     NA
      165    NA    NA     NA
      166    NA    NA     NA
      167    NA    NA     NA
      168    NA    NA     NA
      169    NA    NA     NA
      170    NA    NA     NA
      171    NA    NA     NA
      172    NA    NA     NA
      173    NA    NA     NA
      174    NA    NA     NA
      175    NA    NA     NA
      176    NA    NA     NA
      177    NA    NA     NA
      178    NA    NA     NA
      179    NA    NA     NA
      180    NA    NA     NA
      181    NA    NA     NA
      182    NA    NA     NA
      183    NA    NA     NA
      184    NA    NA     NA
      185    NA    NA     NA
      186    NA    NA     NA
      187    NA    NA     NA
      188    NA    NA     NA
      189    NA    NA     NA
      190    NA    NA     NA
      191    NA    NA     NA
      192    NA    NA     NA
      193    NA    NA     NA
      194    NA    NA     NA
      195    NA    NA     NA
      196    NA    NA     NA
      197    NA    NA     NA
      198    NA    NA     NA
      199    NA    NA     NA
      200    NA    NA     NA
      201    NA    NA     NA
      202    NA    NA     NA
      203    NA    NA     NA
      204    NA    NA     NA
      205    NA    NA     NA
      206    NA    NA     NA
      207    NA    NA     NA
      208    NA    NA     NA
      209    NA    NA     NA
      210    NA    NA     NA
      211    NA    NA     NA
      212    NA    NA     NA
      213    NA    NA     NA
      214    NA    NA     NA
      215    NA    NA     NA
      216    NA    NA     NA
      217    NA    NA     NA
      218    NA    NA     NA
      219    NA    NA     NA
      220    NA    NA     NA
      221    NA    NA     NA
      222    NA    NA     NA
      223    NA    NA     NA
      224    NA    NA     NA
      225    NA    NA     NA
      226    NA    NA     NA
      227    NA    NA     NA
      228    NA    NA     NA
      229    NA    NA     NA
      230    NA    NA     NA
      231    NA    NA     NA
      232    NA    NA     NA
      233    NA    NA     NA
      234    NA    NA     NA
      235    NA    NA     NA
      236    NA    NA     NA
      237    NA    NA     NA
      238    NA    NA     NA
      239    NA    NA     NA
      240    NA    NA     NA
      241    NA    NA     NA
      242    NA    NA     NA
      243    NA    NA     NA
      244    NA    NA     NA
      245    NA    NA     NA
      246    NA    NA     NA
      247    NA    NA     NA
      248    NA    NA     NA
      249    NA    NA     NA
      250    NA    NA     NA
      251    NA    NA     NA
      252    NA    NA     NA
      253    NA    NA     NA
      254    NA    NA     NA
      255    NA    NA     NA
      256    NA    NA     NA
      257    NA    NA     NA
      258    NA    NA     NA
      259    NA    NA     NA
      260    NA    NA     NA
      261    NA    NA     NA
      262    NA    NA     NA
      263    NA    NA     NA
      264    NA    NA     NA
      265    NA    NA     NA
      266    NA    NA     NA
      267    NA    NA     NA
      268    NA    NA     NA
      269    NA    NA     NA
      270    NA    NA     NA
      271    NA    NA     NA
      272    NA    NA     NA
      273    NA    NA     NA
      274    NA    NA     NA
      275    NA    NA     NA
      276    NA    NA     NA
      277    NA    NA     NA
      278    NA    NA     NA
      279    NA    NA     NA
      280    NA    NA     NA
      281    NA    NA     NA
      282    NA    NA     NA
      283    NA    NA     NA
      284    NA    NA     NA
      285    NA    NA     NA
      286    NA    NA     NA
      287    NA    NA     NA
      288    NA    NA     NA
      289    NA    NA     NA
      290    NA    NA     NA
      291    NA    NA     NA
      292    NA    NA     NA
      293    NA    NA     NA
      294    NA    NA     NA
      295    NA    NA     NA
      296    NA    NA     NA
      297    NA    NA     NA
      298    NA    NA     NA
      299    NA    NA     NA
      300    NA    NA     NA
      301    NA    NA     NA
      302    NA    NA     NA
      303    NA    NA     NA
      304    NA    NA     NA
      305    NA    NA     NA
      306    NA    NA     NA
      307    NA    NA     NA
      308    NA    NA     NA
      309    NA    NA     NA
      310    NA    NA     NA
      311    NA    NA     NA
      312    NA    NA     NA
      313    NA    NA     NA
      314    NA    NA     NA
      315    NA    NA     NA
      316    NA    NA     NA
      317    NA    NA     NA
      318    NA    NA     NA
      319    NA    NA     NA
      320    NA    NA     NA
      321    NA    NA     NA
      322    NA    NA     NA
      323    NA    NA     NA
      324    NA    NA     NA
      325    NA    NA     NA
      326    NA    NA     NA
      327    NA    NA     NA
      328    NA    NA     NA
      329    NA    NA     NA
      330    NA    NA     NA
      331    NA    NA     NA
      332    NA    NA     NA
      333    NA    NA     NA
      334    NA    NA     NA
      335    NA    NA     NA
      336    NA    NA     NA
      337    NA    NA     NA
      338    NA    NA     NA
      339    NA    NA     NA
      340    NA    NA     NA
      341    NA    NA     NA
      342    NA    NA     NA
      343    NA    NA     NA
      344    NA    NA     NA
      345    NA    NA     NA
      346    NA    NA     NA
      347    NA    NA     NA
      348    NA    NA     NA
      349    NA    NA     NA
      350    NA    NA     NA
      351    NA    NA     NA
      352    NA    NA     NA
      353    NA    NA     NA
      354    NA    NA     NA
      355    NA    NA     NA
      356    NA    NA     NA
      357    NA    NA     NA
      358    NA    NA     NA
      359    NA    NA     NA
      360    NA    NA     NA
      361    NA    NA     NA
      362    NA    NA     NA
      363    NA    NA     NA
      364    NA    NA     NA
      365    NA    NA     NA
      366    NA    NA     NA
      367    NA    NA     NA
      368    NA    NA     NA
      369    NA    NA     NA
      370    NA    NA     NA
      371    NA    NA     NA
      372    NA    NA     NA
      373    NA    NA     NA
      374    NA    NA     NA
      375    NA    NA     NA
      376    NA    NA     NA
      377    NA    NA     NA
      378    NA    NA     NA
      379    NA    NA     NA
      380    NA    NA     NA
      381    NA    NA     NA
      382    NA    NA     NA
      383    NA    NA     NA
      384    NA    NA     NA
      385    NA    NA     NA
      386    NA    NA     NA
      387    NA    NA     NA
      388    NA    NA     NA
      389    NA    NA     NA
      390    NA    NA     NA
      391    NA    NA     NA
      392    NA    NA     NA
      393    NA    NA     NA
      394    NA    NA     NA
      395    NA    NA     NA
      396    NA    NA     NA
      397    NA    NA     NA
      398    NA    NA     NA
      399    NA    NA     NA
      400    NA    NA     NA
      401    NA    NA     NA
      402    NA    NA     NA
      403    NA    NA     NA
      404    NA    NA     NA
      405    NA    NA     NA
      406    NA    NA     NA
      407    NA    NA     NA
      408    NA    NA     NA
      409    NA    NA     NA
      410    NA    NA     NA
      411    NA    NA     NA
      412    NA    NA     NA
      413    NA    NA     NA
      414    NA    NA     NA
      415    NA    NA     NA
      416    NA    NA     NA
      417    NA    NA     NA
      418    NA    NA     NA
      419    NA    NA     NA
      420    NA    NA     NA
      421    NA    NA     NA
      422    NA    NA     NA
      423    NA    NA     NA
      424    NA    NA     NA
      425    NA    NA     NA
      426    NA    NA     NA
      427    NA    NA     NA
      428    NA    NA     NA
      429    NA    NA     NA
      430    NA    NA     NA
      431    NA    NA     NA
      432    NA    NA     NA
      433    NA    NA     NA
      434    NA    NA     NA
      435    NA    NA     NA
      436    NA    NA     NA
      437    NA    NA     NA
      438    NA    NA     NA
      439    NA    NA     NA
      440    NA    NA     NA
      441    NA    NA     NA
      442    NA    NA     NA
      443    NA    NA     NA
      444    NA    NA     NA
      445    NA    NA     NA
      446    NA    NA     NA
      447    NA    NA     NA
      448    NA    NA     NA
      449    NA    NA     NA
      450    NA    NA     NA
      451    NA    NA     NA
      452    NA    NA     NA
      453    NA    NA     NA
      454    NA    NA     NA
      455    NA    NA     NA
      456    NA    NA     NA
      457    NA    NA     NA
      458    NA    NA     NA
      459    NA    NA     NA
      460    NA    NA     NA
      461    NA    NA     NA
      462    NA    NA     NA
      463    NA    NA     NA
      464    NA    NA     NA
      465    NA    NA     NA
      466    NA    NA     NA
      467    NA    NA     NA
      468    NA    NA     NA
      469    NA    NA     NA
      470    NA    NA     NA
      471    NA    NA     NA
      472    NA    NA     NA
      473    NA    NA     NA
      474    NA    NA     NA
      475    NA    NA     NA
      476    NA    NA     NA
      477    NA    NA     NA
      478    NA    NA     NA
      479    NA    NA     NA
      480    NA    NA     NA
      481    NA    NA     NA
      482    NA    NA     NA
      483    NA    NA     NA
      484    NA    NA     NA
      485    NA    NA     NA
      486    NA    NA     NA
      487    NA    NA     NA
      488    NA    NA     NA
      489    NA    NA     NA
      490    NA    NA     NA
      491    NA    NA     NA
      492    NA    NA     NA
      493    NA    NA     NA
      494    NA    NA     NA
      495    NA    NA     NA
      496    NA    NA     NA
      497    NA    NA     NA
      498    NA    NA     NA
      499    NA    NA     NA
      500    NA    NA     NA
      501    NA    NA     NA
      502    NA    NA     NA
      503    NA    NA     NA
      504    NA    NA     NA
      505    NA    NA     NA
      506    NA    NA     NA
      507    NA    NA     NA
      508    NA    NA     NA
      509    NA    NA     NA
      510    NA    NA     NA
      511    NA    NA     NA
      512    NA    NA     NA
      513    NA    NA     NA
      514    NA    NA     NA
      515    NA    NA     NA
      516    NA    NA     NA
      517    NA    NA     NA
      518    NA    NA     NA
      519    NA    NA     NA
      520    NA    NA     NA
      521    NA    NA     NA
      522    NA    NA     NA
      523    NA    NA     NA
      524    NA    NA     NA
      525    NA    NA     NA
      526    NA    NA     NA
      527    NA    NA     NA
      528    NA    NA     NA
      529    NA    NA     NA
      530    NA    NA     NA
      531    NA    NA     NA
      532    NA    NA     NA
      533    NA    NA     NA
      534    NA    NA     NA
      535    NA    NA     NA
      536    NA    NA     NA
      537    NA    NA     NA
      538    NA    NA     NA
      539    NA    NA     NA
      540    NA    NA     NA
      541    NA    NA     NA
      542    NA    NA     NA
      543    NA    NA     NA
      544    NA    NA     NA
      545    NA    NA     NA
      546    NA    NA     NA
      547    NA    NA     NA
      548    NA    NA     NA
      549    NA    NA     NA
      550    NA    NA     NA
      551    NA    NA     NA
      552    NA    NA     NA
      553    NA    NA     NA
      554    NA    NA     NA
      555    NA    NA     NA
      556    NA    NA     NA
      557    NA    NA     NA
      558    NA    NA     NA
      559    NA    NA     NA
      560    NA    NA     NA
      561    NA    NA     NA
      562    NA    NA     NA
      563    NA    NA     NA
      564    NA    NA     NA
      565    NA    NA     NA
      566    NA    NA     NA
      567    NA    NA     NA
      568    NA    NA     NA
      569    NA    NA     NA
      570    NA    NA     NA
      571    NA    NA     NA
      572    NA    NA     NA
      573    NA    NA     NA
      574    NA    NA     NA
      575    NA    NA     NA
      576    NA    NA     NA
      577    NA    NA     NA
      578    NA    NA     NA
      579    NA    NA     NA
      580    NA    NA     NA
      581    NA    NA     NA
      582    NA    NA     NA
      583    NA    NA     NA
      584    NA    NA     NA
      585    NA    NA     NA
      586    NA    NA     NA
      587    NA    NA     NA
      588    NA    NA     NA
      589    NA    NA     NA
      590    NA    NA     NA
      591    NA    NA     NA
      592    NA    NA     NA
      593    NA    NA     NA
      594    NA    NA     NA
      595    NA    NA     NA
      596    NA    NA     NA
      597    NA    NA     NA
      598    NA    NA     NA
      599    NA    NA     NA
      600    NA    NA     NA
      601    NA    NA     NA
      602    NA    NA     NA
      603    NA    NA     NA
      604    NA    NA     NA
      605    NA    NA     NA
      606    NA    NA     NA
      607    NA    NA     NA
      608    NA    NA     NA
      609    NA    NA     NA
      610    NA    NA     NA
      611    NA    NA     NA
      612    NA    NA     NA
      613    NA    NA     NA
      614    NA    NA     NA
      615    NA    NA     NA
      616    NA    NA     NA
      617    NA    NA     NA
      618    NA    NA     NA
      619    NA    NA     NA
      620    NA    NA     NA
      621    NA    NA     NA
      622    NA    NA     NA
      623    NA    NA     NA
      624    NA    NA     NA
      625    NA    NA     NA
      626    NA    NA     NA
      627    NA    NA     NA
      628    NA    NA     NA
      629    NA    NA     NA
      630    NA    NA     NA
      631    NA    NA     NA
      632    NA    NA     NA
      633    NA    NA     NA
      634    NA    NA     NA
      635    NA    NA     NA
      636    NA    NA     NA
      637    NA    NA     NA
      638    NA    NA     NA
      639    NA    NA     NA
      640    NA    NA     NA
      641    NA    NA     NA
      642    NA    NA     NA
      643    NA    NA     NA
      644    NA    NA     NA
      645    NA    NA     NA
      646    NA    NA     NA
      647    NA    NA     NA
      648    NA    NA     NA
      649    NA    NA     NA
      650    NA    NA     NA
      651    NA    NA     NA
      652    NA    NA     NA
      653    NA    NA     NA
      654    NA    NA     NA
      655    NA    NA     NA
      656    NA    NA     NA
      657    NA    NA     NA
      658    NA    NA     NA
      659    NA    NA     NA
      660    NA    NA     NA
      661    NA    NA     NA
      662    NA    NA     NA
      663    NA    NA     NA
      664    NA    NA     NA
      665    NA    NA     NA
      666    NA    NA     NA
      667    NA    NA     NA
      668    NA    NA     NA
      669    NA    NA     NA
      670    NA    NA     NA
      671    NA    NA     NA
      672    NA    NA     NA
      673    NA    NA     NA
      674    NA    NA     NA
      675    NA    NA     NA
      676    NA    NA     NA
      677    NA    NA     NA
      678    NA    NA     NA
      679    NA    NA     NA
      680    NA    NA     NA
      681    NA    NA     NA
      682    NA    NA     NA
      683    NA    NA     NA
      684    NA    NA     NA
      685    NA    NA     NA
      686    NA    NA     NA
      687    NA    NA     NA
      688    NA    NA     NA
      689    NA    NA     NA
      690    NA    NA     NA
      691    NA    NA     NA
      692    NA    NA     NA
      693    NA    NA     NA
      694    NA    NA     NA
      695    NA    NA     NA
      696    NA    NA     NA
      697    NA    NA     NA
      698    NA    NA     NA
      699    NA    NA     NA
      700    NA    NA     NA
      701    NA    NA     NA
      702    NA    NA     NA
      703    NA    NA     NA
      704    NA    NA     NA
      705    NA    NA     NA
      706    NA    NA     NA
      707    NA    NA     NA
      708    NA    NA     NA
      709    NA    NA     NA
      710    NA    NA     NA
      711    NA    NA     NA
      712    NA    NA     NA
      713    NA    NA     NA
      714    NA    NA     NA
      715    NA    NA     NA
      716    NA    NA     NA
      717    NA    NA     NA
      718    NA    NA     NA
      719    NA    NA     NA
      720    NA    NA     NA
      721    NA    NA     NA
      722    NA    NA     NA
      723    NA    NA     NA
      724    NA    NA     NA
      725    NA    NA     NA
      726    NA    NA     NA
      727    NA    NA     NA
      728    NA    NA     NA
      729    NA    NA     NA
      730    NA    NA     NA
      731    NA    NA     NA
      732    NA    NA     NA
      733    NA    NA     NA
      734    NA    NA     NA
      735    NA    NA     NA
      736    NA    NA     NA
      737    NA    NA     NA
      738    NA    NA     NA
      739    NA    NA     NA
      740    NA    NA     NA
      741    NA    NA     NA
      742    NA    NA     NA
      743    NA    NA     NA
      744    NA    NA     NA
      745    NA    NA     NA
      746    NA    NA     NA
      747    NA    NA     NA
      748    NA    NA     NA
      749    NA    NA     NA
      750    NA    NA     NA
      751    NA    NA     NA
      752    NA    NA     NA
      753    NA    NA     NA
      754    NA    NA     NA
      755    NA    NA     NA
      756    NA    NA     NA
      757    NA    NA     NA
      758    NA    NA     NA
      759    NA    NA     NA
      760    NA    NA     NA
      761    NA    NA     NA
      762    NA    NA     NA
      763    NA    NA     NA
      764    NA    NA     NA
      765    NA    NA     NA
      766    NA    NA     NA
      767    NA    NA     NA
      768    NA    NA     NA
      769    NA    NA     NA
      770    NA    NA     NA
      771    NA    NA     NA
      772    NA    NA     NA
      773    NA    NA     NA
      774    NA    NA     NA
      775    NA    NA     NA
      776    NA    NA     NA
      777    NA    NA     NA
      778    NA    NA     NA
      779    NA    NA     NA
      780    NA    NA     NA
      781    NA    NA     NA
      782    NA    NA     NA
      783    NA    NA     NA
      784    NA    NA     NA
      785    NA    NA     NA
      786    NA    NA     NA
      787    NA    NA     NA
      788    NA    NA     NA
      789    NA    NA     NA
      790    NA    NA     NA
      791    NA    NA     NA
      792    NA    NA     NA
      793    NA    NA     NA
      794    NA    NA     NA
      795    NA    NA     NA
      796    NA    NA     NA
      797    NA    NA     NA
      798    NA    NA     NA
      799    NA    NA     NA
      800    NA    NA     NA
      801    NA    NA     NA
      802    NA    NA     NA
      803    NA    NA     NA
      804    NA    NA     NA
      805    NA    NA     NA
      806    NA    NA     NA
      807    NA    NA     NA
      808    NA    NA     NA
      809    NA    NA     NA
      810    NA    NA     NA
      811    NA    NA     NA
      812    NA    NA     NA
      813    NA    NA     NA
      814    NA    NA     NA
      815    NA    NA     NA
      816    NA    NA     NA
      817    NA    NA     NA
      818    NA    NA     NA
      819    NA    NA     NA
      820    NA    NA     NA
      821    NA    NA     NA
      822    NA    NA     NA
      823    NA    NA     NA
      824    NA    NA     NA
      825    NA    NA     NA
      826    NA    NA     NA
      827    NA    NA     NA
      828    NA    NA     NA
      829    NA    NA     NA
      830    NA    NA     NA
      831    NA    NA     NA
      832    NA    NA     NA
      833    NA    NA     NA
      834    NA    NA     NA
      835    NA    NA     NA
      836    NA    NA     NA
      837    NA    NA     NA
      838    NA    NA     NA
      839    NA    NA     NA
      840    NA    NA     NA
      841    NA    NA     NA
      842    NA    NA     NA
      843    NA    NA     NA
      844    NA    NA     NA
      845    NA    NA     NA
      846    NA    NA     NA
      847    NA    NA     NA
      848    NA    NA     NA
      849    NA    NA     NA
      850    NA    NA     NA
      851    NA    NA     NA
      852    NA    NA     NA
      853    NA    NA     NA
      854    NA    NA     NA
      855    NA    NA     NA
      856    NA    NA     NA
      857    NA    NA     NA
      858    NA    NA     NA
      859    NA    NA     NA
      860    NA    NA     NA
      861    NA    NA     NA
      862    NA    NA     NA
      863    NA    NA     NA
      864    NA    NA     NA
      865    NA    NA     NA
      866    NA    NA     NA
      867    NA    NA     NA
      868    NA    NA     NA
      869    NA    NA     NA
      870    NA    NA     NA
      871    NA    NA     NA
      872    NA    NA     NA
      873    NA    NA     NA
      874    NA    NA     NA
      875    NA    NA     NA
      876    NA    NA     NA
      877    NA    NA     NA
      878    NA    NA     NA
      879    NA    NA     NA
      880    NA    NA     NA
      881    NA    NA     NA
      882    NA    NA     NA
      883    NA    NA     NA
      884    NA    NA     NA
      885    NA    NA     NA
      886    NA    NA     NA
      887    NA    NA     NA
      888    NA    NA     NA
      889    NA    NA     NA
      890    NA    NA     NA
      891    NA    NA     NA
      892    NA    NA     NA
      893    NA    NA     NA
      894    NA    NA     NA
      895    NA    NA     NA
      896    NA    NA     NA
      897    NA    NA     NA
      898    NA    NA     NA
      899    NA    NA     NA
      900    NA    NA     NA
      901    NA    NA     NA
      902    NA    NA     NA
      903    NA    NA     NA
      904    NA    NA     NA
      905    NA    NA     NA
      906    NA    NA     NA
      907    NA    NA     NA
      908    NA    NA     NA
      909    NA    NA     NA
      910    NA    NA     NA
      911    NA    NA     NA
      912    NA    NA     NA
      913    NA    NA     NA
      914    NA    NA     NA
      915    NA    NA     NA
      916    NA    NA     NA
      917    NA    NA     NA
      918    NA    NA     NA
      919    NA    NA     NA
      920    NA    NA     NA
      921    NA    NA     NA
      922    NA    NA     NA
      923    NA    NA     NA
      924    NA    NA     NA
      925    NA    NA     NA
      926    NA    NA     NA
      927    NA    NA     NA
      928    NA    NA     NA
      929    NA    NA     NA
      930    NA    NA     NA
      931    NA    NA     NA
      932    NA    NA     NA
      933    NA    NA     NA
      934    NA    NA     NA
      935    NA    NA     NA
      936    NA    NA     NA
      937    NA    NA     NA
      938    NA    NA     NA
      939    NA    NA     NA
      940    NA    NA     NA
      941    NA    NA     NA
      942    NA    NA     NA
      943    NA    NA     NA
      944    NA    NA     NA
      945    NA    NA     NA
      946    NA    NA     NA
      947    NA    NA     NA
      948    NA    NA     NA
      949    NA    NA     NA
      950    NA    NA     NA
      951    NA    NA     NA
      952    NA    NA     NA
      953    NA    NA     NA
      954    NA    NA     NA
      955    NA    NA     NA
      956    NA    NA     NA
      957    NA    NA     NA
      958    NA    NA     NA
      959    NA    NA     NA
      960    NA    NA     NA
      
      $Asia$d2$`mpg:gear`
            fill  x y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FFBBBB  2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #FFBBBB  2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #FFBBBB  2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFBBBB  3 1     1     7  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      8  #FFBBBB  3 1     1     7  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      9  #FFBBBB  3 1     1     7  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      10 #FFBBBB  4 1     1    10  3.5  4.5  0.5  1.5     NA       0.1        1    NA
      11 #FFBBBB  4 1     1    10  3.5  4.5  0.5  1.5     NA       0.1        1    NA
      12 #FFBBBB  4 1     1    10  3.5  4.5  0.5  1.5     NA       0.1        1    NA
      13 #FFBBBB  5 1     1    13  4.5  5.5  0.5  1.5     NA       0.1        1    NA
      14 #FFBBBB  5 1     1    13  4.5  5.5  0.5  1.5     NA       0.1        1    NA
      15 #FFBBBB  5 1     1    13  4.5  5.5  0.5  1.5     NA       0.1        1    NA
      16 #FFBBBB  6 1     1    16  5.5  6.5  0.5  1.5     NA       0.1        1    NA
      17 #FFBBBB  6 1     1    16  5.5  6.5  0.5  1.5     NA       0.1        1    NA
      18 #FFBBBB  6 1     1    16  5.5  6.5  0.5  1.5     NA       0.1        1    NA
      19 #FFBBBB  7 1     1    19  6.5  7.5  0.5  1.5     NA       0.1        1    NA
      20 #FFBBBB  7 1     1    19  6.5  7.5  0.5  1.5     NA       0.1        1    NA
      21 #FFBBBB  7 1     1    19  6.5  7.5  0.5  1.5     NA       0.1        1    NA
      22 #FFBBBB  8 1     1    22  7.5  8.5  0.5  1.5     NA       0.1        1    NA
      23 #FFBBBB  8 1     1    22  7.5  8.5  0.5  1.5     NA       0.1        1    NA
      24 #FFBBBB  8 1     1    22  7.5  8.5  0.5  1.5     NA       0.1        1    NA
      25 #FFBBBB  9 1     1    25  8.5  9.5  0.5  1.5     NA       0.1        1    NA
      26 #FFBBBB  9 1     1    25  8.5  9.5  0.5  1.5     NA       0.1        1    NA
      27 #FFBBBB  9 1     1    25  8.5  9.5  0.5  1.5     NA       0.1        1    NA
      28 #FFBBBB 10 1     1    28  9.5 10.5  0.5  1.5     NA       0.1        1    NA
      29 #FFBBBB 10 1     1    28  9.5 10.5  0.5  1.5     NA       0.1        1    NA
      30 #FFBBBB 10 1     1    28  9.5 10.5  0.5  1.5     NA       0.1        1    NA
      31 #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      32 #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      33 #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      34 #FFBBBB  2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      35 #FFBBBB  2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      36 #FFBBBB  2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      37 #FFBBBB  3 2     1     8  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      38 #FFBBBB  3 2     1     8  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      39 #FFBBBB  3 2     1     8  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      40 #FFBBBB  4 2     1    11  3.5  4.5  1.5  2.5     NA       0.1        1    NA
      41 #FFBBBB  4 2     1    11  3.5  4.5  1.5  2.5     NA       0.1        1    NA
      42 #FFBBBB  4 2     1    11  3.5  4.5  1.5  2.5     NA       0.1        1    NA
      43 #FFBBBB  5 2     1    14  4.5  5.5  1.5  2.5     NA       0.1        1    NA
      44 #FFBBBB  5 2     1    14  4.5  5.5  1.5  2.5     NA       0.1        1    NA
      45 #FFBBBB  5 2     1    14  4.5  5.5  1.5  2.5     NA       0.1        1    NA
      46 #FFBBBB  6 2     1    17  5.5  6.5  1.5  2.5     NA       0.1        1    NA
      47 #FFBBBB  6 2     1    17  5.5  6.5  1.5  2.5     NA       0.1        1    NA
      48 #FFBBBB  6 2     1    17  5.5  6.5  1.5  2.5     NA       0.1        1    NA
      49 #FFBBBB  7 2     1    20  6.5  7.5  1.5  2.5     NA       0.1        1    NA
      50 #FFBBBB  7 2     1    20  6.5  7.5  1.5  2.5     NA       0.1        1    NA
      51 #FFBBBB  7 2     1    20  6.5  7.5  1.5  2.5     NA       0.1        1    NA
      52 #FFBBBB  8 2     1    23  7.5  8.5  1.5  2.5     NA       0.1        1    NA
      53 #FFBBBB  8 2     1    23  7.5  8.5  1.5  2.5     NA       0.1        1    NA
      54 #FFBBBB  8 2     1    23  7.5  8.5  1.5  2.5     NA       0.1        1    NA
      55 #FFBBBB  9 2     1    26  8.5  9.5  1.5  2.5     NA       0.1        1    NA
      56 #FFBBBB  9 2     1    26  8.5  9.5  1.5  2.5     NA       0.1        1    NA
      57 #FFBBBB  9 2     1    26  8.5  9.5  1.5  2.5     NA       0.1        1    NA
      58 #FFBBBB 10 2     1    29  9.5 10.5  1.5  2.5     NA       0.1        1    NA
      59 #FFBBBB 10 2     1    29  9.5 10.5  1.5  2.5     NA       0.1        1    NA
      60 #FFBBBB 10 2     1    29  9.5 10.5  1.5  2.5     NA       0.1        1    NA
      61 #FFBBBB  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      62 #FFBBBB  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      63 #FFBBBB  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      64 #FFBBBB  2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      65 #FFBBBB  2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      66 #FFBBBB  2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      67 #FFBBBB  3 3     1     9  2.5  3.5  2.5  3.5     NA       0.1        1    NA
      68 #FFBBBB  3 3     1     9  2.5  3.5  2.5  3.5     NA       0.1        1    NA
      69 #FFBBBB  3 3     1     9  2.5  3.5  2.5  3.5     NA       0.1        1    NA
      70 #FFBBBB  4 3     1    12  3.5  4.5  2.5  3.5     NA       0.1        1    NA
      71 #FFBBBB  4 3     1    12  3.5  4.5  2.5  3.5     NA       0.1        1    NA
      72 #FFBBBB  4 3     1    12  3.5  4.5  2.5  3.5     NA       0.1        1    NA
      73 #FFBBBB  5 3     1    15  4.5  5.5  2.5  3.5     NA       0.1        1    NA
      74 #FFBBBB  5 3     1    15  4.5  5.5  2.5  3.5     NA       0.1        1    NA
      75 #FFBBBB  5 3     1    15  4.5  5.5  2.5  3.5     NA       0.1        1    NA
      76 #FFBBBB  6 3     1    18  5.5  6.5  2.5  3.5     NA       0.1        1    NA
      77 #FFBBBB  6 3     1    18  5.5  6.5  2.5  3.5     NA       0.1        1    NA
      78 #FFBBBB  6 3     1    18  5.5  6.5  2.5  3.5     NA       0.1        1    NA
      79 #FFBBBB  7 3     1    21  6.5  7.5  2.5  3.5     NA       0.1        1    NA
      80 #FFBBBB  7 3     1    21  6.5  7.5  2.5  3.5     NA       0.1        1    NA
      81 #FFBBBB  7 3     1    21  6.5  7.5  2.5  3.5     NA       0.1        1    NA
      82 #FFBBBB  8 3     1    24  7.5  8.5  2.5  3.5     NA       0.1        1    NA
      83 #FFBBBB  8 3     1    24  7.5  8.5  2.5  3.5     NA       0.1        1    NA
      84 #FFBBBB  8 3     1    24  7.5  8.5  2.5  3.5     NA       0.1        1    NA
      85 #FFBBBB  9 3     1    27  8.5  9.5  2.5  3.5     NA       0.1        1    NA
      86 #FFBBBB  9 3     1    27  8.5  9.5  2.5  3.5     NA       0.1        1    NA
      87 #FFBBBB  9 3     1    27  8.5  9.5  2.5  3.5     NA       0.1        1    NA
      88 #FFBBBB 10 3     1    30  9.5 10.5  2.5  3.5     NA       0.1        1    NA
      89 #FFBBBB 10 3     1    30  9.5 10.5  2.5  3.5     NA       0.1        1    NA
      90 #FFBBBB 10 3     1    30  9.5 10.5  2.5  3.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      19    NA     NA
      20    NA     NA
      21    NA     NA
      22    NA     NA
      23    NA     NA
      24    NA     NA
      25    NA     NA
      26    NA     NA
      27    NA     NA
      28    NA     NA
      29    NA     NA
      30    NA     NA
      31    NA     NA
      32    NA     NA
      33    NA     NA
      34    NA     NA
      35    NA     NA
      36    NA     NA
      37    NA     NA
      38    NA     NA
      39    NA     NA
      40    NA     NA
      41    NA     NA
      42    NA     NA
      43    NA     NA
      44    NA     NA
      45    NA     NA
      46    NA     NA
      47    NA     NA
      48    NA     NA
      49    NA     NA
      50    NA     NA
      51    NA     NA
      52    NA     NA
      53    NA     NA
      54    NA     NA
      55    NA     NA
      56    NA     NA
      57    NA     NA
      58    NA     NA
      59    NA     NA
      60    NA     NA
      61    NA     NA
      62    NA     NA
      63    NA     NA
      64    NA     NA
      65    NA     NA
      66    NA     NA
      67    NA     NA
      68    NA     NA
      69    NA     NA
      70    NA     NA
      71    NA     NA
      72    NA     NA
      73    NA     NA
      74    NA     NA
      75    NA     NA
      76    NA     NA
      77    NA     NA
      78    NA     NA
      79    NA     NA
      80    NA     NA
      81    NA     NA
      82    NA     NA
      83    NA     NA
      84    NA     NA
      85    NA     NA
      86    NA     NA
      87    NA     NA
      88    NA     NA
      89    NA     NA
      90    NA     NA
      
      $Asia$d2$`mpg:carb`
             fill  x y PANEL group xmin xmax ymin ymax colour linewidth linetype
      1   #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      2   #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      3   #FFBBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      4   #FFBBBB  2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1
      5   #FFBBBB  2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1
      6   #FFBBBB  2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1
      7   #FFBBBB  3 1     1    11  2.5  3.5  0.5  1.5     NA       0.1        1
      8   #FFBBBB  3 1     1    11  2.5  3.5  0.5  1.5     NA       0.1        1
      9   #FFBBBB  3 1     1    11  2.5  3.5  0.5  1.5     NA       0.1        1
      10  #FFBBBB  4 1     1    16  3.5  4.5  0.5  1.5     NA       0.1        1
      11  #FFBBBB  4 1     1    16  3.5  4.5  0.5  1.5     NA       0.1        1
      12  #FFBBBB  4 1     1    16  3.5  4.5  0.5  1.5     NA       0.1        1
      13  #FFBBBB  5 1     1    21  4.5  5.5  0.5  1.5     NA       0.1        1
      14  #FFBBBB  5 1     1    21  4.5  5.5  0.5  1.5     NA       0.1        1
      15  #FFBBBB  5 1     1    21  4.5  5.5  0.5  1.5     NA       0.1        1
      16  #FFBBBB  6 1     1    26  5.5  6.5  0.5  1.5     NA       0.1        1
      17  #FFBBBB  6 1     1    26  5.5  6.5  0.5  1.5     NA       0.1        1
      18  #FFBBBB  6 1     1    26  5.5  6.5  0.5  1.5     NA       0.1        1
      19  #FFBBBB  7 1     1    31  6.5  7.5  0.5  1.5     NA       0.1        1
      20  #FFBBBB  7 1     1    31  6.5  7.5  0.5  1.5     NA       0.1        1
      21  #FFBBBB  7 1     1    31  6.5  7.5  0.5  1.5     NA       0.1        1
      22  #FFBBBB  8 1     1    36  7.5  8.5  0.5  1.5     NA       0.1        1
      23  #FFBBBB  8 1     1    36  7.5  8.5  0.5  1.5     NA       0.1        1
      24  #FFBBBB  8 1     1    36  7.5  8.5  0.5  1.5     NA       0.1        1
      25  #FFBBBB  9 1     1    41  8.5  9.5  0.5  1.5     NA       0.1        1
      26  #FFBBBB  9 1     1    41  8.5  9.5  0.5  1.5     NA       0.1        1
      27  #FFBBBB  9 1     1    41  8.5  9.5  0.5  1.5     NA       0.1        1
      28  #FFBBBB 10 1     1    46  9.5 10.5  0.5  1.5     NA       0.1        1
      29  #FFBBBB 10 1     1    46  9.5 10.5  0.5  1.5     NA       0.1        1
      30  #FFBBBB 10 1     1    46  9.5 10.5  0.5  1.5     NA       0.1        1
      31  #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      32  #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      33  #FFBBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      34  #FFBBBB  2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1
      35  #FFBBBB  2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1
      36  #FFBBBB  2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1
      37  #FFBBBB  3 2     1    12  2.5  3.5  1.5  2.5     NA       0.1        1
      38  #FFBBBB  3 2     1    12  2.5  3.5  1.5  2.5     NA       0.1        1
      39  #FFBBBB  3 2     1    12  2.5  3.5  1.5  2.5     NA       0.1        1
      40  #FFBBBB  4 2     1    17  3.5  4.5  1.5  2.5     NA       0.1        1
      41  #FFBBBB  4 2     1    17  3.5  4.5  1.5  2.5     NA       0.1        1
      42  #FFBBBB  4 2     1    17  3.5  4.5  1.5  2.5     NA       0.1        1
      43  #FFBBBB  5 2     1    22  4.5  5.5  1.5  2.5     NA       0.1        1
      44  #FFBBBB  5 2     1    22  4.5  5.5  1.5  2.5     NA       0.1        1
      45  #FFBBBB  5 2     1    22  4.5  5.5  1.5  2.5     NA       0.1        1
      46  #FFBBBB  6 2     1    27  5.5  6.5  1.5  2.5     NA       0.1        1
      47  #FFBBBB  6 2     1    27  5.5  6.5  1.5  2.5     NA       0.1        1
      48  #FFBBBB  6 2     1    27  5.5  6.5  1.5  2.5     NA       0.1        1
      49  #FFBBBB  7 2     1    32  6.5  7.5  1.5  2.5     NA       0.1        1
      50  #FFBBBB  7 2     1    32  6.5  7.5  1.5  2.5     NA       0.1        1
      51  #FFBBBB  7 2     1    32  6.5  7.5  1.5  2.5     NA       0.1        1
      52  #FFBBBB  8 2     1    37  7.5  8.5  1.5  2.5     NA       0.1        1
      53  #FFBBBB  8 2     1    37  7.5  8.5  1.5  2.5     NA       0.1        1
      54  #FFBBBB  8 2     1    37  7.5  8.5  1.5  2.5     NA       0.1        1
      55  #FFBBBB  9 2     1    42  8.5  9.5  1.5  2.5     NA       0.1        1
      56  #FFBBBB  9 2     1    42  8.5  9.5  1.5  2.5     NA       0.1        1
      57  #FFBBBB  9 2     1    42  8.5  9.5  1.5  2.5     NA       0.1        1
      58  #FFBBBB 10 2     1    47  9.5 10.5  1.5  2.5     NA       0.1        1
      59  #FFBBBB 10 2     1    47  9.5 10.5  1.5  2.5     NA       0.1        1
      60  #FFBBBB 10 2     1    47  9.5 10.5  1.5  2.5     NA       0.1        1
      61  #FFBBBB  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      62  #FFBBBB  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      63  #FFBBBB  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      64  #FFBBBB  2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1
      65  #FFBBBB  2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1
      66  #FFBBBB  2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1
      67  #FFBBBB  3 3     1    13  2.5  3.5  2.5  3.5     NA       0.1        1
      68  #FFBBBB  3 3     1    13  2.5  3.5  2.5  3.5     NA       0.1        1
      69  #FFBBBB  3 3     1    13  2.5  3.5  2.5  3.5     NA       0.1        1
      70  #FFBBBB  4 3     1    18  3.5  4.5  2.5  3.5     NA       0.1        1
      71  #FFBBBB  4 3     1    18  3.5  4.5  2.5  3.5     NA       0.1        1
      72  #FFBBBB  4 3     1    18  3.5  4.5  2.5  3.5     NA       0.1        1
      73  #FFBBBB  5 3     1    23  4.5  5.5  2.5  3.5     NA       0.1        1
      74  #FFBBBB  5 3     1    23  4.5  5.5  2.5  3.5     NA       0.1        1
      75  #FFBBBB  5 3     1    23  4.5  5.5  2.5  3.5     NA       0.1        1
      76  #FFBBBB  6 3     1    28  5.5  6.5  2.5  3.5     NA       0.1        1
      77  #FFBBBB  6 3     1    28  5.5  6.5  2.5  3.5     NA       0.1        1
      78  #FFBBBB  6 3     1    28  5.5  6.5  2.5  3.5     NA       0.1        1
      79  #FFBBBB  7 3     1    33  6.5  7.5  2.5  3.5     NA       0.1        1
      80  #FFBBBB  7 3     1    33  6.5  7.5  2.5  3.5     NA       0.1        1
      81  #FFBBBB  7 3     1    33  6.5  7.5  2.5  3.5     NA       0.1        1
      82  #FFBBBB  8 3     1    38  7.5  8.5  2.5  3.5     NA       0.1        1
      83  #FFBBBB  8 3     1    38  7.5  8.5  2.5  3.5     NA       0.1        1
      84  #FFBBBB  8 3     1    38  7.5  8.5  2.5  3.5     NA       0.1        1
      85  #FFBBBB  9 3     1    43  8.5  9.5  2.5  3.5     NA       0.1        1
      86  #FFBBBB  9 3     1    43  8.5  9.5  2.5  3.5     NA       0.1        1
      87  #FFBBBB  9 3     1    43  8.5  9.5  2.5  3.5     NA       0.1        1
      88  #FFBBBB 10 3     1    48  9.5 10.5  2.5  3.5     NA       0.1        1
      89  #FFBBBB 10 3     1    48  9.5 10.5  2.5  3.5     NA       0.1        1
      90  #FFBBBB 10 3     1    48  9.5 10.5  2.5  3.5     NA       0.1        1
      91  #FFBBBB  1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      92  #FFBBBB  1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      93  #FFBBBB  1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      94  #FFBBBB  2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1
      95  #FFBBBB  2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1
      96  #FFBBBB  2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1
      97  #FFBBBB  3 4     1    14  2.5  3.5  3.5  4.5     NA       0.1        1
      98  #FFBBBB  3 4     1    14  2.5  3.5  3.5  4.5     NA       0.1        1
      99  #FFBBBB  3 4     1    14  2.5  3.5  3.5  4.5     NA       0.1        1
      100 #FFBBBB  4 4     1    19  3.5  4.5  3.5  4.5     NA       0.1        1
      101 #FFBBBB  4 4     1    19  3.5  4.5  3.5  4.5     NA       0.1        1
      102 #FFBBBB  4 4     1    19  3.5  4.5  3.5  4.5     NA       0.1        1
      103 #FFBBBB  5 4     1    24  4.5  5.5  3.5  4.5     NA       0.1        1
      104 #FFBBBB  5 4     1    24  4.5  5.5  3.5  4.5     NA       0.1        1
      105 #FFBBBB  5 4     1    24  4.5  5.5  3.5  4.5     NA       0.1        1
      106 #FFBBBB  6 4     1    29  5.5  6.5  3.5  4.5     NA       0.1        1
      107 #FFBBBB  6 4     1    29  5.5  6.5  3.5  4.5     NA       0.1        1
      108 #FFBBBB  6 4     1    29  5.5  6.5  3.5  4.5     NA       0.1        1
      109 #FFBBBB  7 4     1    34  6.5  7.5  3.5  4.5     NA       0.1        1
      110 #FFBBBB  7 4     1    34  6.5  7.5  3.5  4.5     NA       0.1        1
      111 #FFBBBB  7 4     1    34  6.5  7.5  3.5  4.5     NA       0.1        1
      112 #FFBBBB  8 4     1    39  7.5  8.5  3.5  4.5     NA       0.1        1
      113 #FFBBBB  8 4     1    39  7.5  8.5  3.5  4.5     NA       0.1        1
      114 #FFBBBB  8 4     1    39  7.5  8.5  3.5  4.5     NA       0.1        1
      115 #FFBBBB  9 4     1    44  8.5  9.5  3.5  4.5     NA       0.1        1
      116 #FFBBBB  9 4     1    44  8.5  9.5  3.5  4.5     NA       0.1        1
      117 #FFBBBB  9 4     1    44  8.5  9.5  3.5  4.5     NA       0.1        1
      118 #FFBBBB 10 4     1    49  9.5 10.5  3.5  4.5     NA       0.1        1
      119 #FFBBBB 10 4     1    49  9.5 10.5  3.5  4.5     NA       0.1        1
      120 #FFBBBB 10 4     1    49  9.5 10.5  3.5  4.5     NA       0.1        1
      121 #FFBBBB  1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      122 #FFBBBB  1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      123 #FFBBBB  1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      124 #FFBBBB  2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1
      125 #FFBBBB  2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1
      126 #FFBBBB  2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1
      127 #FFBBBB  3 5     1    15  2.5  3.5  4.5  5.5     NA       0.1        1
      128 #FFBBBB  3 5     1    15  2.5  3.5  4.5  5.5     NA       0.1        1
      129 #FFBBBB  3 5     1    15  2.5  3.5  4.5  5.5     NA       0.1        1
      130 #FFBBBB  4 5     1    20  3.5  4.5  4.5  5.5     NA       0.1        1
      131 #FFBBBB  4 5     1    20  3.5  4.5  4.5  5.5     NA       0.1        1
      132 #FFBBBB  4 5     1    20  3.5  4.5  4.5  5.5     NA       0.1        1
      133 #FFBBBB  5 5     1    25  4.5  5.5  4.5  5.5     NA       0.1        1
      134 #FFBBBB  5 5     1    25  4.5  5.5  4.5  5.5     NA       0.1        1
      135 #FFBBBB  5 5     1    25  4.5  5.5  4.5  5.5     NA       0.1        1
      136 #FFBBBB  6 5     1    30  5.5  6.5  4.5  5.5     NA       0.1        1
      137 #FFBBBB  6 5     1    30  5.5  6.5  4.5  5.5     NA       0.1        1
      138 #FFBBBB  6 5     1    30  5.5  6.5  4.5  5.5     NA       0.1        1
      139 #FFBBBB  7 5     1    35  6.5  7.5  4.5  5.5     NA       0.1        1
      140 #FFBBBB  7 5     1    35  6.5  7.5  4.5  5.5     NA       0.1        1
      141 #FFBBBB  7 5     1    35  6.5  7.5  4.5  5.5     NA       0.1        1
      142 #FFBBBB  8 5     1    40  7.5  8.5  4.5  5.5     NA       0.1        1
      143 #FFBBBB  8 5     1    40  7.5  8.5  4.5  5.5     NA       0.1        1
      144 #FFBBBB  8 5     1    40  7.5  8.5  4.5  5.5     NA       0.1        1
      145 #FFBBBB  9 5     1    45  8.5  9.5  4.5  5.5     NA       0.1        1
      146 #FFBBBB  9 5     1    45  8.5  9.5  4.5  5.5     NA       0.1        1
      147 #FFBBBB  9 5     1    45  8.5  9.5  4.5  5.5     NA       0.1        1
      148 #FFBBBB 10 5     1    50  9.5 10.5  4.5  5.5     NA       0.1        1
      149 #FFBBBB 10 5     1    50  9.5 10.5  4.5  5.5     NA       0.1        1
      150 #FFBBBB 10 5     1    50  9.5 10.5  4.5  5.5     NA       0.1        1
          alpha width height
      1      NA    NA     NA
      2      NA    NA     NA
      3      NA    NA     NA
      4      NA    NA     NA
      5      NA    NA     NA
      6      NA    NA     NA
      7      NA    NA     NA
      8      NA    NA     NA
      9      NA    NA     NA
      10     NA    NA     NA
      11     NA    NA     NA
      12     NA    NA     NA
      13     NA    NA     NA
      14     NA    NA     NA
      15     NA    NA     NA
      16     NA    NA     NA
      17     NA    NA     NA
      18     NA    NA     NA
      19     NA    NA     NA
      20     NA    NA     NA
      21     NA    NA     NA
      22     NA    NA     NA
      23     NA    NA     NA
      24     NA    NA     NA
      25     NA    NA     NA
      26     NA    NA     NA
      27     NA    NA     NA
      28     NA    NA     NA
      29     NA    NA     NA
      30     NA    NA     NA
      31     NA    NA     NA
      32     NA    NA     NA
      33     NA    NA     NA
      34     NA    NA     NA
      35     NA    NA     NA
      36     NA    NA     NA
      37     NA    NA     NA
      38     NA    NA     NA
      39     NA    NA     NA
      40     NA    NA     NA
      41     NA    NA     NA
      42     NA    NA     NA
      43     NA    NA     NA
      44     NA    NA     NA
      45     NA    NA     NA
      46     NA    NA     NA
      47     NA    NA     NA
      48     NA    NA     NA
      49     NA    NA     NA
      50     NA    NA     NA
      51     NA    NA     NA
      52     NA    NA     NA
      53     NA    NA     NA
      54     NA    NA     NA
      55     NA    NA     NA
      56     NA    NA     NA
      57     NA    NA     NA
      58     NA    NA     NA
      59     NA    NA     NA
      60     NA    NA     NA
      61     NA    NA     NA
      62     NA    NA     NA
      63     NA    NA     NA
      64     NA    NA     NA
      65     NA    NA     NA
      66     NA    NA     NA
      67     NA    NA     NA
      68     NA    NA     NA
      69     NA    NA     NA
      70     NA    NA     NA
      71     NA    NA     NA
      72     NA    NA     NA
      73     NA    NA     NA
      74     NA    NA     NA
      75     NA    NA     NA
      76     NA    NA     NA
      77     NA    NA     NA
      78     NA    NA     NA
      79     NA    NA     NA
      80     NA    NA     NA
      81     NA    NA     NA
      82     NA    NA     NA
      83     NA    NA     NA
      84     NA    NA     NA
      85     NA    NA     NA
      86     NA    NA     NA
      87     NA    NA     NA
      88     NA    NA     NA
      89     NA    NA     NA
      90     NA    NA     NA
      91     NA    NA     NA
      92     NA    NA     NA
      93     NA    NA     NA
      94     NA    NA     NA
      95     NA    NA     NA
      96     NA    NA     NA
      97     NA    NA     NA
      98     NA    NA     NA
      99     NA    NA     NA
      100    NA    NA     NA
      101    NA    NA     NA
      102    NA    NA     NA
      103    NA    NA     NA
      104    NA    NA     NA
      105    NA    NA     NA
      106    NA    NA     NA
      107    NA    NA     NA
      108    NA    NA     NA
      109    NA    NA     NA
      110    NA    NA     NA
      111    NA    NA     NA
      112    NA    NA     NA
      113    NA    NA     NA
      114    NA    NA     NA
      115    NA    NA     NA
      116    NA    NA     NA
      117    NA    NA     NA
      118    NA    NA     NA
      119    NA    NA     NA
      120    NA    NA     NA
      121    NA    NA     NA
      122    NA    NA     NA
      123    NA    NA     NA
      124    NA    NA     NA
      125    NA    NA     NA
      126    NA    NA     NA
      127    NA    NA     NA
      128    NA    NA     NA
      129    NA    NA     NA
      130    NA    NA     NA
      131    NA    NA     NA
      132    NA    NA     NA
      133    NA    NA     NA
      134    NA    NA     NA
      135    NA    NA     NA
      136    NA    NA     NA
      137    NA    NA     NA
      138    NA    NA     NA
      139    NA    NA     NA
      140    NA    NA     NA
      141    NA    NA     NA
      142    NA    NA     NA
      143    NA    NA     NA
      144    NA    NA     NA
      145    NA    NA     NA
      146    NA    NA     NA
      147    NA    NA     NA
      148    NA    NA     NA
      149    NA    NA     NA
      150    NA    NA     NA
      
      $Asia$d2$`mpg:wt`
             fill  x  y PANEL group xmin xmax ymin ymax colour linewidth linetype
      1   #FFBBBB  1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      2   #FFBBBB  1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      3   #FFBBBB  1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      4   #FFBBBB  2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1
      5   #FFBBBB  2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1
      6   #FFBBBB  2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1
      7   #FFBBBB  3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1
      8   #FFBBBB  3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1
      9   #FFBBBB  3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1
      10  #FFBBBB  4  1     1    31  3.5  4.5  0.5  1.5     NA       0.1        1
      11  #FFBBBB  4  1     1    31  3.5  4.5  0.5  1.5     NA       0.1        1
      12  #FFBBBB  4  1     1    31  3.5  4.5  0.5  1.5     NA       0.1        1
      13  #FFBBBB  5  1     1    41  4.5  5.5  0.5  1.5     NA       0.1        1
      14  #FFBBBB  5  1     1    41  4.5  5.5  0.5  1.5     NA       0.1        1
      15  #FFBBBB  5  1     1    41  4.5  5.5  0.5  1.5     NA       0.1        1
      16  #FFBBBB  6  1     1    51  5.5  6.5  0.5  1.5     NA       0.1        1
      17  #FFBBBB  6  1     1    51  5.5  6.5  0.5  1.5     NA       0.1        1
      18  #FFBBBB  6  1     1    51  5.5  6.5  0.5  1.5     NA       0.1        1
      19  #FFBBBB  7  1     1    61  6.5  7.5  0.5  1.5     NA       0.1        1
      20  #FFBBBB  7  1     1    61  6.5  7.5  0.5  1.5     NA       0.1        1
      21  #FFBBBB  7  1     1    61  6.5  7.5  0.5  1.5     NA       0.1        1
      22  #FFBBBB  8  1     1    71  7.5  8.5  0.5  1.5     NA       0.1        1
      23  #FFBBBB  8  1     1    71  7.5  8.5  0.5  1.5     NA       0.1        1
      24  #FFBBBB  8  1     1    71  7.5  8.5  0.5  1.5     NA       0.1        1
      25  #FFBBBB  9  1     1    81  8.5  9.5  0.5  1.5     NA       0.1        1
      26  #FFBBBB  9  1     1    81  8.5  9.5  0.5  1.5     NA       0.1        1
      27  #FFBBBB  9  1     1    81  8.5  9.5  0.5  1.5     NA       0.1        1
      28  #FFBBBB 10  1     1    91  9.5 10.5  0.5  1.5     NA       0.1        1
      29  #FFBBBB 10  1     1    91  9.5 10.5  0.5  1.5     NA       0.1        1
      30  #FFBBBB 10  1     1    91  9.5 10.5  0.5  1.5     NA       0.1        1
      31  #FFBBBB  1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      32  #FFBBBB  1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      33  #FFBBBB  1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      34  #FFBBBB  2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1
      35  #FFBBBB  2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1
      36  #FFBBBB  2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1
      37  #FFBBBB  3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1
      38  #FFBBBB  3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1
      39  #FFBBBB  3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1
      40  #FFBBBB  4  2     1    32  3.5  4.5  1.5  2.5     NA       0.1        1
      41  #FFBBBB  4  2     1    32  3.5  4.5  1.5  2.5     NA       0.1        1
      42  #FFBBBB  4  2     1    32  3.5  4.5  1.5  2.5     NA       0.1        1
      43  #FFBBBB  5  2     1    42  4.5  5.5  1.5  2.5     NA       0.1        1
      44  #FFBBBB  5  2     1    42  4.5  5.5  1.5  2.5     NA       0.1        1
      45  #FFBBBB  5  2     1    42  4.5  5.5  1.5  2.5     NA       0.1        1
      46  #FFBBBB  6  2     1    52  5.5  6.5  1.5  2.5     NA       0.1        1
      47  #FFBBBB  6  2     1    52  5.5  6.5  1.5  2.5     NA       0.1        1
      48  #FFBBBB  6  2     1    52  5.5  6.5  1.5  2.5     NA       0.1        1
      49  #FFBBBB  7  2     1    62  6.5  7.5  1.5  2.5     NA       0.1        1
      50  #FFBBBB  7  2     1    62  6.5  7.5  1.5  2.5     NA       0.1        1
      51  #FFBBBB  7  2     1    62  6.5  7.5  1.5  2.5     NA       0.1        1
      52  #FFBBBB  8  2     1    72  7.5  8.5  1.5  2.5     NA       0.1        1
      53  #FFBBBB  8  2     1    72  7.5  8.5  1.5  2.5     NA       0.1        1
      54  #FFBBBB  8  2     1    72  7.5  8.5  1.5  2.5     NA       0.1        1
      55  #FFBBBB  9  2     1    82  8.5  9.5  1.5  2.5     NA       0.1        1
      56  #FFBBBB  9  2     1    82  8.5  9.5  1.5  2.5     NA       0.1        1
      57  #FFBBBB  9  2     1    82  8.5  9.5  1.5  2.5     NA       0.1        1
      58  #FFBBBB 10  2     1    92  9.5 10.5  1.5  2.5     NA       0.1        1
      59  #FFBBBB 10  2     1    92  9.5 10.5  1.5  2.5     NA       0.1        1
      60  #FFBBBB 10  2     1    92  9.5 10.5  1.5  2.5     NA       0.1        1
      61  #FFBBBB  1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      62  #FFBBBB  1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      63  #FFBBBB  1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      64  #FFBBBB  2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1
      65  #FFBBBB  2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1
      66  #FFBBBB  2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1
      67  #FFBBBB  3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1
      68  #FFBBBB  3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1
      69  #FFBBBB  3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1
      70  #FFBBBB  4  3     1    33  3.5  4.5  2.5  3.5     NA       0.1        1
      71  #FFBBBB  4  3     1    33  3.5  4.5  2.5  3.5     NA       0.1        1
      72  #FFBBBB  4  3     1    33  3.5  4.5  2.5  3.5     NA       0.1        1
      73  #FFBBBB  5  3     1    43  4.5  5.5  2.5  3.5     NA       0.1        1
      74  #FFBBBB  5  3     1    43  4.5  5.5  2.5  3.5     NA       0.1        1
      75  #FFBBBB  5  3     1    43  4.5  5.5  2.5  3.5     NA       0.1        1
      76  #FFBBBB  6  3     1    53  5.5  6.5  2.5  3.5     NA       0.1        1
      77  #FFBBBB  6  3     1    53  5.5  6.5  2.5  3.5     NA       0.1        1
      78  #FFBBBB  6  3     1    53  5.5  6.5  2.5  3.5     NA       0.1        1
      79  #FFBBBB  7  3     1    63  6.5  7.5  2.5  3.5     NA       0.1        1
      80  #FFBBBB  7  3     1    63  6.5  7.5  2.5  3.5     NA       0.1        1
      81  #FFBBBB  7  3     1    63  6.5  7.5  2.5  3.5     NA       0.1        1
      82  #FFBBBB  8  3     1    73  7.5  8.5  2.5  3.5     NA       0.1        1
      83  #FFBBBB  8  3     1    73  7.5  8.5  2.5  3.5     NA       0.1        1
      84  #FFBBBB  8  3     1    73  7.5  8.5  2.5  3.5     NA       0.1        1
      85  #FFBBBB  9  3     1    83  8.5  9.5  2.5  3.5     NA       0.1        1
      86  #FFBBBB  9  3     1    83  8.5  9.5  2.5  3.5     NA       0.1        1
      87  #FFBBBB  9  3     1    83  8.5  9.5  2.5  3.5     NA       0.1        1
      88  #FFBBBB 10  3     1    93  9.5 10.5  2.5  3.5     NA       0.1        1
      89  #FFBBBB 10  3     1    93  9.5 10.5  2.5  3.5     NA       0.1        1
      90  #FFBBBB 10  3     1    93  9.5 10.5  2.5  3.5     NA       0.1        1
      91  #FFBBBB  1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      92  #FFBBBB  1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      93  #FFBBBB  1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      94  #FFBBBB  2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1
      95  #FFBBBB  2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1
      96  #FFBBBB  2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1
      97  #FFBBBB  3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1
      98  #FFBBBB  3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1
      99  #FFBBBB  3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1
      100 #FFBBBB  4  4     1    34  3.5  4.5  3.5  4.5     NA       0.1        1
      101 #FFBBBB  4  4     1    34  3.5  4.5  3.5  4.5     NA       0.1        1
      102 #FFBBBB  4  4     1    34  3.5  4.5  3.5  4.5     NA       0.1        1
      103 #FFBBBB  5  4     1    44  4.5  5.5  3.5  4.5     NA       0.1        1
      104 #FFBBBB  5  4     1    44  4.5  5.5  3.5  4.5     NA       0.1        1
      105 #FFBBBB  5  4     1    44  4.5  5.5  3.5  4.5     NA       0.1        1
      106 #FFBBBB  6  4     1    54  5.5  6.5  3.5  4.5     NA       0.1        1
      107 #FFBBBB  6  4     1    54  5.5  6.5  3.5  4.5     NA       0.1        1
      108 #FFBBBB  6  4     1    54  5.5  6.5  3.5  4.5     NA       0.1        1
      109 #FFBBBB  7  4     1    64  6.5  7.5  3.5  4.5     NA       0.1        1
      110 #FFBBBB  7  4     1    64  6.5  7.5  3.5  4.5     NA       0.1        1
      111 #FFBBBB  7  4     1    64  6.5  7.5  3.5  4.5     NA       0.1        1
      112 #FFBBBB  8  4     1    74  7.5  8.5  3.5  4.5     NA       0.1        1
      113 #FFBBBB  8  4     1    74  7.5  8.5  3.5  4.5     NA       0.1        1
      114 #FFBBBB  8  4     1    74  7.5  8.5  3.5  4.5     NA       0.1        1
      115 #FFBBBB  9  4     1    84  8.5  9.5  3.5  4.5     NA       0.1        1
      116 #FFBBBB  9  4     1    84  8.5  9.5  3.5  4.5     NA       0.1        1
      117 #FFBBBB  9  4     1    84  8.5  9.5  3.5  4.5     NA       0.1        1
      118 #FFBBBB 10  4     1    94  9.5 10.5  3.5  4.5     NA       0.1        1
      119 #FFBBBB 10  4     1    94  9.5 10.5  3.5  4.5     NA       0.1        1
      120 #FFBBBB 10  4     1    94  9.5 10.5  3.5  4.5     NA       0.1        1
      121 #FFBBBB  1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      122 #FFBBBB  1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      123 #FFBBBB  1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      124 #FFBBBB  2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1
      125 #FFBBBB  2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1
      126 #FFBBBB  2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1
      127 #FFBBBB  3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1
      128 #FFBBBB  3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1
      129 #FFBBBB  3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1
      130 #FFBBBB  4  5     1    35  3.5  4.5  4.5  5.5     NA       0.1        1
      131 #FFBBBB  4  5     1    35  3.5  4.5  4.5  5.5     NA       0.1        1
      132 #FFBBBB  4  5     1    35  3.5  4.5  4.5  5.5     NA       0.1        1
      133 #FFBBBB  5  5     1    45  4.5  5.5  4.5  5.5     NA       0.1        1
      134 #FFBBBB  5  5     1    45  4.5  5.5  4.5  5.5     NA       0.1        1
      135 #FFBBBB  5  5     1    45  4.5  5.5  4.5  5.5     NA       0.1        1
      136 #FFBBBB  6  5     1    55  5.5  6.5  4.5  5.5     NA       0.1        1
      137 #FFBBBB  6  5     1    55  5.5  6.5  4.5  5.5     NA       0.1        1
      138 #FFBBBB  6  5     1    55  5.5  6.5  4.5  5.5     NA       0.1        1
      139 #FFBBBB  7  5     1    65  6.5  7.5  4.5  5.5     NA       0.1        1
      140 #FFBBBB  7  5     1    65  6.5  7.5  4.5  5.5     NA       0.1        1
      141 #FFBBBB  7  5     1    65  6.5  7.5  4.5  5.5     NA       0.1        1
      142 #FFBBBB  8  5     1    75  7.5  8.5  4.5  5.5     NA       0.1        1
      143 #FFBBBB  8  5     1    75  7.5  8.5  4.5  5.5     NA       0.1        1
      144 #FFBBBB  8  5     1    75  7.5  8.5  4.5  5.5     NA       0.1        1
      145 #FFBBBB  9  5     1    85  8.5  9.5  4.5  5.5     NA       0.1        1
      146 #FFBBBB  9  5     1    85  8.5  9.5  4.5  5.5     NA       0.1        1
      147 #FFBBBB  9  5     1    85  8.5  9.5  4.5  5.5     NA       0.1        1
      148 #FFBBBB 10  5     1    95  9.5 10.5  4.5  5.5     NA       0.1        1
      149 #FFBBBB 10  5     1    95  9.5 10.5  4.5  5.5     NA       0.1        1
      150 #FFBBBB 10  5     1    95  9.5 10.5  4.5  5.5     NA       0.1        1
      151 #FFBBBB  1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      152 #FFBBBB  1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      153 #FFBBBB  1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      154 #FFBBBB  2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1
      155 #FFBBBB  2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1
      156 #FFBBBB  2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1
      157 #FFBBBB  3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1
      158 #FFBBBB  3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1
      159 #FFBBBB  3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1
      160 #FFBBBB  4  6     1    36  3.5  4.5  5.5  6.5     NA       0.1        1
      161 #FFBBBB  4  6     1    36  3.5  4.5  5.5  6.5     NA       0.1        1
      162 #FFBBBB  4  6     1    36  3.5  4.5  5.5  6.5     NA       0.1        1
      163 #FFBBBB  5  6     1    46  4.5  5.5  5.5  6.5     NA       0.1        1
      164 #FFBBBB  5  6     1    46  4.5  5.5  5.5  6.5     NA       0.1        1
      165 #FFBBBB  5  6     1    46  4.5  5.5  5.5  6.5     NA       0.1        1
      166 #FFBBBB  6  6     1    56  5.5  6.5  5.5  6.5     NA       0.1        1
      167 #FFBBBB  6  6     1    56  5.5  6.5  5.5  6.5     NA       0.1        1
      168 #FFBBBB  6  6     1    56  5.5  6.5  5.5  6.5     NA       0.1        1
      169 #FFBBBB  7  6     1    66  6.5  7.5  5.5  6.5     NA       0.1        1
      170 #FFBBBB  7  6     1    66  6.5  7.5  5.5  6.5     NA       0.1        1
      171 #FFBBBB  7  6     1    66  6.5  7.5  5.5  6.5     NA       0.1        1
      172 #FFBBBB  8  6     1    76  7.5  8.5  5.5  6.5     NA       0.1        1
      173 #FFBBBB  8  6     1    76  7.5  8.5  5.5  6.5     NA       0.1        1
      174 #FFBBBB  8  6     1    76  7.5  8.5  5.5  6.5     NA       0.1        1
      175 #FFBBBB  9  6     1    86  8.5  9.5  5.5  6.5     NA       0.1        1
      176 #FFBBBB  9  6     1    86  8.5  9.5  5.5  6.5     NA       0.1        1
      177 #FFBBBB  9  6     1    86  8.5  9.5  5.5  6.5     NA       0.1        1
      178 #FFBBBB 10  6     1    96  9.5 10.5  5.5  6.5     NA       0.1        1
      179 #FFBBBB 10  6     1    96  9.5 10.5  5.5  6.5     NA       0.1        1
      180 #FFBBBB 10  6     1    96  9.5 10.5  5.5  6.5     NA       0.1        1
      181 #FFBBBB  1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      182 #FFBBBB  1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      183 #FFBBBB  1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      184 #FFBBBB  2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1
      185 #FFBBBB  2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1
      186 #FFBBBB  2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1
      187 #FFBBBB  3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1
      188 #FFBBBB  3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1
      189 #FFBBBB  3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1
      190 #FFBBBB  4  7     1    37  3.5  4.5  6.5  7.5     NA       0.1        1
      191 #FFBBBB  4  7     1    37  3.5  4.5  6.5  7.5     NA       0.1        1
      192 #FFBBBB  4  7     1    37  3.5  4.5  6.5  7.5     NA       0.1        1
      193 #FFBBBB  5  7     1    47  4.5  5.5  6.5  7.5     NA       0.1        1
      194 #FFBBBB  5  7     1    47  4.5  5.5  6.5  7.5     NA       0.1        1
      195 #FFBBBB  5  7     1    47  4.5  5.5  6.5  7.5     NA       0.1        1
      196 #FFBBBB  6  7     1    57  5.5  6.5  6.5  7.5     NA       0.1        1
      197 #FFBBBB  6  7     1    57  5.5  6.5  6.5  7.5     NA       0.1        1
      198 #FFBBBB  6  7     1    57  5.5  6.5  6.5  7.5     NA       0.1        1
      199 #FFBBBB  7  7     1    67  6.5  7.5  6.5  7.5     NA       0.1        1
      200 #FFBBBB  7  7     1    67  6.5  7.5  6.5  7.5     NA       0.1        1
      201 #FFBBBB  7  7     1    67  6.5  7.5  6.5  7.5     NA       0.1        1
      202 #FFBBBB  8  7     1    77  7.5  8.5  6.5  7.5     NA       0.1        1
      203 #FFBBBB  8  7     1    77  7.5  8.5  6.5  7.5     NA       0.1        1
      204 #FFBBBB  8  7     1    77  7.5  8.5  6.5  7.5     NA       0.1        1
      205 #FFBBBB  9  7     1    87  8.5  9.5  6.5  7.5     NA       0.1        1
      206 #FFBBBB  9  7     1    87  8.5  9.5  6.5  7.5     NA       0.1        1
      207 #FFBBBB  9  7     1    87  8.5  9.5  6.5  7.5     NA       0.1        1
      208 #FFBBBB 10  7     1    97  9.5 10.5  6.5  7.5     NA       0.1        1
      209 #FFBBBB 10  7     1    97  9.5 10.5  6.5  7.5     NA       0.1        1
      210 #FFBBBB 10  7     1    97  9.5 10.5  6.5  7.5     NA       0.1        1
      211 #FFBBBB  1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      212 #FFBBBB  1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      213 #FFBBBB  1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      214 #FFBBBB  2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1
      215 #FFBBBB  2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1
      216 #FFBBBB  2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1
      217 #FFBBBB  3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1
      218 #FFBBBB  3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1
      219 #FFBBBB  3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1
      220 #FFBBBB  4  8     1    38  3.5  4.5  7.5  8.5     NA       0.1        1
      221 #FFBBBB  4  8     1    38  3.5  4.5  7.5  8.5     NA       0.1        1
      222 #FFBBBB  4  8     1    38  3.5  4.5  7.5  8.5     NA       0.1        1
      223 #FFBBBB  5  8     1    48  4.5  5.5  7.5  8.5     NA       0.1        1
      224 #FFBBBB  5  8     1    48  4.5  5.5  7.5  8.5     NA       0.1        1
      225 #FFBBBB  5  8     1    48  4.5  5.5  7.5  8.5     NA       0.1        1
      226 #FFBBBB  6  8     1    58  5.5  6.5  7.5  8.5     NA       0.1        1
      227 #FFBBBB  6  8     1    58  5.5  6.5  7.5  8.5     NA       0.1        1
      228 #FFBBBB  6  8     1    58  5.5  6.5  7.5  8.5     NA       0.1        1
      229 #FFBBBB  7  8     1    68  6.5  7.5  7.5  8.5     NA       0.1        1
      230 #FFBBBB  7  8     1    68  6.5  7.5  7.5  8.5     NA       0.1        1
      231 #FFBBBB  7  8     1    68  6.5  7.5  7.5  8.5     NA       0.1        1
      232 #FFBBBB  8  8     1    78  7.5  8.5  7.5  8.5     NA       0.1        1
      233 #FFBBBB  8  8     1    78  7.5  8.5  7.5  8.5     NA       0.1        1
      234 #FFBBBB  8  8     1    78  7.5  8.5  7.5  8.5     NA       0.1        1
      235 #FFBBBB  9  8     1    88  8.5  9.5  7.5  8.5     NA       0.1        1
      236 #FFBBBB  9  8     1    88  8.5  9.5  7.5  8.5     NA       0.1        1
      237 #FFBBBB  9  8     1    88  8.5  9.5  7.5  8.5     NA       0.1        1
      238 #FFBBBB 10  8     1    98  9.5 10.5  7.5  8.5     NA       0.1        1
      239 #FFBBBB 10  8     1    98  9.5 10.5  7.5  8.5     NA       0.1        1
      240 #FFBBBB 10  8     1    98  9.5 10.5  7.5  8.5     NA       0.1        1
      241 #FFBBBB  1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      242 #FFBBBB  1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      243 #FFBBBB  1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      244 #FFBBBB  2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1
      245 #FFBBBB  2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1
      246 #FFBBBB  2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1
      247 #FFBBBB  3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1
      248 #FFBBBB  3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1
      249 #FFBBBB  3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1
      250 #FFBBBB  4  9     1    39  3.5  4.5  8.5  9.5     NA       0.1        1
      251 #FFBBBB  4  9     1    39  3.5  4.5  8.5  9.5     NA       0.1        1
      252 #FFBBBB  4  9     1    39  3.5  4.5  8.5  9.5     NA       0.1        1
      253 #FFBBBB  5  9     1    49  4.5  5.5  8.5  9.5     NA       0.1        1
      254 #FFBBBB  5  9     1    49  4.5  5.5  8.5  9.5     NA       0.1        1
      255 #FFBBBB  5  9     1    49  4.5  5.5  8.5  9.5     NA       0.1        1
      256 #FFBBBB  6  9     1    59  5.5  6.5  8.5  9.5     NA       0.1        1
      257 #FFBBBB  6  9     1    59  5.5  6.5  8.5  9.5     NA       0.1        1
      258 #FFBBBB  6  9     1    59  5.5  6.5  8.5  9.5     NA       0.1        1
      259 #FFBBBB  7  9     1    69  6.5  7.5  8.5  9.5     NA       0.1        1
      260 #FFBBBB  7  9     1    69  6.5  7.5  8.5  9.5     NA       0.1        1
      261 #FFBBBB  7  9     1    69  6.5  7.5  8.5  9.5     NA       0.1        1
      262 #FFBBBB  8  9     1    79  7.5  8.5  8.5  9.5     NA       0.1        1
      263 #FFBBBB  8  9     1    79  7.5  8.5  8.5  9.5     NA       0.1        1
      264 #FFBBBB  8  9     1    79  7.5  8.5  8.5  9.5     NA       0.1        1
      265 #FFBBBB  9  9     1    89  8.5  9.5  8.5  9.5     NA       0.1        1
      266 #FFBBBB  9  9     1    89  8.5  9.5  8.5  9.5     NA       0.1        1
      267 #FFBBBB  9  9     1    89  8.5  9.5  8.5  9.5     NA       0.1        1
      268 #FFBBBB 10  9     1    99  9.5 10.5  8.5  9.5     NA       0.1        1
      269 #FFBBBB 10  9     1    99  9.5 10.5  8.5  9.5     NA       0.1        1
      270 #FFBBBB 10  9     1    99  9.5 10.5  8.5  9.5     NA       0.1        1
      271 #FFBBBB  1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      272 #FFBBBB  1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      273 #FFBBBB  1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      274 #FFBBBB  2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1
      275 #FFBBBB  2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1
      276 #FFBBBB  2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1
      277 #FFBBBB  3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1
      278 #FFBBBB  3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1
      279 #FFBBBB  3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1
      280 #FFBBBB  4 10     1    40  3.5  4.5  9.5 10.5     NA       0.1        1
      281 #FFBBBB  4 10     1    40  3.5  4.5  9.5 10.5     NA       0.1        1
      282 #FFBBBB  4 10     1    40  3.5  4.5  9.5 10.5     NA       0.1        1
      283 #FFBBBB  5 10     1    50  4.5  5.5  9.5 10.5     NA       0.1        1
      284 #FFBBBB  5 10     1    50  4.5  5.5  9.5 10.5     NA       0.1        1
      285 #FFBBBB  5 10     1    50  4.5  5.5  9.5 10.5     NA       0.1        1
      286 #FFBBBB  6 10     1    60  5.5  6.5  9.5 10.5     NA       0.1        1
      287 #FFBBBB  6 10     1    60  5.5  6.5  9.5 10.5     NA       0.1        1
      288 #FFBBBB  6 10     1    60  5.5  6.5  9.5 10.5     NA       0.1        1
      289 #FFBBBB  7 10     1    70  6.5  7.5  9.5 10.5     NA       0.1        1
      290 #FFBBBB  7 10     1    70  6.5  7.5  9.5 10.5     NA       0.1        1
      291 #FFBBBB  7 10     1    70  6.5  7.5  9.5 10.5     NA       0.1        1
      292 #FFBBBB  8 10     1    80  7.5  8.5  9.5 10.5     NA       0.1        1
      293 #FFBBBB  8 10     1    80  7.5  8.5  9.5 10.5     NA       0.1        1
      294 #FFBBBB  8 10     1    80  7.5  8.5  9.5 10.5     NA       0.1        1
      295 #FFBBBB  9 10     1    90  8.5  9.5  9.5 10.5     NA       0.1        1
      296 #FFBBBB  9 10     1    90  8.5  9.5  9.5 10.5     NA       0.1        1
      297 #FFBBBB  9 10     1    90  8.5  9.5  9.5 10.5     NA       0.1        1
      298 #FFBBBB 10 10     1   100  9.5 10.5  9.5 10.5     NA       0.1        1
      299 #FFBBBB 10 10     1   100  9.5 10.5  9.5 10.5     NA       0.1        1
      300 #FFBBBB 10 10     1   100  9.5 10.5  9.5 10.5     NA       0.1        1
          alpha width height
      1      NA    NA     NA
      2      NA    NA     NA
      3      NA    NA     NA
      4      NA    NA     NA
      5      NA    NA     NA
      6      NA    NA     NA
      7      NA    NA     NA
      8      NA    NA     NA
      9      NA    NA     NA
      10     NA    NA     NA
      11     NA    NA     NA
      12     NA    NA     NA
      13     NA    NA     NA
      14     NA    NA     NA
      15     NA    NA     NA
      16     NA    NA     NA
      17     NA    NA     NA
      18     NA    NA     NA
      19     NA    NA     NA
      20     NA    NA     NA
      21     NA    NA     NA
      22     NA    NA     NA
      23     NA    NA     NA
      24     NA    NA     NA
      25     NA    NA     NA
      26     NA    NA     NA
      27     NA    NA     NA
      28     NA    NA     NA
      29     NA    NA     NA
      30     NA    NA     NA
      31     NA    NA     NA
      32     NA    NA     NA
      33     NA    NA     NA
      34     NA    NA     NA
      35     NA    NA     NA
      36     NA    NA     NA
      37     NA    NA     NA
      38     NA    NA     NA
      39     NA    NA     NA
      40     NA    NA     NA
      41     NA    NA     NA
      42     NA    NA     NA
      43     NA    NA     NA
      44     NA    NA     NA
      45     NA    NA     NA
      46     NA    NA     NA
      47     NA    NA     NA
      48     NA    NA     NA
      49     NA    NA     NA
      50     NA    NA     NA
      51     NA    NA     NA
      52     NA    NA     NA
      53     NA    NA     NA
      54     NA    NA     NA
      55     NA    NA     NA
      56     NA    NA     NA
      57     NA    NA     NA
      58     NA    NA     NA
      59     NA    NA     NA
      60     NA    NA     NA
      61     NA    NA     NA
      62     NA    NA     NA
      63     NA    NA     NA
      64     NA    NA     NA
      65     NA    NA     NA
      66     NA    NA     NA
      67     NA    NA     NA
      68     NA    NA     NA
      69     NA    NA     NA
      70     NA    NA     NA
      71     NA    NA     NA
      72     NA    NA     NA
      73     NA    NA     NA
      74     NA    NA     NA
      75     NA    NA     NA
      76     NA    NA     NA
      77     NA    NA     NA
      78     NA    NA     NA
      79     NA    NA     NA
      80     NA    NA     NA
      81     NA    NA     NA
      82     NA    NA     NA
      83     NA    NA     NA
      84     NA    NA     NA
      85     NA    NA     NA
      86     NA    NA     NA
      87     NA    NA     NA
      88     NA    NA     NA
      89     NA    NA     NA
      90     NA    NA     NA
      91     NA    NA     NA
      92     NA    NA     NA
      93     NA    NA     NA
      94     NA    NA     NA
      95     NA    NA     NA
      96     NA    NA     NA
      97     NA    NA     NA
      98     NA    NA     NA
      99     NA    NA     NA
      100    NA    NA     NA
      101    NA    NA     NA
      102    NA    NA     NA
      103    NA    NA     NA
      104    NA    NA     NA
      105    NA    NA     NA
      106    NA    NA     NA
      107    NA    NA     NA
      108    NA    NA     NA
      109    NA    NA     NA
      110    NA    NA     NA
      111    NA    NA     NA
      112    NA    NA     NA
      113    NA    NA     NA
      114    NA    NA     NA
      115    NA    NA     NA
      116    NA    NA     NA
      117    NA    NA     NA
      118    NA    NA     NA
      119    NA    NA     NA
      120    NA    NA     NA
      121    NA    NA     NA
      122    NA    NA     NA
      123    NA    NA     NA
      124    NA    NA     NA
      125    NA    NA     NA
      126    NA    NA     NA
      127    NA    NA     NA
      128    NA    NA     NA
      129    NA    NA     NA
      130    NA    NA     NA
      131    NA    NA     NA
      132    NA    NA     NA
      133    NA    NA     NA
      134    NA    NA     NA
      135    NA    NA     NA
      136    NA    NA     NA
      137    NA    NA     NA
      138    NA    NA     NA
      139    NA    NA     NA
      140    NA    NA     NA
      141    NA    NA     NA
      142    NA    NA     NA
      143    NA    NA     NA
      144    NA    NA     NA
      145    NA    NA     NA
      146    NA    NA     NA
      147    NA    NA     NA
      148    NA    NA     NA
      149    NA    NA     NA
      150    NA    NA     NA
      151    NA    NA     NA
      152    NA    NA     NA
      153    NA    NA     NA
      154    NA    NA     NA
      155    NA    NA     NA
      156    NA    NA     NA
      157    NA    NA     NA
      158    NA    NA     NA
      159    NA    NA     NA
      160    NA    NA     NA
      161    NA    NA     NA
      162    NA    NA     NA
      163    NA    NA     NA
      164    NA    NA     NA
      165    NA    NA     NA
      166    NA    NA     NA
      167    NA    NA     NA
      168    NA    NA     NA
      169    NA    NA     NA
      170    NA    NA     NA
      171    NA    NA     NA
      172    NA    NA     NA
      173    NA    NA     NA
      174    NA    NA     NA
      175    NA    NA     NA
      176    NA    NA     NA
      177    NA    NA     NA
      178    NA    NA     NA
      179    NA    NA     NA
      180    NA    NA     NA
      181    NA    NA     NA
      182    NA    NA     NA
      183    NA    NA     NA
      184    NA    NA     NA
      185    NA    NA     NA
      186    NA    NA     NA
      187    NA    NA     NA
      188    NA    NA     NA
      189    NA    NA     NA
      190    NA    NA     NA
      191    NA    NA     NA
      192    NA    NA     NA
      193    NA    NA     NA
      194    NA    NA     NA
      195    NA    NA     NA
      196    NA    NA     NA
      197    NA    NA     NA
      198    NA    NA     NA
      199    NA    NA     NA
      200    NA    NA     NA
      201    NA    NA     NA
      202    NA    NA     NA
      203    NA    NA     NA
      204    NA    NA     NA
      205    NA    NA     NA
      206    NA    NA     NA
      207    NA    NA     NA
      208    NA    NA     NA
      209    NA    NA     NA
      210    NA    NA     NA
      211    NA    NA     NA
      212    NA    NA     NA
      213    NA    NA     NA
      214    NA    NA     NA
      215    NA    NA     NA
      216    NA    NA     NA
      217    NA    NA     NA
      218    NA    NA     NA
      219    NA    NA     NA
      220    NA    NA     NA
      221    NA    NA     NA
      222    NA    NA     NA
      223    NA    NA     NA
      224    NA    NA     NA
      225    NA    NA     NA
      226    NA    NA     NA
      227    NA    NA     NA
      228    NA    NA     NA
      229    NA    NA     NA
      230    NA    NA     NA
      231    NA    NA     NA
      232    NA    NA     NA
      233    NA    NA     NA
      234    NA    NA     NA
      235    NA    NA     NA
      236    NA    NA     NA
      237    NA    NA     NA
      238    NA    NA     NA
      239    NA    NA     NA
      240    NA    NA     NA
      241    NA    NA     NA
      242    NA    NA     NA
      243    NA    NA     NA
      244    NA    NA     NA
      245    NA    NA     NA
      246    NA    NA     NA
      247    NA    NA     NA
      248    NA    NA     NA
      249    NA    NA     NA
      250    NA    NA     NA
      251    NA    NA     NA
      252    NA    NA     NA
      253    NA    NA     NA
      254    NA    NA     NA
      255    NA    NA     NA
      256    NA    NA     NA
      257    NA    NA     NA
      258    NA    NA     NA
      259    NA    NA     NA
      260    NA    NA     NA
      261    NA    NA     NA
      262    NA    NA     NA
      263    NA    NA     NA
      264    NA    NA     NA
      265    NA    NA     NA
      266    NA    NA     NA
      267    NA    NA     NA
      268    NA    NA     NA
      269    NA    NA     NA
      270    NA    NA     NA
      271    NA    NA     NA
      272    NA    NA     NA
      273    NA    NA     NA
      274    NA    NA     NA
      275    NA    NA     NA
      276    NA    NA     NA
      277    NA    NA     NA
      278    NA    NA     NA
      279    NA    NA     NA
      280    NA    NA     NA
      281    NA    NA     NA
      282    NA    NA     NA
      283    NA    NA     NA
      284    NA    NA     NA
      285    NA    NA     NA
      286    NA    NA     NA
      287    NA    NA     NA
      288    NA    NA     NA
      289    NA    NA     NA
      290    NA    NA     NA
      291    NA    NA     NA
      292    NA    NA     NA
      293    NA    NA     NA
      294    NA    NA     NA
      295    NA    NA     NA
      296    NA    NA     NA
      297    NA    NA     NA
      298    NA    NA     NA
      299    NA    NA     NA
      300    NA    NA     NA
      
      $Asia$d2$`vs:am`
            fill x y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #FFBBBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #FFBBBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #FFBBBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FFBBBB 2 1     1     3  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #FFBBBB 2 1     1     3  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #FFBBBB 2 1     1     3  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFBBBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      8  #FFBBBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      9  #FFBBBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      10 #FFBBBB 2 2     1     4  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      11 #FFBBBB 2 2     1     4  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      12 #FFBBBB 2 2     1     4  1.5  2.5  1.5  2.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      
      $Asia$d2$`vs:model`
             fill x  y PANEL group xmin xmax ymin ymax colour linewidth linetype
      1   #FFBBBB 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      2   #FFBBBB 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      3   #FFBBBB 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      4   #FFBBBB 2  1     1    33  1.5  2.5  0.5  1.5     NA       0.1        1
      5   #FFBBBB 2  1     1    33  1.5  2.5  0.5  1.5     NA       0.1        1
      6   #FFBBBB 2  1     1    33  1.5  2.5  0.5  1.5     NA       0.1        1
      7   #FFBBBB 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      8   #FFBBBB 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      9   #FFBBBB 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      10  #FFBBBB 2  2     1    34  1.5  2.5  1.5  2.5     NA       0.1        1
      11  #FFBBBB 2  2     1    34  1.5  2.5  1.5  2.5     NA       0.1        1
      12  #FFBBBB 2  2     1    34  1.5  2.5  1.5  2.5     NA       0.1        1
      13  #FFBBBB 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      14  #FFBBBB 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      15  #FFBBBB 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      16  #FFBBBB 2  3     1    35  1.5  2.5  2.5  3.5     NA       0.1        1
      17  #FFBBBB 2  3     1    35  1.5  2.5  2.5  3.5     NA       0.1        1
      18  #FFBBBB 2  3     1    35  1.5  2.5  2.5  3.5     NA       0.1        1
      19  #FFBBBB 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      20  #FFBBBB 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      21  #FFBBBB 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      22  #FFBBBB 2  4     1    36  1.5  2.5  3.5  4.5     NA       0.1        1
      23  #FFBBBB 2  4     1    36  1.5  2.5  3.5  4.5     NA       0.1        1
      24  #FFBBBB 2  4     1    36  1.5  2.5  3.5  4.5     NA       0.1        1
      25  #FFBBBB 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      26  #FFBBBB 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      27  #FFBBBB 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      28  #FFBBBB 2  5     1    37  1.5  2.5  4.5  5.5     NA       0.1        1
      29  #FFBBBB 2  5     1    37  1.5  2.5  4.5  5.5     NA       0.1        1
      30  #FFBBBB 2  5     1    37  1.5  2.5  4.5  5.5     NA       0.1        1
      31  #FFBBBB 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      32  #FFBBBB 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      33  #FFBBBB 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      34  #FFBBBB 2  6     1    38  1.5  2.5  5.5  6.5     NA       0.1        1
      35  #FFBBBB 2  6     1    38  1.5  2.5  5.5  6.5     NA       0.1        1
      36  #FFBBBB 2  6     1    38  1.5  2.5  5.5  6.5     NA       0.1        1
      37  #FFBBBB 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      38  #FFBBBB 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      39  #FFBBBB 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      40  #FFBBBB 2  7     1    39  1.5  2.5  6.5  7.5     NA       0.1        1
      41  #FFBBBB 2  7     1    39  1.5  2.5  6.5  7.5     NA       0.1        1
      42  #FFBBBB 2  7     1    39  1.5  2.5  6.5  7.5     NA       0.1        1
      43  #FFBBBB 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      44  #FFBBBB 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      45  #FFBBBB 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      46  #FFBBBB 2  8     1    40  1.5  2.5  7.5  8.5     NA       0.1        1
      47  #FFBBBB 2  8     1    40  1.5  2.5  7.5  8.5     NA       0.1        1
      48  #FFBBBB 2  8     1    40  1.5  2.5  7.5  8.5     NA       0.1        1
      49  #FFBBBB 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      50  #FFBBBB 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      51  #FFBBBB 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      52  #FFBBBB 2  9     1    41  1.5  2.5  8.5  9.5     NA       0.1        1
      53  #FFBBBB 2  9     1    41  1.5  2.5  8.5  9.5     NA       0.1        1
      54  #FFBBBB 2  9     1    41  1.5  2.5  8.5  9.5     NA       0.1        1
      55  #FFBBBB 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      56  #FFBBBB 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      57  #FFBBBB 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      58  #FFBBBB 2 10     1    42  1.5  2.5  9.5 10.5     NA       0.1        1
      59  #FFBBBB 2 10     1    42  1.5  2.5  9.5 10.5     NA       0.1        1
      60  #FFBBBB 2 10     1    42  1.5  2.5  9.5 10.5     NA       0.1        1
      61  #FFBBBB 1 11     1    11  0.5  1.5 10.5 11.5     NA       0.1        1
      62  #FFBBBB 1 11     1    11  0.5  1.5 10.5 11.5     NA       0.1        1
      63  #FFBBBB 1 11     1    11  0.5  1.5 10.5 11.5     NA       0.1        1
      64  #FFBBBB 2 11     1    43  1.5  2.5 10.5 11.5     NA       0.1        1
      65  #FFBBBB 2 11     1    43  1.5  2.5 10.5 11.5     NA       0.1        1
      66  #FFBBBB 2 11     1    43  1.5  2.5 10.5 11.5     NA       0.1        1
      67  #FFBBBB 1 12     1    12  0.5  1.5 11.5 12.5     NA       0.1        1
      68  #FFBBBB 1 12     1    12  0.5  1.5 11.5 12.5     NA       0.1        1
      69  #FFBBBB 1 12     1    12  0.5  1.5 11.5 12.5     NA       0.1        1
      70  #FFBBBB 2 12     1    44  1.5  2.5 11.5 12.5     NA       0.1        1
      71  #FFBBBB 2 12     1    44  1.5  2.5 11.5 12.5     NA       0.1        1
      72  #FFBBBB 2 12     1    44  1.5  2.5 11.5 12.5     NA       0.1        1
      73  #FFBBBB 1 13     1    13  0.5  1.5 12.5 13.5     NA       0.1        1
      74  #FFBBBB 1 13     1    13  0.5  1.5 12.5 13.5     NA       0.1        1
      75  #FFBBBB 1 13     1    13  0.5  1.5 12.5 13.5     NA       0.1        1
      76  #FFBBBB 2 13     1    45  1.5  2.5 12.5 13.5     NA       0.1        1
      77  #FFBBBB 2 13     1    45  1.5  2.5 12.5 13.5     NA       0.1        1
      78  #FFBBBB 2 13     1    45  1.5  2.5 12.5 13.5     NA       0.1        1
      79  #FFBBBB 1 14     1    14  0.5  1.5 13.5 14.5     NA       0.1        1
      80  #FFBBBB 1 14     1    14  0.5  1.5 13.5 14.5     NA       0.1        1
      81  #FFBBBB 1 14     1    14  0.5  1.5 13.5 14.5     NA       0.1        1
      82  #FFBBBB 2 14     1    46  1.5  2.5 13.5 14.5     NA       0.1        1
      83  #FFBBBB 2 14     1    46  1.5  2.5 13.5 14.5     NA       0.1        1
      84  #FFBBBB 2 14     1    46  1.5  2.5 13.5 14.5     NA       0.1        1
      85  #FFBBBB 1 15     1    15  0.5  1.5 14.5 15.5     NA       0.1        1
      86  #FFBBBB 1 15     1    15  0.5  1.5 14.5 15.5     NA       0.1        1
      87  #FFBBBB 1 15     1    15  0.5  1.5 14.5 15.5     NA       0.1        1
      88  #FFBBBB 2 15     1    47  1.5  2.5 14.5 15.5     NA       0.1        1
      89  #FFBBBB 2 15     1    47  1.5  2.5 14.5 15.5     NA       0.1        1
      90  #FFBBBB 2 15     1    47  1.5  2.5 14.5 15.5     NA       0.1        1
      91  #FFBBBB 1 16     1    16  0.5  1.5 15.5 16.5     NA       0.1        1
      92  #FFBBBB 1 16     1    16  0.5  1.5 15.5 16.5     NA       0.1        1
      93  #FFBBBB 1 16     1    16  0.5  1.5 15.5 16.5     NA       0.1        1
      94  #FFBBBB 2 16     1    48  1.5  2.5 15.5 16.5     NA       0.1        1
      95  #FFBBBB 2 16     1    48  1.5  2.5 15.5 16.5     NA       0.1        1
      96  #FFBBBB 2 16     1    48  1.5  2.5 15.5 16.5     NA       0.1        1
      97  #FFBBBB 1 17     1    17  0.5  1.5 16.5 17.5     NA       0.1        1
      98  #FFBBBB 1 17     1    17  0.5  1.5 16.5 17.5     NA       0.1        1
      99  #FFBBBB 1 17     1    17  0.5  1.5 16.5 17.5     NA       0.1        1
      100 #FFBBBB 2 17     1    49  1.5  2.5 16.5 17.5     NA       0.1        1
      101 #FFBBBB 2 17     1    49  1.5  2.5 16.5 17.5     NA       0.1        1
      102 #FFBBBB 2 17     1    49  1.5  2.5 16.5 17.5     NA       0.1        1
      103 #FFBBBB 1 18     1    18  0.5  1.5 17.5 18.5     NA       0.1        1
      104 #FFBBBB 1 18     1    18  0.5  1.5 17.5 18.5     NA       0.1        1
      105 #FFBBBB 1 18     1    18  0.5  1.5 17.5 18.5     NA       0.1        1
      106 #FFBBBB 2 18     1    50  1.5  2.5 17.5 18.5     NA       0.1        1
      107 #FFBBBB 2 18     1    50  1.5  2.5 17.5 18.5     NA       0.1        1
      108 #FFBBBB 2 18     1    50  1.5  2.5 17.5 18.5     NA       0.1        1
      109 #FFBBBB 1 19     1    19  0.5  1.5 18.5 19.5     NA       0.1        1
      110 #FFBBBB 1 19     1    19  0.5  1.5 18.5 19.5     NA       0.1        1
      111 #FFBBBB 1 19     1    19  0.5  1.5 18.5 19.5     NA       0.1        1
      112 #FFBBBB 2 19     1    51  1.5  2.5 18.5 19.5     NA       0.1        1
      113 #FFBBBB 2 19     1    51  1.5  2.5 18.5 19.5     NA       0.1        1
      114 #FFBBBB 2 19     1    51  1.5  2.5 18.5 19.5     NA       0.1        1
      115 #FFBBBB 1 20     1    20  0.5  1.5 19.5 20.5     NA       0.1        1
      116 #FFBBBB 1 20     1    20  0.5  1.5 19.5 20.5     NA       0.1        1
      117 #FFBBBB 1 20     1    20  0.5  1.5 19.5 20.5     NA       0.1        1
      118 #FFBBBB 2 20     1    52  1.5  2.5 19.5 20.5     NA       0.1        1
      119 #FFBBBB 2 20     1    52  1.5  2.5 19.5 20.5     NA       0.1        1
      120 #FFBBBB 2 20     1    52  1.5  2.5 19.5 20.5     NA       0.1        1
      121 #FFBBBB 1 21     1    21  0.5  1.5 20.5 21.5     NA       0.1        1
      122 #FFBBBB 1 21     1    21  0.5  1.5 20.5 21.5     NA       0.1        1
      123 #FFBBBB 1 21     1    21  0.5  1.5 20.5 21.5     NA       0.1        1
      124 #FFBBBB 2 21     1    53  1.5  2.5 20.5 21.5     NA       0.1        1
      125 #FFBBBB 2 21     1    53  1.5  2.5 20.5 21.5     NA       0.1        1
      126 #FFBBBB 2 21     1    53  1.5  2.5 20.5 21.5     NA       0.1        1
      127 #FFBBBB 1 22     1    22  0.5  1.5 21.5 22.5     NA       0.1        1
      128 #FFBBBB 1 22     1    22  0.5  1.5 21.5 22.5     NA       0.1        1
      129 #FFBBBB 1 22     1    22  0.5  1.5 21.5 22.5     NA       0.1        1
      130 #FFBBBB 2 22     1    54  1.5  2.5 21.5 22.5     NA       0.1        1
      131 #FFBBBB 2 22     1    54  1.5  2.5 21.5 22.5     NA       0.1        1
      132 #FFBBBB 2 22     1    54  1.5  2.5 21.5 22.5     NA       0.1        1
      133 #FFBBBB 1 23     1    23  0.5  1.5 22.5 23.5     NA       0.1        1
      134 #FFBBBB 1 23     1    23  0.5  1.5 22.5 23.5     NA       0.1        1
      135 #FFBBBB 1 23     1    23  0.5  1.5 22.5 23.5     NA       0.1        1
      136 #FFBBBB 2 23     1    55  1.5  2.5 22.5 23.5     NA       0.1        1
      137 #FFBBBB 2 23     1    55  1.5  2.5 22.5 23.5     NA       0.1        1
      138 #FFBBBB 2 23     1    55  1.5  2.5 22.5 23.5     NA       0.1        1
      139 #FFBBBB 1 24     1    24  0.5  1.5 23.5 24.5     NA       0.1        1
      140 #FFBBBB 1 24     1    24  0.5  1.5 23.5 24.5     NA       0.1        1
      141 #FFBBBB 1 24     1    24  0.5  1.5 23.5 24.5     NA       0.1        1
      142 #FFBBBB 2 24     1    56  1.5  2.5 23.5 24.5     NA       0.1        1
      143 #FFBBBB 2 24     1    56  1.5  2.5 23.5 24.5     NA       0.1        1
      144 #FFBBBB 2 24     1    56  1.5  2.5 23.5 24.5     NA       0.1        1
      145 #FFBBBB 1 25     1    25  0.5  1.5 24.5 25.5     NA       0.1        1
      146 #FFBBBB 1 25     1    25  0.5  1.5 24.5 25.5     NA       0.1        1
      147 #FFBBBB 1 25     1    25  0.5  1.5 24.5 25.5     NA       0.1        1
      148 #FFBBBB 2 25     1    57  1.5  2.5 24.5 25.5     NA       0.1        1
      149 #FFBBBB 2 25     1    57  1.5  2.5 24.5 25.5     NA       0.1        1
      150 #FFBBBB 2 25     1    57  1.5  2.5 24.5 25.5     NA       0.1        1
      151 #FFBBBB 1 26     1    26  0.5  1.5 25.5 26.5     NA       0.1        1
      152 #FFBBBB 1 26     1    26  0.5  1.5 25.5 26.5     NA       0.1        1
      153 #FFBBBB 1 26     1    26  0.5  1.5 25.5 26.5     NA       0.1        1
      154 #FFBBBB 2 26     1    58  1.5  2.5 25.5 26.5     NA       0.1        1
      155 #FFBBBB 2 26     1    58  1.5  2.5 25.5 26.5     NA       0.1        1
      156 #FFBBBB 2 26     1    58  1.5  2.5 25.5 26.5     NA       0.1        1
      157 #FFBBBB 1 27     1    27  0.5  1.5 26.5 27.5     NA       0.1        1
      158 #FFBBBB 1 27     1    27  0.5  1.5 26.5 27.5     NA       0.1        1
      159 #FFBBBB 1 27     1    27  0.5  1.5 26.5 27.5     NA       0.1        1
      160 #FFBBBB 2 27     1    59  1.5  2.5 26.5 27.5     NA       0.1        1
      161 #FFBBBB 2 27     1    59  1.5  2.5 26.5 27.5     NA       0.1        1
      162 #FFBBBB 2 27     1    59  1.5  2.5 26.5 27.5     NA       0.1        1
      163 #FFBBBB 1 28     1    28  0.5  1.5 27.5 28.5     NA       0.1        1
      164 #FFBBBB 1 28     1    28  0.5  1.5 27.5 28.5     NA       0.1        1
      165 #FFBBBB 1 28     1    28  0.5  1.5 27.5 28.5     NA       0.1        1
      166 #FFBBBB 2 28     1    60  1.5  2.5 27.5 28.5     NA       0.1        1
      167 #FFBBBB 2 28     1    60  1.5  2.5 27.5 28.5     NA       0.1        1
      168 #FFBBBB 2 28     1    60  1.5  2.5 27.5 28.5     NA       0.1        1
      169 #FFBBBB 1 29     1    29  0.5  1.5 28.5 29.5     NA       0.1        1
      170 #FFBBBB 1 29     1    29  0.5  1.5 28.5 29.5     NA       0.1        1
      171 #FFBBBB 1 29     1    29  0.5  1.5 28.5 29.5     NA       0.1        1
      172 #FFBBBB 2 29     1    61  1.5  2.5 28.5 29.5     NA       0.1        1
      173 #FFBBBB 2 29     1    61  1.5  2.5 28.5 29.5     NA       0.1        1
      174 #FFBBBB 2 29     1    61  1.5  2.5 28.5 29.5     NA       0.1        1
      175 #FFBBBB 1 30     1    30  0.5  1.5 29.5 30.5     NA       0.1        1
      176 #FFBBBB 1 30     1    30  0.5  1.5 29.5 30.5     NA       0.1        1
      177 #FFBBBB 1 30     1    30  0.5  1.5 29.5 30.5     NA       0.1        1
      178 #FFBBBB 2 30     1    62  1.5  2.5 29.5 30.5     NA       0.1        1
      179 #FFBBBB 2 30     1    62  1.5  2.5 29.5 30.5     NA       0.1        1
      180 #FFBBBB 2 30     1    62  1.5  2.5 29.5 30.5     NA       0.1        1
      181 #FFBBBB 1 31     1    31  0.5  1.5 30.5 31.5     NA       0.1        1
      182 #FFBBBB 1 31     1    31  0.5  1.5 30.5 31.5     NA       0.1        1
      183 #FFBBBB 1 31     1    31  0.5  1.5 30.5 31.5     NA       0.1        1
      184 #FFBBBB 2 31     1    63  1.5  2.5 30.5 31.5     NA       0.1        1
      185 #FFBBBB 2 31     1    63  1.5  2.5 30.5 31.5     NA       0.1        1
      186 #FFBBBB 2 31     1    63  1.5  2.5 30.5 31.5     NA       0.1        1
      187 #FFBBBB 1 32     1    32  0.5  1.5 31.5 32.5     NA       0.1        1
      188 #FFBBBB 1 32     1    32  0.5  1.5 31.5 32.5     NA       0.1        1
      189 #FFBBBB 1 32     1    32  0.5  1.5 31.5 32.5     NA       0.1        1
      190 #FFBBBB 2 32     1    64  1.5  2.5 31.5 32.5     NA       0.1        1
      191 #FFBBBB 2 32     1    64  1.5  2.5 31.5 32.5     NA       0.1        1
      192 #FFBBBB 2 32     1    64  1.5  2.5 31.5 32.5     NA       0.1        1
          alpha width height
      1      NA    NA     NA
      2      NA    NA     NA
      3      NA    NA     NA
      4      NA    NA     NA
      5      NA    NA     NA
      6      NA    NA     NA
      7      NA    NA     NA
      8      NA    NA     NA
      9      NA    NA     NA
      10     NA    NA     NA
      11     NA    NA     NA
      12     NA    NA     NA
      13     NA    NA     NA
      14     NA    NA     NA
      15     NA    NA     NA
      16     NA    NA     NA
      17     NA    NA     NA
      18     NA    NA     NA
      19     NA    NA     NA
      20     NA    NA     NA
      21     NA    NA     NA
      22     NA    NA     NA
      23     NA    NA     NA
      24     NA    NA     NA
      25     NA    NA     NA
      26     NA    NA     NA
      27     NA    NA     NA
      28     NA    NA     NA
      29     NA    NA     NA
      30     NA    NA     NA
      31     NA    NA     NA
      32     NA    NA     NA
      33     NA    NA     NA
      34     NA    NA     NA
      35     NA    NA     NA
      36     NA    NA     NA
      37     NA    NA     NA
      38     NA    NA     NA
      39     NA    NA     NA
      40     NA    NA     NA
      41     NA    NA     NA
      42     NA    NA     NA
      43     NA    NA     NA
      44     NA    NA     NA
      45     NA    NA     NA
      46     NA    NA     NA
      47     NA    NA     NA
      48     NA    NA     NA
      49     NA    NA     NA
      50     NA    NA     NA
      51     NA    NA     NA
      52     NA    NA     NA
      53     NA    NA     NA
      54     NA    NA     NA
      55     NA    NA     NA
      56     NA    NA     NA
      57     NA    NA     NA
      58     NA    NA     NA
      59     NA    NA     NA
      60     NA    NA     NA
      61     NA    NA     NA
      62     NA    NA     NA
      63     NA    NA     NA
      64     NA    NA     NA
      65     NA    NA     NA
      66     NA    NA     NA
      67     NA    NA     NA
      68     NA    NA     NA
      69     NA    NA     NA
      70     NA    NA     NA
      71     NA    NA     NA
      72     NA    NA     NA
      73     NA    NA     NA
      74     NA    NA     NA
      75     NA    NA     NA
      76     NA    NA     NA
      77     NA    NA     NA
      78     NA    NA     NA
      79     NA    NA     NA
      80     NA    NA     NA
      81     NA    NA     NA
      82     NA    NA     NA
      83     NA    NA     NA
      84     NA    NA     NA
      85     NA    NA     NA
      86     NA    NA     NA
      87     NA    NA     NA
      88     NA    NA     NA
      89     NA    NA     NA
      90     NA    NA     NA
      91     NA    NA     NA
      92     NA    NA     NA
      93     NA    NA     NA
      94     NA    NA     NA
      95     NA    NA     NA
      96     NA    NA     NA
      97     NA    NA     NA
      98     NA    NA     NA
      99     NA    NA     NA
      100    NA    NA     NA
      101    NA    NA     NA
      102    NA    NA     NA
      103    NA    NA     NA
      104    NA    NA     NA
      105    NA    NA     NA
      106    NA    NA     NA
      107    NA    NA     NA
      108    NA    NA     NA
      109    NA    NA     NA
      110    NA    NA     NA
      111    NA    NA     NA
      112    NA    NA     NA
      113    NA    NA     NA
      114    NA    NA     NA
      115    NA    NA     NA
      116    NA    NA     NA
      117    NA    NA     NA
      118    NA    NA     NA
      119    NA    NA     NA
      120    NA    NA     NA
      121    NA    NA     NA
      122    NA    NA     NA
      123    NA    NA     NA
      124    NA    NA     NA
      125    NA    NA     NA
      126    NA    NA     NA
      127    NA    NA     NA
      128    NA    NA     NA
      129    NA    NA     NA
      130    NA    NA     NA
      131    NA    NA     NA
      132    NA    NA     NA
      133    NA    NA     NA
      134    NA    NA     NA
      135    NA    NA     NA
      136    NA    NA     NA
      137    NA    NA     NA
      138    NA    NA     NA
      139    NA    NA     NA
      140    NA    NA     NA
      141    NA    NA     NA
      142    NA    NA     NA
      143    NA    NA     NA
      144    NA    NA     NA
      145    NA    NA     NA
      146    NA    NA     NA
      147    NA    NA     NA
      148    NA    NA     NA
      149    NA    NA     NA
      150    NA    NA     NA
      151    NA    NA     NA
      152    NA    NA     NA
      153    NA    NA     NA
      154    NA    NA     NA
      155    NA    NA     NA
      156    NA    NA     NA
      157    NA    NA     NA
      158    NA    NA     NA
      159    NA    NA     NA
      160    NA    NA     NA
      161    NA    NA     NA
      162    NA    NA     NA
      163    NA    NA     NA
      164    NA    NA     NA
      165    NA    NA     NA
      166    NA    NA     NA
      167    NA    NA     NA
      168    NA    NA     NA
      169    NA    NA     NA
      170    NA    NA     NA
      171    NA    NA     NA
      172    NA    NA     NA
      173    NA    NA     NA
      174    NA    NA     NA
      175    NA    NA     NA
      176    NA    NA     NA
      177    NA    NA     NA
      178    NA    NA     NA
      179    NA    NA     NA
      180    NA    NA     NA
      181    NA    NA     NA
      182    NA    NA     NA
      183    NA    NA     NA
      184    NA    NA     NA
      185    NA    NA     NA
      186    NA    NA     NA
      187    NA    NA     NA
      188    NA    NA     NA
      189    NA    NA     NA
      190    NA    NA     NA
      191    NA    NA     NA
      192    NA    NA     NA
      
      $Asia$d2$`vs:gear`
            fill x y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #FFBBBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #FFBBBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #FFBBBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FFBBBB 2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #FFBBBB 2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #FFBBBB 2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFBBBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      8  #FFBBBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      9  #FFBBBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      10 #FFBBBB 2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      11 #FFBBBB 2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      12 #FFBBBB 2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      13 #FFBBBB 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      14 #FFBBBB 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      15 #FFBBBB 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      16 #FFBBBB 2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      17 #FFBBBB 2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      18 #FFBBBB 2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      
      $Asia$d2$`vs:carb`
            fill x y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #FFBBBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #FFBBBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #FFBBBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FFBBBB 2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #FFBBBB 2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #FFBBBB 2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFBBBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      8  #FFBBBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      9  #FFBBBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      10 #FFBBBB 2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      11 #FFBBBB 2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      12 #FFBBBB 2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      13 #FFBBBB 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      14 #FFBBBB 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      15 #FFBBBB 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      16 #FFBBBB 2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      17 #FFBBBB 2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      18 #FFBBBB 2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      19 #FFBBBB 1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      20 #FFBBBB 1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      21 #FFBBBB 1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      22 #FFBBBB 2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      23 #FFBBBB 2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      24 #FFBBBB 2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      25 #FFBBBB 1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      26 #FFBBBB 1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      27 #FFBBBB 1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      28 #FFBBBB 2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      29 #FFBBBB 2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      30 #FFBBBB 2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      19    NA     NA
      20    NA     NA
      21    NA     NA
      22    NA     NA
      23    NA     NA
      24    NA     NA
      25    NA     NA
      26    NA     NA
      27    NA     NA
      28    NA     NA
      29    NA     NA
      30    NA     NA
      
      $Asia$d2$`vs:wt`
            fill x  y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #FFBBBB 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #FFBBBB 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #FFBBBB 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FFBBBB 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #FFBBBB 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #FFBBBB 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFBBBB 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      8  #FFBBBB 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      9  #FFBBBB 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      10 #FFBBBB 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      11 #FFBBBB 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      12 #FFBBBB 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      13 #FFBBBB 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      14 #FFBBBB 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      15 #FFBBBB 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      16 #FFBBBB 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      17 #FFBBBB 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      18 #FFBBBB 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      19 #FFBBBB 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      20 #FFBBBB 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      21 #FFBBBB 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      22 #FFBBBB 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      23 #FFBBBB 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      24 #FFBBBB 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      25 #FFBBBB 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      26 #FFBBBB 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      27 #FFBBBB 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      28 #FFBBBB 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      29 #FFBBBB 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      30 #FFBBBB 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      31 #FFBBBB 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1    NA
      32 #FFBBBB 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1    NA
      33 #FFBBBB 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1    NA
      34 #FFBBBB 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1    NA
      35 #FFBBBB 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1    NA
      36 #FFBBBB 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1    NA
      37 #FFBBBB 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1    NA
      38 #FFBBBB 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1    NA
      39 #FFBBBB 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1    NA
      40 #FFBBBB 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1    NA
      41 #FFBBBB 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1    NA
      42 #FFBBBB 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1    NA
      43 #FFBBBB 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1    NA
      44 #FFBBBB 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1    NA
      45 #FFBBBB 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1    NA
      46 #FFBBBB 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1    NA
      47 #FFBBBB 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1    NA
      48 #FFBBBB 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1    NA
      49 #FFBBBB 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1    NA
      50 #FFBBBB 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1    NA
      51 #FFBBBB 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1    NA
      52 #FFBBBB 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1    NA
      53 #FFBBBB 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1    NA
      54 #FFBBBB 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1    NA
      55 #FFBBBB 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1    NA
      56 #FFBBBB 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1    NA
      57 #FFBBBB 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1    NA
      58 #FFBBBB 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1    NA
      59 #FFBBBB 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1    NA
      60 #FFBBBB 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      19    NA     NA
      20    NA     NA
      21    NA     NA
      22    NA     NA
      23    NA     NA
      24    NA     NA
      25    NA     NA
      26    NA     NA
      27    NA     NA
      28    NA     NA
      29    NA     NA
      30    NA     NA
      31    NA     NA
      32    NA     NA
      33    NA     NA
      34    NA     NA
      35    NA     NA
      36    NA     NA
      37    NA     NA
      38    NA     NA
      39    NA     NA
      40    NA     NA
      41    NA     NA
      42    NA     NA
      43    NA     NA
      44    NA     NA
      45    NA     NA
      46    NA     NA
      47    NA     NA
      48    NA     NA
      49    NA     NA
      50    NA     NA
      51    NA     NA
      52    NA     NA
      53    NA     NA
      54    NA     NA
      55    NA     NA
      56    NA     NA
      57    NA     NA
      58    NA     NA
      59    NA     NA
      60    NA     NA
      
      $Asia$d2$`am:model`
             fill x  y PANEL group xmin xmax ymin ymax colour linewidth linetype
      1   #BBC8FF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      2   #BBC5FF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      3   #BBBEFF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      4   #FFBDBB 2  1     1    33  1.5  2.5  0.5  1.5     NA       0.1        1
      5   #BBC5FF 2  1     1    33  1.5  2.5  0.5  1.5     NA       0.1        1
      6   #1508FF 2  1     1    33  1.5  2.5  0.5  1.5     NA       0.1        1
      7   #BBC8FF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      8   #BBC1FF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      9   #A696FF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      10  #FFBDBB 2  2     1    34  1.5  2.5  1.5  2.5     NA       0.1        1
      11  #BBC1FF 2  2     1    34  1.5  2.5  1.5  2.5     NA       0.1        1
      12  #0000FF 2  2     1    34  1.5  2.5  1.5  2.5     NA       0.1        1
      13  #FFC6BB 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      14  #BBC9FF 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      15  #A696FF 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      16  #FFBDBB 2  3     1    35  1.5  2.5  2.5  3.5     NA       0.1        1
      17  #BBC9FF 2  3     1    35  1.5  2.5  2.5  3.5     NA       0.1        1
      18  #9984FF 2  3     1    35  1.5  2.5  2.5  3.5     NA       0.1        1
      19  #FFC6BB 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      20  #BBC9FF 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      21  #A696FF 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      22  #FFBDBB 2  4     1    36  1.5  2.5  3.5  4.5     NA       0.1        1
      23  #BBC9FF 2  4     1    36  1.5  2.5  3.5  4.5     NA       0.1        1
      24  #9984FF 2  4     1    36  1.5  2.5  3.5  4.5     NA       0.1        1
      25  #FFC6BB 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      26  #BBC9FF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      27  #A696FF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      28  #FFBDBB 2  5     1    37  1.5  2.5  4.5  5.5     NA       0.1        1
      29  #BBC9FF 2  5     1    37  1.5  2.5  4.5  5.5     NA       0.1        1
      30  #9A84FF 2  5     1    37  1.5  2.5  4.5  5.5     NA       0.1        1
      31  #FFC5BB 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      32  #BBC9FF 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      33  #A290FF 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      34  #FFBDBB 2  6     1    38  1.5  2.5  5.5  6.5     NA       0.1        1
      35  #BBC9FF 2  6     1    38  1.5  2.5  5.5  6.5     NA       0.1        1
      36  #957EFF 2  6     1    38  1.5  2.5  5.5  6.5     NA       0.1        1
      37  #FFC5BB 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      38  #BBC9FF 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      39  #A290FF 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      40  #FFBDBB 2  7     1    39  1.5  2.5  6.5  7.5     NA       0.1        1
      41  #BBC9FF 2  7     1    39  1.5  2.5  6.5  7.5     NA       0.1        1
      42  #957EFF 2  7     1    39  1.5  2.5  6.5  7.5     NA       0.1        1
      43  #FFC5BB 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      44  #BBC9FF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      45  #A290FF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      46  #FFAFAA 2  8     1    40  1.5  2.5  7.5  8.5     NA       0.1        1
      47  #BBC9FF 2  8     1    40  1.5  2.5  7.5  8.5     NA       0.1        1
      48  #6546FF 2  8     1    40  1.5  2.5  7.5  8.5     NA       0.1        1
      49  #FFC8BB 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      50  #BBC9FF 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      51  #A392FF 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      52  #FFAFAA 2  9     1    41  1.5  2.5  8.5  9.5     NA       0.1        1
      53  #BBC9FF 2  9     1    41  1.5  2.5  8.5  9.5     NA       0.1        1
      54  #6546FF 2  9     1    41  1.5  2.5  8.5  9.5     NA       0.1        1
      55  #FFC7BB 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      56  #BBCAFF 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      57  #A392FF 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      58  #FFB9B8 2 10     1    42  1.5  2.5  9.5 10.5     NA       0.1        1
      59  #BBCAFF 2 10     1    42  1.5  2.5  9.5 10.5     NA       0.1        1
      60  #8E74FF 2 10     1    42  1.5  2.5  9.5 10.5     NA       0.1        1
      61  #FFC7BB 1 11     1    11  0.5  1.5 10.5 11.5     NA       0.1        1
      62  #BBCAFF 1 11     1    11  0.5  1.5 10.5 11.5     NA       0.1        1
      63  #A392FF 1 11     1    11  0.5  1.5 10.5 11.5     NA       0.1        1
      64  #FFB9B8 2 11     1    43  1.5  2.5 10.5 11.5     NA       0.1        1
      65  #BBCAFF 2 11     1    43  1.5  2.5 10.5 11.5     NA       0.1        1
      66  #8E74FF 2 11     1    43  1.5  2.5 10.5 11.5     NA       0.1        1
      67  #FFC5BB 1 12     1    12  0.5  1.5 11.5 12.5     NA       0.1        1
      68  #BBCAFF 1 12     1    12  0.5  1.5 11.5 12.5     NA       0.1        1
      69  #A696FF 1 12     1    12  0.5  1.5 11.5 12.5     NA       0.1        1
      70  #FFBDBB 2 12     1    44  1.5  2.5 11.5 12.5     NA       0.1        1
      71  #BBCAFF 2 12     1    44  1.5  2.5 11.5 12.5     NA       0.1        1
      72  #9A85FF 2 12     1    44  1.5  2.5 11.5 12.5     NA       0.1        1
      73  #FFBFBB 1 13     1    13  0.5  1.5 12.5 13.5     NA       0.1        1
      74  #FFCBBB 1 13     1    13  0.5  1.5 12.5 13.5     NA       0.1        1
      75  #A696FF 1 13     1    13  0.5  1.5 12.5 13.5     NA       0.1        1
      76  #FFBDBB 2 13     1    45  1.5  2.5 12.5 13.5     NA       0.1        1
      77  #FFCBBB 2 13     1    45  1.5  2.5 12.5 13.5     NA       0.1        1
      78  #9D89FF 2 13     1    45  1.5  2.5 12.5 13.5     NA       0.1        1
      79  #FFBFBB 1 14     1    14  0.5  1.5 13.5 14.5     NA       0.1        1
      80  #FFCBBB 1 14     1    14  0.5  1.5 13.5 14.5     NA       0.1        1
      81  #A696FF 1 14     1    14  0.5  1.5 13.5 14.5     NA       0.1        1
      82  #FFBDBB 2 14     1    46  1.5  2.5 13.5 14.5     NA       0.1        1
      83  #FFCBBB 2 14     1    46  1.5  2.5 13.5 14.5     NA       0.1        1
      84  #9D89FF 2 14     1    46  1.5  2.5 13.5 14.5     NA       0.1        1
      85  #FFBFBB 1 15     1    15  0.5  1.5 14.5 15.5     NA       0.1        1
      86  #FFCBBB 1 15     1    15  0.5  1.5 14.5 15.5     NA       0.1        1
      87  #A696FF 1 15     1    15  0.5  1.5 14.5 15.5     NA       0.1        1
      88  #FFBDBB 2 15     1    47  1.5  2.5 14.5 15.5     NA       0.1        1
      89  #FFCBBB 2 15     1    47  1.5  2.5 14.5 15.5     NA       0.1        1
      90  #9D89FF 2 15     1    47  1.5  2.5 14.5 15.5     NA       0.1        1
      91  #FFBFBB 1 16     1    16  0.5  1.5 15.5 16.5     NA       0.1        1
      92  #FFCBBB 1 16     1    16  0.5  1.5 15.5 16.5     NA       0.1        1
      93  #A696FF 1 16     1    16  0.5  1.5 15.5 16.5     NA       0.1        1
      94  #FFBDBB 2 16     1    48  1.5  2.5 15.5 16.5     NA       0.1        1
      95  #FFCABB 2 16     1    48  1.5  2.5 15.5 16.5     NA       0.1        1
      96  #9E8AFF 2 16     1    48  1.5  2.5 15.5 16.5     NA       0.1        1
      97  #FFBFBB 1 17     1    17  0.5  1.5 16.5 17.5     NA       0.1        1
      98  #FFCBBB 1 17     1    17  0.5  1.5 16.5 17.5     NA       0.1        1
      99  #A290FF 1 17     1    17  0.5  1.5 16.5 17.5     NA       0.1        1
      100 #FFBDBB 2 17     1    49  1.5  2.5 16.5 17.5     NA       0.1        1
      101 #FFCABB 2 17     1    49  1.5  2.5 16.5 17.5     NA       0.1        1
      102 #9983FF 2 17     1    49  1.5  2.5 16.5 17.5     NA       0.1        1
      103 #FFBFBB 1 18     1    18  0.5  1.5 17.5 18.5     NA       0.1        1
      104 #FFCBBB 1 18     1    18  0.5  1.5 17.5 18.5     NA       0.1        1
      105 #A290FF 1 18     1    18  0.5  1.5 17.5 18.5     NA       0.1        1
      106 #FFBCBB 2 18     1    50  1.5  2.5 17.5 18.5     NA       0.1        1
      107 #FFCABB 2 18     1    50  1.5  2.5 17.5 18.5     NA       0.1        1
      108 #5B3CFF 2 18     1    50  1.5  2.5 17.5 18.5     NA       0.1        1
      109 #FFC4BB 1 19     1    19  0.5  1.5 18.5 19.5     NA       0.1        1
      110 #FFCBBB 1 19     1    19  0.5  1.5 18.5 19.5     NA       0.1        1
      111 #A494FF 1 19     1    19  0.5  1.5 18.5 19.5     NA       0.1        1
      112 #FFACA6 2 19     1    51  1.5  2.5 18.5 19.5     NA       0.1        1
      113 #FFC8BB 2 19     1    51  1.5  2.5 18.5 19.5     NA       0.1        1
      114 #5B3CFF 2 19     1    51  1.5  2.5 18.5 19.5     NA       0.1        1
      115 #FFC4BB 1 20     1    20  0.5  1.5 19.5 20.5     NA       0.1        1
      116 #FFCBBB 1 20     1    20  0.5  1.5 19.5 20.5     NA       0.1        1
      117 #A494FF 1 20     1    20  0.5  1.5 19.5 20.5     NA       0.1        1
      118 #FFB7B5 2 20     1    52  1.5  2.5 19.5 20.5     NA       0.1        1
      119 #FFC7BB 2 20     1    52  1.5  2.5 19.5 20.5     NA       0.1        1
      120 #A08EFF 2 20     1    52  1.5  2.5 19.5 20.5     NA       0.1        1
      121 #FFC1BB 1 21     1    21  0.5  1.5 20.5 21.5     NA       0.1        1
      122 #FFCBBB 1 21     1    21  0.5  1.5 20.5 21.5     NA       0.1        1
      123 #A392FF 1 21     1    21  0.5  1.5 20.5 21.5     NA       0.1        1
      124 #FFBEBB 2 21     1    53  1.5  2.5 20.5 21.5     NA       0.1        1
      125 #FFC6BB 2 21     1    53  1.5  2.5 20.5 21.5     NA       0.1        1
      126 #BBBDFF 2 21     1    53  1.5  2.5 20.5 21.5     NA       0.1        1
      127 #FFBBBB 1 22     1    22  0.5  1.5 21.5 22.5     NA       0.1        1
      128 #FFC7BB 1 22     1    22  0.5  1.5 21.5 22.5     NA       0.1        1
      129 #BBC3FF 1 22     1    22  0.5  1.5 21.5 22.5     NA       0.1        1
      130 #FFAAA3 2 22     1    54  1.5  2.5 21.5 22.5     NA       0.1        1
      131 #FFC2BB 2 22     1    54  1.5  2.5 21.5 22.5     NA       0.1        1
      132 #FFCABB 2 22     1    54  1.5  2.5 21.5 22.5     NA       0.1        1
      133 #FF9F93 1 23     1    23  0.5  1.5 22.5 23.5     NA       0.1        1
      134 #FFC3BB 1 23     1    23  0.5  1.5 22.5 23.5     NA       0.1        1
      135 #BBC9FF 1 23     1    23  0.5  1.5 22.5 23.5     NA       0.1        1
      136 #FF7E68 2 23     1    55  1.5  2.5 22.5 23.5     NA       0.1        1
      137 #FFC0BB 2 23     1    55  1.5  2.5 22.5 23.5     NA       0.1        1
      138 #B8B6FF 2 23     1    55  1.5  2.5 22.5 23.5     NA       0.1        1
      139 #FF8875 1 24     1    24  0.5  1.5 23.5 24.5     NA       0.1        1
      140 #FFBFBB 1 24     1    24  0.5  1.5 23.5 24.5     NA       0.1        1
      141 #BBCAFF 1 24     1    24  0.5  1.5 23.5 24.5     NA       0.1        1
      142 #FF5238 2 24     1    56  1.5  2.5 23.5 24.5     NA       0.1        1
      143 #FFBDBB 2 24     1    56  1.5  2.5 23.5 24.5     NA       0.1        1
      144 #7859FF 2 24     1    56  1.5  2.5 23.5 24.5     NA       0.1        1
      145 #FF8774 1 25     1    25  0.5  1.5 24.5 25.5     NA       0.1        1
      146 #FFBDBB 1 25     1    25  0.5  1.5 24.5 25.5     NA       0.1        1
      147 #BBCBFF 1 25     1    25  0.5  1.5 24.5 25.5     NA       0.1        1
      148 #FF452C 2 25     1    57  1.5  2.5 24.5 25.5     NA       0.1        1
      149 #FFB8B7 2 25     1    57  1.5  2.5 24.5 25.5     NA       0.1        1
      150 #4429FF 2 25     1    57  1.5  2.5 24.5 25.5     NA       0.1        1
      151 #FF8774 1 26     1    26  0.5  1.5 25.5 26.5     NA       0.1        1
      152 #FFBDBB 1 26     1    26  0.5  1.5 25.5 26.5     NA       0.1        1
      153 #BBCBFF 1 26     1    26  0.5  1.5 25.5 26.5     NA       0.1        1
      154 #FF432A 2 26     1    58  1.5  2.5 25.5 26.5     NA       0.1        1
      155 #FFB1AC 2 26     1    58  1.5  2.5 25.5 26.5     NA       0.1        1
      156 #4B2EFF 2 26     1    58  1.5  2.5 25.5 26.5     NA       0.1        1
      157 #FF8774 1 27     1    27  0.5  1.5 26.5 27.5     NA       0.1        1
      158 #FFBDBB 1 27     1    27  0.5  1.5 26.5 27.5     NA       0.1        1
      159 #BBCBFF 1 27     1    27  0.5  1.5 26.5 27.5     NA       0.1        1
      160 #FF0000 2 27     1    59  1.5  2.5 26.5 27.5     NA       0.1        1
      161 #FFA398 2 27     1    59  1.5  2.5 26.5 27.5     NA       0.1        1
      162 #957DFF 2 27     1    59  1.5  2.5 26.5 27.5     NA       0.1        1
      163 #FF8571 1 28     1    28  0.5  1.5 27.5 28.5     NA       0.1        1
      164 #FFBDBB 1 28     1    28  0.5  1.5 27.5 28.5     NA       0.1        1
      165 #BBCBFF 1 28     1    28  0.5  1.5 27.5 28.5     NA       0.1        1
      166 #FF3B23 2 28     1    60  1.5  2.5 27.5 28.5     NA       0.1        1
      167 #FFA9A1 2 28     1    60  1.5  2.5 27.5 28.5     NA       0.1        1
      168 #957DFF 2 28     1    60  1.5  2.5 27.5 28.5     NA       0.1        1
      169 #FF8672 1 29     1    29  0.5  1.5 28.5 29.5     NA       0.1        1
      170 #FFBDBB 1 29     1    29  0.5  1.5 28.5 29.5     NA       0.1        1
      171 #BBCBFF 1 29     1    29  0.5  1.5 28.5 29.5     NA       0.1        1
      172 #FF3C24 2 29     1    61  1.5  2.5 28.5 29.5     NA       0.1        1
      173 #FFA9A1 2 29     1    61  1.5  2.5 28.5 29.5     NA       0.1        1
      174 #9780FF 2 29     1    61  1.5  2.5 28.5 29.5     NA       0.1        1
      175 #FF9B8E 1 30     1    30  0.5  1.5 29.5 30.5     NA       0.1        1
      176 #FFBDBB 1 30     1    30  0.5  1.5 29.5 30.5     NA       0.1        1
      177 #FFC7BB 1 30     1    30  0.5  1.5 29.5 30.5     NA       0.1        1
      178 #FF5A40 2 30     1    62  1.5  2.5 29.5 30.5     NA       0.1        1
      179 #FFA9A1 2 30     1    62  1.5  2.5 29.5 30.5     NA       0.1        1
      180 #BBBEFF 2 30     1    62  1.5  2.5 29.5 30.5     NA       0.1        1
      181 #FF9080 1 31     1    31  0.5  1.5 30.5 31.5     NA       0.1        1
      182 #FFBDBB 1 31     1    31  0.5  1.5 30.5 31.5     NA       0.1        1
      183 #FFCABB 1 31     1    31  0.5  1.5 30.5 31.5     NA       0.1        1
      184 #FF4C32 2 31     1    63  1.5  2.5 30.5 31.5     NA       0.1        1
      185 #FFA9A1 2 31     1    63  1.5  2.5 30.5 31.5     NA       0.1        1
      186 #AEA4FF 2 31     1    63  1.5  2.5 30.5 31.5     NA       0.1        1
      187 #FF9080 1 32     1    32  0.5  1.5 31.5 32.5     NA       0.1        1
      188 #FFBDBB 1 32     1    32  0.5  1.5 31.5 32.5     NA       0.1        1
      189 #FFCABB 1 32     1    32  0.5  1.5 31.5 32.5     NA       0.1        1
      190 #FF2412 2 32     1    64  1.5  2.5 31.5 32.5     NA       0.1        1
      191 #FFA297 2 32     1    64  1.5  2.5 31.5 32.5     NA       0.1        1
      192 #AEA4FF 2 32     1    64  1.5  2.5 31.5 32.5     NA       0.1        1
          alpha width height
      1      NA    NA     NA
      2      NA    NA     NA
      3      NA    NA     NA
      4      NA    NA     NA
      5      NA    NA     NA
      6      NA    NA     NA
      7      NA    NA     NA
      8      NA    NA     NA
      9      NA    NA     NA
      10     NA    NA     NA
      11     NA    NA     NA
      12     NA    NA     NA
      13     NA    NA     NA
      14     NA    NA     NA
      15     NA    NA     NA
      16     NA    NA     NA
      17     NA    NA     NA
      18     NA    NA     NA
      19     NA    NA     NA
      20     NA    NA     NA
      21     NA    NA     NA
      22     NA    NA     NA
      23     NA    NA     NA
      24     NA    NA     NA
      25     NA    NA     NA
      26     NA    NA     NA
      27     NA    NA     NA
      28     NA    NA     NA
      29     NA    NA     NA
      30     NA    NA     NA
      31     NA    NA     NA
      32     NA    NA     NA
      33     NA    NA     NA
      34     NA    NA     NA
      35     NA    NA     NA
      36     NA    NA     NA
      37     NA    NA     NA
      38     NA    NA     NA
      39     NA    NA     NA
      40     NA    NA     NA
      41     NA    NA     NA
      42     NA    NA     NA
      43     NA    NA     NA
      44     NA    NA     NA
      45     NA    NA     NA
      46     NA    NA     NA
      47     NA    NA     NA
      48     NA    NA     NA
      49     NA    NA     NA
      50     NA    NA     NA
      51     NA    NA     NA
      52     NA    NA     NA
      53     NA    NA     NA
      54     NA    NA     NA
      55     NA    NA     NA
      56     NA    NA     NA
      57     NA    NA     NA
      58     NA    NA     NA
      59     NA    NA     NA
      60     NA    NA     NA
      61     NA    NA     NA
      62     NA    NA     NA
      63     NA    NA     NA
      64     NA    NA     NA
      65     NA    NA     NA
      66     NA    NA     NA
      67     NA    NA     NA
      68     NA    NA     NA
      69     NA    NA     NA
      70     NA    NA     NA
      71     NA    NA     NA
      72     NA    NA     NA
      73     NA    NA     NA
      74     NA    NA     NA
      75     NA    NA     NA
      76     NA    NA     NA
      77     NA    NA     NA
      78     NA    NA     NA
      79     NA    NA     NA
      80     NA    NA     NA
      81     NA    NA     NA
      82     NA    NA     NA
      83     NA    NA     NA
      84     NA    NA     NA
      85     NA    NA     NA
      86     NA    NA     NA
      87     NA    NA     NA
      88     NA    NA     NA
      89     NA    NA     NA
      90     NA    NA     NA
      91     NA    NA     NA
      92     NA    NA     NA
      93     NA    NA     NA
      94     NA    NA     NA
      95     NA    NA     NA
      96     NA    NA     NA
      97     NA    NA     NA
      98     NA    NA     NA
      99     NA    NA     NA
      100    NA    NA     NA
      101    NA    NA     NA
      102    NA    NA     NA
      103    NA    NA     NA
      104    NA    NA     NA
      105    NA    NA     NA
      106    NA    NA     NA
      107    NA    NA     NA
      108    NA    NA     NA
      109    NA    NA     NA
      110    NA    NA     NA
      111    NA    NA     NA
      112    NA    NA     NA
      113    NA    NA     NA
      114    NA    NA     NA
      115    NA    NA     NA
      116    NA    NA     NA
      117    NA    NA     NA
      118    NA    NA     NA
      119    NA    NA     NA
      120    NA    NA     NA
      121    NA    NA     NA
      122    NA    NA     NA
      123    NA    NA     NA
      124    NA    NA     NA
      125    NA    NA     NA
      126    NA    NA     NA
      127    NA    NA     NA
      128    NA    NA     NA
      129    NA    NA     NA
      130    NA    NA     NA
      131    NA    NA     NA
      132    NA    NA     NA
      133    NA    NA     NA
      134    NA    NA     NA
      135    NA    NA     NA
      136    NA    NA     NA
      137    NA    NA     NA
      138    NA    NA     NA
      139    NA    NA     NA
      140    NA    NA     NA
      141    NA    NA     NA
      142    NA    NA     NA
      143    NA    NA     NA
      144    NA    NA     NA
      145    NA    NA     NA
      146    NA    NA     NA
      147    NA    NA     NA
      148    NA    NA     NA
      149    NA    NA     NA
      150    NA    NA     NA
      151    NA    NA     NA
      152    NA    NA     NA
      153    NA    NA     NA
      154    NA    NA     NA
      155    NA    NA     NA
      156    NA    NA     NA
      157    NA    NA     NA
      158    NA    NA     NA
      159    NA    NA     NA
      160    NA    NA     NA
      161    NA    NA     NA
      162    NA    NA     NA
      163    NA    NA     NA
      164    NA    NA     NA
      165    NA    NA     NA
      166    NA    NA     NA
      167    NA    NA     NA
      168    NA    NA     NA
      169    NA    NA     NA
      170    NA    NA     NA
      171    NA    NA     NA
      172    NA    NA     NA
      173    NA    NA     NA
      174    NA    NA     NA
      175    NA    NA     NA
      176    NA    NA     NA
      177    NA    NA     NA
      178    NA    NA     NA
      179    NA    NA     NA
      180    NA    NA     NA
      181    NA    NA     NA
      182    NA    NA     NA
      183    NA    NA     NA
      184    NA    NA     NA
      185    NA    NA     NA
      186    NA    NA     NA
      187    NA    NA     NA
      188    NA    NA     NA
      189    NA    NA     NA
      190    NA    NA     NA
      191    NA    NA     NA
      192    NA    NA     NA
      
      $Asia$d2$`am:gear`
            fill x y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #FFC1BB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #FFC7BB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #FFCCBB 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FF7F6A 2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #FFC7BB 2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #AFA5FF 2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFB8B6 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      8  #FFC2BB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      9  #FFC8BB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      10 #FF432A 2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      11 #FFA399 2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      12 #BBCBFF 2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      13 #FFB8B6 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      14 #FFC2BB 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      15 #FFC8BB 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      16 #FF0000 2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      17 #FF573D 2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      18 #FF8977 2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      
      $Asia$d2$`am:carb`
            fill x y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #BBCBFF 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #BBCBFF 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #BBCBFF 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FF9C8F 2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #BBCBFF 2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #BBC5FF 2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFBCBB 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      8  #BBCBFF 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      9  #BBC8FF 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      10 #FF0000 2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      11 #FFCCBB 2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      12 #BBC2FF 2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      13 #BBCCFF 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      14 #BBCBFF 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      15 #BBCBFF 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      16 #FF8875 2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      17 #FFCCBB 2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      18 #BBC6FF 2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      19 #FFBFBB 1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      20 #BBC2FF 1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      21 #B2ABFF 1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      22 #B8B5FF 2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      23 #AB9EFF 2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      24 #9781FF 2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      25 #BBCAFF 1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      26 #BBC2FF 1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      27 #BBBCFF 1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      28 #BAB9FF 2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      29 #AB9EFF 2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      30 #8A6FFF 2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      19    NA     NA
      20    NA     NA
      21    NA     NA
      22    NA     NA
      23    NA     NA
      24    NA     NA
      25    NA     NA
      26    NA     NA
      27    NA     NA
      28    NA     NA
      29    NA     NA
      30    NA     NA
      
      $Asia$d2$`am:wt`
            fill x  y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #BBCBFF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #BBCBFF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #BBCBFF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FFC7BB 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #BBCBFF 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #BBCBFF 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #BBCCFF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      8  #BBCBFF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      9  #BBCBFF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      10 #FF0100 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      11 #BBCBFF 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      12 #BBC9FF 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      13 #FFBEBB 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      14 #BBCBFF 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      15 #BBCAFF 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      16 #FF0000 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      17 #BBCBFF 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      18 #BBC9FF 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      19 #FFC1BB 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      20 #BBCAFF 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      21 #BBC9FF 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      22 #BBCBFF 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      23 #BBC9FF 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      24 #BBC8FF 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      25 #BBCBFF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      26 #BBCAFF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      27 #BBC8FF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      28 #BBC9FF 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      29 #BBC7FF 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      30 #BBC4FF 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      31 #FFC4BB 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1    NA
      32 #BBCAFF 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1    NA
      33 #BBC8FF 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1    NA
      34 #BBC9FF 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1    NA
      35 #BBC7FF 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1    NA
      36 #BBC4FF 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1    NA
      37 #FFC4BB 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1    NA
      38 #BBCAFF 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1    NA
      39 #BBC8FF 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1    NA
      40 #BBC8FF 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1    NA
      41 #BBC6FF 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1    NA
      42 #BBC4FF 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1    NA
      43 #BBCBFF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1    NA
      44 #BBCAFF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1    NA
      45 #BBC8FF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1    NA
      46 #BBC7FF 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1    NA
      47 #BBC6FF 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1    NA
      48 #BBC5FF 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1    NA
      49 #FFC4BB 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1    NA
      50 #BBCAFF 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1    NA
      51 #BBC8FF 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1    NA
      52 #BBC8FF 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1    NA
      53 #BBC6FF 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1    NA
      54 #BBC4FF 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1    NA
      55 #FFC4BB 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1    NA
      56 #BBCAFF 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1    NA
      57 #BBC8FF 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1    NA
      58 #BBC8FF 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1    NA
      59 #BBC6FF 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1    NA
      60 #BBC4FF 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      19    NA     NA
      20    NA     NA
      21    NA     NA
      22    NA     NA
      23    NA     NA
      24    NA     NA
      25    NA     NA
      26    NA     NA
      27    NA     NA
      28    NA     NA
      29    NA     NA
      30    NA     NA
      31    NA     NA
      32    NA     NA
      33    NA     NA
      34    NA     NA
      35    NA     NA
      36    NA     NA
      37    NA     NA
      38    NA     NA
      39    NA     NA
      40    NA     NA
      41    NA     NA
      42    NA     NA
      43    NA     NA
      44    NA     NA
      45    NA     NA
      46    NA     NA
      47    NA     NA
      48    NA     NA
      49    NA     NA
      50    NA     NA
      51    NA     NA
      52    NA     NA
      53    NA     NA
      54    NA     NA
      55    NA     NA
      56    NA     NA
      57    NA     NA
      58    NA     NA
      59    NA     NA
      60    NA     NA
      
      $Asia$d2$`model:gear`
             fill  x y PANEL group xmin xmax ymin ymax colour linewidth linetype
      1   #FFCBBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      2   #FFCCBB  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      3   #BBC8FF  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      4   #FFCBBB  2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1
      5   #BBCBFF  2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1
      6   #BBBDFF  2 1     1     4  1.5  2.5  0.5  1.5     NA       0.1        1
      7   #FFC5BB  3 1     1     7  2.5  3.5  0.5  1.5     NA       0.1        1
      8   #FFCABB  3 1     1     7  2.5  3.5  0.5  1.5     NA       0.1        1
      9   #BBBDFF  3 1     1     7  2.5  3.5  0.5  1.5     NA       0.1        1
      10  #FFC8BB  4 1     1    10  3.5  4.5  0.5  1.5     NA       0.1        1
      11  #FFCBBB  4 1     1    10  3.5  4.5  0.5  1.5     NA       0.1        1
      12  #BBBDFF  4 1     1    10  3.5  4.5  0.5  1.5     NA       0.1        1
      13  #FFCBBB  5 1     1    13  4.5  5.5  0.5  1.5     NA       0.1        1
      14  #BBC0FF  5 1     1    13  4.5  5.5  0.5  1.5     NA       0.1        1
      15  #957EFF  5 1     1    13  4.5  5.5  0.5  1.5     NA       0.1        1
      16  #FFC8BB  6 1     1    16  5.5  6.5  0.5  1.5     NA       0.1        1
      17  #BBC5FF  6 1     1    16  5.5  6.5  0.5  1.5     NA       0.1        1
      18  #9781FF  6 1     1    16  5.5  6.5  0.5  1.5     NA       0.1        1
      19  #FFC6BB  7 1     1    19  6.5  7.5  0.5  1.5     NA       0.1        1
      20  #BBC5FF  7 1     1    19  6.5  7.5  0.5  1.5     NA       0.1        1
      21  #6242FF  7 1     1    19  6.5  7.5  0.5  1.5     NA       0.1        1
      22  #FFC8BB  8 1     1    22  7.5  8.5  0.5  1.5     NA       0.1        1
      23  #BBC5FF  8 1     1    22  7.5  8.5  0.5  1.5     NA       0.1        1
      24  #866AFF  8 1     1    22  7.5  8.5  0.5  1.5     NA       0.1        1
      25  #FFC8BB  9 1     1    25  8.5  9.5  0.5  1.5     NA       0.1        1
      26  #BBC5FF  9 1     1    25  8.5  9.5  0.5  1.5     NA       0.1        1
      27  #866AFF  9 1     1    25  8.5  9.5  0.5  1.5     NA       0.1        1
      28  #FFC2BB 10 1     1    28  9.5 10.5  0.5  1.5     NA       0.1        1
      29  #FFCCBB 10 1     1    28  9.5 10.5  0.5  1.5     NA       0.1        1
      30  #6748FF 10 1     1    28  9.5 10.5  0.5  1.5     NA       0.1        1
      31  #FFC2BB 11 1     1    31 10.5 11.5  0.5  1.5     NA       0.1        1
      32  #FFCCBB 11 1     1    31 10.5 11.5  0.5  1.5     NA       0.1        1
      33  #6748FF 11 1     1    31 10.5 11.5  0.5  1.5     NA       0.1        1
      34  #FFC6BB 12 1     1    34 11.5 12.5  0.5  1.5     NA       0.1        1
      35  #FFCCBB 12 1     1    34 11.5 12.5  0.5  1.5     NA       0.1        1
      36  #B6B1FF 12 1     1    34 11.5 12.5  0.5  1.5     NA       0.1        1
      37  #FFC3BB 13 1     1    37 12.5 13.5  0.5  1.5     NA       0.1        1
      38  #FFCABB 13 1     1    37 12.5 13.5  0.5  1.5     NA       0.1        1
      39  #B6B1FF 13 1     1    37 12.5 13.5  0.5  1.5     NA       0.1        1
      40  #FFC3BB 14 1     1    40 13.5 14.5  0.5  1.5     NA       0.1        1
      41  #FFCABB 14 1     1    40 13.5 14.5  0.5  1.5     NA       0.1        1
      42  #B6B1FF 14 1     1    40 13.5 14.5  0.5  1.5     NA       0.1        1
      43  #FFC3BB 15 1     1    43 14.5 15.5  0.5  1.5     NA       0.1        1
      44  #FFCABB 15 1     1    43 14.5 15.5  0.5  1.5     NA       0.1        1
      45  #B6B1FF 15 1     1    43 14.5 15.5  0.5  1.5     NA       0.1        1
      46  #FFC3BB 16 1     1    46 15.5 16.5  0.5  1.5     NA       0.1        1
      47  #FFCABB 16 1     1    46 15.5 16.5  0.5  1.5     NA       0.1        1
      48  #B6B1FF 16 1     1    46 15.5 16.5  0.5  1.5     NA       0.1        1
      49  #FFBDBB 17 1     1    49 16.5 17.5  0.5  1.5     NA       0.1        1
      50  #FFCABB 17 1     1    49 16.5 17.5  0.5  1.5     NA       0.1        1
      51  #8E74FF 17 1     1    49 16.5 17.5  0.5  1.5     NA       0.1        1
      52  #FFBFBB 18 1     1    52 17.5 18.5  0.5  1.5     NA       0.1        1
      53  #FFCABB 18 1     1    52 17.5 18.5  0.5  1.5     NA       0.1        1
      54  #A89AFF 18 1     1    52 17.5 18.5  0.5  1.5     NA       0.1        1
      55  #FFC2BB 19 1     1    55 18.5 19.5  0.5  1.5     NA       0.1        1
      56  #FFCABB 19 1     1    55 18.5 19.5  0.5  1.5     NA       0.1        1
      57  #AA9DFF 19 1     1    55 18.5 19.5  0.5  1.5     NA       0.1        1
      58  #FFBDBB 20 1     1    58 19.5 20.5  0.5  1.5     NA       0.1        1
      59  #FFCABB 20 1     1    58 19.5 20.5  0.5  1.5     NA       0.1        1
      60  #9780FF 20 1     1    58 19.5 20.5  0.5  1.5     NA       0.1        1
      61  #FFBCBB 21 1     1    61 20.5 21.5  0.5  1.5     NA       0.1        1
      62  #FFCABB 21 1     1    61 20.5 21.5  0.5  1.5     NA       0.1        1
      63  #8F75FF 21 1     1    61 20.5 21.5  0.5  1.5     NA       0.1        1
      64  #FFBFBB 22 1     1    64 21.5 22.5  0.5  1.5     NA       0.1        1
      65  #FFCABB 22 1     1    64 21.5 22.5  0.5  1.5     NA       0.1        1
      66  #9279FF 22 1     1    64 21.5 22.5  0.5  1.5     NA       0.1        1
      67  #FFBFBB 23 1     1    67 22.5 23.5  0.5  1.5     NA       0.1        1
      68  #FFCABB 23 1     1    67 22.5 23.5  0.5  1.5     NA       0.1        1
      69  #9D88FF 23 1     1    67 22.5 23.5  0.5  1.5     NA       0.1        1
      70  #FFBFBB 24 1     1    70 23.5 24.5  0.5  1.5     NA       0.1        1
      71  #FFCABB 24 1     1    70 23.5 24.5  0.5  1.5     NA       0.1        1
      72  #9D88FF 24 1     1    70 23.5 24.5  0.5  1.5     NA       0.1        1
      73  #FFBFBB 25 1     1    73 24.5 25.5  0.5  1.5     NA       0.1        1
      74  #FFCABB 25 1     1    73 24.5 25.5  0.5  1.5     NA       0.1        1
      75  #9D88FF 25 1     1    73 24.5 25.5  0.5  1.5     NA       0.1        1
      76  #FFBFBB 26 1     1    76 25.5 26.5  0.5  1.5     NA       0.1        1
      77  #FFCABB 26 1     1    76 25.5 26.5  0.5  1.5     NA       0.1        1
      78  #9D88FF 26 1     1    76 25.5 26.5  0.5  1.5     NA       0.1        1
      79  #FFBFBB 27 1     1    79 26.5 27.5  0.5  1.5     NA       0.1        1
      80  #FFCABB 27 1     1    79 26.5 27.5  0.5  1.5     NA       0.1        1
      81  #9D88FF 27 1     1    79 26.5 27.5  0.5  1.5     NA       0.1        1
      82  #FFB5B2 28 1     1    82 27.5 28.5  0.5  1.5     NA       0.1        1
      83  #FFCABB 28 1     1    82 27.5 28.5  0.5  1.5     NA       0.1        1
      84  #6445FF 28 1     1    82 27.5 28.5  0.5  1.5     NA       0.1        1
      85  #FFBBBB 29 1     1    85 28.5 29.5  0.5  1.5     NA       0.1        1
      86  #FFCABB 29 1     1    85 28.5 29.5  0.5  1.5     NA       0.1        1
      87  #6A4AFF 29 1     1    85 28.5 29.5  0.5  1.5     NA       0.1        1
      88  #FFBBBB 30 1     1    88 29.5 30.5  0.5  1.5     NA       0.1        1
      89  #FFCABB 30 1     1    88 29.5 30.5  0.5  1.5     NA       0.1        1
      90  #6A4AFF 30 1     1    88 29.5 30.5  0.5  1.5     NA       0.1        1
      91  #FFB0AB 31 1     1    91 30.5 31.5  0.5  1.5     NA       0.1        1
      92  #FFCABB 31 1     1    91 30.5 31.5  0.5  1.5     NA       0.1        1
      93  #5335FF 31 1     1    91 30.5 31.5  0.5  1.5     NA       0.1        1
      94  #FFB0AB 32 1     1    94 31.5 32.5  0.5  1.5     NA       0.1        1
      95  #FFCABB 32 1     1    94 31.5 32.5  0.5  1.5     NA       0.1        1
      96  #3921FF 32 1     1    94 31.5 32.5  0.5  1.5     NA       0.1        1
      97  #FFCBBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      98  #FFCCBB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      99  #BBC8FF  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      100 #FFCBBB  2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1
      101 #BBCBFF  2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1
      102 #BBBDFF  2 2     1     5  1.5  2.5  1.5  2.5     NA       0.1        1
      103 #FFC5BB  3 2     1     8  2.5  3.5  1.5  2.5     NA       0.1        1
      104 #FFCABB  3 2     1     8  2.5  3.5  1.5  2.5     NA       0.1        1
      105 #BBBDFF  3 2     1     8  2.5  3.5  1.5  2.5     NA       0.1        1
      106 #FFC8BB  4 2     1    11  3.5  4.5  1.5  2.5     NA       0.1        1
      107 #FFCBBB  4 2     1    11  3.5  4.5  1.5  2.5     NA       0.1        1
      108 #BBBDFF  4 2     1    11  3.5  4.5  1.5  2.5     NA       0.1        1
      109 #FFCBBB  5 2     1    14  4.5  5.5  1.5  2.5     NA       0.1        1
      110 #BBC0FF  5 2     1    14  4.5  5.5  1.5  2.5     NA       0.1        1
      111 #957EFF  5 2     1    14  4.5  5.5  1.5  2.5     NA       0.1        1
      112 #FFC8BB  6 2     1    17  5.5  6.5  1.5  2.5     NA       0.1        1
      113 #BBC5FF  6 2     1    17  5.5  6.5  1.5  2.5     NA       0.1        1
      114 #9781FF  6 2     1    17  5.5  6.5  1.5  2.5     NA       0.1        1
      115 #FFC6BB  7 2     1    20  6.5  7.5  1.5  2.5     NA       0.1        1
      116 #BBC5FF  7 2     1    20  6.5  7.5  1.5  2.5     NA       0.1        1
      117 #6242FF  7 2     1    20  6.5  7.5  1.5  2.5     NA       0.1        1
      118 #FFC8BB  8 2     1    23  7.5  8.5  1.5  2.5     NA       0.1        1
      119 #BBC5FF  8 2     1    23  7.5  8.5  1.5  2.5     NA       0.1        1
      120 #866AFF  8 2     1    23  7.5  8.5  1.5  2.5     NA       0.1        1
      121 #FFC8BB  9 2     1    26  8.5  9.5  1.5  2.5     NA       0.1        1
      122 #BBC5FF  9 2     1    26  8.5  9.5  1.5  2.5     NA       0.1        1
      123 #866AFF  9 2     1    26  8.5  9.5  1.5  2.5     NA       0.1        1
      124 #FFC2BB 10 2     1    29  9.5 10.5  1.5  2.5     NA       0.1        1
      125 #FFCCBB 10 2     1    29  9.5 10.5  1.5  2.5     NA       0.1        1
      126 #6748FF 10 2     1    29  9.5 10.5  1.5  2.5     NA       0.1        1
      127 #FFC2BB 11 2     1    32 10.5 11.5  1.5  2.5     NA       0.1        1
      128 #FFCCBB 11 2     1    32 10.5 11.5  1.5  2.5     NA       0.1        1
      129 #6748FF 11 2     1    32 10.5 11.5  1.5  2.5     NA       0.1        1
      130 #FFC6BB 12 2     1    35 11.5 12.5  1.5  2.5     NA       0.1        1
      131 #FFCCBB 12 2     1    35 11.5 12.5  1.5  2.5     NA       0.1        1
      132 #B6B1FF 12 2     1    35 11.5 12.5  1.5  2.5     NA       0.1        1
      133 #FFC3BB 13 2     1    38 12.5 13.5  1.5  2.5     NA       0.1        1
      134 #FFCABB 13 2     1    38 12.5 13.5  1.5  2.5     NA       0.1        1
      135 #B6B1FF 13 2     1    38 12.5 13.5  1.5  2.5     NA       0.1        1
      136 #FFC3BB 14 2     1    41 13.5 14.5  1.5  2.5     NA       0.1        1
      137 #FFCABB 14 2     1    41 13.5 14.5  1.5  2.5     NA       0.1        1
      138 #B6B1FF 14 2     1    41 13.5 14.5  1.5  2.5     NA       0.1        1
      139 #FFC2BB 15 2     1    44 14.5 15.5  1.5  2.5     NA       0.1        1
      140 #FFCABB 15 2     1    44 14.5 15.5  1.5  2.5     NA       0.1        1
      141 #B5B0FF 15 2     1    44 14.5 15.5  1.5  2.5     NA       0.1        1
      142 #FFC2BB 16 2     1    47 15.5 16.5  1.5  2.5     NA       0.1        1
      143 #FFCABB 16 2     1    47 15.5 16.5  1.5  2.5     NA       0.1        1
      144 #B5B0FF 16 2     1    47 15.5 16.5  1.5  2.5     NA       0.1        1
      145 #FFBDBB 17 2     1    50 16.5 17.5  1.5  2.5     NA       0.1        1
      146 #FFCABB 17 2     1    50 16.5 17.5  1.5  2.5     NA       0.1        1
      147 #8D73FF 17 2     1    50 16.5 17.5  1.5  2.5     NA       0.1        1
      148 #FFBFBB 18 2     1    53 17.5 18.5  1.5  2.5     NA       0.1        1
      149 #FFCABB 18 2     1    53 17.5 18.5  1.5  2.5     NA       0.1        1
      150 #A798FF 18 2     1    53 17.5 18.5  1.5  2.5     NA       0.1        1
      151 #FFC2BB 19 2     1    56 18.5 19.5  1.5  2.5     NA       0.1        1
      152 #FFCABB 19 2     1    56 18.5 19.5  1.5  2.5     NA       0.1        1
      153 #A99CFF 19 2     1    56 18.5 19.5  1.5  2.5     NA       0.1        1
      154 #FFBDBB 20 2     1    59 19.5 20.5  1.5  2.5     NA       0.1        1
      155 #FFC9BB 20 2     1    59 19.5 20.5  1.5  2.5     NA       0.1        1
      156 #BBBDFF 20 2     1    59 19.5 20.5  1.5  2.5     NA       0.1        1
      157 #FFBCBB 21 2     1    62 20.5 21.5  1.5  2.5     NA       0.1        1
      158 #FFC8BB 21 2     1    62 20.5 21.5  1.5  2.5     NA       0.1        1
      159 #BAB9FF 21 2     1    62 20.5 21.5  1.5  2.5     NA       0.1        1
      160 #FFBBBB 22 2     1    65 21.5 22.5  1.5  2.5     NA       0.1        1
      161 #FFC6BB 22 2     1    65 21.5 22.5  1.5  2.5     NA       0.1        1
      162 #BBCAFF 22 2     1    65 21.5 22.5  1.5  2.5     NA       0.1        1
      163 #FFB7B5 23 2     1    68 22.5 23.5  1.5  2.5     NA       0.1        1
      164 #FFC8BB 23 2     1    68 22.5 23.5  1.5  2.5     NA       0.1        1
      165 #5B3CFF 23 2     1    68 22.5 23.5  1.5  2.5     NA       0.1        1
      166 #FFAAA3 24 2     1    71 23.5 24.5  1.5  2.5     NA       0.1        1
      167 #FFC4BB 24 2     1    71 23.5 24.5  1.5  2.5     NA       0.1        1
      168 #BBBFFF 24 2     1    71 23.5 24.5  1.5  2.5     NA       0.1        1
      169 #FFAAA3 25 2     1    74 24.5 25.5  1.5  2.5     NA       0.1        1
      170 #FFC4BB 25 2     1    74 24.5 25.5  1.5  2.5     NA       0.1        1
      171 #BBBFFF 25 2     1    74 24.5 25.5  1.5  2.5     NA       0.1        1
      172 #FFA59B 26 2     1    77 25.5 26.5  1.5  2.5     NA       0.1        1
      173 #FFC3BB 26 2     1    77 25.5 26.5  1.5  2.5     NA       0.1        1
      174 #BBC0FF 26 2     1    77 25.5 26.5  1.5  2.5     NA       0.1        1
      175 #FF988B 27 2     1    80 26.5 27.5  1.5  2.5     NA       0.1        1
      176 #FFC1BB 27 2     1    80 26.5 27.5  1.5  2.5     NA       0.1        1
      177 #BBC4FF 27 2     1    80 26.5 27.5  1.5  2.5     NA       0.1        1
      178 #FF8E7D 28 2     1    83 27.5 28.5  1.5  2.5     NA       0.1        1
      179 #FFC4BB 28 2     1    83 27.5 28.5  1.5  2.5     NA       0.1        1
      180 #5134FF 28 2     1    83 27.5 28.5  1.5  2.5     NA       0.1        1
      181 #FF9485 29 2     1    86 28.5 29.5  1.5  2.5     NA       0.1        1
      182 #FFC1BB 29 2     1    86 28.5 29.5  1.5  2.5     NA       0.1        1
      183 #BBBEFF 29 2     1    86 28.5 29.5  1.5  2.5     NA       0.1        1
      184 #FF9586 30 2     1    89 29.5 30.5  1.5  2.5     NA       0.1        1
      185 #FFC2BB 30 2     1    89 29.5 30.5  1.5  2.5     NA       0.1        1
      186 #BBBDFF 30 2     1    89 29.5 30.5  1.5  2.5     NA       0.1        1
      187 #FF816C 31 2     1    92 30.5 31.5  1.5  2.5     NA       0.1        1
      188 #FFC3BB 31 2     1    92 30.5 31.5  1.5  2.5     NA       0.1        1
      189 #3A21FF 31 2     1    92 30.5 31.5  1.5  2.5     NA       0.1        1
      190 #FF654C 32 2     1    95 31.5 32.5  1.5  2.5     NA       0.1        1
      191 #FFC1BB 32 2     1    95 31.5 32.5  1.5  2.5     NA       0.1        1
      192 #0000FF 32 2     1    95 31.5 32.5  1.5  2.5     NA       0.1        1
      193 #FFCBBB  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      194 #FFCCBB  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      195 #BBC8FF  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      196 #FFCBBB  2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1
      197 #BBCBFF  2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1
      198 #BBBDFF  2 3     1     6  1.5  2.5  2.5  3.5     NA       0.1        1
      199 #FFC5BB  3 3     1     9  2.5  3.5  2.5  3.5     NA       0.1        1
      200 #FFCABB  3 3     1     9  2.5  3.5  2.5  3.5     NA       0.1        1
      201 #BBBDFF  3 3     1     9  2.5  3.5  2.5  3.5     NA       0.1        1
      202 #FFC8BB  4 3     1    12  3.5  4.5  2.5  3.5     NA       0.1        1
      203 #FFCBBB  4 3     1    12  3.5  4.5  2.5  3.5     NA       0.1        1
      204 #BBBDFF  4 3     1    12  3.5  4.5  2.5  3.5     NA       0.1        1
      205 #FFCBBB  5 3     1    15  4.5  5.5  2.5  3.5     NA       0.1        1
      206 #BBC0FF  5 3     1    15  4.5  5.5  2.5  3.5     NA       0.1        1
      207 #957EFF  5 3     1    15  4.5  5.5  2.5  3.5     NA       0.1        1
      208 #FFC8BB  6 3     1    18  5.5  6.5  2.5  3.5     NA       0.1        1
      209 #BBC5FF  6 3     1    18  5.5  6.5  2.5  3.5     NA       0.1        1
      210 #9781FF  6 3     1    18  5.5  6.5  2.5  3.5     NA       0.1        1
      211 #FFC6BB  7 3     1    21  6.5  7.5  2.5  3.5     NA       0.1        1
      212 #BBC5FF  7 3     1    21  6.5  7.5  2.5  3.5     NA       0.1        1
      213 #6242FF  7 3     1    21  6.5  7.5  2.5  3.5     NA       0.1        1
      214 #FFC8BB  8 3     1    24  7.5  8.5  2.5  3.5     NA       0.1        1
      215 #BBC5FF  8 3     1    24  7.5  8.5  2.5  3.5     NA       0.1        1
      216 #866AFF  8 3     1    24  7.5  8.5  2.5  3.5     NA       0.1        1
      217 #FFC8BB  9 3     1    27  8.5  9.5  2.5  3.5     NA       0.1        1
      218 #BBC5FF  9 3     1    27  8.5  9.5  2.5  3.5     NA       0.1        1
      219 #866AFF  9 3     1    27  8.5  9.5  2.5  3.5     NA       0.1        1
      220 #FFC2BB 10 3     1    30  9.5 10.5  2.5  3.5     NA       0.1        1
      221 #FFCCBB 10 3     1    30  9.5 10.5  2.5  3.5     NA       0.1        1
      222 #6748FF 10 3     1    30  9.5 10.5  2.5  3.5     NA       0.1        1
      223 #FFC2BB 11 3     1    33 10.5 11.5  2.5  3.5     NA       0.1        1
      224 #FFCCBB 11 3     1    33 10.5 11.5  2.5  3.5     NA       0.1        1
      225 #6748FF 11 3     1    33 10.5 11.5  2.5  3.5     NA       0.1        1
      226 #FFC6BB 12 3     1    36 11.5 12.5  2.5  3.5     NA       0.1        1
      227 #FFCCBB 12 3     1    36 11.5 12.5  2.5  3.5     NA       0.1        1
      228 #B6B1FF 12 3     1    36 11.5 12.5  2.5  3.5     NA       0.1        1
      229 #FFC3BB 13 3     1    39 12.5 13.5  2.5  3.5     NA       0.1        1
      230 #FFCABB 13 3     1    39 12.5 13.5  2.5  3.5     NA       0.1        1
      231 #B6B1FF 13 3     1    39 12.5 13.5  2.5  3.5     NA       0.1        1
      232 #FFC3BB 14 3     1    42 13.5 14.5  2.5  3.5     NA       0.1        1
      233 #FFCABB 14 3     1    42 13.5 14.5  2.5  3.5     NA       0.1        1
      234 #B6B1FF 14 3     1    42 13.5 14.5  2.5  3.5     NA       0.1        1
      235 #FFC2BB 15 3     1    45 14.5 15.5  2.5  3.5     NA       0.1        1
      236 #FFCABB 15 3     1    45 14.5 15.5  2.5  3.5     NA       0.1        1
      237 #B5B0FF 15 3     1    45 14.5 15.5  2.5  3.5     NA       0.1        1
      238 #FFC2BB 16 3     1    48 15.5 16.5  2.5  3.5     NA       0.1        1
      239 #FFC8BB 16 3     1    48 15.5 16.5  2.5  3.5     NA       0.1        1
      240 #B4ADFF 16 3     1    48 15.5 16.5  2.5  3.5     NA       0.1        1
      241 #FFBDBB 17 3     1    51 16.5 17.5  2.5  3.5     NA       0.1        1
      242 #FFC8BB 17 3     1    51 16.5 17.5  2.5  3.5     NA       0.1        1
      243 #8B70FF 17 3     1    51 16.5 17.5  2.5  3.5     NA       0.1        1
      244 #FFBFBB 18 3     1    54 17.5 18.5  2.5  3.5     NA       0.1        1
      245 #FFC8BB 18 3     1    54 17.5 18.5  2.5  3.5     NA       0.1        1
      246 #A696FF 18 3     1    54 17.5 18.5  2.5  3.5     NA       0.1        1
      247 #FFBEBB 19 3     1    57 18.5 19.5  2.5  3.5     NA       0.1        1
      248 #FFC7BB 19 3     1    57 18.5 19.5  2.5  3.5     NA       0.1        1
      249 #A899FF 19 3     1    57 18.5 19.5  2.5  3.5     NA       0.1        1
      250 #FFADA7 20 3     1    60 19.5 20.5  2.5  3.5     NA       0.1        1
      251 #FFC5BB 20 3     1    60 19.5 20.5  2.5  3.5     NA       0.1        1
      252 #BBBCFF 20 3     1    60 19.5 20.5  2.5  3.5     NA       0.1        1
      253 #FF9E92 21 3     1    63 20.5 21.5  2.5  3.5     NA       0.1        1
      254 #FFC4BB 21 3     1    63 20.5 21.5  2.5  3.5     NA       0.1        1
      255 #B9B6FF 21 3     1    63 20.5 21.5  2.5  3.5     NA       0.1        1
      256 #FF9687 22 3     1    66 21.5 22.5  2.5  3.5     NA       0.1        1
      257 #FFC1BB 22 3     1    66 21.5 22.5  2.5  3.5     NA       0.1        1
      258 #BBC9FF 22 3     1    66 21.5 22.5  2.5  3.5     NA       0.1        1
      259 #FF8C7A 23 3     1    69 22.5 23.5  2.5  3.5     NA       0.1        1
      260 #FFC2BB 23 3     1    69 22.5 23.5  2.5  3.5     NA       0.1        1
      261 #BBBBFF 23 3     1    69 22.5 23.5  2.5  3.5     NA       0.1        1
      262 #FF7B65 24 3     1    72 23.5 24.5  2.5  3.5     NA       0.1        1
      263 #FFBDBB 24 3     1    72 23.5 24.5  2.5  3.5     NA       0.1        1
      264 #FFC9BB 24 3     1    72 23.5 24.5  2.5  3.5     NA       0.1        1
      265 #FF7963 25 3     1    75 24.5 25.5  2.5  3.5     NA       0.1        1
      266 #FFBDBB 25 3     1    75 24.5 25.5  2.5  3.5     NA       0.1        1
      267 #FFC9BB 25 3     1    75 24.5 25.5  2.5  3.5     NA       0.1        1
      268 #FF725B 26 3     1    78 25.5 26.5  2.5  3.5     NA       0.1        1
      269 #FFBDBB 26 3     1    78 25.5 26.5  2.5  3.5     NA       0.1        1
      270 #FFC9BB 26 3     1    78 25.5 26.5  2.5  3.5     NA       0.1        1
      271 #FF644B 27 3     1    81 26.5 27.5  2.5  3.5     NA       0.1        1
      272 #FFBBBB 27 3     1    81 26.5 27.5  2.5  3.5     NA       0.1        1
      273 #FFC8BB 27 3     1    81 26.5 27.5  2.5  3.5     NA       0.1        1
      274 #FF573D 28 3     1    84 27.5 28.5  2.5  3.5     NA       0.1        1
      275 #FFBEBB 28 3     1    84 27.5 28.5  2.5  3.5     NA       0.1        1
      276 #B7B4FF 28 3     1    84 27.5 28.5  2.5  3.5     NA       0.1        1
      277 #FF5F45 29 3     1    87 28.5 29.5  2.5  3.5     NA       0.1        1
      278 #FFB9B8 29 3     1    87 28.5 29.5  2.5  3.5     NA       0.1        1
      279 #FFC9BB 29 3     1    87 28.5 29.5  2.5  3.5     NA       0.1        1
      280 #FF6046 30 3     1    90 29.5 30.5  2.5  3.5     NA       0.1        1
      281 #FFBCBB 30 3     1    90 29.5 30.5  2.5  3.5     NA       0.1        1
      282 #FFCABB 30 3     1    90 29.5 30.5  2.5  3.5     NA       0.1        1
      283 #FF452C 31 3     1    93 30.5 31.5  2.5  3.5     NA       0.1        1
      284 #FFBDBB 31 3     1    93 30.5 31.5  2.5  3.5     NA       0.1        1
      285 #B0A7FF 31 3     1    93 30.5 31.5  2.5  3.5     NA       0.1        1
      286 #FF0000 32 3     1    96 31.5 32.5  2.5  3.5     NA       0.1        1
      287 #FFBABA 32 3     1    96 31.5 32.5  2.5  3.5     NA       0.1        1
      288 #A799FF 32 3     1    96 31.5 32.5  2.5  3.5     NA       0.1        1
          alpha width height
      1      NA    NA     NA
      2      NA    NA     NA
      3      NA    NA     NA
      4      NA    NA     NA
      5      NA    NA     NA
      6      NA    NA     NA
      7      NA    NA     NA
      8      NA    NA     NA
      9      NA    NA     NA
      10     NA    NA     NA
      11     NA    NA     NA
      12     NA    NA     NA
      13     NA    NA     NA
      14     NA    NA     NA
      15     NA    NA     NA
      16     NA    NA     NA
      17     NA    NA     NA
      18     NA    NA     NA
      19     NA    NA     NA
      20     NA    NA     NA
      21     NA    NA     NA
      22     NA    NA     NA
      23     NA    NA     NA
      24     NA    NA     NA
      25     NA    NA     NA
      26     NA    NA     NA
      27     NA    NA     NA
      28     NA    NA     NA
      29     NA    NA     NA
      30     NA    NA     NA
      31     NA    NA     NA
      32     NA    NA     NA
      33     NA    NA     NA
      34     NA    NA     NA
      35     NA    NA     NA
      36     NA    NA     NA
      37     NA    NA     NA
      38     NA    NA     NA
      39     NA    NA     NA
      40     NA    NA     NA
      41     NA    NA     NA
      42     NA    NA     NA
      43     NA    NA     NA
      44     NA    NA     NA
      45     NA    NA     NA
      46     NA    NA     NA
      47     NA    NA     NA
      48     NA    NA     NA
      49     NA    NA     NA
      50     NA    NA     NA
      51     NA    NA     NA
      52     NA    NA     NA
      53     NA    NA     NA
      54     NA    NA     NA
      55     NA    NA     NA
      56     NA    NA     NA
      57     NA    NA     NA
      58     NA    NA     NA
      59     NA    NA     NA
      60     NA    NA     NA
      61     NA    NA     NA
      62     NA    NA     NA
      63     NA    NA     NA
      64     NA    NA     NA
      65     NA    NA     NA
      66     NA    NA     NA
      67     NA    NA     NA
      68     NA    NA     NA
      69     NA    NA     NA
      70     NA    NA     NA
      71     NA    NA     NA
      72     NA    NA     NA
      73     NA    NA     NA
      74     NA    NA     NA
      75     NA    NA     NA
      76     NA    NA     NA
      77     NA    NA     NA
      78     NA    NA     NA
      79     NA    NA     NA
      80     NA    NA     NA
      81     NA    NA     NA
      82     NA    NA     NA
      83     NA    NA     NA
      84     NA    NA     NA
      85     NA    NA     NA
      86     NA    NA     NA
      87     NA    NA     NA
      88     NA    NA     NA
      89     NA    NA     NA
      90     NA    NA     NA
      91     NA    NA     NA
      92     NA    NA     NA
      93     NA    NA     NA
      94     NA    NA     NA
      95     NA    NA     NA
      96     NA    NA     NA
      97     NA    NA     NA
      98     NA    NA     NA
      99     NA    NA     NA
      100    NA    NA     NA
      101    NA    NA     NA
      102    NA    NA     NA
      103    NA    NA     NA
      104    NA    NA     NA
      105    NA    NA     NA
      106    NA    NA     NA
      107    NA    NA     NA
      108    NA    NA     NA
      109    NA    NA     NA
      110    NA    NA     NA
      111    NA    NA     NA
      112    NA    NA     NA
      113    NA    NA     NA
      114    NA    NA     NA
      115    NA    NA     NA
      116    NA    NA     NA
      117    NA    NA     NA
      118    NA    NA     NA
      119    NA    NA     NA
      120    NA    NA     NA
      121    NA    NA     NA
      122    NA    NA     NA
      123    NA    NA     NA
      124    NA    NA     NA
      125    NA    NA     NA
      126    NA    NA     NA
      127    NA    NA     NA
      128    NA    NA     NA
      129    NA    NA     NA
      130    NA    NA     NA
      131    NA    NA     NA
      132    NA    NA     NA
      133    NA    NA     NA
      134    NA    NA     NA
      135    NA    NA     NA
      136    NA    NA     NA
      137    NA    NA     NA
      138    NA    NA     NA
      139    NA    NA     NA
      140    NA    NA     NA
      141    NA    NA     NA
      142    NA    NA     NA
      143    NA    NA     NA
      144    NA    NA     NA
      145    NA    NA     NA
      146    NA    NA     NA
      147    NA    NA     NA
      148    NA    NA     NA
      149    NA    NA     NA
      150    NA    NA     NA
      151    NA    NA     NA
      152    NA    NA     NA
      153    NA    NA     NA
      154    NA    NA     NA
      155    NA    NA     NA
      156    NA    NA     NA
      157    NA    NA     NA
      158    NA    NA     NA
      159    NA    NA     NA
      160    NA    NA     NA
      161    NA    NA     NA
      162    NA    NA     NA
      163    NA    NA     NA
      164    NA    NA     NA
      165    NA    NA     NA
      166    NA    NA     NA
      167    NA    NA     NA
      168    NA    NA     NA
      169    NA    NA     NA
      170    NA    NA     NA
      171    NA    NA     NA
      172    NA    NA     NA
      173    NA    NA     NA
      174    NA    NA     NA
      175    NA    NA     NA
      176    NA    NA     NA
      177    NA    NA     NA
      178    NA    NA     NA
      179    NA    NA     NA
      180    NA    NA     NA
      181    NA    NA     NA
      182    NA    NA     NA
      183    NA    NA     NA
      184    NA    NA     NA
      185    NA    NA     NA
      186    NA    NA     NA
      187    NA    NA     NA
      188    NA    NA     NA
      189    NA    NA     NA
      190    NA    NA     NA
      191    NA    NA     NA
      192    NA    NA     NA
      193    NA    NA     NA
      194    NA    NA     NA
      195    NA    NA     NA
      196    NA    NA     NA
      197    NA    NA     NA
      198    NA    NA     NA
      199    NA    NA     NA
      200    NA    NA     NA
      201    NA    NA     NA
      202    NA    NA     NA
      203    NA    NA     NA
      204    NA    NA     NA
      205    NA    NA     NA
      206    NA    NA     NA
      207    NA    NA     NA
      208    NA    NA     NA
      209    NA    NA     NA
      210    NA    NA     NA
      211    NA    NA     NA
      212    NA    NA     NA
      213    NA    NA     NA
      214    NA    NA     NA
      215    NA    NA     NA
      216    NA    NA     NA
      217    NA    NA     NA
      218    NA    NA     NA
      219    NA    NA     NA
      220    NA    NA     NA
      221    NA    NA     NA
      222    NA    NA     NA
      223    NA    NA     NA
      224    NA    NA     NA
      225    NA    NA     NA
      226    NA    NA     NA
      227    NA    NA     NA
      228    NA    NA     NA
      229    NA    NA     NA
      230    NA    NA     NA
      231    NA    NA     NA
      232    NA    NA     NA
      233    NA    NA     NA
      234    NA    NA     NA
      235    NA    NA     NA
      236    NA    NA     NA
      237    NA    NA     NA
      238    NA    NA     NA
      239    NA    NA     NA
      240    NA    NA     NA
      241    NA    NA     NA
      242    NA    NA     NA
      243    NA    NA     NA
      244    NA    NA     NA
      245    NA    NA     NA
      246    NA    NA     NA
      247    NA    NA     NA
      248    NA    NA     NA
      249    NA    NA     NA
      250    NA    NA     NA
      251    NA    NA     NA
      252    NA    NA     NA
      253    NA    NA     NA
      254    NA    NA     NA
      255    NA    NA     NA
      256    NA    NA     NA
      257    NA    NA     NA
      258    NA    NA     NA
      259    NA    NA     NA
      260    NA    NA     NA
      261    NA    NA     NA
      262    NA    NA     NA
      263    NA    NA     NA
      264    NA    NA     NA
      265    NA    NA     NA
      266    NA    NA     NA
      267    NA    NA     NA
      268    NA    NA     NA
      269    NA    NA     NA
      270    NA    NA     NA
      271    NA    NA     NA
      272    NA    NA     NA
      273    NA    NA     NA
      274    NA    NA     NA
      275    NA    NA     NA
      276    NA    NA     NA
      277    NA    NA     NA
      278    NA    NA     NA
      279    NA    NA     NA
      280    NA    NA     NA
      281    NA    NA     NA
      282    NA    NA     NA
      283    NA    NA     NA
      284    NA    NA     NA
      285    NA    NA     NA
      286    NA    NA     NA
      287    NA    NA     NA
      288    NA    NA     NA
      
      $Asia$d2$`model:carb`
             fill  x y PANEL group xmin xmax ymin ymax colour linewidth linetype
      1   #BBC4FF  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      2   #BBC4FF  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      3   #BBC4FF  1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      4   #BBC4FF  2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1
      5   #BBC4FF  2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1
      6   #BBC4FF  2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1
      7   #BBC4FF  3 1     1    11  2.5  3.5  0.5  1.5     NA       0.1        1
      8   #BBC4FF  3 1     1    11  2.5  3.5  0.5  1.5     NA       0.1        1
      9   #BBC4FF  3 1     1    11  2.5  3.5  0.5  1.5     NA       0.1        1
      10  #BBC4FF  4 1     1    16  3.5  4.5  0.5  1.5     NA       0.1        1
      11  #BBC4FF  4 1     1    16  3.5  4.5  0.5  1.5     NA       0.1        1
      12  #BBC4FF  4 1     1    16  3.5  4.5  0.5  1.5     NA       0.1        1
      13  #BBC4FF  5 1     1    21  4.5  5.5  0.5  1.5     NA       0.1        1
      14  #BBC4FF  5 1     1    21  4.5  5.5  0.5  1.5     NA       0.1        1
      15  #BBC4FF  5 1     1    21  4.5  5.5  0.5  1.5     NA       0.1        1
      16  #BBC5FF  6 1     1    26  5.5  6.5  0.5  1.5     NA       0.1        1
      17  #BBC4FF  6 1     1    26  5.5  6.5  0.5  1.5     NA       0.1        1
      18  #BBC2FF  6 1     1    26  5.5  6.5  0.5  1.5     NA       0.1        1
      19  #FFCABB  7 1     1    31  6.5  7.5  0.5  1.5     NA       0.1        1
      20  #BBC4FF  7 1     1    31  6.5  7.5  0.5  1.5     NA       0.1        1
      21  #B5B1FF  7 1     1    31  6.5  7.5  0.5  1.5     NA       0.1        1
      22  #FFB1AC  8 1     1    36  7.5  8.5  0.5  1.5     NA       0.1        1
      23  #BBC4FF  8 1     1    36  7.5  8.5  0.5  1.5     NA       0.1        1
      24  #A493FF  8 1     1    36  7.5  8.5  0.5  1.5     NA       0.1        1
      25  #FFA79F  9 1     1    41  8.5  9.5  0.5  1.5     NA       0.1        1
      26  #BBC4FF  9 1     1    41  8.5  9.5  0.5  1.5     NA       0.1        1
      27  #A18FFF  9 1     1    41  8.5  9.5  0.5  1.5     NA       0.1        1
      28  #FF9E92 10 1     1    46  9.5 10.5  0.5  1.5     NA       0.1        1
      29  #BBC4FF 10 1     1    46  9.5 10.5  0.5  1.5     NA       0.1        1
      30  #9E8BFF 10 1     1    46  9.5 10.5  0.5  1.5     NA       0.1        1
      31  #FF9E92 11 1     1    51 10.5 11.5  0.5  1.5     NA       0.1        1
      32  #BBC4FF 11 1     1    51 10.5 11.5  0.5  1.5     NA       0.1        1
      33  #9E8BFF 11 1     1    51 10.5 11.5  0.5  1.5     NA       0.1        1
      34  #BBCAFF 12 1     1    56 11.5 12.5  0.5  1.5     NA       0.1        1
      35  #BBC4FF 12 1     1    56 11.5 12.5  0.5  1.5     NA       0.1        1
      36  #BBBEFF 12 1     1    56 11.5 12.5  0.5  1.5     NA       0.1        1
      37  #BBCAFF 13 1     1    61 12.5 13.5  0.5  1.5     NA       0.1        1
      38  #BBC4FF 13 1     1    61 12.5 13.5  0.5  1.5     NA       0.1        1
      39  #BBBEFF 13 1     1    61 12.5 13.5  0.5  1.5     NA       0.1        1
      40  #BBCAFF 14 1     1    66 13.5 14.5  0.5  1.5     NA       0.1        1
      41  #BBC4FF 14 1     1    66 13.5 14.5  0.5  1.5     NA       0.1        1
      42  #BBBEFF 14 1     1    66 13.5 14.5  0.5  1.5     NA       0.1        1
      43  #BBCAFF 15 1     1    71 14.5 15.5  0.5  1.5     NA       0.1        1
      44  #BBC4FF 15 1     1    71 14.5 15.5  0.5  1.5     NA       0.1        1
      45  #BBBEFF 15 1     1    71 14.5 15.5  0.5  1.5     NA       0.1        1
      46  #BBCAFF 16 1     1    76 15.5 16.5  0.5  1.5     NA       0.1        1
      47  #BBC4FF 16 1     1    76 15.5 16.5  0.5  1.5     NA       0.1        1
      48  #BBBEFF 16 1     1    76 15.5 16.5  0.5  1.5     NA       0.1        1
      49  #FFC9BB 17 1     1    81 16.5 17.5  0.5  1.5     NA       0.1        1
      50  #BBC4FF 17 1     1    81 16.5 17.5  0.5  1.5     NA       0.1        1
      51  #B5AFFF 17 1     1    81 16.5 17.5  0.5  1.5     NA       0.1        1
      52  #FFA399 18 1     1    86 17.5 18.5  0.5  1.5     NA       0.1        1
      53  #BBC4FF 18 1     1    86 17.5 18.5  0.5  1.5     NA       0.1        1
      54  #9F8CFF 18 1     1    86 17.5 18.5  0.5  1.5     NA       0.1        1
      55  #FF674E 19 1     1    91 18.5 19.5  0.5  1.5     NA       0.1        1
      56  #BBC4FF 19 1     1    91 18.5 19.5  0.5  1.5     NA       0.1        1
      57  #8E74FF 19 1     1    91 18.5 19.5  0.5  1.5     NA       0.1        1
      58  #FF674D 20 1     1    96 19.5 20.5  0.5  1.5     NA       0.1        1
      59  #BBC4FF 20 1     1    96 19.5 20.5  0.5  1.5     NA       0.1        1
      60  #8E73FF 20 1     1    96 19.5 20.5  0.5  1.5     NA       0.1        1
      61  #FF5C42 21 1     1   101 20.5 21.5  0.5  1.5     NA       0.1        1
      62  #BBC4FF 21 1     1   101 20.5 21.5  0.5  1.5     NA       0.1        1
      63  #8B70FF 21 1     1   101 20.5 21.5  0.5  1.5     NA       0.1        1
      64  #FF5C42 22 1     1   106 21.5 22.5  0.5  1.5     NA       0.1        1
      65  #BBC4FF 22 1     1   106 21.5 22.5  0.5  1.5     NA       0.1        1
      66  #8B70FF 22 1     1   106 21.5 22.5  0.5  1.5     NA       0.1        1
      67  #BBCBFF 23 1     1   111 22.5 23.5  0.5  1.5     NA       0.1        1
      68  #BBC4FF 23 1     1   111 22.5 23.5  0.5  1.5     NA       0.1        1
      69  #BBBDFF 23 1     1   111 22.5 23.5  0.5  1.5     NA       0.1        1
      70  #BBCBFF 24 1     1   116 23.5 24.5  0.5  1.5     NA       0.1        1
      71  #BBC4FF 24 1     1   116 23.5 24.5  0.5  1.5     NA       0.1        1
      72  #BBBDFF 24 1     1   116 23.5 24.5  0.5  1.5     NA       0.1        1
      73  #BBCBFF 25 1     1   121 24.5 25.5  0.5  1.5     NA       0.1        1
      74  #BBC4FF 25 1     1   121 24.5 25.5  0.5  1.5     NA       0.1        1
      75  #BBBDFF 25 1     1   121 24.5 25.5  0.5  1.5     NA       0.1        1
      76  #BBCBFF 26 1     1   126 25.5 26.5  0.5  1.5     NA       0.1        1
      77  #BBC4FF 26 1     1   126 25.5 26.5  0.5  1.5     NA       0.1        1
      78  #BBBDFF 26 1     1   126 25.5 26.5  0.5  1.5     NA       0.1        1
      79  #BBCBFF 27 1     1   131 26.5 27.5  0.5  1.5     NA       0.1        1
      80  #BBC4FF 27 1     1   131 26.5 27.5  0.5  1.5     NA       0.1        1
      81  #BBBDFF 27 1     1   131 26.5 27.5  0.5  1.5     NA       0.1        1
      82  #FFC1BB 28 1     1   136 27.5 28.5  0.5  1.5     NA       0.1        1
      83  #BBC4FF 28 1     1   136 27.5 28.5  0.5  1.5     NA       0.1        1
      84  #ADA2FF 28 1     1   136 27.5 28.5  0.5  1.5     NA       0.1        1
      85  #FF735B 29 1     1   141 28.5 29.5  0.5  1.5     NA       0.1        1
      86  #BBC4FF 29 1     1   141 28.5 29.5  0.5  1.5     NA       0.1        1
      87  #9077FF 29 1     1   141 28.5 29.5  0.5  1.5     NA       0.1        1
      88  #FF5137 30 1     1   146 29.5 30.5  0.5  1.5     NA       0.1        1
      89  #BBC4FF 30 1     1   146 29.5 30.5  0.5  1.5     NA       0.1        1
      90  #876BFF 30 1     1   146 29.5 30.5  0.5  1.5     NA       0.1        1
      91  #FF482E 31 1     1   151 30.5 31.5  0.5  1.5     NA       0.1        1
      92  #BBC4FF 31 1     1   151 30.5 31.5  0.5  1.5     NA       0.1        1
      93  #8568FF 31 1     1   151 30.5 31.5  0.5  1.5     NA       0.1        1
      94  #FF442B 32 1     1   156 31.5 32.5  0.5  1.5     NA       0.1        1
      95  #BBC4FF 32 1     1   156 31.5 32.5  0.5  1.5     NA       0.1        1
      96  #8467FF 32 1     1   156 31.5 32.5  0.5  1.5     NA       0.1        1
      97  #FFC8BB  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      98  #BBC4FF  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      99  #ADA2FF  1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      100 #FFC8BB  2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1
      101 #BBC4FF  2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1
      102 #ADA2FF  2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1
      103 #FFC8BB  3 2     1    12  2.5  3.5  1.5  2.5     NA       0.1        1
      104 #BBC4FF  3 2     1    12  2.5  3.5  1.5  2.5     NA       0.1        1
      105 #ADA2FF  3 2     1    12  2.5  3.5  1.5  2.5     NA       0.1        1
      106 #FFC8BB  4 2     1    17  3.5  4.5  1.5  2.5     NA       0.1        1
      107 #BBC4FF  4 2     1    17  3.5  4.5  1.5  2.5     NA       0.1        1
      108 #ADA2FF  4 2     1    17  3.5  4.5  1.5  2.5     NA       0.1        1
      109 #FFC8BB  5 2     1    22  4.5  5.5  1.5  2.5     NA       0.1        1
      110 #BBC4FF  5 2     1    22  4.5  5.5  1.5  2.5     NA       0.1        1
      111 #ADA1FF  5 2     1    22  4.5  5.5  1.5  2.5     NA       0.1        1
      112 #FFC5BB  6 2     1    27  5.5  6.5  1.5  2.5     NA       0.1        1
      113 #BBC4FF  6 2     1    27  5.5  6.5  1.5  2.5     NA       0.1        1
      114 #A899FF  6 2     1    27  5.5  6.5  1.5  2.5     NA       0.1        1
      115 #FF9180  7 2     1    32  6.5  7.5  1.5  2.5     NA       0.1        1
      116 #BBC4FF  7 2     1    32  6.5  7.5  1.5  2.5     NA       0.1        1
      117 #886CFF  7 2     1    32  6.5  7.5  1.5  2.5     NA       0.1        1
      118 #FF3C24  8 2     1    37  7.5  8.5  1.5  2.5     NA       0.1        1
      119 #BBC4FF  8 2     1    37  7.5  8.5  1.5  2.5     NA       0.1        1
      120 #6D4DFF  8 2     1    37  7.5  8.5  1.5  2.5     NA       0.1        1
      121 #FF2714  9 2     1    42  8.5  9.5  1.5  2.5     NA       0.1        1
      122 #BBC4FF  9 2     1    42  8.5  9.5  1.5  2.5     NA       0.1        1
      123 #6849FF  9 2     1    42  8.5  9.5  1.5  2.5     NA       0.1        1
      124 #FF0000 10 2     1    47  9.5 10.5  1.5  2.5     NA       0.1        1
      125 #BBC4FF 10 2     1    47  9.5 10.5  1.5  2.5     NA       0.1        1
      126 #6444FF 10 2     1    47  9.5 10.5  1.5  2.5     NA       0.1        1
      127 #FF0000 11 2     1    52 10.5 11.5  1.5  2.5     NA       0.1        1
      128 #BBC4FF 11 2     1    52 10.5 11.5  1.5  2.5     NA       0.1        1
      129 #6444FF 11 2     1    52 10.5 11.5  1.5  2.5     NA       0.1        1
      130 #FFC8BB 12 2     1    57 11.5 12.5  1.5  2.5     NA       0.1        1
      131 #BBC4FF 12 2     1    57 11.5 12.5  1.5  2.5     NA       0.1        1
      132 #ACA1FF 12 2     1    57 11.5 12.5  1.5  2.5     NA       0.1        1
      133 #FFC9BB 13 2     1    62 12.5 13.5  1.5  2.5     NA       0.1        1
      134 #BBC4FF 13 2     1    62 12.5 13.5  1.5  2.5     NA       0.1        1
      135 #ACA1FF 13 2     1    62 12.5 13.5  1.5  2.5     NA       0.1        1
      136 #FFCABB 14 2     1    67 13.5 14.5  1.5  2.5     NA       0.1        1
      137 #BBC4FF 14 2     1    67 13.5 14.5  1.5  2.5     NA       0.1        1
      138 #ACA1FF 14 2     1    67 13.5 14.5  1.5  2.5     NA       0.1        1
      139 #BBCCFF 15 2     1    72 14.5 15.5  1.5  2.5     NA       0.1        1
      140 #BBC3FF 15 2     1    72 14.5 15.5  1.5  2.5     NA       0.1        1
      141 #ACA1FF 15 2     1    72 14.5 15.5  1.5  2.5     NA       0.1        1
      142 #BBCBFF 16 2     1    77 15.5 16.5  1.5  2.5     NA       0.1        1
      143 #BBC3FF 16 2     1    77 15.5 16.5  1.5  2.5     NA       0.1        1
      144 #ACA0FF 16 2     1    77 15.5 16.5  1.5  2.5     NA       0.1        1
      145 #FFC9BB 17 2     1    82 16.5 17.5  1.5  2.5     NA       0.1        1
      146 #BBC2FF 17 2     1    82 16.5 17.5  1.5  2.5     NA       0.1        1
      147 #9A84FF 17 2     1    82 16.5 17.5  1.5  2.5     NA       0.1        1
      148 #FFBABA 18 2     1    87 17.5 18.5  1.5  2.5     NA       0.1        1
      149 #BBC0FF 18 2     1    87 17.5 18.5  1.5  2.5     NA       0.1        1
      150 #7657FF 18 2     1    87 17.5 18.5  1.5  2.5     NA       0.1        1
      151 #FF9485 19 2     1    92 18.5 19.5  1.5  2.5     NA       0.1        1
      152 #BBBFFF 19 2     1    92 18.5 19.5  1.5  2.5     NA       0.1        1
      153 #593AFF 19 2     1    92 18.5 19.5  1.5  2.5     NA       0.1        1
      154 #FFA298 20 2     1    97 19.5 20.5  1.5  2.5     NA       0.1        1
      155 #BBBFFF 20 2     1    97 19.5 20.5  1.5  2.5     NA       0.1        1
      156 #593AFF 20 2     1    97 19.5 20.5  1.5  2.5     NA       0.1        1
      157 #FFA49A 21 2     1   102 20.5 21.5  1.5  2.5     NA       0.1        1
      158 #BBBEFF 21 2     1   102 20.5 21.5  1.5  2.5     NA       0.1        1
      159 #5436FF 21 2     1   102 20.5 21.5  1.5  2.5     NA       0.1        1
      160 #FFABA3 22 2     1   107 21.5 22.5  1.5  2.5     NA       0.1        1
      161 #BBBEFF 22 2     1   107 21.5 22.5  1.5  2.5     NA       0.1        1
      162 #5134FF 22 2     1   107 21.5 22.5  1.5  2.5     NA       0.1        1
      163 #BBC1FF 23 2     1   112 22.5 23.5  1.5  2.5     NA       0.1        1
      164 #BBBEFF 23 2     1   112 22.5 23.5  1.5  2.5     NA       0.1        1
      165 #B6B2FF 23 2     1   112 22.5 23.5  1.5  2.5     NA       0.1        1
      166 #BBC1FF 24 2     1   117 23.5 24.5  1.5  2.5     NA       0.1        1
      167 #BBBEFF 24 2     1   117 23.5 24.5  1.5  2.5     NA       0.1        1
      168 #B6B2FF 24 2     1   117 23.5 24.5  1.5  2.5     NA       0.1        1
      169 #BBC1FF 25 2     1   122 24.5 25.5  1.5  2.5     NA       0.1        1
      170 #BBBEFF 25 2     1   122 24.5 25.5  1.5  2.5     NA       0.1        1
      171 #B6B2FF 25 2     1   122 24.5 25.5  1.5  2.5     NA       0.1        1
      172 #BBC1FF 26 2     1   127 25.5 26.5  1.5  2.5     NA       0.1        1
      173 #BBBEFF 26 2     1   127 25.5 26.5  1.5  2.5     NA       0.1        1
      174 #B6B2FF 26 2     1   127 25.5 26.5  1.5  2.5     NA       0.1        1
      175 #BBC1FF 27 2     1   132 26.5 27.5  1.5  2.5     NA       0.1        1
      176 #BBBEFF 27 2     1   132 26.5 27.5  1.5  2.5     NA       0.1        1
      177 #B6B2FF 27 2     1   132 26.5 27.5  1.5  2.5     NA       0.1        1
      178 #BBC2FF 28 2     1   137 27.5 28.5  1.5  2.5     NA       0.1        1
      179 #BBBDFF 28 2     1   137 27.5 28.5  1.5  2.5     NA       0.1        1
      180 #B7B4FF 28 2     1   137 27.5 28.5  1.5  2.5     NA       0.1        1
      181 #BBC6FF 29 2     1   142 28.5 29.5  1.5  2.5     NA       0.1        1
      182 #BBBDFF 29 2     1   142 28.5 29.5  1.5  2.5     NA       0.1        1
      183 #9E8AFF 29 2     1   142 28.5 29.5  1.5  2.5     NA       0.1        1
      184 #BBC9FF 30 2     1   147 29.5 30.5  1.5  2.5     NA       0.1        1
      185 #BBBDFF 30 2     1   147 29.5 30.5  1.5  2.5     NA       0.1        1
      186 #967EFF 30 2     1   147 29.5 30.5  1.5  2.5     NA       0.1        1
      187 #BBC9FF 31 2     1   152 30.5 31.5  1.5  2.5     NA       0.1        1
      188 #BBBDFF 31 2     1   152 30.5 31.5  1.5  2.5     NA       0.1        1
      189 #947BFF 31 2     1   152 30.5 31.5  1.5  2.5     NA       0.1        1
      190 #BBC9FF 32 2     1   157 31.5 32.5  1.5  2.5     NA       0.1        1
      191 #BBBDFF 32 2     1   157 31.5 32.5  1.5  2.5     NA       0.1        1
      192 #937BFF 32 2     1   157 31.5 32.5  1.5  2.5     NA       0.1        1
      193 #BBCAFF  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      194 #BBC4FF  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      195 #BBBEFF  1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      196 #BBCAFF  2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1
      197 #BBC3FF  2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1
      198 #BBBEFF  2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1
      199 #BBCAFF  3 3     1    13  2.5  3.5  2.5  3.5     NA       0.1        1
      200 #BBC3FF  3 3     1    13  2.5  3.5  2.5  3.5     NA       0.1        1
      201 #BBBEFF  3 3     1    13  2.5  3.5  2.5  3.5     NA       0.1        1
      202 #BBCAFF  4 3     1    18  3.5  4.5  2.5  3.5     NA       0.1        1
      203 #BBC3FF  4 3     1    18  3.5  4.5  2.5  3.5     NA       0.1        1
      204 #BBBEFF  4 3     1    18  3.5  4.5  2.5  3.5     NA       0.1        1
      205 #BBCAFF  5 3     1    23  4.5  5.5  2.5  3.5     NA       0.1        1
      206 #BBC3FF  5 3     1    23  4.5  5.5  2.5  3.5     NA       0.1        1
      207 #BBBEFF  5 3     1    23  4.5  5.5  2.5  3.5     NA       0.1        1
      208 #BBCBFF  6 3     1    28  5.5  6.5  2.5  3.5     NA       0.1        1
      209 #BBC3FF  6 3     1    28  5.5  6.5  2.5  3.5     NA       0.1        1
      210 #BBBCFF  6 3     1    28  5.5  6.5  2.5  3.5     NA       0.1        1
      211 #FFBAB9  7 3     1    33  6.5  7.5  2.5  3.5     NA       0.1        1
      212 #BBC3FF  7 3     1    33  6.5  7.5  2.5  3.5     NA       0.1        1
      213 #A594FF  7 3     1    33  6.5  7.5  2.5  3.5     NA       0.1        1
      214 #FF745D  8 3     1    38  7.5  8.5  2.5  3.5     NA       0.1        1
      215 #BBC3FF  8 3     1    38  7.5  8.5  2.5  3.5     NA       0.1        1
      216 #9076FF  8 3     1    38  7.5  8.5  2.5  3.5     NA       0.1        1
      217 #FF694F  9 3     1    43  8.5  9.5  2.5  3.5     NA       0.1        1
      218 #BBC3FF  9 3     1    43  8.5  9.5  2.5  3.5     NA       0.1        1
      219 #8D72FF  9 3     1    43  8.5  9.5  2.5  3.5     NA       0.1        1
      220 #FF5E44 10 3     1    48  9.5 10.5  2.5  3.5     NA       0.1        1
      221 #BBC3FF 10 3     1    48  9.5 10.5  2.5  3.5     NA       0.1        1
      222 #896EFF 10 3     1    48  9.5 10.5  2.5  3.5     NA       0.1        1
      223 #FF5F45 11 3     1    53 10.5 11.5  2.5  3.5     NA       0.1        1
      224 #BBC3FF 11 3     1    53 10.5 11.5  2.5  3.5     NA       0.1        1
      225 #896EFF 11 3     1    53 10.5 11.5  2.5  3.5     NA       0.1        1
      226 #BBCBFF 12 3     1    58 11.5 12.5  2.5  3.5     NA       0.1        1
      227 #BBC3FF 12 3     1    58 11.5 12.5  2.5  3.5     NA       0.1        1
      228 #BBBCFF 12 3     1    58 11.5 12.5  2.5  3.5     NA       0.1        1
      229 #BBCAFF 13 3     1    63 12.5 13.5  2.5  3.5     NA       0.1        1
      230 #BBC3FF 13 3     1    63 12.5 13.5  2.5  3.5     NA       0.1        1
      231 #BBBCFF 13 3     1    63 12.5 13.5  2.5  3.5     NA       0.1        1
      232 #BBCAFF 14 3     1    68 13.5 14.5  2.5  3.5     NA       0.1        1
      233 #BBC3FF 14 3     1    68 13.5 14.5  2.5  3.5     NA       0.1        1
      234 #BBBCFF 14 3     1    68 13.5 14.5  2.5  3.5     NA       0.1        1
      235 #BBC9FF 15 3     1    73 14.5 15.5  2.5  3.5     NA       0.1        1
      236 #BBC2FF 15 3     1    73 14.5 15.5  2.5  3.5     NA       0.1        1
      237 #BBBCFF 15 3     1    73 14.5 15.5  2.5  3.5     NA       0.1        1
      238 #BBC8FF 16 3     1    78 15.5 16.5  2.5  3.5     NA       0.1        1
      239 #BBC2FF 16 3     1    78 15.5 16.5  2.5  3.5     NA       0.1        1
      240 #BBBCFF 16 3     1    78 15.5 16.5  2.5  3.5     NA       0.1        1
      241 #BBC9FF 17 3     1    83 16.5 17.5  2.5  3.5     NA       0.1        1
      242 #BBC1FF 17 3     1    83 16.5 17.5  2.5  3.5     NA       0.1        1
      243 #ADA1FF 17 3     1    83 16.5 17.5  2.5  3.5     NA       0.1        1
      244 #FFC7BB 18 3     1    88 17.5 18.5  2.5  3.5     NA       0.1        1
      245 #BBBEFF 18 3     1    88 17.5 18.5  2.5  3.5     NA       0.1        1
      246 #8E74FF 18 3     1    88 17.5 18.5  2.5  3.5     NA       0.1        1
      247 #FFC0BB 19 3     1    93 18.5 19.5  2.5  3.5     NA       0.1        1
      248 #BBBDFF 19 3     1    93 18.5 19.5  2.5  3.5     NA       0.1        1
      249 #785AFF 19 3     1    93 18.5 19.5  2.5  3.5     NA       0.1        1
      250 #FFC5BB 20 3     1    98 19.5 20.5  2.5  3.5     NA       0.1        1
      251 #BBBCFF 20 3     1    98 19.5 20.5  2.5  3.5     NA       0.1        1
      252 #7859FF 20 3     1    98 19.5 20.5  2.5  3.5     NA       0.1        1
      253 #FFC7BB 21 3     1   103 20.5 21.5  2.5  3.5     NA       0.1        1
      254 #BBBAFF 21 3     1   103 20.5 21.5  2.5  3.5     NA       0.1        1
      255 #6F50FF 21 3     1   103 20.5 21.5  2.5  3.5     NA       0.1        1
      256 #FFCCBB 22 3     1   108 21.5 22.5  2.5  3.5     NA       0.1        1
      257 #B6B2FF 22 3     1   108 21.5 22.5  2.5  3.5     NA       0.1        1
      258 #6343FF 22 3     1   108 21.5 22.5  2.5  3.5     NA       0.1        1
      259 #BBBEFF 23 3     1   113 22.5 23.5  2.5  3.5     NA       0.1        1
      260 #B2ABFF 23 3     1   113 22.5 23.5  2.5  3.5     NA       0.1        1
      261 #937BFF 23 3     1   113 22.5 23.5  2.5  3.5     NA       0.1        1
      262 #BBBCFF 24 3     1   118 23.5 24.5  2.5  3.5     NA       0.1        1
      263 #B0A6FF 24 3     1   118 23.5 24.5  2.5  3.5     NA       0.1        1
      264 #9279FF 24 3     1   118 23.5 24.5  2.5  3.5     NA       0.1        1
      265 #BAB9FF 25 3     1   123 24.5 25.5  2.5  3.5     NA       0.1        1
      266 #ADA2FF 25 3     1   123 24.5 25.5  2.5  3.5     NA       0.1        1
      267 #9279FF 25 3     1   123 24.5 25.5  2.5  3.5     NA       0.1        1
      268 #B9B8FF 26 3     1   128 25.5 26.5  2.5  3.5     NA       0.1        1
      269 #AB9EFF 26 3     1   128 25.5 26.5  2.5  3.5     NA       0.1        1
      270 #9178FF 26 3     1   128 25.5 26.5  2.5  3.5     NA       0.1        1
      271 #B9B7FF 27 3     1   133 26.5 27.5  2.5  3.5     NA       0.1        1
      272 #A99BFF 27 3     1   133 26.5 27.5  2.5  3.5     NA       0.1        1
      273 #9178FF 27 3     1   133 26.5 27.5  2.5  3.5     NA       0.1        1
      274 #BBBDFF 28 3     1   138 27.5 28.5  2.5  3.5     NA       0.1        1
      275 #A89AFF 28 3     1   138 27.5 28.5  2.5  3.5     NA       0.1        1
      276 #7758FF 28 3     1   138 27.5 28.5  2.5  3.5     NA       0.1        1
      277 #BBC3FF 29 3     1   143 28.5 29.5  2.5  3.5     NA       0.1        1
      278 #A89AFF 29 3     1   143 28.5 29.5  2.5  3.5     NA       0.1        1
      279 #4026FF 29 3     1   143 28.5 29.5  2.5  3.5     NA       0.1        1
      280 #BBC6FF 30 3     1   148 29.5 30.5  2.5  3.5     NA       0.1        1
      281 #A89AFF 30 3     1   148 29.5 30.5  2.5  3.5     NA       0.1        1
      282 #2412FF 30 3     1   148 29.5 30.5  2.5  3.5     NA       0.1        1
      283 #BBC6FF 31 3     1   153 30.5 31.5  2.5  3.5     NA       0.1        1
      284 #A89AFF 31 3     1   153 30.5 31.5  2.5  3.5     NA       0.1        1
      285 #1A0BFF 31 3     1   153 30.5 31.5  2.5  3.5     NA       0.1        1
      286 #BBC6FF 32 3     1   158 31.5 32.5  2.5  3.5     NA       0.1        1
      287 #A89AFF 32 3     1   158 31.5 32.5  2.5  3.5     NA       0.1        1
      288 #180AFF 32 3     1   158 31.5 32.5  2.5  3.5     NA       0.1        1
      289 #FFC8BB  1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      290 #BBC3FF  1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      291 #ADA1FF  1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      292 #FFC9BB  2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1
      293 #BBC2FF  2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1
      294 #ACA1FF  2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1
      295 #FFC9BB  3 4     1    14  2.5  3.5  3.5  4.5     NA       0.1        1
      296 #BBC2FF  3 4     1    14  2.5  3.5  3.5  4.5     NA       0.1        1
      297 #ADA1FF  3 4     1    14  2.5  3.5  3.5  4.5     NA       0.1        1
      298 #FFC9BB  4 4     1    19  3.5  4.5  3.5  4.5     NA       0.1        1
      299 #BBC2FF  4 4     1    19  3.5  4.5  3.5  4.5     NA       0.1        1
      300 #ACA1FF  4 4     1    19  3.5  4.5  3.5  4.5     NA       0.1        1
      301 #FFC9BB  5 4     1    24  4.5  5.5  3.5  4.5     NA       0.1        1
      302 #BBC2FF  5 4     1    24  4.5  5.5  3.5  4.5     NA       0.1        1
      303 #ACA0FF  5 4     1    24  4.5  5.5  3.5  4.5     NA       0.1        1
      304 #FFC6BB  6 4     1    29  5.5  6.5  3.5  4.5     NA       0.1        1
      305 #BBC2FF  6 4     1    29  5.5  6.5  3.5  4.5     NA       0.1        1
      306 #A798FF  6 4     1    29  5.5  6.5  3.5  4.5     NA       0.1        1
      307 #FF9384  7 4     1    34  6.5  7.5  3.5  4.5     NA       0.1        1
      308 #BBC2FF  7 4     1    34  6.5  7.5  3.5  4.5     NA       0.1        1
      309 #876BFF  7 4     1    34  6.5  7.5  3.5  4.5     NA       0.1        1
      310 #FF4128  8 4     1    39  7.5  8.5  3.5  4.5     NA       0.1        1
      311 #BBC2FF  8 4     1    39  7.5  8.5  3.5  4.5     NA       0.1        1
      312 #6B4CFF  8 4     1    39  7.5  8.5  3.5  4.5     NA       0.1        1
      313 #FF2E19  9 4     1    44  8.5  9.5  3.5  4.5     NA       0.1        1
      314 #BBC2FF  9 4     1    44  8.5  9.5  3.5  4.5     NA       0.1        1
      315 #6647FF  9 4     1    44  8.5  9.5  3.5  4.5     NA       0.1        1
      316 #FF1407 10 4     1    49  9.5 10.5  3.5  4.5     NA       0.1        1
      317 #BBC2FF 10 4     1    49  9.5 10.5  3.5  4.5     NA       0.1        1
      318 #6041FF 10 4     1    49  9.5 10.5  3.5  4.5     NA       0.1        1
      319 #FF1809 11 4     1    54 10.5 11.5  3.5  4.5     NA       0.1        1
      320 #BBC2FF 11 4     1    54 10.5 11.5  3.5  4.5     NA       0.1        1
      321 #6041FF 11 4     1    54 10.5 11.5  3.5  4.5     NA       0.1        1
      322 #BBC4FF 12 4     1    59 11.5 12.5  3.5  4.5     NA       0.1        1
      323 #BBC2FF 12 4     1    59 11.5 12.5  3.5  4.5     NA       0.1        1
      324 #BBBFFF 12 4     1    59 11.5 12.5  3.5  4.5     NA       0.1        1
      325 #BBC4FF 13 4     1    64 12.5 13.5  3.5  4.5     NA       0.1        1
      326 #BBC2FF 13 4     1    64 12.5 13.5  3.5  4.5     NA       0.1        1
      327 #BBBFFF 13 4     1    64 12.5 13.5  3.5  4.5     NA       0.1        1
      328 #BBC3FF 14 4     1    69 13.5 14.5  3.5  4.5     NA       0.1        1
      329 #BBC2FF 14 4     1    69 13.5 14.5  3.5  4.5     NA       0.1        1
      330 #BBBFFF 14 4     1    69 13.5 14.5  3.5  4.5     NA       0.1        1
      331 #BBC3FF 15 4     1    74 14.5 15.5  3.5  4.5     NA       0.1        1
      332 #BBC1FF 15 4     1    74 14.5 15.5  3.5  4.5     NA       0.1        1
      333 #BBBFFF 15 4     1    74 14.5 15.5  3.5  4.5     NA       0.1        1
      334 #BBC3FF 16 4     1    79 15.5 16.5  3.5  4.5     NA       0.1        1
      335 #BBC1FF 16 4     1    79 15.5 16.5  3.5  4.5     NA       0.1        1
      336 #BBBEFF 16 4     1    79 15.5 16.5  3.5  4.5     NA       0.1        1
      337 #BBC2FF 17 4     1    84 16.5 17.5  3.5  4.5     NA       0.1        1
      338 #BBBFFF 17 4     1    84 16.5 17.5  3.5  4.5     NA       0.1        1
      339 #BBBDFF 17 4     1    84 16.5 17.5  3.5  4.5     NA       0.1        1
      340 #BBC6FF 18 4     1    89 17.5 18.5  3.5  4.5     NA       0.1        1
      341 #BBBCFF 18 4     1    89 17.5 18.5  3.5  4.5     NA       0.1        1
      342 #A595FF 18 4     1    89 17.5 18.5  3.5  4.5     NA       0.1        1
      343 #BBC7FF 19 4     1    94 18.5 19.5  3.5  4.5     NA       0.1        1
      344 #B9B7FF 19 4     1    94 18.5 19.5  3.5  4.5     NA       0.1        1
      345 #937BFF 19 4     1    94 18.5 19.5  3.5  4.5     NA       0.1        1
      346 #BBC3FF 20 4     1    99 19.5 20.5  3.5  4.5     NA       0.1        1
      347 #B5B0FF 20 4     1    99 19.5 20.5  3.5  4.5     NA       0.1        1
      348 #937AFF 20 4     1    99 19.5 20.5  3.5  4.5     NA       0.1        1
      349 #BBC0FF 21 4     1   104 20.5 21.5  3.5  4.5     NA       0.1        1
      350 #AFA5FF 21 4     1   104 20.5 21.5  3.5  4.5     NA       0.1        1
      351 #8C71FF 21 4     1   104 20.5 21.5  3.5  4.5     NA       0.1        1
      352 #BBBFFF 22 4     1   109 21.5 22.5  3.5  4.5     NA       0.1        1
      353 #AA9DFF 22 4     1   109 21.5 22.5  3.5  4.5     NA       0.1        1
      354 #8265FF 22 4     1   109 21.5 22.5  3.5  4.5     NA       0.1        1
      355 #ACA1FF 23 4     1   114 22.5 23.5  3.5  4.5     NA       0.1        1
      356 #A595FF 23 4     1   114 22.5 23.5  3.5  4.5     NA       0.1        1
      357 #9F8CFF 23 4     1   114 22.5 23.5  3.5  4.5     NA       0.1        1
      358 #AB9FFF 24 4     1   119 23.5 24.5  3.5  4.5     NA       0.1        1
      359 #A291FF 24 4     1   119 23.5 24.5  3.5  4.5     NA       0.1        1
      360 #9A84FF 24 4     1   119 23.5 24.5  3.5  4.5     NA       0.1        1
      361 #AB9FFF 25 4     1   124 24.5 25.5  3.5  4.5     NA       0.1        1
      362 #A08CFF 25 4     1   124 24.5 25.5  3.5  4.5     NA       0.1        1
      363 #967EFF 25 4     1   124 24.5 25.5  3.5  4.5     NA       0.1        1
      364 #AB9EFF 26 4     1   129 25.5 26.5  3.5  4.5     NA       0.1        1
      365 #9D89FF 26 4     1   129 25.5 26.5  3.5  4.5     NA       0.1        1
      366 #947DFF 26 4     1   129 25.5 26.5  3.5  4.5     NA       0.1        1
      367 #AB9EFF 27 4     1   134 26.5 27.5  3.5  4.5     NA       0.1        1
      368 #9B85FF 27 4     1   134 26.5 27.5  3.5  4.5     NA       0.1        1
      369 #8E74FF 27 4     1   134 26.5 27.5  3.5  4.5     NA       0.1        1
      370 #9D89FF 28 4     1   139 27.5 28.5  3.5  4.5     NA       0.1        1
      371 #9A85FF 28 4     1   139 27.5 28.5  3.5  4.5     NA       0.1        1
      372 #967EFF 28 4     1   139 27.5 28.5  3.5  4.5     NA       0.1        1
      373 #B5B0FF 29 4     1   144 28.5 29.5  3.5  4.5     NA       0.1        1
      374 #9A85FF 29 4     1   144 28.5 29.5  3.5  4.5     NA       0.1        1
      375 #7152FF 29 4     1   144 28.5 29.5  3.5  4.5     NA       0.1        1
      376 #BBBBFF 30 4     1   149 29.5 30.5  3.5  4.5     NA       0.1        1
      377 #9A85FF 30 4     1   149 29.5 30.5  3.5  4.5     NA       0.1        1
      378 #6546FF 30 4     1   149 29.5 30.5  3.5  4.5     NA       0.1        1
      379 #BBBCFF 31 4     1   154 30.5 31.5  3.5  4.5     NA       0.1        1
      380 #9A85FF 31 4     1   154 30.5 31.5  3.5  4.5     NA       0.1        1
      381 #6243FF 31 4     1   154 30.5 31.5  3.5  4.5     NA       0.1        1
      382 #BBBCFF 32 4     1   159 31.5 32.5  3.5  4.5     NA       0.1        1
      383 #9A85FF 32 4     1   159 31.5 32.5  3.5  4.5     NA       0.1        1
      384 #6242FF 32 4     1   159 31.5 32.5  3.5  4.5     NA       0.1        1
      385 #BBCBFF  1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      386 #BBC3FF  1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      387 #BBBCFF  1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      388 #BBCBFF  2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1
      389 #BBC2FF  2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1
      390 #BBBCFF  2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1
      391 #BBCBFF  3 5     1    15  2.5  3.5  4.5  5.5     NA       0.1        1
      392 #BBC2FF  3 5     1    15  2.5  3.5  4.5  5.5     NA       0.1        1
      393 #BBBCFF  3 5     1    15  2.5  3.5  4.5  5.5     NA       0.1        1
      394 #BBCBFF  4 5     1    20  3.5  4.5  4.5  5.5     NA       0.1        1
      395 #BBC2FF  4 5     1    20  3.5  4.5  4.5  5.5     NA       0.1        1
      396 #BBBCFF  4 5     1    20  3.5  4.5  4.5  5.5     NA       0.1        1
      397 #BBCBFF  5 5     1    25  4.5  5.5  4.5  5.5     NA       0.1        1
      398 #BBC2FF  5 5     1    25  4.5  5.5  4.5  5.5     NA       0.1        1
      399 #BBBCFF  5 5     1    25  4.5  5.5  4.5  5.5     NA       0.1        1
      400 #BBCCFF  6 5     1    30  5.5  6.5  4.5  5.5     NA       0.1        1
      401 #BBC2FF  6 5     1    30  5.5  6.5  4.5  5.5     NA       0.1        1
      402 #B9B8FF  6 5     1    30  5.5  6.5  4.5  5.5     NA       0.1        1
      403 #FFABA4  7 5     1    35  6.5  7.5  4.5  5.5     NA       0.1        1
      404 #BBC2FF  7 5     1    35  6.5  7.5  4.5  5.5     NA       0.1        1
      405 #9F8BFF  7 5     1    35  6.5  7.5  4.5  5.5     NA       0.1        1
      406 #FF6249  8 5     1    40  7.5  8.5  4.5  5.5     NA       0.1        1
      407 #BBC2FF  8 5     1    40  7.5  8.5  4.5  5.5     NA       0.1        1
      408 #896DFF  8 5     1    40  7.5  8.5  4.5  5.5     NA       0.1        1
      409 #FF563B  9 5     1    45  8.5  9.5  4.5  5.5     NA       0.1        1
      410 #BBC2FF  9 5     1    45  8.5  9.5  4.5  5.5     NA       0.1        1
      411 #8569FF  9 5     1    45  8.5  9.5  4.5  5.5     NA       0.1        1
      412 #FF4930 10 5     1    50  9.5 10.5  4.5  5.5     NA       0.1        1
      413 #BBC2FF 10 5     1    50  9.5 10.5  4.5  5.5     NA       0.1        1
      414 #8163FF 10 5     1    50  9.5 10.5  4.5  5.5     NA       0.1        1
      415 #FF4B31 11 5     1    55 10.5 11.5  4.5  5.5     NA       0.1        1
      416 #BBC2FF 11 5     1    55 10.5 11.5  4.5  5.5     NA       0.1        1
      417 #8163FF 11 5     1    55 10.5 11.5  4.5  5.5     NA       0.1        1
      418 #FFC9BB 12 5     1    60 11.5 12.5  4.5  5.5     NA       0.1        1
      419 #BBC2FF 12 5     1    60 11.5 12.5  4.5  5.5     NA       0.1        1
      420 #AB9EFF 12 5     1    60 11.5 12.5  4.5  5.5     NA       0.1        1
      421 #FFCBBB 13 5     1    65 12.5 13.5  4.5  5.5     NA       0.1        1
      422 #BBC2FF 13 5     1    65 12.5 13.5  4.5  5.5     NA       0.1        1
      423 #AB9EFF 13 5     1    65 12.5 13.5  4.5  5.5     NA       0.1        1
      424 #BBCCFF 14 5     1    70 13.5 14.5  4.5  5.5     NA       0.1        1
      425 #BBC2FF 14 5     1    70 13.5 14.5  4.5  5.5     NA       0.1        1
      426 #AB9EFF 14 5     1    70 13.5 14.5  4.5  5.5     NA       0.1        1
      427 #BBCBFF 15 5     1    75 14.5 15.5  4.5  5.5     NA       0.1        1
      428 #BBC1FF 15 5     1    75 14.5 15.5  4.5  5.5     NA       0.1        1
      429 #AA9EFF 15 5     1    75 14.5 15.5  4.5  5.5     NA       0.1        1
      430 #BBCAFF 16 5     1    80 15.5 16.5  4.5  5.5     NA       0.1        1
      431 #BBC1FF 16 5     1    80 15.5 16.5  4.5  5.5     NA       0.1        1
      432 #AA9DFF 16 5     1    80 15.5 16.5  4.5  5.5     NA       0.1        1
      433 #BBCBFF 17 5     1    85 16.5 17.5  4.5  5.5     NA       0.1        1
      434 #BBBFFF 17 5     1    85 16.5 17.5  4.5  5.5     NA       0.1        1
      435 #967FFF 17 5     1    85 16.5 17.5  4.5  5.5     NA       0.1        1
      436 #FFC3BB 18 5     1    90 17.5 18.5  4.5  5.5     NA       0.1        1
      437 #BBBCFF 18 5     1    90 17.5 18.5  4.5  5.5     NA       0.1        1
      438 #7051FF 18 5     1    90 17.5 18.5  4.5  5.5     NA       0.1        1
      439 #FFC0BB 19 5     1    95 18.5 19.5  4.5  5.5     NA       0.1        1
      440 #B9B7FF 19 5     1    95 18.5 19.5  4.5  5.5     NA       0.1        1
      441 #5033FF 19 5     1    95 18.5 19.5  4.5  5.5     NA       0.1        1
      442 #FFCABB 20 5     1   100 19.5 20.5  4.5  5.5     NA       0.1        1
      443 #B5B0FF 20 5     1   100 19.5 20.5  4.5  5.5     NA       0.1        1
      444 #5032FF 20 5     1   100 19.5 20.5  4.5  5.5     NA       0.1        1
      445 #BBCAFF 21 5     1   105 20.5 21.5  4.5  5.5     NA       0.1        1
      446 #AFA5FF 21 5     1   105 20.5 21.5  4.5  5.5     NA       0.1        1
      447 #4026FF 21 5     1   105 20.5 21.5  4.5  5.5     NA       0.1        1
      448 #BBC8FF 22 5     1   110 21.5 22.5  4.5  5.5     NA       0.1        1
      449 #AA9DFF 22 5     1   110 21.5 22.5  4.5  5.5     NA       0.1        1
      450 #2311FF 22 5     1   110 21.5 22.5  4.5  5.5     NA       0.1        1
      451 #AFA6FF 23 5     1   115 22.5 23.5  4.5  5.5     NA       0.1        1
      452 #A595FF 23 5     1   115 22.5 23.5  4.5  5.5     NA       0.1        1
      453 #9178FF 23 5     1   115 22.5 23.5  4.5  5.5     NA       0.1        1
      454 #ACA1FF 24 5     1   120 23.5 24.5  4.5  5.5     NA       0.1        1
      455 #A291FF 24 5     1   120 23.5 24.5  4.5  5.5     NA       0.1        1
      456 #9076FF 24 5     1   120 23.5 24.5  4.5  5.5     NA       0.1        1
      457 #A799FF 25 5     1   125 24.5 25.5  4.5  5.5     NA       0.1        1
      458 #A08CFF 25 5     1   125 24.5 25.5  4.5  5.5     NA       0.1        1
      459 #9076FF 25 5     1   125 24.5 25.5  4.5  5.5     NA       0.1        1
      460 #A697FF 26 5     1   130 25.5 26.5  4.5  5.5     NA       0.1        1
      461 #9D89FF 26 5     1   130 25.5 26.5  4.5  5.5     NA       0.1        1
      462 #8F75FF 26 5     1   130 25.5 26.5  4.5  5.5     NA       0.1        1
      463 #A696FF 27 5     1   135 26.5 27.5  4.5  5.5     NA       0.1        1
      464 #9B85FF 27 5     1   135 26.5 27.5  4.5  5.5     NA       0.1        1
      465 #8F75FF 27 5     1   135 26.5 27.5  4.5  5.5     NA       0.1        1
      466 #AEA3FF 28 5     1   140 27.5 28.5  4.5  5.5     NA       0.1        1
      467 #9A85FF 28 5     1   140 27.5 28.5  4.5  5.5     NA       0.1        1
      468 #7455FF 28 5     1   140 27.5 28.5  4.5  5.5     NA       0.1        1
      469 #BBBCFF 29 5     1   145 28.5 29.5  4.5  5.5     NA       0.1        1
      470 #9A85FF 29 5     1   145 28.5 29.5  4.5  5.5     NA       0.1        1
      471 #3A21FF 29 5     1   145 28.5 29.5  4.5  5.5     NA       0.1        1
      472 #BBBFFF 30 5     1   150 29.5 30.5  4.5  5.5     NA       0.1        1
      473 #9A85FF 30 5     1   150 29.5 30.5  4.5  5.5     NA       0.1        1
      474 #1709FF 30 5     1   150 29.5 30.5  4.5  5.5     NA       0.1        1
      475 #BBC0FF 31 5     1   155 30.5 31.5  4.5  5.5     NA       0.1        1
      476 #9A85FF 31 5     1   155 30.5 31.5  4.5  5.5     NA       0.1        1
      477 #0401FF 31 5     1   155 30.5 31.5  4.5  5.5     NA       0.1        1
      478 #BBC0FF 32 5     1   160 31.5 32.5  4.5  5.5     NA       0.1        1
      479 #9A85FF 32 5     1   160 31.5 32.5  4.5  5.5     NA       0.1        1
      480 #0000FF 32 5     1   160 31.5 32.5  4.5  5.5     NA       0.1        1
          alpha width height
      1      NA    NA     NA
      2      NA    NA     NA
      3      NA    NA     NA
      4      NA    NA     NA
      5      NA    NA     NA
      6      NA    NA     NA
      7      NA    NA     NA
      8      NA    NA     NA
      9      NA    NA     NA
      10     NA    NA     NA
      11     NA    NA     NA
      12     NA    NA     NA
      13     NA    NA     NA
      14     NA    NA     NA
      15     NA    NA     NA
      16     NA    NA     NA
      17     NA    NA     NA
      18     NA    NA     NA
      19     NA    NA     NA
      20     NA    NA     NA
      21     NA    NA     NA
      22     NA    NA     NA
      23     NA    NA     NA
      24     NA    NA     NA
      25     NA    NA     NA
      26     NA    NA     NA
      27     NA    NA     NA
      28     NA    NA     NA
      29     NA    NA     NA
      30     NA    NA     NA
      31     NA    NA     NA
      32     NA    NA     NA
      33     NA    NA     NA
      34     NA    NA     NA
      35     NA    NA     NA
      36     NA    NA     NA
      37     NA    NA     NA
      38     NA    NA     NA
      39     NA    NA     NA
      40     NA    NA     NA
      41     NA    NA     NA
      42     NA    NA     NA
      43     NA    NA     NA
      44     NA    NA     NA
      45     NA    NA     NA
      46     NA    NA     NA
      47     NA    NA     NA
      48     NA    NA     NA
      49     NA    NA     NA
      50     NA    NA     NA
      51     NA    NA     NA
      52     NA    NA     NA
      53     NA    NA     NA
      54     NA    NA     NA
      55     NA    NA     NA
      56     NA    NA     NA
      57     NA    NA     NA
      58     NA    NA     NA
      59     NA    NA     NA
      60     NA    NA     NA
      61     NA    NA     NA
      62     NA    NA     NA
      63     NA    NA     NA
      64     NA    NA     NA
      65     NA    NA     NA
      66     NA    NA     NA
      67     NA    NA     NA
      68     NA    NA     NA
      69     NA    NA     NA
      70     NA    NA     NA
      71     NA    NA     NA
      72     NA    NA     NA
      73     NA    NA     NA
      74     NA    NA     NA
      75     NA    NA     NA
      76     NA    NA     NA
      77     NA    NA     NA
      78     NA    NA     NA
      79     NA    NA     NA
      80     NA    NA     NA
      81     NA    NA     NA
      82     NA    NA     NA
      83     NA    NA     NA
      84     NA    NA     NA
      85     NA    NA     NA
      86     NA    NA     NA
      87     NA    NA     NA
      88     NA    NA     NA
      89     NA    NA     NA
      90     NA    NA     NA
      91     NA    NA     NA
      92     NA    NA     NA
      93     NA    NA     NA
      94     NA    NA     NA
      95     NA    NA     NA
      96     NA    NA     NA
      97     NA    NA     NA
      98     NA    NA     NA
      99     NA    NA     NA
      100    NA    NA     NA
      101    NA    NA     NA
      102    NA    NA     NA
      103    NA    NA     NA
      104    NA    NA     NA
      105    NA    NA     NA
      106    NA    NA     NA
      107    NA    NA     NA
      108    NA    NA     NA
      109    NA    NA     NA
      110    NA    NA     NA
      111    NA    NA     NA
      112    NA    NA     NA
      113    NA    NA     NA
      114    NA    NA     NA
      115    NA    NA     NA
      116    NA    NA     NA
      117    NA    NA     NA
      118    NA    NA     NA
      119    NA    NA     NA
      120    NA    NA     NA
      121    NA    NA     NA
      122    NA    NA     NA
      123    NA    NA     NA
      124    NA    NA     NA
      125    NA    NA     NA
      126    NA    NA     NA
      127    NA    NA     NA
      128    NA    NA     NA
      129    NA    NA     NA
      130    NA    NA     NA
      131    NA    NA     NA
      132    NA    NA     NA
      133    NA    NA     NA
      134    NA    NA     NA
      135    NA    NA     NA
      136    NA    NA     NA
      137    NA    NA     NA
      138    NA    NA     NA
      139    NA    NA     NA
      140    NA    NA     NA
      141    NA    NA     NA
      142    NA    NA     NA
      143    NA    NA     NA
      144    NA    NA     NA
      145    NA    NA     NA
      146    NA    NA     NA
      147    NA    NA     NA
      148    NA    NA     NA
      149    NA    NA     NA
      150    NA    NA     NA
      151    NA    NA     NA
      152    NA    NA     NA
      153    NA    NA     NA
      154    NA    NA     NA
      155    NA    NA     NA
      156    NA    NA     NA
      157    NA    NA     NA
      158    NA    NA     NA
      159    NA    NA     NA
      160    NA    NA     NA
      161    NA    NA     NA
      162    NA    NA     NA
      163    NA    NA     NA
      164    NA    NA     NA
      165    NA    NA     NA
      166    NA    NA     NA
      167    NA    NA     NA
      168    NA    NA     NA
      169    NA    NA     NA
      170    NA    NA     NA
      171    NA    NA     NA
      172    NA    NA     NA
      173    NA    NA     NA
      174    NA    NA     NA
      175    NA    NA     NA
      176    NA    NA     NA
      177    NA    NA     NA
      178    NA    NA     NA
      179    NA    NA     NA
      180    NA    NA     NA
      181    NA    NA     NA
      182    NA    NA     NA
      183    NA    NA     NA
      184    NA    NA     NA
      185    NA    NA     NA
      186    NA    NA     NA
      187    NA    NA     NA
      188    NA    NA     NA
      189    NA    NA     NA
      190    NA    NA     NA
      191    NA    NA     NA
      192    NA    NA     NA
      193    NA    NA     NA
      194    NA    NA     NA
      195    NA    NA     NA
      196    NA    NA     NA
      197    NA    NA     NA
      198    NA    NA     NA
      199    NA    NA     NA
      200    NA    NA     NA
      201    NA    NA     NA
      202    NA    NA     NA
      203    NA    NA     NA
      204    NA    NA     NA
      205    NA    NA     NA
      206    NA    NA     NA
      207    NA    NA     NA
      208    NA    NA     NA
      209    NA    NA     NA
      210    NA    NA     NA
      211    NA    NA     NA
      212    NA    NA     NA
      213    NA    NA     NA
      214    NA    NA     NA
      215    NA    NA     NA
      216    NA    NA     NA
      217    NA    NA     NA
      218    NA    NA     NA
      219    NA    NA     NA
      220    NA    NA     NA
      221    NA    NA     NA
      222    NA    NA     NA
      223    NA    NA     NA
      224    NA    NA     NA
      225    NA    NA     NA
      226    NA    NA     NA
      227    NA    NA     NA
      228    NA    NA     NA
      229    NA    NA     NA
      230    NA    NA     NA
      231    NA    NA     NA
      232    NA    NA     NA
      233    NA    NA     NA
      234    NA    NA     NA
      235    NA    NA     NA
      236    NA    NA     NA
      237    NA    NA     NA
      238    NA    NA     NA
      239    NA    NA     NA
      240    NA    NA     NA
      241    NA    NA     NA
      242    NA    NA     NA
      243    NA    NA     NA
      244    NA    NA     NA
      245    NA    NA     NA
      246    NA    NA     NA
      247    NA    NA     NA
      248    NA    NA     NA
      249    NA    NA     NA
      250    NA    NA     NA
      251    NA    NA     NA
      252    NA    NA     NA
      253    NA    NA     NA
      254    NA    NA     NA
      255    NA    NA     NA
      256    NA    NA     NA
      257    NA    NA     NA
      258    NA    NA     NA
      259    NA    NA     NA
      260    NA    NA     NA
      261    NA    NA     NA
      262    NA    NA     NA
      263    NA    NA     NA
      264    NA    NA     NA
      265    NA    NA     NA
      266    NA    NA     NA
      267    NA    NA     NA
      268    NA    NA     NA
      269    NA    NA     NA
      270    NA    NA     NA
      271    NA    NA     NA
      272    NA    NA     NA
      273    NA    NA     NA
      274    NA    NA     NA
      275    NA    NA     NA
      276    NA    NA     NA
      277    NA    NA     NA
      278    NA    NA     NA
      279    NA    NA     NA
      280    NA    NA     NA
      281    NA    NA     NA
      282    NA    NA     NA
      283    NA    NA     NA
      284    NA    NA     NA
      285    NA    NA     NA
      286    NA    NA     NA
      287    NA    NA     NA
      288    NA    NA     NA
      289    NA    NA     NA
      290    NA    NA     NA
      291    NA    NA     NA
      292    NA    NA     NA
      293    NA    NA     NA
      294    NA    NA     NA
      295    NA    NA     NA
      296    NA    NA     NA
      297    NA    NA     NA
      298    NA    NA     NA
      299    NA    NA     NA
      300    NA    NA     NA
      301    NA    NA     NA
      302    NA    NA     NA
      303    NA    NA     NA
      304    NA    NA     NA
      305    NA    NA     NA
      306    NA    NA     NA
      307    NA    NA     NA
      308    NA    NA     NA
      309    NA    NA     NA
      310    NA    NA     NA
      311    NA    NA     NA
      312    NA    NA     NA
      313    NA    NA     NA
      314    NA    NA     NA
      315    NA    NA     NA
      316    NA    NA     NA
      317    NA    NA     NA
      318    NA    NA     NA
      319    NA    NA     NA
      320    NA    NA     NA
      321    NA    NA     NA
      322    NA    NA     NA
      323    NA    NA     NA
      324    NA    NA     NA
      325    NA    NA     NA
      326    NA    NA     NA
      327    NA    NA     NA
      328    NA    NA     NA
      329    NA    NA     NA
      330    NA    NA     NA
      331    NA    NA     NA
      332    NA    NA     NA
      333    NA    NA     NA
      334    NA    NA     NA
      335    NA    NA     NA
      336    NA    NA     NA
      337    NA    NA     NA
      338    NA    NA     NA
      339    NA    NA     NA
      340    NA    NA     NA
      341    NA    NA     NA
      342    NA    NA     NA
      343    NA    NA     NA
      344    NA    NA     NA
      345    NA    NA     NA
      346    NA    NA     NA
      347    NA    NA     NA
      348    NA    NA     NA
      349    NA    NA     NA
      350    NA    NA     NA
      351    NA    NA     NA
      352    NA    NA     NA
      353    NA    NA     NA
      354    NA    NA     NA
      355    NA    NA     NA
      356    NA    NA     NA
      357    NA    NA     NA
      358    NA    NA     NA
      359    NA    NA     NA
      360    NA    NA     NA
      361    NA    NA     NA
      362    NA    NA     NA
      363    NA    NA     NA
      364    NA    NA     NA
      365    NA    NA     NA
      366    NA    NA     NA
      367    NA    NA     NA
      368    NA    NA     NA
      369    NA    NA     NA
      370    NA    NA     NA
      371    NA    NA     NA
      372    NA    NA     NA
      373    NA    NA     NA
      374    NA    NA     NA
      375    NA    NA     NA
      376    NA    NA     NA
      377    NA    NA     NA
      378    NA    NA     NA
      379    NA    NA     NA
      380    NA    NA     NA
      381    NA    NA     NA
      382    NA    NA     NA
      383    NA    NA     NA
      384    NA    NA     NA
      385    NA    NA     NA
      386    NA    NA     NA
      387    NA    NA     NA
      388    NA    NA     NA
      389    NA    NA     NA
      390    NA    NA     NA
      391    NA    NA     NA
      392    NA    NA     NA
      393    NA    NA     NA
      394    NA    NA     NA
      395    NA    NA     NA
      396    NA    NA     NA
      397    NA    NA     NA
      398    NA    NA     NA
      399    NA    NA     NA
      400    NA    NA     NA
      401    NA    NA     NA
      402    NA    NA     NA
      403    NA    NA     NA
      404    NA    NA     NA
      405    NA    NA     NA
      406    NA    NA     NA
      407    NA    NA     NA
      408    NA    NA     NA
      409    NA    NA     NA
      410    NA    NA     NA
      411    NA    NA     NA
      412    NA    NA     NA
      413    NA    NA     NA
      414    NA    NA     NA
      415    NA    NA     NA
      416    NA    NA     NA
      417    NA    NA     NA
      418    NA    NA     NA
      419    NA    NA     NA
      420    NA    NA     NA
      421    NA    NA     NA
      422    NA    NA     NA
      423    NA    NA     NA
      424    NA    NA     NA
      425    NA    NA     NA
      426    NA    NA     NA
      427    NA    NA     NA
      428    NA    NA     NA
      429    NA    NA     NA
      430    NA    NA     NA
      431    NA    NA     NA
      432    NA    NA     NA
      433    NA    NA     NA
      434    NA    NA     NA
      435    NA    NA     NA
      436    NA    NA     NA
      437    NA    NA     NA
      438    NA    NA     NA
      439    NA    NA     NA
      440    NA    NA     NA
      441    NA    NA     NA
      442    NA    NA     NA
      443    NA    NA     NA
      444    NA    NA     NA
      445    NA    NA     NA
      446    NA    NA     NA
      447    NA    NA     NA
      448    NA    NA     NA
      449    NA    NA     NA
      450    NA    NA     NA
      451    NA    NA     NA
      452    NA    NA     NA
      453    NA    NA     NA
      454    NA    NA     NA
      455    NA    NA     NA
      456    NA    NA     NA
      457    NA    NA     NA
      458    NA    NA     NA
      459    NA    NA     NA
      460    NA    NA     NA
      461    NA    NA     NA
      462    NA    NA     NA
      463    NA    NA     NA
      464    NA    NA     NA
      465    NA    NA     NA
      466    NA    NA     NA
      467    NA    NA     NA
      468    NA    NA     NA
      469    NA    NA     NA
      470    NA    NA     NA
      471    NA    NA     NA
      472    NA    NA     NA
      473    NA    NA     NA
      474    NA    NA     NA
      475    NA    NA     NA
      476    NA    NA     NA
      477    NA    NA     NA
      478    NA    NA     NA
      479    NA    NA     NA
      480    NA    NA     NA
      
      $Asia$d2$`model:wt`
             fill  x  y PANEL group xmin xmax ymin ymax colour linewidth linetype
      1   #BBC7FF  1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      2   #BBC7FF  1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      3   #BBC7FF  1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      4   #BBC7FF  2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1
      5   #BBC7FF  2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1
      6   #BBC7FF  2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1
      7   #BBC7FF  3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1
      8   #BBC7FF  3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1
      9   #BBC7FF  3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1
      10  #BBC7FF  4  1     1    31  3.5  4.5  0.5  1.5     NA       0.1        1
      11  #BBC7FF  4  1     1    31  3.5  4.5  0.5  1.5     NA       0.1        1
      12  #BBC7FF  4  1     1    31  3.5  4.5  0.5  1.5     NA       0.1        1
      13  #BBC7FF  5  1     1    41  4.5  5.5  0.5  1.5     NA       0.1        1
      14  #BBC7FF  5  1     1    41  4.5  5.5  0.5  1.5     NA       0.1        1
      15  #BBC7FF  5  1     1    41  4.5  5.5  0.5  1.5     NA       0.1        1
      16  #BBC7FF  6  1     1    51  5.5  6.5  0.5  1.5     NA       0.1        1
      17  #BBC7FF  6  1     1    51  5.5  6.5  0.5  1.5     NA       0.1        1
      18  #BBC7FF  6  1     1    51  5.5  6.5  0.5  1.5     NA       0.1        1
      19  #BBC8FF  7  1     1    61  6.5  7.5  0.5  1.5     NA       0.1        1
      20  #BBC7FF  7  1     1    61  6.5  7.5  0.5  1.5     NA       0.1        1
      21  #BBC5FF  7  1     1    61  6.5  7.5  0.5  1.5     NA       0.1        1
      22  #FFCABB  8  1     1    71  7.5  8.5  0.5  1.5     NA       0.1        1
      23  #BBC7FF  8  1     1    71  7.5  8.5  0.5  1.5     NA       0.1        1
      24  #BBC1FF  8  1     1    71  7.5  8.5  0.5  1.5     NA       0.1        1
      25  #FFC9BB  9  1     1    81  8.5  9.5  0.5  1.5     NA       0.1        1
      26  #BBC7FF  9  1     1    81  8.5  9.5  0.5  1.5     NA       0.1        1
      27  #BBC1FF  9  1     1    81  8.5  9.5  0.5  1.5     NA       0.1        1
      28  #FFC8BB 10  1     1    91  9.5 10.5  0.5  1.5     NA       0.1        1
      29  #BBC7FF 10  1     1    91  9.5 10.5  0.5  1.5     NA       0.1        1
      30  #BBC1FF 10  1     1    91  9.5 10.5  0.5  1.5     NA       0.1        1
      31  #FFC8BB 11  1     1   101 10.5 11.5  0.5  1.5     NA       0.1        1
      32  #BBC7FF 11  1     1   101 10.5 11.5  0.5  1.5     NA       0.1        1
      33  #BBC1FF 11  1     1   101 10.5 11.5  0.5  1.5     NA       0.1        1
      34  #BBC7FF 12  1     1   111 11.5 12.5  0.5  1.5     NA       0.1        1
      35  #BBC7FF 12  1     1   111 11.5 12.5  0.5  1.5     NA       0.1        1
      36  #BBC7FF 12  1     1   111 11.5 12.5  0.5  1.5     NA       0.1        1
      37  #BBC7FF 13  1     1   121 12.5 13.5  0.5  1.5     NA       0.1        1
      38  #BBC7FF 13  1     1   121 12.5 13.5  0.5  1.5     NA       0.1        1
      39  #BBC7FF 13  1     1   121 12.5 13.5  0.5  1.5     NA       0.1        1
      40  #BBC7FF 14  1     1   131 13.5 14.5  0.5  1.5     NA       0.1        1
      41  #BBC7FF 14  1     1   131 13.5 14.5  0.5  1.5     NA       0.1        1
      42  #BBC7FF 14  1     1   131 13.5 14.5  0.5  1.5     NA       0.1        1
      43  #BBC7FF 15  1     1   141 14.5 15.5  0.5  1.5     NA       0.1        1
      44  #BBC7FF 15  1     1   141 14.5 15.5  0.5  1.5     NA       0.1        1
      45  #BBC7FF 15  1     1   141 14.5 15.5  0.5  1.5     NA       0.1        1
      46  #BBC7FF 16  1     1   151 15.5 16.5  0.5  1.5     NA       0.1        1
      47  #BBC7FF 16  1     1   151 15.5 16.5  0.5  1.5     NA       0.1        1
      48  #BBC7FF 16  1     1   151 15.5 16.5  0.5  1.5     NA       0.1        1
      49  #BBC8FF 17  1     1   161 16.5 17.5  0.5  1.5     NA       0.1        1
      50  #BBC7FF 17  1     1   161 16.5 17.5  0.5  1.5     NA       0.1        1
      51  #BBC5FF 17  1     1   161 16.5 17.5  0.5  1.5     NA       0.1        1
      52  #BBC9FF 18  1     1   171 17.5 18.5  0.5  1.5     NA       0.1        1
      53  #BBC7FF 18  1     1   171 17.5 18.5  0.5  1.5     NA       0.1        1
      54  #BBC4FF 18  1     1   171 17.5 18.5  0.5  1.5     NA       0.1        1
      55  #FFCABB 19  1     1   181 18.5 19.5  0.5  1.5     NA       0.1        1
      56  #BBC7FF 19  1     1   181 18.5 19.5  0.5  1.5     NA       0.1        1
      57  #BBC1FF 19  1     1   181 18.5 19.5  0.5  1.5     NA       0.1        1
      58  #FFC9BB 20  1     1   191 19.5 20.5  0.5  1.5     NA       0.1        1
      59  #BBC7FF 20  1     1   191 19.5 20.5  0.5  1.5     NA       0.1        1
      60  #BBC1FF 20  1     1   191 19.5 20.5  0.5  1.5     NA       0.1        1
      61  #FFC8BB 21  1     1   201 20.5 21.5  0.5  1.5     NA       0.1        1
      62  #BBC7FF 21  1     1   201 20.5 21.5  0.5  1.5     NA       0.1        1
      63  #BBC1FF 21  1     1   201 20.5 21.5  0.5  1.5     NA       0.1        1
      64  #FFC8BB 22  1     1   211 21.5 22.5  0.5  1.5     NA       0.1        1
      65  #BBC7FF 22  1     1   211 21.5 22.5  0.5  1.5     NA       0.1        1
      66  #BBC1FF 22  1     1   211 21.5 22.5  0.5  1.5     NA       0.1        1
      67  #BBC7FF 23  1     1   221 22.5 23.5  0.5  1.5     NA       0.1        1
      68  #BBC7FF 23  1     1   221 22.5 23.5  0.5  1.5     NA       0.1        1
      69  #BBC7FF 23  1     1   221 22.5 23.5  0.5  1.5     NA       0.1        1
      70  #BBC7FF 24  1     1   231 23.5 24.5  0.5  1.5     NA       0.1        1
      71  #BBC7FF 24  1     1   231 23.5 24.5  0.5  1.5     NA       0.1        1
      72  #BBC7FF 24  1     1   231 23.5 24.5  0.5  1.5     NA       0.1        1
      73  #BBC7FF 25  1     1   241 24.5 25.5  0.5  1.5     NA       0.1        1
      74  #BBC7FF 25  1     1   241 24.5 25.5  0.5  1.5     NA       0.1        1
      75  #BBC7FF 25  1     1   241 24.5 25.5  0.5  1.5     NA       0.1        1
      76  #BBC7FF 26  1     1   251 25.5 26.5  0.5  1.5     NA       0.1        1
      77  #BBC7FF 26  1     1   251 25.5 26.5  0.5  1.5     NA       0.1        1
      78  #BBC7FF 26  1     1   251 25.5 26.5  0.5  1.5     NA       0.1        1
      79  #BBC7FF 27  1     1   261 26.5 27.5  0.5  1.5     NA       0.1        1
      80  #BBC7FF 27  1     1   261 26.5 27.5  0.5  1.5     NA       0.1        1
      81  #BBC7FF 27  1     1   261 26.5 27.5  0.5  1.5     NA       0.1        1
      82  #BBC8FF 28  1     1   271 27.5 28.5  0.5  1.5     NA       0.1        1
      83  #BBC7FF 28  1     1   271 27.5 28.5  0.5  1.5     NA       0.1        1
      84  #BBC5FF 28  1     1   271 27.5 28.5  0.5  1.5     NA       0.1        1
      85  #BBCBFF 29  1     1   281 28.5 29.5  0.5  1.5     NA       0.1        1
      86  #BBC7FF 29  1     1   281 28.5 29.5  0.5  1.5     NA       0.1        1
      87  #BBC2FF 29  1     1   281 28.5 29.5  0.5  1.5     NA       0.1        1
      88  #FFCABB 30  1     1   291 29.5 30.5  0.5  1.5     NA       0.1        1
      89  #BBC7FF 30  1     1   291 29.5 30.5  0.5  1.5     NA       0.1        1
      90  #BBC1FF 30  1     1   291 29.5 30.5  0.5  1.5     NA       0.1        1
      91  #FFC8BB 31  1     1   301 30.5 31.5  0.5  1.5     NA       0.1        1
      92  #BBC7FF 31  1     1   301 30.5 31.5  0.5  1.5     NA       0.1        1
      93  #BBC0FF 31  1     1   301 30.5 31.5  0.5  1.5     NA       0.1        1
      94  #FFC8BB 32  1     1   311 31.5 32.5  0.5  1.5     NA       0.1        1
      95  #BBC7FF 32  1     1   311 31.5 32.5  0.5  1.5     NA       0.1        1
      96  #BBC0FF 32  1     1   311 31.5 32.5  0.5  1.5     NA       0.1        1
      97  #BBC7FF  1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      98  #BBC7FF  1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      99  #BBC7FF  1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      100 #BBC7FF  2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1
      101 #BBC7FF  2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1
      102 #BBC7FF  2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1
      103 #BBC7FF  3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1
      104 #BBC7FF  3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1
      105 #BBC7FF  3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1
      106 #BBC7FF  4  2     1    32  3.5  4.5  1.5  2.5     NA       0.1        1
      107 #BBC7FF  4  2     1    32  3.5  4.5  1.5  2.5     NA       0.1        1
      108 #BBC7FF  4  2     1    32  3.5  4.5  1.5  2.5     NA       0.1        1
      109 #BBC7FF  5  2     1    42  4.5  5.5  1.5  2.5     NA       0.1        1
      110 #BBC7FF  5  2     1    42  4.5  5.5  1.5  2.5     NA       0.1        1
      111 #BBC7FF  5  2     1    42  4.5  5.5  1.5  2.5     NA       0.1        1
      112 #BBC7FF  6  2     1    52  5.5  6.5  1.5  2.5     NA       0.1        1
      113 #BBC7FF  6  2     1    52  5.5  6.5  1.5  2.5     NA       0.1        1
      114 #BBC6FF  6  2     1    52  5.5  6.5  1.5  2.5     NA       0.1        1
      115 #BBC8FF  7  2     1    62  6.5  7.5  1.5  2.5     NA       0.1        1
      116 #BBC7FF  7  2     1    62  6.5  7.5  1.5  2.5     NA       0.1        1
      117 #BBC5FF  7  2     1    62  6.5  7.5  1.5  2.5     NA       0.1        1
      118 #FFC9BB  8  2     1    72  7.5  8.5  1.5  2.5     NA       0.1        1
      119 #BBC7FF  8  2     1    72  7.5  8.5  1.5  2.5     NA       0.1        1
      120 #BBC0FF  8  2     1    72  7.5  8.5  1.5  2.5     NA       0.1        1
      121 #FFC8BB  9  2     1    82  8.5  9.5  1.5  2.5     NA       0.1        1
      122 #BBC7FF  9  2     1    82  8.5  9.5  1.5  2.5     NA       0.1        1
      123 #BBC0FF  9  2     1    82  8.5  9.5  1.5  2.5     NA       0.1        1
      124 #FFC7BB 10  2     1    92  9.5 10.5  1.5  2.5     NA       0.1        1
      125 #BBC7FF 10  2     1    92  9.5 10.5  1.5  2.5     NA       0.1        1
      126 #BBC0FF 10  2     1    92  9.5 10.5  1.5  2.5     NA       0.1        1
      127 #FFC7BB 11  2     1   102 10.5 11.5  1.5  2.5     NA       0.1        1
      128 #BBC7FF 11  2     1   102 10.5 11.5  1.5  2.5     NA       0.1        1
      129 #BBC0FF 11  2     1   102 10.5 11.5  1.5  2.5     NA       0.1        1
      130 #FFC7BB 12  2     1   112 11.5 12.5  1.5  2.5     NA       0.1        1
      131 #BBC7FF 12  2     1   112 11.5 12.5  1.5  2.5     NA       0.1        1
      132 #BBC0FF 12  2     1   112 11.5 12.5  1.5  2.5     NA       0.1        1
      133 #FFC7BB 13  2     1   122 12.5 13.5  1.5  2.5     NA       0.1        1
      134 #BBC7FF 13  2     1   122 12.5 13.5  1.5  2.5     NA       0.1        1
      135 #BBC0FF 13  2     1   122 12.5 13.5  1.5  2.5     NA       0.1        1
      136 #FFC7BB 14  2     1   132 13.5 14.5  1.5  2.5     NA       0.1        1
      137 #BBC7FF 14  2     1   132 13.5 14.5  1.5  2.5     NA       0.1        1
      138 #BBC0FF 14  2     1   132 13.5 14.5  1.5  2.5     NA       0.1        1
      139 #FFC7BB 15  2     1   142 14.5 15.5  1.5  2.5     NA       0.1        1
      140 #BBC7FF 15  2     1   142 14.5 15.5  1.5  2.5     NA       0.1        1
      141 #BBC0FF 15  2     1   142 14.5 15.5  1.5  2.5     NA       0.1        1
      142 #FFC7BB 16  2     1   152 15.5 16.5  1.5  2.5     NA       0.1        1
      143 #BBC7FF 16  2     1   152 15.5 16.5  1.5  2.5     NA       0.1        1
      144 #BBC0FF 16  2     1   152 15.5 16.5  1.5  2.5     NA       0.1        1
      145 #FFC0BB 17  2     1   162 16.5 17.5  1.5  2.5     NA       0.1        1
      146 #BBC7FF 17  2     1   162 16.5 17.5  1.5  2.5     NA       0.1        1
      147 #BBBEFF 17  2     1   162 16.5 17.5  1.5  2.5     NA       0.1        1
      148 #FFACA5 18  2     1   172 17.5 18.5  1.5  2.5     NA       0.1        1
      149 #BBC7FF 18  2     1   172 17.5 18.5  1.5  2.5     NA       0.1        1
      150 #BBBDFF 18  2     1   172 17.5 18.5  1.5  2.5     NA       0.1        1
      151 #FF4D33 19  2     1   182 18.5 19.5  1.5  2.5     NA       0.1        1
      152 #BBC7FF 19  2     1   182 18.5 19.5  1.5  2.5     NA       0.1        1
      153 #B8B6FF 19  2     1   182 18.5 19.5  1.5  2.5     NA       0.1        1
      154 #FF462D 20  2     1   192 19.5 20.5  1.5  2.5     NA       0.1        1
      155 #BBC7FF 20  2     1   192 19.5 20.5  1.5  2.5     NA       0.1        1
      156 #B8B5FF 20  2     1   192 19.5 20.5  1.5  2.5     NA       0.1        1
      157 #FF4129 21  2     1   202 20.5 21.5  1.5  2.5     NA       0.1        1
      158 #BBC7FF 21  2     1   202 20.5 21.5  1.5  2.5     NA       0.1        1
      159 #B7B4FF 21  2     1   202 20.5 21.5  1.5  2.5     NA       0.1        1
      160 #FF4128 22  2     1   212 21.5 22.5  1.5  2.5     NA       0.1        1
      161 #BBC7FF 22  2     1   212 21.5 22.5  1.5  2.5     NA       0.1        1
      162 #B7B4FF 22  2     1   212 21.5 22.5  1.5  2.5     NA       0.1        1
      163 #FFC3BB 23  2     1   222 22.5 23.5  1.5  2.5     NA       0.1        1
      164 #BBC7FF 23  2     1   222 22.5 23.5  1.5  2.5     NA       0.1        1
      165 #BBBFFF 23  2     1   222 22.5 23.5  1.5  2.5     NA       0.1        1
      166 #FFC3BB 24  2     1   232 23.5 24.5  1.5  2.5     NA       0.1        1
      167 #BBC7FF 24  2     1   232 23.5 24.5  1.5  2.5     NA       0.1        1
      168 #BBBFFF 24  2     1   232 23.5 24.5  1.5  2.5     NA       0.1        1
      169 #FFC3BB 25  2     1   242 24.5 25.5  1.5  2.5     NA       0.1        1
      170 #BBC7FF 25  2     1   242 24.5 25.5  1.5  2.5     NA       0.1        1
      171 #BBBFFF 25  2     1   242 24.5 25.5  1.5  2.5     NA       0.1        1
      172 #FFC3BB 26  2     1   252 25.5 26.5  1.5  2.5     NA       0.1        1
      173 #BBC7FF 26  2     1   252 25.5 26.5  1.5  2.5     NA       0.1        1
      174 #BBBFFF 26  2     1   252 25.5 26.5  1.5  2.5     NA       0.1        1
      175 #FFC2BB 27  2     1   262 26.5 27.5  1.5  2.5     NA       0.1        1
      176 #BBC7FF 27  2     1   262 26.5 27.5  1.5  2.5     NA       0.1        1
      177 #BBBFFF 27  2     1   262 26.5 27.5  1.5  2.5     NA       0.1        1
      178 #FFBCBB 28  2     1   272 27.5 28.5  1.5  2.5     NA       0.1        1
      179 #BBC7FF 28  2     1   272 27.5 28.5  1.5  2.5     NA       0.1        1
      180 #BBBEFF 28  2     1   272 27.5 28.5  1.5  2.5     NA       0.1        1
      181 #FF593F 29  2     1   282 28.5 29.5  1.5  2.5     NA       0.1        1
      182 #BBC7FF 29  2     1   282 28.5 29.5  1.5  2.5     NA       0.1        1
      183 #B9B7FF 29  2     1   282 28.5 29.5  1.5  2.5     NA       0.1        1
      184 #FF301B 30  2     1   292 29.5 30.5  1.5  2.5     NA       0.1        1
      185 #BBC7FF 30  2     1   292 29.5 30.5  1.5  2.5     NA       0.1        1
      186 #B7B3FF 30  2     1   292 29.5 30.5  1.5  2.5     NA       0.1        1
      187 #FF210F 31  2     1   302 30.5 31.5  1.5  2.5     NA       0.1        1
      188 #BBC7FF 31  2     1   302 30.5 31.5  1.5  2.5     NA       0.1        1
      189 #B6B2FF 31  2     1   302 30.5 31.5  1.5  2.5     NA       0.1        1
      190 #FF200F 32  2     1   312 31.5 32.5  1.5  2.5     NA       0.1        1
      191 #BBC7FF 32  2     1   312 31.5 32.5  1.5  2.5     NA       0.1        1
      192 #B6B2FF 32  2     1   312 31.5 32.5  1.5  2.5     NA       0.1        1
      193 #FFC1BB  1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      194 #BBC7FF  1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      195 #BBBFFF  1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      196 #FFC1BB  2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1
      197 #BBC7FF  2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1
      198 #BBBFFF  2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1
      199 #FFC1BB  3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1
      200 #BBC7FF  3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1
      201 #BBBFFF  3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1
      202 #FFC1BB  4  3     1    33  3.5  4.5  2.5  3.5     NA       0.1        1
      203 #BBC7FF  4  3     1    33  3.5  4.5  2.5  3.5     NA       0.1        1
      204 #BBBFFF  4  3     1    33  3.5  4.5  2.5  3.5     NA       0.1        1
      205 #FFC1BB  5  3     1    43  4.5  5.5  2.5  3.5     NA       0.1        1
      206 #BBC7FF  5  3     1    43  4.5  5.5  2.5  3.5     NA       0.1        1
      207 #BBBFFF  5  3     1    43  4.5  5.5  2.5  3.5     NA       0.1        1
      208 #FFC1BB  6  3     1    53  5.5  6.5  2.5  3.5     NA       0.1        1
      209 #BBC7FF  6  3     1    53  5.5  6.5  2.5  3.5     NA       0.1        1
      210 #BBBFFF  6  3     1    53  5.5  6.5  2.5  3.5     NA       0.1        1
      211 #FFB9B9  7  3     1    63  6.5  7.5  2.5  3.5     NA       0.1        1
      212 #BBC7FF  7  3     1    63  6.5  7.5  2.5  3.5     NA       0.1        1
      213 #BBBEFF  7  3     1    63  6.5  7.5  2.5  3.5     NA       0.1        1
      214 #FF2311  8  3     1    73  7.5  8.5  2.5  3.5     NA       0.1        1
      215 #BBC7FF  8  3     1    73  7.5  8.5  2.5  3.5     NA       0.1        1
      216 #B6B2FF  8  3     1    73  7.5  8.5  2.5  3.5     NA       0.1        1
      217 #FF1407  9  3     1    83  8.5  9.5  2.5  3.5     NA       0.1        1
      218 #BBC7FF  9  3     1    83  8.5  9.5  2.5  3.5     NA       0.1        1
      219 #B6B1FF  9  3     1    83  8.5  9.5  2.5  3.5     NA       0.1        1
      220 #FF0100 10  3     1    93  9.5 10.5  2.5  3.5     NA       0.1        1
      221 #BBC7FF 10  3     1    93  9.5 10.5  2.5  3.5     NA       0.1        1
      222 #B5B0FF 10  3     1    93  9.5 10.5  2.5  3.5     NA       0.1        1
      223 #FF0000 11  3     1   103 10.5 11.5  2.5  3.5     NA       0.1        1
      224 #BBC7FF 11  3     1   103 10.5 11.5  2.5  3.5     NA       0.1        1
      225 #B5B0FF 11  3     1   103 10.5 11.5  2.5  3.5     NA       0.1        1
      226 #FFC1BB 12  3     1   113 11.5 12.5  2.5  3.5     NA       0.1        1
      227 #BBC7FF 12  3     1   113 11.5 12.5  2.5  3.5     NA       0.1        1
      228 #BBBFFF 12  3     1   113 11.5 12.5  2.5  3.5     NA       0.1        1
      229 #FFC1BB 13  3     1   123 12.5 13.5  2.5  3.5     NA       0.1        1
      230 #BBC7FF 13  3     1   123 12.5 13.5  2.5  3.5     NA       0.1        1
      231 #BBBFFF 13  3     1   123 12.5 13.5  2.5  3.5     NA       0.1        1
      232 #FFC1BB 14  3     1   133 13.5 14.5  2.5  3.5     NA       0.1        1
      233 #BBC7FF 14  3     1   133 13.5 14.5  2.5  3.5     NA       0.1        1
      234 #BBBFFF 14  3     1   133 13.5 14.5  2.5  3.5     NA       0.1        1
      235 #FFC1BB 15  3     1   143 14.5 15.5  2.5  3.5     NA       0.1        1
      236 #BBC7FF 15  3     1   143 14.5 15.5  2.5  3.5     NA       0.1        1
      237 #BBBFFF 15  3     1   143 14.5 15.5  2.5  3.5     NA       0.1        1
      238 #FFC1BB 16  3     1   153 15.5 16.5  2.5  3.5     NA       0.1        1
      239 #BBC7FF 16  3     1   153 15.5 16.5  2.5  3.5     NA       0.1        1
      240 #BBBFFF 16  3     1   153 15.5 16.5  2.5  3.5     NA       0.1        1
      241 #FFBABA 17  3     1   163 16.5 17.5  2.5  3.5     NA       0.1        1
      242 #BBC7FF 17  3     1   163 16.5 17.5  2.5  3.5     NA       0.1        1
      243 #BBBEFF 17  3     1   163 16.5 17.5  2.5  3.5     NA       0.1        1
      244 #FF9788 18  3     1   173 17.5 18.5  2.5  3.5     NA       0.1        1
      245 #BBC7FF 18  3     1   173 17.5 18.5  2.5  3.5     NA       0.1        1
      246 #BBBCFF 18  3     1   173 17.5 18.5  2.5  3.5     NA       0.1        1
      247 #FF2512 19  3     1   183 18.5 19.5  2.5  3.5     NA       0.1        1
      248 #BBC7FF 19  3     1   183 18.5 19.5  2.5  3.5     NA       0.1        1
      249 #B6B2FF 19  3     1   183 18.5 19.5  2.5  3.5     NA       0.1        1
      250 #FF1709 20  3     1   193 19.5 20.5  2.5  3.5     NA       0.1        1
      251 #BBC7FF 20  3     1   193 19.5 20.5  2.5  3.5     NA       0.1        1
      252 #B5B1FF 20  3     1   193 19.5 20.5  2.5  3.5     NA       0.1        1
      253 #FF0702 21  3     1   203 20.5 21.5  2.5  3.5     NA       0.1        1
      254 #BBC7FF 21  3     1   203 20.5 21.5  2.5  3.5     NA       0.1        1
      255 #B5B0FF 21  3     1   203 20.5 21.5  2.5  3.5     NA       0.1        1
      256 #FF0802 22  3     1   213 21.5 22.5  2.5  3.5     NA       0.1        1
      257 #BBC6FF 22  3     1   213 21.5 22.5  2.5  3.5     NA       0.1        1
      258 #B4AEFF 22  3     1   213 21.5 22.5  2.5  3.5     NA       0.1        1
      259 #FFC1BB 23  3     1   223 22.5 23.5  2.5  3.5     NA       0.1        1
      260 #BBC6FF 23  3     1   223 22.5 23.5  2.5  3.5     NA       0.1        1
      261 #BBBFFF 23  3     1   223 22.5 23.5  2.5  3.5     NA       0.1        1
      262 #FFC1BB 24  3     1   233 23.5 24.5  2.5  3.5     NA       0.1        1
      263 #BBC6FF 24  3     1   233 23.5 24.5  2.5  3.5     NA       0.1        1
      264 #BBBEFF 24  3     1   233 23.5 24.5  2.5  3.5     NA       0.1        1
      265 #FFC1BB 25  3     1   243 24.5 25.5  2.5  3.5     NA       0.1        1
      266 #BBC6FF 25  3     1   243 24.5 25.5  2.5  3.5     NA       0.1        1
      267 #BBBEFF 25  3     1   243 24.5 25.5  2.5  3.5     NA       0.1        1
      268 #FFC2BB 26  3     1   253 25.5 26.5  2.5  3.5     NA       0.1        1
      269 #BBC6FF 26  3     1   253 25.5 26.5  2.5  3.5     NA       0.1        1
      270 #BBBDFF 26  3     1   253 25.5 26.5  2.5  3.5     NA       0.1        1
      271 #FFC1BB 27  3     1   263 26.5 27.5  2.5  3.5     NA       0.1        1
      272 #BBC6FF 27  3     1   263 26.5 27.5  2.5  3.5     NA       0.1        1
      273 #BBBDFF 27  3     1   263 26.5 27.5  2.5  3.5     NA       0.1        1
      274 #FFBCBB 28  3     1   273 27.5 28.5  2.5  3.5     NA       0.1        1
      275 #BBC6FF 28  3     1   273 27.5 28.5  2.5  3.5     NA       0.1        1
      276 #BBBCFF 28  3     1   273 27.5 28.5  2.5  3.5     NA       0.1        1
      277 #FF563C 29  3     1   283 28.5 29.5  2.5  3.5     NA       0.1        1
      278 #BBC6FF 29  3     1   283 28.5 29.5  2.5  3.5     NA       0.1        1
      279 #B3ACFF 29  3     1   283 28.5 29.5  2.5  3.5     NA       0.1        1
      280 #FF2B17 30  3     1   293 29.5 30.5  2.5  3.5     NA       0.1        1
      281 #BBC6FF 30  3     1   293 29.5 30.5  2.5  3.5     NA       0.1        1
      282 #B0A7FF 30  3     1   293 29.5 30.5  2.5  3.5     NA       0.1        1
      283 #FF190A 31  3     1   303 30.5 31.5  2.5  3.5     NA       0.1        1
      284 #BBC6FF 31  3     1   303 30.5 31.5  2.5  3.5     NA       0.1        1
      285 #AFA6FF 31  3     1   303 30.5 31.5  2.5  3.5     NA       0.1        1
      286 #FF190A 32  3     1   313 31.5 32.5  2.5  3.5     NA       0.1        1
      287 #BBC6FF 32  3     1   313 31.5 32.5  2.5  3.5     NA       0.1        1
      288 #AFA6FF 32  3     1   313 31.5 32.5  2.5  3.5     NA       0.1        1
      289 #FFC2BB  1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      290 #BBC5FF  1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      291 #BBBFFF  1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      292 #FFC4BB  2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1
      293 #BBC4FF  2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1
      294 #BBBFFF  2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1
      295 #FFC4BB  3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1
      296 #BBC2FF  3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1
      297 #BBBAFF  3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1
      298 #FFC4BB  4  4     1    34  3.5  4.5  3.5  4.5     NA       0.1        1
      299 #BBC1FF  4  4     1    34  3.5  4.5  3.5  4.5     NA       0.1        1
      300 #B3ABFF  4  4     1    34  3.5  4.5  3.5  4.5     NA       0.1        1
      301 #FFC4BB  5  4     1    44  4.5  5.5  3.5  4.5     NA       0.1        1
      302 #BBC1FF  5  4     1    44  4.5  5.5  3.5  4.5     NA       0.1        1
      303 #AEA4FF  5  4     1    44  4.5  5.5  3.5  4.5     NA       0.1        1
      304 #FFC4BB  6  4     1    54  5.5  6.5  3.5  4.5     NA       0.1        1
      305 #BBC0FF  6  4     1    54  5.5  6.5  3.5  4.5     NA       0.1        1
      306 #A99CFF  6  4     1    54  5.5  6.5  3.5  4.5     NA       0.1        1
      307 #FFBFBB  7  4     1    64  6.5  7.5  3.5  4.5     NA       0.1        1
      308 #BBC0FF  7  4     1    64  6.5  7.5  3.5  4.5     NA       0.1        1
      309 #A697FF  7  4     1    64  6.5  7.5  3.5  4.5     NA       0.1        1
      310 #FF4D33  8  4     1    74  7.5  8.5  3.5  4.5     NA       0.1        1
      311 #BBBFFF  8  4     1    74  7.5  8.5  3.5  4.5     NA       0.1        1
      312 #A392FF  8  4     1    74  7.5  8.5  3.5  4.5     NA       0.1        1
      313 #FF472E  9  4     1    84  8.5  9.5  3.5  4.5     NA       0.1        1
      314 #BBBFFF  9  4     1    84  8.5  9.5  3.5  4.5     NA       0.1        1
      315 #A392FF  9  4     1    84  8.5  9.5  3.5  4.5     NA       0.1        1
      316 #FF462D 10  4     1    94  9.5 10.5  3.5  4.5     NA       0.1        1
      317 #BBBEFF 10  4     1    94  9.5 10.5  3.5  4.5     NA       0.1        1
      318 #A391FF 10  4     1    94  9.5 10.5  3.5  4.5     NA       0.1        1
      319 #FF472E 11  4     1   104 10.5 11.5  3.5  4.5     NA       0.1        1
      320 #BBBEFF 11  4     1   104 10.5 11.5  3.5  4.5     NA       0.1        1
      321 #A391FF 11  4     1   104 10.5 11.5  3.5  4.5     NA       0.1        1
      322 #BBC7FF 12  4     1   114 11.5 12.5  3.5  4.5     NA       0.1        1
      323 #BBBEFF 12  4     1   114 11.5 12.5  3.5  4.5     NA       0.1        1
      324 #9F8CFF 12  4     1   114 11.5 12.5  3.5  4.5     NA       0.1        1
      325 #BBC7FF 13  4     1   124 12.5 13.5  3.5  4.5     NA       0.1        1
      326 #BBBEFF 13  4     1   124 12.5 13.5  3.5  4.5     NA       0.1        1
      327 #9F8CFF 13  4     1   124 12.5 13.5  3.5  4.5     NA       0.1        1
      328 #BBC7FF 14  4     1   134 13.5 14.5  3.5  4.5     NA       0.1        1
      329 #BBBEFF 14  4     1   134 13.5 14.5  3.5  4.5     NA       0.1        1
      330 #9F8CFF 14  4     1   134 13.5 14.5  3.5  4.5     NA       0.1        1
      331 #BBC7FF 15  4     1   144 14.5 15.5  3.5  4.5     NA       0.1        1
      332 #BBBEFF 15  4     1   144 14.5 15.5  3.5  4.5     NA       0.1        1
      333 #9F8CFF 15  4     1   144 14.5 15.5  3.5  4.5     NA       0.1        1
      334 #BBC7FF 16  4     1   154 15.5 16.5  3.5  4.5     NA       0.1        1
      335 #BBBEFF 16  4     1   154 15.5 16.5  3.5  4.5     NA       0.1        1
      336 #9F8CFF 16  4     1   154 15.5 16.5  3.5  4.5     NA       0.1        1
      337 #BBC7FF 17  4     1   164 16.5 17.5  3.5  4.5     NA       0.1        1
      338 #BBBEFF 17  4     1   164 16.5 17.5  3.5  4.5     NA       0.1        1
      339 #A18FFF 17  4     1   164 16.5 17.5  3.5  4.5     NA       0.1        1
      340 #BBC9FF 18  4     1   174 17.5 18.5  3.5  4.5     NA       0.1        1
      341 #BBBEFF 18  4     1   174 17.5 18.5  3.5  4.5     NA       0.1        1
      342 #A18FFF 18  4     1   174 17.5 18.5  3.5  4.5     NA       0.1        1
      343 #BBCCFF 19  4     1   184 18.5 19.5  3.5  4.5     NA       0.1        1
      344 #BBBEFF 19  4     1   184 18.5 19.5  3.5  4.5     NA       0.1        1
      345 #A08DFF 19  4     1   184 18.5 19.5  3.5  4.5     NA       0.1        1
      346 #BBCCFF 20  4     1   194 19.5 20.5  3.5  4.5     NA       0.1        1
      347 #BBBEFF 20  4     1   194 19.5 20.5  3.5  4.5     NA       0.1        1
      348 #A08DFF 20  4     1   194 19.5 20.5  3.5  4.5     NA       0.1        1
      349 #BBCCFF 21  4     1   204 20.5 21.5  3.5  4.5     NA       0.1        1
      350 #BBBEFF 21  4     1   204 20.5 21.5  3.5  4.5     NA       0.1        1
      351 #9F8CFF 21  4     1   204 20.5 21.5  3.5  4.5     NA       0.1        1
      352 #BBCCFF 22  4     1   214 21.5 22.5  3.5  4.5     NA       0.1        1
      353 #BBBDFF 22  4     1   214 21.5 22.5  3.5  4.5     NA       0.1        1
      354 #9E8BFF 22  4     1   214 21.5 22.5  3.5  4.5     NA       0.1        1
      355 #BBC6FF 23  4     1   224 22.5 23.5  3.5  4.5     NA       0.1        1
      356 #BBBCFF 23  4     1   224 22.5 23.5  3.5  4.5     NA       0.1        1
      357 #9A84FF 23  4     1   224 22.5 23.5  3.5  4.5     NA       0.1        1
      358 #BBC6FF 24  4     1   234 23.5 24.5  3.5  4.5     NA       0.1        1
      359 #BBBCFF 24  4     1   234 23.5 24.5  3.5  4.5     NA       0.1        1
      360 #9780FF 24  4     1   234 23.5 24.5  3.5  4.5     NA       0.1        1
      361 #BBC6FF 25  4     1   244 24.5 25.5  3.5  4.5     NA       0.1        1
      362 #BBBBFF 25  4     1   244 24.5 25.5  3.5  4.5     NA       0.1        1
      363 #967EFF 25  4     1   244 24.5 25.5  3.5  4.5     NA       0.1        1
      364 #BBC6FF 26  4     1   254 25.5 26.5  3.5  4.5     NA       0.1        1
      365 #BBBBFF 26  4     1   254 25.5 26.5  3.5  4.5     NA       0.1        1
      366 #957DFF 26  4     1   254 25.5 26.5  3.5  4.5     NA       0.1        1
      367 #BBC6FF 27  4     1   264 26.5 27.5  3.5  4.5     NA       0.1        1
      368 #BBBAFF 27  4     1   264 26.5 27.5  3.5  4.5     NA       0.1        1
      369 #947CFF 27  4     1   264 26.5 27.5  3.5  4.5     NA       0.1        1
      370 #BBC7FF 28  4     1   274 27.5 28.5  3.5  4.5     NA       0.1        1
      371 #BABAFF 28  4     1   274 27.5 28.5  3.5  4.5     NA       0.1        1
      372 #967EFF 28  4     1   274 27.5 28.5  3.5  4.5     NA       0.1        1
      373 #BBCAFF 29  4     1   284 28.5 29.5  3.5  4.5     NA       0.1        1
      374 #BAB9FF 29  4     1   284 28.5 29.5  3.5  4.5     NA       0.1        1
      375 #957DFF 29  4     1   284 28.5 29.5  3.5  4.5     NA       0.1        1
      376 #BBCBFF 30  4     1   294 29.5 30.5  3.5  4.5     NA       0.1        1
      377 #BAB9FF 30  4     1   294 29.5 30.5  3.5  4.5     NA       0.1        1
      378 #947CFF 30  4     1   294 29.5 30.5  3.5  4.5     NA       0.1        1
      379 #BBCBFF 31  4     1   304 30.5 31.5  3.5  4.5     NA       0.1        1
      380 #BAB9FF 31  4     1   304 30.5 31.5  3.5  4.5     NA       0.1        1
      381 #947CFF 31  4     1   304 30.5 31.5  3.5  4.5     NA       0.1        1
      382 #BBCBFF 32  4     1   314 31.5 32.5  3.5  4.5     NA       0.1        1
      383 #BAB9FF 32  4     1   314 31.5 32.5  3.5  4.5     NA       0.1        1
      384 #947CFF 32  4     1   314 31.5 32.5  3.5  4.5     NA       0.1        1
      385 #BBC7FF  1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      386 #BBC5FF  1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      387 #BBC0FF  1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      388 #BBC7FF  2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1
      389 #BBC2FF  2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1
      390 #B4AEFF  2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1
      391 #BBC7FF  3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1
      392 #BBBFFF  3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1
      393 #9F8CFF  3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1
      394 #BBC7FF  4  5     1    35  3.5  4.5  4.5  5.5     NA       0.1        1
      395 #BBBEFF  4  5     1    35  3.5  4.5  4.5  5.5     NA       0.1        1
      396 #957DFF  4  5     1    35  3.5  4.5  4.5  5.5     NA       0.1        1
      397 #BBC7FF  5  5     1    45  4.5  5.5  4.5  5.5     NA       0.1        1
      398 #BBBDFF  5  5     1    45  4.5  5.5  4.5  5.5     NA       0.1        1
      399 #8E74FF  5  5     1    45  4.5  5.5  4.5  5.5     NA       0.1        1
      400 #BBC7FF  6  5     1    55  5.5  6.5  4.5  5.5     NA       0.1        1
      401 #BBBDFF  6  5     1    55  5.5  6.5  4.5  5.5     NA       0.1        1
      402 #886CFF  6  5     1    55  5.5  6.5  4.5  5.5     NA       0.1        1
      403 #BBC8FF  7  5     1    65  6.5  7.5  4.5  5.5     NA       0.1        1
      404 #BBBCFF  7  5     1    65  6.5  7.5  4.5  5.5     NA       0.1        1
      405 #8467FF  7  5     1    65  6.5  7.5  4.5  5.5     NA       0.1        1
      406 #BBCCFF  8  5     1    75  7.5  8.5  4.5  5.5     NA       0.1        1
      407 #BBBCFF  8  5     1    75  7.5  8.5  4.5  5.5     NA       0.1        1
      408 #8062FF  8  5     1    75  7.5  8.5  4.5  5.5     NA       0.1        1
      409 #FFCCBB  9  5     1    85  8.5  9.5  4.5  5.5     NA       0.1        1
      410 #BBBCFF  9  5     1    85  8.5  9.5  4.5  5.5     NA       0.1        1
      411 #8062FF  9  5     1    85  8.5  9.5  4.5  5.5     NA       0.1        1
      412 #FFCCBB 10  5     1    95  9.5 10.5  4.5  5.5     NA       0.1        1
      413 #BBBBFF 10  5     1    95  9.5 10.5  4.5  5.5     NA       0.1        1
      414 #7F61FF 10  5     1    95  9.5 10.5  4.5  5.5     NA       0.1        1
      415 #BBCCFF 11  5     1   105 10.5 11.5  4.5  5.5     NA       0.1        1
      416 #B9B8FF 11  5     1   105 10.5 11.5  4.5  5.5     NA       0.1        1
      417 #7F61FF 11  5     1   105 10.5 11.5  4.5  5.5     NA       0.1        1
      418 #BBC7FF 12  5     1   115 11.5 12.5  4.5  5.5     NA       0.1        1
      419 #B9B7FF 12  5     1   115 11.5 12.5  4.5  5.5     NA       0.1        1
      420 #7D5FFF 12  5     1   115 11.5 12.5  4.5  5.5     NA       0.1        1
      421 #BBC7FF 13  5     1   125 12.5 13.5  4.5  5.5     NA       0.1        1
      422 #B8B6FF 13  5     1   125 12.5 13.5  4.5  5.5     NA       0.1        1
      423 #7D5FFF 13  5     1   125 12.5 13.5  4.5  5.5     NA       0.1        1
      424 #BBC7FF 14  5     1   135 13.5 14.5  4.5  5.5     NA       0.1        1
      425 #B8B6FF 14  5     1   135 13.5 14.5  4.5  5.5     NA       0.1        1
      426 #7D5FFF 14  5     1   135 13.5 14.5  4.5  5.5     NA       0.1        1
      427 #BBC7FF 15  5     1   145 14.5 15.5  4.5  5.5     NA       0.1        1
      428 #B8B6FF 15  5     1   145 14.5 15.5  4.5  5.5     NA       0.1        1
      429 #7D5FFF 15  5     1   145 14.5 15.5  4.5  5.5     NA       0.1        1
      430 #BBC7FF 16  5     1   155 15.5 16.5  4.5  5.5     NA       0.1        1
      431 #B8B6FF 16  5     1   155 15.5 16.5  4.5  5.5     NA       0.1        1
      432 #7D5FFF 16  5     1   155 15.5 16.5  4.5  5.5     NA       0.1        1
      433 #BBC7FF 17  5     1   165 16.5 17.5  4.5  5.5     NA       0.1        1
      434 #B7B4FF 17  5     1   165 16.5 17.5  4.5  5.5     NA       0.1        1
      435 #8063FF 17  5     1   165 16.5 17.5  4.5  5.5     NA       0.1        1
      436 #BBC7FF 18  5     1   175 17.5 18.5  4.5  5.5     NA       0.1        1
      437 #B6B2FF 18  5     1   175 17.5 18.5  4.5  5.5     NA       0.1        1
      438 #8062FF 18  5     1   175 17.5 18.5  4.5  5.5     NA       0.1        1
      439 #BBC8FF 19  5     1   185 18.5 19.5  4.5  5.5     NA       0.1        1
      440 #B4AFFF 19  5     1   185 18.5 19.5  4.5  5.5     NA       0.1        1
      441 #7F61FF 19  5     1   185 18.5 19.5  4.5  5.5     NA       0.1        1
      442 #BBC5FF 20  5     1   195 19.5 20.5  4.5  5.5     NA       0.1        1
      443 #B2AAFF 20  5     1   195 19.5 20.5  4.5  5.5     NA       0.1        1
      444 #7E60FF 20  5     1   195 19.5 20.5  4.5  5.5     NA       0.1        1
      445 #BBC3FF 21  5     1   205 20.5 21.5  4.5  5.5     NA       0.1        1
      446 #B0A7FF 21  5     1   205 20.5 21.5  4.5  5.5     NA       0.1        1
      447 #7E60FF 21  5     1   205 20.5 21.5  4.5  5.5     NA       0.1        1
      448 #BBC2FF 22  5     1   215 21.5 22.5  4.5  5.5     NA       0.1        1
      449 #ADA2FF 22  5     1   215 21.5 22.5  4.5  5.5     NA       0.1        1
      450 #7C5EFF 22  5     1   215 21.5 22.5  4.5  5.5     NA       0.1        1
      451 #BBC2FF 23  5     1   225 22.5 23.5  4.5  5.5     NA       0.1        1
      452 #AA9DFF 23  5     1   225 22.5 23.5  4.5  5.5     NA       0.1        1
      453 #7859FF 23  5     1   225 22.5 23.5  4.5  5.5     NA       0.1        1
      454 #BBC2FF 24  5     1   235 23.5 24.5  4.5  5.5     NA       0.1        1
      455 #A99BFF 24  5     1   235 23.5 24.5  4.5  5.5     NA       0.1        1
      456 #7354FF 24  5     1   235 23.5 24.5  4.5  5.5     NA       0.1        1
      457 #BBC2FF 25  5     1   245 24.5 25.5  4.5  5.5     NA       0.1        1
      458 #A799FF 25  5     1   245 24.5 25.5  4.5  5.5     NA       0.1        1
      459 #7152FF 25  5     1   245 24.5 25.5  4.5  5.5     NA       0.1        1
      460 #BBC2FF 26  5     1   255 25.5 26.5  4.5  5.5     NA       0.1        1
      461 #A798FF 26  5     1   255 25.5 26.5  4.5  5.5     NA       0.1        1
      462 #7050FF 26  5     1   255 25.5 26.5  4.5  5.5     NA       0.1        1
      463 #BBC2FF 27  5     1   265 26.5 27.5  4.5  5.5     NA       0.1        1
      464 #A697FF 27  5     1   265 26.5 27.5  4.5  5.5     NA       0.1        1
      465 #6F4FFF 27  5     1   265 26.5 27.5  4.5  5.5     NA       0.1        1
      466 #BBC2FF 28  5     1   275 27.5 28.5  4.5  5.5     NA       0.1        1
      467 #A696FF 28  5     1   275 27.5 28.5  4.5  5.5     NA       0.1        1
      468 #7151FF 28  5     1   275 27.5 28.5  4.5  5.5     NA       0.1        1
      469 #BBC6FF 29  5     1   285 28.5 29.5  4.5  5.5     NA       0.1        1
      470 #A595FF 29  5     1   285 28.5 29.5  4.5  5.5     NA       0.1        1
      471 #6F50FF 29  5     1   285 28.5 29.5  4.5  5.5     NA       0.1        1
      472 #BBC7FF 30  5     1   295 29.5 30.5  4.5  5.5     NA       0.1        1
      473 #A595FF 30  5     1   295 29.5 30.5  4.5  5.5     NA       0.1        1
      474 #6F4FFF 30  5     1   295 29.5 30.5  4.5  5.5     NA       0.1        1
      475 #BBC7FF 31  5     1   305 30.5 31.5  4.5  5.5     NA       0.1        1
      476 #A595FF 31  5     1   305 30.5 31.5  4.5  5.5     NA       0.1        1
      477 #6E4FFF 31  5     1   305 30.5 31.5  4.5  5.5     NA       0.1        1
      478 #BBC7FF 32  5     1   315 31.5 32.5  4.5  5.5     NA       0.1        1
      479 #A595FF 32  5     1   315 31.5 32.5  4.5  5.5     NA       0.1        1
      480 #6E4FFF 32  5     1   315 31.5 32.5  4.5  5.5     NA       0.1        1
      481 #FFC5BB  1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      482 #BBC5FF  1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      483 #BBBFFF  1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      484 #FFC6BB  2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1
      485 #BBC1FF  2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1
      486 #B2ABFF  2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1
      487 #FFC6BB  3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1
      488 #BBBEFF  3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1
      489 #9982FF  3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1
      490 #FFC6BB  4  6     1    36  3.5  4.5  5.5  6.5     NA       0.1        1
      491 #BBBDFF  4  6     1    36  3.5  4.5  5.5  6.5     NA       0.1        1
      492 #896DFF  4  6     1    36  3.5  4.5  5.5  6.5     NA       0.1        1
      493 #FFC6BB  5  6     1    46  4.5  5.5  5.5  6.5     NA       0.1        1
      494 #BBBCFF  5  6     1    46  4.5  5.5  5.5  6.5     NA       0.1        1
      495 #8264FF  5  6     1    46  4.5  5.5  5.5  6.5     NA       0.1        1
      496 #FFC6BB  6  6     1    56  5.5  6.5  5.5  6.5     NA       0.1        1
      497 #BBBBFF  6  6     1    56  5.5  6.5  5.5  6.5     NA       0.1        1
      498 #7A5CFF  6  6     1    56  5.5  6.5  5.5  6.5     NA       0.1        1
      499 #FFC0BB  7  6     1    66  6.5  7.5  5.5  6.5     NA       0.1        1
      500 #BABAFF  7  6     1    66  6.5  7.5  5.5  6.5     NA       0.1        1
      501 #7657FF  7  6     1    66  6.5  7.5  5.5  6.5     NA       0.1        1
      502 #FF573D  8  6     1    76  7.5  8.5  5.5  6.5     NA       0.1        1
      503 #B9B7FF  8  6     1    76  7.5  8.5  5.5  6.5     NA       0.1        1
      504 #7152FF  8  6     1    76  7.5  8.5  5.5  6.5     NA       0.1        1
      505 #FF5339  9  6     1    86  8.5  9.5  5.5  6.5     NA       0.1        1
      506 #B8B6FF  9  6     1    86  8.5  9.5  5.5  6.5     NA       0.1        1
      507 #7151FF  9  6     1    86  8.5  9.5  5.5  6.5     NA       0.1        1
      508 #FF5238 10  6     1    96  9.5 10.5  5.5  6.5     NA       0.1        1
      509 #B7B3FF 10  6     1    96  9.5 10.5  5.5  6.5     NA       0.1        1
      510 #7051FF 10  6     1    96  9.5 10.5  5.5  6.5     NA       0.1        1
      511 #FF563B 11  6     1   106 10.5 11.5  5.5  6.5     NA       0.1        1
      512 #B5B1FF 11  6     1   106 10.5 11.5  5.5  6.5     NA       0.1        1
      513 #7050FF 11  6     1   106 10.5 11.5  5.5  6.5     NA       0.1        1
      514 #FFC6BB 12  6     1   116 11.5 12.5  5.5  6.5     NA       0.1        1
      515 #B4AFFF 12  6     1   116 11.5 12.5  5.5  6.5     NA       0.1        1
      516 #6D4EFF 12  6     1   116 11.5 12.5  5.5  6.5     NA       0.1        1
      517 #FFC6BB 13  6     1   126 12.5 13.5  5.5  6.5     NA       0.1        1
      518 #B4AEFF 13  6     1   126 12.5 13.5  5.5  6.5     NA       0.1        1
      519 #6D4EFF 13  6     1   126 12.5 13.5  5.5  6.5     NA       0.1        1
      520 #FFC6BB 14  6     1   136 13.5 14.5  5.5  6.5     NA       0.1        1
      521 #B4AEFF 14  6     1   136 13.5 14.5  5.5  6.5     NA       0.1        1
      522 #6D4EFF 14  6     1   136 13.5 14.5  5.5  6.5     NA       0.1        1
      523 #FFC6BB 15  6     1   146 14.5 15.5  5.5  6.5     NA       0.1        1
      524 #B4AEFF 15  6     1   146 14.5 15.5  5.5  6.5     NA       0.1        1
      525 #6D4DFF 15  6     1   146 14.5 15.5  5.5  6.5     NA       0.1        1
      526 #FFC7BB 16  6     1   156 15.5 16.5  5.5  6.5     NA       0.1        1
      527 #B4ADFF 16  6     1   156 15.5 16.5  5.5  6.5     NA       0.1        1
      528 #6D4DFF 16  6     1   156 15.5 16.5  5.5  6.5     NA       0.1        1
      529 #FFC7BB 17  6     1   166 16.5 17.5  5.5  6.5     NA       0.1        1
      530 #B3ACFF 17  6     1   166 16.5 17.5  5.5  6.5     NA       0.1        1
      531 #6F50FF 17  6     1   166 16.5 17.5  5.5  6.5     NA       0.1        1
      532 #FFC9BB 18  6     1   176 17.5 18.5  5.5  6.5     NA       0.1        1
      533 #B1A9FF 18  6     1   176 17.5 18.5  5.5  6.5     NA       0.1        1
      534 #6F4FFF 18  6     1   176 17.5 18.5  5.5  6.5     NA       0.1        1
      535 #FFC9BB 19  6     1   186 18.5 19.5  5.5  6.5     NA       0.1        1
      536 #AEA4FF 19  6     1   186 18.5 19.5  5.5  6.5     NA       0.1        1
      537 #6C4CFF 19  6     1   186 18.5 19.5  5.5  6.5     NA       0.1        1
      538 #BBCAFF 20  6     1   196 19.5 20.5  5.5  6.5     NA       0.1        1
      539 #AB9EFF 20  6     1   196 19.5 20.5  5.5  6.5     NA       0.1        1
      540 #6B4BFF 20  6     1   196 19.5 20.5  5.5  6.5     NA       0.1        1
      541 #BBC7FF 21  6     1   206 20.5 21.5  5.5  6.5     NA       0.1        1
      542 #A89AFF 21  6     1   206 20.5 21.5  5.5  6.5     NA       0.1        1
      543 #6849FF 21  6     1   206 20.5 21.5  5.5  6.5     NA       0.1        1
      544 #BBC6FF 22  6     1   216 21.5 22.5  5.5  6.5     NA       0.1        1
      545 #A594FF 22  6     1   216 21.5 22.5  5.5  6.5     NA       0.1        1
      546 #6646FF 22  6     1   216 21.5 22.5  5.5  6.5     NA       0.1        1
      547 #BBC1FF 23  6     1   226 22.5 23.5  5.5  6.5     NA       0.1        1
      548 #A290FF 23  6     1   226 22.5 23.5  5.5  6.5     NA       0.1        1
      549 #5E3FFF 23  6     1   226 22.5 23.5  5.5  6.5     NA       0.1        1
      550 #BBC1FF 24  6     1   236 23.5 24.5  5.5  6.5     NA       0.1        1
      551 #A08DFF 24  6     1   236 23.5 24.5  5.5  6.5     NA       0.1        1
      552 #5738FF 24  6     1   236 23.5 24.5  5.5  6.5     NA       0.1        1
      553 #BBC0FF 25  6     1   246 24.5 25.5  5.5  6.5     NA       0.1        1
      554 #9F8BFF 25  6     1   246 24.5 25.5  5.5  6.5     NA       0.1        1
      555 #5536FF 25  6     1   246 24.5 25.5  5.5  6.5     NA       0.1        1
      556 #BBC0FF 26  6     1   256 25.5 26.5  5.5  6.5     NA       0.1        1
      557 #9E8AFF 26  6     1   256 25.5 26.5  5.5  6.5     NA       0.1        1
      558 #5235FF 26  6     1   256 25.5 26.5  5.5  6.5     NA       0.1        1
      559 #BBC0FF 27  6     1   266 26.5 27.5  5.5  6.5     NA       0.1        1
      560 #9D89FF 27  6     1   266 26.5 27.5  5.5  6.5     NA       0.1        1
      561 #5033FF 27  6     1   266 26.5 27.5  5.5  6.5     NA       0.1        1
      562 #BBC1FF 28  6     1   276 27.5 28.5  5.5  6.5     NA       0.1        1
      563 #9D88FF 28  6     1   276 27.5 28.5  5.5  6.5     NA       0.1        1
      564 #5335FF 28  6     1   276 27.5 28.5  5.5  6.5     NA       0.1        1
      565 #BBC4FF 29  6     1   286 28.5 29.5  5.5  6.5     NA       0.1        1
      566 #9C88FF 29  6     1   286 28.5 29.5  5.5  6.5     NA       0.1        1
      567 #5134FF 29  6     1   286 28.5 29.5  5.5  6.5     NA       0.1        1
      568 #BBC5FF 30  6     1   296 29.5 30.5  5.5  6.5     NA       0.1        1
      569 #9C87FF 30  6     1   296 29.5 30.5  5.5  6.5     NA       0.1        1
      570 #5133FF 30  6     1   296 29.5 30.5  5.5  6.5     NA       0.1        1
      571 #BBC5FF 31  6     1   306 30.5 31.5  5.5  6.5     NA       0.1        1
      572 #9C87FF 31  6     1   306 30.5 31.5  5.5  6.5     NA       0.1        1
      573 #5033FF 31  6     1   306 30.5 31.5  5.5  6.5     NA       0.1        1
      574 #BBC5FF 32  6     1   316 31.5 32.5  5.5  6.5     NA       0.1        1
      575 #9C87FF 32  6     1   316 31.5 32.5  5.5  6.5     NA       0.1        1
      576 #5033FF 32  6     1   316 31.5 32.5  5.5  6.5     NA       0.1        1
      577 #FFC3BB  1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      578 #BBC5FF  1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      579 #BBBFFF  1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      580 #FFC4BB  2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1
      581 #BBC1FF  2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1
      582 #B0A7FF  2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1
      583 #FFC4BB  3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1
      584 #BBBEFF  3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1
      585 #967EFF  3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1
      586 #FFC4BB  4  7     1    37  3.5  4.5  6.5  7.5     NA       0.1        1
      587 #BBBCFF  4  7     1    37  3.5  4.5  6.5  7.5     NA       0.1        1
      588 #7E61FF  4  7     1    37  3.5  4.5  6.5  7.5     NA       0.1        1
      589 #FFC4BB  5  7     1    47  4.5  5.5  6.5  7.5     NA       0.1        1
      590 #BABAFF  5  7     1    47  4.5  5.5  6.5  7.5     NA       0.1        1
      591 #7253FF  5  7     1    47  4.5  5.5  6.5  7.5     NA       0.1        1
      592 #FFC4BB  6  7     1    57  5.5  6.5  6.5  7.5     NA       0.1        1
      593 #B8B6FF  6  7     1    57  5.5  6.5  6.5  7.5     NA       0.1        1
      594 #6A4AFF  6  7     1    57  5.5  6.5  6.5  7.5     NA       0.1        1
      595 #FFBFBB  7  7     1    67  6.5  7.5  6.5  7.5     NA       0.1        1
      596 #B7B4FF  7  7     1    67  6.5  7.5  6.5  7.5     NA       0.1        1
      597 #6445FF  7  7     1    67  6.5  7.5  6.5  7.5     NA       0.1        1
      598 #FF4E34  8  7     1    77  7.5  8.5  6.5  7.5     NA       0.1        1
      599 #B6B1FF  8  7     1    77  7.5  8.5  6.5  7.5     NA       0.1        1
      600 #5F3FFF  8  7     1    77  7.5  8.5  6.5  7.5     NA       0.1        1
      601 #FF492F  9  7     1    87  8.5  9.5  6.5  7.5     NA       0.1        1
      602 #B5B0FF  9  7     1    87  8.5  9.5  6.5  7.5     NA       0.1        1
      603 #5E3FFF  9  7     1    87  8.5  9.5  6.5  7.5     NA       0.1        1
      604 #FF482F 10  7     1    97  9.5 10.5  6.5  7.5     NA       0.1        1
      605 #B4ADFF 10  7     1    97  9.5 10.5  6.5  7.5     NA       0.1        1
      606 #5D3EFF 10  7     1    97  9.5 10.5  6.5  7.5     NA       0.1        1
      607 #FF4C32 11  7     1   107 10.5 11.5  6.5  7.5     NA       0.1        1
      608 #B2ABFF 11  7     1   107 10.5 11.5  6.5  7.5     NA       0.1        1
      609 #5D3EFF 11  7     1   107 10.5 11.5  6.5  7.5     NA       0.1        1
      610 #FFC6BB 12  7     1   117 11.5 12.5  6.5  7.5     NA       0.1        1
      611 #B1A9FF 12  7     1   117 11.5 12.5  6.5  7.5     NA       0.1        1
      612 #5A3BFF 12  7     1   117 11.5 12.5  6.5  7.5     NA       0.1        1
      613 #FFC6BB 13  7     1   127 12.5 13.5  6.5  7.5     NA       0.1        1
      614 #B1A8FF 13  7     1   127 12.5 13.5  6.5  7.5     NA       0.1        1
      615 #5A3BFF 13  7     1   127 12.5 13.5  6.5  7.5     NA       0.1        1
      616 #FFC6BB 14  7     1   137 13.5 14.5  6.5  7.5     NA       0.1        1
      617 #B0A8FF 14  7     1   137 13.5 14.5  6.5  7.5     NA       0.1        1
      618 #5A3BFF 14  7     1   137 13.5 14.5  6.5  7.5     NA       0.1        1
      619 #FFC7BB 15  7     1   147 14.5 15.5  6.5  7.5     NA       0.1        1
      620 #B0A7FF 15  7     1   147 14.5 15.5  6.5  7.5     NA       0.1        1
      621 #593BFF 15  7     1   147 14.5 15.5  6.5  7.5     NA       0.1        1
      622 #FFC7BB 16  7     1   157 15.5 16.5  6.5  7.5     NA       0.1        1
      623 #B0A7FF 16  7     1   157 15.5 16.5  6.5  7.5     NA       0.1        1
      624 #593AFF 16  7     1   157 15.5 16.5  6.5  7.5     NA       0.1        1
      625 #FFC8BB 17  7     1   167 16.5 17.5  6.5  7.5     NA       0.1        1
      626 #AFA6FF 17  7     1   167 16.5 17.5  6.5  7.5     NA       0.1        1
      627 #5C3DFF 17  7     1   167 16.5 17.5  6.5  7.5     NA       0.1        1
      628 #BBCCFF 18  7     1   177 17.5 18.5  6.5  7.5     NA       0.1        1
      629 #ADA2FF 18  7     1   177 17.5 18.5  6.5  7.5     NA       0.1        1
      630 #5B3DFF 18  7     1   177 17.5 18.5  6.5  7.5     NA       0.1        1
      631 #BBCCFF 19  7     1   187 18.5 19.5  6.5  7.5     NA       0.1        1
      632 #AA9DFF 19  7     1   187 18.5 19.5  6.5  7.5     NA       0.1        1
      633 #583AFF 19  7     1   187 18.5 19.5  6.5  7.5     NA       0.1        1
      634 #BBC9FF 20  7     1   197 19.5 20.5  6.5  7.5     NA       0.1        1
      635 #A797FF 20  7     1   197 19.5 20.5  6.5  7.5     NA       0.1        1
      636 #5738FF 20  7     1   197 19.5 20.5  6.5  7.5     NA       0.1        1
      637 #BBC7FF 21  7     1   207 20.5 21.5  6.5  7.5     NA       0.1        1
      638 #A493FF 21  7     1   207 20.5 21.5  6.5  7.5     NA       0.1        1
      639 #5335FF 21  7     1   207 20.5 21.5  6.5  7.5     NA       0.1        1
      640 #BBC6FF 22  7     1   217 21.5 22.5  6.5  7.5     NA       0.1        1
      641 #A08DFF 22  7     1   217 21.5 22.5  6.5  7.5     NA       0.1        1
      642 #5033FF 22  7     1   217 21.5 22.5  6.5  7.5     NA       0.1        1
      643 #BBBCFF 23  7     1   227 22.5 23.5  6.5  7.5     NA       0.1        1
      644 #9D89FF 23  7     1   227 22.5 23.5  6.5  7.5     NA       0.1        1
      645 #3E24FF 23  7     1   227 22.5 23.5  6.5  7.5     NA       0.1        1
      646 #BBBBFF 24  7     1   237 23.5 24.5  6.5  7.5     NA       0.1        1
      647 #9B86FF 24  7     1   237 23.5 24.5  6.5  7.5     NA       0.1        1
      648 #331CFF 24  7     1   237 23.5 24.5  6.5  7.5     NA       0.1        1
      649 #BABAFF 25  7     1   247 24.5 25.5  6.5  7.5     NA       0.1        1
      650 #9A84FF 25  7     1   247 24.5 25.5  6.5  7.5     NA       0.1        1
      651 #2F1AFF 25  7     1   247 24.5 25.5  6.5  7.5     NA       0.1        1
      652 #BAB8FF 26  7     1   257 25.5 26.5  6.5  7.5     NA       0.1        1
      653 #9983FF 26  7     1   257 25.5 26.5  6.5  7.5     NA       0.1        1
      654 #2B17FF 26  7     1   257 25.5 26.5  6.5  7.5     NA       0.1        1
      655 #B9B7FF 27  7     1   267 26.5 27.5  6.5  7.5     NA       0.1        1
      656 #9882FF 27  7     1   267 26.5 27.5  6.5  7.5     NA       0.1        1
      657 #2714FF 27  7     1   267 26.5 27.5  6.5  7.5     NA       0.1        1
      658 #B8B5FF 28  7     1   277 27.5 28.5  6.5  7.5     NA       0.1        1
      659 #9781FF 28  7     1   277 27.5 28.5  6.5  7.5     NA       0.1        1
      660 #2C17FF 28  7     1   277 27.5 28.5  6.5  7.5     NA       0.1        1
      661 #BBBDFF 29  7     1   287 28.5 29.5  6.5  7.5     NA       0.1        1
      662 #9780FF 29  7     1   287 28.5 29.5  6.5  7.5     NA       0.1        1
      663 #2814FF 29  7     1   287 28.5 29.5  6.5  7.5     NA       0.1        1
      664 #BBBEFF 30  7     1   297 29.5 30.5  6.5  7.5     NA       0.1        1
      665 #9780FF 30  7     1   297 29.5 30.5  6.5  7.5     NA       0.1        1
      666 #2613FF 30  7     1   297 29.5 30.5  6.5  7.5     NA       0.1        1
      667 #BBBEFF 31  7     1   307 30.5 31.5  6.5  7.5     NA       0.1        1
      668 #9780FF 31  7     1   307 30.5 31.5  6.5  7.5     NA       0.1        1
      669 #2512FF 31  7     1   307 30.5 31.5  6.5  7.5     NA       0.1        1
      670 #BBBEFF 32  7     1   317 31.5 32.5  6.5  7.5     NA       0.1        1
      671 #9780FF 32  7     1   317 31.5 32.5  6.5  7.5     NA       0.1        1
      672 #2512FF 32  7     1   317 31.5 32.5  6.5  7.5     NA       0.1        1
      673 #BBC7FF  1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      674 #BBC5FF  1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      675 #BBC0FF  1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      676 #BBC7FF  2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1
      677 #BBC1FF  2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1
      678 #AC9FFF  2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1
      679 #BBC7FF  3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1
      680 #BBBEFF  3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1
      681 #9077FF  3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1
      682 #BBC7FF  4  8     1    38  3.5  4.5  7.5  8.5     NA       0.1        1
      683 #BBBBFF  4  8     1    38  3.5  4.5  7.5  8.5     NA       0.1        1
      684 #7859FF  4  8     1    38  3.5  4.5  7.5  8.5     NA       0.1        1
      685 #BBC7FF  5  8     1    48  4.5  5.5  7.5  8.5     NA       0.1        1
      686 #B9B8FF  5  8     1    48  4.5  5.5  7.5  8.5     NA       0.1        1
      687 #694AFF  5  8     1    48  4.5  5.5  7.5  8.5     NA       0.1        1
      688 #BBC7FF  6  8     1    58  5.5  6.5  7.5  8.5     NA       0.1        1
      689 #B7B4FF  6  8     1    58  5.5  6.5  7.5  8.5     NA       0.1        1
      690 #5E3FFF  6  8     1    58  5.5  6.5  7.5  8.5     NA       0.1        1
      691 #BBC8FF  7  8     1    68  6.5  7.5  7.5  8.5     NA       0.1        1
      692 #B6B1FF  7  8     1    68  6.5  7.5  7.5  8.5     NA       0.1        1
      693 #5839FF  7  8     1    68  6.5  7.5  7.5  8.5     NA       0.1        1
      694 #BBCCFF  8  8     1    78  7.5  8.5  7.5  8.5     NA       0.1        1
      695 #B5AFFF  8  8     1    78  7.5  8.5  7.5  8.5     NA       0.1        1
      696 #5133FF  8  8     1    78  7.5  8.5  7.5  8.5     NA       0.1        1
      697 #BBCCFF  9  8     1    88  8.5  9.5  7.5  8.5     NA       0.1        1
      698 #B4AEFF  9  8     1    88  8.5  9.5  7.5  8.5     NA       0.1        1
      699 #5033FF  9  8     1    88  8.5  9.5  7.5  8.5     NA       0.1        1
      700 #BBCCFF 10  8     1    98  9.5 10.5  7.5  8.5     NA       0.1        1
      701 #B2ABFF 10  8     1    98  9.5 10.5  7.5  8.5     NA       0.1        1
      702 #5032FF 10  8     1    98  9.5 10.5  7.5  8.5     NA       0.1        1
      703 #BBCCFF 11  8     1   108 10.5 11.5  7.5  8.5     NA       0.1        1
      704 #B1A8FF 11  8     1   108 10.5 11.5  7.5  8.5     NA       0.1        1
      705 #4F32FF 11  8     1   108 10.5 11.5  7.5  8.5     NA       0.1        1
      706 #BBC7FF 12  8     1   118 11.5 12.5  7.5  8.5     NA       0.1        1
      707 #AFA6FF 12  8     1   118 11.5 12.5  7.5  8.5     NA       0.1        1
      708 #4B2FFF 12  8     1   118 11.5 12.5  7.5  8.5     NA       0.1        1
      709 #BBC7FF 13  8     1   128 12.5 13.5  7.5  8.5     NA       0.1        1
      710 #AFA6FF 13  8     1   128 12.5 13.5  7.5  8.5     NA       0.1        1
      711 #4B2EFF 13  8     1   128 12.5 13.5  7.5  8.5     NA       0.1        1
      712 #BBC7FF 14  8     1   138 13.5 14.5  7.5  8.5     NA       0.1        1
      713 #AFA5FF 14  8     1   138 13.5 14.5  7.5  8.5     NA       0.1        1
      714 #4B2EFF 14  8     1   138 13.5 14.5  7.5  8.5     NA       0.1        1
      715 #BBC7FF 15  8     1   148 14.5 15.5  7.5  8.5     NA       0.1        1
      716 #AFA5FF 15  8     1   148 14.5 15.5  7.5  8.5     NA       0.1        1
      717 #4B2EFF 15  8     1   148 14.5 15.5  7.5  8.5     NA       0.1        1
      718 #BBC7FF 16  8     1   158 15.5 16.5  7.5  8.5     NA       0.1        1
      719 #AFA5FF 16  8     1   158 15.5 16.5  7.5  8.5     NA       0.1        1
      720 #4A2EFF 16  8     1   158 15.5 16.5  7.5  8.5     NA       0.1        1
      721 #BBC6FF 17  8     1   168 16.5 17.5  7.5  8.5     NA       0.1        1
      722 #AEA3FF 17  8     1   168 16.5 17.5  7.5  8.5     NA       0.1        1
      723 #4E31FF 17  8     1   168 16.5 17.5  7.5  8.5     NA       0.1        1
      724 #BBC6FF 18  8     1   178 17.5 18.5  7.5  8.5     NA       0.1        1
      725 #ACA0FF 18  8     1   178 17.5 18.5  7.5  8.5     NA       0.1        1
      726 #4D30FF 18  8     1   178 17.5 18.5  7.5  8.5     NA       0.1        1
      727 #BBC6FF 19  8     1   188 18.5 19.5  7.5  8.5     NA       0.1        1
      728 #A89AFF 19  8     1   188 18.5 19.5  7.5  8.5     NA       0.1        1
      729 #492DFF 19  8     1   188 18.5 19.5  7.5  8.5     NA       0.1        1
      730 #BBC3FF 20  8     1   198 19.5 20.5  7.5  8.5     NA       0.1        1
      731 #A595FF 20  8     1   198 19.5 20.5  7.5  8.5     NA       0.1        1
      732 #482CFF 20  8     1   198 19.5 20.5  7.5  8.5     NA       0.1        1
      733 #BBC1FF 21  8     1   208 20.5 21.5  7.5  8.5     NA       0.1        1
      734 #A290FF 21  8     1   208 20.5 21.5  7.5  8.5     NA       0.1        1
      735 #4328FF 21  8     1   208 20.5 21.5  7.5  8.5     NA       0.1        1
      736 #BBC0FF 22  8     1   218 21.5 22.5  7.5  8.5     NA       0.1        1
      737 #9E8BFF 22  8     1   218 21.5 22.5  7.5  8.5     NA       0.1        1
      738 #3F25FF 22  8     1   218 21.5 22.5  7.5  8.5     NA       0.1        1
      739 #BBBCFF 23  8     1   228 22.5 23.5  7.5  8.5     NA       0.1        1
      740 #9B86FF 23  8     1   228 22.5 23.5  7.5  8.5     NA       0.1        1
      741 #311BFF 23  8     1   228 22.5 23.5  7.5  8.5     NA       0.1        1
      742 #BBBBFF 24  8     1   238 23.5 24.5  7.5  8.5     NA       0.1        1
      743 #9983FF 24  8     1   238 23.5 24.5  7.5  8.5     NA       0.1        1
      744 #2110FF 24  8     1   238 23.5 24.5  7.5  8.5     NA       0.1        1
      745 #B9B8FF 25  8     1   248 24.5 25.5  7.5  8.5     NA       0.1        1
      746 #9881FF 25  8     1   248 24.5 25.5  7.5  8.5     NA       0.1        1
      747 #1B0CFF 25  8     1   248 24.5 25.5  7.5  8.5     NA       0.1        1
      748 #B8B6FF 26  8     1   258 25.5 26.5  7.5  8.5     NA       0.1        1
      749 #9780FF 26  8     1   258 25.5 26.5  7.5  8.5     NA       0.1        1
      750 #1407FF 26  8     1   258 25.5 26.5  7.5  8.5     NA       0.1        1
      751 #B8B5FF 27  8     1   268 26.5 27.5  7.5  8.5     NA       0.1        1
      752 #967FFF 27  8     1   268 26.5 27.5  7.5  8.5     NA       0.1        1
      753 #0903FF 27  8     1   268 26.5 27.5  7.5  8.5     NA       0.1        1
      754 #B8B6FF 28  8     1   278 27.5 28.5  7.5  8.5     NA       0.1        1
      755 #967EFF 28  8     1   278 27.5 28.5  7.5  8.5     NA       0.1        1
      756 #1407FF 28  8     1   278 27.5 28.5  7.5  8.5     NA       0.1        1
      757 #BBBDFF 29  8     1   288 28.5 29.5  7.5  8.5     NA       0.1        1
      758 #957EFF 29  8     1   288 28.5 29.5  7.5  8.5     NA       0.1        1
      759 #0903FF 29  8     1   288 28.5 29.5  7.5  8.5     NA       0.1        1
      760 #BBBEFF 30  8     1   298 29.5 30.5  7.5  8.5     NA       0.1        1
      761 #957DFF 30  8     1   298 29.5 30.5  7.5  8.5     NA       0.1        1
      762 #0301FF 30  8     1   298 29.5 30.5  7.5  8.5     NA       0.1        1
      763 #BBBEFF 31  8     1   308 30.5 31.5  7.5  8.5     NA       0.1        1
      764 #957DFF 31  8     1   308 30.5 31.5  7.5  8.5     NA       0.1        1
      765 #0000FF 31  8     1   308 30.5 31.5  7.5  8.5     NA       0.1        1
      766 #BBBEFF 32  8     1   318 31.5 32.5  7.5  8.5     NA       0.1        1
      767 #957DFF 32  8     1   318 31.5 32.5  7.5  8.5     NA       0.1        1
      768 #0000FF 32  8     1   318 31.5 32.5  7.5  8.5     NA       0.1        1
      769 #FFC9BB  1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      770 #BBC5FF  1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      771 #BBC0FF  1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      772 #FFCABB  2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1
      773 #BBC1FF  2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1
      774 #AEA3FF  2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1
      775 #FFCABB  3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1
      776 #BBBEFF  3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1
      777 #937AFF  3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1
      778 #FFCABB  4  9     1    39  3.5  4.5  8.5  9.5     NA       0.1        1
      779 #BBBBFF  4  9     1    39  3.5  4.5  8.5  9.5     NA       0.1        1
      780 #7B5CFF  4  9     1    39  3.5  4.5  8.5  9.5     NA       0.1        1
      781 #FFCABB  5  9     1    49  4.5  5.5  8.5  9.5     NA       0.1        1
      782 #B9B8FF  5  9     1    49  4.5  5.5  8.5  9.5     NA       0.1        1
      783 #6D4DFF  5  9     1    49  4.5  5.5  8.5  9.5     NA       0.1        1
      784 #FFCABB  6  9     1    59  5.5  6.5  8.5  9.5     NA       0.1        1
      785 #B7B4FF  6  9     1    59  5.5  6.5  8.5  9.5     NA       0.1        1
      786 #6243FF  6  9     1    59  5.5  6.5  8.5  9.5     NA       0.1        1
      787 #FFC4BB  7  9     1    69  6.5  7.5  8.5  9.5     NA       0.1        1
      788 #B6B1FF  7  9     1    69  6.5  7.5  8.5  9.5     NA       0.1        1
      789 #5C3DFF  7  9     1    69  6.5  7.5  8.5  9.5     NA       0.1        1
      790 #FF6A51  8  9     1    79  7.5  8.5  8.5  9.5     NA       0.1        1
      791 #B5AFFF  8  9     1    79  7.5  8.5  8.5  9.5     NA       0.1        1
      792 #5638FF  8  9     1    79  7.5  8.5  8.5  9.5     NA       0.1        1
      793 #FF664D  9  9     1    89  8.5  9.5  8.5  9.5     NA       0.1        1
      794 #B4AEFF  9  9     1    89  8.5  9.5  8.5  9.5     NA       0.1        1
      795 #5537FF  9  9     1    89  8.5  9.5  8.5  9.5     NA       0.1        1
      796 #FF654C 10  9     1    99  9.5 10.5  8.5  9.5     NA       0.1        1
      797 #B2ABFF 10  9     1    99  9.5 10.5  8.5  9.5     NA       0.1        1
      798 #5436FF 10  9     1    99  9.5 10.5  8.5  9.5     NA       0.1        1
      799 #FF684F 11  9     1   109 10.5 11.5  8.5  9.5     NA       0.1        1
      800 #B1A8FF 11  9     1   109 10.5 11.5  8.5  9.5     NA       0.1        1
      801 #5436FF 11  9     1   109 10.5 11.5  8.5  9.5     NA       0.1        1
      802 #FFC8BB 12  9     1   119 11.5 12.5  8.5  9.5     NA       0.1        1
      803 #AFA6FF 12  9     1   119 11.5 12.5  8.5  9.5     NA       0.1        1
      804 #5033FF 12  9     1   119 11.5 12.5  8.5  9.5     NA       0.1        1
      805 #FFC8BB 13  9     1   129 12.5 13.5  8.5  9.5     NA       0.1        1
      806 #AFA6FF 13  9     1   129 12.5 13.5  8.5  9.5     NA       0.1        1
      807 #5033FF 13  9     1   129 12.5 13.5  8.5  9.5     NA       0.1        1
      808 #FFC8BB 14  9     1   139 13.5 14.5  8.5  9.5     NA       0.1        1
      809 #AFA5FF 14  9     1   139 13.5 14.5  8.5  9.5     NA       0.1        1
      810 #5032FF 14  9     1   139 13.5 14.5  8.5  9.5     NA       0.1        1
      811 #FFC8BB 15  9     1   149 14.5 15.5  8.5  9.5     NA       0.1        1
      812 #AFA5FF 15  9     1   149 14.5 15.5  8.5  9.5     NA       0.1        1
      813 #5032FF 15  9     1   149 14.5 15.5  8.5  9.5     NA       0.1        1
      814 #FFC9BB 16  9     1   159 15.5 16.5  8.5  9.5     NA       0.1        1
      815 #AFA5FF 16  9     1   159 15.5 16.5  8.5  9.5     NA       0.1        1
      816 #4F32FF 16  9     1   159 15.5 16.5  8.5  9.5     NA       0.1        1
      817 #FFC9BB 17  9     1   169 16.5 17.5  8.5  9.5     NA       0.1        1
      818 #AEA3FF 17  9     1   169 16.5 17.5  8.5  9.5     NA       0.1        1
      819 #5335FF 17  9     1   169 16.5 17.5  8.5  9.5     NA       0.1        1
      820 #BBCCFF 18  9     1   179 17.5 18.5  8.5  9.5     NA       0.1        1
      821 #ACA0FF 18  9     1   179 17.5 18.5  8.5  9.5     NA       0.1        1
      822 #5234FF 18  9     1   179 17.5 18.5  8.5  9.5     NA       0.1        1
      823 #BBCCFF 19  9     1   189 18.5 19.5  8.5  9.5     NA       0.1        1
      824 #A89AFF 19  9     1   189 18.5 19.5  8.5  9.5     NA       0.1        1
      825 #4E31FF 19  9     1   189 18.5 19.5  8.5  9.5     NA       0.1        1
      826 #BBC9FF 20  9     1   199 19.5 20.5  8.5  9.5     NA       0.1        1
      827 #A595FF 20  9     1   199 19.5 20.5  8.5  9.5     NA       0.1        1
      828 #4D30FF 20  9     1   199 19.5 20.5  8.5  9.5     NA       0.1        1
      829 #BBC7FF 21  9     1   209 20.5 21.5  8.5  9.5     NA       0.1        1
      830 #A290FF 21  9     1   209 20.5 21.5  8.5  9.5     NA       0.1        1
      831 #492DFF 21  9     1   209 20.5 21.5  8.5  9.5     NA       0.1        1
      832 #BBC6FF 22  9     1   219 21.5 22.5  8.5  9.5     NA       0.1        1
      833 #9E8BFF 22  9     1   219 21.5 22.5  8.5  9.5     NA       0.1        1
      834 #452AFF 22  9     1   219 21.5 22.5  8.5  9.5     NA       0.1        1
      835 #BBC0FF 23  9     1   229 22.5 23.5  8.5  9.5     NA       0.1        1
      836 #9B86FF 23  9     1   229 22.5 23.5  8.5  9.5     NA       0.1        1
      837 #381FFF 23  9     1   229 22.5 23.5  8.5  9.5     NA       0.1        1
      838 #BBC0FF 24  9     1   239 23.5 24.5  8.5  9.5     NA       0.1        1
      839 #9983FF 24  9     1   239 23.5 24.5  8.5  9.5     NA       0.1        1
      840 #2A16FF 24  9     1   239 23.5 24.5  8.5  9.5     NA       0.1        1
      841 #BBC0FF 25  9     1   249 24.5 25.5  8.5  9.5     NA       0.1        1
      842 #9881FF 25  9     1   249 24.5 25.5  8.5  9.5     NA       0.1        1
      843 #2512FF 25  9     1   249 24.5 25.5  8.5  9.5     NA       0.1        1
      844 #BBC0FF 26  9     1   259 25.5 26.5  8.5  9.5     NA       0.1        1
      845 #9780FF 26  9     1   259 25.5 26.5  8.5  9.5     NA       0.1        1
      846 #1F0FFF 26  9     1   259 25.5 26.5  8.5  9.5     NA       0.1        1
      847 #BBBFFF 27  9     1   269 26.5 27.5  8.5  9.5     NA       0.1        1
      848 #967FFF 27  9     1   269 26.5 27.5  8.5  9.5     NA       0.1        1
      849 #190AFF 27  9     1   269 26.5 27.5  8.5  9.5     NA       0.1        1
      850 #BBC0FF 28  9     1   279 27.5 28.5  8.5  9.5     NA       0.1        1
      851 #957EFF 28  9     1   279 27.5 28.5  8.5  9.5     NA       0.1        1
      852 #1F0EFF 28  9     1   279 27.5 28.5  8.5  9.5     NA       0.1        1
      853 #BBC4FF 29  9     1   289 28.5 29.5  8.5  9.5     NA       0.1        1
      854 #957EFF 29  9     1   289 28.5 29.5  8.5  9.5     NA       0.1        1
      855 #180AFF 29  9     1   289 28.5 29.5  8.5  9.5     NA       0.1        1
      856 #BBC4FF 30  9     1   299 29.5 30.5  8.5  9.5     NA       0.1        1
      857 #957DFF 30  9     1   299 29.5 30.5  8.5  9.5     NA       0.1        1
      858 #1508FF 30  9     1   299 29.5 30.5  8.5  9.5     NA       0.1        1
      859 #BBC5FF 31  9     1   309 30.5 31.5  8.5  9.5     NA       0.1        1
      860 #957DFF 31  9     1   309 30.5 31.5  8.5  9.5     NA       0.1        1
      861 #1307FF 31  9     1   309 30.5 31.5  8.5  9.5     NA       0.1        1
      862 #BBC5FF 32  9     1   319 31.5 32.5  8.5  9.5     NA       0.1        1
      863 #957DFF 32  9     1   319 31.5 32.5  8.5  9.5     NA       0.1        1
      864 #1307FF 32  9     1   319 31.5 32.5  8.5  9.5     NA       0.1        1
      865 #FFC3BB  1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      866 #BBC5FF  1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      867 #BBBFFF  1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      868 #FFC4BB  2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1
      869 #BBC1FF  2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1
      870 #ADA3FF  2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1
      871 #FFC4BB  3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1
      872 #BBBEFF  3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1
      873 #937AFF  3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1
      874 #FFC4BB  4 10     1    40  3.5  4.5  9.5 10.5     NA       0.1        1
      875 #BBBBFF  4 10     1    40  3.5  4.5  9.5 10.5     NA       0.1        1
      876 #7B5CFF  4 10     1    40  3.5  4.5  9.5 10.5     NA       0.1        1
      877 #FFC4BB  5 10     1    50  4.5  5.5  9.5 10.5     NA       0.1        1
      878 #B9B8FF  5 10     1    50  4.5  5.5  9.5 10.5     NA       0.1        1
      879 #6C4DFF  5 10     1    50  4.5  5.5  9.5 10.5     NA       0.1        1
      880 #FFC4BB  6 10     1    60  5.5  6.5  9.5 10.5     NA       0.1        1
      881 #B7B4FF  6 10     1    60  5.5  6.5  9.5 10.5     NA       0.1        1
      882 #6242FF  6 10     1    60  5.5  6.5  9.5 10.5     NA       0.1        1
      883 #FFBFBB  7 10     1    70  6.5  7.5  9.5 10.5     NA       0.1        1
      884 #B6B1FF  7 10     1    70  6.5  7.5  9.5 10.5     NA       0.1        1
      885 #5C3DFF  7 10     1    70  6.5  7.5  9.5 10.5     NA       0.1        1
      886 #FF4E34  8 10     1    80  7.5  8.5  9.5 10.5     NA       0.1        1
      887 #B5AFFF  8 10     1    80  7.5  8.5  9.5 10.5     NA       0.1        1
      888 #5537FF  8 10     1    80  7.5  8.5  9.5 10.5     NA       0.1        1
      889 #FF492F  9 10     1    90  8.5  9.5  9.5 10.5     NA       0.1        1
      890 #B4AEFF  9 10     1    90  8.5  9.5  9.5 10.5     NA       0.1        1
      891 #5537FF  9 10     1    90  8.5  9.5  9.5 10.5     NA       0.1        1
      892 #FF482F 10 10     1   100  9.5 10.5  9.5 10.5     NA       0.1        1
      893 #B2ABFF 10 10     1   100  9.5 10.5  9.5 10.5     NA       0.1        1
      894 #5436FF 10 10     1   100  9.5 10.5  9.5 10.5     NA       0.1        1
      895 #FF4C32 11 10     1   110 10.5 11.5  9.5 10.5     NA       0.1        1
      896 #B1A8FF 11 10     1   110 10.5 11.5  9.5 10.5     NA       0.1        1
      897 #5436FF 11 10     1   110 10.5 11.5  9.5 10.5     NA       0.1        1
      898 #FFC6BB 12 10     1   120 11.5 12.5  9.5 10.5     NA       0.1        1
      899 #AFA6FF 12 10     1   120 11.5 12.5  9.5 10.5     NA       0.1        1
      900 #5033FF 12 10     1   120 11.5 12.5  9.5 10.5     NA       0.1        1
      901 #FFC6BB 13 10     1   130 12.5 13.5  9.5 10.5     NA       0.1        1
      902 #AFA6FF 13 10     1   130 12.5 13.5  9.5 10.5     NA       0.1        1
      903 #5032FF 13 10     1   130 12.5 13.5  9.5 10.5     NA       0.1        1
      904 #FFC6BB 14 10     1   140 13.5 14.5  9.5 10.5     NA       0.1        1
      905 #AFA5FF 14 10     1   140 13.5 14.5  9.5 10.5     NA       0.1        1
      906 #5032FF 14 10     1   140 13.5 14.5  9.5 10.5     NA       0.1        1
      907 #FFC7BB 15 10     1   150 14.5 15.5  9.5 10.5     NA       0.1        1
      908 #AFA5FF 15 10     1   150 14.5 15.5  9.5 10.5     NA       0.1        1
      909 #4F32FF 15 10     1   150 14.5 15.5  9.5 10.5     NA       0.1        1
      910 #FFC7BB 16 10     1   160 15.5 16.5  9.5 10.5     NA       0.1        1
      911 #AFA5FF 16 10     1   160 15.5 16.5  9.5 10.5     NA       0.1        1
      912 #4F32FF 16 10     1   160 15.5 16.5  9.5 10.5     NA       0.1        1
      913 #FFC8BB 17 10     1   170 16.5 17.5  9.5 10.5     NA       0.1        1
      914 #AEA3FF 17 10     1   170 16.5 17.5  9.5 10.5     NA       0.1        1
      915 #5335FF 17 10     1   170 16.5 17.5  9.5 10.5     NA       0.1        1
      916 #BBCCFF 18 10     1   180 17.5 18.5  9.5 10.5     NA       0.1        1
      917 #AB9FFF 18 10     1   180 17.5 18.5  9.5 10.5     NA       0.1        1
      918 #5234FF 18 10     1   180 17.5 18.5  9.5 10.5     NA       0.1        1
      919 #BBCCFF 19 10     1   190 18.5 19.5  9.5 10.5     NA       0.1        1
      920 #A89AFF 19 10     1   190 18.5 19.5  9.5 10.5     NA       0.1        1
      921 #4E31FF 19 10     1   190 18.5 19.5  9.5 10.5     NA       0.1        1
      922 #BBC9FF 20 10     1   200 19.5 20.5  9.5 10.5     NA       0.1        1
      923 #A595FF 20 10     1   200 19.5 20.5  9.5 10.5     NA       0.1        1
      924 #4D30FF 20 10     1   200 19.5 20.5  9.5 10.5     NA       0.1        1
      925 #BBC7FF 21 10     1   210 20.5 21.5  9.5 10.5     NA       0.1        1
      926 #A290FF 21 10     1   210 20.5 21.5  9.5 10.5     NA       0.1        1
      927 #492DFF 21 10     1   210 20.5 21.5  9.5 10.5     NA       0.1        1
      928 #BBC6FF 22 10     1   220 21.5 22.5  9.5 10.5     NA       0.1        1
      929 #9E8BFF 22 10     1   220 21.5 22.5  9.5 10.5     NA       0.1        1
      930 #452AFF 22 10     1   220 21.5 22.5  9.5 10.5     NA       0.1        1
      931 #BBC0FF 23 10     1   230 22.5 23.5  9.5 10.5     NA       0.1        1
      932 #9B86FF 23 10     1   230 22.5 23.5  9.5 10.5     NA       0.1        1
      933 #381FFF 23 10     1   230 22.5 23.5  9.5 10.5     NA       0.1        1
      934 #BBC0FF 24 10     1   240 23.5 24.5  9.5 10.5     NA       0.1        1
      935 #9983FF 24 10     1   240 23.5 24.5  9.5 10.5     NA       0.1        1
      936 #2A16FF 24 10     1   240 23.5 24.5  9.5 10.5     NA       0.1        1
      937 #BBC0FF 25 10     1   250 24.5 25.5  9.5 10.5     NA       0.1        1
      938 #9881FF 25 10     1   250 24.5 25.5  9.5 10.5     NA       0.1        1
      939 #2512FF 25 10     1   250 24.5 25.5  9.5 10.5     NA       0.1        1
      940 #BBC0FF 26 10     1   260 25.5 26.5  9.5 10.5     NA       0.1        1
      941 #9780FF 26 10     1   260 25.5 26.5  9.5 10.5     NA       0.1        1
      942 #1F0FFF 26 10     1   260 25.5 26.5  9.5 10.5     NA       0.1        1
      943 #BBBFFF 27 10     1   270 26.5 27.5  9.5 10.5     NA       0.1        1
      944 #967FFF 27 10     1   270 26.5 27.5  9.5 10.5     NA       0.1        1
      945 #190AFF 27 10     1   270 26.5 27.5  9.5 10.5     NA       0.1        1
      946 #BBC0FF 28 10     1   280 27.5 28.5  9.5 10.5     NA       0.1        1
      947 #957EFF 28 10     1   280 27.5 28.5  9.5 10.5     NA       0.1        1
      948 #1F0EFF 28 10     1   280 27.5 28.5  9.5 10.5     NA       0.1        1
      949 #BBC4FF 29 10     1   290 28.5 29.5  9.5 10.5     NA       0.1        1
      950 #957DFF 29 10     1   290 28.5 29.5  9.5 10.5     NA       0.1        1
      951 #180AFF 29 10     1   290 28.5 29.5  9.5 10.5     NA       0.1        1
      952 #BBC4FF 30 10     1   300 29.5 30.5  9.5 10.5     NA       0.1        1
      953 #957DFF 30 10     1   300 29.5 30.5  9.5 10.5     NA       0.1        1
      954 #1508FF 30 10     1   300 29.5 30.5  9.5 10.5     NA       0.1        1
      955 #BBC5FF 31 10     1   310 30.5 31.5  9.5 10.5     NA       0.1        1
      956 #957DFF 31 10     1   310 30.5 31.5  9.5 10.5     NA       0.1        1
      957 #1307FF 31 10     1   310 30.5 31.5  9.5 10.5     NA       0.1        1
      958 #BBC5FF 32 10     1   320 31.5 32.5  9.5 10.5     NA       0.1        1
      959 #957DFF 32 10     1   320 31.5 32.5  9.5 10.5     NA       0.1        1
      960 #1307FF 32 10     1   320 31.5 32.5  9.5 10.5     NA       0.1        1
          alpha width height
      1      NA    NA     NA
      2      NA    NA     NA
      3      NA    NA     NA
      4      NA    NA     NA
      5      NA    NA     NA
      6      NA    NA     NA
      7      NA    NA     NA
      8      NA    NA     NA
      9      NA    NA     NA
      10     NA    NA     NA
      11     NA    NA     NA
      12     NA    NA     NA
      13     NA    NA     NA
      14     NA    NA     NA
      15     NA    NA     NA
      16     NA    NA     NA
      17     NA    NA     NA
      18     NA    NA     NA
      19     NA    NA     NA
      20     NA    NA     NA
      21     NA    NA     NA
      22     NA    NA     NA
      23     NA    NA     NA
      24     NA    NA     NA
      25     NA    NA     NA
      26     NA    NA     NA
      27     NA    NA     NA
      28     NA    NA     NA
      29     NA    NA     NA
      30     NA    NA     NA
      31     NA    NA     NA
      32     NA    NA     NA
      33     NA    NA     NA
      34     NA    NA     NA
      35     NA    NA     NA
      36     NA    NA     NA
      37     NA    NA     NA
      38     NA    NA     NA
      39     NA    NA     NA
      40     NA    NA     NA
      41     NA    NA     NA
      42     NA    NA     NA
      43     NA    NA     NA
      44     NA    NA     NA
      45     NA    NA     NA
      46     NA    NA     NA
      47     NA    NA     NA
      48     NA    NA     NA
      49     NA    NA     NA
      50     NA    NA     NA
      51     NA    NA     NA
      52     NA    NA     NA
      53     NA    NA     NA
      54     NA    NA     NA
      55     NA    NA     NA
      56     NA    NA     NA
      57     NA    NA     NA
      58     NA    NA     NA
      59     NA    NA     NA
      60     NA    NA     NA
      61     NA    NA     NA
      62     NA    NA     NA
      63     NA    NA     NA
      64     NA    NA     NA
      65     NA    NA     NA
      66     NA    NA     NA
      67     NA    NA     NA
      68     NA    NA     NA
      69     NA    NA     NA
      70     NA    NA     NA
      71     NA    NA     NA
      72     NA    NA     NA
      73     NA    NA     NA
      74     NA    NA     NA
      75     NA    NA     NA
      76     NA    NA     NA
      77     NA    NA     NA
      78     NA    NA     NA
      79     NA    NA     NA
      80     NA    NA     NA
      81     NA    NA     NA
      82     NA    NA     NA
      83     NA    NA     NA
      84     NA    NA     NA
      85     NA    NA     NA
      86     NA    NA     NA
      87     NA    NA     NA
      88     NA    NA     NA
      89     NA    NA     NA
      90     NA    NA     NA
      91     NA    NA     NA
      92     NA    NA     NA
      93     NA    NA     NA
      94     NA    NA     NA
      95     NA    NA     NA
      96     NA    NA     NA
      97     NA    NA     NA
      98     NA    NA     NA
      99     NA    NA     NA
      100    NA    NA     NA
      101    NA    NA     NA
      102    NA    NA     NA
      103    NA    NA     NA
      104    NA    NA     NA
      105    NA    NA     NA
      106    NA    NA     NA
      107    NA    NA     NA
      108    NA    NA     NA
      109    NA    NA     NA
      110    NA    NA     NA
      111    NA    NA     NA
      112    NA    NA     NA
      113    NA    NA     NA
      114    NA    NA     NA
      115    NA    NA     NA
      116    NA    NA     NA
      117    NA    NA     NA
      118    NA    NA     NA
      119    NA    NA     NA
      120    NA    NA     NA
      121    NA    NA     NA
      122    NA    NA     NA
      123    NA    NA     NA
      124    NA    NA     NA
      125    NA    NA     NA
      126    NA    NA     NA
      127    NA    NA     NA
      128    NA    NA     NA
      129    NA    NA     NA
      130    NA    NA     NA
      131    NA    NA     NA
      132    NA    NA     NA
      133    NA    NA     NA
      134    NA    NA     NA
      135    NA    NA     NA
      136    NA    NA     NA
      137    NA    NA     NA
      138    NA    NA     NA
      139    NA    NA     NA
      140    NA    NA     NA
      141    NA    NA     NA
      142    NA    NA     NA
      143    NA    NA     NA
      144    NA    NA     NA
      145    NA    NA     NA
      146    NA    NA     NA
      147    NA    NA     NA
      148    NA    NA     NA
      149    NA    NA     NA
      150    NA    NA     NA
      151    NA    NA     NA
      152    NA    NA     NA
      153    NA    NA     NA
      154    NA    NA     NA
      155    NA    NA     NA
      156    NA    NA     NA
      157    NA    NA     NA
      158    NA    NA     NA
      159    NA    NA     NA
      160    NA    NA     NA
      161    NA    NA     NA
      162    NA    NA     NA
      163    NA    NA     NA
      164    NA    NA     NA
      165    NA    NA     NA
      166    NA    NA     NA
      167    NA    NA     NA
      168    NA    NA     NA
      169    NA    NA     NA
      170    NA    NA     NA
      171    NA    NA     NA
      172    NA    NA     NA
      173    NA    NA     NA
      174    NA    NA     NA
      175    NA    NA     NA
      176    NA    NA     NA
      177    NA    NA     NA
      178    NA    NA     NA
      179    NA    NA     NA
      180    NA    NA     NA
      181    NA    NA     NA
      182    NA    NA     NA
      183    NA    NA     NA
      184    NA    NA     NA
      185    NA    NA     NA
      186    NA    NA     NA
      187    NA    NA     NA
      188    NA    NA     NA
      189    NA    NA     NA
      190    NA    NA     NA
      191    NA    NA     NA
      192    NA    NA     NA
      193    NA    NA     NA
      194    NA    NA     NA
      195    NA    NA     NA
      196    NA    NA     NA
      197    NA    NA     NA
      198    NA    NA     NA
      199    NA    NA     NA
      200    NA    NA     NA
      201    NA    NA     NA
      202    NA    NA     NA
      203    NA    NA     NA
      204    NA    NA     NA
      205    NA    NA     NA
      206    NA    NA     NA
      207    NA    NA     NA
      208    NA    NA     NA
      209    NA    NA     NA
      210    NA    NA     NA
      211    NA    NA     NA
      212    NA    NA     NA
      213    NA    NA     NA
      214    NA    NA     NA
      215    NA    NA     NA
      216    NA    NA     NA
      217    NA    NA     NA
      218    NA    NA     NA
      219    NA    NA     NA
      220    NA    NA     NA
      221    NA    NA     NA
      222    NA    NA     NA
      223    NA    NA     NA
      224    NA    NA     NA
      225    NA    NA     NA
      226    NA    NA     NA
      227    NA    NA     NA
      228    NA    NA     NA
      229    NA    NA     NA
      230    NA    NA     NA
      231    NA    NA     NA
      232    NA    NA     NA
      233    NA    NA     NA
      234    NA    NA     NA
      235    NA    NA     NA
      236    NA    NA     NA
      237    NA    NA     NA
      238    NA    NA     NA
      239    NA    NA     NA
      240    NA    NA     NA
      241    NA    NA     NA
      242    NA    NA     NA
      243    NA    NA     NA
      244    NA    NA     NA
      245    NA    NA     NA
      246    NA    NA     NA
      247    NA    NA     NA
      248    NA    NA     NA
      249    NA    NA     NA
      250    NA    NA     NA
      251    NA    NA     NA
      252    NA    NA     NA
      253    NA    NA     NA
      254    NA    NA     NA
      255    NA    NA     NA
      256    NA    NA     NA
      257    NA    NA     NA
      258    NA    NA     NA
      259    NA    NA     NA
      260    NA    NA     NA
      261    NA    NA     NA
      262    NA    NA     NA
      263    NA    NA     NA
      264    NA    NA     NA
      265    NA    NA     NA
      266    NA    NA     NA
      267    NA    NA     NA
      268    NA    NA     NA
      269    NA    NA     NA
      270    NA    NA     NA
      271    NA    NA     NA
      272    NA    NA     NA
      273    NA    NA     NA
      274    NA    NA     NA
      275    NA    NA     NA
      276    NA    NA     NA
      277    NA    NA     NA
      278    NA    NA     NA
      279    NA    NA     NA
      280    NA    NA     NA
      281    NA    NA     NA
      282    NA    NA     NA
      283    NA    NA     NA
      284    NA    NA     NA
      285    NA    NA     NA
      286    NA    NA     NA
      287    NA    NA     NA
      288    NA    NA     NA
      289    NA    NA     NA
      290    NA    NA     NA
      291    NA    NA     NA
      292    NA    NA     NA
      293    NA    NA     NA
      294    NA    NA     NA
      295    NA    NA     NA
      296    NA    NA     NA
      297    NA    NA     NA
      298    NA    NA     NA
      299    NA    NA     NA
      300    NA    NA     NA
      301    NA    NA     NA
      302    NA    NA     NA
      303    NA    NA     NA
      304    NA    NA     NA
      305    NA    NA     NA
      306    NA    NA     NA
      307    NA    NA     NA
      308    NA    NA     NA
      309    NA    NA     NA
      310    NA    NA     NA
      311    NA    NA     NA
      312    NA    NA     NA
      313    NA    NA     NA
      314    NA    NA     NA
      315    NA    NA     NA
      316    NA    NA     NA
      317    NA    NA     NA
      318    NA    NA     NA
      319    NA    NA     NA
      320    NA    NA     NA
      321    NA    NA     NA
      322    NA    NA     NA
      323    NA    NA     NA
      324    NA    NA     NA
      325    NA    NA     NA
      326    NA    NA     NA
      327    NA    NA     NA
      328    NA    NA     NA
      329    NA    NA     NA
      330    NA    NA     NA
      331    NA    NA     NA
      332    NA    NA     NA
      333    NA    NA     NA
      334    NA    NA     NA
      335    NA    NA     NA
      336    NA    NA     NA
      337    NA    NA     NA
      338    NA    NA     NA
      339    NA    NA     NA
      340    NA    NA     NA
      341    NA    NA     NA
      342    NA    NA     NA
      343    NA    NA     NA
      344    NA    NA     NA
      345    NA    NA     NA
      346    NA    NA     NA
      347    NA    NA     NA
      348    NA    NA     NA
      349    NA    NA     NA
      350    NA    NA     NA
      351    NA    NA     NA
      352    NA    NA     NA
      353    NA    NA     NA
      354    NA    NA     NA
      355    NA    NA     NA
      356    NA    NA     NA
      357    NA    NA     NA
      358    NA    NA     NA
      359    NA    NA     NA
      360    NA    NA     NA
      361    NA    NA     NA
      362    NA    NA     NA
      363    NA    NA     NA
      364    NA    NA     NA
      365    NA    NA     NA
      366    NA    NA     NA
      367    NA    NA     NA
      368    NA    NA     NA
      369    NA    NA     NA
      370    NA    NA     NA
      371    NA    NA     NA
      372    NA    NA     NA
      373    NA    NA     NA
      374    NA    NA     NA
      375    NA    NA     NA
      376    NA    NA     NA
      377    NA    NA     NA
      378    NA    NA     NA
      379    NA    NA     NA
      380    NA    NA     NA
      381    NA    NA     NA
      382    NA    NA     NA
      383    NA    NA     NA
      384    NA    NA     NA
      385    NA    NA     NA
      386    NA    NA     NA
      387    NA    NA     NA
      388    NA    NA     NA
      389    NA    NA     NA
      390    NA    NA     NA
      391    NA    NA     NA
      392    NA    NA     NA
      393    NA    NA     NA
      394    NA    NA     NA
      395    NA    NA     NA
      396    NA    NA     NA
      397    NA    NA     NA
      398    NA    NA     NA
      399    NA    NA     NA
      400    NA    NA     NA
      401    NA    NA     NA
      402    NA    NA     NA
      403    NA    NA     NA
      404    NA    NA     NA
      405    NA    NA     NA
      406    NA    NA     NA
      407    NA    NA     NA
      408    NA    NA     NA
      409    NA    NA     NA
      410    NA    NA     NA
      411    NA    NA     NA
      412    NA    NA     NA
      413    NA    NA     NA
      414    NA    NA     NA
      415    NA    NA     NA
      416    NA    NA     NA
      417    NA    NA     NA
      418    NA    NA     NA
      419    NA    NA     NA
      420    NA    NA     NA
      421    NA    NA     NA
      422    NA    NA     NA
      423    NA    NA     NA
      424    NA    NA     NA
      425    NA    NA     NA
      426    NA    NA     NA
      427    NA    NA     NA
      428    NA    NA     NA
      429    NA    NA     NA
      430    NA    NA     NA
      431    NA    NA     NA
      432    NA    NA     NA
      433    NA    NA     NA
      434    NA    NA     NA
      435    NA    NA     NA
      436    NA    NA     NA
      437    NA    NA     NA
      438    NA    NA     NA
      439    NA    NA     NA
      440    NA    NA     NA
      441    NA    NA     NA
      442    NA    NA     NA
      443    NA    NA     NA
      444    NA    NA     NA
      445    NA    NA     NA
      446    NA    NA     NA
      447    NA    NA     NA
      448    NA    NA     NA
      449    NA    NA     NA
      450    NA    NA     NA
      451    NA    NA     NA
      452    NA    NA     NA
      453    NA    NA     NA
      454    NA    NA     NA
      455    NA    NA     NA
      456    NA    NA     NA
      457    NA    NA     NA
      458    NA    NA     NA
      459    NA    NA     NA
      460    NA    NA     NA
      461    NA    NA     NA
      462    NA    NA     NA
      463    NA    NA     NA
      464    NA    NA     NA
      465    NA    NA     NA
      466    NA    NA     NA
      467    NA    NA     NA
      468    NA    NA     NA
      469    NA    NA     NA
      470    NA    NA     NA
      471    NA    NA     NA
      472    NA    NA     NA
      473    NA    NA     NA
      474    NA    NA     NA
      475    NA    NA     NA
      476    NA    NA     NA
      477    NA    NA     NA
      478    NA    NA     NA
      479    NA    NA     NA
      480    NA    NA     NA
      481    NA    NA     NA
      482    NA    NA     NA
      483    NA    NA     NA
      484    NA    NA     NA
      485    NA    NA     NA
      486    NA    NA     NA
      487    NA    NA     NA
      488    NA    NA     NA
      489    NA    NA     NA
      490    NA    NA     NA
      491    NA    NA     NA
      492    NA    NA     NA
      493    NA    NA     NA
      494    NA    NA     NA
      495    NA    NA     NA
      496    NA    NA     NA
      497    NA    NA     NA
      498    NA    NA     NA
      499    NA    NA     NA
      500    NA    NA     NA
      501    NA    NA     NA
      502    NA    NA     NA
      503    NA    NA     NA
      504    NA    NA     NA
      505    NA    NA     NA
      506    NA    NA     NA
      507    NA    NA     NA
      508    NA    NA     NA
      509    NA    NA     NA
      510    NA    NA     NA
      511    NA    NA     NA
      512    NA    NA     NA
      513    NA    NA     NA
      514    NA    NA     NA
      515    NA    NA     NA
      516    NA    NA     NA
      517    NA    NA     NA
      518    NA    NA     NA
      519    NA    NA     NA
      520    NA    NA     NA
      521    NA    NA     NA
      522    NA    NA     NA
      523    NA    NA     NA
      524    NA    NA     NA
      525    NA    NA     NA
      526    NA    NA     NA
      527    NA    NA     NA
      528    NA    NA     NA
      529    NA    NA     NA
      530    NA    NA     NA
      531    NA    NA     NA
      532    NA    NA     NA
      533    NA    NA     NA
      534    NA    NA     NA
      535    NA    NA     NA
      536    NA    NA     NA
      537    NA    NA     NA
      538    NA    NA     NA
      539    NA    NA     NA
      540    NA    NA     NA
      541    NA    NA     NA
      542    NA    NA     NA
      543    NA    NA     NA
      544    NA    NA     NA
      545    NA    NA     NA
      546    NA    NA     NA
      547    NA    NA     NA
      548    NA    NA     NA
      549    NA    NA     NA
      550    NA    NA     NA
      551    NA    NA     NA
      552    NA    NA     NA
      553    NA    NA     NA
      554    NA    NA     NA
      555    NA    NA     NA
      556    NA    NA     NA
      557    NA    NA     NA
      558    NA    NA     NA
      559    NA    NA     NA
      560    NA    NA     NA
      561    NA    NA     NA
      562    NA    NA     NA
      563    NA    NA     NA
      564    NA    NA     NA
      565    NA    NA     NA
      566    NA    NA     NA
      567    NA    NA     NA
      568    NA    NA     NA
      569    NA    NA     NA
      570    NA    NA     NA
      571    NA    NA     NA
      572    NA    NA     NA
      573    NA    NA     NA
      574    NA    NA     NA
      575    NA    NA     NA
      576    NA    NA     NA
      577    NA    NA     NA
      578    NA    NA     NA
      579    NA    NA     NA
      580    NA    NA     NA
      581    NA    NA     NA
      582    NA    NA     NA
      583    NA    NA     NA
      584    NA    NA     NA
      585    NA    NA     NA
      586    NA    NA     NA
      587    NA    NA     NA
      588    NA    NA     NA
      589    NA    NA     NA
      590    NA    NA     NA
      591    NA    NA     NA
      592    NA    NA     NA
      593    NA    NA     NA
      594    NA    NA     NA
      595    NA    NA     NA
      596    NA    NA     NA
      597    NA    NA     NA
      598    NA    NA     NA
      599    NA    NA     NA
      600    NA    NA     NA
      601    NA    NA     NA
      602    NA    NA     NA
      603    NA    NA     NA
      604    NA    NA     NA
      605    NA    NA     NA
      606    NA    NA     NA
      607    NA    NA     NA
      608    NA    NA     NA
      609    NA    NA     NA
      610    NA    NA     NA
      611    NA    NA     NA
      612    NA    NA     NA
      613    NA    NA     NA
      614    NA    NA     NA
      615    NA    NA     NA
      616    NA    NA     NA
      617    NA    NA     NA
      618    NA    NA     NA
      619    NA    NA     NA
      620    NA    NA     NA
      621    NA    NA     NA
      622    NA    NA     NA
      623    NA    NA     NA
      624    NA    NA     NA
      625    NA    NA     NA
      626    NA    NA     NA
      627    NA    NA     NA
      628    NA    NA     NA
      629    NA    NA     NA
      630    NA    NA     NA
      631    NA    NA     NA
      632    NA    NA     NA
      633    NA    NA     NA
      634    NA    NA     NA
      635    NA    NA     NA
      636    NA    NA     NA
      637    NA    NA     NA
      638    NA    NA     NA
      639    NA    NA     NA
      640    NA    NA     NA
      641    NA    NA     NA
      642    NA    NA     NA
      643    NA    NA     NA
      644    NA    NA     NA
      645    NA    NA     NA
      646    NA    NA     NA
      647    NA    NA     NA
      648    NA    NA     NA
      649    NA    NA     NA
      650    NA    NA     NA
      651    NA    NA     NA
      652    NA    NA     NA
      653    NA    NA     NA
      654    NA    NA     NA
      655    NA    NA     NA
      656    NA    NA     NA
      657    NA    NA     NA
      658    NA    NA     NA
      659    NA    NA     NA
      660    NA    NA     NA
      661    NA    NA     NA
      662    NA    NA     NA
      663    NA    NA     NA
      664    NA    NA     NA
      665    NA    NA     NA
      666    NA    NA     NA
      667    NA    NA     NA
      668    NA    NA     NA
      669    NA    NA     NA
      670    NA    NA     NA
      671    NA    NA     NA
      672    NA    NA     NA
      673    NA    NA     NA
      674    NA    NA     NA
      675    NA    NA     NA
      676    NA    NA     NA
      677    NA    NA     NA
      678    NA    NA     NA
      679    NA    NA     NA
      680    NA    NA     NA
      681    NA    NA     NA
      682    NA    NA     NA
      683    NA    NA     NA
      684    NA    NA     NA
      685    NA    NA     NA
      686    NA    NA     NA
      687    NA    NA     NA
      688    NA    NA     NA
      689    NA    NA     NA
      690    NA    NA     NA
      691    NA    NA     NA
      692    NA    NA     NA
      693    NA    NA     NA
      694    NA    NA     NA
      695    NA    NA     NA
      696    NA    NA     NA
      697    NA    NA     NA
      698    NA    NA     NA
      699    NA    NA     NA
      700    NA    NA     NA
      701    NA    NA     NA
      702    NA    NA     NA
      703    NA    NA     NA
      704    NA    NA     NA
      705    NA    NA     NA
      706    NA    NA     NA
      707    NA    NA     NA
      708    NA    NA     NA
      709    NA    NA     NA
      710    NA    NA     NA
      711    NA    NA     NA
      712    NA    NA     NA
      713    NA    NA     NA
      714    NA    NA     NA
      715    NA    NA     NA
      716    NA    NA     NA
      717    NA    NA     NA
      718    NA    NA     NA
      719    NA    NA     NA
      720    NA    NA     NA
      721    NA    NA     NA
      722    NA    NA     NA
      723    NA    NA     NA
      724    NA    NA     NA
      725    NA    NA     NA
      726    NA    NA     NA
      727    NA    NA     NA
      728    NA    NA     NA
      729    NA    NA     NA
      730    NA    NA     NA
      731    NA    NA     NA
      732    NA    NA     NA
      733    NA    NA     NA
      734    NA    NA     NA
      735    NA    NA     NA
      736    NA    NA     NA
      737    NA    NA     NA
      738    NA    NA     NA
      739    NA    NA     NA
      740    NA    NA     NA
      741    NA    NA     NA
      742    NA    NA     NA
      743    NA    NA     NA
      744    NA    NA     NA
      745    NA    NA     NA
      746    NA    NA     NA
      747    NA    NA     NA
      748    NA    NA     NA
      749    NA    NA     NA
      750    NA    NA     NA
      751    NA    NA     NA
      752    NA    NA     NA
      753    NA    NA     NA
      754    NA    NA     NA
      755    NA    NA     NA
      756    NA    NA     NA
      757    NA    NA     NA
      758    NA    NA     NA
      759    NA    NA     NA
      760    NA    NA     NA
      761    NA    NA     NA
      762    NA    NA     NA
      763    NA    NA     NA
      764    NA    NA     NA
      765    NA    NA     NA
      766    NA    NA     NA
      767    NA    NA     NA
      768    NA    NA     NA
      769    NA    NA     NA
      770    NA    NA     NA
      771    NA    NA     NA
      772    NA    NA     NA
      773    NA    NA     NA
      774    NA    NA     NA
      775    NA    NA     NA
      776    NA    NA     NA
      777    NA    NA     NA
      778    NA    NA     NA
      779    NA    NA     NA
      780    NA    NA     NA
      781    NA    NA     NA
      782    NA    NA     NA
      783    NA    NA     NA
      784    NA    NA     NA
      785    NA    NA     NA
      786    NA    NA     NA
      787    NA    NA     NA
      788    NA    NA     NA
      789    NA    NA     NA
      790    NA    NA     NA
      791    NA    NA     NA
      792    NA    NA     NA
      793    NA    NA     NA
      794    NA    NA     NA
      795    NA    NA     NA
      796    NA    NA     NA
      797    NA    NA     NA
      798    NA    NA     NA
      799    NA    NA     NA
      800    NA    NA     NA
      801    NA    NA     NA
      802    NA    NA     NA
      803    NA    NA     NA
      804    NA    NA     NA
      805    NA    NA     NA
      806    NA    NA     NA
      807    NA    NA     NA
      808    NA    NA     NA
      809    NA    NA     NA
      810    NA    NA     NA
      811    NA    NA     NA
      812    NA    NA     NA
      813    NA    NA     NA
      814    NA    NA     NA
      815    NA    NA     NA
      816    NA    NA     NA
      817    NA    NA     NA
      818    NA    NA     NA
      819    NA    NA     NA
      820    NA    NA     NA
      821    NA    NA     NA
      822    NA    NA     NA
      823    NA    NA     NA
      824    NA    NA     NA
      825    NA    NA     NA
      826    NA    NA     NA
      827    NA    NA     NA
      828    NA    NA     NA
      829    NA    NA     NA
      830    NA    NA     NA
      831    NA    NA     NA
      832    NA    NA     NA
      833    NA    NA     NA
      834    NA    NA     NA
      835    NA    NA     NA
      836    NA    NA     NA
      837    NA    NA     NA
      838    NA    NA     NA
      839    NA    NA     NA
      840    NA    NA     NA
      841    NA    NA     NA
      842    NA    NA     NA
      843    NA    NA     NA
      844    NA    NA     NA
      845    NA    NA     NA
      846    NA    NA     NA
      847    NA    NA     NA
      848    NA    NA     NA
      849    NA    NA     NA
      850    NA    NA     NA
      851    NA    NA     NA
      852    NA    NA     NA
      853    NA    NA     NA
      854    NA    NA     NA
      855    NA    NA     NA
      856    NA    NA     NA
      857    NA    NA     NA
      858    NA    NA     NA
      859    NA    NA     NA
      860    NA    NA     NA
      861    NA    NA     NA
      862    NA    NA     NA
      863    NA    NA     NA
      864    NA    NA     NA
      865    NA    NA     NA
      866    NA    NA     NA
      867    NA    NA     NA
      868    NA    NA     NA
      869    NA    NA     NA
      870    NA    NA     NA
      871    NA    NA     NA
      872    NA    NA     NA
      873    NA    NA     NA
      874    NA    NA     NA
      875    NA    NA     NA
      876    NA    NA     NA
      877    NA    NA     NA
      878    NA    NA     NA
      879    NA    NA     NA
      880    NA    NA     NA
      881    NA    NA     NA
      882    NA    NA     NA
      883    NA    NA     NA
      884    NA    NA     NA
      885    NA    NA     NA
      886    NA    NA     NA
      887    NA    NA     NA
      888    NA    NA     NA
      889    NA    NA     NA
      890    NA    NA     NA
      891    NA    NA     NA
      892    NA    NA     NA
      893    NA    NA     NA
      894    NA    NA     NA
      895    NA    NA     NA
      896    NA    NA     NA
      897    NA    NA     NA
      898    NA    NA     NA
      899    NA    NA     NA
      900    NA    NA     NA
      901    NA    NA     NA
      902    NA    NA     NA
      903    NA    NA     NA
      904    NA    NA     NA
      905    NA    NA     NA
      906    NA    NA     NA
      907    NA    NA     NA
      908    NA    NA     NA
      909    NA    NA     NA
      910    NA    NA     NA
      911    NA    NA     NA
      912    NA    NA     NA
      913    NA    NA     NA
      914    NA    NA     NA
      915    NA    NA     NA
      916    NA    NA     NA
      917    NA    NA     NA
      918    NA    NA     NA
      919    NA    NA     NA
      920    NA    NA     NA
      921    NA    NA     NA
      922    NA    NA     NA
      923    NA    NA     NA
      924    NA    NA     NA
      925    NA    NA     NA
      926    NA    NA     NA
      927    NA    NA     NA
      928    NA    NA     NA
      929    NA    NA     NA
      930    NA    NA     NA
      931    NA    NA     NA
      932    NA    NA     NA
      933    NA    NA     NA
      934    NA    NA     NA
      935    NA    NA     NA
      936    NA    NA     NA
      937    NA    NA     NA
      938    NA    NA     NA
      939    NA    NA     NA
      940    NA    NA     NA
      941    NA    NA     NA
      942    NA    NA     NA
      943    NA    NA     NA
      944    NA    NA     NA
      945    NA    NA     NA
      946    NA    NA     NA
      947    NA    NA     NA
      948    NA    NA     NA
      949    NA    NA     NA
      950    NA    NA     NA
      951    NA    NA     NA
      952    NA    NA     NA
      953    NA    NA     NA
      954    NA    NA     NA
      955    NA    NA     NA
      956    NA    NA     NA
      957    NA    NA     NA
      958    NA    NA     NA
      959    NA    NA     NA
      960    NA    NA     NA
      
      $Asia$d2$`gear:carb`
            fill x y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #BBCBFF 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #BBCBFF 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #BBCBFF 1 1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #FFBFBB 2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #BBCBFF 2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #BBC8FF 2 1     1     6  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #FFBCBB 3 1     1    11  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      8  #BBCBFF 3 1     1    11  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      9  #BBC8FF 3 1     1    11  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      10 #FF0000 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      11 #BBCBFF 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      12 #BBC5FF 1 2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      13 #BBC9FF 2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      14 #BBC6FF 2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      15 #BBC4FF 2 2     1     7  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      16 #BBCCFF 3 2     1    12  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      17 #BBC7FF 3 2     1    12  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      18 #BBC4FF 3 2     1    12  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      19 #FFBFBB 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      20 #BBCAFF 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      21 #BBC8FF 1 3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      22 #BBC6FF 2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      23 #BBC4FF 2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      24 #BBC3FF 2 3     1     8  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      25 #BBCAFF 3 3     1    13  2.5  3.5  2.5  3.5     NA       0.1        1    NA
      26 #BBC6FF 3 3     1    13  2.5  3.5  2.5  3.5     NA       0.1        1    NA
      27 #BBC3FF 3 3     1    13  2.5  3.5  2.5  3.5     NA       0.1        1    NA
      28 #FF1C0C 1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      29 #BBCAFF 1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      30 #BBC4FF 1 4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      31 #BBC2FF 2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      32 #BBBCFF 2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      33 #B7B4FF 2 4     1     9  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      34 #BBC1FF 3 4     1    14  2.5  3.5  3.5  4.5     NA       0.1        1    NA
      35 #BBBDFF 3 4     1    14  2.5  3.5  3.5  4.5     NA       0.1        1    NA
      36 #B7B4FF 3 4     1    14  2.5  3.5  3.5  4.5     NA       0.1        1    NA
      37 #FFBEBB 1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      38 #BBCAFF 1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      39 #BBC7FF 1 5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      40 #BBBFFF 2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      41 #BBBCFF 2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      42 #B8B5FF 2 5     1    10  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      43 #BBC1FF 3 5     1    15  2.5  3.5  4.5  5.5     NA       0.1        1    NA
      44 #BBBDFF 3 5     1    15  2.5  3.5  4.5  5.5     NA       0.1        1    NA
      45 #B7B4FF 3 5     1    15  2.5  3.5  4.5  5.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      19    NA     NA
      20    NA     NA
      21    NA     NA
      22    NA     NA
      23    NA     NA
      24    NA     NA
      25    NA     NA
      26    NA     NA
      27    NA     NA
      28    NA     NA
      29    NA     NA
      30    NA     NA
      31    NA     NA
      32    NA     NA
      33    NA     NA
      34    NA     NA
      35    NA     NA
      36    NA     NA
      37    NA     NA
      38    NA     NA
      39    NA     NA
      40    NA     NA
      41    NA     NA
      42    NA     NA
      43    NA     NA
      44    NA     NA
      45    NA     NA
      
      $Asia$d2$`gear:wt`
            fill x  y PANEL group xmin xmax ymin ymax colour linewidth linetype alpha
      1  #B8B5FF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      2  #B8B5FF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      3  #B8B5FF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1    NA
      4  #B9B7FF 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      5  #B8B5FF 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      6  #B7B4FF 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1    NA
      7  #B9B8FF 3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      8  #B8B5FF 3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      9  #B7B3FF 3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1    NA
      10 #BAB9FF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      11 #B7B4FF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      12 #B5B0FF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1    NA
      13 #BBBAFF 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      14 #B6B2FF 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      15 #B4ADFF 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1    NA
      16 #BABAFF 3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      17 #B6B2FF 3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      18 #B4ADFF 3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1    NA
      19 #FF0000 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      20 #B7B3FF 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      21 #B4AEFF 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1    NA
      22 #BAB9FF 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      23 #B6B1FF 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      24 #B3ACFF 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1    NA
      25 #B8B6FF 3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1    NA
      26 #B5AFFF 3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1    NA
      27 #B3ACFF 3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1    NA
      28 #FF0200 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      29 #B7B3FF 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      30 #B4AEFF 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1    NA
      31 #B7B4FF 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      32 #B4AEFF 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      33 #B1AAFF 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1    NA
      34 #B6B2FF 3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1    NA
      35 #B3ACFF 3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1    NA
      36 #B0A7FF 3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1    NA
      37 #B9B8FF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      38 #B7B3FF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      39 #B5AFFF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1    NA
      40 #B3ADFF 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      41 #ADA2FF 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      42 #A595FF 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1    NA
      43 #B3ACFF 3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1    NA
      44 #ACA0FF 3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1    NA
      45 #A392FF 3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1    NA
      46 #FF0301 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1    NA
      47 #B7B3FF 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1    NA
      48 #B4AEFF 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1    NA
      49 #B5B0FF 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1    NA
      50 #ADA2FF 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1    NA
      51 #A595FF 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1    NA
      52 #B3ACFF 3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1    NA
      53 #ACA0FF 3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1    NA
      54 #A392FF 3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1    NA
      55 #FF0301 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1    NA
      56 #B7B3FF 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1    NA
      57 #B4AEFF 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1    NA
      58 #B5B0FF 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1    NA
      59 #ADA2FF 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1    NA
      60 #A595FF 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1    NA
      61 #B1A9FF 3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1    NA
      62 #ACA0FF 3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1    NA
      63 #A392FF 3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1    NA
      64 #B9B7FF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1    NA
      65 #B7B3FF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1    NA
      66 #B5AFFF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1    NA
      67 #B2ABFF 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1    NA
      68 #ADA2FF 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1    NA
      69 #A596FF 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1    NA
      70 #B1A8FF 3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1    NA
      71 #ACA0FF 3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1    NA
      72 #A392FF 3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1    NA
      73 #FF0301 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1    NA
      74 #B7B3FF 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1    NA
      75 #B4AEFF 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1    NA
      76 #B5B0FF 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1    NA
      77 #ADA2FF 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1    NA
      78 #A595FF 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1    NA
      79 #B3ACFF 3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1    NA
      80 #ACA0FF 3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1    NA
      81 #A392FF 3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1    NA
      82 #FF0301 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1    NA
      83 #B7B3FF 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1    NA
      84 #B4AEFF 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1    NA
      85 #B5B0FF 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1    NA
      86 #ADA2FF 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1    NA
      87 #A595FF 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1    NA
      88 #B3ACFF 3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1    NA
      89 #ACA0FF 3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1    NA
      90 #A392FF 3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1    NA
         width height
      1     NA     NA
      2     NA     NA
      3     NA     NA
      4     NA     NA
      5     NA     NA
      6     NA     NA
      7     NA     NA
      8     NA     NA
      9     NA     NA
      10    NA     NA
      11    NA     NA
      12    NA     NA
      13    NA     NA
      14    NA     NA
      15    NA     NA
      16    NA     NA
      17    NA     NA
      18    NA     NA
      19    NA     NA
      20    NA     NA
      21    NA     NA
      22    NA     NA
      23    NA     NA
      24    NA     NA
      25    NA     NA
      26    NA     NA
      27    NA     NA
      28    NA     NA
      29    NA     NA
      30    NA     NA
      31    NA     NA
      32    NA     NA
      33    NA     NA
      34    NA     NA
      35    NA     NA
      36    NA     NA
      37    NA     NA
      38    NA     NA
      39    NA     NA
      40    NA     NA
      41    NA     NA
      42    NA     NA
      43    NA     NA
      44    NA     NA
      45    NA     NA
      46    NA     NA
      47    NA     NA
      48    NA     NA
      49    NA     NA
      50    NA     NA
      51    NA     NA
      52    NA     NA
      53    NA     NA
      54    NA     NA
      55    NA     NA
      56    NA     NA
      57    NA     NA
      58    NA     NA
      59    NA     NA
      60    NA     NA
      61    NA     NA
      62    NA     NA
      63    NA     NA
      64    NA     NA
      65    NA     NA
      66    NA     NA
      67    NA     NA
      68    NA     NA
      69    NA     NA
      70    NA     NA
      71    NA     NA
      72    NA     NA
      73    NA     NA
      74    NA     NA
      75    NA     NA
      76    NA     NA
      77    NA     NA
      78    NA     NA
      79    NA     NA
      80    NA     NA
      81    NA     NA
      82    NA     NA
      83    NA     NA
      84    NA     NA
      85    NA     NA
      86    NA     NA
      87    NA     NA
      88    NA     NA
      89    NA     NA
      90    NA     NA
      
      $Asia$d2$`carb:wt`
             fill x  y PANEL group xmin xmax ymin ymax colour linewidth linetype
      1   #BBCCFF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      2   #BBCCFF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      3   #BBCCFF 1  1     1     1  0.5  1.5  0.5  1.5     NA       0.1        1
      4   #FF4C32 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1
      5   #BBCCFF 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1
      6   #BBCAFF 2  1     1    11  1.5  2.5  0.5  1.5     NA       0.1        1
      7   #FF755E 3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1
      8   #BBCCFF 3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1
      9   #BBCAFF 3  1     1    21  2.5  3.5  0.5  1.5     NA       0.1        1
      10  #FF1608 4  1     1    31  3.5  4.5  0.5  1.5     NA       0.1        1
      11  #BBCCFF 4  1     1    31  3.5  4.5  0.5  1.5     NA       0.1        1
      12  #BBCAFF 4  1     1    31  3.5  4.5  0.5  1.5     NA       0.1        1
      13  #FF0000 5  1     1    41  4.5  5.5  0.5  1.5     NA       0.1        1
      14  #BBCCFF 5  1     1    41  4.5  5.5  0.5  1.5     NA       0.1        1
      15  #BBCAFF 5  1     1    41  4.5  5.5  0.5  1.5     NA       0.1        1
      16  #FFC7BB 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      17  #BBCCFF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      18  #BBCBFF 1  2     1     2  0.5  1.5  1.5  2.5     NA       0.1        1
      19  #FF9A8D 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1
      20  #BBCBFF 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1
      21  #BBC9FF 2  2     1    12  1.5  2.5  1.5  2.5     NA       0.1        1
      22  #FFC2BB 3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1
      23  #BBCBFF 3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1
      24  #BBC9FF 3  2     1    22  2.5  3.5  1.5  2.5     NA       0.1        1
      25  #FF9A8D 4  2     1    32  3.5  4.5  1.5  2.5     NA       0.1        1
      26  #BBCBFF 4  2     1    32  3.5  4.5  1.5  2.5     NA       0.1        1
      27  #BBC9FF 4  2     1    32  3.5  4.5  1.5  2.5     NA       0.1        1
      28  #FF9A8D 5  2     1    42  4.5  5.5  1.5  2.5     NA       0.1        1
      29  #BBCBFF 5  2     1    42  4.5  5.5  1.5  2.5     NA       0.1        1
      30  #BBC9FF 5  2     1    42  4.5  5.5  1.5  2.5     NA       0.1        1
      31  #FFC7BB 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      32  #BBCCFF 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      33  #BBCBFF 1  3     1     3  0.5  1.5  2.5  3.5     NA       0.1        1
      34  #FFB4B1 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1
      35  #BBCBFF 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1
      36  #BBC9FF 2  3     1    13  1.5  2.5  2.5  3.5     NA       0.1        1
      37  #BBCCFF 3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1
      38  #BBCBFF 3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1
      39  #BBC9FF 3  3     1    23  2.5  3.5  2.5  3.5     NA       0.1        1
      40  #FFC9BB 4  3     1    33  3.5  4.5  2.5  3.5     NA       0.1        1
      41  #BBCBFF 4  3     1    33  3.5  4.5  2.5  3.5     NA       0.1        1
      42  #BBC8FF 4  3     1    33  3.5  4.5  2.5  3.5     NA       0.1        1
      43  #FFC9BB 5  3     1    43  4.5  5.5  2.5  3.5     NA       0.1        1
      44  #BBCBFF 5  3     1    43  4.5  5.5  2.5  3.5     NA       0.1        1
      45  #BBC8FF 5  3     1    43  4.5  5.5  2.5  3.5     NA       0.1        1
      46  #FFC7BB 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      47  #BBCCFF 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      48  #BBCBFF 1  4     1     4  0.5  1.5  3.5  4.5     NA       0.1        1
      49  #FFC0BB 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1
      50  #BBCBFF 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1
      51  #BBC8FF 2  4     1    14  1.5  2.5  3.5  4.5     NA       0.1        1
      52  #BBCBFF 3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1
      53  #BBCAFF 3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1
      54  #BBC9FF 3  4     1    24  2.5  3.5  3.5  4.5     NA       0.1        1
      55  #BBCCFF 4  4     1    34  3.5  4.5  3.5  4.5     NA       0.1        1
      56  #BBCAFF 4  4     1    34  3.5  4.5  3.5  4.5     NA       0.1        1
      57  #BBC8FF 4  4     1    34  3.5  4.5  3.5  4.5     NA       0.1        1
      58  #BBCCFF 5  4     1    44  4.5  5.5  3.5  4.5     NA       0.1        1
      59  #BBCAFF 5  4     1    44  4.5  5.5  3.5  4.5     NA       0.1        1
      60  #BBC8FF 5  4     1    44  4.5  5.5  3.5  4.5     NA       0.1        1
      61  #FFCCBB 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      62  #BBCCFF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      63  #BBCCFF 1  5     1     5  0.5  1.5  4.5  5.5     NA       0.1        1
      64  #FFC5BB 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1
      65  #BBCBFF 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1
      66  #BBC9FF 2  5     1    15  1.5  2.5  4.5  5.5     NA       0.1        1
      67  #BBCBFF 3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1
      68  #BBCAFF 3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1
      69  #BBC8FF 3  5     1    25  2.5  3.5  4.5  5.5     NA       0.1        1
      70  #BBCCFF 4  5     1    35  3.5  4.5  4.5  5.5     NA       0.1        1
      71  #BBCAFF 4  5     1    35  3.5  4.5  4.5  5.5     NA       0.1        1
      72  #BBC8FF 4  5     1    35  3.5  4.5  4.5  5.5     NA       0.1        1
      73  #BBCCFF 5  5     1    45  4.5  5.5  4.5  5.5     NA       0.1        1
      74  #BBCAFF 5  5     1    45  4.5  5.5  4.5  5.5     NA       0.1        1
      75  #BBC8FF 5  5     1    45  4.5  5.5  4.5  5.5     NA       0.1        1
      76  #FFC7BB 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      77  #BBCCFF 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      78  #BBCBFF 1  6     1     6  0.5  1.5  5.5  6.5     NA       0.1        1
      79  #FFC0BB 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1
      80  #BBCBFF 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1
      81  #BBC8FF 2  6     1    16  1.5  2.5  5.5  6.5     NA       0.1        1
      82  #BBCBFF 3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1
      83  #BBCAFF 3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1
      84  #BBC8FF 3  6     1    26  2.5  3.5  5.5  6.5     NA       0.1        1
      85  #BBCCFF 4  6     1    36  3.5  4.5  5.5  6.5     NA       0.1        1
      86  #BBCAFF 4  6     1    36  3.5  4.5  5.5  6.5     NA       0.1        1
      87  #BBC8FF 4  6     1    36  3.5  4.5  5.5  6.5     NA       0.1        1
      88  #BBCCFF 5  6     1    46  4.5  5.5  5.5  6.5     NA       0.1        1
      89  #BBCAFF 5  6     1    46  4.5  5.5  5.5  6.5     NA       0.1        1
      90  #BBC8FF 5  6     1    46  4.5  5.5  5.5  6.5     NA       0.1        1
      91  #FFC7BB 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      92  #BBCCFF 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      93  #BBCBFF 1  7     1     7  0.5  1.5  6.5  7.5     NA       0.1        1
      94  #FFC0BB 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1
      95  #BBCBFF 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1
      96  #BBC8FF 2  7     1    17  1.5  2.5  6.5  7.5     NA       0.1        1
      97  #BBCBFF 3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1
      98  #BBCAFF 3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1
      99  #BBC8FF 3  7     1    27  2.5  3.5  6.5  7.5     NA       0.1        1
      100 #BBCCFF 4  7     1    37  3.5  4.5  6.5  7.5     NA       0.1        1
      101 #BBCAFF 4  7     1    37  3.5  4.5  6.5  7.5     NA       0.1        1
      102 #BBC8FF 4  7     1    37  3.5  4.5  6.5  7.5     NA       0.1        1
      103 #BBCCFF 5  7     1    47  4.5  5.5  6.5  7.5     NA       0.1        1
      104 #BBCAFF 5  7     1    47  4.5  5.5  6.5  7.5     NA       0.1        1
      105 #BBC8FF 5  7     1    47  4.5  5.5  6.5  7.5     NA       0.1        1
      106 #BBCCFF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      107 #BBCCFF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      108 #BBCCFF 1  8     1     8  0.5  1.5  7.5  8.5     NA       0.1        1
      109 #FFC6BB 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1
      110 #BBCBFF 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1
      111 #BBC9FF 2  8     1    18  1.5  2.5  7.5  8.5     NA       0.1        1
      112 #BBCBFF 3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1
      113 #BBCAFF 3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1
      114 #BBC9FF 3  8     1    28  2.5  3.5  7.5  8.5     NA       0.1        1
      115 #BBCCFF 4  8     1    38  3.5  4.5  7.5  8.5     NA       0.1        1
      116 #BBCAFF 4  8     1    38  3.5  4.5  7.5  8.5     NA       0.1        1
      117 #BBC8FF 4  8     1    38  3.5  4.5  7.5  8.5     NA       0.1        1
      118 #BBCCFF 5  8     1    48  4.5  5.5  7.5  8.5     NA       0.1        1
      119 #BBCAFF 5  8     1    48  4.5  5.5  7.5  8.5     NA       0.1        1
      120 #BBC8FF 5  8     1    48  4.5  5.5  7.5  8.5     NA       0.1        1
      121 #FFC7BB 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      122 #BBCCFF 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      123 #BBCBFF 1  9     1     9  0.5  1.5  8.5  9.5     NA       0.1        1
      124 #FFC0BB 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1
      125 #BBCBFF 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1
      126 #BBC8FF 2  9     1    19  1.5  2.5  8.5  9.5     NA       0.1        1
      127 #BBCBFF 3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1
      128 #BBCAFF 3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1
      129 #BBC8FF 3  9     1    29  2.5  3.5  8.5  9.5     NA       0.1        1
      130 #BBCCFF 4  9     1    39  3.5  4.5  8.5  9.5     NA       0.1        1
      131 #BBCAFF 4  9     1    39  3.5  4.5  8.5  9.5     NA       0.1        1
      132 #BBC8FF 4  9     1    39  3.5  4.5  8.5  9.5     NA       0.1        1
      133 #BBCCFF 5  9     1    49  4.5  5.5  8.5  9.5     NA       0.1        1
      134 #BBCAFF 5  9     1    49  4.5  5.5  8.5  9.5     NA       0.1        1
      135 #BBC8FF 5  9     1    49  4.5  5.5  8.5  9.5     NA       0.1        1
      136 #FFC7BB 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      137 #BBCCFF 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      138 #BBCBFF 1 10     1    10  0.5  1.5  9.5 10.5     NA       0.1        1
      139 #FFC0BB 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1
      140 #BBCBFF 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1
      141 #BBC8FF 2 10     1    20  1.5  2.5  9.5 10.5     NA       0.1        1
      142 #BBCBFF 3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1
      143 #BBCAFF 3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1
      144 #BBC8FF 3 10     1    30  2.5  3.5  9.5 10.5     NA       0.1        1
      145 #BBCCFF 4 10     1    40  3.5  4.5  9.5 10.5     NA       0.1        1
      146 #BBCAFF 4 10     1    40  3.5  4.5  9.5 10.5     NA       0.1        1
      147 #BBC8FF 4 10     1    40  3.5  4.5  9.5 10.5     NA       0.1        1
      148 #BBCCFF 5 10     1    50  4.5  5.5  9.5 10.5     NA       0.1        1
      149 #BBCAFF 5 10     1    50  4.5  5.5  9.5 10.5     NA       0.1        1
      150 #BBC8FF 5 10     1    50  4.5  5.5  9.5 10.5     NA       0.1        1
          alpha width height
      1      NA    NA     NA
      2      NA    NA     NA
      3      NA    NA     NA
      4      NA    NA     NA
      5      NA    NA     NA
      6      NA    NA     NA
      7      NA    NA     NA
      8      NA    NA     NA
      9      NA    NA     NA
      10     NA    NA     NA
      11     NA    NA     NA
      12     NA    NA     NA
      13     NA    NA     NA
      14     NA    NA     NA
      15     NA    NA     NA
      16     NA    NA     NA
      17     NA    NA     NA
      18     NA    NA     NA
      19     NA    NA     NA
      20     NA    NA     NA
      21     NA    NA     NA
      22     NA    NA     NA
      23     NA    NA     NA
      24     NA    NA     NA
      25     NA    NA     NA
      26     NA    NA     NA
      27     NA    NA     NA
      28     NA    NA     NA
      29     NA    NA     NA
      30     NA    NA     NA
      31     NA    NA     NA
      32     NA    NA     NA
      33     NA    NA     NA
      34     NA    NA     NA
      35     NA    NA     NA
      36     NA    NA     NA
      37     NA    NA     NA
      38     NA    NA     NA
      39     NA    NA     NA
      40     NA    NA     NA
      41     NA    NA     NA
      42     NA    NA     NA
      43     NA    NA     NA
      44     NA    NA     NA
      45     NA    NA     NA
      46     NA    NA     NA
      47     NA    NA     NA
      48     NA    NA     NA
      49     NA    NA     NA
      50     NA    NA     NA
      51     NA    NA     NA
      52     NA    NA     NA
      53     NA    NA     NA
      54     NA    NA     NA
      55     NA    NA     NA
      56     NA    NA     NA
      57     NA    NA     NA
      58     NA    NA     NA
      59     NA    NA     NA
      60     NA    NA     NA
      61     NA    NA     NA
      62     NA    NA     NA
      63     NA    NA     NA
      64     NA    NA     NA
      65     NA    NA     NA
      66     NA    NA     NA
      67     NA    NA     NA
      68     NA    NA     NA
      69     NA    NA     NA
      70     NA    NA     NA
      71     NA    NA     NA
      72     NA    NA     NA
      73     NA    NA     NA
      74     NA    NA     NA
      75     NA    NA     NA
      76     NA    NA     NA
      77     NA    NA     NA
      78     NA    NA     NA
      79     NA    NA     NA
      80     NA    NA     NA
      81     NA    NA     NA
      82     NA    NA     NA
      83     NA    NA     NA
      84     NA    NA     NA
      85     NA    NA     NA
      86     NA    NA     NA
      87     NA    NA     NA
      88     NA    NA     NA
      89     NA    NA     NA
      90     NA    NA     NA
      91     NA    NA     NA
      92     NA    NA     NA
      93     NA    NA     NA
      94     NA    NA     NA
      95     NA    NA     NA
      96     NA    NA     NA
      97     NA    NA     NA
      98     NA    NA     NA
      99     NA    NA     NA
      100    NA    NA     NA
      101    NA    NA     NA
      102    NA    NA     NA
      103    NA    NA     NA
      104    NA    NA     NA
      105    NA    NA     NA
      106    NA    NA     NA
      107    NA    NA     NA
      108    NA    NA     NA
      109    NA    NA     NA
      110    NA    NA     NA
      111    NA    NA     NA
      112    NA    NA     NA
      113    NA    NA     NA
      114    NA    NA     NA
      115    NA    NA     NA
      116    NA    NA     NA
      117    NA    NA     NA
      118    NA    NA     NA
      119    NA    NA     NA
      120    NA    NA     NA
      121    NA    NA     NA
      122    NA    NA     NA
      123    NA    NA     NA
      124    NA    NA     NA
      125    NA    NA     NA
      126    NA    NA     NA
      127    NA    NA     NA
      128    NA    NA     NA
      129    NA    NA     NA
      130    NA    NA     NA
      131    NA    NA     NA
      132    NA    NA     NA
      133    NA    NA     NA
      134    NA    NA     NA
      135    NA    NA     NA
      136    NA    NA     NA
      137    NA    NA     NA
      138    NA    NA     NA
      139    NA    NA     NA
      140    NA    NA     NA
      141    NA    NA     NA
      142    NA    NA     NA
      143    NA    NA     NA
      144    NA    NA     NA
      145    NA    NA     NA
      146    NA    NA     NA
      147    NA    NA     NA
      148    NA    NA     NA
      149    NA    NA     NA
      150    NA    NA     NA
      
      
      $Asia$eff
      $Asia$eff[[1]]
        y PANEL group colour      fill linewidth linetype alpha         xmin
      1 1     1     1     NA lightgray       0.5        1    NA 1.197341e-14
      2 2     1     2     NA lightgray       0.5        1    NA 1.197341e-14
      3 3     1     3     NA lightgray       0.5        1    NA 1.197341e-14
      4 4     1     4     NA lightgray       0.5        1    NA 1.197341e-14
      5 5     1     5     NA lightgray       0.5        1    NA 1.197341e-14
      6 6     1     6     NA lightgray       0.5        1    NA 1.197341e-14
      7 7     1     7     NA lightgray       0.5        1    NA 1.197341e-14
               xmax ymin ymax
      1 1.19744e-14 -Inf  Inf
      2 1.19744e-14 -Inf  Inf
      3 1.19744e-14 -Inf  Inf
      4 1.19744e-14 -Inf  Inf
      5 1.19744e-14 -Inf  Inf
      6 1.19744e-14 -Inf  Inf
      7 1.19744e-14 -Inf  Inf
      
      $Asia$eff[[2]]
                 xmin         xmax y PANEL group  ymin  ymax colour linewidth
      1  1.197411e-14 1.197411e-14 1     1     1 0.875 1.125  black       0.5
      2  1.197411e-14 1.197411e-14 2     1     2 1.875 2.125  black       0.5
      3 -1.178021e-05 3.193949e-05 3     1     3 2.875 3.125  black       0.5
      4 -1.894153e-03 5.489234e-03 4     1     4 3.875 4.125  black       0.5
      5 -8.380929e-03 3.090750e-02 5     1     5 4.875 5.125  black       0.5
      6 -2.322303e-01 1.187455e-01 6     1     6 5.875 6.125  black       0.5
      7 -1.939198e+00           NA 7     1     7 6.875 7.125  black       0.5
        linetype height alpha
      1        1   0.25    NA
      2        1   0.25    NA
      3        1   0.25    NA
      4        1   0.25    NA
      5        1   0.25    NA
      6        1   0.25    NA
      7        1   0.25    NA
      
      $Asia$eff[[3]]
                 xmin         xmax ymin ymax y PANEL group colour  fill linewidth
      1  1.197390e-14 1.197390e-14  0.7  1.3 1     1     1     NA white       0.5
      2  1.197390e-14 1.197390e-14  1.7  2.3 2     1     2     NA white       0.5
      3 -5.907412e-06 5.907412e-06  2.7  3.3 3     1     3     NA white       0.5
      4 -8.579039e-04 8.579039e-04  3.7  4.3 4     1     4     NA white       0.5
      5 -1.087804e-02 1.087804e-02  4.7  5.3 5     1     5     NA white       0.5
      6 -7.015474e-02 7.015474e-02  5.7  6.3 6     1     6     NA white       0.5
      7 -5.844910e-01 5.844910e-01  6.7  7.3 7     1     7     NA white       0.5
        linetype alpha
      1        1    NA
      2        1    NA
      3        1    NA
      4        1    NA
      5        1    NA
      6        1    NA
      7        1    NA
      
      $Asia$eff[[4]]
                  x       label y PANEL group colour size angle hjust vjust alpha
      1 1.19739e-14 NALED  0.0% 1     1     1  black    3     0   0.5    -1    NA
      2 1.19739e-14 NALED  0.0% 2     1     2  black    3     0   0.5    -1    NA
      3 1.19739e-14 NALED 47.8% 3     1     3  black    3     0   0.5    -1    NA
      4 1.19739e-14 NALED 40.9% 4     1     4  black    3     0   0.5    -1    NA
      5 1.19739e-14 NALED 38.9% 5     1     5  black    3     0   0.5    -1    NA
      6 1.19739e-14 NALED 37.7% 6     1     6  black    3     0   0.5    -1    NA
      7 1.19739e-14 NALED 43.0% 7     1     7  black    3     0   0.5    -1    NA
        family fontface lineheight
      1               1        1.2
      2               1        1.2
      3               1        1.2
      4               1        1.2
      5               1        1.2
      6               1        1.2
      7               1        1.2
      
      $Asia$eff[[5]]
                    x label    y PANEL group colour size angle hjust vjust alpha
      1  1.197390e-14     ( 1.02     1     1  black 3.88     0   0.5   0.5    NA
      2  1.197390e-14     ( 2.02     1     2  black 3.88     0   0.5   0.5    NA
      3 -5.907412e-06     ( 3.02     1     3  black 3.88     0   0.5   0.5    NA
      4 -8.579039e-04     ( 4.02     1     4  black 3.88     0   0.5   0.5    NA
      5 -1.087804e-02     ( 5.02     1     5  black 3.88     0   0.5   0.5    NA
      6 -7.015474e-02     ( 6.02     1     6  black 3.88     0   0.5   0.5    NA
      7 -5.844910e-01     ( 7.02     1     7  black 3.88     0   0.5   0.5    NA
        family fontface lineheight
      1               1        1.2
      2               1        1.2
      3               1        1.2
      4               1        1.2
      5               1        1.2
      6               1        1.2
      7               1        1.2
      
      $Asia$eff[[6]]
                   x label    y PANEL group colour size angle hjust vjust alpha
      1 1.197390e-14     ) 1.02     1     1  black 3.88     0   0.5   0.5    NA
      2 1.197390e-14     ) 2.02     1     2  black 3.88     0   0.5   0.5    NA
      3 5.907412e-06     ) 3.02     1     3  black 3.88     0   0.5   0.5    NA
      4 8.579039e-04     ) 4.02     1     4  black 3.88     0   0.5   0.5    NA
      5 1.087804e-02     ) 5.02     1     5  black 3.88     0   0.5   0.5    NA
      6 7.015474e-02     ) 6.02     1     6  black 3.88     0   0.5   0.5    NA
      7 5.844910e-01     ) 7.02     1     7  black 3.88     0   0.5   0.5    NA
        family fontface lineheight
      1               1        1.2
      2               1        1.2
      3               1        1.2
      4               1        1.2
      5               1        1.2
      6               1        1.2
      7               1        1.2
      
      $Asia$eff[[7]]
                  x     label y PANEL group colour size angle hjust vjust alpha
      1 1.19739e-14 ALED 0.00 1     1     1  black    3     0   0.5     2    NA
      2 1.19739e-14 ALED 0.00 2     1     2  black    3     0   0.5     2    NA
      3 1.19739e-14 ALED 0.00 3     1     3  black    3     0   0.5     2    NA
      4 1.19739e-14 ALED 0.00 4     1     4  black    3     0   0.5     2    NA
      5 1.19739e-14 ALED 0.02 5     1     5  black    3     0   0.5     2    NA
      6 1.19739e-14 ALED 0.14 6     1     6  black    3     0   0.5     2    NA
      7 1.19739e-14 ALED 1.17 7     1     7  black    3     0   0.5     2    NA
        family fontface lineheight
      1               1        1.2
      2               1        1.2
      3               1        1.2
      4               1        1.2
      5               1        1.2
      6               1        1.2
      7               1        1.2
      
      $Asia$eff[[8]]
        x y PANEL group colour  fill size angle hjust vjust alpha family fontface
      1 1 1     1    -1  black white    3     0     1   0.5    NA               1
        lineheight                                                              label
      1        1.2 Explanation of symbols:\n[N]ALER min |--( [N]ALED )--| [N]ALER max
      
      
      
      $Europe
      $Europe$d1
      $Europe$d1$mpg
                x            y PANEL group colour      fill linewidth linetype alpha
      1  10.37589 1.305186e-14     1    -1     NA lightg