% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rescale.R
\docType{methods}
\name{rescale_transform}
\alias{rescale_transform}
\alias{rescale_transform-method}
\alias{rescale_transform,numeric,numeric-method}
\alias{rescale_transform,ANY,missing-method}
\title{Transform Intensities}
\usage{
rescale_transform(x, y, ...)

\S4method{rescale_transform}{numeric,numeric}(x, y, f, ...)

\S4method{rescale_transform}{ANY,missing}(x, f, ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Extra arguments to be passed to \code{f}.}

\item{f}{A \code{\link{function}} that takes a \code{numeric} vector of intensities as
argument and returns a \code{numeric} vector.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Transform Intensities
}
\details{
Transformation of intensities can be used to improve the identification of
peaks with a low signal-to-noise ratio.
}
\examples{
## gamma-ray spectrometry
data("BEGe")

## Subset from 2.75 to 200 keV
BEGe <- signal_select(BEGe, from = 3, to = 200)

## Plot spectrum
plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")

## Transform intensities
BEGe_trans <- rescale_transform(BEGe, f = sqrt)
plot(BEGe_trans, type = "l", xlab = "Energy (keV)", ylab = "sqrt(Count)")
}
\seealso{
Other normalization methods: 
\code{\link{rescale_area}()},
\code{\link{rescale_range}()},
\code{\link{rescale_total}()}
}
\author{
N. Frerebeau
}
\concept{normalization methods}
