% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{episodes}
\alias{episodes}
\title{Episodes}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{version}}{Country code for the version of the show}
  \item{\code{season}}{The season number}
  \item{\code{episode_number_overall}}{Episode number across seasons}
  \item{\code{episode}}{Episode number}
  \item{\code{title}}{Episode title}
  \item{\code{day_start}}{The day the episode started on}
  \item{\code{n_remaining}}{How are remaining at the start of the episode}
  \item{\code{air_date}}{Date the episode originally aired}
  \item{\code{viewers}}{Number of viewers in the US (millions)}
  \item{\code{quote}}{The beginning quote}
  \item{\code{author}}{Author of the beginning quote}
  \item{\code{imdb_rating}}{IMDb rating of the episode}
  \item{\code{n_ratings}}{Number of ratings given for the episode}
}
}
\source{
\url{https://en.wikipedia.org/wiki/List_of_Alone_episodes#Season_1_(2015)_-_Vancouver_Island}
}
\usage{
episodes
}
\description{
Contains details of each episode including the title, number of viewers, beginning quote
and IMDb rating
}
\examples{
library(dplyr)
library(ggplot2)

episodes |>
  ggplot(aes(episode_number_overall, viewers, colour = as.factor(season))) +
  geom_line()
}
\keyword{datasets}
