% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{extract_set}
\alias{extract_set}
\title{Extract train/test dataset}
\usage{
extract_set(x, set = c("train", "test"))
}
\arguments{
\item{x}{an object of class "split_df", usually, a result of a call to split_df().}

\item{set}{character. Specifies whether the extracted data is a train set or a test set.
You can use "train" or "test".}
}
\value{
an object of class "tbl_df".
}
\description{
Extract train set or test set from split_df class object
}
\details{
Extract the train or test sets based on the parameters you defined when creating split_df with split_by().
}
\examples{
library(dplyr)

# Credit Card Default Data
head(ISLR::Default)

# Generate data for the example
sb <- ISLR::Default \%>\%
  split_by(default)

train <- sb \%>\%
  extract_set(set = "train")

test <- sb \%>\%
  extract_set(set = "test")

}
