% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_blackmarble}
\alias{process_blackmarble}
\title{Assign VIIRS Black Marble products corner coordinates to retrieve a merged raster}
\usage{
process_blackmarble(
  path = NULL,
  date = NULL,
  tile_df = process_blackmarble_corners(),
  subdataset = 3L,
  crs = "EPSG:4326",
  ...
)
}
\arguments{
\item{path}{character. Full paths of h5 files.}

\item{date}{character(1). Date to query.}

\item{tile_df}{data.frame. Contains four corner coordinates in fields named
\code{c("xmin", "xmax", "ymin", "ymax")}.
See \code{\link{process_blackmarble_corners}} to generate a valid object for this argument.}

\item{subdataset}{integer(1). Subdataset number to process.
Default is 3L.}

\item{crs}{character(1). terra::crs compatible CRS.
Default is \code{"EPSG:4326"}}

\item{...}{For internal use.}
}
\value{
a \code{SpatRaster} object
}
\description{
This function will return a \code{SpatRaster} object with
georeferenced h5 files of Black Marble product. Referencing corner coordinates
are necessary as the original h5 data do not include such information.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
vnp46a2 <- process_blackmarble(
  path =
    list.files("./data", pattern = "VNP46A2.", full.names = TRUE),
  date = "2024-01-01",
  tile_df =
    process_blackmarble_corners(hrange = c(8, 10), vrange = c(4, 5)),
  subdataset = 3L,
  crs = "EPSG:4326"
)
}
}
\references{
\itemize{
\item \href{https://ladsweb.modaps.eosdis.nasa.gov/api/v2/content/archives/Document\%20Archive/Science\%20Data\%20Product\%20Documentation/VIIRS_Black_Marble_UG_v1.3_Sep_2022.pdf}{Wang, Z. (2022). Black Marble User Guide (Version 1.3). NASA.}
}
}
\seealso{
\itemize{
\item \code{\link[terra:describe]{terra::describe}}
\item \code{\link[terra:merge]{terra::merge}}
\item \code{\link{process_blackmarble_corners}}
}
}
\author{
Insang Song
}
