% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationMatrix.R
\name{correlationMatrix}
\alias{correlationMatrix}
\title{Correlation matrix for statistical metrics computed by AMBER}
\usage{
correlationMatrix(metric, inputDir, outputDir = FALSE,
  significanceLevel = 0.01, plot.width = 8, plot.height = 6.8,
  plot.margin = c(10, 10, 1, 4))
}
\arguments{
\item{metric}{A string that indicates for what statistical metric the correlation matrix should be computed.
Options are 'bias', 'crmse', 'phase', 'bias-score', 'crmse-score', 'phase-score', or 'iav-score'.}

\item{inputDir}{A string that gives the location of NetCDF files produced by \link{scores.grid.time}, e.g. '/home/project/study'.}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}

\item{significanceLevel}{A number that gives the desired significance level of a correlation, e.g. 0.01}

\item{plot.width}{A number that gives the plot width, e.g. 8}

\item{plot.height}{A number that gives the plot height, e.g. 6.8}

\item{plot.margin}{An R object that gives the plot margin, e.g. c(10, 10, 1, 4)}
}
\value{
A list with the Spearman correlation coefficient and corresponding p-values, and a Figure of the correlation matrix
}
\description{
This function produces a correlation matrices for \eqn{bias}, \eqn{rmse},
\eqn{crmse}, \eqn{phase}, and corresponding scores. The input data consist of netCDF files
produced by \link{scores.grid.time} and \link{scores.grid.notime}.
}
\examples{

library(amber)
library(foreach)
library(Hmisc)
library(ncdf4)
library(raster)

inputDir <- paste(system.file('extdata', package = 'amber'), 'zonalMeanStats', sep = '/')
correlationMatrix(metric = 'bias', inputDir)

}
