% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.tables.R
\name{scores.tables}
\alias{scores.tables}
\title{Summarize results in a table and a plot}
\usage{
scores.tables(plot.width = 6, plot.height = 5, myMargin = c(4, 13, 3,
  4), inputDir = getwd(), outputDir = FALSE)
}
\arguments{
\item{plot.width}{Number that gives the plot width, e.g. 6}

\item{plot.height}{Number that gives the plot height, e.g. 5}

\item{myMargin}{An R object that gives the figure margins, e.g. c(4, 13, 3, 4)}

\item{inputDir}{A string that gives the input directory, e.g. '/home/project/study'.}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
(1) Two tables in LaTeX format that shows the scores of all variables that were assessed (with and without mass weighting).
(2) Two figures in PDF format that show the same information as (1).
(3) Two NetCDF files that show the same information as (1).
(4) Five tables in LaTeX format that show the globally averaged statistical
metrics for calculating a score (without mass weighting).
(\eqn{S_{bias}}, \eqn{S_{rmse}}, \eqn{S_{phase}}, \eqn{S_{iav}}, \eqn{S_{dist}}).
}
\description{
This function merges all tables that have been created by the
functions
\link{scores.fluxnet.csv} or \link{scores.fluxnet.nc},
\link{scores.grid.notime},
\link{scores.grid.time}, and
\link{scores.runoff}.
}
\examples{

library(amber)
library(latex2exp)
library(viridis)
library(xtable)

myInputDir <- paste(system.file('extdata', package = 'amber'), 'scores', sep = '/')
scores.tables(inputDir = myInputDir)

}
