% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEnsembleHovmoeller.R
\name{plotEnsembleHovmoeller}
\alias{plotEnsembleHovmoeller}
\title{Hovmoeller Diagram for model ensemble}
\usage{
plotEnsembleHovmoeller(mod.path.list = mod.path.list,
  modelIDs = modelIDs, myVariables = myVariables, myBin = 20,
  gridCellWidth = 2, my.ylim = c(-100, 100), plot.width = 8.4,
  plot.height = 5, outputDir = FALSE)
}
\arguments{
\item{mod.path.list}{A List of directories where AMBER output is stored for different model runs,
e.g. list(mod01.path, mod02.path, mod03.path)}

\item{modelIDs}{An R object with the different model run IDs, e.g. c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5', 'CLASSIC.CRUNCEP')}

\item{myVariables}{An R object with the variable names of interest, e.g. c('GPP.FluxCom', 'RECO.FluxCom').}

\item{myBin}{An integer number that defines the latitudinal range used for computing the zonal mean.
For instance, a value of 10 implies that a zonal mean is computed for every 10 degrees latitude.}

\item{gridCellWidth}{A number that is used as a factor to adjust the width of grid cells, e.g. 1.}

\item{my.ylim}{An R object that gives the longitude range that you wish to plot, e.g. c(-90, 90)}

\item{plot.width}{Number that gives the plot width, e.g. 8}

\item{plot.height}{Number that gives the plot height, e.g. 4}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
Figures in PDF format.
}
\description{
This function plots Hovmoeller diagrams of monthly climatological
mean values and biases computed by \link{scores.grid.time} for multiple ensemble members
}
\examples{

\donttest{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

mod01.path <- paste(system.file('extdata', package = 'amber'), 'model01', sep = '/')
mod02.path <- paste(system.file('extdata', package = 'amber'), 'model02', sep = '/')
mod.path.list <- list(mod01.path, mod02.path)
modelIDs <- c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5')

myVariables <- c('GPP-MODIS', 'GPP-GOSIF')

plotEnsembleHovmoeller(mod.path.list = mod.path.list,
modelIDs = modelIDs, myVariables = myVariables, myBin = 20, gridCellWidth = 2,
my.ylim = c(-100, 100), plot.width = 8.4, plot.height = 5.0)
} #donttest
}
