% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.R
\name{amber.login}
\alias{amber.login}
\title{Opan a connection with Amber}
\usage{
amber.login(
  username = getOption("amber.username", "anonymous"),
  password = getOption("amber.password", "password"),
  url = getOption("amber.url"),
  opts = getOption("amber.opts", list())
)
}
\arguments{
\item{username}{User name in Amber. Can be provided by "amber.username" option.}

\item{password}{User password in Amber. Can be provided by "amber.password" option.}

\item{url}{Amber url. Can be provided by "amber.url" option. Secure http (https) connection is required.}

\item{opts}{Curl options. Can be provided by "amber.opts" option.}
}
\value{
An Amber object

An amber connection object to be used in further function calls
}
\description{
Open a connection with Amber and returns an Amber object.  When the two-factor
authentication mechanism is enabled, the user will be prompt for one-time password input.
}
\examples{
\dontrun{
# login using credentials from amber.username and amber.password options
a <- amber.login("https://amber-demo.obiba.org")
# login by providing credentials
a <- amber.login("administrator", "password", "https://amber-demo.obiba.org")
}
}
