% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{steps}
\alias{steps}
\alias{direction_abs}
\alias{direction_abs.track_xy}
\alias{direction_rel}
\alias{direction_rel.track_xy}
\alias{step_lengths}
\alias{step_lengths.track_xy}
\alias{steps_by_burst}
\alias{steps_by_burst.track_xyt}
\alias{steps.track_xy}
\alias{steps.track_xyt}
\title{Functions to create and work with steps}
\usage{
direction_abs(x, ...)

\method{direction_abs}{track_xy}(
  x,
  full_circle = FALSE,
  zero_dir = "E",
  clockwise = FALSE,
  append_last = TRUE,
  lonlat = FALSE,
  ...
)

direction_rel(x, ...)

\method{direction_rel}{track_xy}(x, lonlat = FALSE, append_last = TRUE, zero_dir = "E", ...)

step_lengths(x, ...)

\method{step_lengths}{track_xy}(x, lonlat = FALSE, append_last = TRUE, ...)

steps_by_burst(x, ...)

\method{steps_by_burst}{track_xyt}(x, lonlat = FALSE, keep_cols = NULL, ...)

steps(x, ...)

\method{steps}{track_xy}(x, lonlat = FALSE, keep_cols = NULL, ...)

\method{steps}{track_xyt}(x, lonlat = FALSE, keep_cols = NULL, diff_time_units = "auto", ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{...}{Further arguments, none implemented}

\item{full_circle}{\verb{[logical(1)=FALSE]} \cr If \code{TRUE} angles are returned between 0 and $2pi$, otherwise angles are between $-pi$ and $pi$.}

\item{zero_dir}{\verb{[character(1)='E']} \cr Indicating the zero direction. Must be either \code{N}, \code{E}, \code{S}, or \code{W}.}

\item{clockwise}{\verb{[logical(1)=FALSE]} \cr Should angles be calculated clock or anti-clockwise?}

\item{append_last}{\verb{[logical(1)=TRUE]} \cr If \code{TRUE} an \code{NA} is appended at the end of all angles.}

\item{lonlat}{\verb{[logical(1)=TRUE]} \cr Should geographical or planar coordinates be used? If \code{TRUE} geographic distances are calculated.}

\item{keep_cols}{\verb{[character(1)=NULL]\{'start', 'end', 'both'\}} \cr Should columns with attribute information be transferred to steps? If \code{keep_cols = 'start'} the attributes from the starting point are use, otherwise the columns from the end points are used.}

\item{diff_time_units}{\verb{[character(1)='auto']} \cr The unit for time differences, see \code{?difftime}.}
}
\value{
\verb{[numeric]} \cr For \code{step_lengths()} and \verb{direction_*} a numeric vector. \cr
\verb{[data.frame]} \cr For \code{steps} and \code{steps_by_burst}, containing the steps.
}
\description{
\code{step_lengths} can be use to calculate step lengths of a track. \code{direction_abs} and \code{direction_rel} calculate the absolute and relative direction of steps. \code{steps} converts a \verb{track_xy*} from a point representation to a step representation and automatically calculates step lengths and relative turning angles.
}
\details{
\verb{dierctions_*()} returns \code{NA} for 0 step lengths.

\code{step_lengths} calculates the step lengths between points a long the path. The last value returned is \code{NA}, because no observed step is 'started' at the last point. If \code{lonlat = TRUE}, \code{step_lengths()} wraps \code{\link[raster:pointDistance]{raster::pointDistance()}}.
}
\examples{

xy <- tibble(
  x = c(1, 4, 8, 8, 12, 12, 8, 0, 0, 4, 2),
  y = c(0, 0, 0, 8, 12, 12, 12, 12, 8, 4, 2))
trk <- make_track(xy, x, y)

# append last
direction_abs(trk, append_last = TRUE)
direction_abs(trk, append_last = FALSE)

# degrees
direction_abs(trk) \%>\% as_degree

# full circle or not: check
direction_abs(trk, full_circle = TRUE)
direction_abs(trk, full_circle = FALSE)
direction_abs(trk, full_circle = TRUE) \%>\% as_degree()
direction_abs(trk, full_circle = FALSE) \%>\% as_degree()

# direction of 0
direction_abs(trk, full_circle = TRUE, zero_dir = "N")
direction_abs(trk, full_circle = TRUE, zero_dir = "E")
direction_abs(trk, full_circle = TRUE, zero_dir = "S")
direction_abs(trk, full_circle = TRUE, zero_dir = "W")

# clockwise or not
direction_abs(trk, full_circle = TRUE, zero_dir = "N", clockwise = FALSE)
direction_abs(trk, full_circle = TRUE, zero_dir = "N", clockwise = TRUE)

# Bearing (i.e. azimuth): only for lon/lat
direction_abs(trk, full_circle = FALSE, zero_dir = "N", lonlat = FALSE, clockwise = TRUE)
direction_abs(trk, full_circle = FALSE, zero_dir = "N", lonlat = TRUE, clockwise = TRUE)

}
