% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_kde.R
\name{bandwidth_pi}
\alias{bandwidth_pi}
\alias{hr_kde_pi}
\alias{hr_kde_pi.track_xy}
\title{\code{hr_kde_pi} wraps \code{KernSmooth::dpik} to select bandwidth for kernel density estimation the plug-in-the-equation method in two dimensions.}
\usage{
hr_kde_pi(x, ...)

\method{hr_kde_pi}{track_xy}(x, rescale = "none", correct = TRUE, ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{...}{Further arguments, none implemented.}

\item{rescale}{\verb{[character(1)]} \cr Rescaling method for reference bandwidth calculation. Must be one of "unitvar", "xvar", or "none".}

\item{correct}{Logical scalar that indicates whether or not the estimate should be correct for the two dimensional case.}
}
\value{
The bandwidth, the standardization method and correction.
}
\description{
This function calculates bandwidths for kernel density estimation by wrapping \code{KernSmooth::dpik}. If \code{correct = TURE}, the bandwidth is trasformed with power 5/6 to correct for using an univariate implementation for bivariate data (Gitzen et. al 2006).
}
\references{
Gitzen, R. A., Millspaugh, J. J., & Kernohan, B. J. (2006). Bandwidth selection for fixed-kernel analysis of animal utilization distributions. \emph{Journal of Wildlife Management}, 70(5), 1334-1344.
}
\seealso{
\code{KernSmooth::dpik}
}
