% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume-actions.R
\name{volume_attach}
\alias{volume_action}
\alias{volume_actions}
\alias{volume_attach}
\alias{volume_detach}
\alias{volume_resize}
\title{Attach a volume to a droplet}
\usage{
volume_attach(volume, droplet, region = "nyc1", ...)

volume_detach(volume, droplet, region = "nyc1", ...)

volume_resize(volume, size, region = "nyc1", ...)

volume_action(volume, actionid, ...)

volume_actions(volume, page = 1, per_page = 25, ...)
}
\arguments{
\item{volume}{A volume, or something that can be coerced to a volume by
\code{\link{as.volume}}.}

\item{droplet}{A droplet, or something that can be coerced to a droplet by
\code{\link{as.droplet}}.}

\item{region}{(character) The region where the Block Storage volume will
be created. When setting a region, the value should be the slug identifier
for the region. When you query a Block Storage volume, the entire region
object will be returned. Should not be specified with a snapshot_id.
Default: nyc1}

\item{...}{Additional options passed down to \code{\link[httr]{GET}},
\code{\link[httr]{POST}}, etc.}

\item{size}{(integer) The size of the Block Storage volume in GiB}

\item{actionid}{(integer) Optional. An action id.}

\item{page}{Page to return. Default: 1.}

\item{per_page}{Number of results per page. Default: 25.}
}
\description{
Attach a volume to a droplet
}
\details{
Note that there is a way to attach a volume to or remove from a
droplet by name, but we only support doing this by ID. Howevever, as
the user, all you need to do is make a volume class object via
\code{\link{as.volume}} and pass it to \code{volume_attach} or
\code{volume_detach}, which is pretty darn easy.
}
\examples{
\dontrun{
# resize a volume
## create a volume
(vol1 <- volume_create('foobar', 5))
## resize it
volume_resize(vol1, 6)
volume(vol1)

# attach a volume to a droplet
## create a droplet
(d <- droplet_create(region = "nyc1"))
## attach volume to droplet
volume_attach(vol1, d)
## refresh droplet info, see volumes slot
droplet(d$id)

# detach a volume from a droplet
(act <- volume_detach(vol1, d))
## refresh droplet info, see volumes slot
droplet(d$id)

# list an action
volume_action(vol1, 154689758)

# list all volume actions
volume_actions(volumes()[[1]])
}
}

