% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{droplet_functions}
\alias{droplet_functions}
\title{Functions for DigitalOcean (DO) droplets}
\description{
There's a lot of functions for working with droplets.
Here's a breakdown of what they all do.
}
\section{Documentation}{

\itemize{
\item DigitalOcean docs overview:
\url{https://developers.digitalocean.com/documentation/}
\item DigitalOcean API docs:
\url{https://developers.digitalocean.com/documentation/v2/}
}
}

\section{Functions}{


The main functions for creating/deleting droplets:
\itemize{
\item \code{\link[=droplet]{droplet()}}: get a droplet object from a droplet ID
\item \code{\link[=droplet_create]{droplet_create()}}: create a droplet
\item \code{\link[=droplets_create]{droplets_create()}}: create two or more droplets
\item \code{\link[=droplet_delete]{droplet_delete()}}: delete a droplet
\item \code{\link[=droplets]{droplets()}}: get your droplets
\item \code{\link[=as.droplet]{as.droplet()}}: coerce various things to droplet objects
}

Modify a droplet:
\itemize{
\item \code{\link[=droplet_resize]{droplet_resize()}}: resize a droplet to a different size
\item \code{\link[=droplet_rebuild]{droplet_rebuild()}}: reinstall a droplet with a different image
\item \code{\link[=droplet_rename]{droplet_rename()}}: rename a droplet
\item \code{\link[=droplet_change_kernel]{droplet_change_kernel()}}: change droplet to a new kernel
}

Take and restore snapshots:
\itemize{
\item \code{\link[=droplet_snapshot]{droplet_snapshot()}}: make a snapshot of a droplet
\item \code{\link[=droplet_snapshots_list]{droplet_snapshots_list()}}: list snapshots on a droplet
\item \code{\link[=droplet_backups_list]{droplet_backups_list()}}: list droplet backups
\item \code{\link[=droplet_restore]{droplet_restore()}}: Restore a droplet with a previous image or snapshot
}

ssh interactions with droplets:
\itemize{
\item \code{\link[=droplet_ssh]{droplet_ssh()}}: Remotely execute code on your droplet via ssh
\item \code{\link[=droplet_upload]{droplet_upload()}}: Upload files to your droplet via ssh
\item \code{\link[=droplet_download]{droplet_download()}}: Download files from your droplet via ssh
}

Perform various actions on droplets:
\itemize{
\item \code{\link[=droplet_actions]{droplet_actions()}}: retrieve a droplet action or list all actions
associated with a droplet
\item \code{\link[=droplet_disable_backups]{droplet_disable_backups()}}: Disables backups for a droplet
\item \code{\link[=droplet_do_actions]{droplet_do_actions()}}: Perform actions on one or more droplets associated with a tag
\item \code{\link[=droplet_enable_backups]{droplet_enable_backups()}}: Enables backups for a droplet
\item \code{\link[=droplet_enable_ipv6]{droplet_enable_ipv6()}}: Enable IPv6 networking on an existing droplet (within
a region that has IPv6 available)
\item \code{\link[=droplet_enable_private_networking]{droplet_enable_private_networking()}}: Enable private networking on an existing
droplet (within a region that has private networking available)
\item \code{\link[=droplet_execute]{droplet_execute()}}: Execute R code on a droplet
\item \code{\link[=droplet_kernels_list]{droplet_kernels_list()}}:  List all available kernels for a droplet
\item \code{\link[=droplet_neighbors]{droplet_neighbors()}}: List a droplet's neighbors on the same physical server
\item \code{\link[=droplet_power_cycle]{droplet_power_cycle()}}: power cycle a droplet. will turn off the droplet and
then turn it back on
\item \code{\link[=droplet_power_off]{droplet_power_off()}}: Shutdown a running droplet. The droplet will remain in
your account and you will continue to be charged for it
\item \code{\link[=droplet_power_on]{droplet_power_on()}}: Turn on a droplet that's turned off
\item \code{\link[=droplet_reboot]{droplet_reboot()}}: reboot a droplet. This is the preferred method to use if
a server is not responding
\item \code{\link[=droplet_reset_password]{droplet_reset_password()}}: reset the root password for a droplet
\item \code{\link[=droplet_reuse]{droplet_reuse()}}: Reuse a droplet or image by name, creating a new droplet
\item \code{\link[=droplet_shutdown]{droplet_shutdown()}}: Shutdown a running droplet. The droplet will remain in
your account and you will continue to be charged for it.
\item \code{\link[=droplet_upgrade]{droplet_upgrade()}}: Migrate a droplet - NOT SURE IF THIS STILL WORKS OR NOT
\item \code{\link[=droplet_upgrades_list]{droplet_upgrades_list()}}: List all droplets that are scheduled to be upgraded
\item \code{\link[=droplet_wait]{droplet_wait()}}: Wait for a droplet to be ready. mostly used internally
\item \code{\link[=droplets_cost]{droplets_cost()}}: Calculate cost across droplets
}

Freeze/thaw droplets:
\itemize{
\item \code{\link[=droplet_freeze]{droplet_freeze()}}: power off a droplet, snapshots to create an image, and deletes the
droplet
\item \code{\link[=droplet_thaw]{droplet_thaw()}}: takes an image and turns it into a running droplet
}
}

\section{Working with Docker}{


We named a DO droplet with the Docker application installed a "docklet"
for convienence

The main two functions for creating docklets:
\itemize{
\item \code{\link[=docklet_create]{docklet_create()}}: create a docklet (a droplet using the docker image)
\item \code{\link[=docklets_create]{docklets_create()}}: create many docklets
}

Running docker commands on your docklet:
\itemize{
\item \code{\link[=docklet_images]{docklet_images()}}: list docker images on your docklet
\item \code{\link[=docklet_ps]{docklet_ps()}}: list running docker containers
\item \code{\link[=docklet_pull]{docklet_pull()}}: pull a docker image to your docklet
\item \code{\link[=docklet_rm]{docklet_rm()}}: remove a docker image from your docklet
\item \code{\link[=docklet_run]{docklet_run()}}: run a docker command on your docklet
\item \code{\link[=docklet_stop]{docklet_stop()}}: stop a running docker container
\item \code{\link[=docklet_docker]{docklet_docker()}}: low level fxn for running docker commands on your,
not realy intended for public use
}

Install RStudio things:
\itemize{
\item \code{\link[=docklet_rstudio]{docklet_rstudio()}}: install RStudio on your docklet using
Rocker images (\url{https://hub.docker.com/u/rocker})
\item \code{\link[=docklet_rstudio_addusers]{docklet_rstudio_addusers()}}: add users to an RStudio docker image
\item \code{\link[=docklet_shinyserver]{docklet_shinyserver()}}: install Shiny server on your docklet using
Rocker images (\url{https://hub.docker.com/u/rocker})
\item \code{\link[=docklet_shinyapp]{docklet_shinyapp()}}: install a Shiny app on your Shiny server docker
container
}
}

