% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Anfis-training.R
\docType{methods}
\name{LSE}
\alias{LSE}
\alias{LSE,ANFIS-method}
\alias{LSE-methods}
\alias{trainHybridJangOffLine}
\alias{trainHybridJangOffLine,ANFIS-method}
\alias{trainHybridJangOffLine-methods}
\alias{trainHybridJangOnLine}
\alias{trainHybridJangOnLine,ANFIS-method}
\alias{trainHybridJangOnLine-methods}
\alias{trainHybridOffLine}
\alias{trainHybridOffLine,ANFIS-method}
\alias{trainHybridOffLine-methods}
\title{Train ANFIS network}
\usage{
LSE(object, A, B, initialGamma = 1000)

\S4method{LSE}{ANFIS}(object, A, B, initialGamma = 1000)

trainHybridJangOffLine(object, epochs = 5, tolerance = 1e-05,
  initialGamma = 1000, k = 0.01)

\S4method{trainHybridJangOffLine}{ANFIS}(object, epochs = 5,
  tolerance = 1e-05, initialGamma = 1000, k = 0.01)

trainHybridOffLine(object, epochs = 5, tolerance = 1e-05,
  initialGamma = 1000, eta = 0.05, phi = 0.2, a = 0.01, b = 0.1,
  delta_alpha_t_1 = list())

\S4method{trainHybridOffLine}{ANFIS}(object, epochs = 5, tolerance = 1e-05,
  initialGamma = 1000, eta = 0.05, phi = 0.2, a = 0.01, b = 0.1,
  delta_alpha_t_1 = list())

trainHybridJangOnLine(object, epochs = 5, tolerance = 1e-15,
  initialGamma = 1000, k = 0.01, lamda = 0.9, S = matrix(nrow = 0, ncol
  = 0))

\S4method{trainHybridJangOnLine}{ANFIS}(object, epochs = 5,
  tolerance = 1e-15, initialGamma = 1000, k = 0.01, lamda = 0.9,
  S = matrix(nrow = 0, ncol = 0))
}
\arguments{
\item{object}{ANFIS' class object.}

\item{A}{internal matrix for Iterative Least Squares Estimation of AX=B.}

\item{B}{internal matrix for Iterative Least Squares Estimation of AX=B.}

\item{initialGamma}{numeric large number >> 0. Default 1000.}

\item{epochs}{the max number of training epochs. Default 5.}

\item{tolerance}{convergence error to stop training. Default 1e-5.}

\item{k}{numeric with the initial step size for learning rule. Default 0.01.}

\item{eta}{numeric learning rule coefficient. Default 0.05.}

\item{phi}{numeric momentum rule coefficient. Default 0.2.}

\item{a}{numeric step to increase eta if delta_e is < 0, i.e. descending.
Default value 0.01.}

\item{b}{numeric fraction to decrease eta if delta_e is > 0, i.e. ascending.
Default value is 0.1.}

\item{delta_alpha_t_1}{list with numeric matrix with last time step. Default
list().}

\item{lamda}{0 < numeric < 1 forgetting factor. Default 0.9.}

\item{S}{covariance matrix for on-line LSE. Default matrix(nrow=0, ncol=0).}
}
\value{
\item{matrix}{with the system solution for LSE output.}
 \item{error}{numeric vector with training associated errors (pattern or
   epoch) according to trainingType.}
 \item{convergence}{TRUE/FALSE if it reached convergence or not.}
 \item{updated}{trainingType, premises, consequents, error, residuals,
   fitted.values and coefficient.}
}
\description{
ANFIS on-line or off-line hybrid Jang dynamic learning training process. In
addition for off-line learning there is also adaptive learning coefficient
and momentum term.














}
\note{
see full example in \code{\link{ANFIS-class}}
}
\author{
Cristobal Fresno \email{cfresno@bdmg.com.ar}, Andrea S. Llera
 \email{ALlera@leloir.org.ar} and Elmer A. Fernandez
 \email{efernandez@bdmg.com.ar}
}
\seealso{
\code{\link{ANFIS-class}}

Other ANFIS: \code{\link{ANFIS-class}};
  \code{\link{anfis3}}; \code{\link{coef}},
  \code{\link{coef,ANFIS-method}},
  \code{\link{coefficients}},
  \code{\link{coefficients,ANFIS-method}},
  \code{\link{fitted}}, \code{\link{fitted,ANFIS-method}},
  \code{\link{fitted.values}},
  \code{\link{fitted.values,ANFIS-method}},
  \code{\link{resid}}, \code{\link{resid,ANFIS-method}},
  \code{\link{residuals}},
  \code{\link{residuals,ANFIS-method}},
  \code{\link{summary}},
  \code{\link{summary,ANFIS-method}};
  \code{\link{getConsequents}},
  \code{\link{getConsequents}},
  \code{\link{getConsequents,ANFIS-method}},
  \code{\link{getConsequents,ANFIS-method}},
  \code{\link{getErrors}}, \code{\link{getErrors}},
  \code{\link{getErrors,ANFIS-method}},
  \code{\link{getErrors,ANFIS-method}},
  \code{\link{getPremises}}, \code{\link{getPremises}},
  \code{\link{getPremises,ANFIS-method}},
  \code{\link{getPremises-methods}},
  \code{\link{getRules}}, \code{\link{getRules}},
  \code{\link{getRules,ANFIS-method}},
  \code{\link{getRules-methods}},
  \code{\link{getTrainingType}},
  \code{\link{getTrainingType}},
  \code{\link{getTrainingType,ANFIS-method}},
  \code{\link{getTrainingType,ANFIS-method}};
  \code{\link{initialize}},
  \code{\link{initialize,ANFIS-method}};
  \code{\link{plotMF}}, \code{\link{plotMF}},
  \code{\link{plotMF,ANFIS-method}},
  \code{\link{plotMF-methods}}, \code{\link{plotMFs}},
  \code{\link{plotMFs}},
  \code{\link{plotMFs,ANFIS-method}},
  \code{\link{plotMFs-methods}}; \code{\link{plot}},
  \code{\link{plot,ANFIS-method}}; \code{\link{predict}},
  \code{\link{predict,ANFIS-method}}; \code{\link{print}},
  \code{\link{print,ANFIS-method}}, \code{\link{show}},
  \code{\link{show,ANFIS-method}}; \code{\link{trainSet}}
}

