% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/BellMF.R
\docType{class}
\name{BellMF-class}
\alias{BellMF}
\alias{BellMF-class}
\title{Bell Membership Function S4 class}
\description{
Represent a concrete Bell shaped Membership Function S4 class with parameters
 a, b, c. Slots inherited of MembershipFunction class and related functions:
 show, print, derivateMF, evaluateMF, [ and [<-.
}
\section{Slots}{

\describe{
\item{\code{parameters}}{named numeric vector with parameters of Membership Function.}

\item{\code{nParameters}}{integer with the number of parameters for validity check.}

\item{\code{name}}{character The description of the membership function.}

\item{\code{expression}}{expression object just to display purposes.}
}}
\note{
derivateMF, evaluateMF are extended. Prototype is defined and validity
is inherited.
}
\examples{
#BellMF example I
#A bell membership function with default prototype (a=1, b=1,c=0)
#The membership of x in the bell, should be 1
#The derivate of the first parameter at x, should be 0
#The derivate of the first parameter at x, should be also 0
bell <- new(Class="BellMF")
bell
evaluateMF(object=bell, x=0)
derivateMF(object=bell, x=0, i=1)
derivateMF(object=bell, x=0, i="a")
#
#BellMF example II
#A bell membership function with parameters (a=4,b=1,c=-10)
#The membership of x in the bell, should be 0.137931
#The derivate of the first parameter at x, should be 0.05945303
#The derivate on "a" at x=0, should be 0.05945303
bell2 <- new(Class="BellMF",parameters=c(a=4,b=1,c=-10))
bell2
evaluateMF(object=bell2, x=0)
derivateMF(object=bell2, x=0, i=1)
derivateMF(object=bell2, x=0, i="a")
}
\author{
Cristobal Fresno \email{cfresno@bdmg.com.ar}, Andrea S. Llera
 \email{ALlera@leloir.org.ar} and Elmer A. Fernandez
 \email{efernandez@bdmg.com.ar}
}
\seealso{
\code{\link{GaussianMF-class}} and
 \code{\link{NormalizedGaussianMF-class}}

Other Membership Functions: \code{\link{GaussianMF}},
  \code{\link{GaussianMF-class}};
  \code{\link{MembershipFunction}},
  \code{\link{MembershipFunction-class}};
  \code{\link{NormalizedGaussianMF}},
  \code{\link{NormalizedGaussianMF-class}};
  \code{\link{[,MembershipFunction-method}},
  \code{\link{[<-,MembershipFunction-method}},
  \code{\link{extract-methods}},
  \code{\link{extract-methods}}; \code{\link{derivateMF}},
  \code{\link{derivateMF}}, \code{\link{derivateMF}},
  \code{\link{derivateMF}}, \code{\link{derivateMF}},
  \code{\link{derivateMF,BellMF-method}},
  \code{\link{derivateMF,GaussianMF-method}},
  \code{\link{derivateMF,MembershipFunction-method}},
  \code{\link{derivateMF,NormalizedGaussianMF-method}},
  \code{\link{derivateMF-methods}};
  \code{\link{evaluateMF}}, \code{\link{evaluateMF}},
  \code{\link{evaluateMF}}, \code{\link{evaluateMF}},
  \code{\link{evaluateMF}},
  \code{\link{evaluateMF,BellMF-method}},
  \code{\link{evaluateMF,GaussianMF-method}},
  \code{\link{evaluateMF,MembershipFunction-method}},
  \code{\link{evaluateMF,NormalizedGaussianMF-method}},
  \code{\link{evaluateMF-methods}};
  \code{\link{print,MembershipFunction-method}};
  \code{\link{show,MembershipFunction-method}}
}

