% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_stream_permutations.R
\name{plot.list_permuted_networks}
\alias{plot.list_permuted_networks}
\title{Function to plot the network metrics distribution of permuted networks}
\usage{
\method{plot}{list_permuted_networks}(
  x,
  species_original_network,
  network_metrics_functions_list = c(edge_density = function(x) igraph::edge_density(x),
    diameter = function(x) igraph::diameter(x, weights = NA), transitivity = function(x)
    igraph::transitivity(x)),
  ...
)
}
\arguments{
\item{x}{A list of igraph objects obtained obtained using the function obtain_permuted_network_versions}

\item{species_original_network}{An igraph object which is the original network}

\item{network_metrics_functions_list}{A list consisting of function definitions of the network metrics that the user wants to evaluate. Each element in the list should have an assigned name.
Default = c("edge_density" = function(x) igraph::edge_density(x), "diameter" = function(x) igraph::diameter(x, weights = NA), "transitivity" = function(x) igraph::transitivity(x))}

\item{...}{Further arguments are ignored.}
}
\value{
No return value, called for side effects.
}
\description{
Function to plot the network metrics distribution of permuted networks
}
\examples{
\donttest{
data(elk_data_2010, elk_network_2010)
permuted_versions <- obtain_permuted_network_versions(elk_data_2010, 
temporal_thresh = 7, spatial_thresh = 15, n_permutations = 10, n_cores = 2)
plot(permuted_versions, elk_network_2010)
}
}
