% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_analysis.R
\name{line_compare}
\alias{line_compare}
\title{Compares moving averages of a variable for two datasets over time, grouped by GPS
GPS, Date, and col columns should match}
\usage{
line_compare(correct, candidate, col, export = FALSE, out = NULL)
}
\arguments{
\item{correct}{reference df}

\item{candidate}{df to be compared to the reference}

\item{col}{variable to plot the moving average for}

\item{export}{logical, whether to export plot, defaults to False}

\item{out}{.png file name to save plot when export is True}
}
\value{
faceted line plot of moving averages over time grouped by GPS
}
\description{
Compares moving averages of a variable for two datasets over time, grouped by GPS
GPS, Date, and col columns should match
}
\examples{
# Faceted line plot comparing moving averages over time 
# grouped by GPS for unfiltered and filtered demo data
## Set distance as the y axis
line_compare(demo_unfiltered, demo_filtered, Distance)
}
