% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{ImageGeneratorSize}
\alias{ImageGeneratorSize}
\title{Tensorflow data generator that resizes images and returns original image size.}
\usage{
ImageGeneratorSize(
  files,
  resize_height = NULL,
  resize_width = NULL,
  pad = FALSE,
  standardize = FALSE,
  batch = 1
)
}
\arguments{
\item{files}{a vector of file names}

\item{resize_height}{the height the cropped image will be resized to. If NULL returns original size images.}

\item{resize_width}{the width the cropped image will be resized to. If NULL returns original size images..}

\item{pad}{pad the image instead of stretching it, TRUE or FALSE.}

\item{standardize}{standardize the image to the range 0 to 1, TRUE or FALSE.}

\item{batch}{the batch size for the image generator.}
}
\value{
A Tensorflow image data generator.
}
\description{
Creates an image data generator that resizes images if requested and also returns the original images size needed for MegaDetector.
}
\examples{
\dontrun{
dataset <- ImageGenerator(images, standardize = FALSE, batch = batch)
}
}
