% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annmatrix.r
\name{annmatrix}
\alias{annmatrix}
\alias{rowanns}
\alias{rowanns<-}
\alias{colanns}
\alias{colanns<-}
\alias{@.annmatrix}
\alias{@<-.annmatrix}
\alias{$.annmatrix}
\alias{$<-.annmatrix}
\title{annmatrix Objects and Basic Functionality}
\usage{
annmatrix(x, rann, cann)

rowanns(x, names)
rowanns(x, names) <- value

colanns(x, names)
colanns(x, names) <- value

\method{@}{annmatrix}(object, name)
\method{@}{annmatrix}(object, name) <- value

\method{$}{annmatrix}(x, name)
\method{$}{annmatrix}(x, name) <- value
}
\arguments{
\item{x, object}{an R object.}

\item{rann}{annotation \code{data.frame} for rows of the \code{annmatrix} object.}

\item{cann}{annotation \code{data.frame} for columns of the \code{annmatrix} object.}

\item{names}{a character vector of existing row/column annotation names.}

\item{value}{a value that will be assigned to row/column annotation field.}

\item{name}{a name of an existing row/column annotation.}
}
\description{
Annotated matrix is a regular matrix with additional functionality for
attaching persistent information about row and column entries. Annotations
associated with rows and columns are preserved after subsetting,
transposition, and various other matrix-specific operations.

Intended 'annmatrix' use case is for storing and manipulating genomic
datasets that typically consist of a matrix of measurements (like gene
expression values) as well as annotations about rows (i.e. genomic
locations) and annotations about columns (i.e. meta-data about collected
samples). But \code{annmatrix} objects are also expected be useful in
various other contexts.
}
\details{
\code{annmatrix()} constructs an annmatrix. The function expects \code{x} to
be a \code{matrix} and \code{rowanns} and \code{colanns} to be of class
\code{data.frame}. If the passed objects are of a different classes they
will be converted via the use of \code{as.matrix} and \code{as.data.frame}.

\code{rowanns} and \code{colanns} returns the selected field from column and
row annotations respectively. When the selected field is not specified the
whole annotation \code{data.frame} is returned.

\code{@} and \code{$} are convenience shortcuts for selecting annotations.
\code{X@value} selects an existing column from row annotations while
\code{X$value} selects a column from column annotations. An empty selection
of \code{X@''} and \code{X$''} will return the whole annotation data.frame
for rows and columns respectively.

\code{rowanns<-} and \code{colanns<-} functions can be used to replace the
column and row annotations respectively. When the selected field is not
specified the whole annotation \code{data.frame} is replaced.

\code{@<-} and \code{$<-} are convenience shortcuts for the above (see
Examples). A replacement of an empty value - \code{X@'' <- df} and
\code{X$'' <- df} will replace the whole annotation data.frame.
}
\examples{
# construct annmatrix object
x <- matrix(rnorm(20*10), 20, 10)

coldata <- data.frame(group  = rep(c("case", "control"), each = 5),
                      gender = sample(c("M", "F"), 10, replace = TRUE))

rowdata <- data.frame(chr = sample(c("chr1", "chr2"), 20, replace = TRUE),
                      pos = runif(20, 0, 1000000))

X <- annmatrix(x, rowdata, coldata)

is.matrix(x)
is.matrix(X)

is.annmatrix(x)
is.annmatrix(X)

# manipulating annotations without using shortcuts
rowanns(X)
colanns(X)

rowanns(X, "chr")
rowanns(X, "gene") <- letters[1:20]
rowanns(X, c("chr", "gene"))
rowanns(X, "gene") <- NULL
rowanns(X)

colanns(X, "group")
colanns(X, "age") <- 1:10*10
colanns(X, "age")
colanns(X, "age") <- NULL
colanns(X, "age")

# more convenient
X@''
X@chr
X@gene <- letters[1:20]
X@gene
X@gene <- NULL
X@gene

X$''
X$group
X$age <- 1:10*10
X$age
X$age <- NULL
X$age
X$'' <- data.frame(id = 1:10, name = LETTERS[1:10])
X$name

# annotations are preserved after subsetting
Y <- X[X@chr == "chr1", X$name \%in\% c("A", "B", "C")]
Y@chr
Y$''

Y[, 1]
Y[, 1, drop = FALSE]

}
\seealso{
\code{as.annmatrix}
}
\author{
Karolis Koncevičius
}
