test_that("download.database", {
  demo.cfg <- system.file("extdata", "demo/demo.cfg", package = "annovarR")
  x <- download.database("download_demo", show.all.versions = T, download.cfg = demo.cfg)
  expect_that(x, equals("demo"))
  database.dir <- sprintf("%s/databases/", tempdir())
  file.remove(sprintf("%s/%s", database.dir, list.files(database.dir, ".*")))
  x <- download.database("download_demo", "demo", buildver = "GRCh37", database.dir = database.dir, 
    download.cfg = demo.cfg)
  expect_that(x, equals(TRUE))
  finalfn <- sprintf("%s/databases/GRCh37_MT_ensGene.txt", tempdir())
  x <- file.exists(finalfn)
  expect_that(x, equals(TRUE))
  x <- file.size(finalfn)
  expect_that(x > 0, equals(TRUE))
  x <- download.database("db_ucsc_refgene", show.all.buildvers = TRUE)
  expect_that(is.character(x), equals(TRUE))
  x <- download.database(show.all.names = TRUE)
  expect_that(is.character(x), equals(TRUE))
  download.cfg <- system.file("extdata", "config/db/db_annovar.toml", package = "BioInstaller")
  x <- get.finished.filename("db_annovar_1000g", "1000g2015aug", "hg19", download.cfg)
  expect_that(x, equals("hg19_ALL.sites.2015_08.txt"))
})
