% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.anomaly_series.R
\name{print.anomaly_series}
\alias{print.anomaly_series}
\title{Print function for anomaly_series objects.}
\usage{
\method{print}{anomaly_series}(x, ...)
}
\arguments{
\item{x}{An anomaly_series object}

\item{...}{Other parameters to be passed to print methods.}
}
\description{
Prints the contents of an anomaly_series object as returned by the \code{\link{anomaly_series}} method.
}
\examples{
library(anomaly)
set.seed(2018)
# Generate data typically following a normal distribution with mean 0 and variance 1. 
# Then introduce 3 anomaly windows and 4 point outliers.
x  = rnorm(5000)
x[401:500]   = rnorm(100,4,1)
x[1601:1800] = rnorm(200,0,0.01)
x[3201:3500] = rnorm(300,0,10)
x[c(1000,2000,3000,4000)] = rnorm(4,0,100)
inferred_anomalies = anomaly_series(x)
print(inferred_anomalies)

}
