/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngineException;

public abstract class REngine {
    protected static REngine lastEngine = null;
    private static Class byte_ARRAY;
    private static Class short_ARRAY;
    private static Class int_ARRAY;
    private static Class long_ARRAY;
    private static Class float_ARRAY;
    private static Class double_ARRAY;
    private static Class boolean_ARRAY;
    private static Class String_ARRAY;
    private static Class Byte_ARRAY;
    private static Class Short_ARRAY;
    private static Class Integer_ARRAY;
    private static Class Long_ARRAY;
    private static Class Float_ARRAY;
    private static Class Double_ARRAY;
    private static Class Boolean_ARRAY;

    public static REngine engineForClass(String string) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        if (clazz == null) {
            throw new ClassNotFoundException("can't find engine class " + string);
        }
        Method method = clazz.getMethod("createEngine", null);
        Object object = method.invoke(null, (Object[])null);
        lastEngine = (REngine)object;
        return lastEngine;
    }

    public static REngine getLastEngine() {
        return lastEngine;
    }

    public abstract REXP parse(String var1, boolean var2) throws REngineException;

    public abstract REXP eval(REXP var1, REXP var2, boolean var3) throws REngineException, REXPMismatchException;

    public abstract void assign(String var1, REXP var2, REXP var3) throws REngineException, REXPMismatchException;

    public abstract REXP get(String var1, REXP var2, boolean var3) throws REngineException, REXPMismatchException;

    public abstract REXP resolveReference(REXP var1) throws REngineException, REXPMismatchException;

    public abstract REXP createReference(REXP var1) throws REngineException, REXPMismatchException;

    public abstract void finalizeReference(REXP var1) throws REngineException, REXPMismatchException;

    public abstract REXP getParentEnvironment(REXP var1, boolean var2) throws REngineException, REXPMismatchException;

    public abstract REXP newEnvironment(REXP var1, boolean var2) throws REngineException, REXPMismatchException;

    public REXP parseAndEval(String string, REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        REXP rEXP2 = this.parse(string, false);
        return this.eval(rEXP2, rEXP, bl);
    }

    public REXP parseAndEval(String string) throws REngineException, REXPMismatchException {
        return this.parseAndEval(string, null, true);
    }

    public boolean close() {
        return false;
    }

    public boolean supportsReferences() {
        return false;
    }

    public boolean supportsEnvironemnts() {
        return false;
    }

    public boolean supportsREPL() {
        return false;
    }

    public boolean supportsLocking() {
        return false;
    }

    public void assign(String string, double[] dArray) throws REngineException {
        try {
            this.assign(string, new REXPDouble(dArray), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,double[]): " + rEXPMismatchException);
        }
    }

    public void assign(String string, int[] nArray) throws REngineException {
        try {
            this.assign(string, new REXPInteger(nArray), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,int[]): " + rEXPMismatchException);
        }
    }

    public void assign(String string, String[] stringArray) throws REngineException {
        try {
            this.assign(string, new REXPString(stringArray), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,String[]): " + rEXPMismatchException);
        }
    }

    public void assign(String string, byte[] byArray) throws REngineException {
        try {
            this.assign(string, new REXPRaw(byArray), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,byte[]): " + rEXPMismatchException);
        }
    }

    public void assign(String string, String string2) throws REngineException {
        try {
            this.assign(string, new REXPString(string2), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,String[]): " + rEXPMismatchException);
        }
    }

    public void assign(String string, REXP rEXP) throws REngineException, REXPMismatchException {
        this.assign(string, rEXP, null);
    }

    public synchronized int tryLock() {
        return 0;
    }

    public synchronized int lock() {
        return 0;
    }

    public synchronized void unlock(int n) {
    }

    public String toString() {
        return super.toString() + (lastEngine == this ? "{last}" : "");
    }

    public REXP wrap(Object object) {
        Class<?> clazz = object.getClass();
        if (object instanceof REXP) {
            return (REXP)object;
        }
        if (clazz == Byte.class) {
            byte[] byArray = new byte[]{(Byte)object};
            return new REXPRaw(byArray);
        }
        if (clazz == Short.class) {
            return new REXPInteger(((Short)object).intValue());
        }
        if (clazz == Integer.class) {
            return new REXPInteger((Integer)object);
        }
        if (clazz == Long.class) {
            return new REXPInteger(((Long)object).intValue());
        }
        if (clazz == Float.class) {
            return new REXPDouble(((Float)object).doubleValue());
        }
        if (clazz == Double.class) {
            return new REXPDouble((Double)object);
        }
        if (clazz == Boolean.class) {
            return new REXPLogical((Boolean)object);
        }
        if (clazz == String.class) {
            return new REXPString((String)object);
        }
        if (clazz == String_ARRAY) {
            return new REXPString((String[])object);
        }
        if (clazz == byte_ARRAY) {
            return new REXPRaw((byte[])object);
        }
        if (clazz == Byte_ARRAY) {
            Byte[] byteArray = (Byte[])object;
            int n = byteArray.length;
            byte[] byArray = new byte[byteArray.length];
            for (int i = 0; i < n; ++i) {
                byArray[i] = byteArray[i];
            }
            return new REXPRaw(byArray);
        }
        if (clazz == short_ARRAY) {
            short[] sArray = (short[])object;
            int[] nArray = new int[sArray.length];
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                nArray[i] = sArray[i];
            }
            return new REXPInteger(nArray);
        }
        if (clazz == Short_ARRAY) {
            Short[] shortArray = (Short[])object;
            int n = shortArray.length;
            int[] nArray = new int[shortArray.length];
            for (int i = 0; i < n; ++i) {
                nArray[i] = shortArray[i].intValue();
            }
            return new REXPInteger(nArray);
        }
        if (clazz == int_ARRAY) {
            return new REXPInteger((int[])object);
        }
        if (clazz == Integer_ARRAY) {
            Integer[] integerArray = (Integer[])object;
            int n = integerArray.length;
            int[] nArray = new int[integerArray.length];
            for (int i = 0; i < n; ++i) {
                nArray[i] = integerArray[i];
            }
            return new REXPInteger(nArray);
        }
        if (clazz == long_ARRAY) {
            long[] lArray = (long[])object;
            int n = lArray.length;
            int[] nArray = new int[lArray.length];
            for (int i = 0; i < n; ++i) {
                nArray[i] = (int)lArray[i];
            }
            return new REXPInteger(nArray);
        }
        if (clazz == Integer_ARRAY) {
            Long[] longArray = (Long[])object;
            int n = longArray.length;
            int[] nArray = new int[longArray.length];
            for (int i = 0; i < n; ++i) {
                nArray[i] = longArray[i].intValue();
            }
            return new REXPInteger(nArray);
        }
        if (clazz == float_ARRAY) {
            float[] fArray = (float[])object;
            int n = fArray.length;
            double[] dArray = new double[fArray.length];
            for (int i = 0; i < n; ++i) {
                dArray[i] = fArray[i];
            }
            return new REXPDouble(dArray);
        }
        if (clazz == Integer_ARRAY) {
            Float[] floatArray = (Float[])object;
            int n = floatArray.length;
            double[] dArray = new double[floatArray.length];
            for (int i = 0; i < n; ++i) {
                dArray[i] = floatArray[i].doubleValue();
            }
            return new REXPDouble(dArray);
        }
        if (clazz == double_ARRAY) {
            return new REXPDouble((double[])object);
        }
        if (clazz == Double_ARRAY) {
            Double[] doubleArray = (Double[])object;
            double d = doubleArray.length;
            double[] dArray = new double[doubleArray.length];
            int n = 0;
            while ((double)n < d) {
                dArray[n] = doubleArray[n];
                ++n;
            }
            return new REXPDouble(dArray);
        }
        if (clazz == boolean_ARRAY) {
            return new REXPLogical((boolean[])object);
        }
        if (clazz == Boolean_ARRAY) {
            Boolean[] booleanArray = (Boolean[])object;
            int n = booleanArray.length;
            boolean[] blArray = new boolean[booleanArray.length];
            for (int i = 0; i < n; ++i) {
                blArray[i] = booleanArray[i];
            }
            return new REXPLogical(blArray);
        }
        return null;
    }

    static {
        try {
            byte_ARRAY = Class.forName("[B");
            short_ARRAY = Class.forName("[S");
            int_ARRAY = Class.forName("[I");
            long_ARRAY = Class.forName("[L");
            float_ARRAY = Class.forName("[F");
            double_ARRAY = Class.forName("[D");
            boolean_ARRAY = Class.forName("[Z");
            String_ARRAY = Class.forName("[Ljava.lang.String;");
            Byte_ARRAY = Class.forName("[Ljava.lang.Byte;");
            Short_ARRAY = Class.forName("[Ljava.lang.Short;");
            Integer_ARRAY = Class.forName("[Ljava.lang.Integer;");
            Long_ARRAY = Class.forName("[Ljava.lang.Long;");
            Float_ARRAY = Class.forName("[Ljava.lang.Float;");
            Double_ARRAY = Class.forName("[Ljava.lang.Double;");
            Boolean_ARRAY = Class.forName("[Ljava.lang.Boolean;");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

