% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showAliases.R
\name{showAliases}
\alias{showAliases}
\alias{setAlias}
\title{show aliases for variables}
\usage{
showAliases(names = NULL)

setAlias(name, desc, select)
}
\arguments{
\item{names}{optional vector of alias names. If provided, the full list of 
columns selected by these aliases is displayed. Else only the name and a 
short description of all aliases is displayed.}

\item{name}{Alias name}

\item{desc}{Short description indicating why the new alias is interesting}

\item{select}{character vector containing columns and/or types of data to 
import.}
}
\value{
\code{setAlias} is only used for its side effects. A data.frame with columns 
'name', 'desc' and 'select'. \code{showAliases} invisibly returns a 
data.frame with columns "name", "desc" and "select".
}
\description{
Aliases are short names that can be used in the \code{select} parameter in 
function \code{\link{readAntares}} to tell the function which columns and/or
type of data to import. 

\code{setAlias} can be used to create a new alias. It can be especially
useful for package developers to help their users select the data required
by their packages.

\code{showAliases} lists available aliases
}
\examples{

# Display the short description of an alias
showAliases()

# Display the full description of an alias
showAliases("renewable")

\dontrun{
# Create a new alias that imports flows
setAlias("test", "short description", c("links", "FLOW LIN.")) 
showAliases()
}

}
